# Copyright 2014, Scalyr, Inc.
#
# An example ScalyrMonitor plugin to demonstrate how they can be written.
#
# Note, this can be run in standalone mode by:
#     python -m scalyr_agent.run_monitor scalyr_agent.builtin_monitors.test_monitor

import random

from scalyr_agent.scalyr_monitor import ScalyrMonitor


class RandomMonitor(ScalyrMonitor):
    """A Scalyr agent monitor that records random numbers.
    """
    def _initialize(self):
        """Performs monitor-specific initialization.
        """
        # TODO:  Is it better to have this, or just require that classes override __init__ and do their
        # initialization that way.  If we do that, then they must know the argument list for __init__.

        # Useful instance variables:
        #   _sample_interval_secs:  The number of seconds between calls to gather_sample.
        #   _config:  The MonitorConfig object containing the configuration for this monitor instance as retrieved
        #             from configuration file.  It is essentially like a dict but has some methods for validating
        #             field values.
        #   _logger:  The logger instance to report errors/warnings/etc.
        #   log_config: The dict containing the configuration for how the metric log created by the
        #               this module should be saved.  It uses the same fields as the entries in agent.json's
        #               "logs" section.  You can set the path for the log file, as well as the attributes
        #               such as the parser, etc.
        self.__counter = 0
        self.__gauss_mean = self._config.get('gauss_mean', default=0.5, required_field=False, convert_to=float,
                                             min_allowed_value=0, max_allowed_value=10)
        self.__gauss_stddev = self._config.get('gauss_stddev', default=0.25, convert_to=float,
                                               min_allowed_value=0, max_allowed_value=5)

    def gather_sample(self):
        """Invoked once per sample interval to gather a statistic.
        """
        self.__counter += 1
        # Be sure to use emit_values to record the statistics the monitor wishes to send to Scalyr.
        self._logger.emit_value('uniform', random.random(), extra_fields={'count': self.__counter})
        self._logger.emit_value('gauss', random.gauss(self.__gauss_mean, self.__gauss_stddev),
                                extra_fields={'count': self.__counter})
