from setuptools import setup, find_packages


def description():
    """Return description in Restructure Text format."""

    with open('description.rst') as f:
        return f.read()


setup(name='pyclowder',
      version='2.4.1',
      packages=find_packages(),
      description='Python SDK for the Clowder Data Management System',
      long_description=description(),
      author='Rob Kooper',
      author_email='kooper@illinois.edu',

      url='https://clowderframework.org',
      project_urls={
        'Source': 'https://github.com/clowder-framework/pyclowder',
      },

      license='BSD',
      classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: BSD License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 3'
      ],
      keywords=['clowder', 'data management system'],

      install_requires=[
          'enum34==1.1.10',
          'pika==1.2.0',
          'PyYAML==5.4.1',
          'requests==2.26.0',
          'requests-toolbelt==0.9.1',
      ],

      include_package_data=True,
      zip_safe=True,
      )
