# Configurable options:
resolution_selection = 'C'

# Constants

RES_SCALE_DICT = {
    'A': ((1920, 1080), 1),
    'B': ((1200, 800), 75 / 100),
    'C': ((1600, 900), 83 / 100),
    'D': ((960, 540), 50 / 100),
    'E': ((1280, 720), 69 / 100)
}

FRAME_RATE = 60
RESOLUTION, PROTOTYPE_SCALE = RES_SCALE_DICT[resolution_selection]
SPACING = 3
FULLSCREEN = False
SCALE = 5 / 16
HEX_SIZE = 600 * SCALE * PROTOTYPE_SCALE
ACTION_SIZE = (int(70 * PROTOTYPE_SCALE), int(98 * PROTOTYPE_SCALE))
CARD_SIZE = (int(70 * PROTOTYPE_SCALE), int(98 * PROTOTYPE_SCALE))
WINDOW_CENTER = (RESOLUTION[0] / 2, RESOLUTION[1] / 2)

INFO_WIDTH = 6 * ACTION_SIZE[0] + 7 * SPACING
BANK_HEIGHT = 100  # todo scale this
BANK_CARD_WIDTH = (INFO_WIDTH - 8 * SPACING - BANK_HEIGHT) / 6
BANK_HALF_HEIGHT = (BANK_HEIGHT - 3 * SPACING) / 2
PLAYER_HEIGHT = int(4 * 6 / 5 * ACTION_SIZE[0])
PLAYER_SECTION_WIDTH = int((INFO_WIDTH - 4 * SPACING) / 5)
PLAYER_QUARTER_HEIGHT = int((PLAYER_HEIGHT - 2 * SPACING) / 4)

# SCALE = 5 / 16
# HEX_SIZE = 600 * SCALE
# WINDOW_CENTER = (RESOLUTION[0] / 2, RESOLUTION[1] / 2)
