# Generated by Django 2.2.17 on 2022-02-25 15:10

from django.db import connections, migrations


def create_user_files_index(apps, schema_editor):
    # Create an index on file_path column
    # Note: on MySQL/MariaDB, create the index on the first 255 characters of file_path
    if connections.databases[schema_editor.connection.alias]['ENGINE'] == 'django.db.backends.mysql':
        in_atomic_block = schema_editor.connection.in_atomic_block
        schema_editor.connection.in_atomic_block = False
        try:
            schema_editor.execute('''
    create index index_airavata_django_portal_sdk_userfiles_file_path on airavata_django_portal_sdk_userfiles (file_path(255));
            ''')
        finally:
            schema_editor.connection.in_atomic_block = in_atomic_block
    else:
        schema_editor.execute('''
create index index_airavata_django_portal_sdk_userfiles_file_path on airavata_django_portal_sdk_userfiles (file_path);
        ''')


def drop_user_files_index(apps, schema_editor):
    if connections.databases[schema_editor.connection.alias]['ENGINE'] == 'django.db.backends.mysql':
        in_atomic_block = schema_editor.connection.in_atomic_block
        schema_editor.connection.in_atomic_block = False
        try:
            schema_editor.execute('''
    drop index index_airavata_django_portal_sdk_userfiles_file_path on airavata_django_portal_sdk_userfiles;
            ''')
        finally:
            schema_editor.connection.in_atomic_block = in_atomic_block
    else:
        schema_editor.execute('''
drop index index_airavata_django_portal_sdk_userfiles_file_path on airavata_django_portal_sdk_userfiles;
        ''')


class Migration(migrations.Migration):

    dependencies = [
        ('airavata_django_portal_sdk', '0002_userfiles_file_resource_id'),
    ]

    operations = [
        migrations.RunPython(create_user_files_index, drop_user_files_index)
    ]
