"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../lib");
/// !show
// Pick the right Amazon Linux edition. All arguments shown are optional
// and will default to these values when omitted.
const amznLinux = ec2.MachineImage.latestAmazonLinux({
    generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX,
    edition: ec2.AmazonLinuxEdition.STANDARD,
    virtualization: ec2.AmazonLinuxVirt.HVM,
    storage: ec2.AmazonLinuxStorage.GENERAL_PURPOSE,
});
// Pick a Windows edition to use
const windows = ec2.MachineImage.latestWindows(ec2.WindowsVersion.WINDOWS_SERVER_2019_ENGLISH_FULL_BASE);
// Look up the most recent image matching a set of AMI filters.
// In this case, look up the NAT instance AMI, by using a wildcard
// in the 'name' field:
const natAmi = ec2.MachineImage.lookup({
    name: 'amzn-ami-vpc-nat-*',
    owners: ['amazon'],
});
// For other custom (Linux) images, instantiate a `GenericLinuxImage` with
// a map giving the AMI to in for each region:
const linux = ec2.MachineImage.genericLinux({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
// For other custom (Windows) images, instantiate a `GenericWindowsImage` with
// a map giving the AMI to in for each region:
const genericWindows = ec2.MachineImage.genericWindows({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
/// !hide
Array.isArray(windows);
Array.isArray(amznLinux);
Array.isArray(linux);
Array.isArray(genericWindows);
Array.isArray(natAmi);
//# sourceMappingURL=data:application/json;base64,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