% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{empirical_process_lil_bound}
\alias{empirical_process_lil_bound}
\title{Empirical process finite LIL bound.}
\usage{
empirical_process_lil_bound(t, alpha, t_min, A = 0.85)
}
\arguments{
\item{t}{number of samples observed}

\item{alpha}{error / crossing probability of the boundary}

\item{t_min}{first time at which boundary is valid}

\item{A}{leading constant in the bound}
}
\description{
Based on Theorem 2 of the quantile paper. Bound has the form `A
sqrt((loglog(et / t_min) + C) / t)`, and is valid only for t >= t_min. C is
chosen to achieve the desired error probability `alpha`.
}
\details{
This bound controls the deviations of the empirical CDF from the true CDF
uniformly over x and time, or yields a confidence sequences uniform over
quantiles and time (Corollary 2 of the quantile paper).
}
\examples{
empirical_process_lil_bound(1000, .05, 100)
}
