% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{beta_binomial_log_mixture}
\alias{beta_binomial_log_mixture}
\title{Logarithm of mixture supermartingale for the beta-binomial mixture.}
\usage{
beta_binomial_log_mixture(s, v, v_opt, g, h, alpha_opt = 0.05,
  is_one_sided = TRUE)
}
\arguments{
\item{s}{value of the underlying martingale}

\item{v}{intrinsic time value}

\item{v_opt}{intrinsic time value for which the corresponding boundary is
optimized}

\item{g}{lower sub-Bernoulli range parameter}

\item{h}{upper sub-Bernoulli range parameter}

\item{alpha_opt}{alpha for which the corresponding boundary is optimized}

\item{is_one_sided}{if FALSE, use the two-sided beta-binomial mixture}
}
\description{
Logarithm of mixture supermartingale for the beta-binomial mixture.
}
\examples{
beta_binomial_log_mixture(c(10, 20), c(100, 400), 100, .2, .8)
}
