

from math import log
from windnet import IPTool

facebook_address = '''31.13.24.031.13.31.255
69.63.176.069.63.191.255
103.4.96.0103.4.99.255
163.77.128.0163.77.255.255
185.89.218.0185.89.219.255
102.132.112.0102.132.122.255
129.134.135.0129.134.140.255
129.134.163.0129.134.165.255
157.240.158.0157.240.160.255
31.13.64.031.13.127.255
69.171.224.069.171.255.255
129.134.0.0129.134.255.255
173.252.64.0173.252.127.255
204.15.20.0204.15.23.255
102.132.124.0102.132.127.255
129.134.143.0129.134.144.255
129.134.168.0129.134.173.255
157.240.169.0157.240.169.255
45.64.40.045.64.43.255
74.119.76.074.119.79.255
157.240.0.0157.240.255.255
179.60.192.0179.60.195.255
163.114.128.0163.114.143.255
102.221.188.0102.221.191.255
129.134.147.0129.134.150.255
157.240.128.0157.240.128.255
157.240.172.0157.240.181.255
66.220.144.066.220.159.255
102.132.96.0102.132.111.255
163.70.128.0163.70.255.255
185.60.216.0185.60.219.255
199.201.64.0199.201.67.255
129.134.128.0129.134.132.255
129.134.154.0129.134.161.255
157.240.155.0157.240.156.255
164.163.191.64164.163.191.127'''

google_address = '''35.190.247.0/24,35.191.0.0/16,64.233.160.0/19,66.102.0.0/20,66.249.80.0/20,72.14.192.0/18,74.125.0.0/16,108.177.8.0/21,130.211.0.0/22,142.250.4.0/24,142.251.42.0/23,172.217.32.0/20,172.217.128.0/19,172.217.160.0/20,172.217.0.0/19,172.217.192.0/19,172.253.56.0/21,172.253.112.0/20,108.177.96.0/19,173.194.0.0/16,209.85.128.0/17,216.58.192.0/19,216.239.32.0/19,192.0.6.0/24,199.59.0.0/16,31.13.87.0/24,8.8.8.8/32,142.251.8.0/19,128.121.243.0/24'''
github_address = '''
192.30.252.0/22,185.199.108.0/22,140.82.112.0/20,
143.55.64.0/20,
13.114.40.48/32,
52.192.72.89/32,
52.69.186.44/32,
15.164.81.167/32,
52.78.231.108/32,
13.234.176.102/32,
13.234.210.38/32,
13.236.229.21/32,
13.237.44.5/32,
52.64.108.95/32,
20.201.28.151/32,
20.205.243.166/32,
102.133.202.242/32'''

def main2():
    ipsegs = github_address.split(",")
    ip_segments = []
    for ipseg in ipsegs:
        ip_segments.append(IPTool.get_ip_mask(ipseg))
    print("github dedup")
    deduped = IPTool.dedup(ip_segments)
    deduped_str = [IPTool.int2ip(x[0])+"/"+str(x[1]) for x in deduped]
    print(",".join(deduped_str))

def main():
    ipsegs = facebook_address.split("\n")
    ip_segments = []
    for ipseg in ipsegs:
        if not ipseg:
            continue
        index=  ipseg.index(ipseg[:3],3)
        start = ipseg[:index]
        end = ipseg[index:]
        i_start = IPTool.ip2int(start)
        i_end = IPTool.ip2int(end)
        
        # mask = log(i_end-i_start+1,2)
        ip_segments.extend(IPTool.get_ip_segments(i_start,i_end))

        # print(i_end-i_start+1,ip_segments)
    for ip_seg in ip_segments:
        
        print(IPTool.int2ip(ip_seg[0])+"/"+str(ip_seg[1]))
        # print(start+"/"+str(int(32-mask)))
    print("facebook dedup")
    deduped = IPTool.dedup(ip_segments)
    deduped_str = [IPTool.int2ip(x[0])+"/"+str(x[1]) for x in deduped]
    print(",".join(deduped_str))

    
if __name__ == "__main__":
    print(IPTool.get_ip_segments(0,1023))
    print(IPTool.get_ip_segments(1,1024))
    main()
    main2()
