#!/usr/bin/env python3

import json
import subprocess
import sys
import os

if len(sys.argv) != 2:
    print(f"Usage: {sys.argv[0]} /path/to/Caddyfile")
    sys.exit(1)

caddyfile_path = sys.argv[1]

if not os.path.exists(caddyfile_path):
    print(f"Error: Caddyfile not found at {caddyfile_path}")
    sys.exit(1)

# Get current Caddy config
current_config = json.loads(
    subprocess.run(
        ["curl", "http://localhost:2019/config/apps/http/servers/srv0"],
        capture_output=True,
        text=True,
    ).stdout.strip()
)

# Keep all Fujin-managed routes (ones with a group property)
existing_routes = current_config.get("routes", [])
fujin_routes = [r for r in existing_routes if r.get("group")]

# Convert Caddyfile to JSON
routes = json.loads(
    subprocess.run(
        ["caddy", "adapt", "--config", caddyfile_path],
        capture_output=True,
        text=True,
    ).stdout
)

# Extract new routes
new_routes = (
    routes.get("apps", {})
    .get("http", {})
    .get("servers", {})
    .get("srv0", {})
    .get("routes", [])
)

# Merge routes and apply
fujin_routes.extend(new_routes)
current_config["routes"] = fujin_routes

subprocess.run(
    [
        "curl",
        "localhost:2019/config/apps/http/servers/srv0",
        "-H",
        "Content-Type: application/json",
        "-d",
        json.dumps(current_config),
    ]
)

print("Configuration applied successfully!")