#! /bin/sed -nf

# make-targets
#
# tries to catch all targets on a Makefile
#
# the purpose of this is to be used on the complete [make] feature
# of tcsh... so it should be simple and fast
#
# this is not a shell script, exactly for that reason... hopefully
# the kernel will interpret this executable as a sed script and
# feed it directly to it
#
# the name of the makefile, unfortunelly, must be hard coded on the
# complete code, and it is "Makefile"

# take care of \ ended lines
:n
/\\$/{
        N
        s/\\\n//
        bn
}

y/	/ /

# delete all comments
/^ *#/d
s/[^\\]#.*$//

# register variables, the only ones in here are the ones of form
#
#       VAR = one_word_def
#
# in that way, most vars will be skipped, and things like
#
#       SED_TARGET = sed
#
# will still work
#

/\([A-Za-z_0-9-]\+\) *= *\([A-Za-z_0-9./-]\+\) *$/{

        s/ //g
        s/$/ /
        H
        b
}

# now, perform the substitution

/\$[({][A-Za-z_0-9-]\+[)}]/{

        s/$/##/
        G
        s/\(\$[{(]\)\([A-Za-z_0-9-]\+\)\([)}]\)\(.*\)##.*\2=\([A-Za-z_0-9./-]\+\).*/\5\4/g
}

# finally, print the targets

tt
:t
s/^\([A-Za-z_0-9./-]\+\)\(\( \+[A-Za-z_0-9./-]\+\)*\) *:\([^=].*\)\?$/\1\2/
tx

d

# now, this a final selection of targets to be print
# kind of 'prog | grep -v ...'

# don't print *.[hco] targets cause in most cases that makes very long output
:x
/\.[och]$/!p
