#!/bin/sed -f
# justify.sed - Aurelio Jargas <verde (a) aurelio net>
#
# It  gets  a text already wrapped on the desired number of columns
# and  add  extra  white  spaces, from left to right, word by word,
# to  justify  all  the lines. There is a maximum of 5 spaces to be
# inserted  between  the  words. If this limit is reached, the line
# is  not  justified  (come  on,  more  than  5 is horrible). Empty
# lines  are  ignored.  BTW, this comments were justified with this
# script &:)
#
# 2000-07-15 1st release
# 2000-07-22 code cleaned

# cleaning extra spaces of the line
s/ \+/ /g
s/^ //
s/ $//

# we'll only justify lines with less than 65 chars
/^.\{65\}/b

# backup of the 'stripped' line
h

# spaces -> pattern
# convert series of spaces to a internal pattern `n
:s2p
s/     /`5/g
s/    /`4/g
s/   /`3/g
s/  /`2/g
s/ /`1/g
t 1space
b

# pattern -> spaces
# restore the spaces converted to the internal pattern `n
:p2s
s/`5/     /g
s/`4/    /g
s/`3/   /g
s/`2/  /g
s/`1/ /g
t check
b

# check if we've reached our right limit
# if not, continue adding spaces
:check
/^.\{65\}/!b s2p
b

# here's the "magic":
# add 1 space to the first and minor internal pattern found.
# this way, the extra spaces are always added from left to right,
# always balanced, one by one.
# right after the substitution, we'll restore the spaces and
# test if our limit was reached.
:1space
s/`1/`2/ ; t p2s
s/`2/`3/ ; t p2s
s/`3/`4/ ; t p2s
s/`4/`5/ ; t p2s

# we don't want to justify with more than 5 added spaces between
# words, so let's restore the original line
/`5/x
