#! /bin/sed -nf
# filename:  italbold.sed
#   author:  Eric Pement - pemente@northpark.edu
#	     modified by Paolo Bonzini to remove GNU sed 3.02.80 features
#	     and to show how to use `w' to output to stderr.
#     date:  January 7, 2001
#
# purpose:
#     To take input files with two different "toggle switches" such as
# the _underscore_ and *asterisk*, and convert them into something like
# <i>italic</i> and <b>boldface</b> in the output.
#
#     In this script, I've used HTML to illustrate the procedure, but
# the script can be altered to change the toggle switches, the output
# (maybe printer codes?), or both. Note especially my use of the hold
# space to maintain "state". If "I" appears anywhere in the hold
# space, Italic is currently ON and the next match of "_" should turn
# it off. If "I" is not present in the hold space, it means Italic is
# currently OFF, and the next match of an underscore should turn it
# back ON. A similar principle is used with the Bold flag, using "B"
# to indicate that Boldface is currently ON and no "B" to mean OFF.
#
# ERROR HANDLING:
#    This script contains an error-checking routine on lines 64-82, to
# check for unmatched toggle switches. It writes to standard output,
# which may make this script unsuitable for some applications. Sed has
# no way to write to stderr. If you don't like this routine, delete all
# the commands after line 63.
#
# Copyleft 2000 by Eric Pement. This file may be freely distributed.
# Copyleft terms at http://www.dsl.org/copyleft/non-software-copyleft.shtml
# For more help with sed, see http://www.faqs.org/faqs/editor-faq/sed
#
: ital
/_/ { x
      /I/{
        # An underscore is found, and "Italic ON" (I) was in the former
        # hold space.  Delete the flag, turn the next "_" into HTML "</i>"
        # code, and return to the top to find more underscores.
        s/I//
        x
        s|_|</i>|
        b ital
      }
      # Else turn the "I" flag ON, insert <i> and go above.
      s/^/I/
      x
      s|_|<i>|
      b ital
}

# Now do the same with B and asterisks
: bold
/\*/ { x
      /B/{
        s/B//
        x
        s|\*|</b>|
        b bold
      }
      s/^/B/
      x
      s|\*|<b>|
      b bold
}

p
$!b

# Error-checking routine
g
/./ {
   s/^/>>\
    +==============================================+\
    |                                              |\
    |  ERROR!!                                     |/
   s/I/\
    |  Italic was turned ON but never turned OFF!  |/
   s/B/\
    |  Bold was turned ON but never turned OFF!    |/
   s/$/\
    |                                              |\
    +==============================================+/
   
   # If /proc is supported, `w /proc/self/fd/2' writes to stderr
   # For portability, we just use p
   p
}
#----end of script----
