#!/bin/sed -f
#  Sort, partition, and number a list of names in only 14 sed commands.
#  By Greg Ubben, 14 Nov 1996
#
#  Use with -n option to prevent a trailing blank line.
#  Assumes no control characters, even though the sort handles tabs.

#  Sed insertion sort by Greg Ubben, 26 April 1989.  All rights reserved.
#  Note that the code contains some unprintable Ctrl-A and Tab characters.
#  The \(\(.\)\) have been unnested to allow for some brain-damaged seds.
#  Some overlap with next; s:/:/.: the last command for a stand-alone sort.

# Greg's e-mail note to seders list:
#   The code contains a few control characters, so I've included a
#   "readable" version immediately below with the Ctrl-A's and Tabs
#   changed to ^As and ^Is, followed by a uuencoded copy that you can use
#   if you want to run it.

# see .readme.txt for the modifications applied to be used in testing sed.py.
# Gilles Arcas

G
1s/\n/&&	 !"#$%\&'()*+,-.\/0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~/
s/\([	 -~]*\)\(\n\)/\2\1/
s/^\(.[	 -~]*\)\([	 -~]\)\([	 -~]*\)\(.*\1\)\([	 -~]\)\([	 -~]*\)\(.*\n.*\5[	 -~]*\2[ -~]*\)$/\4\5\6\1\2\3\7/
h
$!d
s///g
s/\(.*\)\n.*/\1/

#  Output, adding a blank line between sections and numbering each section.
#  The do-nothing X* below is needed on the SunOS 4.1 sed to work around a
#  RE bug that occurs when a non-null c* closure precedes a null \n recall.

: loop
	s/\([0-9]*\)[ -~]*\n/\1;9876543210990090 /
	s/\([0-8]\{0,1\}\)\(9*\);[^1]*\(.\)\1[0-9]*X*\2\(0*\)[^ ]*/\3\4/
	P
	/^[0-9]* \(.\).*\n\1/ !s/[ -~]*//
	/^\n/P
/./b loop



# begin 755 impossible.sed
# M(R$O8FEN+W-E9" M9@HC("!3;W)T+"!P87)T:71I;VXL(&%N9"!N=6UB97(@
# M82!L:7-T(&]F(&YA;65S(&EN(&]N;'D@,30@<V5D(&-O;6UA;F1S+@HC("!"
# M>2!'<F5G(%5B8F5N+" Q-"!.;W8@,3DY-@HC"B,@(%5S92!W:71H("UN(&]P
# M=&EO;B!T;R!P<F5V96YT(&$@=')A:6QI;F<@8FQA;FL@;&EN92X*(R @07-S
# M=6UE<R!N;R!C;VYT<F]L(&-H87)A8W1E<G,L(&5V96X@=&AO=6=H('1H92!S
# M;W)T(&AA;F1L97,@=&%B<RX*"B,@(%-E9"!I;G-E<G1I;VX@<V]R="!B>2!'
# M<F5G(%5B8F5N+" R-B!!<')I;" Q.3@Y+B @06QL(')I9VAT<R!R97-E<G9E
# M9"X*(R @3F]T92!T:&%T('1H92!C;V1E(&-O;G1A:6YS('-O;64@=6YP<FEN
# M=&%B;&4@0W1R;"U!(&%N9"!486(@8VAA<F%C=&5R<RX*(R @5&AE(%PH7"@N
# M7"E<*2!H879E(&)E96X@=6YN97-T960@=&\@86QL;W<@9F]R('-O;64@8G)A
# M:6XM9&%M86=E9"!S961S+@HC("!3;VUE(&]V97)L87 @=VET:"!N97AT.R!S
# M.B\Z+RXZ('1H92!L87-T(&-O;6UA;F0@9F]R(&$@<W1A;F0M86QO;F4@<V]R
# M="X*1PHQ<R]<;B\F)@$)("$B(R0E7"8G*"DJ*RPM+EPO,#$R,S0U-C<X.3H[
# M/#T^/T!!0D-$149'2$E*2TQ-3D]045)35%565UA96EM<7%U>7V!A8F-D969G
# M:&EJ:VQM;F]P<7)S='5V=WAY>GM\?7XO"G,O7"A;"2 M?ETJ7"E<*%QN7"DO
# M7#)<,0$O"G,O7EPH+EL)("U^72I<*5PH6PD@+7Y=7"E<*%L!"2 M?ETJ7"E<
# M*"XJ7#%<*5PH6P$)("U^75PI7"A; 0D@+7Y=*EPI7"@N*EQN+BI<-5L)("U^
# M72I<,EL@+7Y=*EPI)"]<-%PU7#9<,5PR7#-<-R\*: HD(60*<R\!+R]G"G,O
# M7"@N*EPI7&XN*B]<,2\*"B,@($]U='!U="P@861D:6YG(&$@8FQA;FL@;&EN
# M92!B971W965N('-E8W1I;VYS(&%N9"!N=6UB97)I;F<@96%C:"!S96-T:6]N
# M+@HC("!4:&4@9&\M;F]T:&EN9R!8*B!B96QO=R!I<R!N965D960@;VX@=&AE
# M(%-U;D]3(#0N,2!S960@=&\@=V]R:R!A<F]U;F0@80HC("!212!B=6<@=&AA
# M="!O8V-U<G,@=VAE;B!A(&YO;BUN=6QL(&,J(&-L;W-U<F4@<')E8V5D97,@
# M82!N=6QL(%QN(')E8V%L;"X*"CH@;&]O< H)<R]<*%LP+3E=*EPI6R M?ETJ
# M7&XO7#$[.3@W-C4T,S(Q,#DY,# Y," O"@ES+UPH6S M.%U<>S L,5Q]7"E<
# M*#DJ7"D[6UXQ72I<*"Y<*5PQ6S M.5TJ6"I<,EPH,"I<*5M>(%TJ+UPS7#0O
# M"@E0"@DO7ELP+3E=*B!<*"Y<*2XJ7&Y<,2\@(7,O6R M?ETJ+R\*"2]>7&XO
# ,4 HO+B]B(&QO;W *
#  
# end
