#! /bin/sed -f

# usage: find path -print | fdirname
#
# fdirname acts like dirname, but read files from stdin

# print the directory component of a path

# special case: `/' is given
/^\/$/c\
/

# strip trailing `/'s if any
s/\/*$//
# strip trailing filename
s/[^/]*$//

# if get no chars after these, then we have current dir (things like
# `bin/ src/' were given
/./!c\
.

# delete the trailing `/'
# ("/usr/bin/ls" --> "/usr/bin/", this makes "/usr/bin")
s/\/$//
