#! /bin/sed -f

# Put a space in front to simplify treatment of the first word
s/^/ /

:loop
/[ 	][a-z]/ {
  # Get the letter to be changed and construct <letter><before>\n<after>
  s/^\(.*[ 	]\)\([a-z]\)\(.*\)$/\2\1\
\3/
  h

  # Capitalize the first letter of pattern space, remove the rest of it
  s/^\(.\).*/\1/
  y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/
  G

  # Pattern space is now <new>\n<old><before>\n<after>; construct
  # <before><new><after> and loop back (<after> is not matched by the RE)
  s/^\(.\)\n.\(.*\)\n/\2\1/
  b loop
}

# Remove the space we had added
s/^.//
