#! /bin/sed -f
# center all lines of a file, on a 80 columns width
#
# to change that width, the number in \{\} must be replaced to w+1, and
# the number of added spaces also must be changed
#

1 {
  # Prepare 80 spaces in the buffer
  x
  s/^$/          /
  s/^ *$/&&&&&&&&/
  x
}

# del leading and trailing spaces
y/	/ /
s/^ *//
s/ *$//

# add a new-line and 80 spaces to end of line
G

# keep 1st 81 chars (80 + new-line)
s/^\(.\{81\}\).*$/\1/

# spaces are split into two halves through the use of back-refs.
s/^\(.*\)\n\( *\)\2.*$/\2\1/
