#! /bin/sed -nf

# This script replaces cat -n; the trick is to save the *next* line
# number in hold space, printing the line soon so that we can then
# discard the pattern space

x
/^$/ {
  # Prime the pump
  s/^.*$/1/
}

# Add the correct line number before the pattern
G
h
s/^/      /
s/^ *\(......\)\n/\1  /p

# move the line number only to hold space, and add a
# zero if we're going to add a digit on the next line
x
s/\n.*$//
/^9*$/ s/^/0/

# separate changing/unchanged digits with an x
s/.9*$/x&/

# keep changing digits in hold space
h
s/^.*x//
y/0123456789/1234567890/
x

# keep unchanged digits in pattern space
s/x.*$//

# compose the new number, remove the new-line implicitly added by G
G
s/\n//
h
