#! /bin/sed -f

# This is an alternative approach to summing numbers,
# which works a digit at a time and hence has unlimited
# precision.  This time it is done with lookup tables,
# and uses only 10 commands.

G
s/\n/-/
s/$/-/
s/$/;9aaaaaaaaa98aaaaaaaa87aaaaaaa76aaaaaa65aaaaa54aaaa43aaa32aa21a100/

:loop
/^--[^a]/!{
  # Convert next digit from both terms into analog form
  # and put the two groups next to each other
  s/^\([0-9a]*\)\([0-9]\)-\([^-]*\)-\(.*;.*\2\(a*\)\2.*\)/\1-\3-\5\4/
  s/^\([^-]*\)-\([0-9a]*\)\([0-9]\)-\(.*;.*\3\(a*\)\3.*\)/\1-\2-\5\4/

  # Back to decimal, but keeping the carry in analog form
  # \2 matches an `a' if there are at least ten a's, else nothing
  #
  #    1-------------           3-    4----------------------
  #               2                               5----
  s/-\(aaaaaaaaa\(a\)\)\{0,1\}\(a*\)\([0-9b]*;.*\([0-9]\)\3\5\)/-\2\5\4/
  b loop
}
s/^--\([^;]*\);.*/\1/
h
