# Host: 	    Database: 	    Date:
# ---------------------------------------------------------
#

DROP TABLE IF EXISTS latin_morpho;
CREATE TABLE latin_morpho ( id INTEGER PRIMARY KEY, lemma TEXT  NOT NULL, pos NOT NULL CHECK(pos in ('n','v','a','s','r')), principal_parts TEXT, irregular_forms TEXT, alternative_forms TEXT, pronunciation TEXT, miscellanea TEXT);
CREATE INDEX lemma_and_pos_index on latin_morpho(lemma , pos);

INSERT INTO latin_morpho VALUES (16,'abalieno','v','abalien abalienav abalienat',NULL,NULL,'[a.ba.lɪˈeː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19,'abalienatio','n','abalienation',NULL,NULL,'/a.ba.li.eːˈnaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22,'abante','r',NULL,NULL,NULL,'[aˈban.tɛ]','rp--------');
INSERT INTO latin_morpho VALUES (26,'abavus','n','abav',NULL,NULL,'[ˈa.ba.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (34,'abbatissa','n','abbatiss',NULL,NULL,'[ab.baːˈtɪs.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (38,'abbrevio','v','abbrevi abbreviav abbrevia',NULL,NULL,'[abˈbrɛ.wi.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (42,'abdo','v','abd abdid abdit',NULL,NULL,'/ˈab.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (43,'abdico','v','abdic abdicav abdicat',NULL,NULL,'/abˈdiː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (46,'abdicatio','n','abdication',NULL,NULL,'[ab.dɪˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (54,'abdomen','n','abdomin',NULL,NULL,'[abˈdoː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (58,'abeo','v','ab abiv abit','v2spia--4-=abis v3spia--4-=abit v1ppia--4-=abimus v2ppia--4-=abitis v3ppia--4-=abeunt v1siia--4-=abibam v2siia--4-=abibas v3siia--4-=abibat v1piia--4-=abibamus v2piia--4-=abibatis v3piia--4-=abibant v1sfia--4-=abibo v2sfia--4-=abibis v3sfia--4-=abibit v1pfia--4-=abibimus v2pfia--4-=abibitis v3pfia--4-=abibunt v-sppamn4-=abiens v-sppafn4-=abiens v-sppann4-=abiens v-sfpamn4-=abiturus v-sfpafn4-=abitura v-sfpann4-=abiturum v-sfppmn4-=abeundus v-sfppfn4-=abeunda v-sfppnn4-=abeundum v-sngang4-=abeundi v-s-damn4-=abeundus v-s-dafn4-=abeunda v-s-dann4-=abeundum',NULL,'/ˈa.be.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (69,'aberratio','n','aberration',NULL,NULL,'[a.bɛrˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (75,'abhorreo','v','abhorr abhorru -',NULL,NULL,'[abˈhɔr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (80,'abicio','v','abic abiec abiect',NULL,NULL,'[aˈbɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (84,'abies','n','abiet',NULL,NULL,'/ˈa.bi.eːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (88,'abigo','v','abig abeg abact',NULL,NULL,'[ˈa.bɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (93,'abigeatus','n','abigeat',NULL,NULL,'[a.bɪ.ɡɛˈaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (97,'abitus','n','abit',NULL,NULL,'[ˈa.bɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (99,'abitio','n','abition',NULL,NULL,'[aˈbɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (113,'ablacto','v','ablact ablactav ablactat',NULL,NULL,'[aˈbɫak.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (121,'ablativus','a','ablativ ablativ ablativ',NULL,NULL,'[a.bɫaːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (123,'ablego','v','ableg ablegav ablegat',NULL,NULL,'[aˈbɫeː.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (127,'abligurrio','v','abligurr abligurri abligurrit',NULL,NULL,'[a.blɪˈɡuːr.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (129,'abluo','v','ablu ablu ablut',NULL,NULL,'[ˈa.bɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (131,'ablutio','n','ablution',NULL,NULL,'[aˈbɫuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (132,'abluvium','n','abluvi',NULL,NULL,'[aˈbɫʊ.wi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (133,'abluvio','n','abluvion',NULL,NULL,'[aˈbɫʊ.wi.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (136,'abnego','v','abneg abnegav abnegat',NULL,NULL,'/ˈab.ne.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (137,'abnegatio','n','abnegation',NULL,NULL,'[ab.nɛˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (146,'abnuo','v','abnu abnu -',NULL,NULL,'[ˈab.nʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (153,'aboleo','v','abol abolev abolit',NULL,NULL,'[aˈbɔ.ɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (155,'abolesco','v','abolesc abolev -',NULL,NULL,'[a.bɔˈɫeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (156,'abolitio','n','abolition',NULL,NULL,'[a.bɔˈlɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (158,'abolla','n','aboll',NULL,NULL,'[aˈbɔl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (160,'abominor','v','abomin abominat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (168,'aborior','v','abor abort -',NULL,NULL,'[aˈbɔ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (173,'abortus','n','abort',NULL,NULL,'[aˈbɔr.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (175,'abortio','v','abort abortiv -',NULL,NULL,'[aˈbɔr.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (176,'abortium','n','aborti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (177,'abortio','n','abortion',NULL,NULL,'[aˈbɔr.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (184,'abrado','v','abrad abras abras',NULL,NULL,'/aˈbraː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (188,'abripio','v','abrip abripu abrept',NULL,NULL,'/abˈri.pi.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (191,'abrogo','v','abrog abrogav abrogat',NULL,NULL,'[ˈa.brɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (196,'abrumpo','v','abrump abrup abrupt',NULL,NULL,'[aˈbrʊm.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (200,'abrupte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (201,'abruptio','n','abruption',NULL,NULL,'[aˈbrʊp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (206,'abscedo','v','absced abscess abscess',NULL,NULL,'/apˈskeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (207,'abscessus','n','abscess',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (208,'abscido','v','abscid abscid abscis',NULL,NULL,'/apˈskiː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (209,'abscindo','v','abscind abscid absciss',NULL,NULL,'[apˈskɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (211,'abscise','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (212,'abscisio','n','abscision',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (214,'abscondo','v','abscond abscondid abscondit',NULL,NULL,'[apˈskɔn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (219,'abscondite','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (225,'absento','v','absent absentav absentat',NULL,NULL,'[aˈpsɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (227,'absentia','n','absenti',NULL,NULL,'[aˈpsɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (238,'absinthium','n','absinthi',NULL,NULL,'[aˈpsɪn.tʰi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (242,'absis','n','absid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (244,'absisto','v','absist abstit -',NULL,NULL,'[aˈpsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (248,'absolutus','a','absolut absolut absolut',NULL,NULL,'[a.psɔˈɫuː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (249,'absolute','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (250,'absolutio','n','absolution',NULL,NULL,'[a.psɔˈɫuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (254,'absolvo','v','absolv absolv absolut',NULL,NULL,'[aˈpsɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (255,'absonus','a','abson abson abson',NULL,NULL,'[ˈa.psɔ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (259,'absorbeo','v','absorb absorps absorpt',NULL,NULL,'[aˈpsɔr.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (266,'abstantia','n','abstanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (268,'abstemius','a','abstemi abstemi abstemi',NULL,NULL,'[apˈsteː.mi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (269,'abstergeo','v','absterg absters absters',NULL,NULL,'[apˈstɛr.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (271,'absterreo','v','absterr absterru absterrit',NULL,NULL,'[apˈstɛr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (272,'abstineo','v','abstin abstinu abstent',NULL,NULL,'[apˈstɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (276,'abstinentia','n','abstinenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (279,'abstraho','v','abstrah abstrax abstract',NULL,NULL,'/ˈap.stra.hoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (280,'abstrudo','v','abstrud abstrus abstrus',NULL,NULL,'/apˈstruː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (281,'abstrusus','a','abstrus abstrus abstrus',NULL,NULL,'[apˈstruː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (285,'absumo','v','absum absumps absumpt',NULL,NULL,'/aˈpsuː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (287,'absumptio','n','absumption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (289,'absurde','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (290,'absurditas','n','absurditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (293,'abundo','v','abund abundav abundat',NULL,NULL,'[aˈbʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (294,'abundans','a','abundant abundant abundant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (295,'abundanter','r',NULL,NULL,NULL,'[a.bʊnˈdan.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (296,'abundantia','n','abundanti',NULL,NULL,'[a.bʊnˈdan.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (297,'abundatio','n','abundation',NULL,NULL,'[a.bʊnˈdaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (298,'abunde','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (300,'abusio','n','abusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (306,'abutor','v','abut abus -',NULL,NULL,'[aˈbuː.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (308,'abyssus','n','abyss',NULL,NULL,'[aˈbʏs.sʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (310,'acus','n','ac',NULL,NULL,'/ˈa.kʊs/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (312,'acacia','n','acaci',NULL,NULL,'/aˈkaː.ki.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (313,'academia','n','academi',NULL,NULL,'/a.ka.deːˈmiː.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (314,'academicus','a','academic academic academic',NULL,NULL,'/a.kaˈdeː.mi.kus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (315,'acalanthis','n','acalanthid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (352,'accedo','v','acced access access',NULL,NULL,'/akˈkeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (355,'accelero','v','acceler accelerav accelerat',NULL,NULL,'[akˈkɛ.ɫɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (356,'acceleratio','n','acceleration',NULL,NULL,'[ak.kɛ.ɫɛˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (358,'accendo','v','accend accend accens',NULL,NULL,'[akˈkɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (362,'accensus','n','accens',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (366,'accentus','n','accent',NULL,NULL,'[akˈkɛn.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (368,'accentiuncula','n','accentiuncul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (371,'acceptum','n','accept',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (372,'accepto','v','accept acceptav acceptat',NULL,NULL,'[akˈkɛp.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (373,'acceptus','a','accept accept accept',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (374,'acceptabilis','a','acceptabil acceptabil acceptabil',NULL,NULL,'[ak.kɛpˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (379,'acceptio','n','acception',NULL,NULL,'[akˈkɛp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (389,'accersitor','n','accersitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (391,'accessus','n','access',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (392,'accessibilis','a','accessibil accessibil accessibil',NULL,NULL,'[ak.kɛsˈsɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (394,'accessio','n','accession',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (400,'accido','v','accid accid -',NULL,NULL,'[ˈak.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (403,'accidens','n','accident',NULL,NULL,'[ˈak.kɪ.dẽːs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (408,'accingo','v','accing accinx accinct',NULL,NULL,'[akˈkɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (413,'accitus','n','accit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (415,'accitio','n','accition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (416,'acclamo','v','acclam acclamav acclamat',NULL,NULL,'[akˈkɫaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (417,'acclamatio','n','acclamation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (425,'acclivitas','n','acclivitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (428,'accola','n','accol',NULL,'n-s---cn1-=adcola','[ˈak.kɔ.ɫa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (432,'accommodo','v','accommod accommodav accommodat',NULL,NULL,'[akˈkɔm.mɔ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (435,'accommodatio','n','accommodation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (446,'accredo','v','accred accredid accredit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (447,'accresco','v','accresc accrev accret',NULL,NULL,'/akˈkreːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (449,'accretio','n','accretion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (460,'accumulo','v','accumul accumulav accumulat',NULL,NULL,'[akˈkʊ.mʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (462,'accumulatio','n','accumulation',NULL,NULL,'[ak.kʊ.mʊˈɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (466,'accuratus','a','accurat accurat accurat',NULL,NULL,'/ak.kuːˈraː.tus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (471,'accursus','n','accurs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (472,'accuso','v','accus accusav accusat',NULL,NULL,'/akˈkuː.soː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (474,'accusatio','n','accusation',NULL,NULL,'/ak.kuːˈsaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (476,'accusativus','a','accusativ accusativ accusativ',NULL,NULL,'[ak.kuː.saːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (477,'accusator','n','accusator',NULL,NULL,'/ak.kuːˈsaː.tor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (490,'acer','n','acer',NULL,NULL,'[ˈaː.kɛr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (492,'acer','a','acr acr acr',NULL,NULL,'[ˈaː.kɛr]','aps---mn3-');
INSERT INTO latin_morpho VALUES (495,'acerbo','v','acerb acerbav acerbat',NULL,NULL,'/aˈker.boː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (496,'acerbus','a','acerb acerb acerb',NULL,NULL,'[aˈkɛr.bʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (497,'acerbe','r',NULL,NULL,NULL,'[aˈkɛr.bɛ]','rp--------');
INSERT INTO latin_morpho VALUES (498,'acerbitas','n','acerbitat',NULL,NULL,'[aˈkɛr.bɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (508,'acervus','n','acerv',NULL,NULL,'[aˈkɛr.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (509,'acervo','v','acerv acervav acervat',NULL,NULL,'[aˈkɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (513,'acervatio','n','acervation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (517,'acetum','n','acet',NULL,NULL,'[aˈkeː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (533,'Achates','n','Achat',NULL,NULL,'[aˈkʰaː.teːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (538,'Achilles','n','Achille',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (543,'acia','n','aci',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (544,'acies','n','aci',NULL,NULL,'/ˈa.ki.eːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (547,'acidus','a','acid acid acid',NULL,NULL,'[ˈa.kɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (554,'acinum','n','acin',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (556,'acinaces','n','acinac',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (560,'acipenser','n','acipenser',NULL,NULL,'[a.kɪˈpẽː.sɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (571,'acoetis','n','acoet',NULL,NULL,'[aˈkoe̯.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (578,'aconitum','n','aconit',NULL,NULL,'/a.koˈniː.tum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (588,'acoron','n','acor',NULL,NULL,NULL,'n-s---nn2g');
INSERT INTO latin_morpho VALUES (589,'acor','n','acor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (608,'acrimonia','n','acrimoni',NULL,NULL,'[aː.krɪˈmoː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (609,'acritas','n','acritat',NULL,NULL,'[ˈaː.krɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (611,'acritudo','n','acritudin',NULL,NULL,'[aː.krɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (613,'acroama','n','acroamat',NULL,NULL,'[a.krɔˈaː.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (616,'acroasis','n','acroas',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (617,'acroaticus','a','acroatic acroatic acroatic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (635,'acta','n','act',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (638,'actus','n','act',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (644,'actio','n','action',NULL,NULL,'/ˈaːk.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (648,'activus','a','activ activ activ',NULL,NULL,'[aːkˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (651,'actor','n','actor',NULL,NULL,'[ˈaːk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (657,'actualis','a','actual actual actual',NULL,NULL,'[ak.tʊˈaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (662,'actuarius','n','actuari',NULL,NULL,'[aːk.tʊˈaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (667,'actuosus','a','actuos actuos actuos',NULL,NULL,'[aːk.tʊˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (670,'actutum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (671,'acuo','v','acu acu acut',NULL,NULL,'[ˈa.kʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (677,'aculeus','n','acule',NULL,NULL,'[aˈkʊ.ɫe.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (680,'acumen','n','acumin',NULL,NULL,'[aˈkuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (683,'acuminatus','a','acuminat acuminat acuminat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (690,'acus','n','ac',NULL,NULL,'/ˈa.kʊs/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (692,'acutus','a','acut acut acut',NULL,NULL,'[aˈkuː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (698,'acute','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (710,'adaequo','v','adaequ adaequav adaequat',NULL,NULL,'/aˈdae̯.kʷoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (715,'adaero','v','adaer adaerav adaerat',NULL,NULL,'/aˈdae̯.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (720,'adagio','n','adagion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (721,'adagnitio','n','adagnition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (723,'adalligo','v','adallig adalligav adalligat',NULL,NULL,'[aˈdal.lɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (730,'adamas','n','adamant',NULL,NULL,'/ˈa.da.maːs/','n-s---mn3i');
INSERT INTO latin_morpho VALUES (733,'adamplio','v','adampli adampliav adampliat',NULL,NULL,'/aˈdam.pli.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (736,'adaperio','v','adaper adaperu adapert',NULL,NULL,'[a.daˈpɛ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (739,'adapertio','n','adapertion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (741,'adapto','v','adapt adaptav adaptat',NULL,NULL,'/aˈdap.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (743,'adaquo','v','adaqu adaquav adaquat',NULL,NULL,'/ˈa.da.kʷoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (751,'adauctus','n','adauct',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (754,'adaugeo','v','adaug adaux adauct',NULL,NULL,'/aˈdau̯.ɡe.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (755,'adaugesco','v','adaugesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (756,'adaugmen','n','adaugmin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (758,'adbibo','v','adbib adbib adbibit',NULL,NULL,'[ˈad.bɪ.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (759,'adbito','v','adbit - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (817,'addo','v','add addid addit',NULL,NULL,'/ˈad.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (822,'addenso','v','addens addensav addensa',NULL,NULL,'[adˈdẽː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (829,'addisco','v','addisc addidic -',NULL,NULL,'[adˈdɪs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (830,'additamentum','n','additament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (832,'additio','n','addition',NULL,NULL,'[adˈdɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (839,'addubito','v','addubit addubitav addubitat',NULL,NULL,'[adˈdʊ.bɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (840,'adduco','v','adduc addux adduct',NULL,NULL,'/adˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (843,'adductor','n','adductor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (844,'adeo','v','adi adiv adit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (845,'adedo','v','aded aded ades','v--pna--3-=adesse v2spia--3-=ades v3spia--3-=adest v2ppia--3-=adestis',NULL,'[ˈa.dɛ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (850,'adeo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (851,'adeps','n','adip',NULL,NULL,'[ˈa.dɛps]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (853,'adeptio','n','adeption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (863,'adfabilis','a','adfabil adfabil adfabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (864,'adfabilitas','n','adfabilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (866,'adfabre','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (868,'adfamen','n','adfamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (870,'adfatus','n','adfat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (872,'adfectus','n','adfect',NULL,NULL,'[adˈfɛk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (874,'adfecto','v','adfect adfectav adfectat',NULL,'v1spia--1-=affecto v--pna--1-=affectare v-srppmn1-=affectatus','/adˈfek.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (877,'adfectatio','n','adfectation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (880,'adfecte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (881,'adfectio','n','adfection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (890,'adfectuose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (892,'adfero','v','adfer adtul adlat','v--pna--3-=adferre v2spia--3-=adfers v3spia--3-=adfert v2ppia--3-=adfertis',NULL,'[ˈad.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (893,'adficio','v','adfic adfec adfect',NULL,'v1spia--3i=afficio v--pna--3i=afficere v1sria--3i=affeci v-srppmn3i=affectus v-srppfn3i=affecta v-srppnn3i=affectum','[adˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (898,'adfingo','v','adfing adfinx adfict',NULL,'v1spia--3-=affingo v--pna--3-=affingere v1sria--3-=affinxi v-srppmn3-=affictus v-srppfn3-=afficta v-srppnn3-=affictum','[adˈfɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (901,'adfirmo','v','adfirm adfirmav adfirmat',NULL,'v1spia--1-=affirmo v--pna--1-=affirmare v1sria--1-=affirmavi v-srppmn1-=affirmatus v-srppfn1-=affirmata v-srppnn1-=affirmatum','/adˈfir.moː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (905,'adfirmativus','a','adfirmativ adfirmativ adfirmativ',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (910,'adflo','v','adfl adflav adflat',NULL,NULL,'/ˈad.floː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (913,'adflatus','n','adflat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (916,'adflictus','n','adflict',NULL,NULL,'[adˈfliːk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (918,'adflicto','v','adflict adflictav adflictat',NULL,NULL,'/adˈfliːk.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (921,'adflictio','n','adfliction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (925,'adfligo','v','adflig adflix adflict',NULL,'v1spia--3-=affligo v--pna--3-=affligere v1sria--3-=afflixi v-srppmn3-=afflictus v-srppfn3-=afflicta v-srppnn3-=afflictum','/adˈfliː.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (927,'adfluens','a','adfluent adfluent adfluent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (929,'adfluenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (930,'adfluentia','n','adfluenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (932,'adformido','v','adformid adformidav adformidat',NULL,'v1spia--1-=afformido v--pna--1-=afformidavi v1sria--1-=afformidavi v-srppmn1-=afformidatus v-srppfn1-=afformidata v-srppnn1-=afformidatum','[ad.fɔrˈmiː.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (934,'adfremo','v','adfrem - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (939,'adfrictus','n','adfrict',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (942,'adfulgeo','v','adfulg adfuls -',NULL,'v1spia--2-=affulgeo v--pna--2-=affulgere v1sria--2-=affulsi','[adˈfʊɫ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (951,'adgero','v','adger adgess adgest',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (975,'adgravo','v','adgrav adgravav adgravat',NULL,'v1spia--1-=aggravo v--pna--1-=aggravare v1sria--1-=aggravavi v-srppmn1-=aggravatus','/ˈad.ɡra.woː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (978,'adgredior','v','adgred adgress -',NULL,'v1spid--3i=aggredior v--pnd--3i=aggredi v1sridmn3i=aggressus_sum v1sridfn3i=aggressa_sum v1sridnn3i=aggressum_sum',NULL,'v1spid--3i');
INSERT INTO latin_morpho VALUES (980,'adgressus','n','adgress',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (981,'adgressio','n','adgression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (982,'adgressor','n','adgressor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (983,'adgressura','n','adgressur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (986,'adhaeresco','v','adhaeresc adhaes -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (987,'adhaesus','n','adhaes',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (989,'adhaesio','n','adhaesion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (996,'adhibeo','v','adhib adhibu adhibit',NULL,NULL,'[adˈhɪ.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (1001,'adhortor','v','adhort adhortat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (1003,'adhortatus','n','adhortat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1004,'adhortatio','n','adhortation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1008,'adhuc','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (1010,'adiantum','n','adiant',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1015,'adicio','v','adic adiec adiect',NULL,NULL,'[adˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (1017,'adimo','v','adim adem adempt',NULL,NULL,'[ˈa.dɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1018,'adimpleo','v','adimpl adimplev adimplet',NULL,NULL,'[aˈdɪm.pɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (1020,'adimpletio','n','adimpletion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1022,'adincresco','v','adincresc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1029,'adinvenio','v','adinven adinven adinvent',NULL,NULL,'[a.dɪnˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (1031,'adinventio','n','adinvention',NULL,NULL,'[a.dɪnˈwɛn.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1032,'adinventor','n','adinventor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1035,'adipatus','a','adipat adipat adipat',NULL,NULL,'[a.dɪˈpaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1037,'adipiscor','v','adipisc adept -',NULL,NULL,'[a.dɪˈpiːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (1043,'aditus','n','adit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1045,'aditialis','a','aditial aditial aditial',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (1047,'adiumentum','n','adiument',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1088,'adlambo','v','adlamb - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1095,'adlecto','v','adlect adlectav adlectat',NULL,'v1spia--1-=allecto v--pna--1-=allectrare v1sria--1-=allectavi v-srppmn1-=allectatus v-srppfn1-=allectata v-srppnn1-=allectatum',NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (1100,'adlego','v','adleg adleg adlect',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (1103,'adlegatio','n','adlegation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1105,'adlevo','v','adlev adlevav adleva',NULL,NULL,'[ˈad.ɫɛ.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1107,'adlevamentum','n','adlevament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1108,'adlevatio','n','adlevation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1110,'adlevio','v','adlevi adleviav adleviat',NULL,'v1spia--1-=allevio v--pna--1-=alleviare v1sria--1-=alleviavi v-srppmn1-=alleviatus v-srppfn1-=alleviata v-srppnn1-=alleviatum','[adˈɫɛ.wi.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1114,'adlicio','v','adlic adlex adlect',NULL,NULL,'[adˈlɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (1116,'adligo','v','adlig adligav adligat',NULL,'v1spia--1-=alligo v--pna--1-=alligare v1sria--1-=alligavi v-srppmn1-=alligatus v-srppfn1-=alligata v-srppnn1-=alligatum','[ˈad.lɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1117,'adligamentum','n','adligament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1120,'adligatura','n','adligatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (1123,'adlocutio','n','adlocution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1124,'adloquor','v','adloqu adlocut -',NULL,'v1spid--3-=alloquor v--pnd--3-=alloqui v1sridmn3-=allocutus_sum v1sridfn3-=allocuta_sum v1sridnn3-=allocutum_sum','[ˈad.ɫɔ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (1125,'adloquium','n','adloqui',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1126,'adluo','v','adlu adlu -',NULL,NULL,'[ˈad.ɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1132,'adludio','v','adludi adludiav adludia',NULL,'v1spia--1-=alludio v--pna--1-=alludiare v1sria--1-=alludiavi v-srppmn1-=alludiatus v-srppfn1-=alludiata v-srppnn1-=alludiatum','[adˈɫuː.di.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1135,'adluvius','a','adluvi adluvi adluvi',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1136,'adluvio','n','adluvion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1140,'admetior','v','admet admens -',NULL,NULL,'[adˈmeː.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (1142,'adminiculum','n','adminicul',NULL,NULL,'[ad.mɪˈnɪ.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (1143,'adminiculo','v','adminicul adminiculav adminiculat',NULL,NULL,'[ad.mɪˈnɪ.kʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1147,'adminiculator','n','adminiculator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1148,'administer','n','administr',NULL,NULL,'[ad.mɪˈnɪs.tɛr]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (1149,'administra','n','administr',NULL,NULL,'[ad.mɪˈnɪs.tra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (1150,'administro','v','administr administrav administrat',NULL,NULL,'[ad.mɪˈnɪs.troː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1151,'administratio','n','administration',NULL,NULL,'[ad.mɪ.nɪsˈtraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1154,'administrator','n','administrator',NULL,NULL,'[ad.mɪ.nɪsˈtraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (1156,'admiror','v','admir admirat -',NULL,NULL,'[adˈmiː.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1158,'admirabilitas','n','admirabilitat',NULL,NULL,'/ad.miː.raːˈbi.li.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1159,'admirabiliter','r',NULL,NULL,NULL,'[ad.miː.raːˈbɪ.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (1162,'admirandus','a','admirand admirand admirand',NULL,NULL,'[ad.miːˈran.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1164,'admiratio','n','admiration',NULL,NULL,'/ad.miːˈraː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1165,'admirator','n','admirator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1166,'admisceo','v','admisc admiscu admixt',NULL,NULL,'[adˈmɪs.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (1168,'admissum','n','admiss',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1170,'admissarius','n','admissari',NULL,NULL,'[ad.mɪsˈsaː.ri.ʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (1172,'admissio','n','admission',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1180,'admitto','v','admitt admis admiss',NULL,NULL,'[adˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1181,'admixtus','n','admixt',NULL,NULL,'[adˈmɪk.stʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (1183,'admixtio','n','admixtion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1187,'admodum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (1190,'admoneo','v','admon admonu admonit',NULL,NULL,'[adˈmɔ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (1192,'admonitum','n','admonit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1193,'admonitus','n','admonit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1194,'admonitio','n','admonition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1196,'admonitorium','n','admonitori',NULL,NULL,'[ad.mɔ.nɪˈtoː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (1199,'admorsus','n','admors',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1202,'admoveo','v','admov admov admot',NULL,NULL,'[adˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (1213,'adnecto','v','adnect adnexu adnex',NULL,NULL,'[adˈnɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1224,'adnitor','v','adnit adnix -',NULL,NULL,'[adˈniː.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (1230,'adnoto','v','adnot adnotav adnotat',NULL,NULL,'[ˈad.nɔ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1231,'adnotamentum','n','adnotament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1233,'adnotatus','n','adnotat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1236,'adnotator','n','adnotator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1239,'adnullo','v','adnull adnullav adnullat',NULL,NULL,'[adˈnʊl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1240,'adnumero','v','adnumer adnumerav adnumerat',NULL,NULL,'[adˈnʊ.mɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1241,'adnumeratio','n','adnumeration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1243,'adnuntio','v','adnunti adnuntiav adnuntiat',NULL,NULL,'/adˈnuːn.ti.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (1245,'adnuntiatio','n','adnuntiation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1246,'adnuntiator','n','adnuntiator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1251,'adoleo','v','adol - -',NULL,NULL,NULL,'v1spia--2-');
INSERT INTO latin_morpho VALUES (1255,'adolesco','v','adolesc adolev adult',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1269,'adoperio','v','adoper adoperu adopert',NULL,NULL,'[a.dɔˈpɛ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (1273,'adopinor','v','adopin adopinat -',NULL,NULL,'[a.dɔˈpiː.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1274,'adopto','v','adopt adoptav adoptat',NULL,NULL,'[aˈdɔp.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1279,'adoptaticius','a','adoptatici adoptatici adoptatici',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1282,'adoptio','n','adoption',NULL,NULL,'[aˈdɔp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1284,'adoptivus','a','adoptiv adoptiv adoptiv',NULL,NULL,'[a.dɔpˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1285,'ador','n','ador',NULL,NULL,'[ˈa.dɔr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (1286,'adoro','v','ador adorav adorat',NULL,NULL,'/aˈdoː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (1290,'adorator','n','adorator',NULL,NULL,'[a.doːˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (1293,'adoreum','n','adore',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1296,'adorior','v','ador adort -',NULL,NULL,'[aˈdɔ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (1300,'adorno','v','adorn adornav adornat',NULL,NULL,'/aˈdoːr.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (1408,'adquiesco','v','adquiesc adquiev adquiet',NULL,NULL,'[ad.kᶣɪˈeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1412,'adquiro','v','adquir adquisiv adquisit',NULL,NULL,'[adˈkᶣiː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1414,'adquisitio','n','adquisition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1418,'adrado','v','adrad adras adras',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1422,'adrectarius','a','adrectari adrectari adrectari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1430,'adrigo','v','adrig adrigav adriga',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (1432,'adripio','v','adrip adripu adrept',NULL,NULL,'[aˈdrɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (1434,'adrisor','n','adrisor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1435,'adrodo','v','adrod adros adros',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1436,'adrogo','v','adrog adrogav adrogat',NULL,NULL,'[ˈa.drɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1439,'adroganter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (1440,'adrogantia','n','adroganti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (1446,'adruo','v','adru adru adrut',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1451,'adsum','v','- adfu -','v--pna--3-=adesse v1spia--3-=adsum v2spia--3-=ades v3spia--3-=adest v1ppia--3-=adsumus v2ppia--3-=adestis v3ppia--3-=adsunt v-sfpamn3-=adfuturus v-sfpafn3-=adfutura v-sfpann3-=adfuturum',NULL,'[ˈat.sũ]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1469,'adsecla','n','adsecl',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (1470,'adsector','v','adsect adsectat -',NULL,'v1spid--1-=assector v--pnd--1-=assectari v1sridmn1-=assectatus_sum v1sridfn1-=assectata_sum v1sridnn1-=assectatum_sum','[atˈsɛk.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1472,'adsectator','n','adsectator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1477,'adsellor','v','adsell adsellat -',NULL,'v1spid--1-=assellor v--pnd--1-=assellari v1sridmn1-=assellatus_sum v1sridfn1-=assellata_sum v1sridnn1-=assellatum_sum','[atˈsɛl.lɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1479,'adsensus','n','adsens',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1480,'adsensio','n','adsension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1482,'adsentor','v','adsent adsentat -',NULL,'v1spid--1-=assentor v--pnd--1-=assentari v1sridmn1-=assentatus_sum v1sridfn1-=assentata_sum v1sridnn1-=assentatum_sum','[atˈsɛn.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1483,'adsentatio','n','adsentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1485,'adsentator','n','adsentator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1488,'adsentio','v','adsenti adsens adsens',NULL,NULL,'[atˈsɛn.ti.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1490,'adsequor','v','adsequ adsecut -',NULL,'v1spid--3-=assequor v--pnd--3-=assequi v1sridmn3-=assecutus_sum v1sridmn3-=assecutus_sum v1sridfn3-=assecuta_sum v1sridnn3-=assecutum_sum','[ˈat.sɛ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (1493,'adsero','v','adser adsev adsit',NULL,NULL,'[ˈat.sɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1497,'adsertor','n','adsertor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1499,'adservo','v','adserv adservav adservat',NULL,'v1spia--1-=asservo v--pna--1-=asservare v1sria--1-=asservavi v-srppmn1-=asservatus v-srppfn1-=asservata v-srppnn1-=asservatum','[atˈsɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1508,'adsevero','v','adsever adseverav adseverat',NULL,'v1spia--1-=assevero','[at.sɛˈweː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1510,'adseverate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (1511,'adseveratio','n','adseveration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1513,'adsicco','v','adsicc adsiccav adsiccat',NULL,'v1spia--1-=assicco v--pna--1-=assiccare v1sria--1-=assiccavi v-srppmn1-=assiccatus v-srppfn1-=assiccata v-srppnn1-=assiccatum','[atˈsɪk.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1514,'adsiccesco','v','adsiccesc adsiccu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1516,'adsido','v','adsid adsed adsess',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1519,'adsiduus','a','adsidu adsidu adsidu',NULL,NULL,'[atˈsɪ.dʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1520,'adsidue','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (1521,'adsiduitas','n','adsiduitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1522,'adsiduo','r',NULL,NULL,NULL,'[atˈsɪ.dʊ.oː]','rp--------');
INSERT INTO latin_morpho VALUES (1524,'adsigno','v','adsign adsignav adsignat',NULL,'v1spia--1-=assigno v--pna--1-=assignare v1sria--1-=assignavi v-srppmn1-=assignatus v-srppfn1-=assignata v-srppnn1-=assignatum','[atˈsɪŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1525,'adsignatio','n','adsignation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1527,'adsignifico','v','adsignific adsignificav adsignificat',NULL,'v1spia--1-=assignifico v--pna--1-=assignificare v1sria--1-=assignificavi v-srppfn1-=assignificata v-srppnn1-=assignificatum','[at.sɪŋˈnɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1528,'adsilio','v','adsil adsilu adsult',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (1534,'adsimiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (1535,'adsimulo','v','adsimul adsimulav adsimulat',NULL,'v1spia--1-=assimulo v--pna--1-=assimulare v1sria--1-=assimulavi v-srppmn1-=assimulatus v-srppfn1-=assimulata v-srppnn1-=assimulatum','[atˈsɪ.mʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1539,'adsimulatio','n','adsimulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1545,'adsocio','v','adsoci adsociav adsociat',NULL,'v1spia--1-=associo v--pna--1-=associare v1sria--1-=associavi v-srppmn1-=associatus v-srppfn1-=associata v-srppnn1-=associatum','[atˈsɔ.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1550,'adsono','v','adson adsonav adsonat',NULL,'v1spia--1-=assono v--pna--1-=assonare v1sria--1-=assonavi v-srppmn1-=assonatus v-srppfn1-=assonata v-srppnn1-=assonatum',NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (1566,'adsto','v','adst adstit -',NULL,NULL,'/ˈat.stoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (1573,'adstipulor','v','adstipul adstipulat -',NULL,NULL,'[atˈstɪ.pʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1574,'adstipulatus','n','adstipulat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1575,'adstipulatio','n','adstipulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1576,'adstipulator','n','adstipulator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1578,'adstrangulo','v','adstrangul adstrangulav adstrangula',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (1581,'adstricte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (1583,'adstrictorius','a','adstrictori adstrictori adstrictori',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1585,'adstrido','v','adstrid - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1586,'adstringo','v','adstring adstrinx adstrict',NULL,NULL,'[atˈstrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1587,'adstruo','v','adstru adstrux adstruct',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (1596,'adsuetus','a','adsuet adsuet adsuet',NULL,NULL,'[at.sʊˈeː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1597,'adsuetudo','n','adsuetudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1599,'adsultus','n','adsult',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1600,'adsulto','v','adsult adsultav adsultat',NULL,'v1spia--1-=assulto v--pna--1-=assultare v1sria--1-=assultavi v-srppmn1-=assultatus v-srppfn1-=assultata v-srppnn1-=assultatum','[atˈsʊɫ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1602,'adsumo','v','adsum adsumps adsumpt',NULL,NULL,'/atˈsuː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (1604,'adsumptio','n','adsumption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1606,'adsurgo','v','adsurg adsurrex adsurrect',NULL,NULL,'[atˈsʊr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1625,'adtermino','v','adtermin adterminav adterminat',NULL,'v1spia--1-=attermino v--pna--1-=atterminare v1sria--1-=atterminavi v-srppmn1-=atterminatus v-srppfn1-=atterminata v-srppnn1-=atterminatum','[atˈtɛr.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1641,'adtitulo','v','adtitul adtitulav adtitulat',NULL,'v1spia--1-=attitulo v--pna--1-=attitulare v1sria--1-=attitulavi v-srppmn1-=attitulatus v-srppfn1-=attitulata v-srppnn1-=attitulatum','[atˈtɪ.tʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1675,'adulor','v','adul adulat -',NULL,NULL,'[aˈduː.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1676,'adulans','a','adulant adulant adulant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (1678,'adulatio','n','adulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1680,'adulatorius','a','adulatori adulatori adulatori',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1685,'adulescentia','n','adulescenti',NULL,NULL,'[a.dʊ.ɫeːsˈkɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (1687,'adulescentula','n','adulescentul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (1696,'adulter','a','adulter adulter adulter',NULL,NULL,'[aˈdʊɫ.tɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (1697,'adultero','v','adulter adulterav adulterat',NULL,NULL,'[aˈdʊɫ.tɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1699,'adulteratio','n','adulteration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1701,'adulterium','n','adulteri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1702,'adulterinus','a','adulterin adulterin adulterin',NULL,NULL,'[a.dʊɫ.tɛˈriː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1705,'adumbro','v','adumbr adumbrav adumbrat',NULL,NULL,'[aˈdʊm.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1706,'adumbratus','a','adumbrat adumbrat adumbrat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1708,'adumbratio','n','adumbration',NULL,NULL,'[a.dʊmˈbraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1709,'aduno','v','adun adunav adunat',NULL,NULL,'/aˈduː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (1710,'adunatio','n','adunation',NULL,NULL,'/a.duːˈnaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1713,'aduro','v','adur aduss adust',NULL,NULL,'/aˈduː.roː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (1718,'adustus','a','adust adust adust',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1719,'adustio','n','adustion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1720,'advectus','n','advect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1722,'advecto','v','advect advectav advectat',NULL,NULL,'/adˈwek.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (1726,'advector','n','advector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1727,'adveho','v','adveh advex advect',NULL,NULL,'[ˈad.wɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (1728,'advelo','v','advel advelav advelat',NULL,NULL,'[adˈweː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1730,'advena','n','adven',NULL,NULL,'[ˈad.wɛ.na]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (1732,'adveneror','v','advener advenerat -',NULL,NULL,'[adˈwɛ.nɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1735,'adventus','n','advent',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1736,'advento','v','advent adventav adventat',NULL,NULL,'[adˈwɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1740,'adventor','n','adventor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1744,'adverbium','n','adverbi',NULL,NULL,'[adˈwɛr.bi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (1746,'adverbialiter','r',NULL,NULL,NULL,'[ad.wɛr.bɪˈaː.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (1750,'adversum','n','advers',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (1752,'adversus','a','advers advers advers',NULL,NULL,'[adˈwɛr.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1761,'adversator','n','adversator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1766,'adversitas','n','adversitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1770,'adversus','r',NULL,NULL,NULL,'[adˈwɛr.sʊs]','rp--------');
INSERT INTO latin_morpho VALUES (1775,'advigilo','v','advigil advigilav advigilat',NULL,NULL,'[adˈwɪ.ɡɪ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1777,'advivo','v','adviv advix -',NULL,NULL,'/adˈwiː.woː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (1778,'advoco','v','advoc advocav advocat',NULL,NULL,'[ˈad.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1781,'advocatus','n','advocat',NULL,NULL,'[ad.wɔˈkaː.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (1782,'advocatio','n','advocation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1820,'aedes','n','aed',NULL,NULL,'/ˈae̯.deːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (1822,'aedifacio','v','aedifac aedifec aedifact',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (1823,'aedifex','n','aedific',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1824,'aedifico','v','aedific aedificav aedificat',NULL,NULL,'[ae̯ˈdɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (1827,'aedificatio','n','aedification',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1830,'aedificator','n','aedificator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1833,'aedificium','n','aedifici',NULL,NULL,'[ae̯.dɪˈfɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (1851,'aedon','n','aedon',NULL,NULL,'/aˈeː.doːn/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1856,'aeger','a','aegr aegr aegr',NULL,NULL,'[ˈae̯.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (1862,'aegis','n','aegid',NULL,NULL,'[ˈae̯.ɡɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1874,'aegre','r',NULL,NULL,NULL,'/ˈae̯.ɡreː/','rp--------');
INSERT INTO latin_morpho VALUES (1875,'aegresco','v','aegresc - -',NULL,NULL,'/ae̯ˈɡreːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (1877,'aegrimonia','n','aegrimoni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (1879,'aegritudo','n','aegritudin',NULL,NULL,'[ae̯.ɡrɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1880,'aegror','n','aegror',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (1882,'aegrotus','a','aegrot aegrot aegrot',NULL,NULL,'[ae̯ˈɡroː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1886,'aegrotatio','n','aegrotation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1888,'Aegyptus','n','Aegypt',NULL,NULL,'ae̯ˈɡʏp.tʊs','n-s---mn2-');
INSERT INTO latin_morpho VALUES (1890,'Aegyptius','a','Aegypti Aegypti Aegypti',NULL,NULL,'ae̯ˈɡʏp.ti.ʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (1891,'Aegyptiacus','a','Aegyptiac Aegyptiac Aegyptiac',NULL,NULL,'ae̯.ɡʏpˈti.a.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (1895,'aelurus','n','aelur',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (1900,'aemulor','v','aemul aemulat -',NULL,NULL,'[ˈae̯.mʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (1902,'aemulatus','n','aemulat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (1903,'aemulatio','n','aemulation',NULL,NULL,'[ae̯.mʊˈɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1915,'aenigma','n','aenigmat',NULL,NULL,'[ae̯ˈnɪɡ.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (1925,'aequo','v','aequ aequav aequat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (1926,'aequus','a','aequ aequ aequ',NULL,NULL,'[ˈae̯.kʷʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1927,'aequabilis','a','aequabil aequabil aequabil',NULL,NULL,'[ae̯ˈkʷaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (1928,'aequabilitas','n','aequabilitat',NULL,NULL,'[ae̯.kʷaːˈbɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1929,'aequabiliter','r',NULL,NULL,NULL,'[ae̯.kʷaːˈbɪ.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (1931,'aequalis','a','aequal aequal aequal',NULL,NULL,'[ae̯ˈkʷaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (1934,'aequalitas','n','aequalitat',NULL,NULL,'[ae̯ˈkʷaː.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1935,'aequaliter','r',NULL,NULL,NULL,'[ae̯ˈkʷaː.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (1938,'aequanimus','a','aequanim aequanim aequanim',NULL,NULL,'[ae̯ˈkʷa.nɪ.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1940,'aequanimitas','n','aequanimitat',NULL,NULL,'[ae̯.kʷaˈnɪ.mɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1942,'aequatio','n','aequation',NULL,NULL,'/ae̯ˈkʷaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1946,'aeque','r',NULL,NULL,NULL,'[ˈae̯.kᶣeː]','rp--------');
INSERT INTO latin_morpho VALUES (1952,'aequidistans','a','aequidistant aequidistant aequidistant',NULL,NULL,'[ae̯.kᶣɪˈdɪs.tãːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (1966,'aequilibrium','n','aequilibri',NULL,NULL,'[ae̯.kᶣɪˈliː.bri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (1967,'aequilibritas','n','aequilibritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1969,'aequimanus','a','aequiman aequiman aequiman',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (1970,'aequinoctium','n','aequinocti',NULL,NULL,'[ae̯.kᶣɪˈnɔk.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (1975,'aequiparabilis','a','aequiparabil aequiparabil aequiparabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (1976,'aequiparantia','n','aequiparanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (1977,'aequiparatio','n','aequiparation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (1979,'aequipero','v','aequiper aequiperav aequiperat',NULL,NULL,'/ɛːˈkʷi.pe.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (1987,'aequitas','n','aequitat',NULL,NULL,'[ˈae̯.kᶣɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (1988,'aequiter','r',NULL,NULL,NULL,'[ˈae̯.kᶣɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (1992,'aequivocus','a','aequivoc aequivoc aequivoc',NULL,NULL,'[ae̯ˈkᶣɪ.wɔ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (1993,'aequor','n','aequor',NULL,NULL,'[ˈae̯.kʷɔr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (1997,'aer','n','aer',NULL,NULL,'/ˈaː.eːr/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (1999,'aeramen','n','aeramin',NULL,NULL,'[ae̯ˈraː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (2002,'aerarius','n','aerari',NULL,NULL,'[ae̯ˈraː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (2038,'aeruca','n','aeruc',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2039,'aerugino','v','aerugin aeruginav aeruginat',NULL,NULL,'[ae̯ˈruː.ɡɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (2042,'aerugo','n','aerugin',NULL,NULL,'/ae̯ˈruː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2043,'aerumna','n','aerumn',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2047,'aerusco','v','aerusc aeruscav aerusca',NULL,NULL,'[ae̯ˈrʊs.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (2048,'aeruscator','n','aeruscator',NULL,NULL,'[ae̯.rʊsˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2049,'aes','n','aer',NULL,NULL,'/ae̯s/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (2061,'Aesopus','n','Aesop',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (2063,'aestus','n','aest',NULL,NULL,'[ˈae̯s.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (2064,'aestas','n','aestat',NULL,NULL,'/ˈae̯s.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2067,'aestimo','v','aestim aestimav aestimat',NULL,NULL,'[ˈae̯s.tɪ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (2069,'aestimatus','n','aestimat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (2071,'aestimatio','n','aestimation',NULL,NULL,'[ae̯s.tɪˈmaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2072,'aestimator','n','aestimator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (2081,'aestuo','v','aestu aestuav aestuat',NULL,NULL,'/ˈaɪs.tu.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (2089,'aetas','n','aetat',NULL,NULL,'/ˈae̯.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2090,'aetatula','n','aetatul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2091,'aeterno','v','aetern aeternav aeternat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (2096,'aeternitas','n','aeternitat',NULL,NULL,'[ae̯ˈtɛr.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2097,'aeterno','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2098,'aeternum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2101,'aether','n','aether',NULL,NULL,'/ˈae̯.tʰeːr/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2103,'aetherius','a','aetheri aetheri aetheri',NULL,NULL,'[ae̯ˈtʰɛ.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2104,'Aethiopia','n','Aethiopi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2105,'Aethiopicus','a','Aethiopic Aethiopic Aethiopic',NULL,NULL,'[ae̯.tʰɪˈɔ.pɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2108,'Aethiops','n','Aethiop',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (2111,'aethra','n','aethr',NULL,NULL,'/ˈae̯.tʰra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2119,'aevum','n','aev',NULL,NULL,'[ˈae̯.wũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2120,'aevitas','n','aevitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2127,'Afer','a','Afr Afr Afr',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (2219,'Africa','n','Afric',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2221,'Africus','a','Afric Afric Afric',NULL,NULL,'ˈaː.frɪ.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (2223,'Africanus','a','African African African',NULL,NULL,'aː.frɪˈkaː.nʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (2224,'ago','v','ag eg act',NULL,NULL,'/ˈa.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (2230,'agaricum','n','agaric',NULL,NULL,'/aˈɡa.ri.kum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2231,'agaso','n','agason',NULL,NULL,'/aˈɡaː.soː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2243,'ager','n','agr',NULL,NULL,'[ˈa.ɡɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (2253,'agger','n','agger',NULL,NULL,'[ˈaɡ.ɡɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2254,'aggero','v','agger aggerav aggerat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (2282,'agilis','a','agil agil agil',NULL,NULL,'[ˈa.ɡɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (2283,'agilitas','n','agilitat',NULL,NULL,'[aˈɡɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2284,'agiliter','r',NULL,NULL,NULL,'[aˈɡɪ.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (2289,'agito','v','agit agitav agitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (2290,'agitabilis','a','agitabil agitabil agitabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (2291,'agitatus','n','agitat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (2292,'agitatus','a','agitat agitat agitat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (2293,'agitatio','n','agitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2294,'agitator','n','agitator',NULL,NULL,'[a.ɡɪˈtaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2300,'agmen','n','agmin',NULL,NULL,'[ˈaɡ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (2306,'agnascor','v','agnasc agnat -',NULL,NULL,'[aŋˈnas.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (2313,'agnellus','n','agnell',NULL,NULL,'[aŋˈnɛl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (2317,'agniculus','n','agnicul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (2320,'agnitus','n','agnit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (2321,'agnitio','n','agnition',NULL,NULL,'[aŋˈnɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2324,'agnomen','n','agnomin',NULL,NULL,'[aŋˈnoː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (2325,'agnomentum','n','agnoment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (2328,'agnosco','v','agnosc agnov agnit',NULL,NULL,'[aŋˈnoːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (2336,'agon','n','agon',NULL,NULL,'/ˈa.ɡoːn/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2345,'agonizo','v','agoniz agonizav agoniza',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (2360,'agricola','n','agricol',NULL,NULL,'[aˈɡrɪ.kɔ.ɫa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (2363,'agricolatio','n','agricolation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2385,'aiens','a','aient aient aient',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (2386,'aientia','n','aienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2396,'ala','n','al',NULL,NULL,'[ˈaː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2403,'alabastrites','n','alabastrit',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (2407,'alacer','a','alacr alacr alacr',NULL,NULL,'[ˈa.ɫa.kɛr]','aps---mn3-');
INSERT INTO latin_morpho VALUES (2409,'alacritas','n','alacritat',NULL,NULL,'[aˈɫa.krɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2411,'alapa','n','alap',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2417,'alatus','a','alat alat alat',NULL,NULL,'[aːˈɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2423,'album','n','alb',NULL,NULL,'[ˈaɫ.bũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2426,'albus','a','alb alb alb',NULL,NULL,'[ˈaɫ.bʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2430,'albarium','n','albari',NULL,NULL,'[aɫˈbaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2434,'albedo','n','albedin',NULL,NULL,'[aɫˈbeː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2435,'albens','a','albent albent albent',NULL,NULL,'[ˈaɫ.bẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (2436,'albesco','v','albesc - -',NULL,NULL,'[aɫˈbeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (2448,'albinus','n','albin',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (2455,'albor','n','albor',NULL,NULL,'[ˈaɫ.bɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2457,'albucum','n','albuc',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (2461,'albumen','n','albumin',NULL,NULL,'[aɫˈbuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (2462,'albumentum','n','albument',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (2465,'alce','n','alc',NULL,NULL,NULL,'n-s---fn1g');
INSERT INTO latin_morpho VALUES (2489,'alea','n','ale',NULL,NULL,'[ˈaː.ɫe.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2504,'ales','n','alit',NULL,NULL,NULL,'n-s---cn3-');
INSERT INTO latin_morpho VALUES (2505,'ales','a','alit alit alit',NULL,NULL,NULL,'aps---an3-');
INSERT INTO latin_morpho VALUES (2506,'alesco','v','alesc - -',NULL,NULL,'[aˈɫeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (2507,'aletudo','n','aletudin',NULL,NULL,'[a.ɫɛˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2510,'Alexandrea','n','Alexandre',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2513,'Alexandrinus','a','Alexandrin Alexandrin Alexandrin',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (2516,'algus','n','alg',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (2525,'algor','n','algor',NULL,NULL,'[ˈaɫ.ɡɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2528,'alium','n','ali',NULL,NULL,'[ˈa.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2529,'alius','a','ali ali ali',NULL,NULL,'[ˈa.li.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2531,'alias','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2533,'alibi','r',NULL,NULL,NULL,'[ˈa.lɪ.biː]','rp--------');
INSERT INTO latin_morpho VALUES (2544,'alienus','n','alien',NULL,NULL,'[a.lɪˈeː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (2546,'alieno','v','alien alienav alienat',NULL,NULL,'[a.lɪˈeː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (2549,'alienatio','n','alienation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2550,'alienigena','n','alienigen',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2555,'alifer','a','alifer alifer alifer',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (2556,'aliger','a','aliger aliger aliger',NULL,NULL,'[ˈaː.lɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (2558,'alimentum','n','aliment',NULL,NULL,'[a.lɪˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2561,'alimonia','n','alimoni',NULL,NULL,'[a.lɪˈmoː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2562,'alimonium','n','alimoni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (2563,'alio','r',NULL,NULL,NULL,'/ˈa.lioː/','rp--------');
INSERT INTO latin_morpho VALUES (2565,'alioquin','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2566,'aliorsum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2592,'aliquando','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2597,'aliquanto','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2603,'aliquantum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2622,'aliter','r',NULL,NULL,NULL,'[ˈa.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (2624,'alitura','n','alitur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2627,'aliubi','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2631,'aliuta','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2653,'allegoria','n','allegori',NULL,NULL,'[al.leːˈɡɔ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2655,'allegorice','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2707,'almus','a','alm alm alm',NULL,NULL,'[ˈaɫ.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2714,'alnus','n','aln',NULL,NULL,'[ˈaɫ.nʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (2719,'alogia','n','alogi',NULL,NULL,'[aˈɫɔ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2726,'alpha','n','-',NULL,NULL,'[ˈaɫ.pʰa]','n-s---nn--');
INSERT INTO latin_morpho VALUES (2727,'alphabetum','n','alphabet',NULL,NULL,'[aɫ.pʰaˈbeː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2729,'Alpinus','a','Alpin Alpin Alpin',NULL,NULL,'[aɫˈpiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2741,'altus','a','alt alt alt',NULL,NULL,'[ˈaɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2745,'altare','n','altar',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (2748,'alte','r',NULL,NULL,'rp--------=altum','/ˈal.teː/','rp--------');
INSERT INTO latin_morpho VALUES (2754,'alteratio','n','alteration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2756,'alterco','v','alterc altercav alterca',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (2757,'altercor','v','alterc altercat -',NULL,NULL,'[aɫˈtɛr.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (2759,'altercatio','n','altercation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2764,'alternus','a','altern altern altern',NULL,NULL,'[aɫˈtɛr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2765,'alterno','v','altern alternav alternat',NULL,NULL,'[aɫˈtɛr.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (2766,'alternatus','a','alternat alternat alternat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (2767,'alternatim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2768,'alternatio','n','alternation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2770,'alternis','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2782,'altilis','a','altil altil altil',NULL,NULL,'[ˈaɫ.tɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (2795,'altitudo','n','altitudin',NULL,NULL,'[aɫ.tɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2803,'altrix','n','altric',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2807,'alucinor','v','alucin alucinat -',NULL,NULL,'[aːˈɫuː.kɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (2825,'alumnor','v','alumn alumnat -',NULL,NULL,'/aˈlum.nor/','v1spid--1-');
INSERT INTO latin_morpho VALUES (2831,'aluta','n','alut',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (2834,'alvus','n','alv',NULL,NULL,'[ˈaɫ.wʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (2835,'alvarium','n','alvari',NULL,NULL,'[aɫˈwaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (2839,'alveare','n','alvear',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (2840,'alvearium','n','alveari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (2842,'alveolus','n','alveol',NULL,NULL,'/al.we.ˈo.lus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (2852,'amabilis','a','amabil amabil amabil',NULL,NULL,'[aˈmaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (2856,'amando','v','amand amandav amandat',NULL,NULL,'/aːˈman.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (2859,'amans','a','amant amant amant',NULL,NULL,'[ˈa.mãːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (2861,'amanuensis','n','amanuens',NULL,NULL,'[aː.ma.nʊˈẽː.sɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (2863,'amarus','a','amar amar amar',NULL,NULL,'[aˈmaː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2868,'amarantus','n','amarant',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (2876,'amaritudo','n','amaritudin',NULL,NULL,'[a.maː.rɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2883,'amasius','n','amasi',NULL,NULL,'[aˈmaː.si.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (2888,'amatus','a','amat amat amat',NULL,NULL,'/aˈmaː.tus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (2900,'Amazon','n','Amazon',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2905,'ambages','n','ambag',NULL,NULL,'/amˈbaː.ɡeːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2907,'ambago','n','ambagin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (2910,'ambedo','v','ambed ambed ambes',NULL,NULL,'[ˈam.bɛ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (2913,'ambio','v','amb ambi ambit',NULL,NULL,'/ˈam.bi.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (2916,'ambifarius','a','ambifari ambifari ambifari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (2920,'ambigo','v','ambig - -',NULL,NULL,'[ˈam.bɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (2922,'ambiguus','a','ambigu ambigu ambigu',NULL,NULL,'[amˈbɪ.ɡʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2923,'ambigue','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (2924,'ambiguitas','n','ambiguitat',NULL,NULL,'[am.bɪˈɡʊ.ɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2926,'ambitus','n','ambit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (2927,'ambitio','n','ambition',NULL,NULL,'[amˈbɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2928,'ambitiosus','a','ambitios ambitios ambitios',NULL,NULL,'[am.bɪ.tɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2940,'ambrosia','n','ambrosi',NULL,NULL,'[amˈbrɔ.si.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2948,'ambulo','v','ambul ambulav ambulat',NULL,NULL,'[ˈam.bʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (2951,'ambulatio','n','ambulation',NULL,NULL,'[am.bʊˈɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (2954,'ambulator','n','ambulator',NULL,NULL,'[am.bʊˈɫaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2955,'ambulatorius','a','ambulatori ambulatori ambulatori',NULL,NULL,'[am.bʊ.ɫaːˈtoː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (2957,'ambulatura','n','ambulatur',NULL,NULL,'[am.bʊ.ɫaːˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2959,'amburo','v','ambur ambuss ambust',NULL,NULL,'/amˈbuː.roː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (2969,'amens','a','ament ament ament',NULL,NULL,'[ˈaː.mẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (2972,'amentia','n','amenti',NULL,NULL,'[aːˈmɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (2978,'ames','n','amit',NULL,NULL,'[ˈa.mɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (2979,'amethystus','n','amethyst',NULL,NULL,'[a.mɛˈtʰʏs.tʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (2994,'amicus','n','amic',NULL,NULL,'[aˈmiː.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (3002,'amicio','v','amic amix amict',NULL,NULL,'[aˈmɪ.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (3005,'amicimen','n','amicimin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (3008,'amicitia','n','amiciti',NULL,NULL,'[a.miːˈkɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3009,'amicities','n','amiciti',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (3011,'amictus','n','amict',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (3012,'amictorium','n','amictori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3016,'amiculum','n','amicul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3023,'amissus','n','amiss',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (3025,'amissio','n','amission',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3030,'amitto','v','amitt amis amiss',NULL,NULL,'[aːˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3115,'amnestia','n','amnesti',NULL,NULL,'[amˈnɛs.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3120,'amnis','n','amn',NULL,NULL,'[ˈam.nɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (3122,'amoebaeus','a','amoebae amoebae amoebae',NULL,NULL,'[a.moe̯ˈbae̯.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3125,'amoenus','a','amoen amoen amoen',NULL,NULL,'[aˈmoe̯.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3127,'amoenitas','n','amoenitat',NULL,NULL,'[aˈmoe̯.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3130,'amolior','v','amol amolit -',NULL,NULL,'[aːˈmoː.li.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (3131,'amolitio','n','amolition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3135,'amor','n','amor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (3143,'amotio','n','amotion',NULL,NULL,'/aːˈmoː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3144,'amoveo','v','amov amov amot',NULL,NULL,'[aːˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (3147,'ampelos','n','ampel',NULL,'n-s---fn2-=ampelus','[ˈam.pɛ.ɫɔs]','n-s---mn2g');
INSERT INTO latin_morpho VALUES (3156,'amphemerinos','a','amphemerin amphemerin amphemerin',NULL,NULL,'[am.pʰeːˈmɛ.rɪ.nɔs]','aps---mn1g');
INSERT INTO latin_morpho VALUES (3158,'amphibius','a','amphibi amphibi amphibi',NULL,NULL,'[amˈpʰɪ.bi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3163,'amphibrachys','n','amphibrachy',NULL,NULL,'[amˈpʰɪ.bra.kʰʏs]','n-s---mn3g');
INSERT INTO latin_morpho VALUES (3178,'amphitheatrum','n','amphitheatr',NULL,NULL,'[am.pʰɪ.tʰɛˈaː.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (3182,'amphora','n','amphor',NULL,NULL,'[ˈam.pʰɔ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3185,'ampla','n','ampl',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3186,'amplo','v','ampl amplav ampla',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (3187,'amplus','a','ampl ampl ampl',NULL,NULL,'[ˈam.pɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3189,'amplector','v','amplect amplex -',NULL,NULL,'[amˈpɫɛk.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (3190,'amplexus','n','amplex',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (3192,'amplexor','v','amplex amplexat -',NULL,NULL,'/amˈplek.sor/','v1spid--1-');
INSERT INTO latin_morpho VALUES (3193,'amplio','v','ampli ampliav ampliat',NULL,NULL,'/ˈam.pli.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (3194,'ampliatio','n','ampliation',NULL,NULL,'/am.pliˈaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3197,'amplifico','v','amplific amplificav amplificat',NULL,NULL,'[amˈplɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (3198,'amplificatio','n','amplification',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3201,'amplifice','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (3202,'ampliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (3203,'amplitudo','n','amplitudin',NULL,NULL,'[am.plɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3206,'amplius','r',NULL,NULL,NULL,NULL,'rc--------');
INSERT INTO latin_morpho VALUES (3217,'amputo','v','amput amputav amputat',NULL,NULL,'[ˈam.pʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (3218,'amputatio','n','amputation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3222,'amuletum','n','amulet',NULL,NULL,'[a.mʊˈɫeː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (3228,'amusia','n','amusi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3235,'amygdala','n','amygdal',NULL,NULL,'[aˈmʏɡ.da.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3237,'amygdalus','n','amygdal',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (3238,'amygdalum','n','amygdal',NULL,NULL,'[aˈmʏɡ.da.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (3243,'amylum','n','amyl',NULL,NULL,'/ˈa.mʏ.lum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (3248,'anus','n','an',NULL,NULL,'[ˈaː.nʊs]','n-s---fn4-');
INSERT INTO latin_morpho VALUES (3263,'anachoreta','n','anachoret',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (3289,'analogia','n','analogi',NULL,NULL,'[a.naˈɫɔ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3317,'anas','n','an',NULL,NULL,'/ˈa.nas/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3322,'anastasis','n','anastas',NULL,NULL,'[aˈnas.ta.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (3326,'anathemo','v','anathem anathemav anathemat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (3327,'anathema','n','anathemat',NULL,NULL,'[aˈna.tʰɛ.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (3329,'anathematizo','v','anathematiz anathematizav anathematizat',NULL,NULL,'[a.na.tʰɛ.maˈtiː.zoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (3331,'anaticula','n','anaticul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3334,'anatocismus','n','anatocism',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (3335,'anatomia','n','anatomi',NULL,NULL,'/a.naˈto.mi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3339,'anatomicus','a','anatomic anatomic anatomic',NULL,NULL,'[a.naˈtɔ.mɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3353,'ancilla','n','ancill',NULL,NULL,'[aŋˈkɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3354,'ancillor','v','ancill ancillat -',NULL,NULL,'[aŋˈkɪl.lɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (3361,'anclo','v','ancl anclav ancla',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (3362,'anclabris','a','anclabr anclabr anclabr',NULL,NULL,'[ˈaŋ.kɫa.brɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (3365,'ancon','n','ancon',NULL,NULL,'[ˈaŋ.koːn]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (3389,'androgynus','n','androgyn',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (3390,'andron','n','andron',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (3399,'anesum','n','anes',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3401,'anethum','n','aneth',NULL,NULL,'[ˈa.nɛ.tʰũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (3406,'anfractum','n','anfract',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3407,'anfractus','n','anfract',NULL,NULL,'[ãːˈfrak.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (3410,'ango','v','ang - -',NULL,NULL,'/ˈaŋ.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (3413,'angarius','n','angari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (3417,'angelus','n','angel',NULL,NULL,'[ˈaŋ.ɡɛ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (3418,'angelicus','a','angelic angelic angelic',NULL,NULL,'[aŋˈɡɛ.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3421,'angina','n','angin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3423,'angiportum','n','angiport',NULL,'n-s---mn2-=angiportus',NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3426,'Anglia','n','Angli',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3433,'angor','n','angor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (3440,'anguilla','n','anguill',NULL,NULL,'[aŋˈɡᶣɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3448,'anguis','n','angu',NULL,NULL,'[ˈaŋ.ɡᶣɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (3451,'angulus','n','angul',NULL,NULL,'[ˈaŋ.ɡʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (3462,'angusto','v','angust angustav angustat',NULL,NULL,'[aŋˈɡʊs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (3463,'angustus','a','angust angust angust',NULL,NULL,'[aŋˈɡʊs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3472,'anhelo','v','anhel anhelav anhelat',NULL,NULL,'[anˈheː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (3473,'anhelitus','n','anhelit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (3487,'anilitas','n','anilitat',NULL,NULL,'/aˈniː.li.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3489,'anima','n','anim',NULL,NULL,'[ˈa.nɪ.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3490,'animus','n','anim',NULL,NULL,'[ˈa.nɪ.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (3491,'animo','v','anim animav animat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (3493,'animadversio','n','animadversion',NULL,NULL,'[a.nɪ.madˈwɛr.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3494,'animadversor','n','animadversor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (3495,'animadverto','v','animadvert animadvert animadvers',NULL,NULL,'[a.nɪ.madˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3496,'animaequus','a','animaequ animaequ animaequ',NULL,NULL,'[a.nɪˈmae̯.kʷʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3498,'animal','n','animal',NULL,NULL,'[ˈa.nɪ.maɫ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (3499,'animalis','a','animal animal animal',NULL,NULL,'[a.nɪˈmaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (3501,'animalis','n','animal',NULL,NULL,'[a.nɪˈmaː.lɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3506,'animatus','n','animat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (3507,'animatus','a','animat animat animat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (3510,'animax','a','animac animac animac',NULL,NULL,NULL,'aps---cn3-');
INSERT INTO latin_morpho VALUES (3512,'animosus','a','animos animos animos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (3513,'animose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (3514,'animositas','n','animositat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3521,'annus','n','ann',NULL,NULL,'[ˈan.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (3525,'annalis','n','annal',NULL,NULL,'[anˈnaː.lɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (3544,'anniversarius','a','anniversari anniversari anniversari',NULL,NULL,'[an.nɪ.wɛrˈsaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3552,'annosus','a','annos annos annos',NULL,NULL,'[anˈnoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3563,'annuus','a','annu annu annu',NULL,NULL,'[ˈan.nʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3593,'anomalia','n','anomali',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3601,'anquiro','v','anquir anquisiv anquisit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (3603,'ansa','n','ans',NULL,NULL,'[ˈãː.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3611,'ansula','n','ansul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3614,'antagonista','n','antagonist',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (3620,'ante','r',NULL,NULL,NULL,'[ˈan.tɛ]','rp--------');
INSERT INTO latin_morpho VALUES (3624,'anteactus','a','anteact anteact anteact',NULL,NULL,'[an.tɛˈak.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3628,'antecantamentum','n','antecantament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3630,'antecapio','v','antecap antecep antecept',NULL,NULL,'[an.tɛˈka.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (3631,'antecedo','v','anteced antecess antecess',NULL,NULL,'[an.tɛˈkeː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3632,'antecedens','a','antecedent antecedent antecedent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (3634,'antecello','v','antecell - -',NULL,NULL,'[an.tɛˈkɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3638,'antecessor','n','antecessor',NULL,NULL,'[an.tɛˈkɛs.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (3641,'antecursor','n','antecursor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (3642,'anteeo','v','- anteiv anteit','v--pna--4-=anteire v2spia--4-=anteis v3spia--4-=anteit v1ppia--4-=anteimus v2ppia--4-=anteitis v3ppia--4-=anteeunt v1siia--4-=anteibam v2siia--4-=anteibas v3siia--4-=anteibat v1piia--4-=anteibamus v2piia--4-=anteibatis v3piia--4-=anteibant v1sfia--4-=anteibo v2sfia--4-=anteibis v3sfia--4-=anteibit v1pfia--4-=anteibimus v2pfia--4-=anteibitis v3pfia--4-=anteibunt',NULL,'[anˈte.ɛ.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (3643,'antefero','v','antefer antetul antelat','v--pna--3-=anteferre v2spia--3-=antefers v3spia--3-=antefert v2ppia--3-=antefertis',NULL,'[anˈtɛ.fɛ.rɔ]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3648,'antegredior','v','antegred antegress -',NULL,NULL,'[an.tɛˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (3649,'antehabeo','v','antehab - -',NULL,NULL,'[an.tɛˈha.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (3652,'antelogium','n','antelogi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3653,'anteloquium','n','anteloqui',NULL,NULL,'/an.teˈlo.kʷi.um/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (3658,'anteludium','n','anteludi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3663,'antemna','n','antemn',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3682,'antepono','v','antepon anteposu anteposit',NULL,NULL,'[an.tɛˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3684,'antepotens','a','antepotent antepotent antepotent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (3690,'anteris','n','anterid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3694,'antesignanus','n','antesignan',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (3701,'antevenio','v','anteven anteven antevent',NULL,NULL,'[an.tɛˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (3704,'anteverto','v','antevert antevert antevers',NULL,NULL,'[an.tɛˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3763,'Antichristus','n','Antichrist',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (3765,'anticipo','v','anticip anticipav anticipat',NULL,NULL,'/anˈti.ki.poː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (3768,'anticipatio','n','anticipation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3784,'antidotum','n','antidot',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3815,'antiphona','n','antiphon',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3828,'antiquo','v','antiqu antiquav antiquat',NULL,NULL,'/anˈtiː.kʷoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (3829,'antiquus','a','antiqu antiqu antiqu',NULL,NULL,'[anˈtiː.kʷʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3837,'antiquitas','n','antiquitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3838,'antiquitus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (3853,'antisto','v','antist antistet -',NULL,NULL,'[anˈtɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (3856,'antistes','n','antistit',NULL,NULL,'[anˈtɪs.tɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (3859,'antistita','n','antistit',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3863,'antistrophe','n','antistroph',NULL,NULL,'[anˈtɪs.trɔ.pʰeː]','n-s---fn1g');
INSERT INTO latin_morpho VALUES (3869,'antlia','n','antli',NULL,NULL,'/ˈant.li.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3875,'antonomasia','n','antonomasi',NULL,NULL,'[an.tɔ.nɔˈma.si.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3876,'antrum','n','antr',NULL,NULL,'[ˈan.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (3881,'anulus','n','anul',NULL,NULL,'[ˈaː.nʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (3889,'anxius','a','anxi anxi anxi',NULL,NULL,'[ˈaːŋk.si.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3892,'anxie','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (3893,'anxietas','n','anxietat',NULL,NULL,'[aːŋkˈsi.ɛ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3894,'anxietudo','n','anxietudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3897,'anxitudo','n','anxitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3909,'aper','n','apr',NULL,NULL,'[ˈa.pɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (3912,'aperio','v','aper aperu apert',NULL,NULL,'[aˈpɛ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (3918,'aperto','v','apert apertav aperta',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (3919,'apertus','a','apert apert apert',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (3920,'aperte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (3922,'apertio','n','apertion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3924,'apertura','n','apertur',NULL,NULL,'/a.perˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (3926,'apex','n','apic',NULL,NULL,'[ˈa.pɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (3935,'aphorismus','n','aphorism',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (3942,'aphronitrum','n','aphronitr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3946,'apio','v','ap - apt',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (3954,'apiarius','n','apiari',NULL,NULL,'[a.pɪˈaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (3955,'apiarium','n','apiari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (3967,'apis','n','ap',NULL,NULL,'[ˈa.pɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (3968,'apiscor','v','apisc apt -',NULL,NULL,'[aˈpiːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (3971,'apluda','n','aplud',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (3976,'apocalypsis','n','apocalyps',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (3985,'apocope','n','apocop',NULL,NULL,NULL,'n-s---fn1g');
INSERT INTO latin_morpho VALUES (3991,'apodicticus','a','apodictic apodictic apodictic',NULL,NULL,'[a.pɔˈdiːk.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (3992,'apodixis','n','apodix',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (3997,'apographon','n','apograph',NULL,NULL,NULL,'n-s---nn2g');
INSERT INTO latin_morpho VALUES (4005,'Apollo','n','Apollin',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (4006,'apologus','n','apolog',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (4007,'apologo','v','apolog apologav apologat',NULL,NULL,'/aˈpo.lo.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (4010,'apologia','n','apologi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4017,'apoplecticus','a','apoplectic apoplectic apoplectic',NULL,NULL,'[a.pɔˈpɫeːk.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4019,'apoplexis','n','apoplex',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (4024,'apopsis','n','apops',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (4025,'aporia','n','apori',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4033,'apostasia','n','apostasi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4034,'apostata','n','apostat',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (4038,'apostema','n','apostemat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (4040,'apostolus','n','apostol',NULL,NULL,'[aˈpɔs.tɔ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4042,'apostolatus','n','apostolat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (4044,'apostolicus','a','apostolic apostolic apostolic',NULL,NULL,'[a.pɔsˈtɔ.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4050,'apostrophos','n','apostroph',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (4053,'apotheco','v','apothec apothecav apothecat',NULL,NULL,'[a.pɔˈtʰeː.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4055,'apotheosis','n','apotheos',NULL,NULL,'[a.pɔ.tʰɛˈoː.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (4066,'apparo','v','appar apparav apparat',NULL,NULL,'/ˈap.pa.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (4067,'appareo','v','appar apparu apparit',NULL,NULL,'/apˈpaː.re.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (4070,'apparatus','n','apparat',NULL,NULL,'[ap.paˈraː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (4071,'apparatus','a','apparat apparat apparat',NULL,NULL,'[ap.paˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4072,'apparate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (4078,'apparentia','n','apparenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4081,'apparitio','n','apparition',NULL,NULL,'/ap.paːˈri.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4087,'appello','v','appell appul appuls',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (4092,'appellatio','n','appellation',NULL,NULL,'[ap.pɛlˈlaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4097,'appendo','v','append append appens',NULL,NULL,'[apˈpɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (4102,'appendix','n','appendic',NULL,NULL,'[apˈpɛn.dɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4106,'appeto','v','appet appetiv appetit',NULL,NULL,'[ˈap.pɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (4107,'appetens','a','appetent appetent appetent',NULL,NULL,'[ˈap.pɛ.tẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (4108,'appetenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (4109,'appetentia','n','appetenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4110,'appetibilis','a','appetibil appetibil appetibil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (4112,'appetitus','n','appetit',NULL,NULL,'[ap.pɛˈtiː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (4113,'appetitio','n','appetition',NULL,NULL,'[ap.pɛˈtiː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4121,'applaudo','v','applaud applaus applaus',NULL,NULL,'[apˈpɫau̯.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (4125,'applico','v','applic applicu applicit',NULL,NULL,'[ˈap.plɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4136,'appono','v','appon apposu apposit',NULL,NULL,'/apˈpoː.noː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (4138,'apporto','v','apport apportav apportat',NULL,NULL,'[apˈpɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4142,'appositus','n','apposit',NULL,NULL,'[apˈpɔ.sɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (4143,'appositus','a','apposit apposit apposit',NULL,NULL,'[apˈpɔ.sɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4145,'appositio','n','apposition',NULL,NULL,'[ap.pɔˈsɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4147,'appotus','a','appot appot appot',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (4148,'apprecor','v','apprec apprecat -',NULL,NULL,'[ˈap.prɛ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (4153,'apprehendo','v','apprend apprehend apprehens',NULL,NULL,'[ap.prɛˈhɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (4165,'approbus','a','approb approb approb',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (4166,'approbo','v','approb approbav approbat',NULL,NULL,'[ˈap.prɔ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4167,'approbatio','n','approbation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4173,'appropero','v','approper approperav approperat',NULL,NULL,'[apˈprɔ.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4174,'appropio','v','appropi appropiav appropiat',NULL,NULL,'[apˈprɔ.pi.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4175,'appropinquo','v','appropinqu appropinquav appropinquat',NULL,NULL,'[ap.prɔˈpɪŋ.kʷoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4179,'approximo','v','approxim approximav approxima',NULL,NULL,'[apˈprɔk.sɪ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4180,'appugno','v','appugn appugnav appugnat',NULL,NULL,'[apˈpʊŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4181,'appulsus','n','appuls',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (4282,'apto','v','apt aptav aptat',NULL,NULL,'/ˈap.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (4283,'aptus','a','apt apt apt',NULL,NULL,'[ˈap.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4303,'aqua','n','aqu',NULL,NULL,'/ˈa.kʷa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4310,'aqualiculus','n','aqualicul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (4331,'aquifolium','n','aquifoli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (4335,'aquila','n','aquil',NULL,NULL,'[ˈa.kᶣɪ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4348,'aquilo','n','aquilon',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4365,'ara','n','ar',NULL,NULL,'/ˈaː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4369,'aro','v','ar arav arat',NULL,NULL,'/ˈa.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (4391,'araneum','n','arane',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (4402,'aratio','n','aration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4404,'arator','n','arator',NULL,NULL,'[aˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (4407,'aratrum','n','aratr',NULL,NULL,'[aˈraː.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (4410,'arbilla','n','arbill',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4412,'arbiter','n','arbitr',NULL,NULL,'[ˈar.bɪ.tɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (4414,'arbitra','n','arbitr',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4415,'arbitro','v','arbitr arbitrav arbitra',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (4416,'arbitror','v','arbitr arbitrat -',NULL,NULL,'[ˈar.bɪ.trɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (4418,'arbitrarius','a','arbitrari arbitrari arbitrari',NULL,NULL,'[ar.bɪˈtraː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4420,'arbitratus','n','arbitrat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (4424,'arbitrium','n','arbitri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (4426,'arbor','n','arbor',NULL,NULL,'[ˈar.bɔr]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4435,'arbuscula','n','arbuscul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4438,'arbusto','v','arbust arbustav arbusta',NULL,NULL,'/arˈbus.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (4444,'arca','n','arc',NULL,NULL,'/ˈar.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4447,'arcus','n','arc',NULL,NULL,'[ˈar.kʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (4448,'arceo','v','arc arcu -',NULL,NULL,'/ˈar.ke.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (4467,'arcesso','v','arcess arcessiv arcessit',NULL,NULL,'[arˈkɛs.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (4469,'arcessitus','n','arcessit',NULL,NULL,'[ar.kɛsˈsiː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (4471,'arcessitio','n','arcessition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4472,'arcessitor','n','arcessitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (4478,'archaicus','a','archaic archaic archaic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (4479,'archangelus','n','archangel',NULL,NULL,'[arˈkʰaŋ.ɡɛ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4482,'archetypum','n','archetyp',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (4484,'archetypus','a','archetyp archetyp archetyp',NULL,NULL,'/ar.kʰe.ˈty.pus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (4504,'archiepiscopus','n','archiepiscop',NULL,NULL,'[ar.kʰi.ɛˈpɪs.kɔ.pʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4528,'architectus','n','architect',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (4529,'architecto','v','architect - architectat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (4530,'architector','v','architect architectat -',NULL,NULL,'/ar.kʰiˈtek.tor/','v1spid--1-');
INSERT INTO latin_morpho VALUES (4531,'architecton','n','architecton',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (4532,'architectonice','n','architectonic',NULL,NULL,NULL,'n-s---fn1g');
INSERT INTO latin_morpho VALUES (4533,'architectonicus','a','architectonic architectonic architectonic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (4534,'architectura','n','architectur',NULL,NULL,'[ar.kʰɪ.tɛkˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4536,'archivum','n','archiv',NULL,NULL,'[arˈkʰiː.wũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (4557,'arcticus','a','arctic arctic arctic',NULL,NULL,'/ˈark.ti.kus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (4560,'arctous','a','arcto arcto arcto',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (4568,'arcuatus','a','arcuat arcuat arcuat',NULL,NULL,'[ar.kʊˈaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4573,'arcuatura','n','arcuatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4584,'ardeo','v','ard ars ars',NULL,NULL,'/ˈaːr.de.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (4586,'ardea','n','arde',NULL,NULL,'/ˈar.de.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4588,'ardens','a','ardent ardent ardent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (4589,'ardenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (4591,'ardesco','v','ardesc - -',NULL,NULL,'/aːrˈdeːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (4594,'ardiola','n','ardiol',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4595,'ardor','n','ardor',NULL,NULL,'[ˈar.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (4597,'arduus','a','ardu ardu ardu',NULL,NULL,'[ˈar.dʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4598,'arduitas','n','arduitat',NULL,NULL,'[arˈdʊ.ɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4600,'area','n','are',NULL,NULL,'/ˈaː.re.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4622,'aresco','v','aresc aru -',NULL,NULL,'/aːˈreːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (4633,'argentum','n','argent',NULL,NULL,'[arˈɡɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (4634,'argentaria','n','argentari',NULL,NULL,'[ar.ɡɛnˈtaː.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4635,'argentarius','n','argentari',NULL,NULL,'[ar.ɡɛnˈtaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4638,'argentarius','a','argentari argentari argentari',NULL,NULL,'[ar.ɡɛnˈtaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4646,'Argentoratus','n','Argentorat',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (4649,'argilla','n','argill',NULL,NULL,'[arˈɡɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4650,'argillaceus','a','argillace argillace argillace',NULL,NULL,'[ar.ɡɪlˈlaː.ke.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4655,'arguo','v','argu argu argut',NULL,NULL,'[ˈar.ɡʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (4656,'argumentum','n','argument',NULL,NULL,'[ar.ɡuːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (4658,'argumentor','v','argument argumentat -',NULL,NULL,'[ar.ɡuːˈmɛn.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (4668,'argutus','a','argut argut argut',NULL,NULL,'[arˈɡuː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4669,'argutor','v','argut argutat -',NULL,NULL,'/arˈɡuː.tor/','v1spid--1-');
INSERT INTO latin_morpho VALUES (4671,'argutator','n','argutator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (4674,'argute','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (4677,'argutulus','a','argutul argutul argutul',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (4694,'aridus','a','arid arid arid',NULL,NULL,'[ˈaː.rɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4696,'ariditas','n','ariditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4699,'ariena','n','arien',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4700,'aries','n','ariet',NULL,NULL,'/ˈa.ri.eːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (4701,'arieto','v','ariet arietav arietat',NULL,NULL,'[aˈri.ɛ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (4703,'arietatio','n','arietation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4715,'arista','n','arist',NULL,NULL,'[aˈrɪs.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4726,'arithmetica','n','arithmetic',NULL,NULL,'[a.rɪtʰˈmeː.tɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4729,'arithmeticus','a','arithmetic arithmetic arithmetic',NULL,NULL,'[a.rɪtʰˈmeː.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4730,'aritudo','n','aritudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4731,'armus','n','arm',NULL,NULL,'[ˈar.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4733,'armo','v','arm armav armat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (4736,'armamentarium','n','armamentari',NULL,NULL,'[ar.maː.mɛnˈtaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (4739,'armarium','n','armari',NULL,NULL,'[arˈmaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (4746,'Armenia','n','Armeni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4751,'armentum','n','arment',NULL,NULL,'[arˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (4755,'armenticius','a','armentici armentici armentici',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (4766,'armilla','n','armill',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4770,'armipotens','a','armipotent armipotent armipotent',NULL,NULL,'[arˈmɪ.pɔ.tẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (4786,'aroma','n','aromat',NULL,NULL,'/aˈroː.ma/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (4789,'aromaticus','a','aromatic aromatic aromatic',NULL,NULL,'[a.roːˈma.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4806,'arra','n','arr',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4807,'arrabo','n','arrabon',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (4848,'ars','n','art',NULL,NULL,'/ars/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (4857,'artus','n','art',NULL,NULL,'[ˈar.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (4858,'arto','v','art artav artat',NULL,NULL,'/ˈar.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (4859,'artus','a','art art art',NULL,'aps---mn1-=arctus aps---fn1-=arcta aps---nn1-=artcum','[ˈar.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (4866,'arteria','n','arteri',NULL,NULL,'/arˈteː.ri.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4874,'arthritis','n','arthritid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4879,'articulus','n','articul',NULL,NULL,'[arˈtɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4881,'articulo','v','articul articulav articulat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (4892,'artificium','n','artifici',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (4924,'arvum','n','arv',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (4931,'arvina','n','arvin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4933,'arx','n','arc',NULL,NULL,'/arks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (4936,'as','n','ass',NULL,NULL,'/as/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (4946,'ascalpo','v','ascalp - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (4949,'ascella','n','ascell',NULL,NULL,'[asˈkɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4950,'ascendo','v','ascend ascend ascens',NULL,NULL,'[asˈkɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (4953,'ascensus','n','ascens',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (4954,'ascensio','n','ascension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (4962,'ascetria','n','ascetri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (4967,'ascisco','v','ascisc asciv ascit',NULL,NULL,'/asˈkiːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (4975,'ascribo','v','ascrib ascrips ascript',NULL,NULL,'/aːsˈkriː.boː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (4983,'asellus','n','asell',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (4987,'Asia','n','Asi',NULL,NULL,'ˈa.si.a','n-s---fn1-');
INSERT INTO latin_morpho VALUES (4989,'Asianus','a','Asian',NULL,NULL,'aː.sɪˈaː.nʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (4990,'Asiaticus','a','Asiatic',NULL,NULL,'aː.sɪˈaː.tɪ.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (4991,'asilus','n','asil',NULL,NULL,'[aˈsiː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4993,'asinus','n','asin',NULL,NULL,'[ˈa.sɪ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (4999,'asininus','a','asinin asinin asinin',NULL,NULL,'[a.sɪˈniː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5005,'asotia','n','asoti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5011,'asparagus','n','asparag',NULL,NULL,'[asˈpa.ra.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5014,'aspectus','n','aspect',NULL,NULL,'[asˈpɛk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (5015,'aspecto','v','aspect aspectav aspectat',NULL,NULL,'[asˈpɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5016,'aspectabilis','a','aspectabil aspectabil aspectabil',NULL,'aps---cn3-=adspectabilis aps---nn3-=adspectabile','[as.pɛkˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (5019,'aspello','v','aspell aspul aspuls',NULL,NULL,'[asˈpɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (5022,'aspero','v','asper asperav asperat',NULL,NULL,'/ˈas.pe.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (5023,'asper','a','asper asper asper',NULL,NULL,'[ˈas.pɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (5025,'aspere','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (5026,'aspergo','v','asperg aspers aspers',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (5028,'aspergo','n','aspergin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5029,'asperitas','n','asperitat',NULL,NULL,'[asˈpɛ.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5031,'aspernor','v','aspern aspernat -',NULL,NULL,'[asˈpɛr.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (5032,'aspernabilis','a','aspernabil aspernabil aspernabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (5034,'aspernanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (5035,'aspernatio','n','aspernation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5042,'asphodelus','n','asphodel',NULL,NULL,'/asˈpʰo.de.lus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5044,'aspicio','v','aspic aspex aspect',NULL,NULL,'[asˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (5046,'aspiro','v','aspir aspirav aspirat',NULL,NULL,'/asˈpiː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (5048,'aspiratio','n','aspiration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5053,'aspis','n','aspid',NULL,NULL,'[ˈas.pɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5059,'asporto','v','asport asportav asportat',NULL,NULL,'/asˈpor.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (5060,'asportatio','n','asportation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5072,'asso','v','ass assav assat',NULL,NULL,'/ˈas.soː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (5102,'asser','n','asser',NULL,NULL,'[ˈas.sɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (5185,'assula','n','assul',NULL,NULL,'[ˈas.sʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5200,'astus','n','ast',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (5202,'astacus','n','astac',NULL,NULL,'[ˈas.ta.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5203,'astaphis','n','astaphid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5215,'asteriscus','n','asterisc',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (5219,'asthma','n','asthmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (5221,'asticus','a','astic astic astic',NULL,NULL,'/ˈas.ti.kus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (5229,'astrum','n','astr',NULL,NULL,'[ˈas.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5230,'astragalus','n','astragal',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (5239,'astricus','a','astric astric astric',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (5246,'astrifer','a','astrifer astrifer astrifer',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (5249,'astriger','a','astriger astriger astriger',NULL,NULL,'[ˈas.trɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (5256,'astrologus','n','astrolog',NULL,NULL,'[asˈtrɔ.ɫɔ.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5257,'astrologia','n','astrologi',NULL,NULL,'[as.trɔˈɫɔ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5260,'astronomus','n','astronom',NULL,NULL,'/asˈtro.no.mus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5261,'astronomia','n','astronomi',NULL,NULL,'[as.trɔˈnɔ.mi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5269,'astula','n','astul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5274,'astute','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (5275,'astutia','n','astuti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5281,'asylum','n','asyl',NULL,NULL,'[aˈsyː.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5293,'atavus','n','atav',NULL,NULL,'[ˈa.ta.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5299,'ater','a','  ',NULL,NULL,'[ˈaː.tɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (5302,'atheos','n','athe',NULL,NULL,'[ˈa.tʰe.ɔs]','n-s---mn2g');
INSERT INTO latin_morpho VALUES (5308,'Atheniensis','a','Atheniens Atheniens Atheniens',NULL,NULL,'a.tʰeː.nɪˈẽː.sɪs','aps---cn3-');
INSERT INTO latin_morpho VALUES (5313,'athlum','n','athl',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (5315,'athleta','n','athlet',NULL,NULL,'[aːtʰˈɫeː.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (5316,'athletica','n','athletic',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5321,'atlas','n','atlant',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (5325,'atocium','n','atoci',NULL,NULL,'[aˈtɔ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5327,'atomus','n','atom',NULL,'n-s---fn2-=atomos','[ˈa.tɔ.mʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (5329,'atomus','a','atom atom atom',NULL,NULL,'[ˈa.tɔ.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5338,'atramentarium','n','atramentari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (5340,'atrium','n','atri',NULL,NULL,'[ˈaː.tri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5345,'atriensis','n','atriens',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (5351,'atritas','n','atritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5352,'atrocitas','n','atrocitat',NULL,NULL,'[aˈtroː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5353,'atrociter','r',NULL,NULL,NULL,'[aˈtroː.kɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (5355,'atrophia','n','atrophi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5357,'atrotus','a','atrot atrot atrot',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (5358,'atrox','a','atroc atroc atroc',NULL,NULL,'/ˈa.troːks/','aps---an3i');
INSERT INTO latin_morpho VALUES (5364,'attactus','n','attact',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (5365,'attagus','n','attag',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (5369,'attamino','v','attamin attaminav attamina',NULL,NULL,'[atˈtaː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5374,'attegia','n','attegi',NULL,NULL,'[atˈtɛ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5377,'attempero','v','attemper attemperav attemperat',NULL,NULL,'[atˈtɛm.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5382,'attento','v','attent attentav attentat',NULL,NULL,'[atˈtɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5383,'attentus','a','attent attent attent',NULL,NULL,'[atˈtɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5385,'attentatio','n','attentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5386,'attente','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (5387,'attentio','n','attention',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5388,'attenuo','v','attenu attenuav attenuat',NULL,NULL,'[atˈtɛ.nʊ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5389,'attenuatus','a','attenuat attenuat attenuat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (5391,'attenuatio','n','attenuation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5392,'attero','v','atter attriv attrit',NULL,NULL,'[ˈat.tɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (5397,'attestor','v','attest attestat -',NULL,NULL,'[atˈtɛs.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (5399,'attestatio','n','attestation',NULL,NULL,'[at.tɛsˈtaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5401,'Atticus','a','Attic Attic Attic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (5407,'attillo','v','attill attillav attilla',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (5409,'attineo','v','attin attinu attent',NULL,NULL,'[atˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (5410,'attingo','v','atting attinx attinct',NULL,NULL,'[atˈtɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (5412,'attinguo','v','attingu - attinct',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (5414,'attolero','v','attoler attolerav attolera',NULL,NULL,'[atˈtɔ.ɫɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5415,'attollo','v','attoll - -',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (5416,'attono','v','atton attonu attonit',NULL,NULL,'[ˈat.tɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5417,'attondeo','v','attond attond attons',NULL,NULL,'[atˈtɔn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (5423,'attorreo','v','attorr - -',NULL,NULL,'[atˈtɔr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (5427,'attractio','n','attraction',NULL,NULL,'/atˈtrak.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5430,'attraho','v','attrah attrax attract',NULL,NULL,'/ˈat.tra.hoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (5431,'attrecto','v','attrect attrectav attrectat',NULL,NULL,'[atˈtrɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5436,'attribuo','v','attribu attribu attribut',NULL,NULL,'[atˈtrɪ.bʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (5440,'attributio','n','attribution',NULL,NULL,'[at.trɪˈbuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5441,'attritus','n','attrit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (5442,'attritus','a','attrit attrit attrit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (5444,'attritio','n','attrition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5445,'attuor','v','attu - -',NULL,NULL,NULL,'v1spid--3-');
INSERT INTO latin_morpho VALUES (5460,'auctus','n','auct',NULL,NULL,'[ˈau̯k.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (5461,'aucto','v','auct auctav auctat',NULL,NULL,'/ˈau̯k.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (5463,'auctarium','n','auctari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (5465,'auctifer','a','auctifer auctifer auctifer',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (5467,'auctifico','v','auctific auctificav auctifica',NULL,NULL,'[au̯kˈtɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5468,'auctio','n','auction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5475,'auctor','n','auctor',NULL,NULL,'[ˈau̯k.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (5476,'auctoro','v','auctor auctorav auctorat',NULL,NULL,'/au̯kˈtoː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (5480,'auctoramentum','n','auctorament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (5483,'auctoritas','n','auctoritat',NULL,NULL,'[au̯kˈtoː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5503,'aucupatio','n','aucupation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5508,'audacia','n','audaci',NULL,NULL,'/au̯ˈdaː.ki.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5509,'audaciter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (5511,'audaculus','a','audacul audacul audacul',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (5512,'audax','a','audac audac audac',NULL,NULL,'/ˈau̯.daːks/','aps---an3i');
INSERT INTO latin_morpho VALUES (5514,'audens','a','audent audent audent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (5516,'audentia','n','audenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5517,'audio','v','aud audi audit',NULL,NULL,'/ˈau̯.di.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (5518,'audiens','n','audient',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (5520,'audientia','n','audienti',NULL,NULL,'[au̯.dɪˈɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5523,'auditio','n','audition',NULL,NULL,'/au̯ˈdiː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5525,'auditor','n','auditor',NULL,NULL,'[au̯ˈdiː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (5527,'auditorium','n','auditori',NULL,NULL,'[au̯.diːˈtoː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5531,'aufero','v','aufer abstul ablat','v--pna--3-=auferre v2spia--3-=aufers v3spia--3-=aufert v2ppia--3-=aufertis',NULL,'[ˈau̯.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (5533,'aufugio','v','aufug aufug -',NULL,NULL,'[au̯ˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (5535,'augeo','v','aug aux auct',NULL,NULL,'/ˈau̯.ɡe.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (5537,'augesco','v','augesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (5538,'augifico','v','augific augificav augifica',NULL,NULL,'[au̯ˈɡɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5541,'augmen','n','augmin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (5542,'augmentum','n','augment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (5543,'augmento','v','augment augmentav augmenta',NULL,NULL,'[au̯ɡˈmɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5544,'augmentatio','n','augmentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5545,'augur','n','augur',NULL,NULL,'[ˈau̯.ɡʊr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (5546,'auguro','v','augur augurav augurat',NULL,NULL,'[ˈau̯.ɡʊ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5557,'augurium','n','auguri',NULL,NULL,'[au̯ˈɡʊ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5564,'augustus','a','august august august',NULL,NULL,'[au̯ˈɡʊs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5569,'auguste','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (5572,'aula','n','aul',NULL,NULL,'[ˈau̯.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5577,'aulax','n','aulac',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5595,'aura','n','aur',NULL,NULL,'/ˈau̯.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5596,'aurum','n','aur',NULL,NULL,'[ˈau̯.rũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5597,'auro','v','aur aurav aurat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (5608,'auratura','n','auratur',NULL,NULL,'/au̯.raːˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5611,'aureus','a','aure aure aure',NULL,NULL,'[ˈau̯.re.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5627,'auricula','n','auricul',NULL,NULL,'[au̯ˈrɪ.kʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5632,'aurifex','n','aurific',NULL,NULL,'[ˈau̯.rɪ.fɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (5637,'auriga','n','aurig',NULL,NULL,'/au̯ˈriː.ɡa/','n-s---mn1-');
INSERT INTO latin_morpho VALUES (5655,'auris','n','aur',NULL,NULL,'[ˈau̯.rɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (5657,'auritus','a','aurit aurit aurit',NULL,NULL,'[au̯ˈriː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5660,'aurora','n','auror',NULL,NULL,'/au̯ˈroː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5667,'aurugo','n','aurugin',NULL,NULL,'/au̯ˈruː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5668,'aurula','n','aurul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5670,'ausum','n','aus',NULL,NULL,'[ˈau̯.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5677,'ausculto','v','auscult auscultav auscultat',NULL,NULL,'[au̯sˈkʊɫ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5681,'auscultator','n','auscultator',NULL,NULL,'[au̯s.kʊɫˈtaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (5682,'auspex','n','auspic',NULL,NULL,'[ˈau̯s.pɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (5689,'auspicatus','a','auspicat auspicat auspicat',NULL,NULL,'[au̯s.pɪˈkaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5691,'auspicium','n','auspici',NULL,NULL,'[au̯sˈpɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5693,'austerus','a','auster auster auster',NULL,NULL,'[au̯sˈteː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5695,'Auster','n','Auster',NULL,NULL,'[ˈau̯s.tɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (5699,'austeritas','n','austeritat',NULL,NULL,'[au̯sˈteː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5703,'australis','a','austral austral austral',NULL,NULL,'[au̯sˈtraː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (5706,'austrinus','a','austrin austrin austrin',NULL,NULL,'[au̯sˈtriː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5707,'austrinalis','a','austrinal austrinal austrinal',NULL,NULL,NULL,'aps---cn3-');
INSERT INTO latin_morpho VALUES (5719,'authenticus','a','authentic authentic authentic',NULL,NULL,'[au̯ˈtʰɛn.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5738,'autochthon','n','autochthon',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (5750,'automatum','n','automat',NULL,NULL,'[au̯ˈtɔ.ma.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5772,'autumo','v','autum autumav autumat',NULL,NULL,'[ˈau̯.tʊ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5773,'autumnus','n','autumn',NULL,NULL,'[au̯ˈtʊm.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5774,'autumnus','a','autumn autumn autumn',NULL,NULL,'[au̯ˈtʊm.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5780,'autumnitas','n','autumnitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5782,'auxilium','n','auxili',NULL,NULL,'[au̯kˈsɪ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5784,'auxilior','v','auxili auxiliat -',NULL,NULL,'[au̯kˈsɪ.li.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (5791,'auxiliatus','n','auxiliat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (5793,'auxiliator','n','auxiliator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (5797,'avus','n','av',NULL,NULL,'[ˈa.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (5799,'aveo','v','av - -',NULL,'v1spia--2-=haveo v--pna--2-=havere',NULL,'v1spia--2-');
INSERT INTO latin_morpho VALUES (5802,'avarus','a','avar avar avar',NULL,NULL,'[aˈwaː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5804,'avare','r',NULL,NULL,NULL,'/aˈwaː.reː/','rp--------');
INSERT INTO latin_morpho VALUES (5805,'avariter','r',NULL,NULL,NULL,'[aˈwaː.rɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (5806,'avaritia','n','avariti',NULL,NULL,'[a.waːˈrɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5809,'aveho','v','aveh avex avect',NULL,NULL,'[ˈaː.wɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (5814,'avena','n','aven',NULL,NULL,'/aˈweː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5821,'averrunco','v','averrunc averruncav averruncat',NULL,NULL,'[aː.wɛrˈrʊŋ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5826,'aversatio','n','aversation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5833,'averto','v','avert avert avers',NULL,NULL,'[aːˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (5835,'avia','n','avi',NULL,'n-s---fn1-=ava',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (5845,'avidus','a','avid avid avid',NULL,NULL,'[ˈa.wɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (5846,'avide','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (5847,'aviditas','n','aviditat',NULL,NULL,'[aˈwɪ.dɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (5848,'aviditer','r',NULL,NULL,NULL,'[aˈwɪ.dɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (5850,'avis','n','av',NULL,NULL,'[ˈa.wɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (5854,'avoco','v','avoc avocav avocat',NULL,NULL,'[ˈaː.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (5855,'avocamentum','n','avocament',NULL,NULL,'[aː.wɔ.kaːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5874,'axilla','n','axill',NULL,NULL,'[akˈsɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5877,'axioma','n','axiomat',NULL,NULL,'[ak.sɪˈoː.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (5878,'axis','n','ax',NULL,NULL,'[ˈak.sɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (5910,'Babylon','n','Babylon',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (5921,'bacca','n','bacc',NULL,NULL,'/ˈbaːk.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (5931,'Bacchus','n','Bacch',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (5967,'baculum','n','bacul',NULL,NULL,'[ˈba.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (5971,'badizo','v','badiz badizav badizat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (5972,'baeto','v','baet - -',NULL,NULL,'/ˈbae̯.toː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (5986,'balo','v','bal balav balat',NULL,NULL,'/ˈbaː.loː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (5989,'balanus','n','balan',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (5998,'balatro','n','balatron',NULL,NULL,'[baˈɫaː.troː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (6001,'balbe','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (6002,'balbutio','v','balbut balbutiv -',NULL,NULL,'[baɫˈbuː.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (6028,'balito','v','balit balitav balitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (6029,'ballo','v','ball ballav balla',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (6030,'ballaena','n','ballaen',NULL,NULL,'/balˈlae̯.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6046,'balneum','n','balne',NULL,NULL,'[ˈbaɫ.ne.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6056,'balsamum','n','balsam',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (6059,'balteus','n','balte',NULL,NULL,'[ˈbaɫ.te.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6083,'baptisma','n','baptismat',NULL,NULL,'[bapˈtɪs.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (6085,'baptista','n','baptist',NULL,NULL,'[bapˈtɪs.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (6086,'baptisterium','n','baptisteri',NULL,NULL,'[bap.tɪsˈteː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6087,'baptizo','v','baptiz baptizav baptizat',NULL,NULL,'/bapˈtiː.zoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (6088,'baptizatio','n','baptization',NULL,NULL,'/bap.tiːˈzaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (6090,'barathrum','n','barathr',NULL,NULL,'[ˈba.ra.tʰrũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6092,'barba','n','barb',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6100,'barbaria','n','barbari',NULL,NULL,'/barˈba.ri.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6104,'barbaricarius','n','barbaricari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (6116,'barbitos','n','barbit',NULL,NULL,NULL,'n-s---mn2g');
INSERT INTO latin_morpho VALUES (6118,'barbitium','n','barbiti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (6122,'barcala','n','barcal',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6123,'bardus','n','bard',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (6124,'bardus','a','bard bard bard',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (6126,'bardocucullus','n','bardocucull',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (6131,'baro','n','baron',NULL,NULL,'/ˈbaː.roː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (6138,'barrus','n','barr',NULL,NULL,'[ˈbar.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6152,'bascauda','n','bascaud',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6154,'basium','n','basi',NULL,NULL,'[ˈbaː.si.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6155,'basio','v','basi basiav basiat',NULL,NULL,'/ˈbaː.si.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (6156,'basiatio','n','basiation',NULL,NULL,'[baː.sɪˈaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (6162,'basilica','n','basilic',NULL,NULL,'[baˈsɪ.lɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6173,'basiliscus','n','basilisc',NULL,NULL,'[ba.sɪˈlɪs.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6176,'basis','n','bas',NULL,NULL,'[ˈba.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (6200,'batioca','n','batioc',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6210,'battuo','v','battu battu -',NULL,NULL,'[ˈbat.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (6226,'beo','v','be beav beat',NULL,NULL,'/ˈbe.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (6230,'beatus','a','beat beat beat',NULL,NULL,'[bɛˈaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6235,'beatitas','n','beatitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (6236,'beatitudo','n','beatitudin',NULL,NULL,'[be.aː.tɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (6239,'bebo','v','beb bebav bebat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (6243,'beccus','n','becc',NULL,NULL,'[ˈbɛk.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6254,'belbus','n','belb',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (6260,'bellum','n','bell',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (6261,'bello','v','bell bellav bellat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (6262,'bellus','a','bell bell bell',NULL,NULL,'[ˈbɛl.lʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6265,'bellator','n','bellator',NULL,NULL,'/belˈlaː.tor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (6268,'bellatorius','a','bellatori bellatori bellatori',NULL,NULL,'/bel.laːˈtoː.ri.us/','aps---mn1-');
INSERT INTO latin_morpho VALUES (6273,'belle','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (6278,'bellicosus','a','bellicos bellicos bellicos',NULL,NULL,'[bɛl.lɪˈkoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6280,'bellifer','a','bellifer bellifer bellifer',NULL,NULL,'[ˈbɛl.lɪ.fɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (6284,'belligerator','n','belligerator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (6291,'bellosus','a','bellos bellos bellos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (6293,'bellua','n','bellu',NULL,'n-s---fn1-=belua','[ˈbɛl.lʊ.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6304,'beluus','a','belu belu belu',NULL,NULL,'[ˈbeː.ɫʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6305,'belualis','a','belual belual belual',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (6307,'beluilis','a','beluil beluil beluil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (6308,'beluinus','a','beluin beluin beluin',NULL,NULL,'/beː.luˈiː.nus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (6311,'bene','r',NULL,'rc--------=melius rs--------=optime',NULL,'[ˈbɛ.nɛ]','rp--------');
INSERT INTO latin_morpho VALUES (6313,'benedico','v','benedic benedix benedict',NULL,NULL,'[bɛ.nɛˈdiː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (6316,'benedictus','a','benedict benedict benedict',NULL,NULL,'[bɛ.nɛˈdɪk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6317,'benedictio','n','benediction',NULL,NULL,'[bɛ.nɛˈdɪk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (6323,'benefactor','n','benefactor',NULL,NULL,'[bɛ.nɛˈfak.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (6324,'beneficus','a','benefic benefic benefic',NULL,NULL,'[bɛˈnɛ.fɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6326,'beneficentia','n','beneficenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6327,'beneficium','n','benefici',NULL,NULL,'[bɛ.nɛˈfɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6340,'beneplacitum','n','beneplacit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (6349,'benevolentia','n','benevolenti',NULL,NULL,'[bɛ.nɛ.wɔˈɫɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6353,'benigne','r',NULL,NULL,NULL,'[bɛˈnɪŋ.neː]','rp--------');
INSERT INTO latin_morpho VALUES (6354,'benignitas','n','benignitat',NULL,NULL,'[bɛˈnɪŋ.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (6355,'benigniter','r',NULL,NULL,NULL,'[bɛˈnɪŋ.nɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (6374,'beryllus','n','beryll',NULL,NULL,'[beːˈrʏl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6381,'bestia','n','besti',NULL,NULL,'/ˈbeːs.ti.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6382,'bestialis','a','bestial bestial bestial',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (6386,'bestiola','n','bestiol',NULL,NULL,'[beːsˈti.ɔ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6387,'beta','n','-',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6400,'betulla','n','betull',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6405,'bibo','v','bib bib bibit',NULL,NULL,'[ˈbɪ.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (6409,'bibilis','a','bibil bibil bibil',NULL,NULL,'[ˈbɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (6421,'bibliopola','n','bibliopol',NULL,NULL,'[bɪ.bli.ɔˈpoː.ɫa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (6423,'bibliotheca','n','bibliothec',NULL,NULL,'/bi.bli.oˈtʰeː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6426,'bibliothecarius','n','bibliothecari',NULL,NULL,'[bɪ.bi.ɔ.tʰeːˈkaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6471,'bifariam','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (6512,'bilinguis','a','bilingu bilingu bilingu',NULL,NULL,'[bɪˈlɪŋ.ɡᶣɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (6514,'bilis','n','bil',NULL,NULL,'[ˈbiː.lɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (6523,'bimaritus','n','bimarit',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (6580,'bipes','a','biped biped biped',NULL,NULL,'[ˈbɪ.peːs]','aps---an3-');
INSERT INTO latin_morpho VALUES (6618,'bison','n','bisont',NULL,NULL,'[ˈbɪ.soːn]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (6633,'bitumen','n','bitumin',NULL,NULL,'[bɪˈtuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (6642,'bivium','n','bivi',NULL,NULL,'[ˈbɪ.wi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6653,'blandus','a','bland bland bland',NULL,NULL,'[ˈbɫan.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6656,'blandior','v','bland blandit -',NULL,NULL,'[ˈbɫan.di.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (6661,'blandificus','a','blandific blandific blandific',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (6668,'blandimentum','n','blandiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (6671,'blanditia','n','blanditi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6674,'blanditor','n','blanditor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (6676,'blandulus','a','blandul blandul blandul',NULL,NULL,'[ˈbɫan.dʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6681,'blasphemo','v','blasphem blasphemav blasphema',NULL,NULL,'[bɫasˈpʰeː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (6683,'blasphematio','n','blasphemation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (6684,'blasphemia','n','blasphemi',NULL,NULL,'[bɫasˈpʰeː.mi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6686,'blatero','v','blater blaterav blaterat',NULL,NULL,'/ˈbla.te.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (6690,'blatio','v','blat blativ blatit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (6692,'blatta','n','blatt',NULL,NULL,'[ˈbɫat.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6724,'boo','v','bo boav boat',NULL,NULL,'[ˈbɔ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (6727,'boatus','n','boat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (6731,'boethus','n','boeth',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (6732,'boia','n','boi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6735,'bolus','n','bol',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (6750,'bombus','n','bomb',NULL,NULL,'[ˈbɔm.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6769,'bombyx','n','bombyc',NULL,NULL,'[ˈbɔm.bʏks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (6772,'bonum','n','bon',NULL,NULL,'[ˈbɔ.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6773,'bonus','a','bon bon bon','acs---mn3-=melior acs---fn3-=melior acs---nn3-=melius ass---mn1-=optimus ass---fn1-=optima ass---nn1-=optimum',NULL,'[ˈbɔ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6777,'bonitas','n','bonitat',NULL,NULL,'/ˈbo.ni.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (6778,'Bononia','n','Bononi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6783,'Boreas','n','Bore',NULL,NULL,NULL,'n-s---mn1g');
INSERT INTO latin_morpho VALUES (6784,'boreus','a','bore bore bore',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (6785,'borealis','a','boreal boreal boreal',NULL,NULL,'[bɔ.rɛˈaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (6792,'borrio','v','borr borriv borrit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (6793,'bos','n','bov','n-p---cd3-=bobus n-p---cb3-=bobus',NULL,'/boːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (6820,'botulus','n','botul',NULL,NULL,'[ˈbɔ.tʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6834,'bovillus','a','bovill bovill bovill',NULL,NULL,'/boˈwil.lus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (6835,'bovinus','a','bovin bovin bovin',NULL,NULL,'/boˈwiː.nus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (6842,'brabeuta','n','brabeut',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (6852,'bracchium','n','bracchi',NULL,NULL,'[ˈbrak.kʰi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (6891,'brassica','n','brassic',NULL,NULL,'[ˈbras.sɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6897,'bratteola','n','bratteol',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (6907,'brephotrophium','n','brephotrophi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (6908,'brevis','a','brev brev brev',NULL,NULL,'[ˈbrɛ.wɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (6915,'brevio','v','brevi breviav breviat',NULL,NULL,'[ˈbrɛ.wi.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (6921,'breviator','n','breviator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (6923,'breviculus','a','brevicul brevicul brevicul',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (6926,'breviloquens','a','breviloquent breviloquent breviloquent',NULL,NULL,'[brɛˈwɪ.ɫɔ.kᶣẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (6927,'breviloquentia','n','breviloquenti',NULL,NULL,'[brɛ.wɪ.ɫɔˈkᶣɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6930,'brevitas','n','brevitat',NULL,NULL,'[ˈbrɛ.wɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (6931,'breviter','r',NULL,NULL,NULL,'[ˈbrɛ.wɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (6938,'Britannicus','a','Britannic Britannic Britannic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (6958,'bruchus','n','bruch',NULL,NULL,'[ˈbruː.kʰʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6959,'bruma','n','brum',NULL,NULL,'/ˈbruː.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (6960,'brumalis','a','brumal brumal brumal',NULL,NULL,'[bruːˈmaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (6967,'Brutus','n','Brut',NULL,NULL,'[ˈbruː.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6969,'brutus','a','brut brut brut',NULL,NULL,'[ˈbruː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (6982,'bubalus','n','bubal',NULL,NULL,'[ˈbuː.ba.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (6996,'bubulus','a','bubul bubul bubul',NULL,NULL,'[ˈbuː.bʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7002,'bubulinus','a','bubulin bubulin bubulin',NULL,NULL,'[buː.bʊˈliː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7006,'bucca','n','bucc',NULL,NULL,'[ˈbʊk.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7011,'buccellatum','n','buccellat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7017,'bucco','n','buccon',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (7026,'bucetum','n','bucet',NULL,NULL,'[buːˈkeː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7035,'bucolicus','a','bucolic bucolic bucolic',NULL,NULL,'[buːˈkɔ.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7039,'bucula','n','bucul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (7041,'buculus','n','bucul',NULL,NULL,'[ˈbuː.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7044,'bufo','n','bufon',NULL,NULL,'/ˈbuː.foː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7049,'buglossos','n','bugloss',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (7054,'bulbus','n','bulb',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7064,'bulga','n','bulg',NULL,NULL,'[ˈbʊɫ.ɡa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7071,'bulla','n','bull',NULL,NULL,'[ˈbʊl.laː]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7073,'bullo','v','bull bullav bullat',NULL,NULL,'[ˈbʊl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (7078,'bullio','v','bull bulliv bullit',NULL,NULL,'[ˈbʊl.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (7099,'burdo','n','burdon',NULL,NULL,'[ˈbʊr.doː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7100,'burdonarius','n','burdonari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7129,'bustum','n','bust',NULL,NULL,'[ˈbuːs.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7148,'buxum','n','bux',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7163,'Byzantium','n','Byzanti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7167,'caballus','n','caball',NULL,NULL,'[kaˈbal.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7174,'caco','v','cac cacav cacat',NULL,NULL,'/ˈka.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (7184,'caccabus','n','caccab',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7212,'cactos','n','cact',NULL,NULL,NULL,'n-s---mn2g');
INSERT INTO latin_morpho VALUES (7216,'cacumen','n','cacumin',NULL,NULL,'[kaˈkuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (7217,'cacumino','v','cacumin cacuminav cacuminat',NULL,NULL,'[kaˈkuː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (7218,'cadus','n','cad',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7219,'cado','v','cad cecid cas',NULL,NULL,'/ˈka.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (7220,'cadaver','n','cadaver',NULL,NULL,'[kaˈdaː.wɛr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (7226,'cadivus','a','cadiv cadiv cadiv',NULL,NULL,'[kaˈdiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7233,'caducarius','a','caducari caducari caducari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (7245,'caecus','a','caec caec caec',NULL,NULL,'[ˈkae̯.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7251,'caecitas','n','caecitat',NULL,NULL,'[ˈkae̯.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (7252,'caecitudo','n','caecitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (7257,'caedo','v','caed caecid caes',NULL,NULL,'/ˈkae̯.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (7259,'caedes','n','caed',NULL,NULL,'/ˈkae̯.deːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (7266,'caelum','n','cael',NULL,'n-s---nn2-=cælum n-s---nn2-=cœlum n-s---nn2-=celum n-s---mn2-=caelus n-s---nn2-=coelum',NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7268,'caelo','v','cael caelav caelat',NULL,NULL,'[ˈkae̯.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (7271,'caelator','n','caelator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (7274,'caelebs','a','caelib caelib caelib',NULL,NULL,'[ˈkae̯.ɫɛps]','aps---an3-');
INSERT INTO latin_morpho VALUES (7278,'caeles','a','caelit caelit caelit',NULL,NULL,'[ˈkae̯.ɫɛs]','aps---an3-');
INSERT INTO latin_morpho VALUES (7279,'caelestis','a','caelest caelest caelest',NULL,NULL,'[kae̯ˈɫɛs.tɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (7285,'caelibatus','n','caelibat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (7286,'caelicus','a','caelic caelic caelic',NULL,NULL,'[ˈkae̯.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7287,'caelicola','n','caelicol',NULL,NULL,'[kae̯ˈlɪ.kɔ.ɫa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (7306,'caenum','n','caen',NULL,NULL,'[ˈkae̯.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7323,'caenulentus','a','caenulent caenulent caenulent',NULL,NULL,'[kae̯.nʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7333,'caerefolium','n','caerefoli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7339,'caerimonia','n','caerimoni',NULL,NULL,'[kae̯.rɪˈmoː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7353,'caeruleus','a','caerule caerule caerule',NULL,NULL,'[kae̯ˈrʊ.ɫe.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7356,'caesum','n','caes',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7358,'Caesar','n','Caesar',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (7384,'caesura','n','caesur',NULL,NULL,'/kae̯ˈsuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7399,'calo','v','cal calav calat',NULL,NULL,'[ˈka.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (7403,'calamus','n','calam',NULL,NULL,'[ˈka.ɫa.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7412,'calamitas','n','calamitat',NULL,NULL,'[kaˈɫa.mɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (7414,'calamitosus','a','calamitos calamitos calamitos',NULL,NULL,'[ka.ɫa.mɪˈtoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7415,'calamitose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (7427,'calco','v','calc calcav calcat',NULL,NULL,'[ˈkaɫ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (7430,'calcaneum','n','calcane',NULL,NULL,'[kaɫˈkaː.ne.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7431,'calcar','n','calcar',NULL,NULL,'[ˈkaɫ.kar]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (7441,'calcatus','a','calcat calcat calcat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (7446,'calceus','n','calce',NULL,NULL,'[ˈkaɫ.ke.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7448,'calceamen','n','calceamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (7449,'calceamentum','n','calceament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7454,'calceatus','n','calceat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (7459,'calceolarius','n','calceolari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7481,'calculus','n','calcul',NULL,NULL,'[ˈkaɫ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7484,'calculo','v','calcul calculav calcula',NULL,NULL,'[ˈkaɫ.kʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (7486,'calculatio','n','calculation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (7504,'caldor','n','caldor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (7507,'calefacio','v','calefac calefec calefact',NULL,NULL,'[ka.ɫɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (7510,'calefacto','v','calefact calefactav calefactat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (7531,'calidus','a','calid calid calid',NULL,NULL,'[ˈka.lɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7545,'caligineus','a','caligine caligine caligine',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (7546,'caliginosus','a','caliginos caliginos caliginos',NULL,NULL,'[kaː.liː.ɡɪˈnoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7547,'caligo','n','caligin',NULL,NULL,'/kaːˈliː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (7549,'Caligula','n','Caligul',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (7553,'calix','n','calic',NULL,NULL,'[ˈka.lɪks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7555,'callum','n','call',NULL,NULL,'[ˈkal.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7570,'calliditas','n','calliditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (7591,'callositas','n','callositat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (7594,'calor','n','calor',NULL,NULL,'/ˈka.lor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7595,'caloratus','a','calorat calorat calorat',NULL,NULL,'/ka.loːˈraː.tus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (7603,'caltha','n','calth',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (7607,'calumnia','n','calumni',NULL,NULL,'[kaˈɫʊm.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7610,'calumniator','n','calumniator',NULL,NULL,'[ka.ɫʊm.nɪˈaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7613,'calumniosus','a','calumnios calumnios calumnios',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (7616,'calva','n','calv',NULL,NULL,'[ˈkaɫ.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7621,'calvor','v','calv  -',NULL,NULL,'[ˈkaɫ.wɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (7624,'calvaria','n','calvari',NULL,NULL,'[kaɫˈwaː.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7630,'calvio','v','calv calviv calvit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (7634,'calvitium','n','calviti',NULL,NULL,'[kaɫˈwɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7635,'calvities','n','calviti',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (7636,'calx','n','calc',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (7639,'calyculus','n','calycul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7641,'calyx','n','calyc',NULL,NULL,'[ˈka.lʏks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7644,'camus','n','cam',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7663,'camelus','n','camel',NULL,NULL,'[kaˈmeː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7669,'camella','n','camell',NULL,NULL,'[kaˈmɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7672,'camelopardalis','n','camelopardal',NULL,NULL,'[ka.meː.ɫɔˈpar.da.lɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (7676,'camera','n','camer',NULL,'n-s---fn1-=camara n-s---fn1-=cambra','[ˈka.mɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7680,'camerarius','n','camerari',NULL,NULL,'[ka.mɛˈraː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7686,'caminus','n','camin',NULL,NULL,'[kaˈmiː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7688,'camisia','n','camisi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (7693,'campe','n','camp',NULL,NULL,'/ˈkam.peː/','n-s---fn1g');
INSERT INTO latin_morpho VALUES (7694,'campus','n','camp',NULL,NULL,'[ˈkam.pʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7696,'campana','n','campan',NULL,NULL,'/ˈkam.pa.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7732,'canus','a','can can can',NULL,NULL,'[ˈkaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7733,'cano','v','can cecin cant',NULL,NULL,'/ˈka.noː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (7746,'canaliculus','n','canalicul',NULL,NULL,'[ka.naːˈlɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7750,'canalis','n','canal',NULL,NULL,'[kaˈnaː.lɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (7756,'cancello','v','cancell cancellav cancellat',NULL,NULL,'(Classcial) IPA: /kanˈkel.loː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (7758,'cancellarius','n','cancellari',NULL,NULL,'[kaŋ.kɛlˈlaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7765,'cancer','n','cr',NULL,NULL,'[ˈkaŋ.kɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (7773,'canceroma','n','canceromat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (7783,'candelabrum','n','candelabr',NULL,NULL,'[kan.deːˈɫaː.brũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7785,'candens','a','candent candent candent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (7794,'candidus','a','candid candid candid',NULL,NULL,'[ˈkan.dɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7804,'candide','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (7818,'canicula','n','canicul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (7825,'canis','n','can',NULL,NULL,'[ˈka.nɪs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7826,'canistellum','n','canistell',NULL,NULL,'/ka.nisˈtel.lum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7829,'canitia','n','caniti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (7832,'canna','n','cann',NULL,NULL,'/ˈkan.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7839,'cannabis','n','cannab',NULL,NULL,'[ˈkan.na.bɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (7845,'cannula','n','cannul',NULL,NULL,'[ˈkan.nʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7847,'canon','n','canon',NULL,NULL,'/ˈka.noːn/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (7868,'canor','n','canor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (7869,'canorus','a','canor canor canor',NULL,NULL,'[kaˈnoː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (7870,'canore','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (7872,'cantus','n','cant',NULL,NULL,'[ˈkan.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (7873,'canto','v','cant cantav cantat',NULL,NULL,'/ˈkan.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (7875,'cantabrum','n','cantabr',NULL,NULL,'[ˈkan.ta.brũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7879,'cantamen','n','cantamin',NULL,NULL,'[kanˈtaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (7880,'cantatio','n','cantation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (7881,'cantator','n','cantator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (7895,'cantharis','n','cantharid',NULL,NULL,'[ˈkan.tʰa.rɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (7898,'cantherius','n','cantheri',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7902,'canticum','n','cantic',NULL,NULL,'[ˈkan.tɪ.kũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7904,'canticulum','n','canticul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7906,'cantilena','n','cantilen',NULL,NULL,'[kan.tɪˈɫeː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (7909,'cantio','n','cantion',NULL,NULL,'/ˈkan.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (7913,'cantor','n','cantor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (7924,'capus','n','cap',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (7926,'capacitas','n','capacitat',NULL,NULL,'[kaˈpaː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (7928,'capax','a','capac capac capac',NULL,NULL,'/ˈka.paːks/','aps---an3i');
INSERT INTO latin_morpho VALUES (7940,'caper','n','apr',NULL,NULL,'[ˈka.pɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (7946,'capesso','v','capess capessiv capessit',NULL,NULL,'[kaˈpɛs.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (7951,'capio','v','cap cep capt',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (7953,'capillus','n','capill',NULL,NULL,'[kaˈpɪl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (7955,'capillamentum','n','capillament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7962,'capillitium','n','capilliti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7970,'capistrum','n','capistr',NULL,NULL,'[kaˈpɪs.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (7971,'capistro','v','capistr capistrav capistrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (7976,'capitalis','a','capital capital capital',NULL,NULL,'[ka.pɪˈtaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (7994,'Capitolium','n','Capitoli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (7997,'capitulum','n','capitul',NULL,NULL,'[kaˈpi.tu.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (8014,'capo','n','capon',NULL,NULL,'/ˈkaː.poː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8017,'capparis','n','cappar',NULL,'n-s---nn3-=cappari',NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (8028,'caprarius','n','caprari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8030,'caprea','n','capre',NULL,NULL,'/ˈka.pre.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8036,'capricornus','n','capricorn',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8037,'caprificus','n','caprific',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (8057,'capsa','n','caps',NULL,NULL,'/ˈkap.sa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8064,'capsula','n','capsul',NULL,NULL,'[ˈka.psʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8066,'captus','n','capt',NULL,NULL,'[ˈkap.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (8076,'captio','n','caption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8078,'captiosus','a','captios captios captios',NULL,NULL,'[kap.tɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8088,'captivitas','n','captivitat',NULL,NULL,'[kapˈtiː.wɪ.tas]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8092,'captura','n','captur',NULL,NULL,'/kapˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8097,'capulus','n','capul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8106,'caput','n','capit',NULL,NULL,'[ˈka.pʊt]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (8111,'carus','a','car car car',NULL,NULL,'[ˈkaː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8123,'carbasus','n','carbas',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8132,'carbo','n','carbon',NULL,NULL,'/ˈkar.boː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8140,'carbunculus','n','carbuncul',NULL,NULL,'[karˈbʊŋ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (8147,'carcer','n','carcer',NULL,NULL,'[ˈkar.kɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8153,'Carchedonius','a','Carchedoni Carchedoni Carchedoni',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (8154,'carchesium','n','carchesi',NULL,NULL,'[karˈkʰeː.si.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (8164,'cardamomum','n','cardamom',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (8165,'cardelis','n','cardel',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8169,'cardinalis','a','cardinal cardinal cardinal',NULL,NULL,'[kar.dɪˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (8182,'cardo','n','cardin',NULL,NULL,'/ˈkar.doː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8183,'carduus','n','cardu',NULL,NULL,'[ˈkar.dʊ.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (8184,'carduelis','n','carduel',NULL,NULL,'[kar.dʊˈeː.lɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (8187,'careum','n','care',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (8193,'carentia','n','carenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8198,'caries','n','cari',NULL,NULL,'/ˈka.ri.eːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (8201,'carina','n','carin',NULL,NULL,'/kaˈriː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8204,'carino','v','carin carinav carinat',NULL,NULL,'[ˈkaː.rɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (8215,'caritas','n','caritat',NULL,NULL,'[ˈkaː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8220,'carmen','n','carmin',NULL,NULL,'[ˈkar.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (8227,'carnalis','a','carnal carnal carnal',NULL,NULL,'[karˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (8230,'carnaliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (8232,'carnarium','n','carnari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (8235,'carnatio','n','carnation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8236,'carneus','a','carne carne carne',NULL,NULL,'[ˈkar.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8241,'carnifex','n','carnific',NULL,NULL,'[ˈkar.nɪ.fɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8244,'carnifico','v','carnific carnificav carnificat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (8247,'carnificina','n','carnificin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8251,'carnosus','a','carnos carnos carnos',NULL,NULL,'/karˈnoː.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (8262,'caro','n','carn',NULL,NULL,'/ˈka.roː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8267,'carpa','n','carp',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8268,'carpo','v','carp carps carpt',NULL,NULL,'/ˈkar.poː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (8274,'carpentum','n','carpent',NULL,NULL,'[karˈpɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (8287,'carptim','r',NULL,NULL,NULL,'[ˈkarp.tĩ]','rp--------');
INSERT INTO latin_morpho VALUES (8301,'carruca','n','carruc',NULL,NULL,'/karˈruː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8309,'cartallus','n','cartall',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8310,'Carthaginiensis','a','Carthaginiens Carthaginiens Carthaginiens',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (8312,'Carthago','n','Carthagin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8317,'cartilago','n','cartilagin',NULL,NULL,'[kar.tɪˈɫaː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8321,'caryon','n','cary',NULL,NULL,NULL,'n-s---nn2g');
INSERT INTO latin_morpho VALUES (8328,'caryota','n','caryot',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8330,'casa','n','cas',NULL,NULL,'[ˈka.za]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8331,'casus','n','cas',NULL,NULL,'[ˈkaː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (8338,'cascus','a','casc casc casc',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (8340,'caseus','n','case',NULL,NULL,'[ˈkaː.se.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (8348,'casia','n','casi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8357,'casnar','n',NULL,NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (8360,'cassus','a','cass cass cass',NULL,NULL,'[ˈkas.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8361,'casso','v','cass cassav cassat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (8368,'cassida','n','cassid',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8372,'cassis','n','cassid',NULL,'n-s---fn1-=cassida','[ˈkas.sɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8375,'cassito','v','cassit cassitav cassitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (8376,'cassiterum','n','cassiter',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (8382,'castanea','n','castane',NULL,NULL,'/kasˈta.ne.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8385,'caste','r',NULL,NULL,NULL,'/ˈkas.teː/','rp--------');
INSERT INTO latin_morpho VALUES (8386,'castellum','n','castell',NULL,NULL,'[kasˈtɛl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (8396,'castigo','v','castig castigav castigat',NULL,NULL,'/kasˈtiː.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (8399,'castigate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (8400,'castigatio','n','castigation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8403,'castimonia','n','castimoni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8406,'castitas','n','castitat',NULL,NULL,'[ˈkas.tɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8408,'castor','n','castor',NULL,NULL,'[ˈkas.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8414,'castrum','n','castr',NULL,NULL,'[ˈkas.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (8417,'castro','v','castr castrav castrat',NULL,NULL,'/ˈkas.troː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (8422,'castratio','n','castration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8436,'casula','n','casul',NULL,NULL,'[ˈka.sʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8440,'catus','a','cat cat cat',NULL,NULL,'[ˈka.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8452,'cataclysmos','n','cataclysm',NULL,NULL,NULL,'n-s---mn2g');
INSERT INTO latin_morpho VALUES (8481,'cataphagas','n','cataphag',NULL,NULL,NULL,'n-s---mn1g');
INSERT INTO latin_morpho VALUES (8489,'catapirateria','n','catapirateri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8494,'cataplasma','n','cataplasm',NULL,NULL,'[ka.taˈpɫas.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (8497,'catapotium','n','catapoti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (8498,'catapulta','n','catapult',NULL,NULL,'[ka.taˈpʊɫ.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8500,'cataracta','n','cataract',NULL,NULL,'/ka.taˈrak.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8506,'catarrhus','n','catarrh',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8526,'catechismus','n','catechism',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8528,'catechista','n','catechist',NULL,NULL,'[ka.teːˈkʰɪs.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (8535,'catechumenus','n','catechumen',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8538,'categoria','n','categori',NULL,NULL,'[ka.teːˈɡɔ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8539,'categoricus','a','categoric categoric categoric',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (8544,'catena','n','caten',NULL,NULL,'/kaˈteː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8548,'catenatio','n','catenation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8550,'caterva','n','caterv',NULL,NULL,'[kaˈtɛr.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8557,'cathedra','n','cathedr',NULL,NULL,'[ˈka.tʰɛ.dra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8572,'catholicus','a','catholic catholic catholic',NULL,NULL,'[kaˈtʰɔ.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8573,'catholice','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (8576,'catillus','n','catill',NULL,NULL,'[kaˈtɪl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (8588,'Cato','n','Caton',NULL,NULL,'/ˈka.toː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8590,'catocha','n','catoch',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8600,'cattus','n','catt',NULL,NULL,'[ˈkat.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (8602,'catulus','n','catul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (8614,'cauda','n','caud',NULL,NULL,'/ˈkau̯.da/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8631,'caulis','n','caul',NULL,'n-s---mn3i=colis n-s---mn3i=coles',NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (8635,'caupo','n','caupon',NULL,NULL,'/ˈkau̯.poː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8638,'cauponor','v','caupon cauponat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (8649,'causa','n','caus',NULL,NULL,'/ˈkau̯.sa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8659,'causarius','a','causari causari causari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (8662,'causatio','n','causation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8667,'causidicus','n','causidic',NULL,NULL,'[kau̯ˈsɪ.dɪ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (8680,'causticus','a','caustic caustic caustic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (8683,'cautus','a','caut caut caut',NULL,NULL,'[ˈkau̯.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8684,'caute','r',NULL,NULL,NULL,'/ˈkau̯.teː/','rp--------');
INSERT INTO latin_morpho VALUES (8685,'cautela','n','cautel',NULL,NULL,'[kau̯ˈteː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8691,'cautes','n','caut',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (8693,'cautio','n','caution',NULL,NULL,'/ˈkau̯.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8702,'cavus','n','cav',NULL,NULL,'[ˈka.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (8704,'cavus','a','cav cav cav',NULL,NULL,'[ˈka.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8706,'cavo','v','cav cavav cavat',NULL,NULL,'/ˈka.woː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (8708,'cavamen','n','cavamin',NULL,NULL,'[kaˈwaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (8712,'cavatio','n','cavation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8714,'cavatura','n','cavatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8715,'cavea','n','cave',NULL,NULL,'/ˈka.we.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8730,'cavillor','v','cavill cavillat -',NULL,NULL,'[kaˈwɪl.lɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (8733,'cavillatio','n','cavillation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8734,'cavillator','n','cavillator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (8737,'cavositas','n','cavositat',NULL,NULL,'[kaˈwoː.sɪ.tas]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8738,'cedo','v','ced cess cess',NULL,NULL,'/ˈkeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (8741,'cedrus','n','cedr',NULL,NULL,'[ˈkɛ.drʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (8751,'celo','v','cel celav celat',NULL,NULL,'[ˈkeː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (8759,'celeber','a','celebr celebr celebr',NULL,NULL,'[ˈkɛ.ɫɛ.bɛr]','aps---mn3-');
INSERT INTO latin_morpho VALUES (8762,'celebro','v','celebr celebrav celebrat',NULL,NULL,'[ˈkɛ.ɫɛ.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (8765,'celebratus','a','celebrat celebrat celebrat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (8766,'celebratio','n','celebration',NULL,NULL,'[kɛ.ɫɛˈbraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8769,'celebritas','n','celebritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8773,'celero','v','celer celerav celerat',NULL,NULL,'[ˈkɛ.ɫɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (8774,'celer','a','celer celer celer',NULL,NULL,'[ˈkɛ.ɫɛr]','aps---mn3-');
INSERT INTO latin_morpho VALUES (8776,'celeratim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (8777,'celere','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (8779,'celeritas','n','celeritat',NULL,NULL,'/keˈle.ri.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8780,'celeriter','r',NULL,'rc--------=celerius rs--------=celerrime',NULL,'[kɛˈɫɛ.rɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (8791,'celeusma','n','celeusmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (8793,'cella','n','cell',NULL,NULL,'[ˈkɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8824,'celsitudo','n','celsitudin',NULL,NULL,'[kɛɫ.sɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (8837,'cena','n','cen',NULL,NULL,'/ˈkeː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8841,'cenaculum','n','cenacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (8865,'census','n','cens',NULL,NULL,'[ˈkẽː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (8867,'censeo','v','cens censu censit',NULL,NULL,'[ˈkẽː.se.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (8871,'censitio','n','censition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (8873,'censor','n','censor',NULL,NULL,'[ˈkẽː.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (8875,'censorius','a','censori censori censori',NULL,NULL,'[kẽːˈsoː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (8878,'censura','n','censur',NULL,NULL,'[kẽːˈsuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (8882,'centaureum','n','centaure',NULL,NULL,'[kɛn.tau̯ˈreː.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (8908,'centipeda','n','centiped',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (8909,'centipellio','n','centipellion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (8918,'centrum','n','centr',NULL,NULL,'[ˈkɛn.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (8956,'centurio','n','centurion',NULL,'n-s---mn2-=centurionus',NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (8973,'cephalalgia','n','cephalalgi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (9000,'cera','n','cer',NULL,NULL,'/ˈkeː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9009,'cerasus','n','ceras',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (9010,'cerasum','n','ceras',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (9012,'cerasium','n','cerasi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (9019,'ceratium','n','cerati',NULL,NULL,'[kɛˈraː.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (9044,'cerdo','n','cerdon',NULL,NULL,'[ˈkɛr.doː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (9047,'cereus','a','cere cere cere',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (9050,'cerebellum','n','cerebell',NULL,NULL,'[kɛ.rɛˈbɛl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (9052,'cerebrum','n','cerebr',NULL,NULL,'[ˈkɛ.rɛ.brũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (9062,'Ceres','n','Cerer',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9084,'cerno','v','cern crev cret',NULL,NULL,'[ˈkɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9087,'cernuus','n','cernu',NULL,NULL,'[ˈkɛr.nʊ.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (9094,'ceroma','n','cerom',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (9100,'cerrus','n','cerr',NULL,NULL,'[ˈkɛr.rʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (9107,'certo','v','cert certav certat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (9108,'certus','a','cert cert cert',NULL,NULL,'[ˈkɛr.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (9111,'certamen','n','certamin',NULL,NULL,'[kɛrˈtaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (9112,'certatus','n','certat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (9116,'certator','n','certator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (9117,'certe','r',NULL,NULL,NULL,'[ˈkɛr.teː]','rp--------');
INSERT INTO latin_morpho VALUES (9122,'certioro','v','certior certiorav certiorat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (9124,'certitudo','n','certitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9125,'certo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (9128,'cerussa','n','ceruss',NULL,NULL,'[keːˈrʊs.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9130,'cerva','n','cerv',NULL,NULL,'[ˈkɛr.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9131,'cervus','n','cerv',NULL,NULL,'[ˈkɛr.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (9137,'cervical','n','cervical',NULL,NULL,'[kɛrˈwiː.kaɫ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (9139,'cervicatus','a','cervicat cervicat cervicat',NULL,NULL,'[kɛr.wiːˈkaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (9141,'cervicosus','a','cervicos cervicos cervicos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (9142,'cervicula','n','cervicul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (9150,'cervix','n','cervic',NULL,NULL,'[ˈkɛr.wiːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (9155,'ceryx','n','ceric',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (9161,'cessatio','n','cessation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9178,'cetarius','n','cetari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (9186,'ceterum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (9190,'ceu','r',NULL,NULL,NULL,'/keu̯/','rp--------');
INSERT INTO latin_morpho VALUES (9196,'Chaos','n',NULL,NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (9223,'chalcis','n','chalcid',NULL,NULL,'[ˈkʰaɫ.kɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (9238,'chalybs','n','chalyb',NULL,NULL,'[ˈkʰa.lʏps]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (9240,'chama','n','cham',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (9249,'chamaeleon','n','chamaeleon',NULL,NULL,'[kʰaˈmae̯.ɫe.õ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (9285,'character','n','character',NULL,NULL,'[kʰaˈrak.tɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (9291,'charisma','n','charismat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (9303,'charta','n','chart',NULL,NULL,'/ˈkʰar.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9304,'chartus','n','chart',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (9316,'Charybdis','n','Charybd',NULL,NULL,'[kʰaˈrʏb.dɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (9318,'chasma','n','chasmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (9319,'chasmatias','n','chasmati',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (9320,'chele','n','chel',NULL,NULL,'[ˈkʰeː.ɫeː]','n-s---fn1g');
INSERT INTO latin_morpho VALUES (9334,'chelys','n','chely',NULL,NULL,'[ˈkʰɛ.lʏs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (9360,'cherub','n',NULL,NULL,NULL,'[ˈkʰɛ.rʊb]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (9403,'chirurgus','n','chirurg',NULL,NULL,'[kʰiːˈrʊr.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (9405,'chirurgia','n','chirurgi',NULL,NULL,'[kʰiːˈrʊr.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9444,'chorus','n','chor',NULL,NULL,'[ˈkʰɔ.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (9456,'choraules','n','choraul',NULL,NULL,'[kʰɔˈrau̯.ɫeːs]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (9459,'chorda','n','chord',NULL,NULL,'[ˈkʰɔr.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9464,'chorea','n','chore',NULL,NULL,'/kʰoˈreː.a/','n-s---fn1g');
INSERT INTO latin_morpho VALUES (9465,'choreus','n','chore',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (9491,'chrisma','n','chrismat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (9497,'Christus','n','Christ',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (9500,'Christianus','a','Christian Christian Christian',NULL,NULL,'kʰrɪs.tɪˈaː.nʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (9502,'Christianismus','n','Christianism',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (9503,'Christianitas','n','Christianitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9522,'chronius','a','chroni chroni chroni',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (9526,'chronicus','a','chronic chronic chronic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (9528,'chronographus','n','chronograph',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (9532,'chrysos','n','chrys',NULL,'n-s---mn2-=chrysus','[ˈkʰryː.sɔs]','n-s---mn2g');
INSERT INTO latin_morpho VALUES (9560,'chrysocolla','n','chrysocoll',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (9567,'chrysolithos','n','chrysolith',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (9585,'chydaeus','a','chydae chydae chydae',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (9593,'cieo','v','ci civ cit',NULL,NULL,'/ˈki.e.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (9595,'cibus','n','cib',NULL,NULL,'[ˈkɪ.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (9596,'cibo','v','cib cibav cibat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (9601,'cibatus','n','cibat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (9602,'cibatio','n','cibation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9608,'cicada','n','cicad',NULL,NULL,'[kɪˈkaː.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9614,'cicatrix','n','cicatric',NULL,NULL,'[kɪˈkaː.triːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (9630,'cicindela','n','cicindel',NULL,NULL,'[kɪ.kɪnˈdeː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9632,'ciconia','n','ciconi',NULL,NULL,'[kɪˈkoː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9638,'cicuta','n','cicut',NULL,NULL,'[kɪˈkuː.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9660,'cimex','n','cimic',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (9676,'cinara','n','cinar',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (9682,'cinctus','n','cinct',NULL,NULL,'[ˈkɪŋk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (9710,'cingo','v','cing cinx cinct',NULL,NULL,'[ˈkɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9714,'cingulus','n','cingul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (9715,'cingulum','n','cingul',NULL,NULL,'[ˈkɪŋ.ɡʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (9720,'cinis','n','ciner',NULL,NULL,'[ˈkɪ.nɪs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (9743,'circus','n','circ',NULL,NULL,'[ˈkɪr.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (9746,'circa','r',NULL,NULL,NULL,'[ˈkɪr.kaː]','rp--------');
INSERT INTO latin_morpho VALUES (9757,'circes','n','circit',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (9763,'circinatus','a','circinat circinat circinat',NULL,NULL,'[kɪr.kɪˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (9764,'circinatio','n','circination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9766,'circiter','r',NULL,NULL,NULL,'[ˈkɪr.kɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (9768,'circitor','n','circitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (9774,'circuitus','n','circuit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (9775,'circuitio','n','circuition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9778,'circulus','n','circul',NULL,NULL,'[ˈkɪr.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (9779,'circulo','v','circul circulav circula',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (9787,'circum','r',NULL,NULL,NULL,'[ˈkɪr.kũ]','rp--------');
INSERT INTO latin_morpho VALUES (9789,'circumactus','n','circumact',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (9791,'circumactio','n','circumaction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9798,'circumaspicio','v','circumaspic - -',NULL,NULL,'[kɪr.kʊ.masˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (9802,'circumcido','v','circumcid circumcid circumcis',NULL,NULL,'[kɪr.kʊŋˈkiː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9804,'circumcingo','v','circumcing circumcinx circumcinct',NULL,NULL,'[kɪr.kʊŋˈkɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9807,'circumcisus','a','circumcis circumcis circumcis',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (9808,'circumcise','r',NULL,NULL,NULL,'[kɪr.kʊŋˈkiː.sɛ]','rp--------');
INSERT INTO latin_morpho VALUES (9810,'circumcisio','n','circumcision',NULL,NULL,'[kɪr.kʊŋˈkiː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (9816,'circumcludo','v','circumclud circumclus circumclus',NULL,NULL,'[kɪr.kʊŋˈkɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9829,'circumdo','v','circum circumded circumdat',NULL,NULL,'[kɪrˈkʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (9834,'circumduco','v','circumduc circumdux circumduct',NULL,NULL,'[kɪr.kʊnˈduː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9835,'circumductum','n','circumduct',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (9836,'circumductus','n','circumduct',NULL,NULL,'[kɪr.kʊnˈdʊk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (9838,'circumductio','n','circumduction',NULL,NULL,'[kɪr.kʊnˈdʊk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (9840,'circumeo','v','circum circumiv circumit','v2spia--4-=circumis v3spia--4-=circumit v1ppia--4-=circumimus v2ppia--4-=circumitis v3ppia--4-=circumeunt v1siia--4-=circumibam v2siia--4-=circumibas v3siia--4-=circumibat v1piia--4-=circumibamus v2piia--4-=circumibatis v3piia--4-=circumibant v1sfia--4-=circumibo v2sfia--4-=circumibis v3sfia--4-=circumibit v1pfia--4-=circumibimus v2pfia--4-=circumibitis v3pfia--4-=circumibunt',NULL,'[kɪrˈkʊ.me.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (9844,'circumfero','v','circumfer circumtul circumlat','v--pna--3-=circumferre v2spia--3-=circumfers v3spia--3-=circumfert v2ppia--3-=circumfertis',NULL,'[kɪrˈkũː.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9845,'circumferentia','n','circumferenti',NULL,NULL,'[kɪr.kũː.fɛˈrɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (9853,'circumflexus','n','circumflex',NULL,NULL,'[kɪr.kũːˈfɫɛk.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (9858,'circumfluo','v','circumflu circumflux circumflux',NULL,NULL,'[kɪrˈkũː.fɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9874,'circumfundo','v','circumfund circumfud circumfus',NULL,NULL,'[kɪr.kũːˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9889,'circumicio','v','circumic circumjec circumject',NULL,NULL,'[kɪr.kʊˈmɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (9912,'circumlaticius','a','circumlatici circumlatici circumlatici',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (9913,'circumlatio','n','circumlation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9921,'circumligo','v','circumlig circumligav circumligat',NULL,NULL,'[kɪrˈkʊm.lɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (9926,'circumlocutio','n','circumlocution',NULL,NULL,'[kɪr.kʊm.ɫɔˈkuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (9934,'circummeo','v','circumme circummeav circummeat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (9942,'circummunio','v','circummun circummuniv circummunit',NULL,NULL,'[kɪr.kʊmˈmuː.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (9948,'circumnecto','v','circumnect - circumnex',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (9958,'circumplecto','v','circumplect - -',NULL,NULL,'[kɪr.kʊmˈpɫɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9976,'circumrodo','v','circumrod circumrod circumros',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (9979,'circumsaepio','v','circumsaep circumseps circumsept',NULL,NULL,'[kɪr.kũːˈsae̯.pi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (9986,'circumscribo','v','circumscrib circumscrips circumscript',NULL,NULL,'[kɪr.kũːˈskriː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (9989,'circumscriptio','n','circumscription',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (9990,'circumscriptor','n','circumscriptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (9994,'circumsedeo','v','circumsed circumsed circumsess',NULL,NULL,'[kɪr.kũːˈsɛ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (9999,'circumsessio','n','circumsession',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10001,'circumsido','v','circumsid - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (10004,'circumsisto','v','circumsist - -',NULL,NULL,'[kɪr.kũːˈsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (10010,'circumspectus','n','circumspect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (10011,'circumspecto','v','circumspect circumspectav circumspectat',NULL,NULL,'[kɪr.kũːˈspɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10012,'circumspectus','a','circumspect circumspect circumspect',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (10016,'circumspectio','n','circumspection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10017,'circumspector','n','circumspector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (10019,'circumspicio','v','circumspic circumspex circumspect',NULL,NULL,'[kɪr.kũːˈspɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (10020,'circumspicientia','n','circumspicienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (10021,'circumsto','v','circumst circumstet -',NULL,NULL,'[kɪrˈkũː.stoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10024,'circumstantia','n','circumstant',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (10055,'circumvado','v','circumvad circumvas -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (10061,'circumvectio','n','circumvection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10065,'circumvenio','v','circumven circumven circumvent',NULL,NULL,'[kɪr.kʊmˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (10066,'circumventio','n','circumvention',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10072,'circumversio','n','circumversion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10078,'circumvolito','v','circumvolit circumvolitav circumvolitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10086,'cirrus','n','cirr',NULL,NULL,'[ˈkɪr.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (10100,'cissos','n','ciss',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (10108,'cista','n','cist',NULL,NULL,'[ˈkɪs.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10114,'cisterna','n','cistern',NULL,NULL,'[kɪsˈtɛr.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10121,'cito','v','cit citav citat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10125,'citatus','n','citat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (10128,'citatim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (10149,'cito','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (10151,'citrus','n','citr',NULL,NULL,'[ˈkɪ.trʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (10165,'citreago','n','citreagin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10175,'civicus','a','civic civic civic',NULL,NULL,'[ˈkiː.wɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (10183,'civis','n','civ',NULL,NULL,'[ˈkiː.wɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (10184,'civitas','n','civitat',NULL,NULL,'[ˈkiː.wɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (10191,'clades','n','clad',NULL,NULL,'[ˈkɫaː.dɛs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (10197,'clamo','v','clam clamav clamat',NULL,NULL,'[ˈkɫaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10199,'clamator','n','clamator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (10203,'clamito','v','clamit clamitav clamitat',NULL,NULL,'[ˈkɫaː.mɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10205,'clamor','n','clamor',NULL,NULL,'[ˈkɫaː.mɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (10212,'clancularius','a','clanculari clanculari clanculari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (10220,'clangor','n','clangor',NULL,NULL,'[ˈkɫaŋ.ɡɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (10222,'claro','v','clar clarav clarat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10223,'clarus','a','clar clar clar',NULL,NULL,'[ˈkɫaː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (10225,'clare','r',NULL,NULL,NULL,'[ˈkɫaː.reː]','rp--------');
INSERT INTO latin_morpho VALUES (10228,'clarico','v','claric claricav claricat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10231,'clarificatio','n','clarification',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10233,'clarigatio','n','clarigation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10237,'claritas','n','claritat',NULL,NULL,'[ˈkɫaː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (10238,'claritudo','n','claritudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10239,'claritus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (10249,'classis','n','class',NULL,NULL,'[ˈkɫas.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (10257,'claudus','a','claud claud claud',NULL,NULL,'[ˈkɫau̯.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (10258,'claudeo','v','claud claus claus',NULL,NULL,'[ˈkɫau̯.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (10259,'claudo','v','claud claus claus',NULL,NULL,'[ˈkɫau̯.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (10264,'claudico','v','claudic claudicav claudicat',NULL,NULL,'[ˈkɫau̯.dɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10267,'clauditas','n','clauditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10270,'clausus','a','claus claus claus',NULL,NULL,'[ˈkɫau̯.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (10272,'claustrum','n','claustrum',NULL,NULL,'[ˈkɫau̯s.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (10278,'clausula','n','clausul',NULL,NULL,'[ˈkɫau̯.sʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10279,'clausura','n','clausur',NULL,NULL,'[kɫau̯ˈsuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10280,'clava','n','clav',NULL,NULL,'[ˈkɫaː.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10282,'clavus','n','clav',NULL,NULL,'[ˈkɫaː.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (10293,'clavicula','n','clavicul',NULL,NULL,'/klaːˈwi.ku.la/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10294,'clavicularius','n','claviculari',NULL,NULL,'[kɫaː.wɪ.kʊˈɫaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (10302,'clavulus','n','clavul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (10311,'clemens','a','clement clement clement',NULL,NULL,'[ˈkɫeː.mẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (10312,'clementer','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (10313,'clementia','n','clementi',NULL,NULL,'[kɫeːˈmɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10317,'Cleopatra','n','Cleopatr',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (10323,'cleptes','n','clept',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (10325,'clerus','n','cler',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (10326,'clericus','n','cleric',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (10329,'clibanus','n','cliban',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (10330,'clibanarius','n','clibanari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (10335,'cliens','n','client',NULL,NULL,'[ˈkli.ẽːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (10338,'clientela','n','clientel',NULL,NULL,'[kli.ɛnˈteː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10340,'clima','n','climat',NULL,NULL,'[ˈklɪ.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (10367,'clipeo','v','clipe clipeav clipeat',NULL,'v1spia--1-=clypeo v--pna--1-=clypeare v1sria--1-=clypeavi v-srppmn1-=clypeatus v-srppfn1-=clypeata v-srppnn1-=clypeatum v1spia--1-=clupeo v--pna--1-=clupeare v1sria--1-=clupeavi v-srppmn1-=clupeatus v-srppfn1-=clupeata v-srppnn1-=clupeatum',NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10374,'clivus','n','cliv',NULL,NULL,'[ˈkliː.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (10386,'cloaca','n','cloac',NULL,NULL,'/kloˈaː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10404,'claustellum','n','claustell',NULL,'n-s---nn2-=clostellum',NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (10428,'clunis','n','clun',NULL,NULL,'[ˈkɫuː.nɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (10460,'clyster','n','clyster',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (10479,'cnodax','n','cnodac',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (10485,'coacervo','v','coacerv coacervav coacervat',NULL,NULL,'[kɔ.aˈkɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10494,'coacte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (10503,'coactor','n','coactor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (10505,'coactura','n','coactur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (10506,'coaddo','v','coadd - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (10514,'coaduno','v','coadun coadunav coadunat',NULL,NULL,'[kɔ.aˈduː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10519,'coaequo','v','coaequ coaequav coaequat',NULL,NULL,'[kɔˈae̯.kʷoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10530,'coagmento','v','coagment coagmentav coagmentat',NULL,NULL,'[kɔ.aɡˈmɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10532,'coagmentatio','n','coagmentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10533,'coagulum','n','coagul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (10534,'coagulo','v','coagul coagulav coagulat',NULL,NULL,'[kɔˈaː.ɡʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10535,'coagulare','n','coagular',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (10537,'coagulatio','n','coagulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10540,'coalesco','v','coalesc coalu coalit',NULL,NULL,'[kɔ.aˈɫeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (10551,'coarguo','v','coargu coargu coargut',NULL,NULL,'[kɔˈar.ɡʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (10555,'coarto','v','coart coartav coartat',NULL,NULL,'[kɔˈar.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10594,'cochlea','n','cochle',NULL,NULL,'[ˈkɔ.kʰɫe.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10595,'cochlear','n','cochlear',NULL,NULL,'[ˈkɔ.kʰɫe.ar]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (10598,'cochlearium','n','cochleari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (10614,'cocio','n','cocion',NULL,NULL,'/ˈkoː.ki.oː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (10646,'coctio','n','coction',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (10649,'coctor','n','coctor',NULL,NULL,'/ˈkok.tor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (10652,'coctura','n','coctur',NULL,NULL,'[kɔkˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10658,'codex','n','codic',NULL,NULL,'[ˈkoː.dɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (10662,'codicillus','n','codicill',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (10697,'coemeterium','n','coemeteri',NULL,NULL,'[koe̯.meːˈteː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (10717,'coenobium','n','coenobi',NULL,NULL,'[koe̯ˈnɔ.bi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (10726,'coepio','v','coep coep coept',NULL,NULL,'/ˈkoe̯.pi.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (10730,'coeptum','n','coept',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (10731,'coeptus','n','coept',NULL,NULL,'[ˈkoe̯p.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (10733,'coepto','v','coept coeptav coeptat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10736,'coerceo','v','coerc coercu coercit',NULL,NULL,'[kɔˈɛr.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (10752,'cogo','v','cog coeg coact',NULL,NULL,'/ˈkoː.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (10753,'cogito','v','cogit cogitav cogitat',NULL,NULL,'[ˈkoː.ɡɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10756,'cogitamen','n','cogitamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (10757,'cogitamentum','n','cogitament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (10759,'cogitatus','n','cogitat',NULL,NULL,'/koː.ɡiˈtaː.tus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (10763,'cogitatio','n','cogitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10768,'cognatio','n','cognation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10770,'cognitus','a','cognit cognit cognit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (10771,'cognitio','n','cognition',NULL,NULL,'[kɔŋˈnɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (10777,'cognobilis','a','cognobil cognobil cognobil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (10778,'cognomen','n','cognomin',NULL,NULL,'[koːŋˈnoː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (10779,'cognomentum','n','cognoment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (10780,'cognominis','a','cognomin cognomin cognomin',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (10781,'cognomino','v','cognomin cognominav cognominat',NULL,NULL,'[kɔŋˈnoː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10785,'cognosco','v','cognosc cognov cognit',NULL,NULL,'[kɔŋˈnoːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (10788,'cognoscenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (10799,'cohaerens','a','cohaerent cohaerent cohaerent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (10802,'cohaerentia','n','cohaerenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (10804,'cohaeresco','v','cohaeresc cohaes -',NULL,NULL,'[kɔ.hae̯ˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (10819,'cohors','n','cohort',NULL,NULL,'[ˈkɔ.hɔrs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (10822,'cohortor','v','cohort cohortat -',NULL,NULL,'[kɔˈhɔr.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (10826,'cohortatio','n','cohortation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10831,'cohumido','v','cohumid cohumidav cohumidat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10841,'coinquino','v','coinquin coinquinav coinquinat',NULL,NULL,'[kɔˈɪŋ.kᶣɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10846,'coitio','n','coition',NULL,NULL,'[kɔˈɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (10853,'colus','n','col',NULL,NULL,'[ˈkɔ.ɫʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (10855,'colum','n','col',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (10857,'colon','n','col',NULL,'n-s---nn2-=colum n-s---mn2-=colus','[ˈkɔ.ɫõ]','n-s---nn2g');
INSERT INTO latin_morpho VALUES (10859,'colus','n','col',NULL,NULL,'[ˈkɔ.ɫʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (10860,'colo','v','col colav colat',NULL,NULL,'[ˈkɔ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (10871,'colens','n','colent',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (10892,'collum','n','coll',NULL,NULL,'[ˈkɔl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (10893,'collabor','v','collab collaps -',NULL,NULL,'[kɔlˈlaː.bɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (10895,'collabasco','v','collabasc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (10918,'collare','n','collar',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (10926,'collatio','n','collation',NULL,NULL,'[kɔlˈlaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (10935,'collaudatio','n','collaudation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10938,'collecta','n','collect',NULL,NULL,'[kɔlˈleːk.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (10940,'collectus','n','collect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (10945,'collectarius','n','collectari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (10950,'collectio','n','collection',NULL,NULL,'[kɔlˈleːk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (10952,'collectivus','a','collectiv collectiv collectiv',NULL,NULL,'[kɔl.leːkˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (10957,'collega','n','colleg',NULL,NULL,'[kɔlˈleː.ɡa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (10960,'collegium','n','collegi',NULL,NULL,'[kɔlˈleː.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (10973,'collevo','v','collev collevav collevat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10980,'colliculus','n','collicul',NULL,NULL,'[kɔlˈlɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (10981,'collido','v','collid collis collis',NULL,NULL,'[kɔlˈliː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (10983,'colligo','v','collig colleg collect',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (10987,'colligatio','n','colligation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (10995,'collino','v','collin collev collit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (10996,'collineo','v','colline collineav collineat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11000,'colliquefacio','v','colliquefac colliquefec colliquefact',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (11002,'colliquesco','v','colliquesc colliqu -',NULL,NULL,'[kɔl.lɪˈkᶣeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11005,'collis','n','coll',NULL,NULL,'[ˈkɔl.lɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (11006,'collisus','n','collis',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11009,'colloco','v','colloc collocav collocat',NULL,NULL,'[ˈkɔl.lɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11010,'collocatio','n','collocation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11012,'collocutio','n','collocution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11016,'colloquor','v','colloqu collocut -',NULL,NULL,'[ˈkɔl.lɔ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (11017,'colloquium','n','colloqui',NULL,NULL,'[kɔlˈlɔ.kᶣi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (11018,'colluo','v','collu collu collut',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (11020,'colluco','v','colluc collucav collucat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11021,'colluceo','v','colluc - -',NULL,NULL,'[kɔlˈluː.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (11022,'colluctor','v','colluct colluctat -',NULL,NULL,'[kɔlˈlʊk.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11023,'colluctatio','n','colluctation',NULL,'n-s---fn3-=conluctatio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11026,'colludium','n','colludi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11028,'collumino','v','collumin colluminav collumina',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11032,'collusio','n','collusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11035,'collustro','v','collustr collustrav collustrat',NULL,NULL,'[kɔlˈlʊs.troː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11043,'colluvio','n','colluvion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11050,'collyrida','n','collyrid',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (11066,'colona','n','colon',NULL,NULL,'[kɔˈɫoː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11067,'colonus','n','colon',NULL,NULL,'[kɔˈɫoː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (11071,'colonia','n','coloni',NULL,NULL,'[kɔˈɫoː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11082,'color','n','color',NULL,NULL,'[ˈkɔ.ɫɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (11083,'coloro','v','color colorav colorat',NULL,NULL,'[kɔˈɫoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11085,'coloratus','a','colorat colorat colorat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11105,'coluber','n','colubr',NULL,NULL,'[ˈkɔ.ɫʊ.bɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (11106,'colubra','n','colubr',NULL,NULL,'/ˈko.lu.bra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11117,'columbare','n','columbar',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (11130,'columen','n','columin',NULL,NULL,'[ˈkɔ.ɫʊ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (11131,'columna','n','column',NULL,NULL,'[kɔˈɫʊm.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11134,'columnarius','n','columnari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (11155,'coma','n','com',NULL,NULL,'[ˈkɔ.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11157,'comis','a','com com com',NULL,NULL,'[ˈkoː.mɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (11158,'como','v','com comps compt',NULL,NULL,'/ˈkoː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (11161,'coma','n','com',NULL,NULL,'[ˈkɔ.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11163,'comans','a','comant comant comant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (11173,'combibo','v','combib combib combibit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (11175,'combino','v','combin - combinat',NULL,NULL,'[kɔmˈbiː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11179,'comburo','v','combur combuss combust',NULL,NULL,'[kɔmˈbuː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11181,'combustum','n','combust',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11185,'combustura','n','combustur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (11187,'comedo','v','comed comed comes',NULL,NULL,'[ˈkɔ.mɛ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11195,'comes','n','comit',NULL,NULL,'[ˈkɔ.mɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (11205,'comestibilis','a','comestibil comestibil comestibil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (11209,'cometes','n','comet',NULL,NULL,'[kɔˈmeː.teːs]','n-s---mn1g');
INSERT INTO latin_morpho VALUES (11214,'comicus','n','comic',NULL,NULL,'[ˈkoː.mɪ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (11215,'comicus','a','comic comic comic',NULL,NULL,'[ˈkoː.mɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11228,'comissatio','n','comissation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11230,'comito','v','comit comitav comitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11231,'comitor','v','comit comitat -',NULL,NULL,'[ˈkɔ.mɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11233,'comitas','n','comitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11238,'comiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (11241,'comitium','n','comiti',NULL,NULL,'[kɔˈmɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (11243,'comitialis','a','comitial comitial comitial',NULL,NULL,'[kɔ.mɪ.tɪˈaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (11255,'comma','n','commat',NULL,NULL,'[ˈkɔm.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (11257,'commaceratio','n','commaceration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11259,'commaculo','v','commacul commaculav commaculat',NULL,NULL,'[kɔmˈma.kʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11263,'commalleo','v','commalle commalleav commallea',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11270,'commanducatio','n','commanducation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11290,'commeo','v','comme commeav commeat',NULL,NULL,'[ˈkɔm.me.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11292,'commeatus','n','commeat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11295,'commeditor','v','commedit commeditat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (11296,'commeio','v','commei commeiav commeia',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (11298,'commeleto','v','commelet commeletav commeletat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11300,'commemoro','v','commemor commemorav commemorat',NULL,NULL,'[kɔmˈmɛ.mɔ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11303,'commemoratio','n','commemoration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11307,'commendo','v','commend commendav commendat',NULL,NULL,'[kɔmˈmɛn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11313,'commendatio','n','commendation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11320,'commensus','n','commens',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11327,'commentum','n','comment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11330,'commentor','v','comment commentat -',NULL,NULL,'[kɔmˈmɛn.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11332,'commentarium','n','commentari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11338,'commentator','n','commentator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11342,'commentor','n','commentor',NULL,NULL,'[kɔmˈmɛn.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (11343,'commereo','v','commer commeru -',NULL,NULL,'[kɔmˈmɛ.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (11344,'commereor','v','commer commerit -',NULL,NULL,'[kɔmˈmɛ.re.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (11348,'commercium','n','commerci',NULL,NULL,'[kɔmˈmɛr.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (11353,'commetior','v','commet commens -',NULL,NULL,'[kɔmˈmeː.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (11358,'commigratio','n','commigration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11359,'commiles','n','commilit',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11362,'commilito','n','commiliton',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11364,'comminor','v','commin comminat -',NULL,NULL,'[ˈkɔm.mɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11367,'comminatio','n','commination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11372,'comminiscor','v','comminisc comment -',NULL,NULL,'[kɔm.mɪˈniːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (11374,'comminuo','v','comminu comminu comminut',NULL,NULL,'[kɔmˈmɪ.nʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11382,'commisceo','v','commisc commiscu commixt',NULL,NULL,'[kɔmˈmɪs.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (11385,'commiseror','v','commiser commiserat -',NULL,NULL,'[kɔmˈmɪ.sɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11386,'commisereor','v','commiser commiserit -',NULL,NULL,NULL,'v1spid--2-');
INSERT INTO latin_morpho VALUES (11388,'commiseratio','n','commiseration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11393,'commissum','n','commiss',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11397,'commissio','n','commission',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11402,'commissura','n','commissur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (11407,'commitigo','v','commitig commitigav commitiga',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11408,'committo','v','committ commis commiss',NULL,NULL,'[kɔmˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11410,'commixtio','n','commixtion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11411,'commixtura','n','commixtur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (11413,'commodum','n','commod',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11414,'commodo','v','commod commodav commodat',NULL,NULL,'[ˈkɔm.mɔ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11415,'commodus','a','commod commod commod',NULL,NULL,'[ˈkɔm.mɔ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11416,'commodatum','n','commodat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11420,'commode','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (11422,'commoditas','n','commoditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11429,'commodum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (11433,'commolior','v','commol commolit -',NULL,NULL,NULL,'v1spid--4-');
INSERT INTO latin_morpho VALUES (11435,'commoneo','v','common commonu commonit',NULL,NULL,'[kɔmˈmɔ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (11436,'commonefacio','v','commonefac commonefec commonefact',NULL,NULL,'[kɔm.mɔ.nɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (11437,'commonitio','n','commonition',NULL,NULL,'/kom.moˈni.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11441,'commonstro','v','commonstr commonstrav commonstrat',NULL,NULL,'[kɔmˈmõː.stroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11443,'commoror','v','commor commorat -',NULL,NULL,'[ˈkɔm.mɔ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11444,'commoratio','n','commoration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11452,'commotus','n','commot',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11455,'commotio','n','commotion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11458,'commoveo','v','commov commov commot',NULL,NULL,'[kɔmˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (11464,'communis','a','commun commun commun',NULL,NULL,'[kɔmˈmuː.nɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (11468,'communio','v','commun communiv communit',NULL,NULL,'[kɔmˈmuː.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (11469,'communico','v','communic communicav communicat',NULL,NULL,'[kɔmˈmuː.nɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11479,'communio','n','communion',NULL,NULL,'[kɔmˈmuː.ni.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11484,'communitas','n','communitat',NULL,NULL,'[kɔmˈmuː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11486,'communitio','n','communition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11487,'communitus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (11490,'commurmuror','v','commurmur commurmurat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (11492,'commuto','v','commut commutav commutat',NULL,NULL,'[kɔmˈmuː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11493,'commutabilis','a','commutabil commutabil commutabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (11494,'commutatus','n','commutat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11495,'commutatio','n','commutation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11496,'comoedus','n','comoed',NULL,NULL,'[koːˈmoe̯.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (11498,'comoedia','n','comoedi',NULL,NULL,'/koːˈmoe̯.di.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11506,'compactus','a','compact compact compact',NULL,NULL,'[kɔmˈpak.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11509,'compactio','n','compaction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11517,'compages','n','compag',NULL,NULL,'[kɔmˈpaː.ɡɛs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (11520,'compaginatio','n','compagination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11521,'compago','n','compagin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11526,'comparo','v','compar comparav comparat',NULL,NULL,'[ˈkɔm.pa.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11528,'comparabilis','a','comparabil comparabil comparabil',NULL,NULL,'[kɔm.paˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (11529,'comparatus','n','comparat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11531,'comparatio','n','comparation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11533,'comparativus','a','comparativ comparativ comparativ',NULL,NULL,'[kɔm.pa.raːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11535,'comparator','n','comparator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11541,'compartior','v','compart  -',NULL,NULL,'[kɔmˈpar.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (11554,'compatior','v','compat compass -',NULL,NULL,'[kɔmˈpa.ti.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (11565,'compectum','n','compect',NULL,'n-s---nn2-=conpectum',NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11572,'compello','v','compell compul compuls',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11577,'compendium','n','compendi',NULL,NULL,'[kɔmˈpɛn.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (11578,'compendio','v','compendi compendiav compendiat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11582,'compendiosus','a','compendios compendios compendios',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11585,'compenso','v','compens compensav compensat',NULL,NULL,'[kɔmˈpẽː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11589,'comperco','v','comperc compers -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (11597,'comperio','v','comper comper compert',NULL,NULL,'[kɔmˈpɛ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (11607,'compesco','v','compesc compescu -',NULL,NULL,'[kɔmˈpɛs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11610,'competo','v','compet competiv competit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (11613,'competens','a','competent competent competent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (11615,'competentia','n','competenti',NULL,NULL,'[kɔm.pɛˈtɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11617,'competitio','n','competition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11619,'competitor','n','competitor',NULL,NULL,'[kɔm.pɛˈtiː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (11621,'compilo','v','compil compilav compilat',NULL,NULL,'[kɔmˈpiː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11622,'compilatio','n','compilation',NULL,NULL,'[kɔm.piːˈɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11624,'compingo','v','comping compinx compict',NULL,NULL,'[kɔmˈpɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11635,'compleo','v','compl complev complet',NULL,NULL,'[ˈkɔm.pɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (11639,'complano','v','complan complanav complanat',NULL,NULL,'[kɔmˈpɫaː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11647,'complector','v','complect complex -',NULL,NULL,'[kɔmˈpɫɛk.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (11648,'complementum','n','complement',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11655,'completorium','n','completori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11656,'complexus','n','complex',NULL,NULL,'[kɔmˈpɫɛk.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (11661,'complexio','n','complexion',NULL,NULL,'[kɔmˈpɫɛk.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11665,'complico','v','complic complicav complicat',NULL,NULL,'[ˈkɔm.plɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11672,'comploratus','n','complorat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11673,'comploratio','n','comploration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11686,'compono','v','compon composu composit',NULL,NULL,'[kɔmˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11688,'comporto','v','comport comportav comportat',NULL,NULL,'[kɔmˈpɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11695,'compositus','a','composit composit composit',NULL,NULL,'[kɔmˈpɔ.sɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11697,'compositicius','a','compositici compositici compositici',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11698,'compositio','n','composition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11702,'compositor','n','compositor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11718,'comprecor','v','comprec comprecat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (11720,'comprehendo','v','comprehend comprehend comprehens',NULL,NULL,'[kɔm.prɛˈhɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11722,'comprehenso','v','comprehens comprehensav comprehensa',NULL,NULL,'[kɔm.prɛˈhẽː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11725,'comprehensio','n','comprehension',NULL,NULL,'[kɔm.prɛˈhẽː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11730,'compressus','n','compress',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11731,'compresso','v','compress - compressat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11732,'compressus','a','compress compress compress',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11734,'compressio','n','compression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11735,'compressor','n','compressor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11736,'comprimo','v','comprim compress compress',NULL,NULL,'[ˈkɔm.prɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11738,'comprobo','v','comprob comprobav comprobat',NULL,NULL,'[ˈkɔm.prɔ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11739,'comprobatio','n','comprobation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11746,'comptus','n','compt',NULL,NULL,'[ˈkoːmp.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (11747,'comptus','a','compt compt compt',NULL,NULL,'[ˈkoːmp.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11759,'compulsio','n','compulsion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11762,'compunctio','n','compunction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11764,'compungo','v','compung compunx compunct',NULL,NULL,'[kɔmˈpʊŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11768,'computus','n','comput',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (11769,'computo','v','comput computav computat',NULL,NULL,'[ˈkɔm.pʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11775,'computresco','v','computresc computru -',NULL,NULL,'[kɔm.puːˈtreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11781,'conus','n','con',NULL,NULL,'[ˈkoː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (11782,'conor','v','con conat -',NULL,NULL,'[ˈkoː.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11784,'conamen','n','conamin',NULL,NULL,'[koːˈnaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (11788,'conatum','n','conat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11789,'conatus','n','conat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11790,'conatio','n','conation',NULL,NULL,'/koːˈnaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11802,'concaco','v','concac concacav concacat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11804,'concaedes','n','concaed',NULL,NULL,NULL,'n-p---fn3i');
INSERT INTO latin_morpho VALUES (11805,'concalo','v','concal concalav concala',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11807,'concalefacio','v','concalefac concalefec concalefact',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (11809,'concalesco','v','concalesc concalu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (11822,'concarno','v','concarn concarnav concarna',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11823,'concarnatio','n','concarnation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11826,'concateno','v','concaten - concatenat',NULL,NULL,'[kɔŋ.kaˈteː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11830,'concavus','a','concav concav concav',NULL,NULL,'[ˈkɔŋ.ka.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11831,'concavo','v','concav -av concavat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11834,'concedo','v','conced concess concess',NULL,NULL,'[kɔŋˈkeː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11836,'concelebro','v','concelebr concelebrav concelebrat',NULL,NULL,'[kɔŋ.kɛˈɫeː.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11840,'concentus','n','concent',NULL,NULL,'[kɔŋˈkɛn.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (11841,'concentio','n','concention',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11846,'conceptus','n','concept',NULL,NULL,'[kɔŋˈkɛp.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (11847,'concepto','v','concept conceptav concepta',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11849,'conceptaculum','n','conceptacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11850,'conceptio','n','conception',NULL,NULL,'[kɔŋˈkɛp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11855,'concerpo','v','concerp concerps concerpt',NULL,NULL,'[kɔŋˈkɛr.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11858,'concerto','v','concert concertav concertat',NULL,NULL,'[kɔŋˈkɛr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11860,'concertatio','n','concertation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11862,'concertator','n','concertator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11864,'concessus','n','concess',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11865,'concessus','a','concess concess concess',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11868,'concessio','n','concession',NULL,NULL,'[kɔŋˈkɛs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (11870,'concha','n','conch',NULL,NULL,'[ˈkɔŋ.kʰa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11881,'conchylium','n','conchyli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11889,'concido','v','concid concid -',NULL,NULL,'[ˈkɔŋ.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11891,'concieo','v','conci conciv concit',NULL,NULL,'[kɔŋˈki.e.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (11893,'concilium','n','concili',NULL,NULL,'[kɔŋˈkɪ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (11895,'concilio','v','concili conciliav conciliat',NULL,NULL,'[kɔŋˈkɪ.li.ɔ]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11896,'conciliabulum','n','conciliabul',NULL,NULL,'[kɔŋ.kɪ.lɪˈaː.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (11899,'conciliatus','n','conciliat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11901,'conciliatio','n','conciliation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11902,'conciliator','n','conciliator',NULL,NULL,'[kɔŋ.kɪ.lɪˈaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (11907,'concino','v','concin concinu -',NULL,NULL,'[ˈkɔŋ.kɪ.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11908,'concinens','a','concinent concinent concinent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (11909,'concinentia','n','concinenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (11913,'concinno','v','concinn concinnav concinnat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11914,'concinnus','a','concinn concinn concinn',NULL,NULL,'[kɔŋˈkɪn.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (11922,'concinnitudo','n','concinnitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11933,'concisus','a','concis concis concis',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11934,'concise','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (11938,'concisura','n','concisur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (11940,'concitus','a','concit concit concit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11941,'concito','v','concit concitav concitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (11942,'concitamentum','n','concitament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (11943,'concitatus','n','concitat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (11944,'concitatus','a','concitat concitat concitat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11946,'concitatio','n','concitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11947,'concitator','n','concitator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11950,'concito','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (11951,'concitor','n','concitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (11954,'conclamo','v','conclam conclamav conclamat',NULL,NULL,'[kɔŋˈkɫaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11957,'conclamatio','n','conclamation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11960,'conclave','n','conclav',NULL,NULL,'[kɔŋˈkɫaː.wɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (11963,'concludo','v','conclud conclus conclus',NULL,NULL,'[kɔŋˈkɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11968,'conclusus','a','conclus conclus conclus',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (11970,'conclusio','n','conclusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11975,'concoctio','n','concoction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11981,'concomitor','v','concomit concomitat -',NULL,NULL,'[kɔŋˈkɔ.mɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (11985,'concoquo','v','concoqu concox concoct',NULL,NULL,'[ˈkɔŋ.kɔ.kʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (11986,'concordo','v','concord concordav concordat',NULL,NULL,'[kɔŋˈkɔr.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (11991,'concordatio','n','concordation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (11993,'concordia','n','concordi',NULL,NULL,'[kɔŋˈkɔr.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (11995,'concorditas','n','concorditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12004,'concors','a','concord concord concord',NULL,NULL,'[ˈkɔŋ.kɔrs]','aps---an3-');
INSERT INTO latin_morpho VALUES (12013,'concrementum','n','concrement',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12017,'concresco','v','concresc concrev concret',NULL,NULL,'[kɔŋˈkreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12018,'concrescentia','n','concrescenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (12021,'concretus','a','concret concret concret',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (12025,'concrispo','v','concrisp - concrispat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12036,'concubium','n','concubi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12038,'concubina','n','concubin',NULL,NULL,'[kɔŋ.kʊˈbiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (12043,'concubinatus','n','concubinat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12046,'concubitio','n','concubition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12048,'conculco','v','conculc conculcav conculcat',NULL,NULL,'[kɔŋˈkʊɫ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12052,'concumulatus','a','concumulat concumulat concumulat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (12056,'concupiscentia','n','concupiscenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (12066,'concurro','v','concurr concucurr concurs',NULL,NULL,'[kɔŋˈkʊr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12071,'concursus','n','concurs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12072,'concurso','v','concurs concursav concursat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12073,'concursatio','n','concursation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12077,'concursio','n','concursion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12078,'concurvo','v','concurv concurvav concurvat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12079,'concussus','n','concuss',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12080,'concussus','a','concuss concuss concuss',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (12082,'concussio','n','concussion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12084,'concussura','n','concussur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (12086,'concutio','v','concut concuss concuss',NULL,NULL,'[kɔŋˈkʊ.ti.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (12088,'condo','v','cond condid condit',NULL,NULL,'[ˈkɔn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12089,'condalium','n','condali',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12096,'condecoro','v','condecor condecorav condecorat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12101,'condemno','v','condemn condemnav condemnat',NULL,NULL,'[kɔnˈdɛm.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12103,'condemnatio','n','condemnation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12104,'condemnator','n','condemnator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (12107,'condensus','a','condens condens condens',NULL,NULL,'[kɔnˈdẽː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (12109,'condenseo','v','condens - -',NULL,NULL,'[kɔnˈdẽː.se.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (12117,'condio','v','cond condiv condit',NULL,NULL,'[ˈkɔn.di.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (12118,'condico','v','condic condix condict',NULL,NULL,'[kɔnˈdiː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12120,'condicio','n','condicion',NULL,NULL,'[kɔnˈdɪ.ki.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (12125,'condictum','n','condict',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12133,'condimentum','n','condiment',NULL,NULL,'[kɔn.diːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (12138,'condiscipulus','n','condiscipul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (12140,'conditum','n','condit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12142,'conditus','n','condit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12148,'conditio','n','condition',NULL,NULL,'[kɔnˈdɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (12159,'conditivum','n','conditiv',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12161,'conditor','n','conditor',NULL,NULL,'[kɔnˈdiː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (12163,'conditorium','n','conditori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12169,'condocefacio','v','condocefac condocefec condocefact',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (12173,'condolesco','v','condolesc condolu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (12178,'condono','v','condon condonav condonat',NULL,NULL,'[kɔnˈdoː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12180,'condonatio','n','condonation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12188,'conduco','v','conduc condux conduct',NULL,NULL,'[kɔnˈduː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12190,'conducibilis','a','conducibil conducibil conducibil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (12196,'conductio','n','conduction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12199,'conductor','n','conductor',NULL,NULL,'[kɔnˈdʊk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (12203,'condulco','v','condulc condulcav condulca',NULL,NULL,'[kɔnˈdʊɫ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12205,'conduplico','v','conduplic conduplicav conduplicat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12207,'conduro','v','condur condurav condurat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12209,'condylus','n','condyl',NULL,NULL,'[ˈkɔn.dʏ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (12212,'conecto','v','conect conexu conex',NULL,NULL,'[koːˈnɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12217,'conexus','n','conex',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12219,'conexio','n','conexion',NULL,NULL,'[koːˈnɛk.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (12224,'confabulor','v','confabul confabulat -',NULL,NULL,'[kõːˈfaː.bʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (12225,'confabulatus','n','confabulat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12226,'confabulatio','n','confabulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12236,'confectio','n','confection',NULL,NULL,'[kõːˈfɛk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (12237,'confector','n','confector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (12241,'confectura','n','confectur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (12245,'confero','v','confer contul conlat','v--pna--3-=conferre v2spia--3-=confers v3spia--3-=confert v2ppia--3-=confertis',NULL,'[ˈkõː.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12266,'confessio','n','confession',NULL,NULL,'[kõːˈfɛs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (12272,'confessor','n','confessor',NULL,NULL,'[kõːˈfɛs.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (12274,'confestim','r',NULL,NULL,NULL,'[kõːˈfɛs.tĩ]','rp--------');
INSERT INTO latin_morpho VALUES (12276,'confio','v','- - -','v--pna--3i=confieri v1sridmn3i=confactus_sum v1sridfn3i=confacta_sum v1sridnn3i=confactum_sum',NULL,'[kõːˈfiː.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (12278,'conficio','v','confic confec confect',NULL,NULL,'[kõːˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (12281,'conficto','v','confict confictav conficta',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12285,'confido','v','confid - confis',NULL,NULL,'[kõːˈfiː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12289,'confidenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (12290,'confidentia','n','confidenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (12293,'configuro','v','configur - configurat',NULL,NULL,'[kõː.fɪˈɡuː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12300,'confine','n','confin',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (12301,'confingo','v','confing confinx confict',NULL,NULL,'[kõːˈfɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12302,'confinium','n','confini',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12304,'confirmo','v','confirm confirmav confirmat',NULL,NULL,'[kõːˈfɪr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12307,'confirmatus','a','confirmat confirmat confirmat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (12311,'confirmatio','n','confirmation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12315,'confirmator','n','confirmator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (12318,'confisco','v','confisc - confiscat',NULL,NULL,'[kõːˈfɪs.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12319,'confiscatio','n','confiscation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12321,'confisio','n','confision',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12322,'confiteor','v','confit confess -',NULL,NULL,'[kõːˈfɪ.te.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (12325,'conflo','v','confl conflav conflat',NULL,NULL,'[ˈkõː.fɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12329,'conflagro','v','conflagr conflagrav conflagrat',NULL,NULL,'[ˈkõː.fɫa.ɡroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12331,'conflagratio','n','conflagration',NULL,NULL,'[kõː.fɫaˈɡraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (12336,'conflatio','n','conflation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12339,'conflatura','n','conflatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (12342,'conflictus','n','conflict',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12343,'conflicto','v','conflict conflictav conflictat',NULL,NULL,'[kõːˈflɪk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12346,'conflictatio','n','conflictation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12348,'conflictio','n','confliction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12349,'confligo','v','conflig conflix conflict',NULL,NULL,'[ˈkõː.flɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12356,'confluo','v','conflu conflux -',NULL,NULL,'[ˈkõː.fɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12358,'confluens','n','confluent',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (12362,'confodio','v','confod confod confoss',NULL,NULL,'[kõːˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (12365,'confoederatio','n','confoederation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12371,'conformo','v','conform conformav conformat',NULL,NULL,'[kõːˈfoːr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12373,'conformatio','n','conformation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12378,'conforto','v','confort confortav conforta',NULL,NULL,'[kõːˈfɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12380,'confortatio','n','confortation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12382,'confoveo','v','confov confov confot',NULL,NULL,'[kõːˈfɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (12383,'confracesco','v','confracesc confracescu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (12398,'confremo','v','confrem confremu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (12401,'confrico','v','confric confricav confricat',NULL,NULL,'[ˈkõː.frɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12405,'confringo','v','confring confreg confract',NULL,NULL,'[kõːˈfrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12411,'confugium','n','confugi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12413,'confulgeo','v','confulg - -',NULL,NULL,'[kõːˈfʊɫ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (12415,'confundo','v','confund confud confus',NULL,NULL,'[kõːˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12417,'confusus','a','confus confus confus',NULL,NULL,'[kõːˈfuː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (12419,'confuse','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (12422,'confusio','n','confusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12424,'confuto','v','confut confutav confutat',NULL,NULL,'[kõːˈfuː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12425,'confutatio','n','confutation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12432,'congelasco','v','congelasc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (12434,'congelatio','n','congelation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12435,'congemo','v','congem congemu -',NULL,NULL,'[ˈkɔŋ.ɡɛ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12436,'congemino','v','congemin congeminav congeminat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12449,'congero','v','conger congess congest',NULL,NULL,'[ˈkɔŋ.ɡɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12450,'conger','n','congr',NULL,NULL,'[ˈkɔŋ.ɡɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (12452,'congeries','n','congeri',NULL,'n-s---fn1-=congeria','[kɔŋˈɡɛ.ri.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (12456,'congermino','v','congermin congerminav congermina',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12461,'congestus','n','congest',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12468,'congestio','n','congestion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12472,'congiarium','n','congiari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (12474,'conglacio','v','conglaci - conglaciat',NULL,NULL,'[kɔŋˈɡɫa.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12476,'conglisco','v','conglisc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (12477,'conglobo','v','conglob conglobav conglobat',NULL,NULL,'[ˈkɔŋ.ɡɫɔ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12479,'conglobatio','n','conglobation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12480,'conglomero','v','conglomer conglomerav conglomerat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12494,'congredior','v','congred congress -',NULL,NULL,'[kɔŋˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (12497,'congrego','v','congreg congregav congregat',NULL,NULL,'[ˈkɔŋ.ɡrɛ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12502,'congregatio','n','congregation',NULL,NULL,'/kon.ɡreˈɡaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (12505,'congressus','n','congress',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12506,'congressio','n','congression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12511,'congruo','v','congru - -',NULL,NULL,'[ˈkɔŋ.ɡrʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12513,'congruens','a','congruent congruent congruent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (12515,'congruentia','n','congruent',NULL,NULL,'[kɔŋ.ɡrʊˈɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (12522,'conicio','v','conic coniec coniect',NULL,NULL,'[kɔnˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (12533,'conitor','v','conit conis -',NULL,NULL,'[koːˈniː.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (12950,'conquadro','v','conquadr conquadrav conquadrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (12953,'conquasso','v','conquass conquassav conquassat',NULL,NULL,'[kɔŋˈkʷas.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (12956,'conqueror','v','conquer conquest -',NULL,NULL,'[ˈkɔŋ.kᶣɛ.rɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (12957,'conquestus','n','conquest',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (12958,'conquestio','n','conquestion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12960,'conquiesco','v','conquiesc conquiev conquiet',NULL,NULL,'[kɔŋ.kᶣɪˈeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12965,'conquiro','v','conquir conquisiv conquisit',NULL,NULL,'[kɔŋˈkᶣiː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (12967,'conquisite','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (12968,'conquisitio','n','conquisition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (12970,'conquisitor','n','conquisitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13038,'consaepio','v','consaep consaeps consaept',NULL,NULL,'[kõːˈsae̯.pi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (13039,'consaeptum','n','consaept',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13042,'consaluto','v','consalut consalutav consalutat',NULL,NULL,'[kõː.saˈɫuː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13048,'consanguineus','a','consanguine consanguine consanguine',NULL,NULL,'[kõː.saŋˈɡᶣɪ.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13049,'consanguinitas','n','consanguinitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13062,'consceleratus','a','conscelerat conscelerat conscelerat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13063,'conscendo','v','conscend conscend conscens',NULL,NULL,'[kõːˈskɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13064,'conscensus','n','conscens',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (13065,'conscensio','n','conscension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13070,'conscientia','n','conscienti',NULL,NULL,'[kõː.skɪˈɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13072,'conscisco','v','conscisc consci conscit',NULL,NULL,'[kõːˈskiːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13075,'conscribo','v','conscrib conscrips conscript',NULL,NULL,'[kõːˈskriː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13078,'conscriptus','n','conscript',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (13079,'conscriptio','n','conscription',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13080,'conscriptor','n','conscriptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13081,'conseco','v','consec consecu consect',NULL,NULL,'[ˈkõː.sɛ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13083,'consecro','v','consecr consecrav consecrat',NULL,NULL,'[ˈkõː.sɛ.kroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13087,'consecratio','n','consecration',NULL,NULL,'[kõː.sɛˈkraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13091,'consector','v','consect consectat -',NULL,NULL,'[kõːˈsɛk.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (13096,'consectarius','a','consectari consectari consectari',NULL,NULL,'[kõː.sɛkˈtaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13097,'consectatio','n','consectation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13098,'consectator','n','consectator',NULL,NULL,'[kõː.sɛkˈtaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (13102,'consecutio','n','consecution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13111,'consensus','n','consens',NULL,NULL,'[kõːˈsẽː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (13114,'consensio','n','consension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13118,'consentio','v','consent consens consens',NULL,NULL,'[kõːˈsɛn.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (13121,'consentiens','a','consentient consentient consentient',NULL,NULL,'[kõːˈsɛn.ti.ẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (13128,'consequor','v','consequ consecut -',NULL,NULL,'[ˈkõː.sɛ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (13133,'consequentia','n','consequenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (13139,'consero','v','conser conseru consert',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (13144,'consermonor','v','consermon consermonat -',NULL,NULL,'[kõː.sɛrˈmoː.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (13149,'conservo','v','conserv conservav conservat',NULL,NULL,'[kõːˈsɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13152,'conservatio','n','conservation',NULL,NULL,'[kõː.sɛrˈwaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13155,'conservator','n','conservator',NULL,NULL,'[kõː.sɛrˈwaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (13161,'consessus','n','consess',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (13163,'consido','v','consid consed consess',NULL,NULL,'[kõːˈsiː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13165,'considero','v','consider considerav considerat',NULL,NULL,'[kõːˈsiː.dɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13167,'considerantia','n','consideranti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (13168,'consideratus','a','considerat considerat considerat',NULL,NULL,'[kõː.siː.dɛˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13169,'considerate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13173,'consigno','v','consign consignav consignat',NULL,NULL,'[kõːˈsɪŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13180,'consilium','n','consili',NULL,NULL,'[kõːˈsɪ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (13186,'consiliator','n','consiliator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13193,'consimiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13197,'consisto','v','consist constit -',NULL,NULL,'[kõːˈsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13208,'consitor','n','consitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13211,'consobrinus','n','consobrin',NULL,NULL,'[kõː.soːˈbriː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (13215,'consocius','a','consoci consoci consoci',NULL,NULL,'[kõːˈsɔ.ki.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13216,'consocio','v','consoci consociav consociat',NULL,NULL,'[kõːˈsɔ.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13218,'consociatus','a','consociat consociat consociat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13219,'consociatim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13220,'consociatio','n','consociation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13223,'consolo','v','consol consolav consolat',NULL,NULL,'[kõːˈsoː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13225,'consolabilis','a','consolabil consolabil consolabil',NULL,NULL,'[kõː.soːˈɫaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (13227,'consolatio','n','consolation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13230,'consolator','n','consolator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13234,'consolido','v','consolid - consolidat',NULL,NULL,'[kõːˈsɔ.lɪ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13235,'consolidatio','n','consolidation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13241,'consonus','a','conson conson conson',NULL,NULL,'[ˈkõː.sɔ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13242,'consono','v','conson consonu consonit',NULL,NULL,'[ˈkõː.sɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13245,'consonanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13246,'consonantia','n','consonanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (13249,'consopio','v','consop consopiv consopit',NULL,NULL,'[kõːˈsoː.pi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (13251,'consors','a','consort consort consort',NULL,NULL,'[ˈkõː.sɔrs]','aps---an3-');
INSERT INTO latin_morpho VALUES (13253,'consortium','n','consorti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13254,'consortio','n','consortion',NULL,NULL,'[kõːˈsɔr.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13258,'conspectus','n','conspect',NULL,NULL,'[kõːˈspɛk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (13259,'conspectus','a','conspect conspect conspect',NULL,NULL,'[kõːˈspɛk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13260,'conspectio','n','conspection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13263,'conspergo','v','consperg conspers conspers',NULL,NULL,'[kõːˈspɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13264,'conspersio','n','conspersion',NULL,'n-s---fn3-=consparsio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13265,'conspicor','v','conspic conspicat -',NULL,NULL,'[ˈkõː.spɪ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (13266,'conspicabilis','a','conspicabil conspicabil conspicabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (13268,'conspicio','v','conspic conspex conspect',NULL,NULL,'[kõːˈspɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (13275,'conspicuus','a','conspicu conspicu conspicu',NULL,NULL,'[kõːˈspɪ.kʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13277,'conspiro','v','conspir conspirav conspirat',NULL,NULL,'[kõːˈspiː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13278,'conspiratus','n','conspirat',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (13281,'conspiratio','n','conspiration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13300,'consto','v','const constit -',NULL,NULL,'[ˈkõː.stoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13303,'constabilio','v','constabil constabiliv constabilit',NULL,NULL,'[kõː.staˈbɪ.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (13306,'constans','a','constant constant constant',NULL,NULL,'[ˈkõː.stãːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (13307,'constanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13308,'constantia','n','constanti',NULL,NULL,'[kõːˈstan.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13313,'consterno','v','constern consternav consternat',NULL,NULL,'[kõːˈstɛr.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13317,'consternatio','n','consternation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13322,'constituo','v','constitu constitu constitut',NULL,NULL,'[kõːˈstɪ.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13324,'constitutum','n','constitut',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13326,'constitutio','n','constitution',NULL,NULL,'[kõː.stɪˈtuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13329,'constitutor','n','constitutor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13335,'constrictus','a','constrict constrict constrict',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13337,'constrictio','n','constriction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13338,'constrictivus','a','constrictiv constrictiv constrictiv',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13341,'constringo','v','constring constrinx constrict',NULL,NULL,'[kõːˈstrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13342,'construo','v','constru construx construct',NULL,NULL,'[ˈkõː.strʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13343,'constructio','n','construction',NULL,NULL,'[kõːˈstrʊk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13345,'constupro','v','constupr constuprav constuprat',NULL,NULL,'[ˈkõː.stʊ.proː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13346,'constuprator','n','constuprator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13351,'consuasor','n','consuasor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13358,'consucidus','a','consucid consucid consucid',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13363,'consuesco','v','consuesc consuev consuet',NULL,NULL,'[kõːˈsweːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13364,'consuetus','a','consuet consuet consuet',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13367,'consuetudinarius','a','consuetudinari consuetudinari consuetudinari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13369,'consuetudo','n','consuetudin',NULL,NULL,'/koːn.sweːˈtuː.doː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13370,'consul','n','consul',NULL,NULL,'[ˈkõː.sʊɫ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (13373,'consularis','a','consular consular consular',NULL,NULL,'/koːn.suˈlaː.ris/','aps---cn3i');
INSERT INTO latin_morpho VALUES (13377,'consulatus','n','consulat',NULL,NULL,'/koːn.suˈlaː.tus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (13379,'consultum','n','consult',NULL,NULL,'[kõːˈsʊɫ.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (13382,'consultus','a','consult consult consult',NULL,NULL,'[kõːˈsʊɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13393,'consumo','v','consum consumps consumpt',NULL,NULL,'[kõːˈsuː.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13394,'consummo','v','consumm consummav consummat',NULL,NULL,'[kõːˈsʊm.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13396,'consummatus','a','consummat consummat consummat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13397,'consummatio','n','consummation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13401,'consumptio','n','consumption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13403,'consumptor','n','consumptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13406,'consurgo','v','consurg consurrex consurrect',NULL,NULL,'[kõːˈsʊr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13411,'contus','n','cont',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (13414,'contabefacio','v','contabefac - -',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (13418,'contactus','n','contact',NULL,NULL,'/konˈtaːk.tus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (13421,'contagium','n','contagi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13425,'contamino','v','contamin contaminav contaminat',NULL,NULL,'[kɔnˈtaː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13437,'contechnor','v','contechn contechnat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (13438,'contego','v','conteg contex contect',NULL,NULL,'[ˈkɔn.tɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13439,'contemero','v','contemer contemerav contemerat',NULL,NULL,'[kɔnˈtɛ.mɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13440,'contemno','v','contemn contemps contempt',NULL,NULL,'[kɔnˈtɛm.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13445,'contempero','v','contemper contemperav contemperat',NULL,NULL,'[kɔnˈtɛm.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13448,'contemplo','v','contempl contemplav contemplat',NULL,NULL,'[kɔnˈtɛm.pɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13453,'contemplatus','n','contemplat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (13454,'contemplatio','n','contemplation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13456,'contemplator','n','contemplator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13464,'contemptus','n','contempt',NULL,NULL,'[kɔnˈtɛmp.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (13465,'contemptus','a','contempt contempt contempt',NULL,NULL,'[kɔnˈtɛmp.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13467,'contemptibilis','a','contemptibil contemptibil contemptibil',NULL,NULL,'[kɔn.tɛmpˈtɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (13470,'contemptio','n','contemption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13482,'contendo','v','contend contend content',NULL,NULL,'[kɔnˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13485,'contentus','a','content content content',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13489,'contente','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13490,'contentio','n','contention',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13494,'contero','v','conter contriv contrit',NULL,NULL,'[ˈkɔn.tɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13518,'contexo','v','contex contexu context',NULL,NULL,'[kɔnˈtɛk.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13519,'contextus','n','context',NULL,NULL,'[kɔnˈtɛk.stʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (13521,'contextus','a','context context context',NULL,NULL,'[kɔnˈtɛk.stʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13538,'contiguus','a','contigu contigu contigu',NULL,NULL,'/konˈti.ɡu.us/','aps---mn1-');
INSERT INTO latin_morpho VALUES (13540,'contineo','v','contin continu content',NULL,NULL,'[kɔnˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (13541,'continor','v','contin continat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (13545,'continens','a','continent continent continent',NULL,NULL,'[ˈkɔn.tɪ.nẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (13546,'continenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13548,'continentia','n','continent',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (13557,'continuus','a','continu continu continu',NULL,NULL,'[kɔnˈtɪ.nʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13562,'continuatus','a','continuat continuat continuat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13564,'continuatim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13565,'continuatio','n','continuation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13571,'continuo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13572,'contio','n','contion',NULL,NULL,'/ˈkoːn.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13587,'contorqueo','v','contorqu contors contort',NULL,NULL,'[kɔnˈtɔr.kᶣe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (13602,'contractus','a','contract contract contract',NULL,NULL,'[kɔnˈtrak.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13608,'contractio','n','contraction',NULL,NULL,'/konˈtrak.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13614,'contradico','v','contradic contradix contradict',NULL,NULL,'/kon.traːˈdiː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (13616,'contradictio','n','contradiction',NULL,NULL,'/kon.traːˈdik.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13617,'contradictor','n','contradictor',NULL,NULL,'/kon.traːˈdik.tor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (13624,'contraho','v','contrah contrax contract',NULL,NULL,'[ˈkɔn.tra.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13628,'contrapositum','n','contraposit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13633,'contrarius','a','contrari contrari contrari',NULL,NULL,'[kɔnˈtraː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13636,'contrarietas','n','contrarietat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13648,'contrecto','v','contrect contrectav contrectat',NULL,NULL,'[kɔnˈtrɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13654,'contremesco','v','contremesc contremu -',NULL,NULL,'[kɔn.trɛˈmeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13657,'contrio','v','contr contriv contrit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (13658,'contribuo','v','contribu contribu contribut',NULL,NULL,'[kɔnˈtrɪ.bʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13661,'contribulo','v','contribul - contribulat',NULL,NULL,'[kɔnˈtrɪ.bʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13665,'contributio','n','contribution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13666,'contrico','v','contric contricav contricat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13667,'contristo','v','contrist contristav contristat',NULL,NULL,'[kɔnˈtriːs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13669,'contritus','a','contrit contrit contrit',NULL,NULL,'[kɔnˈtriː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13671,'contritio','n','contrition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13673,'controversus','a','controvers controvers controvers',NULL,NULL,'[kɔn.troːˈwɛr.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13674,'controversor','v','controvers controversat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (13675,'controversia','n','controversi',NULL,NULL,'[kɔn.troːˈwɛr.si.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13684,'contrucido','v','contrucid contrucidav contrucidat',NULL,NULL,'[kɔn.trʊˈkiː.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13685,'contrudo','v','contrud contrus contrus',NULL,NULL,'[kɔnˈtruː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13687,'contueor','v','contu contuit -',NULL,NULL,'[kɔnˈtʊ.e.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (13690,'contubernalis','n','contubernal',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (13692,'contubernium','n','contuberni',NULL,NULL,'[kɔn.tʊˈbɛr.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (13693,'contuitus','n','contuit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (13694,'contumacia','n','contumaci',NULL,NULL,'/kon.tuˈma.ki.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13695,'contumaciter','r',NULL,NULL,NULL,'[kɔn.tʊˈmaː.kɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (13696,'contumax','a','contumac contumac contumac',NULL,NULL,'[ˈkɔn.tʊ.maːks]','aps---an3-');
INSERT INTO latin_morpho VALUES (13697,'contumelia','n','contumeli',NULL,NULL,'[kɔn.tʊˈmeː.li.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13703,'contumulo','v','contumul contumulav contumulat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13704,'contundo','v','contund contud contus',NULL,NULL,'[kɔnˈtʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13706,'conturbo','v','conturb conturbav conturbat',NULL,NULL,'[kɔnˈtʊr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13707,'conturbatus','a','conturbat conturbat conturbat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13708,'conturbatio','n','conturbation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13713,'contusum','n','contus',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13714,'contusio','n','contusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13718,'conubium','n','conubi',NULL,NULL,'[koːˈnuː.bi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (13720,'conubialis','a','conubial conubial conubial',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (13724,'convalesco','v','convalesc convalu -',NULL,NULL,'[kɔn.waˈɫeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13727,'convalescentia','n','convalescenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (13730,'convallo','v','convall convallav convallat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13732,'convallis','n','convall',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (13735,'convaso','v','convas convasav convasat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13738,'convector','n','convector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13739,'conveho','v','conveh convex convect',NULL,NULL,'[ˈkɔn.wɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13741,'convello','v','convell convuls convuls',NULL,NULL,'[kɔnˈwɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13744,'convenio','v','conven conven convent',NULL,NULL,'[kɔnˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (13746,'conveniens','a','convenient convenient convenient',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (13748,'convenientia','n','convenienti',NULL,NULL,'/kon.we.niˈen.ti.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13749,'conventum','n','convent',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13750,'conventus','n','convent',NULL,NULL,'[kɔnˈwɛn.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (13756,'conventio','n','convention',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13762,'convenusto','v','convenust convenustav convenusta',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13763,'converbero','v','converber converberav converberat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13773,'conversor','v','convers conversat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (13775,'conversatio','n','conversation',NULL,NULL,'[kɔn.wɛrˈsaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (13783,'converto','v','convert convert convers',NULL,NULL,'[kɔnˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13788,'convestio','v','convest convestiv convestit',NULL,NULL,'[kɔnˈwɛs.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (13791,'convexus','a','convex convex convex',NULL,NULL,'[kɔnˈwɛk.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13794,'convexio','n','convexion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13795,'convexitas','n','convexitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13799,'convicium','n','convici',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13800,'convicior','v','convici conviciat -',NULL,NULL,'[kɔnˈwiː.ki.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (13804,'convictus','n','convict',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (13805,'convictio','n','conviction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13808,'convinco','v','convinc convic convict',NULL,NULL,'[kɔnˈwɪŋ.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13809,'convinctio','n','convinction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13810,'conviolo','v','conviol conviolav conviolat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13812,'conviso','v','convis - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (13825,'convivator','n','convivator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (13827,'convivium','n','convivi',NULL,NULL,'[kɔnˈwiː.wi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (13829,'convoco','v','convoc convocav convocat',NULL,NULL,'[ˈkɔn.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13838,'convolvo','v','convolv convolv convolut',NULL,NULL,'[kɔnˈwɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13849,'convulsio','n','convulsion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13853,'cooperor','v','cooper cooperat -',NULL,NULL,'[kɔˈɔ.pɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (13856,'cooperator','n','cooperator',NULL,NULL,'[kɔ.ɔ.pɛˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (13858,'cooperculum','n','coopercul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13861,'cooperimentum','n','cooperiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13863,'coopertorium','n','coopertori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (13864,'coopto','v','coopt cooptav cooptat',NULL,NULL,'[kɔˈɔp.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13865,'cooptatio','n','cooptation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13869,'coorior','v','coor coort -',NULL,NULL,'[kɔˈɔ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (13880,'cophinus','n','cophin',NULL,NULL,'[ˈkɔ.pʰɪ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (13881,'copia','n','copi',NULL,NULL,'/ˈkoː.pi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13888,'copiosus','a','copios copios copios',NULL,NULL,'[koː.pɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13889,'copiose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13890,'copiositas','n','copiositat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13903,'copula','n','copul',NULL,NULL,'[ˈkoː.pʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13904,'copulo','v','copul copulav copulat',NULL,NULL,'/ˈkoː.pu.loː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (13909,'copulatus','a','copulat copulat copulat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13912,'copulatio','n','copulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (13917,'coqua','n','coqu',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (13918,'coquus','n','coqu',NULL,NULL,'[ˈkɔ.kʷʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (13920,'coquo','v','coqu cox coct',NULL,NULL,'[ˈkɔ.kʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (13923,'coquina','n','coquin',NULL,NULL,'[kɔˈkᶣiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (13925,'coquino','v','coquin coquinav coquinat',NULL,NULL,'[kɔˈkᶣiː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (13930,'coquinatorius','a','coquinatori coquinatori coquinatori',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (13938,'cor','n','cord',NULL,NULL,'[kɔr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (13944,'coracino','v','coracin coracinav coracinat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (13951,'corallium','n','coralli',NULL,NULL,'[kɔˈral.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (13956,'coram','r',NULL,NULL,NULL,'[ˈkoː.rã]','rp--------');
INSERT INTO latin_morpho VALUES (13961,'corax','n','corac',NULL,NULL,'[ˈkɔ.raks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (13962,'corban','n',NULL,NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (13964,'corbis','n','corb',NULL,NULL,'[ˈkɔr.bɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (13969,'corbula','n','corbul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (13984,'cordatus','a','cordat cordat cordat',NULL,NULL,'[kɔrˈdaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (13985,'cordate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (13998,'corium','n','cori',NULL,NULL,'[ˈkɔ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14004,'coriandrum','n','coriandr',NULL,NULL,'[kɔ.rɪˈan.drũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14011,'Corinthos','n','Corinth',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (14026,'cornu','n','corn',NULL,NULL,'[ˈkɔr.nuː]','n-s---nn4-');
INSERT INTO latin_morpho VALUES (14034,'cornicen','n','cornicin',NULL,NULL,'[ˈkɔr.nɪ.kẽ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14035,'cornicula','n','cornicul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14040,'cornicularius','n','corniculari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (14047,'corniger','a','corniger corniger corniger',NULL,NULL,'[ˈkɔr.nɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (14051,'cornix','n','cornic',NULL,NULL,'[ˈkɔr.niːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14063,'cornutus','a','cornut cornut cornut',NULL,NULL,'[kɔrˈnuː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14068,'corollarium','n','corollari',NULL,NULL,'[kɔ.roːlˈlaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14071,'corona','n','coron',NULL,NULL,'[kɔˈroː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14072,'corono','v','coron coronav coronat',NULL,NULL,'[kɔˈroː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14092,'corporaliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14097,'corporatio','n','corporation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14103,'corpulentus','a','corpulent corpulent corpulent',NULL,NULL,'[kɔr.pʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14105,'corpus','n','corpor',NULL,NULL,'[ˈkɔr.pʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (14106,'corpusculum','n','corpuscul',NULL,NULL,'[kɔrˈpʊs.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14109,'corrationalitas','n','corrationalitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14113,'correctio','n','correction',NULL,NULL,'[kɔrˈreːk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14123,'correpto','v','corrept correptav correptat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14125,'correptio','n','correption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14133,'corrigo','v','corrig correx correct',NULL,NULL,'[ˈkɔr.rɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (14135,'corripio','v','corrip corripu corrept',NULL,NULL,'[kɔrˈrɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (14141,'corroboro','v','corrobor corroborav corroborat',NULL,NULL,'[kɔrˈroː.bɔ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14148,'corrotundo','v','corrotund corrotundav corrotundat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14149,'corruo','v','corru corru -',NULL,NULL,'[ˈkɔr.rʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (14154,'corrumpo','v','corrump corrup corrupt',NULL,NULL,'[kɔrˈrʊm.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (14158,'corruptus','a','corrupt corrupt corrupt',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (14160,'corruptela','n','corruptel',NULL,NULL,'[kɔr.rʊpˈteː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14162,'corruptibilitas','n','corruptibilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14163,'corruptio','n','corruption',NULL,NULL,'[kɔrˈrʊp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14166,'corruptor','n','corruptor',NULL,NULL,'[kɔrˈrʊp.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14172,'corsa','n','cors',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14175,'Corsica','n','Corsic',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14180,'cortex','n','cortic',NULL,NULL,'[ˈkɔr.tɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14186,'cortina','n','cortin',NULL,NULL,'[kɔrˈtiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14195,'corusco','v','corusc coruscav coruscat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14197,'coruscatio','n','coruscation',NULL,NULL,'[kɔ.rʊsˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14199,'corvus','n','corv',NULL,NULL,'[ˈkɔr.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14208,'corymbus','n','corymb',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (14217,'corytos','n','coryt',NULL,NULL,NULL,'n-s---mn2g');
INSERT INTO latin_morpho VALUES (14220,'cos','n','cot',NULL,NULL,'/koːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14225,'cosmos','n','cosm',NULL,NULL,NULL,'n-s---mn2g');
INSERT INTO latin_morpho VALUES (14264,'cothurnus','n','cothurn',NULL,NULL,'[kɔˈtʰʊr.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14268,'coticula','n','coticul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14277,'cotoneum','n','cotone',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (14284,'cottidianus','a','cottidian cottidian cottidian',NULL,NULL,'[kɔt.tiː.dɪˈaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14296,'covinnus','n','covinn',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (14298,'coxa','n','cox',NULL,NULL,'[ˈkɔk.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14300,'coxendix','n','coxendic',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14305,'crabro','n','crabron',NULL,NULL,'/ˈkraː.broː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14308,'cramum','n','cram',NULL,NULL,'[ˈkraː.mũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14310,'crambe','n','cramb',NULL,NULL,'/ˈkram.beː/','n-s---fn1g');
INSERT INTO latin_morpho VALUES (14311,'crapula','n','crapul',NULL,NULL,'[ˈkraː.pʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14318,'cras','r',NULL,NULL,NULL,'/kraːs/','rp--------');
INSERT INTO latin_morpho VALUES (14320,'crasso','v','crass - crassat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14321,'crassus','a','crass crass crass',NULL,NULL,'[ˈkras.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14322,'crassamen','n','crassamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (14325,'crasse','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14327,'crassesco','v','crassesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (14331,'crassities','n','crassiti',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (14332,'crassitudo','n','crassitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14337,'crastino','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14345,'crater','n','crater',NULL,NULL,'/ˈkraː.teːr/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14351,'craticula','n','craticul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14353,'cratis','n','crat',NULL,NULL,'[ˈkraː.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (14356,'creo','v','cre creav creat',NULL,NULL,'/ˈkre.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (14363,'creatio','n','creation',NULL,NULL,'/kreˈaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14366,'creator','n','creator',NULL,NULL,'[krɛˈaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14367,'creatrix','n','creatric',NULL,NULL,'[krɛˈaː.trɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14368,'creatura','n','creatur',NULL,NULL,'/kre.aːˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14369,'creber','a','  ',NULL,NULL,'[ˈkreː.bɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (14374,'crebre','r',NULL,NULL,NULL,'/ˈkreː.breː/','rp--------');
INSERT INTO latin_morpho VALUES (14375,'crebresco','v','crebresc crebu -',NULL,NULL,'[kreːˈbrɛs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (14379,'crebritas','n','crebritat',NULL,NULL,'[ˈkreː.brɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14380,'crebriter','r',NULL,NULL,NULL,'[ˈkreː.brɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (14381,'crebritudo','n','crebritudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14382,'crebro','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14383,'credo','v','cred credid credit',NULL,NULL,'/ˈkreː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (14389,'credibilis','a','credibil credibil credibil',NULL,NULL,'/kreːˈdi.bi.lis/','aps---cn3i');
INSERT INTO latin_morpho VALUES (14391,'creditum','n','credit',NULL,NULL,'/ˈkreː.di.tum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14394,'creditor','n','creditor',NULL,NULL,'/ˈkreː.di.tor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14398,'credulus','a','credul credul credul',NULL,NULL,'/ˈkreː.du.lus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (14399,'credulitas','n','credulitat',NULL,NULL,'/kreːˈdu.li.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14401,'cremo','v','crem cremav cremat',NULL,NULL,'[ˈkrɛ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14404,'crematio','n','cremation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14406,'crementum','n','crement',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (14411,'cremor','n','cremor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (14415,'crepo','v','crep crepu crepit',NULL,NULL,'[ˈkrɛ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14426,'crepido','n','crepidin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14430,'crepitus','n','crepit',NULL,NULL,'[ˈkrɛ.pɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (14431,'crepito','v','crepit crepitav crepitat',NULL,NULL,'[ˈkrɛ.pɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14433,'crepitaculum','n','crepitacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (14438,'crepusculum','n','crepuscul',NULL,NULL,'[krɛˈpʊs.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14440,'cresco','v','cresc crev cret',NULL,NULL,'/ˈkreːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (14441,'crescentia','n','crescenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14443,'creta','n','cret',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14455,'cretio','n','cretion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14456,'cretosus','a','cretos cretos cretos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (14462,'cribello','v','cribell - cribellat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14463,'cribrum','n','cribr',NULL,NULL,'[ˈkriː.brũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14464,'cribro','v','cribr cribrav cribrat',NULL,NULL,'/ˈkriː.broː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (14469,'crimen','n','crimin',NULL,NULL,'[ˈkriː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (14471,'criminor','v','crimin criminat -',NULL,NULL,'[ˈkriː.mɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (14472,'criminalis','a','criminal criminal criminal',NULL,NULL,'[kriː.mɪˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (14475,'criminatio','n','crimination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14476,'criminator','n','criminator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (14481,'criminosus','a','criminos criminos criminos',NULL,NULL,'[kriː.mɪˈnoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14490,'crinis','n','crin',NULL,NULL,'[ˈkriː.nɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (14497,'crisis','n','cris',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (14499,'crispus','a','crisp crisp crisp',NULL,NULL,'[ˈkrɪs.pʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14500,'crispo','v','crisp crispav crispat',NULL,NULL,'/ˈkris.poː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (14504,'crispico','v','crispic crispicav crispicat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14510,'crista','n','crist',NULL,NULL,'[ˈkrɪs.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14528,'crocum','n','croc',NULL,NULL,'[ˈkrɔ.kũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14537,'crocio','v','croci  ',NULL,NULL,'[ˈkrɔ.ki.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (14546,'crocito','v','crocit crocitav crocitat',NULL,NULL,'[ˈkrɔ.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14548,'crocodilus','n','crocodil',NULL,NULL,'[krɔ.kɔˈdiː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14581,'crucio','v','cruci cruciav cruciat',NULL,NULL,'[ˈkrʊ.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14582,'cruciabilis','a','cruciabil cruciabil cruciabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (14583,'cruciabilitas','n','cruciabilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14586,'cruciamen','n','cruciamin',NULL,NULL,'[krʊ.kɪˈaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (14587,'cruciamentum','n','cruciament',NULL,NULL,'[krʊ.ki.aːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14591,'cruciatus','n','cruciat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (14592,'cruciatio','n','cruciation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14593,'cruciator','n','cruciator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (14596,'crucifigo','v','crucifig crucifix crucifix',NULL,NULL,'[krʊ.kɪˈfiː.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (14600,'crucifixio','n','crucifixion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14605,'crudus','a','crud crud crud',NULL,NULL,'/ˈkruːdus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (14609,'crudelitas','n','crudelitat',NULL,NULL,'/kruːˈdeː.li.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14613,'cruditas','n','cruditat',NULL,NULL,'/ˈkruːˈdi.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14615,'cruento','v','cruent cruentav cruentat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14616,'cruentus','a','cruent cruent cruent',NULL,NULL,'[krʊˈɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14619,'cruente','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14624,'crumena','n','crumen',NULL,'n-s---fn1-=crumina',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14626,'cruor','n','cruor',NULL,NULL,'[ˈkrʊ.ɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14633,'crus','n','crur',NULL,NULL,'/kruːs/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (14636,'crusta','n','crust',NULL,NULL,'[ˈkrʊs.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14638,'crusto','v','crust crustav crustat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14653,'crux','n','cruc',NULL,NULL,'[krʊks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14654,'crypta','n','crypt',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14659,'crystallum','n','crystall',NULL,NULL,'[krʏsˈtal.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14667,'cubus','n','cub',NULL,NULL,'[ˈkʊ.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14668,'cubo','v','cub cubav cubat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14674,'cubiculum','n','cubicul',NULL,NULL,'[kʊˈbɪ.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14680,'cubile','n','cubil',NULL,NULL,'[kʊˈbiː.ɫɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (14681,'cubitus','n','cubit',NULL,'n-s---nn2-=cubitum','/ˈku.bi.tus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (14684,'cubito','v','cubit cubitav cubitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (14698,'cuculus','n','cucul',NULL,NULL,'[kʊˈkuː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14701,'cuculla','n','cucull',NULL,NULL,'[kʊˈkʊl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14702,'cucullus','n','cucull',NULL,NULL,'[kʊˈkʊl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14711,'cucumis','n','cucumer',NULL,NULL,'[ˈkʊ.kʊ.mɪs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14725,'cudo','v','cud cud cus',NULL,NULL,'/ˈkuː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (14739,'culus','n','cul',NULL,NULL,'[ˈkuː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14741,'culcita','n','culcit',NULL,NULL,'[ˈkʊɫ.kɪ.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14759,'culina','n','culin',NULL,NULL,'[kʊˈliː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14772,'culmus','n','culm',NULL,NULL,'[ˈkʊɫ.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14774,'culmen','n','culmin',NULL,NULL,'[ˈkʊɫ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (14778,'culpa','n','culp',NULL,NULL,'[ˈkʊɫ.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14779,'culpo','v','culp culpav culpat',NULL,NULL,'[ˈkʊɫ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (14785,'culpatio','n','culpation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14789,'cultus','n','cult',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (14790,'cultus','a','cult cult cult',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (14792,'cultellus','n','cultell',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (14797,'culter','n','cultr',NULL,NULL,'[ˈkʊɫ.tɛr]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14798,'cultio','n','cultion',NULL,NULL,'[ˈkʊɫ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14800,'cultor','n','cultor',NULL,NULL,'[ˈkʊɫ.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14805,'cultura','n','cultur',NULL,NULL,'[kʊɫˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14817,'cumba','n','cumb',NULL,NULL,'[ˈkʊm.ba]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14822,'cuminum','n','cumin',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (14827,'cummi','n','-',NULL,'n-s---nn--=gummi',NULL,'n-s---nn--');
INSERT INTO latin_morpho VALUES (14831,'cumprime','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14832,'cumprimis','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14836,'cumulo','v','cumul cumulav cumulat',NULL,NULL,'/ˈku.mu.loː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (14837,'cumulatus','a','cumulat cumulat cumulat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (14838,'cumulate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14851,'cunctor','v','cunct cunctat -',NULL,NULL,'[ˈkʊŋk.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (14854,'cunctamen','n','cunctamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (14856,'cunctanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14858,'cunctatio','n','cunctation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14866,'cuneus','n','cune',NULL,NULL,'[ˈkʊ.ne.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14876,'cuniculus','n','cunicul',NULL,NULL,'[kʊˈniː.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (14879,'cunicularius','n','cuniculari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (14892,'cupa','n','cup',NULL,NULL,'/ˈkuː.pa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14895,'cuparius','n','cupari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (14902,'cupio','v','cup cupiv cupit',NULL,NULL,'[ˈkʊ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (14903,'cupidus','a','cupid cupid cupid',NULL,NULL,'[ˈkʊ.pɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (14907,'Cupido','n','Cupidin',NULL,NULL,'[kʊˈpiː.doː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (14910,'cupienter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (14942,'cur','r',NULL,NULL,NULL,'/kuːr/','rp--------');
INSERT INTO latin_morpho VALUES (14943,'cura','n','cur',NULL,NULL,'/ˈkuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (14944,'curo','v','cur curav curat',NULL,NULL,'/ˈkuː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (14945,'curabilis','a','curabil curabil curabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (14955,'curatio','n','curation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14956,'curator','n','curator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (14962,'curatura','n','curatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14969,'curia','n','curi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (14984,'curiosus','a','curios curios curios',NULL,NULL,'/kuː.riˈoː.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (14986,'curiositas','n','curiositat',NULL,NULL,'[kuː.rɪˈoː.sɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (14988,'curis','n','curit',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (14991,'currus','n','curr',NULL,NULL,'[ˈkʊr.rʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (14992,'curro','v','curr cucurr curs',NULL,NULL,'[ˈkʊr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (14995,'curriculum','n','curricul',NULL,NULL,'[kʊrˈrɪ.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (14999,'cursus','n','curs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (15004,'cursim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (15009,'cursor','n','cursor',NULL,NULL,'/ˈkur.sor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15015,'cursura','n','cursur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (15017,'curto','v','curt curtav curtat',NULL,NULL,'[ˈkʊr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15023,'curvus','a','curv curv curv',NULL,NULL,'[ˈkʊr.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (15024,'curvo','v','curv curvav curvat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15026,'curvamen','n','curvamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (15029,'curvatura','n','curvatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (15032,'curvitas','n','curvitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15033,'curvor','n','curvor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15041,'cuspis','n','cuspid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15045,'custodio','v','custod custodi custodit',NULL,NULL,'[kʊsˈtoː.di.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (15046,'custodia','n','custodi',NULL,NULL,'[kʊsˈtoː.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (15052,'custos','n','custod',NULL,NULL,'[ˈkʊs.toːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15056,'cutis','n','cut',NULL,NULL,'[ˈkʊ.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (15081,'cyclus','n','cycl',NULL,NULL,'[ˈkʏ.kɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (15087,'cyclicus','a','cyclic cyclic cyclic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (15090,'cycnus','n','cycn',NULL,'n-s---mn2-=cygnus',NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (15106,'cylindrus','n','cylindr',NULL,NULL,'[kʏˈlɪn.drʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (15107,'cylindratus','a','cylindrat cylindrat cylindrat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (15113,'cymatium','n','cymati',NULL,NULL,'[kyːˈma.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (15118,'cymbalum','n','cymbal',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15126,'cymbium','n','cymbi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15197,'Cypros','n','Cypr',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (15206,'cyprinus','n','cyprin',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (15230,'do','v','d dav dat',NULL,NULL,'/doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15235,'dactylicus','a','dactylic dactylic dactylic',NULL,NULL,'[dakˈtʏ.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (15243,'daemon','n','daemon',NULL,NULL,'[ˈdae̯.mõ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15245,'daemonion','n','daemoni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15256,'damalio','n','damalion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15258,'Damascos','n','Damasc',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (15265,'damma','n','damm',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (15267,'damnum','n','damn',NULL,NULL,'[ˈdam.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (15268,'damno','v','damn damnav damnat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15274,'damnatio','n','damnation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15281,'damnifico','v','damnific damnificav damnifica',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15283,'damnosus','a','damnos damnos damnos',NULL,NULL,'[damˈnoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (15296,'danista','n','danist',NULL,NULL,'/daˈniːs.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (15313,'daps','n','dap',NULL,NULL,'/daps/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15314,'dapsilis','a','dapsil dapsil dapsil',NULL,NULL,'[ˈda.psɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (15316,'dapsiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (15323,'datum','n','dat',NULL,NULL,'[ˈda.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (15334,'dator','n','dator',NULL,NULL,'[ˈda.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15342,'dea','n','de',NULL,NULL,'/ˈde.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (15349,'dealbo','v','dealb dealbav dealbat',NULL,NULL,'[dɛˈaɫ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15355,'deambulo','v','deambul deambulav deambulat',NULL,NULL,'[dɛˈam.bʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15357,'deambulatio','n','deambulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15361,'dearmo','v','dearm dearmav dearmat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15362,'deartuo','v','deartu deartuav deartuat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15365,'deauro','v','deaur deaurav deaurat',NULL,NULL,'[dɛˈau̯.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15367,'deaurator','n','deaurator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15368,'debeo','v','deb debu debit',NULL,NULL,'/ˈdeː.be.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (15369,'debacchor','v','debacch debacchat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (15370,'debacchatio','n','debacchation',NULL,NULL,'/deː.bakˈkʰaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15371,'debattuo','v','debattu - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (15373,'debello','v','debell debellav debellat',NULL,NULL,'[deːˈbɛl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15377,'debilis','a','debil debil debil',NULL,NULL,'/ˈdeː.bi.lis/','aps---cn3i');
INSERT INTO latin_morpho VALUES (15378,'debilito','v','debilit debilitav debilitat',NULL,NULL,'[deːˈbɪ.lɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15379,'debilitas','n','debilitat',NULL,NULL,'[deːˈbɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15380,'debilitatio','n','debilitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15382,'debitum','n','debit',NULL,NULL,'[ˈdeː.bɪ.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (15385,'debitor','n','debitor',NULL,NULL,'[ˈdeː.bɪ.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15414,'decanus','n','decan',NULL,NULL,'[dɛˈkaː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (15421,'decanto','v','decant decantav decantat',NULL,NULL,'/deːˈkan.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15431,'decas','n','decad',NULL,NULL,'[ˈdɛ.kaːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15437,'decedo','v','deced decess decess',NULL,NULL,'/deːˈkeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (15469,'decens','a','decent decent decent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (15471,'decentia','n','decenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (15472,'deceptus','n','decept',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (15473,'deceptio','n','deception',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15481,'decerno','v','decern decrev decret',NULL,NULL,'[deːˈkɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15482,'decerpo','v','decerp decerps decerpt',NULL,NULL,'[deːˈkɛr.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15484,'decerto','v','decert decertav decertat',NULL,NULL,'[deːˈkɛr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15486,'decertator','n','decertator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15488,'decessus','n','decess',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (15489,'decessio','n','decession',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15494,'decido','v','decid decid -',NULL,NULL,'[ˈdeː.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15498,'deciduus','a','decidu decidu decidu',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (15507,'decimatio','n','decimation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15513,'decipio','v','decip decep decept',NULL,NULL,'[deːˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (15514,'decipula','n','decipul',NULL,NULL,'[deːˈkɪ.pʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (15517,'decisio','n','decision',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15521,'declamo','v','declam declamav declamat',NULL,NULL,'[deːˈkɫaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15528,'declaro','v','declar declarav declarat',NULL,NULL,'[deːˈkɫaː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15529,'declaratio','n','declaration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15536,'declino','v','declin declinav declinat',NULL,NULL,'/deːˈkliː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15539,'declinatio','n','declination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15543,'declivitas','n','declivitat',NULL,NULL,'[deːˈkliː.wɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15554,'decollo','v','decoll decollav decollat',NULL,NULL,'[deːˈkɔl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15556,'decollatio','n','decollation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15558,'decoloro','v','decolor decolorav decolorat',NULL,NULL,'[deː.kɔˈɫoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15565,'decontor','v','decont decontat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (15567,'decoquo','v','decoqu decox decoct',NULL,NULL,'[ˈdeː.kɔ.kʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15573,'decorus','a','decor decor decor',NULL,NULL,'[dɛˈkoː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (15584,'decrementum','n','decrement',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15586,'decresco','v','decresc decrev decret',NULL,NULL,'/deːˈkreːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (15588,'decretum','n','decret',NULL,NULL,'[deːˈkreː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (15593,'decretio','n','decretion',NULL,NULL,'/deːˈkreː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15595,'decretorius','a','decretori decretori decretori',NULL,NULL,'[deː.kreːˈtoː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (15631,'decursus','n','decurs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (15632,'decursio','n','decursion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15633,'decurto','v','decurt decurtav decurtat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15637,'decus','n','dec',NULL,NULL,'[ˈdɛ.kʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (15643,'decussatio','n','decussation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15647,'decutio','v','decuti  ',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (15649,'dedo','v','ded dedid dedit',NULL,NULL,'/ˈdeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (15654,'dedecoro','v','dedecor dedecorav dedecorat',NULL,NULL,'[deːˈdɛ.kɔ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15655,'dedecoramentum','n','dedecorament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15656,'dedecoratio','n','dedecoration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15660,'dedecus','n','dedecor',NULL,NULL,'[ˈdeː.dɛ.kʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (15661,'dedico','v','dedic dedicav dedicat',NULL,NULL,'[ˈdeː.dɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15664,'dedicatio','n','dedication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15665,'dedicativus','a','dedicativ dedicativ dedicativ',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (15667,'dedicator','n','dedicator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15670,'dedignor','v','dedign dedignat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (15671,'dedignatio','n','dedignation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15672,'dedisco','v','dedisc dedidic -',NULL,NULL,'[deːˈdɪs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15676,'deditio','n','dedition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15684,'deduco','v','deduc dedux deduct',NULL,NULL,'/deːˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (15689,'deductio','n','deduction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15691,'deductor','n','deductor',NULL,NULL,'/deːˈduk.tor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15696,'deerro','v','deerr deerrav deerrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15697,'defaeco','v','defaec defaecav defaecat',NULL,NULL,'/deːˈfae̯.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15707,'defatigo','v','defatig defatigav defatigat',NULL,NULL,'/deː.faˈtiː.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15708,'defatigatio','n','defatigation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15714,'defectus','n','defect',NULL,NULL,'[deːˈfɛk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (15719,'defectivus','a','defectiv defectiv defectiv',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (15720,'defector','n','defector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15722,'defendo','v','defend defend defens',NULL,NULL,'[deːˈfɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15728,'defenso','v','defens defensav defensat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15730,'defensator','n','defensator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15734,'defensio','n','defension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15736,'defensor','n','defensor',NULL,NULL,'[deːˈfẽː.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15739,'defero','v','defer detul delat','v--pna--3-=deferre v2spia--3-=defers v3spia--3-=defert v2ppia--3-=defertis',NULL,'[ˈdeː.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15745,'defervesco','v','defervesc - -',NULL,NULL,'[deː.fɛrˈwɛs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15748,'defessus','a','defess defess defess',NULL,NULL,'[deːˈfɛs.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (15763,'defingo','v','defing definx defict',NULL,NULL,'[deːˈfɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15764,'definio','v','defin defini definit',NULL,NULL,'/deːˈfiː.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (15765,'definienter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (15766,'definitus','a','definit definit definit',NULL,NULL,'[deː.fiːˈniː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (15767,'definite','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (15768,'definitio','n','definition',NULL,NULL,'/deː.fiːˈniː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15782,'deflagro','v','deflagr deflagrav deflagrat',NULL,NULL,'[ˈdeː.fɫa.ɡroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15784,'deflammo','v','deflamm deflammav deflammat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15785,'deflecto','v','deflect deflex deflex',NULL,NULL,'[deːˈfɫɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15788,'deflexus','n','deflex',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (15792,'defloro','v','deflor deflorav deflorat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15794,'defloratio','n','defloration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15795,'defloresco','v','defloresc defloru -',NULL,NULL,'[deː.fɫoːˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15798,'defluo','v','deflu deflux defluct',NULL,NULL,'[ˈdeː.fɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15802,'defodio','v','defod defod defoss',NULL,NULL,'[deːˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (15806,'deforis','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (15807,'deformo','v','deform deformav deformat',NULL,NULL,'/deːˈfoːr.moː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15810,'deformatio','n','deformation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15813,'deformitas','n','deformitat',NULL,NULL,'[deːˈfoːr.mɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15817,'defraudo','v','defraud defraudav defraudat',NULL,NULL,'/deːˈfrau̯.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15822,'defrenatus','a','defrenat defrenat defrenat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (15824,'defrico','v','defric defricu defrict',NULL,NULL,'[ˈdeː.frɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15828,'defrigesco','v','defrigesc defrix -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (15839,'defuga','n','defug',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (15841,'defugio','v','defug defug -',NULL,NULL,'[deːˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (15847,'defunctus','n','defunct',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (15849,'defunctio','n','defunction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15852,'defundo','v','defund defud defus',NULL,NULL,'[deːˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15853,'defungor','v','defung defunct -',NULL,NULL,'/deːˈfun.ɡor/','v1spid--3-');
INSERT INTO latin_morpho VALUES (15857,'dego','v','deg - -',NULL,NULL,'/ˈdeː.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (15858,'degener','a','degener degener degener',NULL,NULL,'[ˈdeː.ɡɛ.nɛr]','aps---an3-');
INSERT INTO latin_morpho VALUES (15860,'degenero','v','degener degenerav degenerat',NULL,NULL,'[deːˈɡɛ.nɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15861,'degeneratio','n','degeneration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15862,'degero','v','deger degess degest',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (15864,'deglubo','v','deglub deglups deglupt',NULL,NULL,'[deːˈɡɫuː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (15868,'degrado','v','degrad degradav degradat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15869,'degradatio','n','degradation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15873,'degredior','v','degred degress -',NULL,NULL,'[deːˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (15877,'degulo','v','degul degulav degulat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15878,'degulator','n','degulator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (15881,'degusto','v','degust degustav degustat',NULL,NULL,'[deːˈɡʊs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15887,'dehisco','v','dehisc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (15888,'dehonestus','a','dehonest dehonest dehonest',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (15889,'dehonesto','v','dehonest dehonestav dehonestat',NULL,NULL,'[dɛ.hɔˈnɛs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15890,'dehonestamentum','n','dehonestament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15892,'dehonoro','v','dehonor dehonorav dehonorat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15899,'deicio','v','deic deiec deiect',NULL,NULL,'[deːˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (15905,'deifico','v','deific deificav deificat',NULL,NULL,'[dɛˈɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15910,'deinceps','a','deincipit deincipit deincipit',NULL,NULL,'[dɛˈɪŋ.kɛps]or disyllabic:','aps---an3-');
INSERT INTO latin_morpho VALUES (15912,'deinde','r',NULL,NULL,NULL,'[dɛˈɪn.dɛ]or disyllabic:','rp--------');
INSERT INTO latin_morpho VALUES (15914,'deintegro','v','deintegr deintegrav deintegrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15938,'deleo','v','del delev delet',NULL,NULL,'[ˈdeː.ɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (15939,'delabor','v','delab delaps -',NULL,NULL,'[deːˈɫaː.bɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (15944,'delacrimatio','n','delacrimation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15952,'delasso','v','delass delassav delassat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15954,'delatio','n','delation',NULL,NULL,'[deːˈɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15955,'delator','n','delator',NULL,NULL,'[deːˈɫaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (15957,'delatura','n','delatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (15964,'delecto','v','delect delectav delectat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (15966,'delectabilis','a','delectabil delectabil delectabil',NULL,NULL,'[deː.ɫɛkˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (15968,'delectamentum','n','delectament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15969,'delectatio','n','delectation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15974,'delego','v','deleg delegav delegat',NULL,NULL,'[deːˈɫeː.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (15977,'delegatio','n','delegation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (15979,'delenio','v','delen deleni delenit',NULL,NULL,'[deːˈɫeː.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (15981,'delenimentum','n','deleniment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15991,'deletio','n','deletion',NULL,NULL,'[deːˈɫeː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (15996,'delibo','v','delib delibav delibat',NULL,NULL,'/deːˈliː.boː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (15997,'delibamentum','n','delibament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (15999,'delibero','v','deliber deliberav deliberat',NULL,NULL,'[deːˈliː.bɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16002,'deliberatus','a','deliberat deliberat deliberat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16013,'delicatus','a','delicat delicat delicat',NULL,NULL,'[deː.lɪˈkaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16020,'delicium','n','delici',NULL,'n-s---fn1-=delicia','[deːˈlɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16026,'delictum','n','delict',NULL,NULL,'[deːˈlɪk.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16030,'deligo','v','delig deligav deligat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16035,'delimito','v','delimit delimitav delimitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16037,'delino','v','delin - delit',NULL,NULL,'[ˈdeː.lɪ.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16038,'delineo','v','deline delineav delineat',NULL,NULL,'/deːˈliː.ne.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16039,'delineatio','n','delineation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16040,'delingo','v','deling delinx delinct',NULL,NULL,'[deːˈlɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16048,'delinquo','v','delinqu deliqu delict',NULL,NULL,'[deːˈlɪŋ.kʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16049,'delinquentia','n','delinquenti',NULL,NULL,'[deː.lɪŋˈkᶣɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (16052,'deliquo','v','deliqu deliquav deliquat',NULL,NULL,'[ˈdeː.lɪ.kʷoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16054,'deliquesco','v','deliquesc delicu -',NULL,NULL,'[deː.lɪˈkᶣeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16056,'deliquium','n','deliqui',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16057,'deliquio','n','deliquion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16058,'delirus','a','delir delir delir',NULL,NULL,'[deːˈliː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16060,'deliramentum','n','delirament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16061,'deliratio','n','deliration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16062,'delirium','n','deliri',NULL,NULL,'/deːˈliː.ri.um/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16063,'deliritas','n','deliritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16065,'delitesco','v','delitisc delitu -',NULL,NULL,'/deː.liˈteːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16069,'delocatio','n','delocation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16073,'delphin','n','delphin',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16077,'delubrum','n','delubr',NULL,NULL,'[deːˈɫuː.brũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16078,'delucto','v','deluct deluctav deluctat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16081,'deludo','v','delud delus delus',NULL,NULL,'[deːˈɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16085,'delumbo','v','delumb - delumbat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16091,'demo','v','dem demps dempt',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16097,'demando','v','demand demandav demandat',NULL,NULL,'/deːˈman.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16104,'demeo','v','deme demeav demeat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16108,'demens','a','dement dement dement',NULL,NULL,'[ˈdeː.mẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (16111,'dementer','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16113,'dementia','n','dementi',NULL,NULL,'[deːˈmɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (16114,'demereo','v','demer demeru demerit',NULL,NULL,'[deːˈmɛ.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16116,'demergo','v','demerg demers demers',NULL,NULL,'[deːˈmɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16121,'demeto','v','demet demetav demetat',NULL,NULL,'[ˈdeː.mɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16126,'demigratio','n','demigration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16127,'deminoro','v','deminor deminorav deminorat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16129,'deminuo','v','deminu deminu deminut',NULL,NULL,'[deːˈmɪ.nʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16130,'deminutus','a','deminut deminut deminut',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16131,'deminutio','n','deminution',NULL,'n-s---fn3-=diminutio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16136,'demissus','a','demiss demiss demiss',NULL,NULL,'[deːˈmɪs.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16137,'demisse','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16139,'demissio','n','demission',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16152,'demolio','v','demoli  ',NULL,NULL,'/deːˈmoː.li.oː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16154,'demolitio','n','demolition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16156,'demonstro','v','demonstr demonstrav demonstrat',NULL,NULL,'[deːˈmõː.stroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16158,'demonstratio','n','demonstration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16162,'demonstrator','n','demonstrator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16164,'demoror','v','demor demorat -',NULL,NULL,'[ˈdeː.mɔ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (16167,'demorior','v','demor demortu -',NULL,NULL,'[deːˈmɔ.ri.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (16173,'Demosthenes','n','Demosthen',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16174,'demoveo','v','demov demov demot',NULL,NULL,'[deːˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16175,'demptio','n','demption',NULL,NULL,'[ˈdɛmp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16178,'demulceo','v','demulc demuls demulct',NULL,NULL,'[deːˈmʊɫ.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16180,'demum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16186,'demuto','v','demut demutav demutat',NULL,NULL,'/deːˈmuː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16188,'demutatio','n','demutation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16190,'demutilo','v','demutil demutilav demutilat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16210,'denego','v','deneg denegav denegat',NULL,NULL,'[ˈdeː.nɛ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16213,'denigro','v','denigr denigrav denigrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16215,'denique','r',NULL,NULL,NULL,'[ˈdeː.nɪ.kᶣɛ]','rp--------');
INSERT INTO latin_morpho VALUES (16217,'denomino','v','denomin denominav denominat',NULL,NULL,'[deːˈnoː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16218,'denominatio','n','denomination',NULL,NULL,'[deː.noː.mɪˈnaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16219,'denominativus','a','denominativ denominativ denominativ',NULL,NULL,'[deː.noː.mɪ.naːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16223,'denoto','v','denot denotav denotat',NULL,NULL,'[ˈdeː.nɔ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16226,'denotatio','n','denotation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16227,'denso','v','dens densav densat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16228,'densus','a','dens dens dens',NULL,NULL,'[ˈdẽː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16229,'denseo','v','dens - denset',NULL,NULL,'[ˈdẽː.se.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16230,'dens','n','dent',NULL,NULL,'[dẽːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (16231,'densabilis','a','densabil densabil densabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (16232,'densatio','n','densation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16234,'dense','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16236,'densitas','n','densitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16237,'dentale','n','dental',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (16253,'dentifricium','n','dentifrici',NULL,NULL,'[dɛn.tɪˈfrɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16256,'dentiscalpium','n','dentiscalpi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16263,'denudo','v','denud denudav denudat',NULL,NULL,'/deːˈnuː.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16267,'denumeratio','n','denumeration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16269,'denuntio','v','denunti denuntiav denuntiat',NULL,NULL,'[deːˈnʊn.ti.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16270,'denuntiatio','n','denuntiation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16274,'denuo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16276,'deonero','v','deoner deonerav deonerat',NULL,NULL,'[dɛˈɔ.nɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16278,'deoperio','v','deoper deoperu deopert',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (16279,'deopto','v','deopt deoptav deoptat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16284,'deorsum','r',NULL,NULL,NULL,'[dɛˈɔr.sũ]','rp--------');
INSERT INTO latin_morpho VALUES (16290,'depalo','v','depal depalav depalat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16297,'depasco','v','depasc depav depast',NULL,NULL,'/deːˈpaːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16298,'depascor','v','depasc depast -',NULL,NULL,NULL,'v1spid--3-');
INSERT INTO latin_morpho VALUES (16305,'depeciscor','v','depecisc depect -',NULL,NULL,'[deː.pɛˈkɪs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (16306,'depecto','v','depect depex depex',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16307,'depectio','n','depection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16310,'depeculor','v','depecul depeculat -',NULL,NULL,'[deː.pɛˈkuː.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (16312,'depello','v','depell depellav depella',NULL,NULL,'[deːˈpɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16313,'dependo','v','depend depend depens',NULL,NULL,'[deːˈpɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16318,'depensio','n','depension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16319,'deperdo','v','deperd deperdid deperdit',NULL,NULL,'[deːˈpɛr.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16322,'deperditio','n','deperdition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16323,'depereo','v','deperi deperiv deperit',NULL,NULL,'[deːˈpɛ.re.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16331,'depingo','v','deping depinx depict',NULL,NULL,'[deːˈpɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16332,'depinnatus','a','depinnat depinnat depinnat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16333,'depleo','v','depl deplev deplet',NULL,NULL,'[ˈdeː.pɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16336,'deplango','v','deplang deplanx deplanct',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16337,'deplanto','v','deplant deplantav deplantat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16343,'deploro','v','deplor deplorav deplorat',NULL,NULL,'[deːˈpɫoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16345,'deploratus','a','deplorat deplorat deplorat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16353,'depompo','v','depomp depompav depompa',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16356,'depono','v','depon deposu deposit',NULL,NULL,'/deːˈpoː.noː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16364,'depopulor','v','depopul depopulat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (16365,'depopulatio','n','depopulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16366,'depopulator','n','depopulator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16368,'deporto','v','deport deportav deportat',NULL,NULL,'[deːˈpɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16372,'deposco','v','deposc depoposc -',NULL,NULL,'[deːˈpɔs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16373,'depositum','n','deposit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16375,'depositarius','n','depositari',NULL,NULL,'[deː.pɔ.sɪˈtaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (16376,'depositio','n','deposition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16379,'depositor','n','depositor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16380,'depostulo','v','depostul depostulav depostulat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16383,'depraedor','v','depraed depraedat -',NULL,NULL,'[deːˈprae̯.dɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (16384,'depraedatio','n','depraedation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16385,'depraedator','n','depraedator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16390,'depravo','v','deprav depravav depravat',NULL,NULL,'/deːˈpraː.woː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16392,'depravatio','n','depravation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16394,'deprecor','v','deprec deprecat -',NULL,NULL,'[ˈdeː.prɛ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (16398,'deprecatio','n','deprecation',NULL,NULL,'[deː.prɛˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16406,'deprehendo','v','deprehend deprehend deprehens',NULL,NULL,'[deː.prɛˈhɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16412,'depressio','n','depression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16414,'depretio','v','depreti depretiav depretiat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16416,'deprimo','v','deprim depress depress',NULL,NULL,'[ˈdeː.prɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16419,'depromo','v','deprom depromps deprompt',NULL,NULL,'/deːˈproː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16422,'depso','v','deps depsu depst',NULL,NULL,'[ˈdɛ.psoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16429,'depudico','v','depudic depudicav depudicat',NULL,NULL,'[deːˈpʊ.dɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16445,'depurgatio','n','depurgation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16446,'deputo','v','deput deputav deputat',NULL,NULL,'[ˈdeː.pʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16448,'deputatio','n','deputation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16454,'derado','v','derad deras deras',NULL,NULL,'/deːˈraː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16463,'derelictus','n','derelict',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (16465,'derelictio','n','dereliction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16467,'derelinquo','v','derelinqu dereliqu derelict',NULL,NULL,'[deː.rɛˈlɪŋ.kʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16470,'derideo','v','derid deris deris',NULL,NULL,'/deːˈriː.de.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (16471,'deridiculum','n','deridicul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16476,'deripio','v','derip deripu derept',NULL,NULL,'[deːˈrɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (16477,'derisus','n','deris',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (16479,'derisio','n','derision',NULL,NULL,'/deːˈriː.si.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16480,'derisor','n','derisor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16482,'derivo','v','deriv derivav derivat',NULL,NULL,'/deːˈriː.woː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16483,'derivatio','n','derivation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16485,'derivativus','a','derivativ derivativ derivativ',NULL,NULL,'[deː.riː.waːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16487,'derogo','v','derog derogav derogat',NULL,NULL,'[ˈdeː.rɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16489,'derogator','n','derogator',NULL,NULL,'[deː.rɔˈɡaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (16494,'deruncino','v','deruncin - deruncinat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16499,'desum','v','de defu -','v--pna--3-=deesse v1spia--3-=desum v2spia--3-=dees v3spia--3-=deest v1ppia--3-=desumus v2ppia--3-=deestis v3ppia--3-=desunt',NULL,'[ˈdeː.sũ]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16502,'desaevio','v','desaev desaevi desaevit',NULL,NULL,'/deːˈsae̯.wi.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (16507,'descensio','n','descension',NULL,NULL,'[deːsˈkẽː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16509,'descindo','v','descind desciss -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16510,'descisco','v','descisc desciv descit',NULL,NULL,'/deːsˈkiːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16511,'descobino','v','descobin descobinav descobinat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16512,'describo','v','describ descrips descript',NULL,NULL,'/deːsˈkriː.boː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16516,'descriptio','n','description',NULL,NULL,'/deːsˈkriːp.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16520,'descrobo','v','descrob descrobav descrobat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16522,'deseco','v','desec desecu desect',NULL,NULL,'[ˈdeː.sɛ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16523,'desecatio','n','desecation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16524,'desectio','n','desection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16527,'desero','v','deser deseru desert',NULL,NULL,'[ˈdeː.sɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16533,'desertus','a','desert desert desert',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16535,'desertor','n','desertor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16537,'deservio','v','deserv deservi deservit',NULL,NULL,'[deːˈsɛr.wi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (16538,'deses','a','desid desid desid',NULL,NULL,'[ˈdeː.sɛs]','aps---an3-');
INSERT INTO latin_morpho VALUES (16543,'desido','v','desid desed -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16545,'desidero','v','desider desiderav desiderat',NULL,NULL,'[deːˈsiː.dɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16546,'desiderabilis','a','desiderabil desiderabil desiderabil',NULL,NULL,'[deː.siː.dɛˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (16550,'desideratio','n','desideration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16552,'desiderium','n','desideri',NULL,NULL,'[deː.siːˈdɛ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16553,'desidia','n','desidi',NULL,NULL,'[deːˈsɪ.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (16560,'designo','v','design designav designat',NULL,NULL,'[deːˈsɪŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16563,'designatio','n','designation',NULL,NULL,'[deː.sɪŋˈnaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16568,'desino','v','desin desi desit',NULL,NULL,'[ˈdeː.sɪ.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16573,'desipiens','a','desipient desipient desipient',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (16574,'desipientia','n','desipienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (16575,'desisto','v','desist destit destit',NULL,NULL,'[deːˈsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16578,'desolo','v','desol desolav desolat',NULL,NULL,'[deːˈsoː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16580,'desolatio','n','desolation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16588,'despectus','n','despect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (16589,'despectus','a','despect despect despect',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16590,'despecto','v','despect despectav despectat',NULL,NULL,'[deːsˈpɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16593,'despectio','n','despection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16600,'desperatus','a','desperat desperat desperat',NULL,NULL,'[deːs.peːˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16605,'despicor','v','despic despicat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (16606,'despicabilis','a','despicabil despicabil despicabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (16608,'despicatus','n','despicat',NULL,NULL,'[deːs.pɪˈkaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (16610,'despicatio','n','despication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16611,'despicio','v','despic despex despect',NULL,NULL,'[deːsˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (16612,'despicientia','n','despicienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (16615,'despolio','v','despoli despoliav despoliat',NULL,NULL,'[deːsˈpɔ.li.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16619,'despondeo','v','despond despond despons',NULL,NULL,'[deːsˈpɔn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16624,'desponsatio','n','desponsation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16629,'despuo','v','despu despu desput',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16632,'desputum','n','desput',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16634,'desquamo','v','desquam desquamav desquamat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16641,'desterno','v','destern destrav destrat',NULL,NULL,'[deːsˈtɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16644,'destillo','v','destill destillav destillat',NULL,NULL,'[deːsˈtɪl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16645,'destillatio','n','destillation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16648,'destina','n','destin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (16649,'destino','v','destin destinav destinat',NULL,NULL,'[ˈdeːs.tɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16652,'destinatus','a','destinat destinat destinat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16654,'destinate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16655,'destinatio','n','destination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16659,'destituo','v','destitu destitu destitut',NULL,NULL,'[deːsˈtɪ.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16661,'destitutio','n','destitution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16664,'destrictus','a','destrict destrict destrict',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16666,'destricte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16669,'destruo','v','destru destrux destruct',NULL,NULL,'[ˈdeːs.trʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16671,'destructilis','a','destructil destructil destructil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (16672,'destructio','n','destruction',NULL,NULL,'[deːsˈtrʊk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16673,'destructivus','a','destructiv destructiv destructiv',NULL,NULL,'[deːs.trʊkˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16674,'destructor','n','destructor',NULL,NULL,'[deːsˈtrʊk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (16680,'desudo','v','desud desudav desudat',NULL,NULL,'[dɛˈsuː.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16682,'desudatio','n','desudation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16687,'desuetudo','n','desuetudin',NULL,NULL,'[deː.sʊ.eːˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16688,'desugo','v','desug desux desuct',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16696,'desumo','v','desum - desupt',NULL,NULL,'/deːˈsuː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16700,'desurgo','v','desurg desurrex desurrect',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16704,'detectio','n','detection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16706,'detego','v','deteg detex detect',NULL,NULL,'[ˈdeː.tɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16707,'detendo','v','detend - detens',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16710,'detento','v','detent - detentat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16711,'detentatio','n','detentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16713,'detentio','n','detention',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16715,'detero','v','deter detriv detrit',NULL,NULL,'[ˈdeː.tɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16716,'detergeo','v','deterg deters deters',NULL,NULL,'[deːˈtɛr.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16720,'determino','v','determin determinav determinat',NULL,NULL,'[deːˈtɛr.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16722,'determinatio','n','determination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16726,'deterreo','v','deterr deterru deterrit',NULL,NULL,'[deːˈtɛr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16729,'detestor','v','detest detestat -',NULL,NULL,'[deːˈtɛs.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (16732,'detestatio','n','detestation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16736,'detexo','v','detex detexu detext',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (16737,'detineo','v','detin detinu detent',NULL,NULL,'[deːˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16738,'detono','v','deton detonu -',NULL,NULL,'[ˈdeː.tɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16740,'detondeo','v','detond detotond detons',NULL,NULL,'[deːˈtɔn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16742,'detonso','v','detons detonsav detonsa',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16745,'detorqueo','v','detorqu detors detort',NULL,NULL,'[deːˈtɔr.kᶣe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16748,'detractus','n','detract',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (16753,'detractio','n','detraction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16754,'detractor','n','detractor',NULL,NULL,'[deːˈtrak.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (16757,'detraho','v','detrah detrax detract',NULL,NULL,'/ˈdeː.tra.hoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16758,'detrecto','v','detrect detrectav detrectat',NULL,NULL,'[deːˈtrɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16759,'detrectatio','n','detrectation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16763,'detrimentum','n','detriment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16765,'detrimentosus','a','detrimentos detrimentos detrimentos',NULL,NULL,'[deː.triː.mɛnˈtoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16767,'detritus','a','detrit detrit detrit',NULL,NULL,'/deːˈtriː.tus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (16769,'detrudo','v','detrud detrus detrus',NULL,NULL,'/deːˈtruː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16770,'detrunco','v','detrunc detruncav detruncat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16776,'deturbo','v','deturb deturbav deturbat',NULL,NULL,'[deːˈtʊr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16778,'deturpo','v','deturp deturpav deturpat',NULL,NULL,'[deːˈtʊr.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16780,'deuro','v','deur deuss deust',NULL,NULL,'/deːˈuː.roː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16786,'devastatio','n','devastation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16787,'deveho','v','deveh devex devect',NULL,NULL,'[ˈdeː.wɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16789,'deveneror','v','devener devenerat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (16790,'devenio','v','deven deven devent',NULL,NULL,'[deːˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (16792,'deversor','v','devers deversat -',NULL,NULL,'[deːˈwɛr.sɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (16793,'deversorium','n','deversori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16796,'deverto','v','devert devert devers',NULL,NULL,'[deːˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16797,'deverticulum','n','deverticul',NULL,NULL,'[deː.wɛrˈtɪ.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16801,'deviatio','n','deviation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16803,'devincio','v','devinc devinx devinct',NULL,NULL,'[deːˈwɪŋ.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (16804,'devirgino','v','devirgin devirginav devirginat',NULL,NULL,'[deːˈwɪr.ɡɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16805,'devito','v','devit devitav devitat',NULL,NULL,'/deːˈwiː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16811,'devoro','v','devor devorav devorat',NULL,NULL,'[ˈdeː.wɔ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16813,'devorator','n','devorator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (16818,'devotatio','n','devotation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16819,'devotio','n','devotion',NULL,NULL,'/deːˈwoː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16821,'devoveo','v','devov devov devot',NULL,NULL,'[deːˈwɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (16827,'dexteritas','n','dexteritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16829,'dextrale','n','dextral',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (16836,'dies','n','di',NULL,NULL,'/ˈdi.eːs/','n-s---mn5-');
INSERT INTO latin_morpho VALUES (16839,'diabetes','n','diabet',NULL,NULL,NULL,'n-s---mn1g');
INSERT INTO latin_morpho VALUES (16840,'diabolus','n','diabol',NULL,NULL,'[dɪˈa.bɔ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (16843,'diaconus','n','diacon',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (16853,'diadema','n','diadem',NULL,NULL,'/di.aˈdeː.ma/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (16857,'diaeta','n','diaet',NULL,NULL,'[dɪˈae̯.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (16861,'Dialis','a','Dial Dial Dial',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (16862,'dialectos','n','dialect',NULL,NULL,'[di.aˈɫɛk.tɔs]','n-s---fn2g');
INSERT INTO latin_morpho VALUES (16866,'dialecticus','a','dialectic dialectic dialectic',NULL,NULL,'[di.aˈɫɛk.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16871,'diametros','n','diametr',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (16874,'Diana','n','Dian',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (16880,'diaphragma','n','diaphragmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (16882,'diarium','n','diari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (16892,'diatonicus','a','diatonic diatonic diatonic',NULL,NULL,'[di.aˈtɔ.nɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16893,'diatriba','n','diatrib',NULL,NULL,'/diˈa.tri.ba/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (16897,'dico','v','dic dicav dicat',NULL,NULL,'/ˈdiː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (16906,'dicax','a','dicac dicac dicac',NULL,NULL,'[ˈdɪ.kaːks]','aps---an3-');
INSERT INTO latin_morpho VALUES (16910,'dicio','n','dicion',NULL,'n-s---fn3-=ditio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16912,'dictum','n','dict',NULL,NULL,'[ˈdɪk.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16913,'dictus','n','dict',NULL,NULL,'[ˈdɪk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (16914,'dicto','v','dict dictav dictat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (16918,'dictamnum','n','dictamn',NULL,NULL,'[dɪkˈtam.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (16920,'dictator','n','dictator',NULL,NULL,'[dɪkˈtaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (16922,'dictatura','n','dictatur',NULL,NULL,'[dɪk.taːˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (16924,'dictio','n','diction',NULL,NULL,'[ˈdɪk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16929,'dido','v','did didid didit',NULL,NULL,'/ˈdiː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16932,'Dido','n','Didon',NULL,NULL,'/ˈdiː.doː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16938,'diduco','v','diduc didux diduct',NULL,NULL,'/diːˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (16950,'diffamo','v','diffam diffamav diffamat',NULL,NULL,'[dɪfˈfaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (16953,'differo','v','differ distul dilat','v--pna--3-=differre v2spia--3-=differs v3spia--3-=differt v2ppia--3-=differtis',NULL,'[ˈdɪf.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16955,'differens','a','different different different',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (16956,'differenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (16957,'differentia','n','differenti',NULL,NULL,'[dɪf.fɛˈrɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (16959,'differitas','n','differitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (16960,'differtus','a','differt differt differt',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (16962,'difficilis','a','difficil difficil difficil',NULL,NULL,'[dɪfˈfɪ.kɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (16964,'difficultas','n','difficultat',NULL,NULL,'/dif.fiˈkul.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (16967,'diffidentia','n','diffidenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (16968,'diffindo','v','diffind diffid diffiss',NULL,NULL,'[dɪfˈfɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16973,'diffiteor','v','diffit  -',NULL,NULL,'[dɪfˈfɪ.te.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (16976,'diffringo','v','diffring diffreg diffract',NULL,NULL,'[dɪfˈfrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16977,'diffugio','v','diffug diffug -',NULL,NULL,'[dɪfˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (16978,'diffundo','v','diffund diffud diffus',NULL,NULL,'[dɪfˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16986,'digero','v','diger digess digest',NULL,NULL,'[ˈdiː.ɡɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (16987,'digeries','n','digeri',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (16989,'digitus','n','digit',NULL,NULL,'[ˈdɪ.ɡɪ.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (16993,'digladior','v','digladi digladiat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (16996,'dignus','a','dign dign dign',NULL,NULL,'[ˈdɪŋ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (16999,'dignanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17000,'dignatio','n','dignation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17001,'digne','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17002,'dignitas','n','dignitat',NULL,NULL,'[ˈdiːŋ.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17003,'dignosco','v','dignosc dignov dignot',NULL,NULL,'[diːŋˈnoːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17004,'digredior','v','digred digress -',NULL,NULL,'[diːˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (17005,'digressus','n','digress',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (17006,'digressio','n','digression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17015,'dilabor','v','dilab dilaps -',NULL,NULL,'[diːˈɫaː.bɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (17019,'dilapido','v','dilapid dilapidav dilapidat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17022,'dilato','v','dilat dilatav dilatat',NULL,NULL,'[diːˈɫaː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17023,'dilatatio','n','dilatation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17024,'dilatio','n','dilation',NULL,NULL,'[diːˈɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17027,'dilectus','n','dilect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (17030,'dilectio','n','dilection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17032,'diligo','v','dilig dilex dilect',NULL,NULL,'[ˈdiː.lɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17033,'diligens','a','diligent diligent diligent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (17034,'diligenter','r',NULL,NULL,NULL,'[diː.lɪˈɡɛn.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (17035,'diligentia','n','diligenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17039,'diluo','v','dilu dilu dilut',NULL,NULL,'[ˈdiː.ɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17042,'dilucidus','a','dilucid dilucid dilucid',NULL,NULL,'[diːˈɫuː.kɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17043,'diluculum','n','dilucul',NULL,NULL,'[diːˈɫuː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17049,'diluvium','n','diluvi',NULL,NULL,'[diːˈɫʊ.wi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17050,'diluvies','n','diluvi',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (17052,'dimensio','n','dimension',NULL,NULL,'[diːˈmẽː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17054,'dimeto','v','dimet dimetav dimetat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17057,'dimetior','v','dimet dimens -',NULL,NULL,'[diːˈmeː.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (17058,'dimico','v','dimic dimicav dimicat',NULL,NULL,'[ˈdiː.mɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17059,'dimicatio','n','dimication',NULL,NULL,'[diː.mɪˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17081,'dioecesis','n','dioeces',NULL,NULL,'[di.oe̯ˈkeː.sɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17088,'Diovis','n','Diov',NULL,'n-s---mn3-=Iovis n-s---mn3-=Iupiter n-s---mn3-=Iuppiter',NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (17091,'diphthongos','n','diphthong',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (17107,'directus','a','direct direct direct',NULL,NULL,'[diːˈrɛk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17109,'directio','n','direction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17115,'diremptio','n','diremption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17116,'direptio','n','direption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17117,'direptor','n','direptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17121,'dirigo','v','dirig direx direct',NULL,NULL,'[ˈdiː.rɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17123,'dirimo','v','dirim direm dirempt',NULL,NULL,'[ˈdɪ.rɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17125,'diripio','v','dirip diripu dirept',NULL,NULL,'[diːˈrɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17131,'discus','n','disc',NULL,NULL,'/ˈdis.kus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (17132,'disco','v','disc didic -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (17135,'discedo','v','disced discess discess',NULL,NULL,'[dɪsˈkeː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17136,'discepto','v','discept disceptav disceptat',NULL,NULL,'[dɪsˈkɛp.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17137,'disceptatio','n','disceptation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17138,'disceptator','n','disceptator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17140,'discerno','v','discern discrev discret',NULL,NULL,'[dɪsˈkɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17141,'discerpo','v','discerp discerps discerpt',NULL,NULL,'[dɪsˈkɛr.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17145,'discidium','n','discidi',NULL,NULL,'[diːsˈkɪ.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17147,'discindo','v','discind discid disciss',NULL,NULL,'[diːsˈkɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17148,'disciplina','n','disciplin',NULL,NULL,'[dɪs.kɪˈpliː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17153,'discipulus','n','discipul',NULL,NULL,'[dɪsˈkɪ.pʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (17156,'discludo','v','disclud disclus disclus',NULL,NULL,'[dɪsˈkɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17162,'discooperio','v','discooper discooperu discoopert',NULL,NULL,'[dɪs.kɔ.ɔˈpɛ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (17167,'discordia','n','discordi',NULL,NULL,'[dɪsˈkɔr.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17168,'discordium','n','discordi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17171,'discors','a','discord discord discord',NULL,NULL,'/ˈdis.kors/','aps---an3-');
INSERT INTO latin_morpho VALUES (17173,'discrepo','v','discrep discrepav discrepat',NULL,NULL,'[ˈdɪs.krɛ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17174,'discrepantia','n','discrepanti',NULL,NULL,'[dɪs.krɛˈpan.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17176,'discretio','n','discretion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17178,'discribo','v','discrib discrips discript',NULL,NULL,'[dɪsˈkriː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17179,'discrimen','n','discrimin',NULL,NULL,'[dɪsˈkriː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (17180,'discrimino','v','discrimin discriminav discriminat',NULL,NULL,'[dɪsˈkriː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17184,'discriptio','n','discription',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17185,'discrucio','v','discruci discruciav discruciat',NULL,NULL,'[dɪsˈkrʊ.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17188,'discumbo','v','discumb discubu discubit',NULL,NULL,'[dɪsˈkʊm.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17194,'discutio','v','discut discuss discuss',NULL,NULL,'[dɪsˈkʊ.ti.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17197,'disertus','a','disert disert disert',NULL,NULL,'[dɪˈsɛr.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17198,'diserte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17199,'disertitudo','n','disertitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17201,'disgrego','v','disgreg disgregav disgrega',NULL,NULL,'[ˈdɪs.ɡrɛ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17204,'disicio','v','disic disiec disiect',NULL,NULL,'[dɪsˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17216,'dispar','a','dispar dispar dispar',NULL,NULL,'[ˈdɪs.paːr]','aps---an3-');
INSERT INTO latin_morpho VALUES (17217,'disparo','v','dispar disparav disparat',NULL,NULL,'[ˈdɪs.pa.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17224,'dispello','v','dispell dispul dispuls',NULL,NULL,'[dɪsˈpɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17225,'dispendo','v','dispend - dispens',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (17226,'dispendium','n','dispendi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17228,'dispenso','v','dispens dispensav dispensat',NULL,NULL,'[dɪsˈpẽː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17229,'dispensatio','n','dispensation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17230,'dispensator','n','dispensator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17232,'disperdo','v','disperd disperdid disperdit',NULL,NULL,'[dɪsˈpɛr.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17235,'dispergo','v','disperg dispers dispers',NULL,NULL,'[dɪsˈpɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17238,'dispersio','n','dispersion',NULL,NULL,'[dɪsˈpɛr.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17239,'dispertio','v','dispert disperti dispertit',NULL,NULL,'[dɪsˈpɛr.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (17242,'dispesco','v','dispesc dispescu dispest',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (17243,'dispicio','v','dispic dispex dispect',NULL,NULL,'[dɪsˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17249,'dispono','v','dispon disposu disposit',NULL,NULL,'[dɪsˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17258,'disputo','v','disput disputav disputat',NULL,NULL,'[ˈdɪs.pʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17259,'disputatio','n','disputation',NULL,NULL,'[dɪs.pʊˈtaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17261,'disquisitio','n','disquisition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17279,'dissero','v','disser disserav dissera',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (17284,'disserto','v','dissert dissertav dissertat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17289,'dissigno','v','dissign dissignav dissignat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17290,'dissignatio','n','dissignation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17293,'dissilio','v','dissil dissiliv dissult',NULL,NULL,'[dɪsˈsɪ.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (17294,'dissimilis','a','dissimil dissimil dissimil',NULL,NULL,'[dɪsˈsɪ.mɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (17295,'dissimilitudo','n','dissimilitudin',NULL,NULL,'[dɪs.sɪ.mɪ.lɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17296,'dissimulo','v','dissimul dissimulav dissimulat',NULL,NULL,'[dɪsˈsɪ.mʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17299,'dissimulator','n','dissimulator',NULL,NULL,'[dɪs.sɪ.mʊˈɫaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (17300,'dissipo','v','dissip dissipav dissipat',NULL,NULL,'[ˈdɪs.sɪ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17301,'dissipatio','n','dissipation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17303,'dissocio','v','dissoci dissociav dissociat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17304,'dissociabilis','a','dissociabil dissociabil dissociabil',NULL,NULL,'[dɪs.sɔ.kɪˈaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (17306,'dissolutus','a','dissolut dissolut dissolut',NULL,NULL,'[dɪsˈsɔ.ɫʊ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17307,'dissolutio','n','dissolution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17308,'dissolvo','v','dissolv dissolv dissolut',NULL,NULL,'[dɪsˈsɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17309,'dissonus','a','disson disson disson',NULL,NULL,'[ˈdɪs.sɔ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17311,'dissonantia','n','dissonanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17315,'dissuadeo','v','dissuad dissuas dissuas',NULL,NULL,'[dɪsˈswaː.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (17316,'dissuasio','n','dissuasion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17325,'distantia','n','distanti',NULL,NULL,'[dɪsˈtan.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17326,'distendo','v','distend distend distent',NULL,NULL,'[dɪsˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17328,'distentus','a','distent distent distent',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (17331,'distichon','n','distich',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17338,'distineo','v','distin distinu distent',NULL,NULL,'[dɪsˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (17339,'distinctus','a','distinct distinct distinct',NULL,NULL,'[dɪsˈtɪŋk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17340,'distinctio','n','distinction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17341,'distinguo','v','distingu distinx distinct',NULL,NULL,'[dɪsˈtɪŋ.ɡʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17346,'distraho','v','distrah distrax distract',NULL,NULL,'[ˈdɪs.tra.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17347,'distribuo','v','distribu distribu distribut',NULL,NULL,'[dɪsˈtrɪ.bʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17348,'distributio','n','distribution',NULL,NULL,'[dɪs.trɪˈbuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17349,'distributivus','a','distributiv distributiv distributiv',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (17350,'distributor','n','distributor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17351,'districtus','a','district district district',NULL,NULL,'[dɪsˈtrɪk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17352,'districte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17357,'distringo','v','distring distrinx district',NULL,NULL,'[dɪsˈtrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17358,'disturbo','v','disturb disturbav disturbat',NULL,NULL,'[dɪsˈtʊr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17378,'diurnus','a','diurn diurn diurn',NULL,NULL,'[dɪˈʊr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17388,'diva','n','div',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17389,'divus','n','div',NULL,NULL,'[ˈdiː.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (17390,'divum','n','div',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17396,'divello','v','divell divell divuls',NULL,NULL,'[diːˈwɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17398,'diverbero','v','diverber diverberav diverberat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17401,'diversus','a','divers divers divers',NULL,NULL,'[diːˈwɛr.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17405,'diversitas','n','diversitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17410,'divexo','v','divex divexav divexat',NULL,NULL,'/diːˈweːk.soː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (17412,'divido','v','divid divis divis',NULL,NULL,'[ˈdiː.wɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17414,'dividuus','a','dividu dividu dividu',NULL,NULL,'[diːˈwɪ.dʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17417,'divinus','a','divin divin divin',NULL,NULL,'[diːˈwiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17419,'divinitas','n','divinitat',NULL,NULL,'[diːˈwiː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17420,'divinitus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17421,'divisus','n','divis',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (17422,'divise','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17423,'divisibilis','a','divisibil divisibil divisibil',NULL,NULL,'[diː.wiːˈsɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (17424,'divisim','r',NULL,NULL,NULL,'[diːˈwiː.sĩ]','rp--------');
INSERT INTO latin_morpho VALUES (17425,'divisio','n','division',NULL,NULL,'/diːˈwiː.si.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17430,'divortium','n','divorti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17431,'divulgo','v','divulg divulgav divulgat',NULL,NULL,'[diːˈwʊɫ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17434,'doceo','v','doc docu doct',NULL,NULL,'[ˈdɔ.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (17437,'docilis','a','docil docil docil',NULL,NULL,'[ˈdɔ.kɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (17440,'doctus','a','doct doct doct',NULL,NULL,'[ˈdɔk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17442,'doctor','n','doctor',NULL,NULL,'/ˈdɔk.tɔr/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (17445,'doctrina','n','doctrin',NULL,NULL,'[dɔkˈtriː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17446,'doctrinalis','a','doctrinal doctrinal doctrinal',NULL,NULL,'[dɔk.triːˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (17447,'doctrix','n','doctric',NULL,NULL,'[ˈdɔk.triːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17448,'documen','n','documin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (17449,'documentum','n','document',NULL,NULL,'[dɔ.kʊˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17455,'doga','n','dog',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17456,'dogma','n','dogm',NULL,NULL,'[ˈdɔɡ.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (17457,'dogmaticus','a','dogmatic dogmatic dogmatic',NULL,NULL,'[dɔɡˈma.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17460,'dolus','n','dol',NULL,NULL,'[ˈdɔ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (17462,'doleo','v','dol dolu dolit',NULL,NULL,'[ˈdɔ.ɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (17467,'doliolum','n','doliol',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17469,'dolor','n','dolor',NULL,NULL,'[ˈdɔ.ɫɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (17473,'dolositas','n','dolositat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17474,'domus','n','dom',NULL,NULL,'[ˈdɔ.mʊs]','n-s---fn4-');
INSERT INTO latin_morpho VALUES (17476,'domo','v','dom domu domit',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17481,'domesticus','a','domestic domestic domestic',NULL,NULL,'[dɔˈmɛs.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17484,'domicilium','n','domicili',NULL,NULL,'[dɔ.mɪˈkɪ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17486,'domina','n','domin',NULL,NULL,'[ˈdɔ.mɪ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17487,'dominus','n','domin',NULL,NULL,'[ˈdɔ.mɪ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (17489,'dominor','v','domin dominat -',NULL,NULL,'[ˈdɔ.mɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (17490,'dominatus','n','dominat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (17491,'dominatio','n','domination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17493,'dominator','n','dominator',NULL,NULL,'[dɔ.mɪˈnaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (17495,'dominium','n','domini',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17506,'domito','v','domit domitav domitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17510,'domitor','n','domitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17514,'domuncula','n','domuncul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17515,'donum','n','don',NULL,NULL,'[ˈdoː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17516,'dono','v','don donav donat',NULL,NULL,'/ˈdoː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (17521,'donatio','n','donation',NULL,NULL,'/doːˈnaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17524,'donator','n','donator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17527,'dorcas','n','dorcad',NULL,NULL,'[ˈdɔr.kas]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17530,'dormio','v','dorm dormi dormit',NULL,NULL,'[ˈdɔr.mi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (17532,'dormitatio','n','dormitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17535,'dorsum','n','dors',NULL,NULL,'[ˈdɔr.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17540,'dos','n','dot',NULL,NULL,'/doːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17551,'draco','n','dracon',NULL,NULL,'/ˈdra.koː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (17554,'dracontia','n','draconti',NULL,'n-s---fn1-=dracontias n-s---fn3i=draconitis',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17556,'dracunculus','n','dracuncul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (17564,'dromas','n','dromad',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17566,'dromedarius','n','dromedari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (17570,'Dryas','n','Dryant',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (17572,'dubium','n','dubi',NULL,NULL,'[ˈdʊ.bi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17573,'dubius','a','dubi dubi dubi',NULL,NULL,'[ˈdʊ.bi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17574,'dubietas','n','dubietat',NULL,NULL,'[dʊˈbi.ɛ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17575,'dubito','v','dubit dubitav dubitat',NULL,NULL,'[ˈdʊ.bɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17577,'dubitatio','n','dubitation',NULL,NULL,'/du.biˈtaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17578,'duco','v','duc dux duct',NULL,NULL,'/ˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (17581,'ducatus','n','ducat',NULL,NULL,'[dʊˈkaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (17591,'ducto','v','duct ductav ductat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17596,'ductor','n','ductor',NULL,NULL,'/ˈduk.tor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (17598,'duellum','n','duell',NULL,NULL,'[dʊˈɛl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17600,'duellator','n','duellator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17602,'duellicus','a','duellic duellic duellic',NULL,NULL,'[dʊˈɛl.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17605,'duis','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17606,'dulco','v','dulc dulcav dulcat',NULL,NULL,'[ˈdʊɫ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17607,'dulcis','a','dulc dulc dulc',NULL,NULL,'[ˈdʊɫ.kɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (17609,'dulcedo','n','dulcedin',NULL,NULL,'[dʊɫˈkeː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17617,'dulciter','r',NULL,NULL,NULL,'[ˈdʊɫ.kɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (17618,'dulcitudo','n','dulcitudin',NULL,NULL,'[dʊɫ.kɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17620,'dulcoro','v','dulcor dulcorav dulcorat',NULL,NULL,'[dʊɫˈkoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17629,'dumtaxat','r',NULL,NULL,NULL,'[dʊnˈtak.sat]','rp--------');
INSERT INTO latin_morpho VALUES (17646,'duplatio','n','duplation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17649,'duplico','v','duplic duplicav duplicat',NULL,NULL,'[ˈdʊ.plɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (17653,'duplicatio','n','duplication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17654,'duplicitas','n','duplicitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17655,'dupliciter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17656,'duplo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17662,'duro','v','dur durav durat',NULL,NULL,'/ˈduː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (17663,'durus','a','dur dur dur',NULL,NULL,'[ˈduː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17667,'duritia','n','duriti',NULL,NULL,'[duːˈrɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17676,'dux','n','duc',NULL,NULL,'[dʊks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (17680,'dynastes','n','dynast',NULL,NULL,'[dʏˈnas.teːs]','n-s---mn1g');
INSERT INTO latin_morpho VALUES (17683,'dysenteria','n','dysenteri',NULL,NULL,'[dʏ.sɛnˈtɛ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17692,'eo','v','- iv it','v--pna--4-=ire v2spia--4-=is v3spia--4-=it v1ppia--4-=imus v2ppia--4-=itis v3ppia--4-=eunt v1siia--4-=ibam v2siia--4-=ibas v3siia--4-=ibat v1piia--4-=ibamus v2piia--4-=ibatis v3piia--4-=ibant v1sfia--4-=ibo v2sfia--4-=ibis v3sfia--4-=ibit v1pfia--4-=ibimus v2pfia--4-=ibitis v3pfia--4-=ibunt v-sppamn4-=iens v-sppafn4-=iens v-sppann4-=iens v-sfpamn4-=iturus v-sfpafn4-=itura v-sfpann4-=iturum v-sfppmn4-=eundus v-sfppfn4-=eunda v-sfppnn4-=eundum v-s-gang4-=eundi v-s-damn4-=eundus v-s-dafn4-=eunda v-s-dann4-=eundum',NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (17694,'eadem','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (17700,'ebenus','n','eben',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (17701,'ebenum','n','eben',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17702,'ebibo','v','ebib ebib ebibit',NULL,NULL,'[ˈeː.bɪ.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17708,'ebrius','a','ebri ebri ebri',NULL,NULL,'[ˈeː.bri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17709,'ebriacus','a','ebriac ebriac ebriac',NULL,NULL,'[eː.brɪˈaː.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17710,'ebrietas','n','ebrietat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17714,'ebulum','n','ebul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17722,'ecbasis','n','ecbas',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (17733,'ecclesia','n','ecclesi',NULL,NULL,'[ɛkˈkɫeː.si.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17738,'ecclesiasticus','a','ecclesiastic ecclesiastic ecclesiastic',NULL,NULL,'[ɛk.kɫeː.sɪˈas.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17754,'echidna','n','echidn',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17756,'echo','n','ech',NULL,NULL,NULL,'n-s---fn4-');
INSERT INTO latin_morpho VALUES (17761,'eclipsis','n','eclips',NULL,NULL,'/eˈkliːp.sis/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (17764,'ecloga','n','eclog',NULL,NULL,'[ˈɛ.kɫɔ.ɡa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17770,'ecstasis','n','ecstas',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (17775,'eculeus','n','ecule',NULL,NULL,'[ɛˈkʊ.ɫe.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (17776,'edus','n','ed',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (17777,'edo','v','ed ed es',NULL,NULL,'[ˈɛ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17780,'edax','a','edac edac edac',NULL,NULL,'[ˈɛ.daːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (17781,'edentulus','a','edentul edentul edentul',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (17785,'edico','v','edic edix edict',NULL,NULL,'/eːˈdiː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (17786,'edictum','n','edict',NULL,NULL,'[eːˈdɪk.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17789,'edissero','v','edisser edisseru edissert',NULL,NULL,'[eːˈdɪs.sɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17791,'editus','a','edit edit edit',NULL,NULL,'[ˈeː.dɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17793,'editio','n','edition',NULL,NULL,'[eːˈdɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17801,'educo','v','educ educav educat',NULL,NULL,'/eːˈduː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (17803,'educatio','n','education',NULL,NULL,'[eː.dʊˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17807,'edulis','a','edul edul edul',NULL,NULL,'[ɛˈduː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (17812,'effor','v','eff effat -',NULL,NULL,'[ˈɛf.fɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (17815,'effatum','n','effat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (17819,'effectus','n','effect',NULL,NULL,'[ɛfˈfɛk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (17821,'effectio','n','effection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (17824,'effector','n','effector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (17829,'effero','v','effer efferav efferat','v--pna--3-=efferre v2spia--3-=effers v3spia--3-=effert v2ppia--3-=effertis','v1spia--3-=exfero v--pna--3-=exferre v1spia--3-=ecfero v--pna--3-=ecferre',NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17835,'effervesco','v','effervesc - -',NULL,NULL,'[ɛf.fɛrˈwɛs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17837,'effetus','a','effet effet effet',NULL,NULL,'[ɛfˈfeː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17839,'efficacia','n','efficaci',NULL,NULL,'[ɛf.fɪˈkaː.ki.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17840,'efficacitas','n','efficacitat',NULL,NULL,'[ɛf.fɪˈkaː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17842,'efficax','a','efficac efficac efficac',NULL,NULL,'[ˈɛf.fɪ.kaːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (17844,'efficio','v','effic effec effect',NULL,NULL,'[ɛfˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17847,'effigia','n','effigi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (17848,'effigies','n','effigi',NULL,NULL,'[ɛfˈfɪ.ɡi.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (17849,'effigio','v','effigi effigiav effigiat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (17850,'effingo','v','effing effinx effict',NULL,NULL,'[ɛfˈfɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17857,'effloresco','v','effloresc effloru -',NULL,NULL,'[ɛf.fɫoːˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17858,'effluo','v','efflu efflu -',NULL,NULL,'[ˈɛf.fɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17861,'effodio','v','effod effod effoss',NULL,NULL,'[ɛfˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17865,'effrenus','a','effren effren effren',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (17867,'effrenatus','a','effrenat effrenat effrenat',NULL,NULL,'[ɛf.freːˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17868,'effringo','v','effring effreg effract',NULL,NULL,'[ɛfˈfrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17872,'effugio','v','effug effug effugit',NULL,NULL,'[ɛfˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17873,'effugium','n','effugi',NULL,NULL,'[ɛfˈfʊ.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17874,'effulgeo','v','effulg effuls -',NULL,NULL,'[ɛfˈfʊɫ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (17876,'effundo','v','effund effud effus',NULL,NULL,'[ɛfˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (17877,'effusus','a','effus effus effus',NULL,NULL,'[ɛfˈfuː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17879,'effusio','n','effusion',NULL,NULL,'[ɛfˈfuː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17880,'effutio','v','effut effuti effutit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (17887,'egero','v','eger egess egest',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (17888,'egestas','n','egestat',NULL,NULL,'[ɛˈɡɛs.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (17894,'egredior','v','egred egress -',NULL,NULL,'[eːˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (17895,'egregius','a','egregi egregi egregi',NULL,NULL,'[eːˈɡrɛ.ɡi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (17896,'egregie','r',NULL,NULL,NULL,'[eːˈɡrɛ.ɡi.eː]','rp--------');
INSERT INTO latin_morpho VALUES (17897,'egressus','n','egress',NULL,NULL,'[eːˈɡrɛs.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (17905,'eicio','v','eic ejec eject',NULL,NULL,'[eːˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17922,'elabor','v','elab elaps -',NULL,NULL,'[eːˈɫaː.bɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (17945,'electrum','n','electr',NULL,NULL,'[eːˈɫɛk.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17972,'eleemosyna','n','eleemosyn',NULL,NULL,'[ɛ.ɫe.eːˈmɔ.sʏ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (17982,'elementum','n','element',NULL,NULL,'[ɛ.ɫɛˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (17996,'elicio','v','elic elicu elicit',NULL,NULL,'[eːˈlɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (17997,'elido','v','elid elis elis',NULL,NULL,'/eːˈliː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (17998,'eligo','v','elig eleg elect',NULL,NULL,'[ˈeː.lɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18017,'elocutio','n','elocution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18018,'elogium','n','elogi',NULL,NULL,'[eːˈɫɔ.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18023,'eloquor','v','eloqu elocut -',NULL,NULL,'[ˈeː.ɫɔ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (18024,'eloquens','a','eloquent eloquent eloquent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (18026,'eloquentia','n','eloquenti',NULL,NULL,'[eː.ɫɔˈkᶣɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18027,'eloquium','n','eloqui',NULL,NULL,'[eːˈɫɔ.kᶣi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18032,'elucido','v','elucid elucidav elucidat',NULL,NULL,'[eːˈɫuː.kɪ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18036,'eludo','v','elud elus elus',NULL,NULL,'[eːˈɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18040,'eluvies','n','eluvi',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (18041,'eluvio','n','eluvion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18044,'emo','v','em em empt',NULL,'v1sria--3-=empsi','IPA: /ˈe.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (18047,'emano','v','eman emanav emanat',NULL,NULL,'/eːˈmaː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (18049,'emanatio','n','emanation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18050,'emancipo','v','emancip emancipav emancipat',NULL,NULL,'[eːˈmaŋ.kɪ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18052,'emancipatio','n','emancipation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18058,'emblema','n','emblem',NULL,NULL,'[ɛmˈbɫeː.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (18061,'embolus','n','embol',NULL,NULL,'[ˈɛm.bɔ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18063,'embolium','n','emboli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18070,'emendo','v','emend emendav emendat',NULL,NULL,'[eːˈmɛn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18071,'emendatio','n','emendation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18072,'emendico','v','emendic emendicav emendicat',NULL,NULL,'[eː.mɛnˈdiː.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18073,'ementior','v','ement ementit -',NULL,NULL,'[eːˈmɛn.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (18074,'emereo','v','emer emeru emerit',NULL,NULL,'[eːˈmɛ.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (18076,'emercor','v','emerc emercat -',NULL,NULL,'[eːˈmɛr.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (18077,'emergo','v','emerg emers emers',NULL,NULL,'[eːˈmɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18082,'emetior','v','emet emens -',NULL,NULL,'[eːˈmeː.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (18085,'emineo','v','emin eminu -',NULL,NULL,'[eːˈmɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (18086,'eminens','a','eminent eminent eminent',NULL,NULL,'[ˈeː.mɪ.nẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (18088,'eminentia','n','eminent',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18098,'emissio','n','emission',NULL,NULL,'[eːˈmɪs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18103,'emitto','v','emitt emis emiss',NULL,NULL,'[eːˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18105,'emoderor','v','emoder emoderat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (18108,'emollio','v','emoll emolli emollit',NULL,NULL,'[eːˈmɔl.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18109,'emolumentum','n','emolument',NULL,'n-s---nn2-=emolimentum',NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18111,'emorior','v','emor emortu -',NULL,NULL,'[eːˈmɔ.ri.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (18113,'emoveo','v','emov emov emot',NULL,NULL,'[eːˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (18115,'emphasis','n','emphas',NULL,NULL,'/ˈem.pʰa.sis/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (18125,'empiricus','a','empiric empiric empiric',NULL,NULL,'[ɛmˈpiː.rɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18128,'emplastrum','n','emplastr',NULL,NULL,'[ɛmˈpɫas.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18131,'emporium','n','empori',NULL,NULL,'[ɛmˈpɔ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18133,'emptio','n','emption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18134,'emptor','n','emptor',NULL,NULL,'[ˈeːmp.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (18143,'emunio','v','emun emuni emunit',NULL,NULL,'/eːˈmuː.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (18150,'enarro','v','enarr enarrav enarrat',NULL,NULL,'/eːˈnaːr.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (18152,'enarratio','n','enarration',NULL,NULL,'/eː.naːrˈraː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18154,'enascor','v','enasc enat -',NULL,NULL,'[eːˈnaːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (18164,'enchiridion','n','enchiridi',NULL,NULL,NULL,'n-s---nn2g');
INSERT INTO latin_morpho VALUES (18167,'encomboma','n','encombomat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (18170,'endivia','n','endivi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18172,'eneco','v','enec enecu enect',NULL,NULL,'[ˈeː.nɛ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18174,'energia','n','energi',NULL,NULL,'[ɛ.nɛrˈɡiː.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18177,'enervis','a','enerv enerv enerv',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (18178,'enervo','v','enerv enervav enervat',NULL,NULL,'[eːˈnɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18179,'enerviter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (18192,'enitor','v','enit enix -',NULL,NULL,'[eːˈniː.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (18198,'enodate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (18199,'enodatio','n','enodation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18206,'ensis','n','ens',NULL,NULL,'[ˈẽː.sɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (18207,'entheca','n','enthec',NULL,NULL,'[ɛnˈtʰeː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18210,'enthymema','n','enthymemat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (18219,'enucleatus','a','enucleat enucleat enucleat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (18221,'enumero','v','enumer enumerav enumerat',NULL,NULL,'[eːˈnʊ.mɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18222,'enumeratio','n','enumeration',NULL,NULL,'[eː.nʊ.mɛˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18223,'enuntio','v','enunti enuntiav enuntiat',NULL,'v1spia--1-=enuncio v--pna--1-=enunciare v1sria--1-=enunciavi v-srppmn1-=enunciatus v-srppfn1-=enunciata v-srppnn1-=enunciatum','[eːˈnʊn.ti.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18226,'enuntiatio','n','enuntiation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18238,'ephebus','n','epheb',NULL,NULL,'[ɛˈpʰeː.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18242,'ephemeris','n','ephemerid',NULL,NULL,'[ɛˈpʰeː.mɛ.rɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18257,'epicus','a','epic epic epic',NULL,NULL,'[ˈɛ.pɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18270,'epidipnis','n','epidipnid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18272,'epigramma','n','epigrammat',NULL,NULL,'[ɛ.pɪˈɡram.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (18281,'epilepsia','n','epilepsi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18282,'epilepticus','a','epileptic epileptic epileptic',NULL,NULL,'[ɛ.pɪˈɫeːp.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18283,'epilogus','n','epilog',NULL,NULL,'[ɛˈpɪ.ɫɔ.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18290,'Epiphania','n','epiphani',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18294,'episcopus','n','episcop',NULL,NULL,'[ɛˈpɪs.kɔ.pʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18295,'episcopalis','a','episcopal episcopal episcopal',NULL,NULL,'[ɛ.pɪs.kɔˈpaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (18297,'episcopatus','n','episcopat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (18305,'epistula','n','epistul',NULL,NULL,'[ɛˈpɪs.tʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18307,'epistylium','n','epistyli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18310,'epitheca','n','epithec',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18313,'epitome','n','epitom',NULL,NULL,'[ɛˈpɪ.tɔ.meː]','n-s---fn1g');
INSERT INTO latin_morpho VALUES (18315,'epitonium','n','epitoni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18325,'epops','n','epop',NULL,NULL,'[ˈɛ.pɔps]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (18329,'epoto','v','epot - epotat',NULL,NULL,'/eːˈpoː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (18335,'epulor','v','epul epulat -',NULL,NULL,'[ˈɛ.pʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (18337,'equa','n','equ',NULL,NULL,'[ˈɛ.kʷa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18338,'equus','n','equ',NULL,NULL,'[ˈɛ.kʷʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18339,'eques','n','equit',NULL,NULL,'[ˈɛ.kᶣɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (18342,'equidem','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (18347,'equito','v','equit equitav equitat',NULL,NULL,'[ˈɛ.kᶣɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18348,'equitatus','n','equitat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (18350,'equitatio','n','equitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18353,'era','n','er',NULL,NULL,'[ˈɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18354,'erus','n','er',NULL,NULL,'[ˈɛ.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18355,'erado','v','erad eras eras',NULL,NULL,'/eːˈraː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (18356,'eradico','v','eradic eradicav eradicat',NULL,NULL,'/eː.raːˈdiː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (18358,'erectus','a','erect erect erect',NULL,NULL,'[eːˈrɛk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18359,'erectio','n','erection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18360,'eremus','n','erem',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (18362,'eremita','n','eremit',NULL,NULL,'[ɛ.reːˈmiː.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (18368,'ergastulum','n','ergastul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18372,'ericius','n','erici',NULL,NULL,'[eːˈrɪ.ki.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18373,'erigo','v','erig erex erect',NULL,NULL,'[ˈeː.rɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18375,'erinaceus','n','erinace',NULL,NULL,'[eː.rɪˈnaː.ke.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18379,'erithacus','n','erithac',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (18383,'erogo','v','erog erogav erogat',NULL,NULL,'[ˈeː.rɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18384,'erogatio','n','erogation',NULL,NULL,'[eː.rɔˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18386,'erro','v','err errav errat',NULL,NULL,'[ˈɛr.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18389,'erratum','n','errat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18391,'erro','n','erron',NULL,NULL,'[ˈɛr.roː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (18394,'error','n','error',NULL,NULL,'[ˈɛr.rɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (18395,'eruo','v','eru eru erut',NULL,NULL,'[ˈeː.rʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18396,'erubesco','v','erubesc erubu -',NULL,NULL,'[eː.rʊˈbeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18401,'erudio','v','erud erudiv erudit',NULL,NULL,'[eːˈrʊ.di.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18402,'eruditus','a','erudit erudit erudit',NULL,NULL,'[eː.rʊˈdiː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18403,'eruditio','n','erudition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18411,'eruptio','n','eruption',NULL,NULL,'[eːˈrʊp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18413,'ervum','n','erv',NULL,NULL,'[ˈɛr.wũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18422,'esca','n','esc',NULL,NULL,'/ˈeːs.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18424,'escendo','v','escend escend escens',NULL,'v1spia--3-=exscendo v--pna--3-=exscendere v1sria--3-=exscendi v-srppmn3-=exscensus v-srppfn3-=exscensa v-srppnn3-=exscensum v1spia--3-=excendo v--pna--3-=excendere v1sria--3-=excendi v-srppmn3-=excensus v-srppfn3-=excensa v-srppnn3-=excensum','[eːsˈkɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18428,'esculentus','a','esculent esculent esculent',NULL,NULL,'[eːs.kʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18432,'esotericus','a','esoteric esoteric esoteric',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (18440,'essentia','n','essenti',NULL,NULL,'[ɛsˈsɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18443,'essentialiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (18459,'esuries','n','esuri',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (18461,'esuriens','a','esurient esurient esurient',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (18471,'ethica','n','ethic',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18474,'ethicus','a','ethic ethic ethic',NULL,NULL,'[ˈeː.tʰɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18486,'etiamnum','r',NULL,NULL,'rp--------=etiamnunc',NULL,'rp--------');
INSERT INTO latin_morpho VALUES (18491,'etymologia','n','etymologi',NULL,NULL,'[ɛ.tʏ.mɔˈɫɔ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18494,'eucharistia','n','eucharisti',NULL,NULL,'[eu̯.kʰaˈrɪs.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18512,'eulogia','n','eulogi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18514,'eunuchus','n','eunuch',NULL,NULL,'[eu̯ˈnuː.kʰʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (18522,'euripus','n','eurip',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (18531,'Europa','n','Europ',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18535,'Eva','n','Ev',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18536,'evacuo','v','evacu - evacuat',NULL,NULL,'[eːˈwa.kʊ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18537,'evado','v','evad evas evas',NULL,NULL,'/eːˈwaː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (18538,'evagor','v','evag evagat -',NULL,NULL,'[ˈeː.wa.ɡɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (18541,'evanesco','v','evanesc evanu -',NULL,NULL,'/eː.waːˈneːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (18555,'evaporatio','n','evaporation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18556,'evasio','n','evasion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18557,'evasto','v','evast evastav evastat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (18558,'evectio','n','evection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18560,'evello','v','evell evuls evuls',NULL,NULL,'[eːˈwɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18561,'evenio','v','even even event',NULL,NULL,'[eːˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18563,'eventum','n','event',NULL,NULL,'[eːˈwɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18564,'eventus','n','event',NULL,NULL,'[eːˈwɛn.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (18568,'everro','v','everr everr evers',NULL,NULL,'[eːˈwɛr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18570,'eversio','n','eversion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18572,'everto','v','evert evert evers',NULL,NULL,'[eːˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18575,'evidens','a','evident evident evident',NULL,NULL,'[ˈeː.wɪ.dẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (18577,'evidentia','n','evidenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18579,'evigilatio','n','evigilation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18581,'evinco','v','evinc evic evict',NULL,NULL,'[eːˈwɪŋ.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18582,'evincio','v','evinc evinx evinct',NULL,NULL,'[eːˈwɪŋ.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18583,'eviro','v','evir evirav evirat',NULL,NULL,'[ˈeː.wɪ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18586,'evito','v','evit evitav evitat',NULL,NULL,'/eːˈwiː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (18587,'evitabilis','a','evitabil evitabil evitabil',NULL,NULL,'[eː.wiːˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (18589,'evoco','v','evoc evocav evocat',NULL,NULL,'[ˈeː.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18590,'evocatus','n','evocat',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (18591,'evocatio','n','evocation',NULL,NULL,'[eː.wɔˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18596,'evolvo','v','evolv evolv evolut',NULL,NULL,'[eːˈwɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18599,'evulgo','v','evulg evulgav evulgat',NULL,NULL,'[eːˈwʊɫ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18603,'exacerbo','v','exacerb exacerbav exacerbat',NULL,NULL,'[ɛk.saˈkɛr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18606,'exactus','a','exact exact exact',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (18607,'exactio','n','exaction',NULL,NULL,'[ɛkˈsaːk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18611,'exacuo','v','exacu exacu exacut',NULL,NULL,'[ɛkˈsa.kʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18614,'exadversum','r',NULL,NULL,'rp--------=exadversus rp--------=exadvorsus rp--------=exadvorsum','[ɛk.sadˈwɛr.sũ]','rp--------');
INSERT INTO latin_morpho VALUES (18618,'exaestuo','v','exaestu exaestuav exaestuat',NULL,NULL,'[ɛkˈsae̯s.tʊ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18619,'exaggero','v','exagger exaggerav exaggerat',NULL,NULL,'[ɛkˈsaɡ.ɡɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18620,'exagito','v','exagit exagitav exagitat',NULL,NULL,'[ɛkˈsa.ɡɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18621,'exalto','v','exalt exaltav exaltat',NULL,NULL,'[ɛkˈsaɫ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18622,'exaltatio','n','exaltation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18623,'examen','n','examin',NULL,NULL,'[ɛkˈsaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (18624,'examino','v','examin examinav examinat',NULL,NULL,'[ɛkˈsaː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18626,'examinator','n','examinator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (18627,'examussim','r',NULL,NULL,NULL,'[ɛk.saˈmʊs.sĩ]','rp--------');
INSERT INTO latin_morpho VALUES (18630,'exanimo','v','exanim exanimav exanimat',NULL,NULL,'[ɛkˈsa.nɪ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18633,'exaro','v','exar exarav exarat',NULL,NULL,'[ˈɛk.sa.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18637,'exardesco','v','exardesc exars exars',NULL,NULL,'[ɛk.sarˈdeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18638,'exaresco','v','exaresc exaru -',NULL,NULL,'[ɛk.saːˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18639,'exarmo','v','exarm exarmav exarmat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (18640,'exaspero','v','exasper exasperav exasperat',NULL,NULL,'[ɛkˈsas.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18641,'exasperatio','n','exasperation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18646,'exaudio','v','exaud exaudi exaudit',NULL,NULL,'[ɛkˈsau̯.di.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18659,'excandesco','v','excandesc excandu -',NULL,NULL,'[ɛk.skanˈdeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18663,'excarnifico','v','excarnific excarnificav excarnificat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (18666,'excavo','v','excav excavav excavat',NULL,NULL,'[ˈɛk.ska.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18667,'excedo','v','exced excess excess',NULL,NULL,'[ɛkˈskeː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18669,'excellens','a','excellent excellent excellent',NULL,NULL,'[ɛkˈskɛl.lẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (18671,'excellentia','n','excellenti',NULL,NULL,'[ɛk.skɛlˈlɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18676,'excelsus','a','excels excels excels',NULL,NULL,'[ɛkˈskɛɫ.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18677,'excelsitas','n','excelsitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18682,'exceptio','n','exception',NULL,NULL,'[ɛkˈskɛp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18685,'excerebro','v','excerebr excerebrav excerebra',NULL,NULL,'[ɛk.skɛˈreː.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18686,'excerpo','v','excerp excerps excerpt',NULL,NULL,'[ɛkˈskɛr.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18687,'excerptum','n','excerpt',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18688,'excerptio','n','excerption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18689,'excessus','n','excess',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (18691,'excetra','n','excetr',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18693,'excieo','v','exci exci excit',NULL,NULL,'[ɛkˈski.e.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (18694,'excido','v','excid excid -',NULL,NULL,'[ˈɛk.skɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18696,'excidium','n','excidi',NULL,'n-s---nn2-=exscidium','[ɛkˈskiː.doː]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18698,'excipio','v','excip excep except',NULL,NULL,'[ɛkˈskɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (18701,'excito','v','excit excitav excitat',NULL,NULL,'[ˈɛk.skɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18703,'exclamo','v','exclam exclamav exclamat',NULL,NULL,'[ɛkˈskɫaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18704,'exclamatio','n','exclamation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18707,'excludo','v','exclud exclus exclus',NULL,NULL,'[ɛkˈskɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18709,'exclusio','n','exclusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18712,'excogito','v','excogit excogitav excogitat',NULL,NULL,'[ɛkˈskoː.ɡɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18714,'excolo','v','excol excolav excola',NULL,NULL,'[ˈɛk.skɔ.ɫoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18715,'excommunico','v','excommunic excommunicav excommunicat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (18716,'excommunicatio','n','excommunication',NULL,NULL,'[ɛk.skɔm.muː.nɪˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18717,'excoquo','v','excoqu excox excoct',NULL,NULL,'[ˈɛk.skɔ.kʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18718,'excorio','v','excori excoriav excoria',NULL,NULL,'[ɛkˈskɔ.ri.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18720,'excrementum','n','excrement',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18721,'excresco','v','excresc excrev excret',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (18722,'excrucio','v','excruci excruciav excruciat',NULL,NULL,'[ɛkˈskrʊ.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18732,'excursus','n','excurs',NULL,NULL,'[ɛkˈskʊr.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (18734,'excursio','n','excursion',NULL,NULL,'[ɛkˈskʊr.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18735,'excuso','v','excus excusav excusat',NULL,NULL,'[ɛkˈskuː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18736,'excusabilis','a','excusabil excusabil excusabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (18737,'excusamentum','n','excusament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18738,'excusatio','n','excusation',NULL,NULL,'[ɛk.skuːˈsaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18742,'excutio','v','excut excuss excuss',NULL,NULL,'[ɛkˈskʊ.ti.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (18743,'exeo','v','ex exiv exit','v2spia--4-=exis v3spia--4-=exit v1ppia--4-=eximus v2ppia--4-=exitis v3ppia--4-=exeunt v1siia--4-=exibam v2siia--4-=exibas v3siia--4-=exibat v1piia--4-=exibamus v2piia--4-=exibatis v3piia--4-=exibant v1sfia--4-=exibo v2sfia--4-=exibis v3sfia--4-=exibit v1pfia--4-=exibimus v2pfia--4-=exibitis v3pfia--4-=exibunt v-sppamn4-=exiens v-sppafn4-=exiens v-sppann4-=exiens v-sfpamn4-=exiturus v-sfpafn4-=exitura v-sfpann4-=exiturum v-sfppmn4-=exeundus v-sfppfn4-=exeunda v-sfppnn4-=exeundum v-s-gang4-=exeundi v-s-damn4-=exeundus v-s-dafn4-=exeunda v-s-dann4-=exeundum',NULL,'[ˈɛk.se.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18756,'exedo','v','exed exed exes',NULL,NULL,'[ˈɛk.sɛ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18761,'exemplum','n','exempl',NULL,NULL,'[ɛkˈsɛm.pɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18764,'exemplar','n','exemplar',NULL,NULL,'[ɛkˈsɛm.pɫar]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (18771,'exemptus','n','exempt',NULL,NULL,'[ɛkˈsɛmp.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (18773,'exemptio','n','exemption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18782,'exerceo','v','exerc exercu exercit',NULL,NULL,'[ɛkˈsɛr.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (18784,'exercitus','n','exercit',NULL,NULL,'[ɛkˈsɛr.kɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (18785,'exercito','v','exercit exercitav exercitat',NULL,NULL,'[ɛkˈsɛr.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18786,'exercitatus','a','exercitat exercitat exercitat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (18787,'exercitatio','n','exercitation',NULL,NULL,'[ɛk.sɛr.kɪˈtaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18788,'exercitium','n','exerciti',NULL,NULL,'[ɛk.sɛrˈkɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18797,'exhalo','v','exhal exhalav exhalat',NULL,NULL,'[ɛksˈhaː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18798,'exhaurio','v','exhaur exhaus exhaust',NULL,NULL,'[ɛksˈhau̯.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18801,'exheredo','v','exhered exheredav exheredat',NULL,NULL,'[ɛks.heːˈreː.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18805,'exhibeo','v','exhib exhibu exhibit',NULL,NULL,'[ɛksˈhɪ.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (18808,'exhilaro','v','exhilar exhilarav exhilarat',NULL,NULL,'[ɛksˈhɪ.ɫa.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18810,'exhonoratio','n','exhonoration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18812,'exhorresco','v','exhorresc exhorru -',NULL,NULL,'[ɛks.hɔrˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18814,'exhortor','v','exhort exhortat -',NULL,NULL,'[ɛksˈhɔr.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (18815,'exhortatio','n','exhortation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18820,'exigo','v','exig exeg exact',NULL,NULL,'[ˈɛk.sɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18822,'exiguus','a','exigu exigu exigu',NULL,NULL,'[ɛkˈsɪ.ɡʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18823,'exiguitas','n','exiguitat',NULL,NULL,'[ɛk.sɪˈɡʊ.ɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18824,'exilis','a','exil exil exil',NULL,NULL,'[ɛkˈsiː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (18827,'exilium','n','exili',NULL,'n-s---nn2-=exsilium','[ɛkˈsɪ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18828,'exilitas','n','exilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18831,'eximo','v','exim exem exempt',NULL,NULL,'[ˈɛk.sɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18832,'eximius','a','eximi eximi eximi',NULL,NULL,'[ɛkˈsɪ.mi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18833,'eximietas','n','eximietat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18835,'exinanio','v','exinan exinani exinanit',NULL,NULL,'[ɛk.sɪˈnaː.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18843,'existimatio','n','existimation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18861,'exonero','v','exoner exonerav exonerat',NULL,NULL,'[ɛkˈsɔ.nɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18863,'exoro','v','exor exorav exorat',NULL,NULL,'[ɛkˈsoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18868,'exorcista','n','exorcist',NULL,NULL,'[ɛk.sɔrˈkɪs.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (18871,'exorcizo','v','exorciz exorcizav exorcizat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (18872,'exordior','v','exord exors -',NULL,NULL,'[ɛkˈsɔr.di.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (18873,'exordium','n','exordi',NULL,NULL,'[ɛkˈsɔr.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18874,'exorior','v','exor exort -',NULL,NULL,'[ɛkˈsɔ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (18875,'exorno','v','exorn exornav exornat',NULL,NULL,'[ɛkˈsoːr.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18877,'exornatio','n','exornation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18884,'exosso','v','exoss exossav exossat',NULL,NULL,'[ɛkˈsɔs.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18891,'expando','v','expand expand expans',NULL,NULL,'[ɛkˈspan.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18893,'expansio','n','expansion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18899,'expedio','v','exped exped expedit',NULL,NULL,'[ɛkˈspɛ.di.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18903,'expeditio','n','expedition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18904,'expello','v','expell expul expuls',NULL,NULL,'[ɛkˈspɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18905,'expendo','v','expend expend expens',NULL,NULL,'[ɛkˈspɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18907,'expensa','n','expens',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (18910,'expensio','n','expension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18911,'expergefacio','v','expergefac expergefec expergefact',NULL,NULL,'[ɛk.spɛr.ɡeːˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (18912,'expergiscor','v','expergisc experrect -',NULL,NULL,'[ɛk.spɛrˈɡiːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (18913,'experior','v','exper expert -',NULL,NULL,'[ɛkˈspɛ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (18914,'experiens','a','experient experient experient',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (18915,'experientia','n','experienti',NULL,NULL,'[ɛk.spɛ.rɪˈɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (18916,'experimentum','n','experiment',NULL,NULL,'[ɛk.spɛ.riːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (18923,'expeto','v','expet expeti expetit',NULL,NULL,'[ˈɛk.spɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18926,'expio','v','expi expiav expiat',NULL,NULL,'[ˈɛk.spi.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18927,'expiatio','n','expiation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18928,'expiatorius','a','expiatori expiatori expiatori',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (18929,'expilo','v','expil expilav expilat',NULL,NULL,'[ɛkˈspiː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18932,'expleo','v','expl explev explet',NULL,NULL,'[ˈɛk.spɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (18933,'explano','v','explan explanav explanat',NULL,NULL,'[ɛkˈspɫaː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18935,'explanatio','n','explanation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18936,'explanto','v','explant explantav explanta',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (18938,'explementum','n','explement',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (18940,'expletio','n','expletion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18942,'explico','v','explic explicu explicat',NULL,NULL,'[ˈɛk.splɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18944,'explicatio','n','explication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18949,'explodo','v','explod explos explos',NULL,NULL,'[ɛkˈspɫoː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18950,'exploro','v','explor explorav explorat',NULL,NULL,'[ɛkˈspɫoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18952,'exploratio','n','exploration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18953,'explorator','n','explorator',NULL,NULL,'[ɛk.spɫoːˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (18956,'expolio','v','expol expoliv expolit',NULL,NULL,'[ɛkˈspɔ.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (18959,'expono','v','expon exposu exposit',NULL,NULL,'[ɛkˈspoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18962,'exporrigo','v','exporrig exporrex exporrect',NULL,NULL,'[ɛkˈspɔr.rɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18963,'exporto','v','export exportav exportat',NULL,NULL,'[ɛkˈspɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18966,'exposco','v','exposc expoposc exposcit',NULL,NULL,'[ɛkˈspɔs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18967,'expositio','n','exposition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18969,'expostulo','v','expostul expostulav expostulat',NULL,NULL,'[ɛkˈspɔs.tʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (18970,'expostulatio','n','expostulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18971,'expressus','a','express express express',NULL,NULL,'[ɛkˈsprɛs.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (18972,'expresse','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (18973,'expressim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (18975,'exprimo','v','exprim express express',NULL,NULL,'[ˈɛk.sprɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18980,'expromo','v','exprom expromps exprompt',NULL,NULL,'[ɛkˈsproː.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (18986,'expugnator','n','expugnator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (18988,'expulsio','n','expulsion',NULL,NULL,'[ɛkˈspʊɫ.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (18992,'expurgatio','n','expurgation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (18998,'exquisitio','n','exquisition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19001,'exsatio','v','exsati exsatiav exsatiat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19002,'exsaturo','v','exsatur exsaturav exsaturat',NULL,NULL,'[ɛkˈsa.tʊ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19005,'exscindo','v','exscind exscid exsciss',NULL,NULL,'[ɛkˈskɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19006,'exscreo','v','exscre exscreav exscreat',NULL,NULL,'[ˈɛk.skre.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19007,'exscribo','v','exscrib exscrips exscript',NULL,NULL,'[ɛkˈskriː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19009,'exseco','v','exsec exsecu exsect',NULL,NULL,'[ˈɛk.sɛ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19010,'exsecror','v','exsecr exsecrat -',NULL,NULL,'[ˈɛk.sɛ.krɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (19014,'exsecratio','n','exsecration',NULL,NULL,'[ɛk.seːˈkraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19018,'exsecutio','n','exsecution',NULL,NULL,'[ɛk.sɛˈkuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19020,'exsecutor','n','exsecutor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (19022,'exsequor','v','exsequ exsecut -',NULL,NULL,'[ˈɛk.sɛ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (19027,'exsero','v','exser exseru exsert',NULL,NULL,'[ˈɛk.sɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19028,'exserto','v','exsert exsertav exsertat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19030,'exsicco','v','exsicc exsiccav exsiccat',NULL,NULL,'[ɛkˈsɪk.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19034,'exsisto','v','exsist exstit -',NULL,'v1spia--3-=existo v--pna--3-=existere v1sria--3-=exstiti','[ɛkˈsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19035,'exsistentia','n','exsistenti',NULL,NULL,'[ɛk.sɪsˈtɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19036,'exsolvo','v','exsolv exsolv exsolut',NULL,NULL,'[ɛkˈsɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19039,'exspatior','v','exspati exspatiat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (19040,'exspecto','v','exspect exspectav exspectat',NULL,NULL,'[ɛkˈspɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19041,'exspectatio','n','exspectation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19042,'exspergo','v','exsperg exspers exspers',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (19044,'exspiro','v','exspir exspirav exspirat',NULL,NULL,'[ɛkˈspiː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19045,'exsplendesco','v','exsplendesc exsplendu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (19046,'exspolio','v','exspoli exspoliav exspoliat',NULL,NULL,'[ɛkˈspɔ.li.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19048,'exsto','v','exst exstav exstat',NULL,NULL,'[ˈɛk.stoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19054,'exstimulo','v','exstimul exstimulav exstimulat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19058,'exstinguo','v','exstingu exstinx exstinct',NULL,NULL,'[ɛkˈstɪŋ.ɡʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19059,'exstirpo','v','exstirp exstirpav exstirpat',NULL,NULL,'[ɛkˈstɪr.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19060,'exstruo','v','exstru exstrux exstruct',NULL,NULL,'[ˈɛk.strʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19062,'exsudo','v','exsud exsudav exsudat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19070,'exsulto','v','exsult exsultav exsultat',NULL,NULL,'[ɛkˈsʊɫ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19072,'exsultatio','n','exsultation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19074,'exsupero','v','exsuper exsuperav exsuperat',NULL,NULL,'[ɛkˈsʊ.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19076,'exsurdo','v','exsurd exsurdav exsurdat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19077,'exsurgo','v','exsurg exsurrex exsurrect',NULL,NULL,'[ɛkˈsʊr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19079,'exsuscito','v','exsuscit exsuscitav exsuscitat',NULL,NULL,'[ɛkˈsʊs.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19086,'extemplo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19091,'extendo','v','extend extend extens',NULL,NULL,'[ɛkˈstɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19092,'extensus','n','extens',NULL,NULL,'[ɛkˈstẽː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (19094,'extensio','n','extension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19096,'extenuo','v','extenu extenuav extenuat',NULL,NULL,'[ɛkˈstɛ.nʊ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19100,'exterus','a','exter exter exter',NULL,'aps---mn1-=exter','[ˈɛk.stɛ.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19105,'extermino','v','extermin exterminav exterminat',NULL,NULL,'[ɛkˈstɛr.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19108,'externus','a','extern extern extern',NULL,NULL,'[ɛkˈstɛr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19110,'exterreo','v','exterr exterru exterrit',NULL,NULL,'[ɛkˈstɛr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (19113,'extimesco','v','extimesc extimu -',NULL,NULL,'[ɛk.stɪˈmeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19123,'extollo','v','extoll extul -',NULL,NULL,'[ɛkˈstɔl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19124,'extollentia','n','extollenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19125,'extorqueo','v','extorqu extors extort',NULL,NULL,'[ɛkˈstɔr.kᶣe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (19127,'extra','r',NULL,NULL,NULL,'[ˈɛk.straː]','rp--------');
INSERT INTO latin_morpho VALUES (19133,'extraho','v','extrah extrax extract',NULL,NULL,'[ˈɛk.stra.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19142,'extrarius','a','extrari extrari extrari',NULL,NULL,'[ɛkˈstraː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19148,'extremitas','n','extremitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19149,'extrico','v','extric extricav extricat',NULL,NULL,'[ɛkˈstriː.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19158,'exturbo','v','exturb exturbav exturbat',NULL,NULL,'[ɛkˈstʊr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19159,'exuo','v','exu exu exut',NULL,NULL,'[ˈɛk.sʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19162,'exul','n','exul',NULL,NULL,NULL,'n-s---cn3-');
INSERT INTO latin_morpho VALUES (19164,'exulceratio','n','exulceration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19171,'exuro','v','exur exuss exust',NULL,NULL,'[ɛkˈsuː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19178,'for','v','f fat -',NULL,NULL,'[fɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (19180,'fabella','n','fabell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19181,'faber','n','fabr',NULL,NULL,NULL,'n-s---mn2r');
INSERT INTO latin_morpho VALUES (19185,'fabre','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19187,'fabrica','n','fabric',NULL,NULL,'[ˈfa.brɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19188,'fabrico','v','fabric fabricav fabricat',NULL,NULL,'[ˈfa.brɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19190,'fabricatio','n','fabrication',NULL,NULL,'[faː.brɪˈkaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19191,'fabricator','n','fabricator',NULL,NULL,'[faː.brɪˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19196,'fabula','n','fabul',NULL,NULL,'[ˈfaː.bʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19198,'fabulor','v','fabul fabulat -',NULL,NULL,'[ˈfaː.bʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (19199,'fabulatio','n','fabulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19200,'fabulator','n','fabulator',NULL,NULL,'[faː.bʊˈɫaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19203,'facesso','v','facess facess facessit',NULL,NULL,'[faˈkɛs.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19208,'facio','v','fac fec fact',NULL,NULL,'/ˈfa.ki.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (19209,'facies','n','faci',NULL,NULL,'/ˈfa.ki.eːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (19211,'facilis','a','facil facil facil',NULL,NULL,'[ˈfa.kɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19212,'facile','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19213,'facilitas','n','facilitat',NULL,NULL,'[faˈkɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19214,'faciliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19219,'facinorosus','a','facinoros facinoros facinoros',NULL,NULL,'[fa.kɪ.nɔˈroː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19221,'facinus','n','facinor',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (19222,'factum','n','fact',NULL,NULL,'[ˈfak.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19224,'factio','n','faction',NULL,NULL,'/ˈfak.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19227,'factito','v','factit factitav factitat',NULL,NULL,'[ˈfak.tɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19231,'factura','n','factur',NULL,NULL,'/fakˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19233,'facultas','n','facultat',NULL,NULL,'[faˈkʊɫ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19235,'facundus','a','facund facund facund',NULL,NULL,'[faːˈkʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19237,'facundia','n','facundi',NULL,NULL,'[faːˈkʊn.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19240,'faecula','n','faecul',NULL,NULL,'[ˈfae̯.kʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19245,'faenum','n','faen',NULL,NULL,'[ˈfae̯.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19252,'faeniculum','n','faenicul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19259,'faex','n','faec',NULL,NULL,'/fae̯ks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19280,'fallo','v','fall fefell fals',NULL,NULL,'/ˈfal.loː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (19281,'fallacia','n','fallaci',NULL,NULL,'/falˈlaː.ki.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19287,'fallax','a','fallac fallac fallac',NULL,NULL,'/ˈfal.laːks/','aps---an3-');
INSERT INTO latin_morpho VALUES (19289,'falsus','a','fals fals fals',NULL,NULL,'[ˈfaɫ.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19290,'falso','v','fals falsav falsat',NULL,NULL,'[ˈfaɫ.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19291,'falsarius','n','falsari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (19299,'fama','n','fam',NULL,NULL,'/ˈfaː.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19300,'famelicus','a','famelic famelic famelic',NULL,NULL,'[faˈmeː.lɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19301,'famen','n','famin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (19302,'fames','n','fam',NULL,NULL,'/ˈfa.meːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (19305,'familia','n','famili',NULL,NULL,'[faˈmɪ.li.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19307,'familiaris','a','familiar familiar familiar',NULL,NULL,'[fa.mɪ.lɪˈaː.rɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19309,'familiaritas','n','familiaritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19312,'famosus','a','famos famos famos',NULL,NULL,'[faːˈmoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19313,'famula','n','famul',NULL,NULL,'[ˈfa.mʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19314,'famulus','n','famul',NULL,NULL,'[ˈfa.mʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19316,'famulor','v','famul famulat -',NULL,NULL,'[ˈfa.mʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (19319,'famulatus','n','famulat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (19320,'famulitium','n','famuliti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19321,'fanum','n','fan',NULL,NULL,'[ˈfaː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19322,'fano','v','fan fanav fanat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19326,'fandus','a','fand fand fand',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19332,'far','n','farr',NULL,NULL,'/far/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19333,'farcio','v','farc fars fars',NULL,NULL,'/ˈfar.ki.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (19335,'farcimen','n','farcimin',NULL,NULL,'[farˈkiː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19337,'farina','n','farin',NULL,NULL,'/faˈriː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19340,'farrago','n','farragin',NULL,NULL,'/farˈraː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19345,'fas','n','fas',NULL,NULL,'/faːs/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19348,'fascia','n','fasci',NULL,NULL,'/ˈfas.ki.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19350,'fascino','v','fascin fascinav fascinat',NULL,NULL,'[ˈfas.kɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19354,'fascis','n','fasc',NULL,NULL,'[ˈfas.kɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (19360,'fastus','n','fast',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (19362,'fastidio','v','fastid fastidi fastidit',NULL,NULL,'/fasˈtiː.di.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (19363,'fastidium','n','fastidi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19368,'fastigium','n','fastigi',NULL,NULL,'[fasˈtiː.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19369,'fastosus','a','fastos fastos fastos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19371,'fatum','n','fat',NULL,NULL,'[ˈfaː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19372,'fateor','v','fat fass -',NULL,NULL,'[ˈfa.te.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (19377,'faticanus','a','fatican fatican fatican',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19379,'fatidicus','a','fatidic fatidic fatidic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19381,'fatigo','v','fatig fatigav fatigat',NULL,NULL,'/faˈtiː.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (19383,'fatigatio','n','fatigation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19385,'fatisco','v','fatisc - -',NULL,NULL,'/faˈtiːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (19390,'fatue','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19391,'fatuitas','n','fatuitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19393,'fauna','n','faun',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19396,'fautor','n','fautor',NULL,NULL,'[ˈfau̯.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19398,'faux','n','fauc',NULL,NULL,'/fau̯ks/','n-s---mn3i');
INSERT INTO latin_morpho VALUES (19399,'favus','n','fav',NULL,NULL,'[ˈfa.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19400,'faveo','v','fav fav faut',NULL,NULL,'/ˈfa.we.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (19401,'favilla','n','favill',NULL,NULL,'[faˈwɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19403,'favisor','n','favisor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (19406,'Favonius','n','Favoni',NULL,NULL,'[faˈwoː.ni.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19407,'favor','n','favor',NULL,NULL,'[ˈfa.wɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19410,'fax','n','fac',NULL,NULL,'/faks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19421,'fecundus','a','fecund fecund fecund',NULL,NULL,'[feːˈkʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19423,'fecunditas','n','fecunditat',NULL,NULL,'[feːˈkʊn.dɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19430,'fel','n','fell',NULL,NULL,'[fɛɫ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19431,'feles','n','fel',NULL,NULL,'[ˈfeː.ɫeːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (19433,'felicitas','n','felicitat',NULL,NULL,'[feːˈliː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19436,'felix','a','felic felic felic',NULL,NULL,'/ˈfeː.liːks/','aps---an3i');
INSERT INTO latin_morpho VALUES (19445,'femella','n','femell',NULL,NULL,'[feːˈmɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19447,'femina','n','femin',NULL,'n-s---fn1-=foemina','[ˈfeː.mɪ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19451,'femineus','a','femine femine femine',NULL,NULL,'[feːˈmɪ.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19452,'femininus','a','feminin feminin feminin',NULL,NULL,'[feː.mɪˈniː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19456,'femur','n','femor',NULL,NULL,'[ˈfɛ.mʊr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19462,'fenestra','n','fenestr',NULL,NULL,'[fɛˈnɛs.tra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19467,'fenus','n','fenor',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (19477,'fero','v','fer tul lat','v--pna--3-=ferre v2spia--3-=fers v3spia--3-=fert v2ppia--3-=fertis',NULL,'[ˈfɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19482,'ferax','a','ferac ferac ferac',NULL,NULL,'[ˈfɛ.raks]','aps---an3i');
INSERT INTO latin_morpho VALUES (19485,'ferculum','n','fercul',NULL,NULL,'[ˈfɛr.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19486,'fere','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19489,'ferio','v','fer feriv ferit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (19502,'feritas','n','feritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19503,'ferme','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19504,'fermentum','n','ferment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19511,'ferociter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19513,'ferrum','n','ferr',NULL,NULL,'[ˈfɛr.rũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19530,'ferrumen','n','ferrumin',NULL,NULL,'[fɛrˈruː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19531,'ferrumino','v','ferrumin ferruminav ferruminat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19533,'fertilis','a','fertil fertil fertil',NULL,NULL,'[ˈfɛr.tɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19535,'fertilitas','n','fertilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19536,'ferula','n','ferul',NULL,NULL,'[ˈfɛ.rʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19538,'ferveo','v','ferv ferbu -',NULL,NULL,'[ˈfɛr.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (19540,'fervefacio','v','fervefac fervefec fervefact',NULL,NULL,'[fɛr.wɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (19541,'fervens','a','fervent fervent fervent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (19543,'fervidus','a','fervid fervid fervid',NULL,NULL,'[ˈfɛr.wɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19544,'fervor','n','fervor',NULL,NULL,'[ˈfɛr.wɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19545,'fessus','a','fess fess fess',NULL,NULL,'[ˈfɛs.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19548,'festinus','a','festin festin festin',NULL,NULL,'[fɛsˈtiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19549,'festino','v','festin festinav festinat',NULL,NULL,'[fɛsˈtiː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19550,'festinanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19551,'festinantia','n','festinanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19553,'festinatio','n','festination',NULL,NULL,'[fɛs.tiːˈnaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19554,'festinato','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19557,'festivitas','n','festivitat',NULL,NULL,'[feːsˈtiː.wɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19559,'festuca','n','festuc',NULL,NULL,'[fɛsˈtuː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19562,'fetus','n','fet',NULL,NULL,'[ˈfeː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (19563,'fetus','a','fet fet fet',NULL,NULL,'[ˈfeː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19570,'fio','v','f - -','v--pna--3i=fieri v1sridmn3i=factus_sum v1sridfn3i=facta_sum v1sridnn3i=factum_sum',NULL,'/ˈfiː.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (19572,'fiber','n','fibr',NULL,NULL,'[ˈfɪ.bɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (19574,'fibra','n','fibr',NULL,NULL,'[ˈfɪ.bra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19576,'fibula','n','fibul',NULL,NULL,'[ˈfiː.bʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19577,'ficus','n','fic',NULL,NULL,'[ˈfiː.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19582,'fictus','a','fict fict fict',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19583,'ficte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19590,'fides','n','fid',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (19591,'fidus','a','fid fid fid',NULL,NULL,'[ˈfiː.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19599,'fideiussor','n','fideiussor',NULL,NULL,'[fɪ.dɛˈjʊs.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19601,'fidelis','a','fidel fidel fidel',NULL,NULL,'[fɪˈdeː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19603,'fidelitas','n','fidelitat',NULL,NULL,'[fɪˈdeː.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19604,'fideliter','r',NULL,NULL,NULL,'[fɪˈdeː.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (19606,'fidens','a','fident fident fident',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (19607,'fides','n','fid',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (19613,'fiducia','n','fiduci',NULL,NULL,'/fiːˈduː.ki.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19616,'figo','v','fiv fix fix',NULL,NULL,'/ˈfiː.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (19619,'figmentum','n','figment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19620,'figulus','n','figul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (19622,'figura','n','figur',NULL,NULL,'[fɪˈɡuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19623,'figuro','v','figur figurav figurat',NULL,NULL,'[fɪˈɡuː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19626,'filum','n','fil',NULL,NULL,'[ˈfiː.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19628,'filia','n','fili',NULL,NULL,'/ˈfiː.li.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19629,'filius','n','fili',NULL,NULL,'[ˈfiː.li.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19635,'filix','n','filic',NULL,NULL,'[ˈfɪ.lɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19638,'fimum','n','fim',NULL,NULL,'[ˈfɪ.mũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19646,'findo','v','find fid fiss',NULL,NULL,'[ˈfɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19648,'fingo','v','fing finx fict',NULL,NULL,'[ˈfɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19651,'finio','v','fin finiv finit',NULL,NULL,'/ˈfiː.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (19652,'finis','n','fin',NULL,NULL,'[ˈfiː.nɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (19655,'finitio','n','finition',NULL,NULL,'/fiːˈniː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19657,'firmo','v','firm firmav firmat',NULL,NULL,'[ˈfɪr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19658,'firmus','a','firm firm firm',NULL,NULL,'[ˈfɪr.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19659,'firmamen','n','firmamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (19660,'firmamentum','n','firmament',NULL,NULL,'[fɪr.maːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19662,'firmitas','n','firmitat',NULL,NULL,'[ˈfɪr.mɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19663,'firmiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19664,'firmitudo','n','firmitudin',NULL,NULL,'[fɪr.mɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19666,'fiscalis','a','fiscal fiscal fiscal',NULL,NULL,'[fɪsˈkaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19672,'fistula','n','fistul',NULL,NULL,'[ˈfɪs.tʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19676,'flo','v','fl flav flat',NULL,NULL,'[fɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19677,'fleo','v','fl flev flet',NULL,NULL,'[ˈfɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (19684,'flagellum','n','flagell',NULL,NULL,'[fɫaˈɡɛl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19685,'flagello','v','flagell flagellav flagellat',NULL,NULL,'[fɫaˈɡɛl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19686,'flagito','v','flagit flagitav flagitat',NULL,NULL,'[ˈfɫaː.ɡɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19687,'flagitatio','n','flagitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19689,'flagitium','n','flagiti',NULL,NULL,'[fɫaːˈɡɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19691,'flagrum','n','flagr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19692,'flagro','v','flagr flagrav flagrat',NULL,NULL,'[ˈfɫa.ɡroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19693,'flagrans','a','flagrant flagrant flagrant',NULL,NULL,'[ˈfɫa.ɡrãːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (19697,'flamen','n','flamin',NULL,NULL,'[ˈfɫaː.mẽ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19703,'flamma','n','flamm',NULL,NULL,'[ˈfɫam.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19704,'flammo','v','flamm flammav flammat',NULL,NULL,'[ˈfɫam.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19706,'flammeus','a','flamme flamme flamme',NULL,NULL,'[ˈfɫam.me.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19708,'flammidus','a','flammid flammid flammid',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19709,'flammifer','a','flammifer flammifer flammifer',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (19713,'flammiger','a','flammiger flammiger flammiger',NULL,NULL,'[ˈfɫam.mɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (19716,'flatus','n','flat',NULL,NULL,'[ˈfɫaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (19718,'flavus','a','flav flav flav',NULL,NULL,'/ˈflaː.wus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (19726,'flecto','v','flect flex flex',NULL,NULL,'[ˈfɫɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19727,'fletus','n','flet',NULL,NULL,'[ˈfɫeː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (19728,'flexus','n','flex',NULL,NULL,'[ˈfɫɛk.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (19729,'flexanimus','a','flexanim flexanim flexanim',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19731,'flexibilitas','n','flexibilitat',NULL,NULL,'[fɫɛk.sɪˈbɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19742,'floreo','v','flor floru -',NULL,NULL,'[ˈfɫoː.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (19744,'florens','a','florent florent florent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (19745,'floresco','v','floresc - -',NULL,NULL,'[fɫoːˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19749,'flos','n','flor',NULL,NULL,'[fɫoːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19752,'fluo','v','flu flux flux',NULL,NULL,'[ˈfɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19753,'fluctus','n','fluct',NULL,NULL,'[ˈfɫʊk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (19755,'fluctio','n','fluction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19757,'fluctuo','v','fluctu fluctuav fluctuat',NULL,NULL,'[ˈfɫʊk.tʊ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19761,'fluentum','n','fluent',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19763,'fluito','v','fluit fluitav fluitat',NULL,NULL,'[ˈfɫʊ.ɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19764,'flumen','n','flumin',NULL,NULL,'[ˈfɫuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19767,'fluvius','n','fluvi',NULL,NULL,'[ˈfɫʊ.wi.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19774,'focus','n','foc',NULL,NULL,'[ˈfɔ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19777,'focaria','n','focari',NULL,NULL,'[fɔˈkaː.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19779,'focilo','v','focil focilav focilat',NULL,NULL,'[ˈfɔ.kɪ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19781,'foculus','n','focul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (19782,'fodio','v','fod fod foss',NULL,NULL,'[ˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (19784,'fodina','n','fodin',NULL,NULL,'[fɔˈdiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19788,'foedo','v','foed foedav foedat',NULL,NULL,'/ˈfoe̯.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (19790,'foedero','v','foeder foederav foederat',NULL,NULL,'[ˈfoe̯.dɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19796,'foeditas','n','foeditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19797,'foedus','n','foed',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (19803,'foetor','n','foetor',NULL,NULL,'[ˈfoe̯.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19804,'folium','n','foli',NULL,NULL,'[ˈfɔ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19808,'folliculus','n','follicul',NULL,NULL,'[fɔlˈlɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (19809,'follis','n','foll',NULL,NULL,'[ˈfɔl.lɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (19810,'fomentum','n','foment',NULL,NULL,'[foːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19812,'fons','n','font',NULL,NULL,'[fõːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (19817,'forum','n','for',NULL,NULL,'[ˈfɔ.rũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19819,'foramen','n','foramin',NULL,NULL,'[fɔˈraː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19821,'foras','r',NULL,NULL,NULL,'[ˈfɔ.raːs]','rp--------');
INSERT INTO latin_morpho VALUES (19822,'forceps','n','forcip',NULL,NULL,'[ˈfɔr.kɛps]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19831,'forensis','a','forens forens forens',NULL,NULL,'[fɔˈrẽː.sɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19834,'foricula','n','foricul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19837,'foris','r',NULL,NULL,NULL,'[ˈfɔ.rɪs]','rp--------');
INSERT INTO latin_morpho VALUES (19838,'foris','n','for',NULL,NULL,'[ˈfɔ.rɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (19840,'forma','n','form',NULL,NULL,'/ˈfoːr.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19841,'formo','v','form formav format',NULL,NULL,'/ˈfoːr.moː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (19849,'formica','n','formic',NULL,NULL,'[fɔrˈmiː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19850,'formido','v','formid formidav formidat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (19854,'formido','n','formidin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19858,'formidulosus','a','formidulos formidulos formidulos',NULL,NULL,'[fɔr.miː.dʊˈɫoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19863,'formosus','a','formos formos formos',NULL,NULL,'[foːrˈmoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19866,'formula','n','formul',NULL,NULL,'[ˈfoːr.mʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19868,'fornax','n','fornac',NULL,NULL,'[ˈfɔr.naːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19872,'fornicatus','a','fornicat fornicat fornicat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (19874,'fornicatio','n','fornication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19876,'fornicator','n','fornicator',NULL,NULL,'[fɔr.nɪˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19877,'fornicatrix','n','fornicatric',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19878,'fornix','n','fornic',NULL,NULL,'[ˈfɔr.nɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19879,'forpex','n','forpic',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19880,'fors','n','fort',NULL,NULL,'[fɔrs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19881,'forsan','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19882,'forsit','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19883,'forsitan','r',NULL,NULL,NULL,'[ˈfɔr.sɪ.tã]','rp--------');
INSERT INTO latin_morpho VALUES (19884,'fortis','a','fort fort fort',NULL,NULL,'[ˈfɔr.tɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19885,'fortasse','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19886,'fortassis','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19887,'forte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19889,'fortifico','v','fortific fortificav fortifica',NULL,NULL,'[fɔrˈtɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19891,'fortiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19892,'fortitudo','n','fortitudin',NULL,NULL,'[fɔr.tɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19895,'fortuito','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19897,'fortuna','n','fortun',NULL,NULL,'[fɔrˈtuː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19899,'fortunatus','a','fortunat fortunat fortunat',NULL,NULL,'[fɔr.tuːˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19903,'fossa','n','foss',NULL,NULL,'[ˈfɔs.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19910,'fossio','n','fossion',NULL,NULL,'[ˈfɔs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19912,'foveo','v','fov fov fot',NULL,NULL,'[ˈfɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (19913,'fovea','n','fove',NULL,NULL,'[ˈfɔ.we.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19914,'fracesco','v','fracesc fracu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (19917,'fragilis','a','fragil fragil fragil',NULL,NULL,'[ˈfra.ɡɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (19918,'fragilitas','n','fragilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19922,'fragmen','n','fragmin',NULL,NULL,'[ˈfraɡ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19923,'fragmentum','n','fragment',NULL,NULL,'[fraɡˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19924,'fragor','n','fragor',NULL,NULL,'[ˈfra.ɡɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19925,'fragosus','a','fragos fragos fragos',NULL,NULL,'[fraˈɡoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19927,'fragrantia','n','fragranti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19931,'frango','v','frang freg fract',NULL,NULL,'[ˈfraŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19932,'frater','n','fratr',NULL,NULL,'[ˈfraː.tɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (19934,'fraternus','a','fratern fratern fratern',NULL,NULL,'[fraːˈtɛr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19935,'fraternitas','n','fraternitat',NULL,NULL,'[fraːˈtɛr.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19937,'fraudo','v','fraud fraudav fraudat',NULL,NULL,'/ˈfrau̯.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (19938,'fraudulentus','a','fraudulent fraudulent fraudulent',NULL,NULL,'[frau̯.dʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (19940,'fraudulentia','n','fraudulenti',NULL,NULL,'[frau̯.dʊˈɫɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (19942,'fraus','n','fraud',NULL,NULL,'/frau̯s/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (19946,'fremo','v','frem fremu fremit',NULL,NULL,'[ˈfrɛ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (19948,'fremitus','n','fremit',NULL,NULL,'[ˈfrɛ.mɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (19950,'fremor','n','fremor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (19952,'frenum','n','fren',NULL,NULL,'[ˈfreː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19953,'freno','v','fren frenav frenat',NULL,NULL,'/ˈfreː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (19956,'frequens','a','frequent frequent frequent',NULL,NULL,'[ˈfrɛ.kᶣẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (19957,'frequento','v','frequent frequentav frequentat',NULL,NULL,'[frɛˈkᶣɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19958,'frequenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (19959,'frequentia','n','frequenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19960,'fretum','n','fret',NULL,NULL,'[ˈfrɛ.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (19962,'frio','v','fri friav friat',NULL,NULL,'/ˈfri.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (19964,'frico','v','fric fricav fricat',NULL,NULL,'[ˈfrɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (19966,'fricatio','n','frication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19967,'frictio','n','friction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (19968,'frigo','v','frig - -',NULL,NULL,'/ˈfriː.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (19970,'frigdor','n','frigdor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (19971,'frigesco','v','frigesc frix -',NULL,NULL,'/friːˈɡeːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (19973,'frigidarium','n','frigidari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19976,'frigor','n','frigor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (19977,'frigus','n','frigor',NULL,NULL,'[ˈfriː.ɡʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (19979,'friguttio','v','frigutt friguttiv friguttit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (19987,'frixorium','n','frixori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (19988,'frixura','n','frixur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (19996,'frons','n','frond',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (20000,'fruor','v','fru fruit -',NULL,NULL,'[ˈfrʊ.ɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (20002,'fructus','n','fruct',NULL,NULL,'[ˈfrʊk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (20005,'fructifico','v','fructific fructificav fructifica',NULL,NULL,'[frʊkˈtɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20007,'fructuosus','a','fructuos fructuos fructuos',NULL,NULL,'[frʊk.tʊˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20009,'frugalis','a','frugal frugal frugal',NULL,NULL,'[fruːˈɡaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (20010,'frugalitas','n','frugalitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20011,'frugaliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (20012,'frugi','a',NULL,NULL,NULL,NULL,'aps---an--');
INSERT INTO latin_morpho VALUES (20013,'frugifer','a','frugifer frugifer frugifer',NULL,NULL,'[ˈfruː.ɡɪ.fɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (20017,'fruitio','n','fruition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20018,'frumentum','n','frument',NULL,NULL,'[fruːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20025,'frustum','n','frust',NULL,NULL,'[ˈfrʊs.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20030,'frustror','v','frustr frustrat -',NULL,NULL,'[ˈfruːs.trɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (20032,'frustra','r',NULL,NULL,NULL,'/ˈfruːs.traː/','rp--------');
INSERT INTO latin_morpho VALUES (20034,'frustratio','n','frustration',NULL,NULL,'/fruːsˈtraː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20038,'frutex','n','frutic',NULL,NULL,'[ˈfrʊ.tɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20046,'fucus','n','fuc',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (20047,'fuco','v','fuc fucav fucat',NULL,NULL,'/ˈfuː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (20051,'fugo','v','fug fugav fugat',NULL,NULL,'[ˈfʊ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20053,'fugio','v','fug fug -',NULL,NULL,'[ˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (20056,'fulcio','v','fulc fuls fult',NULL,NULL,'[ˈfʊɫ.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (20057,'fulcimen','n','fulcimin',NULL,NULL,'[fʊɫˈkiː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20061,'fulgeo','v','fulg fuls -',NULL,NULL,'[ˈfʊɫ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (20064,'fulgesco','v','fulgesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (20066,'fulgor','n','fulgor',NULL,NULL,'[ˈfʊɫ.ɡɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20069,'fulgur','n','fulgur',NULL,NULL,'[ˈfʊɫ.ɡʊr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20075,'fuligo','n','fuligin',NULL,NULL,'/fuːˈliː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20080,'fulmen','n','fulmin',NULL,NULL,'[ˈfʊɫ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20082,'fulmentum','n','fulment',NULL,NULL,'[fʊɫˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20087,'fumus','n','fum',NULL,NULL,'[ˈfuː.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20088,'fumo','v','fum fumav fumat',NULL,NULL,'/ˈfuː.moː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (20096,'fumigo','v','fumig fumigav fumigat',NULL,NULL,'[ˈfuː.mɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20100,'fumigium','n','fumigi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20105,'functio','n','function',NULL,NULL,'[ˈfuːŋk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20109,'funda','n','fund',NULL,NULL,'[ˈfʊn.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20110,'fundus','n','fund',NULL,NULL,'[ˈfʊn.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20111,'fundo','v','fund fundav fundat',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (20115,'fundamentum','n','fundament',NULL,NULL,'[fʊn.daːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20116,'fundatio','n','fundation',NULL,NULL,'[fʊnˈdaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20121,'fundibulum','n','fundibul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20124,'funditus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (20130,'funestus','a','funest funest funest',NULL,NULL,'[fuːˈnɛs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20132,'fungus','n','fung',NULL,NULL,'[ˈfʊŋ.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20133,'fungor','v','fung funct -',NULL,NULL,'[ˈfʊŋ.ɡɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (20136,'funiculus','n','funicul',NULL,NULL,'[fuːˈnɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20137,'funis','n','fun',NULL,NULL,'[ˈfuː.nɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (20139,'funus','n','funer',NULL,NULL,'[ˈfuː.nʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20140,'fur','n','fur',NULL,NULL,'/fuːr/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20142,'furo','v','fur - -',NULL,NULL,'[ˈfʊ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (20144,'furca','n','furc',NULL,NULL,'[ˈfʊr.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20145,'furcifer','n','furcifer',NULL,NULL,'[ˈfʊr.kɪ.fɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (20149,'furfur','n','furfur',NULL,NULL,'[ˈfʊr.fʊr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20150,'furia','n','furi',NULL,NULL,'[ˈfʊ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20154,'furiosus','a','furios furios furios',NULL,NULL,'[fʊ.rɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20155,'furnus','n','furn',NULL,NULL,'[ˈfʊr.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20157,'furor','n','furor',NULL,NULL,'[ˈfuː.rɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20159,'furtum','n','furt',NULL,NULL,'[ˈfuːr.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20161,'furtim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (20163,'furunculus','n','furuncul',NULL,NULL,'[fuːˈrʊŋ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20165,'fusus','n','fus',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (20166,'fusus','a','fus fus fus',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (20168,'fusco','v','fusc fuscav fuscat',NULL,NULL,'[ˈfʊs.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20169,'fuscina','n','fuscin',NULL,NULL,'[ˈfʊs.kɪ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20170,'fuscinula','n','fuscinul',NULL,NULL,'[fʊsˈkɪ.nʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20185,'gabalus','n','gabal',NULL,NULL,'[ˈɡa.ba.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20208,'galea','n','gale',NULL,NULL,'[ˈɡa.ɫe.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20212,'galerus','n','galer',NULL,NULL,'[ɡaˈɫeː.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20214,'galericulum','n','galericul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20219,'gallus','n','gall',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (20222,'Gallia','n','Galli',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20227,'Gallicus','a','Gallic Gallic Gallic',NULL,NULL,'ˈɡal.lɪ.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (20228,'gallicinium','n','gallicini',NULL,NULL,'[ɡal.lɪˈkɪ.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20230,'gallina','n','gallin',NULL,NULL,'/ɡalˈliː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20238,'ganeo','n','ganeon',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20239,'gannio','v','gann ganniv gannit',NULL,NULL,'/ˈɡan.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (20240,'gannitus','n','gannit',NULL,NULL,'/ɡanˈniː.tus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (20248,'gargarizo','v','gargariz gargarizav gargarizat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (20250,'garrio','v','garr garriv garrit',NULL,NULL,'/ˈɡar.ri.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (20253,'garrulitas','n','garrulitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20266,'gaudeo','v','gaud - gavis',NULL,NULL,'/ˈɡau̯.de.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (20267,'gaudium','n','gaudi',NULL,NULL,'[ˈɡau̯.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20269,'gaudimonium','n','gaudimoni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20284,'Gehenna','n','gehenn',NULL,NULL,'[ɡɛˈhɛn.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20295,'gelicidium','n','gelicidi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20299,'gemo','v','gem gemu gemit',NULL,NULL,'[ˈɡɛ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (20306,'gemino','v','gemin geminav geminat',NULL,NULL,'/ˈɡe.mi.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (20307,'geminatio','n','gemination',NULL,NULL,'/ɡe.miˈnaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20308,'gemitus','n','gemit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (20309,'gemma','n','gemm',NULL,NULL,'[ˈɡɛm.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20317,'genu','n','gen',NULL,NULL,'[ˈɡɛ.nuː]','n-s---nn4-');
INSERT INTO latin_morpho VALUES (20319,'Genava','n','Genav',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20320,'genealogus','n','genealog',NULL,NULL,'[ɡɛ.nɛˈaː.ɫɔ.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20321,'genealogia','n','genealogi',NULL,NULL,'[ɡɛ.ne.aːˈɫɔ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20323,'gener','n','gener',NULL,NULL,'[ˈɡɛ.nɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (20324,'genero','v','gener generav generat',NULL,NULL,'[ˈɡɛ.nɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20327,'generalitas','n','generalitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20331,'generatio','n','generation',NULL,NULL,'[ɡɛ.nɛˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20332,'generativus','a','generativ generativ generativ',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (20333,'generator','n','generator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20337,'generose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (20344,'genetrix','n','genetric',NULL,NULL,'[ˈɡɛ.nɛ.triːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20345,'genius','n','geni',NULL,NULL,'[ˈɡɛ.ni.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20347,'genialis','a','genial genial genial',NULL,NULL,'[ɡɛ.nɪˈaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (20349,'genimen','n','genimin',NULL,NULL,'[ˈɡɛ.nɪ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20354,'genitor','n','genitor',NULL,NULL,'[ˈɡɛ.nɪ.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20356,'gens','n','gent',NULL,NULL,'[ɡẽːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (20363,'gentilis','n','gentil',NULL,NULL,'[ɡɛnˈtiː.lɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (20365,'gentilitas','n','gentilitat',NULL,NULL,'[ɡɛnˈtiː.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20369,'genuflecto','v','genuflect genuflex genuflex',NULL,NULL,'[ɡɛ.nuːˈfɫɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (20370,'genuinus','n','genuin',NULL,NULL,'[ɡɛ.nʊˈiː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20371,'genuinus','a','genuin genuin genuin',NULL,NULL,'[ɡɛ.nʊˈiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20373,'genus','n','gen',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (20379,'geographia','n','geographi',NULL,NULL,'/ɡe.oːˈɡra.pʰi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20380,'geographicus','a','geographic geographic geographic',NULL,NULL,'[ɡe.oːˈɡra.pʰɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20385,'geometria','n','geometri',NULL,NULL,'[ɡe.oːˈmɛ.tri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20387,'geometricus','a','geometric geometric geometric',NULL,NULL,'[ɡe.oːˈmɛ.trɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20388,'georgicus','a','georgic georgic georgic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (20389,'gero','v','ger gess gest',NULL,NULL,'[ˈɡɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (20392,'germana','n','german',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20395,'germanus','a','german german german',NULL,NULL,'[ɡɛrˈmaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20396,'Germania','n','Germani',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20400,'germen','n','germin',NULL,NULL,'[ˈɡɛr.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20403,'germinatio','n','germination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20410,'gerulus','n','gerul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (20415,'gestus','n','gest',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (20416,'gesto','v','gest gestav gestat',NULL,NULL,'[ˈɡɛs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20419,'gestio','v','gest gesti -',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (20420,'gesticulor','v','gesticul gesticulat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (20422,'gibbus','n','gibb',NULL,NULL,'[ˈɡɪb.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20423,'gibbus','a','gibb gibb gibb',NULL,'aps---mn1-=gybbus aps---fn1-=gybba aps---nn1-=gybbum aps---mn1-=gippus aps---fn1-=gippa aps---nn1-=gippum aps---mn1-=gimbus aps---fn1-=gimba aps---nn1-=gimbum aps---mn1-=gipus aps---fn1-=gipa aps---nn1-=gipum aps---mn1-=gibus aps---fn1-=giba aps---nn1-=gibum aps---mn1-=gilbus aps---fn1-=gilba aps---nn1-=gilbum','[ˈɡɪb.bʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20424,'gibber','n','gibber',NULL,NULL,'[ˈɡɪb.bɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20427,'gigans','n','gigant',NULL,'n-s---mn3-=gigas',NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20430,'gigno','v','gen genu genit',NULL,NULL,'[ˈɡɪŋ.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (20435,'gingiva','n','gingiv',NULL,NULL,'[ɡɪŋˈɡiː.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20440,'glaber','a','glabr glabr glabr',NULL,NULL,'[ˈɡɫa.bɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (20442,'glacies','n','glaci',NULL,NULL,'[ˈɡɫa.ki.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (20443,'glacio','v','glaci glaciav glaciat',NULL,NULL,'[ˈɡɫa.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20446,'gladius','n','gladi',NULL,NULL,'[ˈɡɫa.di.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20448,'gladiator','n','gladiator',NULL,NULL,'[ɡɫa.dɪˈaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20455,'glans','n','gland',NULL,NULL,'[ɡɫãːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (20456,'glarea','n','glare',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20461,'glaucoma','n','glaucomat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (20462,'gleba','n','gleb',NULL,NULL,'[ˈɡɫeː.ba]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20466,'glis','n','glit',NULL,NULL,'/ɡliːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20467,'glisco','v','glisc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (20468,'globus','n','glob',NULL,NULL,'[ˈɡɫɔ.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20470,'globosus','a','globos globos globos',NULL,NULL,'[ɡɫɔˈboː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20472,'glomero','v','glomer glomerav glomerat',NULL,NULL,'[ˈɡɫɔ.mɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20475,'gloria','n','glori',NULL,NULL,'[ˈɡɫoː.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20479,'glorificus','a','glorific glorific glorific',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (20480,'glorifico','v','glorific glorificav glorificat',NULL,NULL,'[ɡɫoːˈrɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20481,'glorificatio','n','glorification',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20483,'gloriosus','a','glorios glorios glorios',NULL,NULL,'[ɡɫoː.rɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20495,'gluten','n','glutin',NULL,NULL,'[ˈɡɫuː.tẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20497,'glutinum','n','glutin',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20498,'glutino','v','glutin glutinav glutinat',NULL,NULL,'[ˈɡɫuː.tɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20502,'gluttio','v','glutt glutti gluttit',NULL,NULL,'[ˈɡɫʊt.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (20503,'glutto','n','glutton',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20508,'gnarus','a','gnar gnar gnar',NULL,NULL,'[ˈŋnaː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20509,'gnaritas','n','gnaritat',NULL,NULL,'[ˈŋnaː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20528,'gracilis','a','gracil gracil gracil',NULL,NULL,'[ˈɡra.kɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (20529,'gracilitas','n','gracilitat',NULL,NULL,'[ɡraˈkɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20531,'gradus','n','grad',NULL,NULL,'[ˈɡra.dʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (20534,'gradatim','r',NULL,NULL,NULL,'[ɡraˈdaː.tĩ]','rp--------');
INSERT INTO latin_morpho VALUES (20535,'gradatio','n','gradation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20536,'gradior','v','grad gress -',NULL,NULL,'[ˈɡra.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (20542,'Graecus','a','Graec Graec Graec',NULL,NULL,'ˈɡrae̯.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (20546,'Graecia','n','Graeci',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20549,'Graeculus','a','Graecul Graecul Graecul',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (20551,'gramen','n','gramin',NULL,NULL,'[ˈɡraː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20553,'gramineus','a','gramine gramine gramine',NULL,NULL,'[ɡraːˈmɪ.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20554,'gramma','n','grammat',NULL,NULL,'/ˈɡram.ma/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20556,'grammatica','n','grammatic',NULL,NULL,'[ɡramˈma.tɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20558,'grammaticus','n','grammatic',NULL,NULL,'/ɡramˈma.ti.kus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20562,'granum','n','gran',NULL,NULL,'[ˈɡraː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20563,'granarium','n','granari',NULL,NULL,'[ɡraːˈnaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20568,'grandis','a','grand grand grand',NULL,NULL,'[ˈɡran.dɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (20570,'grandesco','v','grandesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (20571,'grandio','v','grand grandiv grandit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (20577,'granditas','n','granditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20580,'grando','n','grandin',NULL,NULL,'/ˈɡran.doː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20590,'graphium','n','graphi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20592,'graphicus','a','graphic graphic graphic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (20595,'grassor','v','grass grassat -',NULL,NULL,'[ˈɡras.sɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (20596,'grassator','n','grassator',NULL,NULL,'[ɡrasˈsaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20597,'gratus','a','grat grat grat',NULL,NULL,'[ˈɡraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20600,'grate','r',NULL,NULL,NULL,'/ˈɡraː.teː/','rp--------');
INSERT INTO latin_morpho VALUES (20601,'grates','n','grat',NULL,NULL,'/ˈɡraː.teːs/','n-p---fn3-');
INSERT INTO latin_morpho VALUES (20602,'gratia','n','grati',NULL,NULL,'/ˈɡraː.ti.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20606,'gratiosus','a','gratios gratios gratios',NULL,NULL,'[ɡraː.tɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20611,'gratuito','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (20612,'gratulor','v','gratul gratulat -',NULL,NULL,'[ˈɡraː.tʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (20615,'gratulatio','n','gratulation',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20618,'gravo','v','grav gravav gravat',NULL,NULL,'/ˈɡra.woː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (20619,'gravis','a','grav grav grav',NULL,NULL,'[ˈɡra.wɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (20621,'gravamen','n','gravamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (20624,'gravate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (20627,'gravedo','n','gravedin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20631,'gravidus','a','gravid gravid gravid',NULL,NULL,'[ˈɡra.wɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20635,'gravitas','n','gravitat',NULL,NULL,'/ˈɡra.wi.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20636,'graviter','r',NULL,NULL,NULL,'[ˈɡra.wɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (20638,'grego','v','greg gregav gregat',NULL,NULL,'[ˈɡrɛ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20645,'gremium','n','gremi',NULL,NULL,'[ˈɡrɛ.mi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (20648,'gressus','n','gress',NULL,NULL,'[ˈɡrɛs.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (20649,'grex','n','greg',NULL,NULL,'[ɡrɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20650,'griphus','n','griph',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (20656,'grossus','a','gross gross gross',NULL,NULL,'[ˈɡrɔs.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20657,'grossitudo','n','grossitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20664,'grus','n','gru',NULL,NULL,'/ɡruːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20669,'gryllus','n','gryll',NULL,NULL,'[ˈɡrʏl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20673,'gryps','n','gryph',NULL,NULL,'[ɡrʏps]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20675,'guberno','v','gubern gubernav gubernat',NULL,NULL,'[ɡʊˈbɛr.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20676,'gubernaculum','n','gubernacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20677,'gubernatio','n','gubernation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20678,'gubernator','n','gubernator',NULL,NULL,'[ɡʊ.bɛrˈnaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20680,'gubernius','n','guberni',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (20683,'gula','n','gul',NULL,NULL,'[ˈɡʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20686,'gumia','n','gumi',NULL,NULL,'[ˈɡʊ.mi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20694,'gurges','n','gurgit',NULL,NULL,'[ˈɡʊr.ɡɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20696,'gurgustium','n','gurgusti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20697,'gustus','n','gust',NULL,NULL,'[ˈɡʊs.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (20698,'gusto','v','gust gustav gustat',NULL,NULL,'/ˈɡus.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (20699,'gustatus','n','gustat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (20700,'gutta','n','gutt',NULL,NULL,'[ˈɡʊt.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20705,'guttur','n','guttur',NULL,NULL,'[ˈɡʊt.tʊr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (20727,'gyrus','n','gyr',NULL,NULL,'/ˈɡyː.rus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20732,'habeo','v','hab habu habit',NULL,NULL,'/ˈha.be.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (20734,'habena','n','haben',NULL,NULL,'/haˈbeː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20740,'habito','v','habit habitav habitat',NULL,NULL,'[ˈha.bɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20742,'habitaculum','n','habitacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20744,'habitatio','n','habitation',NULL,NULL,'[ha.bɪˈtaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20745,'habitator','n','habitator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20751,'habitudo','n','habitudin',NULL,NULL,'[ha.bɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20764,'haedus','n','haed',NULL,NULL,'[ˈhae̯.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20772,'haemorrhagia','n','haemorrhagi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20776,'haereo','v','haer haes haes',NULL,NULL,'/ˈhae̯.re.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (20779,'haeresis','n','haeres',NULL,NULL,'[ˈhae̯.rɛ.sɪs]','n-s---fn3g');
INSERT INTO latin_morpho VALUES (20784,'haesitatio','n','haesitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (20794,'halo','v','hal halav halat',NULL,NULL,'[ˈhaː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20801,'halitus','n','halit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (20810,'hama','n','ham',NULL,NULL,'/ˈha.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20811,'hamus','n','ham',NULL,NULL,'[ˈhaː.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20818,'Hannibal','n','Hannibal',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20820,'hara','n','har',NULL,NULL,'/ˈha.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20822,'harena','n','haren',NULL,NULL,'/haˈreː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20823,'harenaceus','a','harenace harenace harenace',NULL,NULL,'/ha.reːˈnaː.ke.us/','aps---mn1-');
INSERT INTO latin_morpho VALUES (20826,'harenarius','n','harenari',NULL,NULL,'/ha.reːˈnaː.ri.us/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (20835,'harenosus','a','harenos harenos harenos',NULL,NULL,'[ha.reːˈnoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20839,'hariolus','n','hariol',NULL,NULL,'[haˈri.ɔ.ɫʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (20841,'harmonia','n','harmoni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20845,'harmonicus','a','harmonic harmonic harmonic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (20847,'harpe','n','harp',NULL,NULL,'/ˈhar.peː/','n-s---fn1g');
INSERT INTO latin_morpho VALUES (20849,'harpago','n','harpagon',NULL,NULL,'/ˈhar.pa.ɡoː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20857,'harundo','n','harundin',NULL,NULL,'[haˈrʊn.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20865,'hasta','n','hast',NULL,NULL,'/ˈhas.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20869,'hastile','n','hastil',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (20872,'haud','r',NULL,NULL,NULL,'/hau̯d/','rp--------');
INSERT INTO latin_morpho VALUES (20876,'haurio','v','haur haus haust',NULL,NULL,'/ˈhau̯.ri.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (20892,'hebdomas','n','hebdomad',NULL,NULL,'[ˈhɛb.dɔ.mas]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20899,'hebes','a','hebet hebet hebet',NULL,NULL,'[ˈhɛ.bɛs]','aps---an3-');
INSERT INTO latin_morpho VALUES (20901,'hebeto','v','hebet hebetav hebetat',NULL,NULL,'[ˈhɛ.bɛ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20905,'Hebraeus','a','Hebrae Hebrae Hebrae',NULL,NULL,'hɛˈbrae̯.ʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (20906,'Hebraicus','a','Hebraic Hebraic Hebraic',NULL,NULL,'hɛˈbra.ɪ.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (20911,'hecatombe','n','hecatomb',NULL,NULL,'[hɛ.kaˈtɔm.beː]','n-s---fn1g');
INSERT INTO latin_morpho VALUES (20914,'Hector','n','Hector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (20916,'hedera','n','heder',NULL,NULL,'[ˈhɛ.dɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20936,'helluor','v','hellu helluat -',NULL,NULL,'[ˈhɛl.lʊ.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (20937,'helluo','n','helluon',NULL,NULL,'[ˈhɛl.lʊ.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (20949,'hemicrania','n','hemicrani',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (20950,'hemicyclium','n','hemicycli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20956,'hemisphaerium','n','hemisphaeri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (20971,'herba','n','herb',NULL,NULL,'[ˈhɛr.ba]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (20976,'herbidus','a','herbid herbid herbid',NULL,NULL,'[ˈhɛr.bɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (20980,'herbosus','a','herbos herbos herbos',NULL,NULL,'/herˈboː.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (20986,'Hercules','n','Hercul',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (20988,'heredito','v','heredit hereditav hereditat',NULL,NULL,'[heːˈreː.dɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (20990,'hereditas','n','hereditat',NULL,NULL,'[heːˈreː.dɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (20995,'heres','n','hered',NULL,NULL,'/ˈheː.reːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21001,'hermaphroditus','n','hermaphrodit',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (21009,'herous','a','hero hero hero',NULL,NULL,'[heːˈroː.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21010,'Herodes','n','Herod',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (21012,'herodio','n','herodion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (21013,'heroicus','a','heroic heroic heroic',NULL,NULL,'[heːˈroː.ɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21017,'heroine','n','heroin',NULL,NULL,NULL,'n-s---fn1g');
INSERT INTO latin_morpho VALUES (21018,'herois','n','heroid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21019,'heros','n','hero',NULL,NULL,'/ˈheː.roːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21025,'hetaeria','n','hetaeri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21037,'hexagonum','n','hexagon',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (21047,'hio','v','hi hiav hiat',NULL,NULL,'/ˈhi.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (21050,'hiatus','n','hiat',NULL,NULL,'[hɪˈaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (21053,'hibernus','a','hibern hibern hibern',NULL,NULL,'[hiːˈbɛr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21056,'hibernalis','a','hibernal hibernal hibernal',NULL,NULL,'[hiː.bɛrˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21062,'hic','r',NULL,NULL,NULL,'[hɪk]','rp--------');
INSERT INTO latin_morpho VALUES (21063,'hiemo','v','hiem hiemav hiemat',NULL,NULL,'/ˈhi.e.moː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (21064,'hiemalis','a','hiemal hiemal hiemal',NULL,NULL,'[hi.ɛˈmaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21066,'hiemps','n','hiem',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21079,'Hierosolyma','n','Hierosolym',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21083,'Hierusalem','n','Hierusalem',NULL,NULL,NULL,'n-s---nn--');
INSERT INTO latin_morpho VALUES (21085,'hilarus','a','hilar hilar hilar',NULL,NULL,'[ˈhɪ.ɫa.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21087,'hilaro','v','hilar hilarav hilarat',NULL,NULL,'[ˈhɪ.ɫa.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21092,'hilaritas','n','hilaritat',NULL,NULL,'[hɪˈɫa.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21098,'hinnio','v','hinn hinni -',NULL,NULL,'[ˈhɪn.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (21100,'hinnulus','n','hinnul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (21106,'hippocentaurus','n','hippocentaur',NULL,NULL,'[hɪp.pɔ.kɛnˈtau̯.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21113,'hircus','n','hirc',NULL,NULL,'[ˈhɪr.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21115,'hirnea','n','hirne',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21120,'hirsutus','a','hirsut hirsut hirsut',NULL,NULL,'[hiːrˈsuː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21121,'hirtus','a','hirt hirt hirt',NULL,NULL,'[ˈhiːr.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21122,'hirudo','n','hirudin',NULL,NULL,'[hɪˈruː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21124,'hirundo','n','hirundin',NULL,NULL,'[hɪˈrʊn.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21125,'hisco','v','hisc - -',NULL,NULL,'/ˈhiːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (21130,'Hispania','n','Hispani',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21131,'hispidus','a','hispid hispid hispid',NULL,NULL,'[ˈhɪs.pɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21134,'historia','n','histori',NULL,NULL,'[hɪsˈtɔ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (21135,'historialis','a','historial historial historial',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (21137,'historicus','a','historic historic historic',NULL,NULL,'[hɪsˈtɔ.rɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21141,'histrio','n','histrion',NULL,NULL,'[ˈhɪs.tri.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21143,'hiulcus','a','hiulc hiulc hiulc',NULL,NULL,'[hɪˈʊɫ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21146,'hodie','r',NULL,NULL,NULL,'[ˈhɔ.di.eː]','rp--------');
INSERT INTO latin_morpho VALUES (21155,'holocaustum','n','holocaust',NULL,NULL,'[hɔ.ɫɔˈkau̯s.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21156,'holocaustoma','n','holocaustomat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (21157,'holocaustosis','n','holocaustos',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (21165,'homicida','n','homicid',NULL,NULL,'[hɔ.mɪˈkiː.da]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (21166,'homicidium','n','homicidi',NULL,NULL,'[hɔ.mɪˈkiː.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21171,'homo','n','homin',NULL,NULL,'[ˈhɔ.moː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21186,'honesto','v','honest honestav honestat',NULL,NULL,'[hɔˈnɛs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21189,'honestas','n','honestat',NULL,NULL,'[hɔˈnɛs.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21190,'honeste','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (21191,'honor','n','honor',NULL,NULL,'[ˈhɔ.nɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21193,'honoro','v','honor honorav honorat',NULL,NULL,'[hɔˈnoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21200,'honorifico','v','honorific honorificav honorificat',NULL,NULL,'[hɔ.noːˈrɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21207,'hora','n','hor',NULL,NULL,'/ˈhoː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (21221,'horizon','n','horizont',NULL,NULL,'[ˈhɔ.rɪ.zoːn]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (21228,'horologium','n','horologi',NULL,NULL,'[hoː.rɔˈɫɔ.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21232,'horreo','v','horr horru -',NULL,NULL,'[ˈhɔr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (21233,'horreum','n','horre',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (21235,'horresco','v','horresc horru -',NULL,NULL,'[hɔrˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21236,'horribilis','a','horribil horribil horribil',NULL,NULL,'[hɔrˈrɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21237,'horridus','a','horrid horrid horrid',NULL,NULL,'/ˈhor.ri.dus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (21239,'horrifer','a','horrifer horrifer horrifer',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (21240,'horrificus','a','horrific horrific horrific',NULL,NULL,'[hɔrˈrɪ.fɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21244,'horror','n','horror',NULL,NULL,'[ˈhɔr.rɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21245,'hortus','n','hort',NULL,NULL,'[ˈhɔr.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21246,'hortor','v','hort hortat -',NULL,NULL,'[ˈhɔr.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (21248,'hortamen','n','hortamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (21249,'hortamentum','n','hortament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (21251,'hortatio','n','hortation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21254,'hortatorius','a','hortatori hortatori hortatori',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21264,'hospes','n','hospit',NULL,NULL,'[ˈhɔs.pɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21269,'hospitor','v','hospit hospitat -',NULL,NULL,'[ˈhɔs.pɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (21272,'hospitalitas','n','hospitalitat',NULL,NULL,'[hɔs.pɪˈtaː.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21274,'hospitium','n','hospiti',NULL,NULL,'[hɔsˈpɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21280,'hostilitas','n','hostilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21282,'hostimentum','n','hostiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (21283,'hostis','n','host',NULL,NULL,'[ˈhɔs.tɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (21286,'huc','r',NULL,NULL,NULL,'/huːk/','rp--------');
INSERT INTO latin_morpho VALUES (21290,'humus','n','hum',NULL,NULL,'[ˈhʊ.mʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (21291,'humo','v','hum humav humat',NULL,NULL,'[ˈhʊ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21294,'humanus','a','human human human',NULL,NULL,'[huːˈmaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21299,'humanitas','n','humanitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21300,'humaniter','r',NULL,NULL,NULL,'[huːˈmaː.nɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (21313,'humilis','a','humil humil humil',NULL,NULL,'[ˈhʊ.mɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21314,'humilio','v','humili humiliav humiliat',NULL,NULL,'[hʊˈmɪ.li.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21315,'humiliatio','n','humiliation',NULL,NULL,'[hʊ.mɪ.lɪˈaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21316,'humilitas','n','humilitat',NULL,NULL,'[hʊˈmɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21325,'hyaena','n','hyaen',NULL,NULL,'[hʏˈae̯.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (21329,'hybrida','n','hybrid',NULL,NULL,'[ˈhʏ.brɪ.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (21334,'hydra','n','hydr',NULL,NULL,'[ˈhʏ.dra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (21335,'hydrus','n','hydr',NULL,NULL,'[ˈhʏ.drʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21336,'hydrargyrus','n','hydrargyr',NULL,NULL,'[hʏˈdrar.ɡʏ.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21358,'Hymen','n','Hymen',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (21359,'Hymenaeus','n','Hymenae',NULL,NULL,'[hʏ.mɛˈnae̯.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21362,'hymnus','n','hymn',NULL,NULL,'[ˈhʏm.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21377,'hyperbole','n','hyperbol',NULL,NULL,'[hʏˈpɛr.bɔ.ɫɛ]','n-s---fn1g');
INSERT INTO latin_morpho VALUES (21381,'hyperbolicus','a','hyperbolic hyperbolic hyperbolic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21395,'hypocrisis','n','hypocris',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (21397,'hypocrites','n','hypocrit',NULL,NULL,NULL,'n-s---mn1g');
INSERT INTO latin_morpho VALUES (21398,'hypodiaconus','n','hypodiacon',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (21406,'hypomnema','n','hypomnemat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (21411,'hypotenusa','n','hypotenus',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21428,'imus','a','im im im',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21433,'iambus','n','iamb',NULL,NULL,'[ɪˈam.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (21434,'iambeus','a','iambe iambe iambe',NULL,NULL,'[i.amˈbeː.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21436,'iambicus','a','iambic iambic iambic',NULL,NULL,'[ɪˈam.bɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21438,'ibi','r',NULL,NULL,NULL,'[ˈɪ.biː]','rp--------');
INSERT INTO latin_morpho VALUES (21440,'ibis','n','ibid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21445,'ico','v','ic ic ict',NULL,NULL,'/ˈiː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (21578,'illotus','a','illot illot illot',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21582,'illudo','v','illud illus illus',NULL,'v1spia--3-=inludo v--pna--3-=inludere v1sria--3-=inlusi v-srppmn3-=illusus v-srppfn3-=illusa v-srppnn3-=illusum','[ɪlˈluː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21583,'illumino','v','illumin illuminav illuminat',NULL,NULL,'[ɪlˈluː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21585,'illuminatio','n','illumination',NULL,NULL,'[ɪl.luː.mɪˈnaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21588,'illusio','n','illusion',NULL,NULL,'[ɪlˈluː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21591,'illustro','v','illustr illustrav illustrat',NULL,NULL,'[ɪlˈluːs.troː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21592,'illustris','a','illustr illustr illustr',NULL,NULL,'[ɪlˈluːs.trɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21596,'illuvies','n','illuvi',NULL,'n-s---fn5-=inluvies',NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (21601,'imaginatio','n','imagination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21603,'imago','n','imagin',NULL,NULL,'[ɪˈmaː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21604,'imaguncula','n','imaguncul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21605,'imbecillus','a','imbecill imbecill imbecill',NULL,NULL,'[ɪm.beːˈkɪl.lʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21607,'imbecillitas','n','imbecillitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21609,'imber','n','imbr',NULL,NULL,'[ˈɪm.bɛr]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (21612,'imbibo','v','imbib imbib -',NULL,NULL,'[ˈɪm.bɪ.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21615,'imbuo','v','imbu imbu imbut',NULL,NULL,'[ˈɪm.bʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21616,'imitor','v','imit imitat -',NULL,NULL,'[ˈɪ.mɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (21618,'imitamen','n','imitamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (21619,'imitamentum','n','imitament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (21620,'imitatio','n','imitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21623,'immaculatus','a','immaculat immaculat immaculat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21626,'immanitas','n','immanitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21629,'immaturus','a','immatur immatur immatur',NULL,NULL,'[ɪm.maːˈtuː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21631,'immedicabilis','a','immedicabil immedicabil immedicabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (21632,'immemor','a','immemor immemor immemor',NULL,NULL,'[ˈɪm.mɛ.mɔr]','aps---an3-');
INSERT INTO latin_morpho VALUES (21637,'immensus','a','immens immens immens',NULL,'aps---mn1-=inmensus aps---fn1-=inmensa aps---nn1-=inmensum','[ɪmˈmẽː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21641,'immergo','v','immerg immers immers',NULL,NULL,'[ɪmˈmɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21648,'immineo','v','immin - -',NULL,NULL,'[ɪmˈmɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (21649,'imminuo','v','imminu imminu imminut',NULL,'v1spia--3-=inminuo v--pna--3-=inminuere v1sria--3-=inminui v-srppmn3-=inminutus v-srppfn3-=inminuta v-srppnn3-=inminutum','[ɪmˈmɪ.nʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21650,'immisceo','v','immisc immiscu immixt',NULL,NULL,'[ɪmˈmɪs.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (21655,'immissio','n','immission',NULL,NULL,'[ɪmˈmɪs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21658,'immitis','a','immit immit immit',NULL,NULL,'[ɪmˈmiː.tɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21659,'immitto','v','immitt immis immiss',NULL,NULL,'[ɪmˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21661,'immo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (21662,'immobilis','a','immobil immobil immobil',NULL,NULL,'[ɪmˈmoː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21663,'immobilitas','n','immobilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21665,'immoderatus','a','immoderat immoderat immoderat',NULL,'aps---mn1-=inmoderatus aps---fn1-=inmoderata aps---nn1-=inmoderatum','[ɪm.mɔ.dɛˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21666,'immoderatio','n','immoderation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21672,'immolo','v','immol immolav immolat',NULL,NULL,'[ˈɪm.mɔ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21679,'immortalis','a','immortal immortal immortal',NULL,NULL,'[ɪm.mɔrˈtaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21681,'immortalitas','n','immortalitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21683,'immugio','v','immug immugi -',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (21686,'immundus','a','immund immund immund',NULL,NULL,'[ɪmˈmʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21687,'immunditia','n','immunditi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21691,'immunitas','n','immunitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21692,'immurmuro','v','immurmur immurmurav immurmurat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (21703,'impar','a','impar impar impar',NULL,NULL,'[ˈɪm.paːr]','aps---an3i');
INSERT INTO latin_morpho VALUES (21712,'impatiens','a','impatient impatient impatient',NULL,NULL,'[ɪmˈpa.ti.ẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (21714,'impavidus','a','impavid impavid impavid',NULL,NULL,'[ɪmˈpa.wɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21715,'impedio','v','imped impediv impedit',NULL,NULL,'[ɪmˈpɛ.di.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (21716,'impedimentum','n','impediment',NULL,NULL,'[ɪm.pɛ.diːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21717,'impeditus','a','impedit impedit impedit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21718,'impello','v','impell impul impuls',NULL,NULL,'[ɪmˈpɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21719,'impendo','v','impend impend impens',NULL,NULL,'[ɪmˈpɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21720,'impendeo','v','impend - -',NULL,NULL,'[ɪmˈpɛn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (21721,'impendium','n','impendi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (21722,'impenetrabilis','a','impenetrabil impenetrabil impenetrabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (21723,'impensa','n','impens',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21725,'impense','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (21726,'impero','v','imper imperav imperat',NULL,NULL,'[ˈɪm.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21727,'imperatum','n','imperat',NULL,NULL,'[ɪm.pɛˈraː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21728,'imperator','n','imperator',NULL,NULL,'[ɪm.pɛˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21736,'imperfectio','n','imperfection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21738,'imperium','n','imperi',NULL,NULL,'[ɪmˈpɛ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21743,'imperiosus','a','imperios imperios imperios',NULL,NULL,'[ɪm.pɛ.rɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21744,'imperitus','a','imperit imperit imperit',NULL,NULL,'[ɪm.pɛˈriː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21745,'imperito','v','imperit imperitav imperitat',NULL,NULL,'[ɪmˈpɛ.rɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21746,'imperitia','n','imperiti',NULL,'n-s---fn1-=inperitia',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21752,'impertio','v','impert impertiv impertit',NULL,'v1spia--4-=inpertio v--pna--4-=inpertire v1sria--4-=inpertivi v-srppmn1-=inpertitus v-srppfn1-=inpertita v-srppnn1-=inpertitum v1spia--4-=impartio v--pna--4-=impartire v1sria--4-=impartivi v-srppmn4-=impartitus','[ɪmˈpɛr.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (21754,'imperturbatus','a','imperturbat imperturbat imperturbat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21755,'impervius','a','impervi impervi impervi',NULL,NULL,'[ɪmˈpɛr.wi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21756,'impetus','n','impet',NULL,NULL,'[ˈɪm.pɛ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (21757,'impeto','v','impet - impetit',NULL,NULL,'[ˈɪm.pɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21760,'impetigo','n','impetigin',NULL,NULL,'[ɪm.pɛˈtiː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21762,'impetro','v','impetr impetrav impetrat',NULL,NULL,'[ˈɪm.pɛ.troː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21766,'impius','a','impi impi impi',NULL,NULL,'[ˈɪm.pi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21773,'impinguo','v','impingu - impinguat',NULL,'v1spia--1-=inpinguo v--pna--1-=inpinguare v1sria--1-=inpinguavi v-srppmn1-=inpinguatus','[ɪmˈpɪŋ.ɡʷoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21775,'impleo','v','impl implev implet',NULL,NULL,'[ˈɪm.pɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (21780,'implano','v','implan implanav implanat',NULL,NULL,'[ɪmˈpɫaː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21783,'implico','v','implic implicav implicit',NULL,NULL,'[ˈɪm.plɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21786,'implicatus','a','implicat implicat implicat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21790,'imploro','v','implor implorav implorat',NULL,NULL,'[ɪmˈpɫoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21798,'impono','v','impon imposu imposit',NULL,NULL,'[ɪmˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21799,'importo','v','import importav importat',NULL,NULL,'[ɪmˈpɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21800,'importunus','a','importun importun importun',NULL,NULL,'[ɪm.pɔrˈtuː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21804,'impositio','n','imposition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21805,'impossibilis','a','impossibil impossibil impossibil',NULL,'aps---cn3-=inpossibilis aps---nn3-=inpossibile','[ɪm.pɔsˈsɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21807,'impostor','n','impostor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (21810,'impotentia','n','impotenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21814,'imprecor','v','imprec imprecat -',NULL,NULL,'[ˈɪm.prɛ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (21815,'imprecatio','n','imprecation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21816,'impressio','n','impression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21821,'imprimo','v','imprim impress impress',NULL,NULL,'[ˈɪm.prɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21823,'imprimis','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (21826,'improbus','a','improb improb improb',NULL,NULL,'[ˈɪm.prɔ.bʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21827,'improbo','v','improb improbav improbat',NULL,NULL,'[ˈɪm.prɔ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21844,'improsper','a','improsper improsper improsper',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (21845,'improspere','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (21847,'improvidus','a','improvid improvid improvid',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21849,'improvisus','a','improvis improvis improvis',NULL,NULL,'[ɪm.proːˈwiː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21853,'imprudentia','n','imprudenti',NULL,'n-s---fn1-=inprudentia',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21855,'impubes','a','impuber impuber impuber',NULL,NULL,'[ɪmˈpuː.bɛs]','aps---an3-');
INSERT INTO latin_morpho VALUES (21857,'impudenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (21858,'impudentia','n','impudenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (21861,'impugno','v','impugn impugnav impugnat',NULL,NULL,'[ɪmˈpʊŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21862,'impulsus','n','impuls',NULL,NULL,'[ɪmˈpʊɫ.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (21865,'impulsor','n','impulsor',NULL,NULL,'[ɪmˈpʊɫ.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (21868,'impunitus','a','impunit impunit impunit',NULL,NULL,'[ɪm.puːˈniː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21869,'impunitas','n','impunitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21871,'impurus','a','impur impur impur',NULL,NULL,'[ɪmˈpuː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21873,'impure','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (21874,'impuritas','n','impuritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21876,'imputo','v','imput imputav imputat',NULL,NULL,'[ˈɪm.pʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21882,'inaccessus','a','inaccess inaccess inaccess',NULL,NULL,'[ɪ.nakˈkɛs.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21887,'inaedifico','v','inaedific inaedificav inaedificat',NULL,NULL,'[ɪ.nae̯ˈdɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21889,'inaequabilis','a','inaequabil inaequabil inaequabil',NULL,NULL,'[ɪ.nae̯ˈkʷaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21892,'inaequalis','a','inaequal inaequal inaequal',NULL,NULL,'[ɪ.nae̯ˈkʷaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21893,'inaequalitas','n','inaequalitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21895,'inaestimabilis','a','inaestimabil inaestimabil inaestimabil',NULL,NULL,'[ɪ.nae̯s.tɪˈmaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21904,'inanis','a','inan inan inan',NULL,NULL,'[ɪˈnaː.nɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (21910,'inanimus','a','inanim inanim inanim',NULL,NULL,'[ɪˈna.nɪ.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21915,'inanimans','a','inanimant inanimant inanimant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (21916,'inanimatus','a','inanimat inanimat inanimat',NULL,NULL,'[ɪ.na.nɪˈmaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21922,'inardesco','v','inardesc inars -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (21930,'inauditus','a','inaudit inaudit inaudit',NULL,NULL,'[ɪ.nau̯ˈdiː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21933,'inauro','v','inaur inaurav inaurat',NULL,NULL,'[ɪˈnau̯.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21966,'incendo','v','incend incend incens',NULL,NULL,'[ɪŋˈkɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21967,'incendium','n','incendi',NULL,NULL,'[ɪŋˈkɛn.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21968,'incendiarius','a','incendiari incendiari incendiari',NULL,NULL,'[ɪŋ.kɛn.dɪˈaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21969,'incensum','n','incens',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (21970,'incensus','a','incens incens incens',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (21972,'incentio','n','incention',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (21974,'incentor','n','incentor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (21975,'inceptum','n','incept',NULL,NULL,'[ɪŋˈkɛp.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (21976,'incepto','v','incept inceptav inceptat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (21977,'inceptio','n','inception',NULL,NULL,'[ɪŋˈkɛp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (21980,'incertus','a','incert incert incert',NULL,NULL,'[ɪŋˈkɛr.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (21983,'incesso','v','incess incessiv -',NULL,NULL,'[ɪŋˈkɛs.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (21987,'incesto','v','incest incestav incestat',NULL,NULL,'[ɪŋˈkɛs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (21992,'incido','v','incid incid -',NULL,NULL,'[ˈɪŋ.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22002,'incilo','v','incil incilav incilat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (22006,'incingo','v','incing incinx incinct',NULL,NULL,'[ɪŋˈkɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22007,'incipio','v','incip incep incept',NULL,NULL,'[ɪŋˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (22008,'incipisso','v','incipiss - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22019,'incito','v','incit incitav incitat',NULL,NULL,'[ˈɪŋ.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22020,'incitamentum','n','incitament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (22022,'incitatio','n','incitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22026,'inclamo','v','inclam inclamav inclamat',NULL,NULL,'[ɪŋˈkɫaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22029,'inclementer','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22030,'inclementia','n','inclementi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22032,'inclino','v','inclin inclinav inclinat',NULL,NULL,'[ɪŋˈkliː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22033,'inclinatio','n','inclination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22035,'includo','v','includ inclus inclus',NULL,NULL,'[ɪŋˈkɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22036,'inclutus','a','inclut inclut inclut',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22039,'incogitans','a','incogitant incogitant incogitant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (22040,'incogitantia','n','incogitanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22042,'incognitus','a','incognit incognit incognit',NULL,NULL,'[ɪŋˈkɔŋ.nɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22043,'incoho','v','incoh incohav incohat',NULL,NULL,'[ˈɪŋ.kɔ.hoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22045,'incola','n','incol',NULL,NULL,'[ˈɪŋ.kɔ.ɫa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (22046,'incolo','v','incol incolav incola',NULL,NULL,'[ˈɪŋ.kɔ.ɫoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22052,'incolumitas','n','incolumitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22056,'incommodum','n','incommod',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (22057,'incommodo','v','incommod incommodav incommodat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (22060,'incommoditas','n','incommoditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22061,'incommutabilis','a','incommutabil incommutabil incommutabil',NULL,NULL,'[ɪŋ.kɔm.muːˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22064,'incomparabilis','a','incomparabil incomparabil incomparabil',NULL,NULL,'[ɪŋ.kɔm.paˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22065,'incomparabiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22105,'inconstanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22107,'inconsultus','a','inconsult inconsult inconsult',NULL,NULL,'[ɪŋ.kõːˈsʊɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22108,'inconsulte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22114,'inconveniens','a','inconvenient inconvenient inconvenient',NULL,NULL,'[ɪŋ.kɔnˈwɛ.ni.ẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (22118,'incorporalis','a','incorporal incorporal incorporal',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22119,'incorporeus','a','incorpore incorpore incorpore',NULL,NULL,'[ɪŋ.kɔrˈpɔ.re.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22121,'incorrigibilis','a','incorrigibil incorrigibil incorrigibil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22123,'incorruptus','a','incorrupt incorrupt incorrupt',NULL,NULL,'[ɪŋ.kɔrˈrʊp.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22124,'incorrupte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22125,'incorruptela','n','incorruptel',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22127,'incorruptibilitas','n','incorruptibilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22129,'incorruptio','n','incorruption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22132,'incrasso','v','incrass incrassav incrassat',NULL,NULL,'[ɪŋˈkras.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22134,'increbresco','v','increbresc increbu -',NULL,NULL,'[ɪŋ.krɛˈbreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22135,'incredibilis','a','incredibil incredibil incredibil',NULL,NULL,'[ɪŋ.kreːˈdɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22136,'incredulus','a','incredul incredul incredul',NULL,NULL,'[ɪŋˈkreː.dʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22137,'incredulitas','n','incredulitat',NULL,NULL,'[ɪŋ.kreːˈdʊ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22138,'incrementum','n','increment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (22141,'increpo','v','increp increpa increpit',NULL,NULL,'[ˈɪŋ.krɛ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22144,'increpatio','n','increpation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22145,'increpito','v','increpit increpitav increpitat',NULL,NULL,'[ɪŋˈkrɛ.pɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22146,'incresco','v','incresc increv -',NULL,NULL,'[ɪŋˈkreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22157,'incultus','n','incult',NULL,NULL,'[ɪŋˈkʊɫ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (22158,'incultus','a','incult incult incult',NULL,NULL,'[ɪŋˈkʊɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22172,'incuria','n','incuri',NULL,NULL,'[ɪŋˈkuː.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22173,'incuriosus','a','incurios incurios incurios',NULL,NULL,'[ɪŋ.kuː.rɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22174,'incuriose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22175,'incurro','v','incurr incurr incurs',NULL,NULL,'[ɪŋˈkʊr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22177,'incursus','n','incurs',NULL,NULL,'[ɪŋˈkʊr.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (22178,'incurso','v','incurs incursav incursat',NULL,NULL,'[ɪŋˈkʊr.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22179,'incursio','n','incursion',NULL,NULL,'[ɪŋˈkʊr.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22181,'incurvus','a','incurv incurv incurv',NULL,NULL,'[ɪŋˈkʊr.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22185,'incus','n','incud',NULL,NULL,'[ˈɪŋ.kuːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22188,'incutio','v','incut incuss incuss',NULL,NULL,'[ɪŋˈkʊ.ti.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (22192,'indo','v','ind indid indit',NULL,NULL,'[ˈɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22193,'indago','v','indag indagav indagat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (22195,'indagatio','n','indagation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22203,'indecens','a','indecent indecent indecent',NULL,NULL,'[ˈɪn.dɛ.kẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (22208,'indecoris','a','indecor indecor indecor',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22209,'indecoro','v','indecor indecorav indecorat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (22236,'index','n','indic',NULL,NULL,'[ˈɪn.dɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (22237,'India','n','Indi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22239,'indico','v','indic indix indict',NULL,NULL,'[ˈɪn.dɪ.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22241,'indicativus','a','indicativ indicativ indicativ',NULL,NULL,'[ɪn.dɪ.kaːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22243,'indicium','n','indici',NULL,NULL,'[ɪnˈdɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (22245,'indictio','n','indiction',NULL,NULL,'[ɪnˈdɪk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22253,'indigeo','v','indig indigu -',NULL,NULL,'[ɪnˈdɪ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (22254,'indigena','n','indigen',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (22259,'indigestus','a','indigest indigest indigest',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22261,'indignus','a','indign indign indign',NULL,NULL,'[ɪnˈdiːŋ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22265,'indignatio','n','indignation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22267,'indignitas','n','indignitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22270,'indiligens','a','indiligent indiligent indiligent',NULL,NULL,'[ɪnˈdiː.lɪ.ɡẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (22271,'indiligentia','n','indiligenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22279,'indiscretus','a','indiscret indiscret indiscret',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22283,'indispositus','a','indisposit indisposit indisposit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22286,'indistinctus','a','indistinct indistinct indistinct',NULL,NULL,'[ɪn.dɪsˈtiːŋk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22289,'individuus','a','individu individu individu',NULL,NULL,'[ɪn.diːˈwɪ.dʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22296,'indivisibilis','a','indivisibil indivisibil indivisibil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22300,'indocilis','a','indocil indocil indocil',NULL,NULL,'[ɪnˈdɔ.kɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22301,'indoctus','a','indoct indoct indoct',NULL,NULL,'[ɪnˈdɔk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22304,'indolesco','v','indolesc indolu -',NULL,NULL,'[ɪn.dɔˈɫeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22306,'indomitus','a','indomit indomit indomit',NULL,NULL,'[ɪnˈdɔ.mɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22310,'induo','v','indu indu indut',NULL,NULL,'[ˈɪn.dʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22311,'indubius','a','indubi indubi indubi',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22315,'indubitatus','a','indubitat indubitat indubitat',NULL,NULL,'[ɪn.dʊ.bɪˈtaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22317,'induco','v','induc indux induct',NULL,NULL,'[ɪnˈduː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22318,'inductio','n','induction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22319,'indulgeo','v','indulg induls indult',NULL,NULL,'[ɪnˈdʊɫ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (22322,'indulgentia','n','indulgenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22323,'indumentum','n','indument',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (22327,'induresco','v','induresc induru -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22329,'industria','n','industri',NULL,NULL,'[ɪnˈdʊs.tri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22330,'industrius','a','industri industri industri',NULL,NULL,'[ɪnˈdʊs.tri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22340,'ineo','v','in iniv init','v2spia--4-=inis v3spia--4-=init v1ppia--4-=inimus v2ppia--4-=initis v3ppia--4-=ineunt v1siia--4-=inibam v2siia--4-=inibas v3siia--4-=inibat v1piia--4-=inibamus v2piia--4-=inibatis v3piia--4-=inibant v1sfia--4-=inibo v2sfia--4-=inibis v3sfia--4-=inibit v1pfia--4-=inibimus v2pfia--4-=inibitis v3pfia--4-=inibunt v-sppamn4-=iniens v-sppafn4-=iniens v-sppann4-=iniens v-sfpamn4-=initurus v-sfpafn4-=initura v-sfpann4-=initurum v-sfppmn4-=ineundus v-sfppfn4-=ineunda v-sfppnn4-=ineundum v-s-gang4-=ineundi v-s-damn4-=ineundus v-s-dafn4-=ineunda v-s-dann4-=ineundum',NULL,'[ˈɪ.ne.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (22342,'inedia','n','inedi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22347,'inefficax','a','inefficac inefficac inefficac',NULL,NULL,'[ɪˈnɛf.fɪ.kaːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (22351,'inemendabilis','a','inemendabil inemendabil inemendabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22362,'inerrans','a','inerrant inerrant inerrant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (22363,'iners','a','inert inert inert',NULL,NULL,'[ˈɪ.nɛrs]','aps---an3-');
INSERT INTO latin_morpho VALUES (22364,'inertia','n','inerti',NULL,NULL,'[ɪˈnɛr.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22365,'ineruditus','a','inerudit inerudit inerudit',NULL,NULL,'[ɪ.neː.rʊˈdiː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22367,'ineruditio','n','inerudition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22378,'inexpertus','a','inexpert inexpert inexpert',NULL,NULL,'[ɪ.nɛkˈspɛr.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22379,'inexpiabilis','a','inexpiabil inexpiabil inexpiabil',NULL,NULL,'[ɪ.nɛk.spɪˈaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22380,'inexplebilis','a','inexplebil inexplebil inexplebil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22381,'inexpletus','a','inexplet inexplet inexplet',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22382,'inexplicabilis','a','inexplicabil inexplicabil inexplicabil',NULL,NULL,'[ɪ.nɛk.splɪˈkaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22387,'inexstinguibilis','a','inexstinguibil inexstinguibil inexstinguibil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22388,'inexsuperabilis','a','inexsuperabil inexsuperabil inexsuperabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22405,'infamo','v','infam infamav infamat',NULL,NULL,'[ĩːˈfaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22406,'infamia','n','infami',NULL,NULL,'[ĩːˈfaː.mi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22408,'infans','n','infant',NULL,NULL,'[ˈĩː.fãːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (22412,'infantia','n','infanti',NULL,NULL,'[ĩːˈfan.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22413,'infantilis','a','infantil infantil infantil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22414,'infantiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22419,'infatigabiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22421,'infaustus','a','infaust infaust infaust',NULL,NULL,'[ĩːˈfau̯s.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22423,'infecundus','a','infecund infecund infecund',NULL,NULL,'[ĩː.feːˈkʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22424,'infecunditas','n','infecunditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22427,'infelicitas','n','infelicitat',NULL,NULL,'[ĩː.feːˈliː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22428,'infeliciter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22429,'infelix','a','infelic infelic infelic',NULL,NULL,'[ĩːˈfeː.liːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (22434,'infero','v','infer intul inlat','v--pna--3-=inferre v2spia--3-=infers v3spia--3-=infert v2ppia--3-=infertis',NULL,'[ˈĩː.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22442,'inferne','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22445,'infesto','v','infest infestav infestat',NULL,NULL,'[ĩːˈfɛs.tʊs]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22446,'infestus','a','infest infest infest',NULL,NULL,'[ĩːˈfɛs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22447,'infeste','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22451,'inficio','v','infic infec infect',NULL,NULL,'[ĩːˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (22455,'infidelitas','n','infidelitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22457,'infigo','v','infig infix infix',NULL,NULL,'[ĩːˈfiː.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22459,'infindo','v','infind infid infiss',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22460,'infinitus','a','infinit infinit infinit',NULL,NULL,'[ĩː.fiːˈniː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22468,'infirmo','v','infirm infirmav infirmat',NULL,NULL,'[ĩːˈfɪr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22469,'infirmus','a','infirm infirm infirm',NULL,NULL,'[ĩːˈfɪr.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22470,'infirme','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22471,'infirmitas','n','infirmitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22472,'infirmiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22474,'infitior','v','infiti infitiat -',NULL,NULL,'[ĩːˈfɪ.ti.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (22478,'inflammo','v','inflamm inflammav inflammat',NULL,NULL,'[ĩːˈfɫam.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22481,'inflammatio','n','inflammation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22482,'inflatus','a','inflat inflat inflat',NULL,NULL,'[ĩːˈfɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22483,'inflatio','n','inflation',NULL,NULL,'[ĩːˈfɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22485,'inflecto','v','inflect inflex inflex',NULL,NULL,'[ĩːˈfɫɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22489,'infligo','v','inflig inflix inflict',NULL,NULL,'[ĩːˈfliː.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22492,'infodio','v','infod infod infoss',NULL,NULL,'[ĩːˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (22494,'informo','v','inform informav informat',NULL,NULL,'[ĩːˈfoːr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22498,'infortunatus','a','infortunat infortunat infortunat',NULL,NULL,'[ĩː.fɔr.tuːˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22499,'infortunium','n','infortuni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (22500,'infra','r',NULL,NULL,NULL,'[ˈĩː.fraː]','rp--------');
INSERT INTO latin_morpho VALUES (22506,'infrenis','a','infren infren infren',NULL,NULL,'[ĩːˈfreː.nɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22507,'infreno','v','infren infrenav infrenat',NULL,NULL,'[ĩːˈfreː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22515,'infrigido','v','infrigid infrigidav infrigidat',NULL,NULL,'[ĩːˈfriː.ɡɪ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22516,'infringo','v','infring infreg infract',NULL,NULL,'[ĩːˈfrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22518,'infructuosus','a','infructuos infructuos infructuos',NULL,NULL,'[ĩː.frʊk.tʊˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22523,'infula','n','inful',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22527,'infundo','v','infund infud infus',NULL,NULL,'[ĩːˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22529,'infundibulum','n','infundibul',NULL,NULL,'[ĩː.fʊnˈdɪ.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (22530,'infusco','v','infusc infuscav infuscat',NULL,NULL,'[ĩːˈfʊs.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22532,'ingemo','v','ingem ingemu ingemit',NULL,NULL,'[ˈɪŋ.ɡɛ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22533,'ingemesco','v','ingemesc ingemu ingemit',NULL,NULL,'[ɪŋ.ɡɛˈmeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22539,'ingenium','n','ingeni',NULL,NULL,'[ɪŋˈɡɛ.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (22543,'ingeniculo','v','ingenicul ingeniculav ingeniculat',NULL,NULL,'[ɪŋ.ɡɛˈnɪ.kʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22545,'ingeniose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22547,'ingenuus','a','ingenu ingenu ingenu',NULL,NULL,'[ɪŋˈɡɛ.nʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22548,'ingenuitas','n','ingenuitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22553,'ingluvies','n','ingluvi',NULL,NULL,'[ɪŋˈɡɫʊ.wi.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (22554,'ingratus','a','ingrat ingrat ingrat',NULL,NULL,'[ɪŋˈɡraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22555,'ingrate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22558,'ingravo','v','ingrav ingravav ingravat',NULL,NULL,'[ˈɪŋ.ɡra.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22560,'ingredior','v','ingred ingress -',NULL,NULL,'[ɪŋˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (22562,'ingressus','n','ingress',NULL,NULL,'[ɪŋˈɡrɛs.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (22564,'inguen','n','inguin',NULL,NULL,'[ˈɪŋ.ɡᶣẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (22569,'inhabito','v','inhabit inhabitav inhabitat',NULL,NULL,'[ɪnˈha.bɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22577,'inhibeo','v','inhib inhibu inhibit',NULL,NULL,'[ɪnˈhɪ.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (22578,'inhonesto','v','inhonest inhonestav inhonestat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (22581,'inhoneste','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22590,'inhorresco','v','inhorresc inhorru -',NULL,NULL,'[ɪn.hɔrˈreːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22594,'inhumanus','a','inhuman inhuman inhuman',NULL,NULL,'[ɪn.huːˈmaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22596,'inhumanatio','n','inhumanation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22599,'inhumatus','a','inhumat inhumat inhumat',NULL,NULL,'[ɪn.hʊˈmaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22601,'inicio','v','inic iniec iniect',NULL,NULL,'[ɪnˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (22606,'inimicus','a','inimic inimic inimic',NULL,NULL,'[ɪ.nɪˈmiː.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22607,'inimicitia','n','inimiciti',NULL,NULL,'[ɪ.nɪ.miːˈkɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22610,'iniquus','a','iniqu iniqu iniqu',NULL,NULL,'[ɪˈniː.kʷʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22611,'iniquitas','n','iniquitat',NULL,NULL,'[ɪˈniː.kᶣɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (22612,'initus','n','init',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (22613,'initium','n','initi',NULL,NULL,'[ɪˈnɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (22614,'initio','v','initi initiav initiat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (22707,'inno','v','inn innav innat',NULL,NULL,'[ˈɪn.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22711,'innatus','a','innat innat innat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22715,'innecto','v','innect innexu innex',NULL,NULL,'[ɪnˈnɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22719,'innocens','a','innocent innocent innocent',NULL,NULL,'[ˈɪn.nɔ.kẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (22720,'innocentia','n','innocenti',NULL,NULL,'[ɪn.nɔˈkɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22721,'innocuus','a','innocu innocu innocu',NULL,NULL,'[ɪnˈnɔ.kʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22725,'innovatio','n','innovation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22726,'innoxius','a','innoxi innoxi innoxi',NULL,NULL,'[ɪnˈnɔk.si.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22729,'innubo','v','innub innups innupt',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22739,'inobaudientia','n','inobaudienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22750,'inoboedus','a','inoboed inoboed inoboed',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22756,'inoboedientia','n','inoboedienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22763,'inoffensus','a','inoffens inoffens inoffens',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22767,'inominatus','a','inominat inominat inominat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22768,'inopia','n','inopi',NULL,NULL,'[ɪˈnɔ.pi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22769,'inopinus','a','inopin inopin inopin',NULL,NULL,'[ɪ.nɔˈpiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22773,'inopinatus','a','inopinat inopinat inopinat',NULL,NULL,'[ɪ.nɔ.piːˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22775,'inops','a','inop inop inop',NULL,NULL,'[ˈɪ.nɔps]','aps---an3-');
INSERT INTO latin_morpho VALUES (22778,'inordinatus','a','inordinat inordinat inordinat',NULL,NULL,'[ɪ.nɔr.dɪˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22780,'inornatus','a','inornat inornat inornat',NULL,NULL,'[ɪ.noːrˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22841,'inquam','v',NULL,NULL,NULL,'[ˈɪŋ.kʷã]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22842,'inquies','a','inquiet inquiet inquiet',NULL,NULL,'[ˈɪŋ.kᶣi.ɛs]','aps---an3-');
INSERT INTO latin_morpho VALUES (22843,'inquieto','v','inquiet inquietav inquietat',NULL,NULL,'[ɪŋ.kᶣɪˈeː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22844,'inquietus','a','inquiet inquiet inquiet',NULL,NULL,'[ɪŋ.kᶣɪˈeː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22845,'inquietudo','n','inquietudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22847,'inquilinus','n','inquilin',NULL,NULL,'[ɪŋ.kᶣɪˈliː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (22849,'inquino','v','inquin inquinav inquinat',NULL,NULL,'[ˈɪŋ.kᶣɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22850,'inquinamentum','n','inquinament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (22852,'inquiro','v','inquir inquisi inquisit',NULL,NULL,'[ɪŋˈkᶣiː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22854,'inquisitio','n','inquisition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22855,'inquisitor','n','inquisitor',NULL,NULL,'[ɪŋ.kᶣiːˈsiː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (22899,'insalubris','a','insalubr insalubr insalubr',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22901,'insanus','a','insan insan insan',NULL,NULL,'[ĩːˈsaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22902,'insanabilis','a','insanabil insanabil insanabil',NULL,NULL,'[ĩː.saːˈnaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22903,'insane','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22905,'insania','n','insani',NULL,NULL,'[ĩːˈsaː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (22906,'insaniter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22908,'insatiabilis','a','insatiabil insatiabil insatiabil',NULL,NULL,'[ĩː.sa.tɪˈaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22910,'inscendo','v','inscend inscend inscens',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22911,'inscius','a','insci insci insci',NULL,NULL,'[ˈĩː.ski.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22913,'inscientia','n','inscienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22914,'inscitus','a','inscit inscit inscit',NULL,NULL,'[ĩːˈskiː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22915,'inscitia','n','insciti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22916,'inscribo','v','inscrib inscrips inscript',NULL,NULL,'[ĩːˈskriː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22917,'inscriptio','n','inscription',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22919,'insculpo','v','insculp insculps insculpt',NULL,NULL,'[ĩːˈskʊɫ.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22920,'inseco','v','insec insecu insect',NULL,NULL,'[ˈĩː.sɛ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22925,'insectatio','n','insectation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22933,'inseparabiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22935,'insepultus','a','insepult insepult insepult',NULL,NULL,'[ĩː.sɛˈpʊɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (22937,'insequor','v','insequ insequut -',NULL,NULL,'[ˈĩː.sɛ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (22938,'insero','v','inser insev insit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22939,'inserto','v','insert insertav insertat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (22945,'insido','v','insid insed insess',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22946,'insideo','v','insid insed insess',NULL,NULL,'[ĩːˈsɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (22947,'insido','v','insid insed insess',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (22952,'insignis','a','insign insign insign',NULL,NULL,'[ĩːˈsɪŋ.nɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (22953,'insigne','n','insign',NULL,NULL,'[ĩːˈsɪŋ.nɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (22954,'insignio','v','insign insigni insignit',NULL,NULL,'[ĩːˈsɪŋ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (22961,'insincerus','a','insincer insincer insincer',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (22962,'insinuo','v','insinu insinuav insinuat',NULL,NULL,'[ĩːˈsɪ.nʊ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22969,'insipienter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22970,'insipientia','n','insipienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22971,'insisto','v','insist instit -',NULL,NULL,'[ĩːˈsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (22975,'insitio','n','insition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22978,'insociabilis','a','insociabil insociabil insociabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (22981,'insolens','a','insolent insolent insolent',NULL,NULL,'[ˈĩː.sɔ.ɫẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (22982,'insolenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (22983,'insolentia','n','insolenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (22989,'insomnium','n','insomni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (22990,'insono','v','inson insonu -',NULL,NULL,'[ˈĩː.sɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22991,'insons','a','insont insont insont',NULL,NULL,'[ˈĩː.sõːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (22995,'inspecto','v','inspect inspectav inspectat',NULL,NULL,'[ĩːˈspɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (22996,'inspectio','n','inspection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (22998,'insperatus','a','insperat insperat insperat',NULL,NULL,'[ĩː.speːˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23001,'inspicio','v','inspic inspex inspect',NULL,NULL,'[ĩːˈspɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (23002,'inspiro','v','inspir inspirav inspirat',NULL,NULL,'[ĩːˈspiː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23003,'inspiratio','n','inspiration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23007,'insto','v','inst instit instat',NULL,NULL,'[ˈĩː.stoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23008,'instabilis','a','instabil instabil instabil',NULL,NULL,'[ĩːˈsta.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (23011,'instantia','n','instanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23013,'instauro','v','instaur instaurav instaurat',NULL,NULL,'[ĩːˈstau̯.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23014,'instauratio','n','instauration',NULL,NULL,'[ĩː.stau̯ˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23017,'instigo','v','instig instigav instigat',NULL,NULL,'[ĩːˈstiː.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23020,'instinctus','n','instinct',NULL,NULL,'[ĩːˈstɪŋk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (23022,'instinctor','n','instinctor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (23025,'institor','n','institor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (23029,'instituo','v','institu institu institut',NULL,NULL,'[ĩːˈstɪ.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23030,'institutum','n','institut',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23033,'institutor','n','institutor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (23036,'instruo','v','instru instrux instruct',NULL,NULL,'[ˈĩː.strʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23038,'instructus','a','instruct instruct instruct',NULL,NULL,'[ĩːˈstruːk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23041,'instrumentum','n','instrument',NULL,NULL,'[ĩː.struːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (23046,'insubidus','a','insubid insubid insubid',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (23047,'insudo','v','insud insudav insudat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (23050,'insuetus','a','insuet insuet insuet',NULL,NULL,'[ĩː.sʊˈeː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23052,'insufficientia','n','insufficienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23055,'insula','n','insul',NULL,NULL,'[ˈĩː.sʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23056,'insulanus','n','insulan',NULL,NULL,'[ĩː.sʊˈɫaː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (23059,'insulsus','a','insuls insuls insuls',NULL,NULL,'[ĩːˈsʊɫ.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23060,'insulsitas','n','insulsitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23066,'insumo','v','insum insumps insumpt',NULL,NULL,'[ĩːˈsuː.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23070,'insuperabilis','a','insuperabil insuperabil insuperabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (23072,'insusurro','v','insusurr insusurrav insusurrat',NULL,NULL,'[ĩː.sʊˈsʊr.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23077,'intectus','a','intect intect intect',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (23078,'intego','v','integ intex intect',NULL,NULL,'[ˈɪn.tɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23082,'integro','v','integr integrav integrat',NULL,NULL,'[ˈɪn.tɛ.ɡroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23087,'integre','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23090,'integritas','n','integritat',NULL,NULL,'[ɪnˈtɛ.ɡrɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23091,'integumentum','n','integument',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23092,'intellectus','n','intellect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (23095,'intellectualiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23096,'intellego','v','intellig intelleg intellect',NULL,NULL,'[ɪnˈtɛl.lɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23098,'intellegens','a','intellegent intellegent intellegent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (23099,'intellegentia','n','intellegenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23103,'intemeratus','a','intemerat intemerat intemerat',NULL,NULL,'[ɪn.tɛ.mɛˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23106,'intemperantia','n','intemperanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23111,'intempestus','a','intempest intempest intempest',NULL,NULL,'[ɪn.tɛmˈpɛs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23114,'intendo','v','intend intend intent',NULL,NULL,'[ɪnˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23119,'intento','v','intent intentav intentat',NULL,NULL,'[ɪnˈtɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23120,'intentus','a','intent intent intent',NULL,NULL,'[ɪnˈtɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23121,'intente','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23122,'intentio','n','intention',NULL,NULL,'[ɪnˈtɛn.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23133,'intercalo','v','intercal intercalav intercalat',NULL,NULL,'[ɪnˈtɛr.ka.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23135,'intercapedo','n','intercapedin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23136,'intercedo','v','interced intercess intercess',NULL,NULL,'[ɪn.tɛrˈkeː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23137,'interceptor','n','interceptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (23138,'intercessio','n','intercession',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23139,'intercessor','n','intercessor',NULL,NULL,'[ɪn.tɛrˈkɛs.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (23141,'intercido','v','intercid intercid -',NULL,NULL,'[ɪnˈtɛr.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23143,'intercipio','v','intercip intercep intercept',NULL,NULL,'[ɪn.tɛrˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (23144,'intercludo','v','interclud interclus interclus',NULL,NULL,'[ɪn.tɛrˈkɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23146,'intercursus','n','intercurs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (23149,'interdico','v','interdic interdix interdict',NULL,NULL,'[ɪn.tɛrˈdiː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23150,'interdictum','n','interdict',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23155,'interdum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23156,'intereo','v','inter interiv interit','v2spia--4-=interis v3spia--4-=interit v1ppia--4-=interimus v2ppia--4-=interitis v3ppia--4-=intereunt v1siia--4-=interibam v2siia--4-=interibas v3siia--4-=interibat v1piia--4-=interibamus v2piia--4-=interibatis v3piia--4-=interibant v1sfia--4-=interibo v2sfia--4-=interibis v3sfia--4-=interibit v1pfia--4-=interibimus v2pfia--4-=interibitis v3pfia--4-=interibunt v-sppamn4-=interiens v-sppafn4-=interiens v-sppann4-=interiens v-sfpamn4-=interiturus v-sfpafn4-=interitura v-sfpann4-=interiturum v-sfppmn4-=intereundus v-sfppfn4-=intereunda v-sfppnn4-=intereundum v-s-gang4-=intereundi v-s-damn4-=intereundus v-s-dafn4-=intereunda v-s-dann4-=intereundum',NULL,'[ɪnˈtɛ.re.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (23157,'interea','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23160,'interfor','v','interf interfat -',NULL,NULL,'[ɪnˈtɛr.fɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (23162,'interfector','n','interfector',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (23164,'interficio','v','interfic interfec interfect',NULL,NULL,'[ɪn.tɛrˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (23170,'interibi','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23171,'intericio','v','interic interiec interiect',NULL,NULL,'[ɪn.tɛˈrɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (23172,'interim','r',NULL,NULL,NULL,'[ˈɪn.tɛ.rĩ]','rp--------');
INSERT INTO latin_morpho VALUES (23173,'interimo','v','interim interem interempt',NULL,NULL,'[ɪnˈtɛ.rɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23176,'interitus','n','interit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (23185,'interloquor','v','interloqu interlocut -',NULL,NULL,'[ɪnˈtɛr.ɫɔ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (23196,'interminor','v','intermin interminat -',NULL,NULL,'[ɪnˈtɛr.mɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (23200,'intermisceo','v','intermisc intermiscu intermixt',NULL,NULL,'[ɪn.tɛrˈmɪs.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (23201,'intermissio','n','intermission',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23202,'intermitto','v','intermitt intermis intermiss',NULL,NULL,'[ɪn.tɛrˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23203,'intermorior','v','intermor intermortu -',NULL,NULL,'[ɪn.tɛrˈmɔ.ri.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (23205,'internus','a','intern intern intern',NULL,NULL,'[ɪnˈtɛr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23210,'internecio','n','internecion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23218,'internuntius','n','internunti',NULL,NULL,'[ɪn.tɛrˈnuːn.ti.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (23221,'interpello','v','interpell interpellav interpellat',NULL,NULL,'[ɪn.tɛrˈpɛl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23223,'interpolo','v','interpol interpolav interpolat',NULL,NULL,'[ɪnˈtɛr.pɔ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23224,'interpono','v','interpon interposu interposit',NULL,NULL,'[ɪn.tɛrˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23225,'interpositio','n','interposition',NULL,NULL,'[ɪn.tɛr.pɔˈsɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23226,'interpres','n','interpret',NULL,NULL,'[ɪnˈtɛr.prɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (23228,'interpretor','v','interpret interpretat -',NULL,NULL,'[ɪnˈtɛr.prɛ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (23229,'interpretamentum','n','interpretament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23230,'interpretatio','n','interpretation',NULL,NULL,'[ɪn.tɛr.prɛˈtaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23232,'interpunctio','n','interpunction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23236,'interregnum','n','interregn',NULL,NULL,'[ɪn.tɛrˈreːŋ.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (23241,'interritus','a','interrit interrit interrit',NULL,NULL,'[ɪnˈtɛr.rɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23243,'interrogo','v','interrog interrogav interrogat',NULL,NULL,'[ɪnˈtɛr.rɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23244,'interrogatio','n','interrogation',NULL,NULL,'[ɪn.tɛr.rɔˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23246,'interrumpo','v','interrump interrup interrupt',NULL,NULL,'[ɪn.tɛrˈrʊm.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23247,'interruptio','n','interruption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23250,'intersaepio','v','intersaep intersaeps intersaept',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (23251,'interscindo','v','interscind interscid intersciss',NULL,NULL,'[ɪn.tɛrˈskɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23260,'interstitium','n','interstiti',NULL,NULL,'[ɪn.tɛrˈstɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (23261,'interstitio','n','interstition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23265,'intertrimentum','n','intertriment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23269,'intervallum','n','intervall',NULL,NULL,'[ɪn.tɛrˈwal.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (23272,'intervenio','v','interven interven intervent',NULL,NULL,'[ɪn.tɛrˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (23274,'interventus','n','intervent',NULL,NULL,'[ɪn.tɛrˈwɛn.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (23275,'interverto','v','intervert intervert intervers',NULL,NULL,'[ɪn.tɛrˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23276,'interviso','v','intervis intervis intervis',NULL,NULL,'[ɪn.tɛrˈwiː.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23281,'intestinus','a','intestin intestin intestin',NULL,NULL,'[ɪn.tɛsˈtiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23282,'intexo','v','intex intexu intext',NULL,NULL,'[ɪnˈtɛk.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23288,'intimo','v','intim intimav intimat',NULL,NULL,'[ˈɪn.tɪ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23289,'intime','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23291,'intinguo','v','intingu intinx intinct',NULL,NULL,'[ɪnˈtɪŋ.ɡʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23294,'intolerabilis','a','intolerabil intolerabil intolerabil',NULL,NULL,'[ɪn.tɔ.ɫɛˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (23296,'intolerans','a','intolerant intolerant intolerant',NULL,NULL,'[ɪnˈtɔ.ɫɛ.rãːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (23298,'intolerantia','n','intoleranti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23299,'intono','v','inton intonu -',NULL,NULL,'[ˈɪn.tɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23302,'intorqueo','v','intorqu intors intort',NULL,NULL,'[ɪnˈtɔr.kᶣe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (23303,'intro','v','intr intrav intrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (23306,'intractabilis','a','intractabil intractabil intractabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (23312,'intremo','v','intrem intremu -',NULL,NULL,'[ˈɪn.trɛ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23314,'intrepidus','a','intrepid intrepid intrepid',NULL,NULL,'[ɪnˈtrɛ.pɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23315,'intributio','n','intribution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23319,'intrinsecus','r',NULL,NULL,NULL,'[ɪnˈtrĩː.sɛ.kʊs]','rp--------');
INSERT INTO latin_morpho VALUES (23321,'intro','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23323,'introduco','v','introduc introdux introduct',NULL,NULL,'[ɪn.troːˈduː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23325,'introeo','v','intro introiv introit','v2spia--4-=introis v3spia--4-=introit v1ppia--4-=introimus v2ppia--4-=introitis v3ppia--4-=introeunt v1siia--4-=introibam v2siia--4-=introibas v3siia--4-=introibat v1piia--4-=introibamus v2piia--4-=introibatis v3piia--4-=introibant v1sfia--4-=introibo v2sfia--4-=introibis v3sfia--4-=introibit v1pfia--4-=introibimus v2pfia--4-=introibitis v3pfia--4-=introibunt v-sppamn4-=introiens v-sppafn4-=introiens v-sppann4-=introiens v-sfpamn4-=introiturus v-sfpafn4-=introitura v-sfpann4-=introiturum v-sfppmn4-=introeundus v-sfppfn4-=introeunda v-sfppnn4-=introeundum v-s-gang4-=introeundi v-s-damn4-=introeundus v-s-dafn4-=introeunda v-s-dann4-=introeundum',NULL,'[ɪnˈtrɔ.e.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (23326,'introgredior','v','introgred introgress -',NULL,NULL,'[ɪn.troːˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (23327,'introitus','n','introit',NULL,NULL,'[ɪnˈtrɔ.ɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (23328,'intromitto','v','intromitt intromis intromiss',NULL,NULL,'[ɪn.troːˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23332,'introspicio','v','introspic introspex introspect',NULL,NULL,'[ɪn.troːsˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (23338,'intueor','v','intu intuit -',NULL,NULL,'[ɪnˈtʊ.e.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (23345,'intumesco','v','intumesc intumu -',NULL,NULL,'[ɪn.tʊˈmeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23346,'intumulatus','a','intumulat intumulat intumulat',NULL,NULL,'[ɪn.tʊ.mʊˈɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23348,'intus','r',NULL,NULL,NULL,'[ˈɪn.tʊs]','rp--------');
INSERT INTO latin_morpho VALUES (23349,'intutus','a','intut intut intut',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (23351,'inultus','a','inult inult inult',NULL,NULL,'[ɪˈnʊɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23353,'inundo','v','inund inundav inundat',NULL,NULL,'[ɪˈnʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23354,'inundatio','n','inundation',NULL,NULL,'[ɪ.nʊnˈdaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23356,'inunguo','v','inungu inunx inunct',NULL,NULL,'[ɪˈnʊŋ.ɡʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23357,'inuro','v','inur inuss inust',NULL,NULL,'[ɪˈnuː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23359,'inusitatus','a','inusitat inusitat inusitat',NULL,NULL,'[ɪ.nuː.sɪˈtaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23360,'inusitate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23361,'inutilis','a','inutil inutil inutil',NULL,NULL,'[ɪˈnuː.tɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (23362,'inutiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23363,'invado','v','invad invas invas',NULL,NULL,'[ɪnˈwaː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23364,'invalesco','v','invalesc invalu -',NULL,NULL,'[ɪn.waˈɫeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23367,'invasio','n','invasion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23368,'inveho','v','inveh invex invect',NULL,NULL,'[ˈɪn.wɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23370,'invenio','v','inven inven invent',NULL,NULL,'[ɪnˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (23371,'inventum','n','invent',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23372,'inventarium','n','inventari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23373,'inventio','n','invention',NULL,NULL,'[ɪnˈwɛn.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23374,'inventor','n','inventor',NULL,NULL,'[ɪnˈwɛn.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (23380,'inverto','v','invert invert invers',NULL,NULL,'[ɪnˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23383,'investigo','v','investig investigav investigat',NULL,NULL,'[ɪn.wɛsˈtiː.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23385,'investigatio','n','investigation',NULL,NULL,'[ɪn.wɛs.tiːˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23390,'invius','a','invi invi invi',NULL,NULL,'[ˈɪn.wi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23391,'invicem','r',NULL,NULL,NULL,'[ˈɪn.wɪ.kẽ]','rp--------');
INSERT INTO latin_morpho VALUES (23394,'invidus','a','invid invid invid',NULL,NULL,'[ˈɪn.wɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23395,'invideo','v','invid invid invis',NULL,NULL,'[ɪnˈwɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (23398,'invidentia','n','invidenti',NULL,NULL,'[ɪn.wɪˈdɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23399,'invidia','n','invidi',NULL,NULL,'[ɪnˈwɪ.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23404,'invincibiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23407,'inviolatus','a','inviolat inviolat inviolat',NULL,NULL,'[ɪn.wi.ɔˈɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23409,'invisus','a','invis invis invis',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (23410,'inviso','v','invis invis invis',NULL,NULL,'[ɪnˈwiː.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23414,'invito','v','invit invitav invitat',NULL,NULL,'[ɪnˈwiː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23416,'invitamentum','n','invitament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23417,'invitatio','n','invitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23420,'invoco','v','invoc invocav invocat',NULL,NULL,'[ˈɪn.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23423,'involucrum','n','involucr',NULL,NULL,'[ɪn.wɔˈɫuː.krũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (23426,'involvo','v','involv involv involut',NULL,NULL,'[ɪnˈwɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23429,'invulnerabilis','a','invulnerabil invulnerabil invulnerabil',NULL,NULL,'[ɪn.wʊɫ.nɛˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (23435,'iota','n','iot',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23441,'ira','n','ir',NULL,NULL,'/ˈiː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23442,'iracundus','a','iracund iracund iracund',NULL,NULL,'[iː.raːˈkʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23445,'irascibilis','a','irascibil irascibil irascibil',NULL,NULL,'[iː.raːsˈkɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (23446,'iratus','a','irat irat irat',NULL,NULL,'[iːˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23447,'irenaceus','n','irenace',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (23452,'Iris','n','Irid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23460,'ironia','n','ironi',NULL,NULL,'/iː.roːˈniː.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23469,'irrefragabilis','a','irrefragabil irrefragabil irrefragabil',NULL,'aps---cn3-=inrefragabilis aps---nn3-=inrefragabile','[ɪr.rɛ.fraːˈɡaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (23474,'irreligiosus','a','irreligios irreligios irreligios',NULL,NULL,'[ɪr.rɛ.lɪ.ɡɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23480,'irreparabilis','a','irreparabil irreparabil irreparabil',NULL,NULL,'[ɪr.rɛ.paˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (23486,'irreverens','a','irreverent irreverent irreverent',NULL,'aps---cn3-=inreverens aps---nn3-=inreverens','[ɪrˈrɛ.wɛ.rẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (23490,'irrideo','v','irrid irris irris',NULL,NULL,'[ɪrˈriː.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (23492,'irrigo','v','irrig irrigav irrigat',NULL,NULL,'[ˈɪr.rɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23496,'irrisus','n','irris',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (23497,'irrisio','n','irrision',NULL,'n-s---fn3-=inrisio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23498,'irrisor','n','irrisor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (23499,'irritus','a','irrit irrit irrit',NULL,'aps---mn1-=inratus aps---fn1-=inrata aps---nn1-=inratum aps---mn1-=inritus aps---fn1-=inrita aps---nn1-=inritum','[ˈɪr.rɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23500,'irrito','v','irrit irritav irrita',NULL,NULL,'[ɪrˈriː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23502,'irritamen','n','irritamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (23503,'irritamentum','n','irritament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23507,'irrogo','v','irrog irrogav irrogat',NULL,NULL,'[ˈɪr.rɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23508,'irroro','v','irror irrorav irrorat',NULL,NULL,'[ɪrˈroː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23511,'irruo','v','irru irru -',NULL,NULL,'[ˈɪr.rʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23517,'irrumpo','v','irrump irrup irrupt',NULL,NULL,'[ɪrˈrʊm.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23518,'irruptio','n','irruption',NULL,'n-s---fn3-=inruptio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23528,'Israel','n','-',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (23548,'itus','n','it',NULL,NULL,'[ˈɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (23549,'ita','r',NULL,NULL,NULL,'[ˈɪ.ta]','rp--------');
INSERT INTO latin_morpho VALUES (23552,'Italia','n','Itali',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23556,'itaque','r',NULL,NULL,NULL,'[ˈɪ.ta.kᶣɛ]','rp--------');
INSERT INTO latin_morpho VALUES (23558,'item','r',NULL,NULL,NULL,'[ˈɪ.tẽ]','rp--------');
INSERT INTO latin_morpho VALUES (23559,'itero','v','iter iterav iterat',NULL,NULL,'[ˈɪ.tɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23560,'iter','n','itiner',NULL,NULL,'[ˈɪ.tɛr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (23561,'iteratio','n','iteration',NULL,NULL,'[ɪ.tɛˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23562,'iterum','r',NULL,NULL,NULL,'[ˈɪ.tɛ.rũ]','rp--------');
INSERT INTO latin_morpho VALUES (23564,'itidem','r',NULL,NULL,NULL,'[ˈɪ.tɪ.dẽ]','rp--------');
INSERT INTO latin_morpho VALUES (23775,'labo','v','lab labav labat',NULL,NULL,'[ˈɫa.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23776,'labor','v','lab laps -',NULL,NULL,'[ˈɫa.bɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (23778,'labasco','v','labasc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (23779,'lambda','n','-',NULL,'n-s---mn1-=labda','[ˈɫamb.da]','n-s---nn--');
INSERT INTO latin_morpho VALUES (23782,'labefacio','v','labefac labefec labefact',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (23783,'labefacto','v','labefact labefactav labefactat',NULL,NULL,'/la.beˈfak.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (23784,'labellum','n','labell',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23787,'labes','n','lab',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (23788,'labia','n','labi',NULL,NULL,'[ˈɫa.bi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23789,'labium','n','labi',NULL,NULL,'[ˈɫa.bi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (23791,'labor','n','labor',NULL,'n-s---mn3-=labos','[ˈɫa.bɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (23792,'laboro','v','labor laborav laborat',NULL,NULL,'[ɫaˈboː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23797,'laboriose','r',NULL,NULL,NULL,'[ɫa.boː.rɪˈoː.seː]','rp--------');
INSERT INTO latin_morpho VALUES (23799,'labrum','n','labr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (23803,'labyrinthus','n','labyrinth',NULL,NULL,'[ɫa.bʏˈrɪn.tʰʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (23805,'lacus','n','lac',NULL,NULL,'[ˈɫa.kʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (23807,'lac','n','lact',NULL,NULL,'[ɫak]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (23809,'lacero','v','lacer lacerav lacerat',NULL,NULL,'/ˈla.ke.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (23812,'lacerta','n','lacert',NULL,'n-s---mn2-=lacertus','[ɫaˈkɛr.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23813,'lacertus','n','lacert',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (23820,'lacinia','n','lacini',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (23823,'lacrima','n','lacrim',NULL,NULL,'[ˈɫa.krɪ.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23824,'lacrimo','v','lacrim lacrimav lacrimat',NULL,NULL,'[ˈɫa.krɪ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23843,'lactens','a','lactent lactent lactent',NULL,NULL,'[ˈɫak.tẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (23846,'lactuca','n','lactuc',NULL,NULL,'[ɫakˈtuː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23848,'lacuna','n','lacun',NULL,NULL,'[ɫaˈkuː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23853,'laedo','v','lid laes laes',NULL,NULL,'[ˈɫae̯.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23855,'laesio','n','laesion',NULL,NULL,'[ˈɫae̯.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23856,'laeto','v','laet laetav laetat',NULL,NULL,'[ˈɫae̯.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23857,'laetus','a','laet laet laet',NULL,NULL,'[ˈɫae̯.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23858,'laetor','v','laet laetat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (23862,'laetatio','n','laetation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23863,'laete','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23866,'laetifico','v','laetific laetificav laetificat',NULL,NULL,'[ɫae̯ˈtɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23867,'laetitia','n','laetiti',NULL,NULL,'[ɫae̯ˈtɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23870,'laevus','a','laev laev laev',NULL,NULL,'[ˈɫae̯.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23887,'lambo','v','lamb lambu lambit',NULL,NULL,'[ˈɫam.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (23893,'lamento','v','lament lamentav lamentat',NULL,NULL,'[ɫaːˈmɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (23894,'lamentor','v','lament lamentat -',NULL,NULL,'[ɫaːˈmɛn.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (23896,'lamentatio','n','lamentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23898,'lamia','n','lami',NULL,NULL,'[ˈɫa.mi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23900,'lamina','n','lamin',NULL,NULL,'/ˈlaː.mi.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23905,'lampas','n','lampad',NULL,NULL,'[ˈɫam.pas]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23906,'lana','n','lan',NULL,NULL,'[ˈɫaː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23907,'lanatus','a','lanat lanat lanat',NULL,NULL,'[ɫaːˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23908,'lancea','n','lance',NULL,NULL,'[ˈɫaŋ.ke.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23911,'landica','n','landic',NULL,NULL,'[ɫanˈdiː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23916,'languidus','a','languid languid languid',NULL,NULL,'[ˈɫaŋ.ɡᶣɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23917,'languide','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23920,'lanius','n','lani',NULL,NULL,'[ˈɫa.ni.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (23921,'lanio','v','lani laniav laniat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (23924,'laniger','a','laniger laniger laniger',NULL,NULL,'[ˈɫaː.nɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (23925,'lanista','n','lanist',NULL,NULL,'/laˈnis.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23928,'lanosus','a','lanos lanos lanos',NULL,NULL,'[ɫaːˈnoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23929,'lanterna','n','lantern',NULL,NULL,'[ɫanˈtɛr.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23932,'lanugo','n','lanugin',NULL,NULL,'[ɫaːˈnuː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23933,'lanx','n','lanc',NULL,NULL,'[ɫaŋks]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (23940,'lapido','v','lapid lapidav lapidat',NULL,NULL,'/ˈla.pi.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (23948,'lapillus','n','lapill',NULL,NULL,'/laˈpil.lus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (23949,'lapis','n','lapid',NULL,NULL,'/ˈla.pis/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (23955,'laqueus','n','laque',NULL,NULL,'[ˈɫa.kᶣe.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (23960,'lar','n','lar',NULL,NULL,'[ɫaːr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (23966,'largior','v','larg largit -',NULL,NULL,'[ˈɫar.ɡi.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (23969,'largitas','n','largitat',NULL,NULL,'[ˈɫar.ɡɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23970,'largiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (23971,'largitio','n','largition',NULL,NULL,'[ɫarˈɡiː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23974,'largitor','n','largitor',NULL,NULL,'[ɫarˈɡiː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (23976,'larix','n','laric',NULL,NULL,'[ˈɫa.rɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (23977,'larva','n','larv',NULL,NULL,'/ˈlar.wa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23980,'lascivus','a','lasciv lasciv lasciv',NULL,NULL,'[ɫasˈkiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23981,'lascivio','v','lasciv lasci lascit',NULL,NULL,'[ɫasˈkiː.wi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (23982,'lascivia','n','lascivi',NULL,NULL,'[ɫasˈkiː.wi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23985,'lassus','a','lass lass lass',NULL,NULL,'/ˈlas.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (23986,'lasso','v','lass lassav lassat',NULL,NULL,'/ˈlas.soː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (23988,'lassitudo','n','lassitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (23990,'latus','a','lat lat lat',NULL,NULL,'[ˈɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (23993,'latebra','n','latebr',NULL,NULL,'[ɫaˈteː.bra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (23999,'later','n','later',NULL,NULL,'[ˈɫa.tɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24006,'latex','n','latic',NULL,NULL,'[ˈɫa.tɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24007,'Latius','a','Lati Lati Lati',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (24012,'Latinus','a','Latin Latin Latin',NULL,NULL,'ɫaˈtiː.nʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (24019,'latitudo','n','latitudin',NULL,NULL,'[ɫaː.tɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24027,'latrina','n','latrin',NULL,NULL,'[ɫaːˈtriː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24029,'latro','n','latron',NULL,NULL,'[ˈɫaː.troː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24031,'latrocinium','n','latrocini',NULL,NULL,'[ɫaː.troːˈkɪ.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24032,'latrunculus','n','latruncul',NULL,NULL,'[ɫaːˈtrʊŋ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24033,'latus','n','later',NULL,NULL,'[ˈɫaː.tʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24035,'laudo','v','laud laudav laudat',NULL,NULL,'[ˈɫau̯.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24037,'laudabilitas','n','laudabilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24038,'laudatio','n','laudation',NULL,NULL,'[ɫau̯ˈdaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24040,'laurus','n','laur',NULL,NULL,'[ˈɫau̯.rʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (24041,'laurea','n','laure',NULL,NULL,'[ˈɫau̯.re.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24049,'laus','n','laud',NULL,NULL,'[ɫau̯s]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24050,'lautus','a','laut laut laut',NULL,NULL,'/ˈlaʊ.tus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (24051,'laute','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24053,'lautitia','n','lautiti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24056,'lavo','v','lav lav -',NULL,NULL,'[ˈɫa.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24062,'lavacrum','n','lavacr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24064,'lavatio','n','lavation',NULL,NULL,'[ɫaˈwaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24067,'laxus','a','lax lax lax',NULL,NULL,'/ˈlak.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (24068,'laxo','v','lax laxav laxat',NULL,NULL,'[ˈɫak.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24069,'laxamentum','n','laxament',NULL,NULL,'[ɫak.saːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24070,'laxatus','a','laxat laxat laxat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (24072,'laxe','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24073,'laxitas','n','laxitat',NULL,NULL,'[ˈɫak.sɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24075,'lea','n','le',NULL,NULL,'[ˈɫe.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24076,'leaena','n','leaen',NULL,NULL,'[ɫɛˈae̯.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24077,'lebes','n','lebet',NULL,NULL,'[ˈɫɛ.bɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24079,'lectus','n','lect',NULL,NULL,'[ˈɫeːk.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24081,'lectus','a','lect lect lect',NULL,NULL,'[ˈɫeːk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24082,'lectica','n','lectic',NULL,NULL,'[ɫɛkˈtiː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24085,'lectio','n','lection',NULL,NULL,'[ˈɫeːk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24088,'lector','n','lector',NULL,NULL,'[ˈɫeːk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24095,'lego','v','leg leg lect',NULL,NULL,'[ˈɫɛ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24097,'legalis','a','legal legal legal',NULL,NULL,'[ɫeːˈɡaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (24099,'legatus','n','legat',NULL,NULL,'[ɫeːˈɡaː.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24102,'legatio','n','legation',NULL,NULL,'[ɫeːˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24104,'legio','n','legion',NULL,NULL,'[ˈɫɛ.ɡi.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24109,'legislator','n','legislator',NULL,NULL,'[ɫeː.ɡɪsˈɫaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24111,'legitimus','a','legitim legitim legitim',NULL,NULL,'[ɫeːˈɡɪ.tɪ.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24117,'legumen','n','legumin',NULL,NULL,'[ɫɛˈɡuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24123,'lemma','n','lemmat',NULL,NULL,'[ˈɫɛm.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24124,'lemniscus','n','lemnisc',NULL,NULL,'[ɫeːmˈnɪs.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24128,'lena','n','len',NULL,NULL,'[ˈɫeː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24129,'lenis','a','len len len',NULL,NULL,'[ˈɫeː.nɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (24130,'lenio','v','len leni lenit',NULL,NULL,'[ˈɫeː.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (24132,'lenimen','n','lenimin',NULL,NULL,'[ɫeːˈniː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24133,'lenimentum','n','leniment',NULL,NULL,'[ɫeː.niːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24134,'lenitas','n','lenitat',NULL,NULL,'[ˈɫeː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24135,'leniter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24136,'lenitudo','n','lenitudin',NULL,NULL,'[ɫeː.nɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24137,'leno','n','lenon',NULL,NULL,'[ˈɫeː.noː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24139,'lenocinium','n','lenocini',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24140,'lens','n','lend',NULL,NULL,'[ɫẽːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (24143,'lente','r',NULL,NULL,NULL,'[ˈɫɛn.teː]','rp--------');
INSERT INTO latin_morpho VALUES (24145,'lenticula','n','lenticul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24146,'lentigo','n','lentigin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24149,'lentitudo','n','lentitudin',NULL,NULL,'[ɫɛn.tɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24150,'lentor','n','lentor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (24153,'leo','n','leon',NULL,NULL,'[ˈɫe.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24155,'leoninus','a','leonin leonin leonin',NULL,NULL,'[ɫe.oːˈniː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24156,'leopardus','n','leopard',NULL,NULL,'[ɫe.ɔˈpar.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24157,'leopardalis','n','leopardal',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (24158,'lepas','n','lepad',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24159,'lepidus','a','lepid lepid lepid',NULL,NULL,'[ˈɫɛ.pɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24160,'lepide','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24165,'lepos','n','lepor',NULL,NULL,'[ˈɫɛ.poːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24166,'lepra','n','lepr',NULL,NULL,'/ˈle.pra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24168,'leprosus','a','lepros lepros lepros',NULL,NULL,'/leˈproː.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (24169,'lepus','n','lepor',NULL,NULL,'[ˈɫɛ.pʊs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24172,'letum','n','let',NULL,'n-s---nn2-=lethum','[ˈɫeː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24173,'letalis','a','letal letal letal',NULL,NULL,'/leːˈtaː.lis/','aps---cn3i');
INSERT INTO latin_morpho VALUES (24176,'lethargus','n','letharg',NULL,NULL,'[ɫeːˈtʰar.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24184,'levo','v','lev levav levat',NULL,NULL,'/ˈle.woː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24186,'levis','a','lev lev lev',NULL,'aps---cn3-=laevis','[ˈɫɛ.wɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (24188,'levamen','n','levamin',NULL,NULL,'[ɫɛˈwaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24189,'levamentum','n','levament',NULL,NULL,'[ɫɛ.waːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24190,'levatio','n','levation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24193,'levifico','v','levific levificav levificat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (24194,'levigo','v','levig levigav levigat',NULL,NULL,'[ˈɫɛ.wɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24198,'Levita','n','Levit',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (24199,'levitas','n','levitat',NULL,NULL,'/ˈle.wi.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24200,'leviter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24202,'levor','n','levor',NULL,NULL,'[ˈɫeː.wɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24203,'lex','n','leg',NULL,NULL,'[ɫeːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24211,'libum','n','lib',NULL,NULL,'[ˈliː.bũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24212,'libo','v','lib libav libat',NULL,NULL,'/ˈliː.boː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24216,'libamentum','n','libament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24217,'libanotis','n','libanotid',NULL,NULL,'[lɪ.baˈnoː.tɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24218,'libatio','n','libation',NULL,NULL,'/liːˈbaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24219,'libella','n','libell',NULL,NULL,'[liːˈbɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24220,'libellus','n','libell',NULL,NULL,'[lɪˈbɛl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24221,'libens','a','libent libent libent',NULL,NULL,'[ˈlɪ.bẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (24222,'libenter','r',NULL,NULL,NULL,'[lɪˈbɛn.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (24224,'libero','v','liber liberav liberat',NULL,NULL,'[ˈliː.bɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24232,'liberator','n','liberator',NULL,NULL,'[liː.bɛˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24235,'libertus','n','libert',NULL,NULL,'[liːˈbɛr.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24237,'libertas','n','libertat',NULL,NULL,'[liːˈbɛr.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24239,'libertinus','n','libertin',NULL,NULL,'[liː.bɛrˈtiː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24243,'libido','n','libidin',NULL,'n-s---fn3-=lubido','[lɪˈbiː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24245,'libitinarius','n','libitinari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (24247,'libra','n','libr',NULL,NULL,'/ˈliː.bra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24248,'libro','v','libr librav librat',NULL,NULL,'/ˈliː.broː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24250,'libramentum','n','librament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24251,'libraria','n','librari',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24252,'librarius','n','librari',NULL,NULL,'[lɪˈbraː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24266,'Libya','n','Liby',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24273,'licentia','n','licenti',NULL,NULL,'[lɪˈkɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24278,'lichen','n','lichen',NULL,NULL,'/ˈliː.kʰeːn/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24279,'licium','n','lici',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24284,'lien','n','lien',NULL,NULL,'/ˈli.eːn/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24289,'ligo','v','lig ligav ligat',NULL,NULL,'[ˈlɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24290,'ligamen','n','ligamin',NULL,NULL,'[lɪˈɡaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24291,'ligamentum','n','ligament',NULL,NULL,'[lɪ.ɡaːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24293,'ligatura','n','ligatur',NULL,NULL,'[lɪ.ɡaːˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24296,'lignum','n','lign',NULL,NULL,'[ˈlɪŋ.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24301,'ligneus','a','ligne ligne ligne',NULL,NULL,'[ˈlɪŋ.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24304,'ligo','n','ligon',NULL,NULL,'[ˈlɪ.ɡoː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24308,'ligurrio','v','ligurr ligurriv -',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (24309,'ligustrum','n','ligustr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24312,'lilium','n','lili',NULL,NULL,'[ˈliː.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24313,'lima','n','lim',NULL,NULL,'/ˈliː.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24314,'limus','n','lim',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (24316,'limo','v','lim limav limat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (24320,'limax','n','limac',NULL,NULL,'/ˈliː.maːks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24321,'limbus','n','limb',NULL,NULL,'/ˈlim.bus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24322,'limen','n','limin',NULL,NULL,'[ˈliː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24323,'limes','n','limit',NULL,NULL,'[ˈliː.mɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24334,'linum','n','lin',NULL,NULL,'[ˈliː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24335,'lino','v','lin - lit',NULL,NULL,'[ˈlɪ.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (24338,'linea','n','line',NULL,NULL,'/ˈliː.ne.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24340,'lineamentum','n','lineament',NULL,NULL,'[liː.ne.aːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24342,'lingo','v','ling linx linct',NULL,NULL,'[ˈlɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (24344,'lingua','n','lingu',NULL,NULL,'[ˈlɪŋ.ɡʷa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24349,'lingulaca','n','lingulac',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24354,'linquo','v','linqu liqu -',NULL,NULL,'[ˈlɪŋ.kʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (24355,'linteum','n','linte',NULL,NULL,'[ˈlɪn.te.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24361,'linter','n','lintr',NULL,NULL,'[ˈlɪn.tɛr]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (24367,'liquo','v','liqu liquav liquat',NULL,NULL,'[ˈlɪ.kʷoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24369,'liquor','v','liqu  -',NULL,NULL,'[ˈlɪ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (24370,'liquamen','n','liquamin',NULL,NULL,'[lɪˈkʷaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24372,'liquatio','n','liquation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24373,'liquefacio','v','liquefac liquefec liquefact',NULL,NULL,'[lɪ.kᶣɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (24376,'liquesco','v','liquesc licu -',NULL,NULL,'[lɪˈkᶣeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (24377,'liquidus','a','liquid liquid liquid',NULL,NULL,'[ˈlɪ.kᶣɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24378,'liquor','n','liquor',NULL,NULL,'[ˈlɪ.kʷɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24379,'lis','n','lit',NULL,NULL,'/liːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (24381,'litania','n','litani',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24395,'littera','n','litter',NULL,NULL,'[ˈlɪt.tɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24398,'litteratus','a','litterat litterat litterat',NULL,NULL,'[lɪt.tɛˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24400,'litteratorius','a','litteratori litteratori litteratori',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (24401,'litteratura','n','litteratur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24405,'litura','n','litur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24409,'litus','n','lit',NULL,NULL,'[ˈliː.tʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24413,'livor','n','livor',NULL,NULL,'[ˈliː.wɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24422,'locus','n','loc',NULL,NULL,'[ˈɫɔ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24429,'loco','v','loc locav locat',NULL,NULL,'[ˈɫɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24432,'locarium','n','locari',NULL,NULL,'[ɫɔˈkaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24433,'locatio','n','location',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24434,'locator','n','locator',NULL,NULL,'[ɫɔˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24439,'loculamentum','n','loculament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24443,'locuples','a','locuplet locuplet locuplet',NULL,NULL,'[ˈɫɔ.kʊ.pɫeːs]','aps---an3-');
INSERT INTO latin_morpho VALUES (24445,'locusta','n','locust',NULL,NULL,'[ɫɔˈkʊs.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24446,'locutio','n','locution',NULL,NULL,'[ɫɔˈkuː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24447,'lodix','n','lodic',NULL,NULL,'[ˈɫoː.diːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24453,'logicum','n','logic',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24454,'logicus','a','logic logic logic',NULL,NULL,'[ˈɫɔ.ɡɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24464,'longus','a','long long long',NULL,NULL,'[ˈɫɔŋ.ɡʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24465,'longaevus','a','longaev longaev longaev',NULL,NULL,'[ɫɔŋˈɡae̯.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24468,'longanimis','a','longanim longanim longanim',NULL,NULL,'[ɫɔŋˈɡa.nɪ.mɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (24469,'longanimitas','n','longanimitat',NULL,NULL,'[ɫɔŋ.ɡaˈnɪ.mɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24470,'longanimiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24475,'longinquitas','n','longinquitat',NULL,NULL,'[ɫɔŋˈɡɪŋ.kᶣɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24478,'longitudo','n','longitudin',NULL,NULL,'[ɫɔŋ.ɡɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24486,'loquor','v','loqu locut -',NULL,NULL,'[ˈɫɔ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (24487,'loquacitas','n','loquacitat',NULL,NULL,'[ɫɔˈkʷaː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24491,'loquella','n','loquell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24493,'lorum','n','lor',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24497,'lorica','n','loric',NULL,'n-s---fn1-=lurica','[ɫoːˈriː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24501,'lotos','n','lot',NULL,NULL,'[ˈɫoː.tɔs]','n-s---cn2-');
INSERT INTO latin_morpho VALUES (24505,'luo','v','lu lu -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (24512,'lubricus','a','lubric lubric lubric',NULL,NULL,'[ˈɫuː.brɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24515,'lubricosus','a','lubricos lubricos lubricos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (24518,'luceo','v','luc - -',NULL,NULL,'[ˈɫuː.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (24520,'lucerna','n','lucern',NULL,NULL,'[ɫʊˈkɛr.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24522,'lucius','n','luci',NULL,NULL,'[ˈɫuː.ki.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24524,'lucidus','a','lucid lucid lucid',NULL,NULL,'[ˈɫuː.kɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24525,'lucido','v','lucid lucidav lucidat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (24533,'lucrum','n','lucr',NULL,NULL,'[ˈɫʊ.krũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24534,'lucror','v','lucr lucrat -',NULL,NULL,'[ˈɫʊ.krɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (24539,'luctus','n','luct',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (24540,'luctor','v','luct luctat -',NULL,NULL,'[ˈɫʊk.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (24541,'luctamen','n','luctamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (24542,'luctator','n','luctator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (24550,'luculentus','a','luculent luculent luculent',NULL,NULL,'[ɫuː.kʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24553,'ludus','n','lud',NULL,NULL,'[ˈɫuː.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24554,'ludo','v','lud lus lus',NULL,NULL,'[ˈɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (24555,'ludius','n','ludi',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (24556,'ludibrium','n','ludibri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24560,'ludicrum','n','ludicr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24566,'ludio','n','ludion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (24567,'luella','n','luell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24568,'lues','n','lu',NULL,NULL,'[ˈɫʊ.eːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (24569,'lugeo','v','lug lux luct',NULL,NULL,'[ˈɫuː.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (24572,'lumbus','n','lumb',NULL,NULL,'[ˈɫʊm.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24575,'lumen','n','lumin',NULL,NULL,'[ˈɫuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (24576,'lumino','v','lumin luminav luminat',NULL,NULL,'[ˈɫuː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24579,'luminosus','a','luminos luminos luminos',NULL,NULL,'/luː.miˈnoː.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (24580,'luna','n','lun',NULL,NULL,'[ˈɫuː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24581,'luno','v','lun lunav lunat',NULL,NULL,'[ˈɫuː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24582,'lunaris','a','lunar lunar lunar',NULL,NULL,'/luːˈnaː.ris/','aps---cn3i');
INSERT INTO latin_morpho VALUES (24585,'lupa','n','lup',NULL,NULL,'[ˈɫʊ.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24586,'lupus','n','lup',NULL,NULL,'[ˈɫʊ.pʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24587,'lupanar','n','lupanar',NULL,NULL,'[ɫʊˈpaː.nar]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (24597,'luror','n','luror',NULL,NULL,'[ˈɫuː.rɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24598,'lusus','n','lus',NULL,NULL,'[ˈɫuː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (24600,'luscinia','n','luscini',NULL,NULL,'[ɫʊsˈkɪ.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24603,'lusito','v','lusit lusitav lusitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (24604,'lusor','n','lusor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (24606,'lustrum','n','lustr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24608,'lustro','v','lustr lustrav lustrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (24613,'lutum','n','lut',NULL,'n-s---mn2-=lutus','[ˈɫʊ.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24622,'lutosus','a','lutos lutos lutos',NULL,NULL,'[ɫʊˈtoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24623,'lutulentus','a','lutulent lutulent lutulent',NULL,NULL,'[ɫʊ.tʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24624,'lux','n','luc',NULL,NULL,'[ɫuːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24625,'luxus','n','lux',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (24626,'luxo','v','lux luxav luxat',NULL,NULL,'[ˈɫʊk.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24627,'luxatio','n','luxation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24628,'luxatura','n','luxatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24629,'luxuria','n','luxuri',NULL,NULL,'[ɫʊkˈsʊ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24631,'luxurio','v','luxuri luxuriav luxuriat',NULL,NULL,'/lukˈsu.ri.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24638,'lychnus','n','lychn',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (24641,'lympha','n','lymph',NULL,NULL,'[ˈlʏm.pʰa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24644,'lymphatus','n','lymphat',NULL,NULL,'[lʏmˈpʰaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (24645,'lymphatus','a','lymphat lymphat lymphat',NULL,NULL,'[lʏmˈpʰaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24646,'lymphaticus','a','lymphatic lymphatic lymphatic',NULL,NULL,'[lʏmˈpʰaː.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24651,'lyricus','a','lyric lyric lyric',NULL,NULL,'[ˈlʏ.rɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24658,'Macedo','n','Macedon',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (24659,'Macedonia','n','Macedoni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24660,'Macedonius','a','Macedoni Macedoni Macedoni',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (24661,'Macedonicus','a','Macedonic Macedonic Macedonic',NULL,NULL,'maː.kɛˈdɔ.nɪ.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (24664,'macero','v','macer macerav macerat',NULL,NULL,'[ˈmaː.kɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24665,'macer','a','  ',NULL,NULL,'[ˈma.kɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (24666,'maceria','n','maceri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24668,'macesco','v','macesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (24670,'machina','n','machin',NULL,NULL,'[ˈmaː.kʰɪ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24671,'machinor','v','machin machinat -',NULL,NULL,'[ˈmaː.kʰɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (24675,'machinatio','n','machination',NULL,NULL,'[maː.kʰɪˈnaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24676,'machinator','n','machinator',NULL,NULL,'[maː.kʰɪˈnaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24677,'macies','n','maci',NULL,NULL,'/ˈma.ki.eːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (24678,'macilentus','a','macilent macilent macilent',NULL,NULL,'[ma.kɪˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24689,'macto','v','mact mactav mactat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (24693,'macula','n','macul',NULL,NULL,'[ˈma.kʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24694,'maculo','v','macul maculav maculat',NULL,NULL,'[ˈma.kʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24697,'madefacio','v','madefac madefec madefact',NULL,NULL,'[ma.dɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (24703,'madidus','a','madid madid madid',NULL,NULL,'[ˈma.dɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24709,'maenianum','n','maenian',NULL,NULL,'[mae̯.nɪˈaː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24710,'maereo','v','maer - -',NULL,NULL,'/ˈmae̯.re.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (24711,'maeror','n','maeror',NULL,'n-s---mn3-=moeror',NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (24713,'maestus','a','maest maest maest',NULL,NULL,'[ˈmae̯s.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24714,'maestitia','n','maestiti',NULL,'n-s---fn1-=moestitia',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24715,'maestitudo','n','maestitudin',NULL,'n-s---fn3-=moestitudo',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24718,'magus','n','mag',NULL,NULL,'[ˈma.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24721,'magia','n','magi',NULL,NULL,'/maˈɡiː.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24723,'magis','r',NULL,NULL,NULL,'[ˈma.ɡɪs]','rp--------');
INSERT INTO latin_morpho VALUES (24724,'magister','n','magistr',NULL,NULL,'[maˈɡɪs.tɛr]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24726,'magisterium','n','magisteri',NULL,NULL,'[ma.ɡɪsˈtɛ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24729,'magistratus','n','magistrat',NULL,NULL,'[ma.ɡɪsˈtraː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (24731,'magnus','a','magn magn magn',NULL,NULL,'[ˈmaŋ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24734,'magnanimus','a','magnanim magnanim magnanim',NULL,NULL,'[maŋˈna.nɪ.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24735,'magnanimitas','n','magnanimitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24737,'magnatus','n','magnat',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (24747,'magnifico','v','magnific magnificav magnificat',NULL,NULL,'[maŋˈnɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24748,'magnificus','a','magnific magnific magnific',NULL,NULL,'[maŋˈnɪ.fɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24750,'magnifice','r',NULL,NULL,NULL,'[maŋˈnɪ.fɪ.keː]','rp--------');
INSERT INTO latin_morpho VALUES (24752,'magnificentia','n','magnificenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24754,'magniloquentia','n','magniloquenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24755,'magnitudo','n','magnitudin',NULL,NULL,'[maŋ.nɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24756,'magnopere','r',NULL,NULL,'rp--------=magno',NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24782,'malus','n','mal',NULL,NULL,'[ˈma.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24784,'malum','n','mal',NULL,NULL,'[ˈma.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24785,'malo','v','mal malu ',NULL,NULL,'/ˈma.loː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (24786,'malus','a','mal mal mal','acs---cn3-=peior acs---nn3-=peius ass---mn1-=pessimus ass---fn1-=pessima ass---nn1-=pessimum',NULL,'[ˈma.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24787,'malacus','a','malac malac malac',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (24790,'malacia','n','malaci',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24791,'malagma','n','malagmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (24796,'male','r',NULL,'rc--------=peius rs--------=pessime',NULL,'[ˈma.ɫɛ]','rp--------');
INSERT INTO latin_morpho VALUES (24798,'maledico','v','maledic maledix maledict',NULL,NULL,'[ma.ɫɛˈdiː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (24802,'maledictum','n','maledict',NULL,NULL,'/ma.leˈdik.tum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24803,'maledictio','n','malediction',NULL,NULL,'[ma.ɫɛˈdɪk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24805,'malefactor','n','malefactor',NULL,NULL,'[ma.ɫɛˈfak.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24806,'malefica','n','malefic',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24808,'maleficus','a','malefic malefic malefic','ass---mn1-=maleficentissimus ass---fn1-=maleficentissima ass---nn1-=maleficentissimum',NULL,'[maˈɫɛ.fɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24809,'malefice','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (24810,'maleficentia','n','maleficenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (24812,'maleficium','n','malefici',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24818,'malevolus','a','malevol malevol malevol',NULL,'aps---mn1-=malivolus aps---fn1-=malivola aps---nn1-=malivolum','[maˈɫɛ.wɔ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24820,'malevolens','a','malevolent malevolent malevolent',NULL,NULL,'[maˈɫɛ.wɔ.ɫẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (24821,'malevolentia','n','malevolenti',NULL,NULL,'/ma.le.woˈlen.ti.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24830,'malignitas','n','malignitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24832,'malitia','n','maliti',NULL,NULL,'[maˈlɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24841,'malleus','n','malle',NULL,NULL,'[ˈmal.le.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24847,'malogranatum','n','malogranat',NULL,NULL,'[maː.ɫɔ.ɡraːˈnaː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24853,'mamilla','n','mamill',NULL,NULL,'[maˈmɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24854,'mamma','n','mamm',NULL,NULL,'/ˈmam.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24861,'manus','n','man',NULL,NULL,'[ˈma.nʊs]','n-s---fn4-');
INSERT INTO latin_morpho VALUES (24862,'mano','v','man manav manat',NULL,NULL,'/ˈmaː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24863,'maneo','v','man mans mans',NULL,NULL,'/ˈma.ne.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (24866,'manceps','n','mancip',NULL,NULL,'[ˈmaŋ.kɛps]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24867,'mancipo','v','mancip mancipav mancipat',NULL,NULL,'[ˈmaŋ.kɪ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24872,'mando','v','mand mandav mandat',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (24875,'mandatum','n','mandat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24880,'manduco','v','manduc manducav manducat',NULL,NULL,'/manˈduː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24890,'mango','n','mangon',NULL,NULL,'[ˈmaŋ.ɡoː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (24892,'mania','n','mani',NULL,NULL,'/ˈma.ni.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24901,'manifesto','v','manifest manifestav manifestat',NULL,NULL,'/ma.niˈfes.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24902,'manifestus','a','manifest manifest manifest',NULL,NULL,'/ma.niˈfes.tus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (24908,'manifesto','r',NULL,NULL,'rp--------=manifeste','/ma.niˈfes.toː/','rp--------');
INSERT INTO latin_morpho VALUES (24912,'manipulus','n','manipul',NULL,NULL,'[maˈnɪ.pʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24917,'manna','n','mann',NULL,NULL,'/ˈman.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24923,'mansio','n','mansion',NULL,NULL,'[ˈmãː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24926,'mansuefacio','v','mansuefac mansuefec mansuefact',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (24932,'mansueto','v','mansuet mansuetav mansueta',NULL,NULL,'[mãːˈsweː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (24933,'mansuetudo','n','mansuetudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (24935,'mantele','n','mantel',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (24936,'mantica','n','mantic',NULL,NULL,'[ˈman.tɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24939,'manubrium','n','manubri',NULL,NULL,'[maˈnuː.bri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (24948,'manumitto','v','manumitt manumis manumiss',NULL,NULL,'[ma.nuːˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (24950,'manupretium','n','manupreti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (24965,'marcens','a','marcent marcent marcent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (24966,'marcesco','v','marcesc marcu -',NULL,NULL,'/marˈkeːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (24970,'marcidus','a','marcid marcid marcid',NULL,NULL,'/ˈmar.ki.dus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (24975,'margarita','n','margarit',NULL,NULL,'/mar.ɡaˈriː.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24978,'margo','n','margin',NULL,NULL,'/ˈmar.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (24982,'marinus','a','marin marin marin',NULL,NULL,'/maˈriː.nus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (24986,'marita','n','marit',NULL,NULL,'/maˈriː.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (24987,'maritus','n','marit',NULL,NULL,'[maˈriː.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (24988,'maritus','a','marit marit marit',NULL,NULL,'[maˈriː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24989,'marito','v','marit maritav maritat',NULL,NULL,'/maˈriː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (24991,'maritimus','a','maritim maritim maritim',NULL,NULL,'[maˈrɪ.tɪ.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (24996,'marmor','n','marmor',NULL,NULL,'[ˈmar.mɔr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (25000,'marra','n','marr',NULL,NULL,'/ˈmar.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25001,'Mars','n','Mart',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (25003,'marsuppium','n','marsuppi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25008,'martyr','n','martyr',NULL,NULL,'[ˈmar.tʏr]','n-s---cn3-');
INSERT INTO latin_morpho VALUES (25014,'mas','a','mar mar mar',NULL,NULL,'/maːs/','aps---an3-');
INSERT INTO latin_morpho VALUES (25015,'masculus','a','mascul mascul mascul',NULL,NULL,'[ˈmas.kʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25019,'massa','n','mass',NULL,NULL,'/ˈmas.sa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25028,'mastiche','n','mastich',NULL,NULL,'[ˈmas.tɪ.kʰeː]','n-s---fn1g');
INSERT INTO latin_morpho VALUES (25030,'mastigo','v','mastig mastigav mastigat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25032,'mastigia','n','mastigi',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (25038,'mater','n','matr',NULL,NULL,'[ˈmaː.tɛr]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25040,'materia','n','materi',NULL,NULL,'[maːˈtɛ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25050,'materiatio','n','materiation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25055,'mathematica','n','mathematic',NULL,NULL,'[ma.tʰeːˈma.tɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25056,'mathematicus','n','mathematic',NULL,NULL,'[ma.tʰeːˈma.tɪ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25057,'mathematicus','a','mathematic mathematic mathematic',NULL,NULL,'[ma.tʰeːˈma.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25058,'mathesis','n','mathes',NULL,NULL,'[maˈtʰeː.sɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25060,'matricida','n','matricid',NULL,NULL,'[maː.trɪˈkiː.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25065,'matrimonium','n','matrimoni',NULL,NULL,'[maː.trɪˈmoː.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25066,'matrimonialis','a','matrimonial matrimonial matrimonial',NULL,NULL,'[maː.trɪ.moː.nɪˈaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25068,'matrix','n','matric',NULL,NULL,'/ˈmaː.triːks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25069,'matrona','n','matron',NULL,NULL,'/maːˈtroː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25075,'maturo','v','matur maturav maturat',NULL,NULL,'/maːˈtuː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25076,'maturus','a','matur matur matur',NULL,NULL,'/maːˈtuː.rus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (25078,'mature','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25080,'maturitas','n','maturitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25086,'Mausoleum','n','Mausole',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25087,'Mavors','n','Mavort',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (25089,'maxilla','n','maxill',NULL,NULL,'[makˈsɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25092,'maxime','r',NULL,NULL,NULL,'[ˈmak.sɪ.meː]','rp--------');
INSERT INTO latin_morpho VALUES (25093,'maximitas','n','maximitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25100,'meo','v','me meav meat',NULL,NULL,'/ˈme.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25101,'meatus','n','meat',NULL,NULL,'[mɛˈaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25103,'mechanicus','n','mechanic',NULL,NULL,'[meːˈkʰa.nɪ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25106,'medeor','v','med  -',NULL,NULL,'[ˈmɛ.de.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (25111,'medella','n','medell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25112,'medens','n','medent',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (25114,'medium','n','medi',NULL,NULL,'[ˈmɛ.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25115,'medius','a','medi medi medi',NULL,NULL,'[ˈmɛ.di.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25125,'mediator','n','mediator',NULL,NULL,'[mɛ.dɪˈaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25127,'medica','n','medic',NULL,NULL,'[ˈmɛ.dɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25130,'medicus','n','medic',NULL,NULL,'[ˈmɛ.dɪ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25132,'medico','v','medic medicav medicat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25133,'medicor','v','medic medicat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (25134,'medicabilis','a','medicabil medicabil medicabil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (25135,'medicamen','n','medicamin',NULL,NULL,'[mɛ.dɪˈkaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (25136,'medicamentum','n','medicament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25137,'medicina','n','medicin',NULL,NULL,'[mɛ.dɪˈkiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25139,'medidies','n','medidi',NULL,NULL,NULL,'n-s---mn5-');
INSERT INTO latin_morpho VALUES (25144,'mediocris','a','mediocr mediocr mediocr',NULL,NULL,'[mɛˈdi.ɔ.krɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25145,'mediocritas','n','mediocritat',NULL,NULL,'[mɛ.dɪˈɔ.krɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25148,'meditor','v','medit meditat -',NULL,NULL,'/ˈme.di.tor/','v1spid--1-');
INSERT INTO latin_morpho VALUES (25151,'meditamentum','n','meditament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25152,'meditatio','n','meditation',NULL,NULL,'/me.diˈtaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25155,'medulla','n','medull',NULL,NULL,'[mɛˈdʊl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25156,'medullitus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25165,'meio','v','mei meiav meia',NULL,NULL,'/ˈmeːj.joː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (25168,'melos','n','mel',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25169,'mel','n','mell',NULL,NULL,'[mɛɫ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (25176,'melioro','v','melior - meliorat',NULL,NULL,'[mɛ.lɪˈoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25192,'melodia','n','melodi',NULL,NULL,'[mɛˈɫoː.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25203,'membrum','n','membr',NULL,NULL,'[ˈmɛm.brũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25204,'membrana','n','membran',NULL,NULL,'[mɛmˈbraː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25207,'memor','a','memor memor memor',NULL,NULL,'[ˈmɛ.mɔr]','aps---an3-');
INSERT INTO latin_morpho VALUES (25208,'memoro','v','memor memorav memorat',NULL,NULL,'[ˈmɛ.mɔ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25211,'memoria','n','memori',NULL,NULL,'[mɛˈmɔ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25216,'memoriola','n','memoriol',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25220,'menda','n','mend',NULL,NULL,'[ˈmɛn.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25221,'mendum','n','mend',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25222,'mendacium','n','mendaci',NULL,NULL,'[mɛnˈdaː.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25223,'mendaciter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25225,'mendax','a','mendac mendac mendac',NULL,NULL,'[ˈmɛn.daːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (25229,'mendicatio','n','mendication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25232,'mensa','n','mens',NULL,NULL,'[ˈmẽː.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25233,'mens','n','ment',NULL,NULL,'[mẽːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (25236,'mensis','n','mens',NULL,NULL,'[ˈmẽː.sɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (25239,'menstruus','a','menstru menstru menstru',NULL,NULL,'[ˈmẽː.strʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25246,'mensura','n','mensur',NULL,NULL,'[mẽːˈsuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25247,'mensuro','v','mensur mensurav mensurat',NULL,NULL,'[mẽːˈsuː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25249,'mentum','n','ment',NULL,NULL,'/ˈmen.tũ/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25251,'mentha','n','menth',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25252,'mentior','v','ment mentit -',NULL,NULL,'[ˈmɛn.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (25253,'mentio','n','mention',NULL,NULL,'/ˈmen.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25257,'merum','n','mer',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25259,'mereo','v','mer meru merit',NULL,NULL,'[ˈmɛ.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (25262,'mercor','v','merc mercat -',NULL,NULL,'[ˈmɛr.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25264,'mercatus','n','mercat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (25265,'mercator','n','mercator',NULL,NULL,'[mɛrˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25266,'mercatura','n','mercatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25272,'merces','n','merced',NULL,NULL,'[ˈmɛr.keːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25273,'mercimonium','n','mercimoni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25275,'Mercurius','n','Mercuri',NULL,NULL,'mɛrˈkʊ.ri.ʊs','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25282,'meretrix','n','meretric',NULL,NULL,'[ˈmɛ.rɛ.triːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25285,'mergo','v','merg mers mers',NULL,NULL,'[ˈmɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (25288,'meridies','n','meridi',NULL,NULL,'[mɛˈriː.di.eːs]','n-s---mn5-');
INSERT INTO latin_morpho VALUES (25295,'meritum','n','merit',NULL,NULL,'[ˈmɛ.rɪ.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25296,'meritus','a','merit merit merit',NULL,NULL,'[ˈmɛ.rɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25297,'merito','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25301,'merso','v','mers mersav mersat',NULL,NULL,'[ˈmɛr.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25302,'merula','n','merul',NULL,NULL,'[ˈmɛ.rʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25303,'merx','n','merc',NULL,NULL,'[mɛrks]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (25309,'mespilum','n','mespil',NULL,NULL,'[ˈmɛs.pɪ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25312,'messis','n','mess',NULL,NULL,'[ˈmɛs.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (25313,'messor','n','messor',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25316,'meta','n','met',NULL,NULL,'/ˈmeː.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25317,'metus','n','met',NULL,NULL,'[ˈmɛ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25318,'meto','v','met - metat',NULL,NULL,'[ˈmɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (25319,'metor','v','met metat -',NULL,NULL,'[ˈmeː.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25322,'metallum','n','metall',NULL,NULL,'[mɛˈtal.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25343,'metior','v','met mens -',NULL,NULL,'[ˈmeː.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (25344,'metonymia','n','metonymi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25345,'metrum','n','metr',NULL,NULL,'[ˈmɛ.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25348,'metricus','a','metric metric metric',NULL,NULL,'[ˈmɛ.trɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25353,'metuo','v','metu metu metut',NULL,NULL,'[ˈmɛ.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (25354,'metuculosus','a','metuculos metuculos metuculos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (25357,'mica','n','mic',NULL,NULL,'/ˈmiː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25358,'mico','v','mic micu -',NULL,NULL,'[ˈmɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25370,'migma','n','migmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (25372,'migro','v','migr migrav migrat',NULL,NULL,'[ˈmɪ.ɡroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25373,'migratio','n','migration',NULL,NULL,'[mɪˈɡraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25375,'miles','n','milit',NULL,NULL,'[ˈmiː.ɫɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25376,'milium','n','mili',NULL,NULL,'/ˈmi.li.ũ/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25389,'militia','n','militi',NULL,NULL,'[miːˈlɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25404,'milvus','n','milv',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (25406,'mimus','n','mim',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (25413,'minor','v','min minat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (25415,'minaciter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25423,'Minerva','n','Minerv',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25426,'minium','n','mini',NULL,NULL,'[ˈmɪ.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25433,'minister','n','ministr',NULL,NULL,'[mɪˈnɪs.tɛr]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25436,'ministerium','n','ministeri',NULL,NULL,'[mɪ.nɪsˈtɛ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25439,'ministro','v','ministr ministrav ministrat',NULL,NULL,'/miˈnis.troː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25441,'minito','v','minit minitav minitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25442,'minitor','v','minit minitat -',NULL,NULL,'[ˈmɪ.nɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25445,'minoro','v','minor - minorat',NULL,NULL,'[mɪˈnoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25447,'minuo','v','minu minu minut',NULL,NULL,'[ˈmɪ.nʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (25448,'minurrio','v','minurri  ',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (25454,'minutus','a','minut minut minut',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (25460,'minutim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25461,'mirus','a','mir mir mir',NULL,NULL,'[ˈmiː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25463,'miror','v','mir mirat -',NULL,NULL,'[ˈmiː.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25464,'mirabilis','a','mirabil mirabil mirabil',NULL,NULL,'[miːˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25465,'mirabiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25467,'miraculum','n','miracul',NULL,NULL,'[miːˈraː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25468,'miraculose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25469,'mirator','n','mirator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25472,'mirifico','v','mirific mirificav mirificat',NULL,NULL,'/miːˈri.fi.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25476,'misceo','v','misc miscu mixt',NULL,NULL,'[ˈmɪs.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (25483,'miser','a','miser miser miser','ass---mn1-=miserrimus',NULL,'[ˈmɪ.sɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (25487,'miseror','v','miser miserat -',NULL,NULL,'[ˈmɪ.sɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25492,'miseratio','n','miseration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25494,'misere','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25496,'miseria','n','miseri',NULL,NULL,'[mɪˈsɛ.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25498,'misericordia','n','misericordi',NULL,NULL,'[mɪ.sɛ.rɪˈkɔr.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25499,'misericors','a','misericord misericord misericord',NULL,NULL,'[mɪˈsɛ.rɪ.kɔrs]','aps---an3-');
INSERT INTO latin_morpho VALUES (25502,'missa','n','miss',NULL,NULL,'[ˈmɪs.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25503,'missus','n','miss',NULL,NULL,'[ˈmɪs.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25508,'missile','n','missil',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (25509,'missio','n','mission',NULL,NULL,'[ˈmɪs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25515,'mitis','a','mit mit mit',NULL,NULL,'[ˈmiː.tɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25519,'mitigo','v','mitig mitigav mitigat',NULL,NULL,'[ˈmiː.tɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25520,'mitra','n','mitr',NULL,NULL,'/ˈmiː.tra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25523,'mitto','v','mitt mis miss',NULL,NULL,'[ˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (25527,'mixtio','n','mixtion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25530,'mnemosynum','n','mnemosyn',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25534,'mobilis','a','mobil mobil mobil',NULL,NULL,'[ˈmoː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25536,'mobilitas','n','mobilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25537,'mobiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25538,'modus','n','mod',NULL,NULL,'[ˈmɔ.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25540,'modero','v','moder moderav moderat',NULL,NULL,'/ˈmo.de.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25541,'moderor','v','moder moderat -',NULL,NULL,'[ˈmɔ.dɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25543,'moderamen','n','moderamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (25544,'moderatus','a','moderat moderat moderat',NULL,NULL,'[mɔˈdɛ.ra.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25545,'moderatio','n','moderation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25546,'moderator','n','moderator',NULL,NULL,'[mɔ.dɛˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25549,'modernus','a','modern modern modern',NULL,NULL,'[mɔˈdɛr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25552,'modestus','a','modest modest modest',NULL,NULL,'[mɔˈdɛs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25553,'modestia','n','modesti',NULL,NULL,'[mɔˈdɛs.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25558,'modicus','a','modic modic modic',NULL,NULL,'[ˈmɔ.dɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25559,'modifico','v','modific modificav modificat',NULL,NULL,'[mɔˈdɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25562,'modo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25565,'modulor','v','modul modulat -',NULL,NULL,'[ˈmɔ.dʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25567,'modulate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25568,'modulatio','n','modulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25570,'modulator','n','modulator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25571,'moecha','n','moech',NULL,NULL,'/ˈmoe̯.kʰa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25572,'moechus','n','moech',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (25580,'mola','n','mol',NULL,NULL,'/ˈmo.la/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25587,'moles','n','mol',NULL,NULL,'[ˈmoː.ɫeːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (25588,'molesto','v','molest molestav molestat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25591,'molestia','n','molesti',NULL,NULL,'[mɔˈɫɛs.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25592,'molior','v','mol molit -',NULL,NULL,'[ˈmoː.li.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (25594,'molimentum','n','moliment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25595,'molinarius','n','molinari',NULL,NULL,'[mɔ.liːˈnaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25597,'molitio','n','molition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25598,'mollis','a','moll moll moll',NULL,NULL,'[ˈmɔl.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25600,'mollio','v','moll molliv mollit',NULL,NULL,'/ˈmol.li.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (25604,'molliter','r',NULL,NULL,NULL,'[ˈmɔl.lɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (25605,'mollitia','n','molliti',NULL,NULL,'/molˈli.ti.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25607,'mollitudo','n','mollitudin',NULL,NULL,'[mɔl.lɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25614,'momen','n','momin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (25615,'momentum','n','moment',NULL,NULL,'[moːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25619,'momentarius','a','momentari momentari momentari',NULL,NULL,'[moː.mɛnˈtaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25621,'moneo','v','mon monu monit',NULL,NULL,'[ˈmɔ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (25626,'monarchia','n','monarchi',NULL,NULL,'[mɔˈnar.kʰi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25628,'monasterium','n','monasteri',NULL,NULL,'[mɔ.nasˈteː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25632,'moneta','n','monet',NULL,NULL,'[mɔˈneː.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25638,'monile','n','monil',NULL,NULL,'[mɔˈniː.lɪs]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (25640,'monitus','n','monit',NULL,NULL,'/ˈmo.ni.tus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25641,'monitio','n','monition',NULL,NULL,'[mɔˈnɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25642,'monitor','n','monitor',NULL,NULL,'[ˈmɔ.nɪ.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25644,'monoceros','n','monocerot',NULL,NULL,'[mɔˈnɔ.kɛ.roːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25655,'monomachia','n','monomachi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25660,'monosyllabon','n','monosyllab',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25665,'mons','n','mont',NULL,NULL,'[mõːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (25666,'monstrum','n','monstr',NULL,NULL,'[ˈmõː.strũː]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25667,'monstro','v','monstr monstrav monstrat',NULL,NULL,'[ˈmõː.stroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25669,'monstrator','n','monstrator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25671,'monstrificus','a','monstrific monstrific monstrific',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (25674,'monstruosus','a','monstruos monstruos monstruos',NULL,NULL,'[mõː.strʊˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25682,'monumentum','n','monument',NULL,NULL,'[mɔ.nʊˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25683,'mora','n','mor',NULL,NULL,'[ˈmɔ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25685,'morum','n','mor',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25686,'moror','v','mor morat -',NULL,NULL,'/ˈmo.ror/','v1spid--1-');
INSERT INTO latin_morpho VALUES (25687,'moralis','a','moral moral moral',NULL,NULL,'[moːˈraː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25688,'moralitas','n','moralitat',NULL,NULL,'[moːˈraː.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25692,'morbus','n','morb',NULL,NULL,'[ˈmɔr.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25693,'morbidus','a','morbid morbid morbid',NULL,NULL,'[ˈmɔr.bɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25696,'morbosus','a','morbos morbos morbos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (25698,'mordeo','v','mord momord mors',NULL,NULL,'[ˈmɔr.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (25701,'mordax','a','mordac mordac mordac',NULL,NULL,'[ˈmɔr.daːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (25703,'mordicus','r',NULL,NULL,NULL,'[ˈmɔr.dɪ.kʊs]','rp--------');
INSERT INTO latin_morpho VALUES (25705,'morior','v','mor mortu -',NULL,NULL,'[ˈmɔ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (25710,'morio','n','morion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25713,'morositas','n','morositat',NULL,NULL,'[moːˈroː.sɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25716,'morsus','n','mors',NULL,NULL,'[ˈmɔr.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25717,'mors','n','mort',NULL,NULL,'[mɔrs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (25718,'mortalis','a','mortal mortal mortal',NULL,NULL,'[mɔrˈtaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25719,'mortalitas','n','mortalitat',NULL,NULL,'[mɔrˈtaː.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25720,'mortarium','n','mortari',NULL,NULL,'[mɔrˈtaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25724,'mortifico','v','mortific mortificav mortificat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25733,'mos','n','mor',NULL,NULL,'/moːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25735,'motus','n','mot',NULL,NULL,'[ˈmoː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25736,'moto','v','mot motav motat',NULL,NULL,'/ˈmoː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25738,'motio','n','motion',NULL,NULL,'/ˈmoː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25743,'moveo','v','mov mov mot',NULL,NULL,'[ˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (25744,'mox','r',NULL,NULL,NULL,'[mɔks]','rp--------');
INSERT INTO latin_morpho VALUES (25745,'mucus','n','muc',NULL,NULL,'[ˈmuː.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25746,'mucidus','a','mucid mucid mucid',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (25747,'mucinnium','n','mucinni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25749,'mucro','n','mucron',NULL,NULL,'[ˈmʊ.kroː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25750,'mugio','v','mug mugi mugit',NULL,NULL,'/ˈmuː.ɡi.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (25751,'mugil','n','mugil',NULL,NULL,'[ˈmuː.ɡɪɫ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25754,'mugitus','n','mugit',NULL,NULL,'[muːˈɡiː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25756,'mulus','n','mul',NULL,NULL,'[ˈmuː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25757,'mulco','v','mulc mulcav mulcat',NULL,NULL,'/ˈmul.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25758,'mulceo','v','mulc muls muls',NULL,NULL,'[ˈmʊɫ.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (25759,'Mulciber','n','Mulciber',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25771,'mulgeo','v','mulg mulx mulct',NULL,NULL,'[ˈmʊɫ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (25773,'muliebris','a','muliebr muliebr muliebr',NULL,NULL,'[mʊˈli.ɛ.brɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25774,'mulier','n','mulier',NULL,NULL,'[ˈmʊ.li.ɛr]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25780,'mulio','n','mulion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25781,'mullus','n','mull',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (25783,'multa','n','mult',NULL,'n-s---fn1-=mulcta',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25785,'multo','v','mult multav multat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25786,'multus','a','mult mult mult',NULL,NULL,'[ˈmʊɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25793,'multicavus','a','multicav multicav multicav',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (25809,'multiloquium','n','multiloqui',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25812,'multiplex','a','multiplic multiplic multiplic',NULL,NULL,'[ˈmʊɫ.tɪ.pɫɛks]','aps---an3i');
INSERT INTO latin_morpho VALUES (25814,'multiplico','v','multiplic multiplicav multiplicat',NULL,NULL,'[mʊɫˈtɪ.plɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25816,'multiplicatio','n','multiplication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25817,'multiplicator','n','multiplicator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25821,'multitudo','n','multitudin',NULL,NULL,'[mʊɫ.tɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25823,'multo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25825,'multum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (25827,'mundus','n','mund',NULL,NULL,'[ˈmʊn.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25828,'mundo','v','mund mundav mundat',NULL,NULL,'[ˈmʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25829,'mundus','a','mund mund mund',NULL,NULL,'[ˈmʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (25832,'mundialis','a','mundial mundial mundial',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (25835,'munditia','n','munditi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25837,'munero','v','muner munerav munerat',NULL,NULL,'/ˈmuː.ne.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25839,'munio','v','mun muni munit',NULL,NULL,'/ˈmuː.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (25849,'munificentia','n','munificenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25850,'munimen','n','munimin',NULL,NULL,'[muːˈniː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (25851,'munimentum','n','muniment',NULL,NULL,'[muː.niːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (25853,'munitio','n','munition',NULL,NULL,'/muːˈniː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (25856,'munus','n','muner',NULL,NULL,'[ˈmuː.nʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (25858,'murus','n','mur',NULL,NULL,'[ˈmuː.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25860,'muralis','a','mural mural mural',NULL,NULL,'[muːˈraː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25866,'muria','n','muri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25873,'murmur','n','murmur',NULL,NULL,'[ˈmʊr.mʊr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (25875,'murmuro','v','murmur murmurav murmurat',NULL,NULL,'[ˈmʊr.mʊ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25876,'murmuratio','n','murmuration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25877,'murra','n','murr',NULL,NULL,'[ˈmʊr.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25880,'mus','n','mur',NULL,NULL,'/muːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (25881,'musa','n','mus',NULL,NULL,'/ˈmuː.sa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25883,'musca','n','musc',NULL,NULL,'[ˈmʊs.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25884,'muscus','n','musc',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (25891,'musculus','n','muscul',NULL,NULL,'[ˈmuːs.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25894,'musica','n','music',NULL,NULL,'[ˈmuː.sɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25901,'musso','v','muss mussav mussat',NULL,NULL,'[ˈmʊs.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (25909,'mustella','n','mustell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25912,'muto','v','mut mutav mutat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25913,'mutabilis','a','mutabil mutabil mutabil',NULL,NULL,'[muːˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (25914,'mutabilitas','n','mutabilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25916,'mutatio','n','mutation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25919,'mutilo','v','mutil mutilav mutilat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (25921,'muto','n','muton',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (25922,'muttio','v','mutt muttiv muttit',NULL,NULL,'[ˈmʊt.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (25927,'mutuor','v','mutu mutuat -',NULL,NULL,'[ˈmuː.tʊ.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (25930,'mutulus','n','mutul',NULL,NULL,'[ˈmuː.tʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25942,'myrica','n','myric',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25949,'myrrha','n','myrrh',NULL,'n-s---fn1-=murra n-s---fn1-=myrra',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (25950,'myrtus','n','myrt',NULL,NULL,'[ˈmʏr.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25959,'mysterium','n','mysteri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25964,'no','v','n nav nat',NULL,NULL,'/noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25965,'neo','v','n nev net',NULL,NULL,'/ˈne.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (25973,'Naias','n','Naiad',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (25977,'nanus','n','nan',NULL,NULL,'[ˈnaː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (25978,'nanciscor','v','nancisc nanct -',NULL,NULL,'[naŋˈkiːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (25980,'naphtha','n','naphth',NULL,NULL,'/ˈnapʰ.tʰa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (25982,'narcissus','n','narciss',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (25988,'nardum','n','nard',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (25992,'naris','n','nar',NULL,NULL,'[ˈnaː.rɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (25993,'narro','v','narr narrav narrat',NULL,NULL,'/ˈnar.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (25995,'narratus','n','narrat',NULL,NULL,'[naːrˈraː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (25996,'narratio','n','narration',NULL,NULL,'/naːrˈraː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26004,'nasus','n','nas',NULL,NULL,'[ˈnaː.sʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26006,'nascor','v','nasc nat -',NULL,NULL,'[ˈnaːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (26008,'nassa','n','nass',NULL,NULL,'/ˈnas.sa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26012,'nata','n','nat',NULL,NULL,'/ˈnaː.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26015,'natus','a','nat nat nat',NULL,NULL,'[ˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26016,'nato','v','nat natav natat',NULL,NULL,'/ˈna.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (26021,'natatus','n','natat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (26024,'natator','n','natator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (26025,'natio','n','nation',NULL,NULL,'/ˈnaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26029,'natis','n','nat',NULL,NULL,'[ˈna.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (26030,'nativus','a','nativ nativ nativ',NULL,NULL,'[naːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26031,'nativitas','n','nativitat',NULL,NULL,'[naːˈtiː.wɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26033,'natura','n','natur',NULL,NULL,'/naːˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26035,'naturalis','a','natural natural natural',NULL,NULL,'/naː.tuːˈraː.lis/','aps---cn3i');
INSERT INTO latin_morpho VALUES (26050,'naufragium','n','naufragi',NULL,NULL,'[nau̯ˈfra.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26052,'nausea','n','nause',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26057,'nauta','n','naut',NULL,NULL,'/ˈnau̯.ta/','n-s---mn1-');
INSERT INTO latin_morpho VALUES (26059,'nauticus','a','nautic nautic nautic',NULL,NULL,'[ˈnau̯.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26062,'navalis','a','naval naval naval',NULL,NULL,'[naːˈwaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (26069,'navigo','v','navig navigav navigat',NULL,NULL,'[ˈnaː.wɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26071,'navigatio','n','navigation',NULL,NULL,'/naː.wiˈɡaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26073,'navigium','n','navigi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26074,'navis','n','nav',NULL,NULL,'[ˈnaː.wɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (26075,'navita','n','navit',NULL,NULL,'[ˈnaː.wɪ.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (26076,'naviter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26086,'Nazarenus','a','Nazaren Nazaren Nazaren',NULL,NULL,'na.zaˈreː.nʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (26091,'ne','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26095,'nebula','n','nebul',NULL,NULL,'[ˈnɛ.bʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26098,'nec','r',NULL,NULL,NULL,'[nɛk]','rp--------');
INSERT INTO latin_morpho VALUES (26100,'neco','v','nec necav necat',NULL,NULL,'[ˈnɛ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26104,'necessaria','n','necessari',NULL,NULL,NULL,'n-p---nn2-');
INSERT INTO latin_morpho VALUES (26106,'necessarius','n','necessari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (26107,'necessarius','a','necessari necessari necessari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (26108,'necessarie','r',NULL,NULL,'rp--------=necessario',NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26110,'necesse','a',NULL,NULL,NULL,'[nɛˈkɛs.sɛ]','aps---nn--');
INSERT INTO latin_morpho VALUES (26112,'necessitas','n','necessitat',NULL,NULL,'[nɛˈkɛs.sɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26113,'necessitudo','n','necessitudin',NULL,NULL,'[nɛ.kɛs.sɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26124,'necopinus','a','necopin necopin necopin',NULL,NULL,'[nɛ.kɔˈpiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26126,'necopinatus','a','necopinat necopinat necopinat',NULL,NULL,'[nɛ.kɔ.piːˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26131,'necto','v','nect nex nex',NULL,NULL,'/ˈnek.toː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (26132,'nectar','n','nectar',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (26137,'nefandus','a','nefand nefand nefand',NULL,NULL,'[nɛˈfan.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26142,'nego','v','neg negav negat',NULL,NULL,'[ˈnɛ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26143,'negatio','n','negation',NULL,NULL,'[nɛˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26146,'negator','n','negator',NULL,NULL,'[nɛˈɡaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (26149,'neglectus','n','neglect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (26152,'neglego','v','negleg neglex neglect',NULL,NULL,'[ˈnɛ.ɡɫɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26153,'neglegens','a','neglegent neglegent neglegent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (26155,'neglegentia','n','neglegenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26159,'negotium','n','negoti',NULL,NULL,'/neˈɡoː.ti.um/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26162,'negotiatio','n','negotiation',NULL,NULL,'[nɛ.ɡoː.tɪˈaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26173,'nemus','n','nemor',NULL,NULL,'[ˈnɛ.mʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (26178,'neomenia','n','neomeni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26180,'neophytus','n','neophyt',NULL,NULL,'[nɛˈɔ.pʰʏ.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26183,'nepa','n','nep',NULL,NULL,'[ˈnɛ.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26185,'nepos','n','nepot',NULL,NULL,'[ˈnɛ.poːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (26187,'Neptunus','n','Neptun',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (26188,'nequam','a',NULL,NULL,NULL,'[ˈneː.kʷã]','aps---cn3-');
INSERT INTO latin_morpho VALUES (26197,'nequiquam','r',NULL,NULL,'rp--------=necquicquam rp--------=nequidquam rp--------=nequicquam','[neːˈkᶣiː.kʷã]','rp--------');
INSERT INTO latin_morpho VALUES (26200,'nequiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26201,'nequitia','n','nequiti',NULL,NULL,'[neːˈkᶣɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26203,'Nero','n','Neron',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (26205,'nervus','n','nerv',NULL,NULL,'[ˈnɛr.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26211,'nescius','a','nesci nesci nesci',NULL,NULL,'[ˈnɛs.ki.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26226,'nex','n','nec',NULL,NULL,'[nɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26241,'nidus','n','nid',NULL,NULL,'[ˈniː.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26245,'nidor','n','nidor',NULL,NULL,'[ˈniː.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (26248,'niger','a','nigr nigr nigr',NULL,NULL,'[ˈnɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (26258,'nihil','n','nihil','n-s---ng2-=nihili n-s---nd2-=nihilo n-s---nb2-=nihilo','n-s---nn--=nil n-s---na--=nil n-s---nn2-=nihilum n-s---na2-=nihilum','[ˈnɪ.hɪɫ]','n-s---nn--');
INSERT INTO latin_morpho VALUES (26267,'nimbus','n','nimb',NULL,NULL,'[ˈnɪm.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26271,'nimietas','n','nimietat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26273,'nimirum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26274,'nimis','r',NULL,NULL,NULL,'[ˈnɪ.mɪs]','rp--------');
INSERT INTO latin_morpho VALUES (26275,'nimium','r',NULL,NULL,NULL,'[ˈnɪ.mi.ũ]','rp--------');
INSERT INTO latin_morpho VALUES (26283,'ninguis','n','ningu',NULL,NULL,'[ˈnɪŋ.ɡᶣɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (26288,'nisus','n','nis',NULL,NULL,'[ˈniː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (26291,'niteo','v','nit - -',NULL,NULL,'[ˈnɪ.te.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (26292,'nitor','v','nit nix -',NULL,NULL,'[ˈniː.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (26298,'nitor','n','nitor',NULL,NULL,'[ˈniː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (26305,'nix','n','niv',NULL,NULL,'[nɪks]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (26306,'nixus','n','nix',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (26307,'nixor','v','nix nixat -',NULL,NULL,'/ˈniːk.sor/','v1spid--1-');
INSERT INTO latin_morpho VALUES (26311,'nobilitas','n','nobilitat',NULL,NULL,'[noːˈbɪ.lɪ.tas]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26314,'nocivus','a','nociv nociv nociv',NULL,NULL,'[nɔˈkiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26316,'noctiluca','n','noctiluc',NULL,NULL,'[nɔk.tɪˈɫuː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26319,'noctua','n','noctu',NULL,NULL,'[ˈnɔk.tʊ.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26325,'nodus','n','nod',NULL,NULL,'[ˈnoː.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26330,'nomas','n','nomad',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (26331,'nomen','n','nomin',NULL,NULL,'[ˈnoː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (26333,'nomenclatura','n','nomenclatur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26335,'nomino','v','nomin nominav nominat',NULL,NULL,'/ˈnoː.mi.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (26338,'nominatio','n','nomination',NULL,NULL,'[noː.mɪˈnaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26339,'nominativus','a','nominativ nominativ nominativ',NULL,NULL,'[noː.mɪ.naːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26342,'nominito','v','nominit nominitav nominitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (26343,'nomisma','n','nomismat',NULL,NULL,'[nɔˈmɪs.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (26345,'non','r',NULL,NULL,NULL,'/noːn/','rp--------');
INSERT INTO latin_morpho VALUES (26363,'nonnumquam','r',NULL,NULL,NULL,'[noːnˈnʊŋ.kʷã]','rp--------');
INSERT INTO latin_morpho VALUES (26365,'norma','n','norm',NULL,NULL,'/ˈnoːr.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26367,'nosco','v','nosc nov not',NULL,NULL,'/ˈnoːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (26370,'nosocomium','n','nosocomi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26374,'nota','n','not',NULL,NULL,'[ˈnɔ.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26377,'noto','v','not notav notat',NULL,NULL,'/ˈno.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (26378,'notus','a','not not not',NULL,NULL,'[ˈnoː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26383,'notarius','n','notari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (26387,'nothus','a','noth noth noth',NULL,NULL,'[ˈnɔ.tʰʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26392,'notitia','n','notiti',NULL,NULL,'/noːˈti.ti.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26395,'novo','v','nov novav novat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (26396,'novus','a','nov nov nov',NULL,NULL,'[ˈnɔ.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26397,'novacula','n','novacul',NULL,NULL,'[nɔˈwaː.kʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26399,'novale','n','noval',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (26412,'noverca','n','noverc',NULL,NULL,'[nɔˈwɛr.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26414,'novicius','a','novici novici novici',NULL,NULL,'[nɔˈwiː.ki.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26416,'novilunium','n','noviluni',NULL,NULL,'[nɔ.wɪˈɫuː.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26420,'novissime','r',NULL,NULL,NULL,NULL,'rs--------');
INSERT INTO latin_morpho VALUES (26421,'novitas','n','novitat',NULL,NULL,'/ˈno.wi.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26422,'noviter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26427,'nox','n','noct',NULL,NULL,'[nɔks]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (26428,'noxa','n','nox',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26430,'noxia','n','noxi',NULL,NULL,'/ˈnok.si.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26431,'noxius','a','noxi noxi noxi',NULL,NULL,'[ˈnɔk.si.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26432,'noxiosus','a','noxios noxios noxios',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (26435,'nubo','v','nub nups nupt',NULL,NULL,'/ˈnuː.boː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (26438,'nubes','n','nub',NULL,NULL,'/ˈnuː.beːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (26442,'nubilus','a','nubil nubil nubil',NULL,NULL,'[ˈnuː.bɪ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26444,'nubilosus','a','nubilos nubilos nubilos',NULL,NULL,'[nuː.bɪˈɫoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26448,'nucifrangibulum','n','nucifrangibul',NULL,NULL,'[nʊ.kɪ.fraŋˈɡɪ.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26449,'nucleus','n','nucleus',NULL,NULL,'[ˈnʊ.kɫe.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26451,'nudus','a','nud nud nud',NULL,NULL,'[ˈnuː.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26452,'nudo','v','nud nudav nudat',NULL,NULL,'/ˈnuː.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (26453,'nuditas','n','nuditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26471,'numen','n','numin',NULL,NULL,'[ˈnuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (26472,'numerus','n','numer',NULL,NULL,'[ˈnʊ.mɛ.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26474,'numero','v','numer numerav numerat',NULL,NULL,'[ˈnʊ.mɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26477,'numeratio','n','numeration',NULL,NULL,'[nʊ.mɛˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26480,'numero','r',NULL,NULL,NULL,'[ˈnʊ.mɛ.roː]','rp--------');
INSERT INTO latin_morpho VALUES (26481,'numerosus','a','numeros numeros numeros',NULL,NULL,'[nʊ.mɛˈroː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26483,'numerositas','n','numerositat',NULL,NULL,'[nʊ.mɛˈroː.sɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26485,'nummus','n','numm',NULL,NULL,'[ˈnʊm.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26506,'nuncupo','v','nuncup nuncupav nuncupat',NULL,NULL,'[ˈnuːŋ.kʊ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26507,'nuncupatio','n','nuncupation',NULL,NULL,'[nuːŋ.kʊˈpaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26517,'nuntius','n','nunti',NULL,NULL,'[ˈnuːn.ti.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26518,'nuntium','n','nunti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26520,'nuntio','v','nunti nuntiav nuntiat',NULL,NULL,'/ˈnuːn.ti.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (26521,'nuntiatio','n','nuntiation',NULL,'n-s---fn3-=nunciatio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26525,'nuper','r',NULL,NULL,NULL,'[ˈnuː.pɛr]','rp--------');
INSERT INTO latin_morpho VALUES (26531,'nutus','n','nut',NULL,NULL,'[ˈnuː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (26532,'nuto','v','nut nutav nutat',NULL,NULL,'/ˈnuː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (26536,'nutrio','v','nutr nutriv nutrit',NULL,NULL,'/ˈnuː.tri.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (26539,'nutrico','v','nutric nutricav nutricat',NULL,NULL,'/nuːˈtriː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (26544,'nutrimen','n','nutrimin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (26546,'nutrimentum','n','nutriment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26554,'nympha','n','nymph',NULL,NULL,'[ˈnʏm.pʰa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26562,'obarmo','v','obarm obarmav obarmat',NULL,NULL,'[ɔˈbar.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26565,'obdo','v','obd obdid obdit',NULL,NULL,'[ˈɔb.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26567,'obdormisco','v','obdormisc obdormiv obdormit',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (26568,'obduco','v','obduc obdux obduct',NULL,NULL,'[ɔbˈduː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26571,'obductio','n','obduction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26572,'obduro','v','obdur obdurav obdurat',NULL,NULL,'[ɔbˈduː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26574,'obeo','v','ob obiv obit','v2spia--4-=obis v3spia--4-=obit v1ppia--4-=obimus v2ppia--4-=obitis v3ppia--4-=obeunt v1siia--4-=obibam v2siia--4-=obibas v3siia--4-=obibat v1piia--4-=obibamus v2piia--4-=obibatis v3piia--4-=obibant v1sfia--4-=obibo v2sfia--4-=obibis v3sfia--4-=obibit v1pfia--4-=obibimus v2pfia--4-=obibitis v3pfia--4-=obibunt v-sppamn4-=obiens v-sppafn4-=obiens v-sppann4-=obiens v-sfpamn4-=obiturus v-sfpafn4-=obitura v-sfpann4-=obiturum v-sfppmn4-=obeundus v-sfppfn4-=obeunda v-sfppnn4-=obeundum v-s-gang4-=obeundi v-s-damn4-=obeundus v-s-dafn4-=obeunda v-s-dann4-=obeundum',NULL,'[ˈɔ.be.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (26581,'obeliscus','n','obelisc',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (26583,'obesus','a','obes obes obes',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (26584,'obex','n','obic',NULL,NULL,'[ˈoː.bɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (26590,'obicio','v','obic obiec obiect',NULL,NULL,'[ɔbˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (26591,'obitus','n','obit',NULL,NULL,'[ˈɔ.bɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (26592,'obiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26612,'oblatio','n','oblation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26615,'oblecto','v','oblect oblectav oblectat',NULL,NULL,'[ɔˈbɫɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26616,'oblectamen','n','oblectamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (26617,'oblectamentum','n','oblectament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26619,'oblido','v','oblid oblis oblis',NULL,NULL,'[ɔˈbliː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26620,'obligo','v','oblig obligav obligat',NULL,NULL,'[ˈɔ.blɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26622,'obligatio','n','obligation',NULL,NULL,'[ɔ.blɪˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26625,'obliquus','a','obliqu obliqu obliqu',NULL,NULL,'[ɔˈbliː.kʷʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26629,'oblittero','v','oblitter oblitterav oblitterat',NULL,NULL,'[ɔˈblɪt.tɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26631,'oblivium','n','oblivi',NULL,NULL,'[ɔˈbliː.wi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26632,'oblivio','n','oblivion',NULL,NULL,'[ɔˈbliː.wi.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26633,'obliviosus','a','oblivios oblivios oblivios',NULL,NULL,'[ɔ.bliː.wɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26634,'obliviscor','v','oblivisc oblit -',NULL,NULL,'[ɔ.bliːˈwɪs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (26637,'obloquor','v','obloqu oblocut -',NULL,NULL,'[ˈɔ.bɫɔ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (26639,'obmolior','v','obmol obmolit -',NULL,NULL,NULL,'v1spid--4-');
INSERT INTO latin_morpho VALUES (26644,'obnixus','a','obnix obnix obnix',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (26647,'obnoxius','a','obnoxi obnoxi obnoxi',NULL,NULL,'[ɔbˈnɔk.si.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26650,'obnubo','v','obnub obnups obnupt',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (26651,'obnubilo','v','obnubil obnubilav obnubilat',NULL,NULL,'[ɔbˈnuː.bɪ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26657,'oboediens','a','oboedient oboedient oboedient',NULL,NULL,'[ɔˈboe̯.di.ẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (26658,'oboedientia','n','oboedienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26663,'oborior','v','obor obort -',NULL,NULL,'[ɔˈbɔ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (26670,'obrigesco','v','obrigesc obrigu -',NULL,NULL,'[ɔ.brɪˈɡeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26674,'obruo','v','obru obru obrut',NULL,NULL,'[ˈɔ.brʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26681,'obsum','v','ob obfu -','v--pna--3-=obesse v1spia--3-=obsum v2spia--3-=obes v3spia--3-=obest v1ppia--3-=obsumus v2ppia--3-=obestis v3ppia--3-=obsunt',NULL,'[ˈɔ.psũ]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26683,'obsaepio','v','obsaep obsaeps obsaept',NULL,NULL,'[ɔˈpsae̯.pi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (26692,'obscenus','a','obscen obscen obscen',NULL,NULL,'[ɔpˈskeː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26693,'obscene','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26694,'obscenitas','n','obscenitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26695,'obscuro','v','obscur obscurav obscurat',NULL,NULL,'[ɔpˈskuː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26696,'obscurus','a','obscur obscur obscur',NULL,NULL,'[ɔpˈskuː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26698,'obscuritas','n','obscuritat',NULL,NULL,'[ɔpˈskuː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26699,'obsecro','v','obsecr obsecrav obsecrat',NULL,NULL,'[ˈɔ.psɛ.kroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26700,'obsecratio','n','obsecration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26705,'obsequens','a','obsequent obsequent obsequent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (26708,'obsequium','n','obsequi',NULL,NULL,'[ɔˈpsɛ.kᶣi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26710,'obsero','v','obser obserav obserat',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (26712,'observo','v','observ observav observat',NULL,NULL,'[ɔˈpsɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26713,'observatio','n','observation',NULL,NULL,'[ɔ.psɛrˈwaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26716,'obses','n','obsid',NULL,NULL,'[ˈɔ.psɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (26717,'obsessio','n','obsession',NULL,NULL,'[ɔˈpsɛs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26718,'obsessor','n','obsessor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (26723,'obsideo','v','obsid obsed obsess',NULL,NULL,'[ɔˈpsɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (26724,'obsido','v','obsid obsed obsess',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (26725,'obsidium','n','obsidi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26727,'obsidio','n','obsidion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26729,'obsigno','v','obsign obsignav obsignat',NULL,NULL,'[ɔˈpsɪŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26736,'obsono','v','obson obsonav obsonat',NULL,'v1spia--1-=opsono v--pna--1-=opsonare v-srppmn1-=opsonatus','[ɔˈpsoː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26740,'obsonium','n','obsoni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26743,'obstaculum','n','obstacul',NULL,NULL,'[ɔpˈstaː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26744,'obstantia','n','obstanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26749,'obstetrix','n','obstetric',NULL,NULL,'[ɔpˈsteː.triːks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26751,'obstinatus','a','obstinat obstinat obstinat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (26752,'obstinate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (26753,'obstinatio','n','obstination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26758,'obstringo','v','obstring obstrinx obstrict',NULL,NULL,'[ɔpˈstrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26759,'obstruo','v','obstru obstrux obstruct',NULL,NULL,'[ˈɔp.strʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26761,'obstupefacio','v','obstupefac obstupefec obstupefact',NULL,NULL,'[ɔp.stʊ.pɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (26767,'obtego','v','obteg obtex obtect',NULL,NULL,'[ˈɔp.tɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26770,'obtendo','v','obtend obtend obtent',NULL,NULL,'[ɔpˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26771,'obtenebro','v','obtenebr obtenebrav obtenebra',NULL,NULL,'[ɔpˈtɛ.nɛ.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26774,'obtentus','n','obtent',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (26775,'obtero','v','obter obtriv obtrit',NULL,NULL,'[ˈɔp.tɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26776,'obtestor','v','obtest obtestat -',NULL,NULL,'[ɔpˈtɛs.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (26777,'obtestatio','n','obtestation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26778,'obtexo','v','obtex obtexu obtext',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (26781,'obtineo','v','obtin obtinu obtent',NULL,NULL,'[ɔpˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (26782,'obtingo','v','obting obtig -',NULL,NULL,'[ɔpˈtɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26786,'obtrectatio','n','obtrectation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26787,'obtrectator','n','obtrectator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (26788,'obtrunco','v','obtrunc obtruncav obtruncat',NULL,NULL,'[ɔpˈtrʊŋ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26790,'obtundo','v','obt obt obt',NULL,NULL,'[ɔpˈtʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26792,'obturo','v','obtur obturav obturat',NULL,NULL,'[ɔpˈtuː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26794,'obtusus','a','obtus obtus obtus',NULL,NULL,'[ɔpˈtuː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26796,'obumbro','v','obumbr obumbrav obumbrat',NULL,NULL,'[ɔˈbʊm.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26806,'obvio','v','obvi obviav obviat',NULL,NULL,'[ˈɔb.wi.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26808,'obvolvo','v','obvolv obvolv obvolut',NULL,NULL,'[ɔbˈwɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26811,'occaeco','v','occaec occaecav occaecat',NULL,NULL,'[ɔkˈkae̯.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26815,'occasio','n','occasion',NULL,NULL,'[ɔkˈkaː.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (26822,'occido','v','occid - -',NULL,NULL,'[ˈɔk.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26827,'occidio','n','occidion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26830,'occipio','v','occip occep occept',NULL,NULL,'[ɔkˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (26831,'occipitium','n','occipiti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26833,'occisio','n','occision',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26838,'occulo','v','occul occulu occult',NULL,NULL,'[ˈɔk.kʊ.ɫoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26841,'occulto','v','occult occultav occultat',NULL,NULL,'[ɔkˈkʊɫ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26843,'occultatio','n','occultation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26847,'occupo','v','occup occupav occupat',NULL,NULL,'[ˈɔk.kʊ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26849,'occupatio','n','occupation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (26853,'occursus','n','occurs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (26855,'Oceanus','n','ocean',NULL,NULL,'[oːˈke.a.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26857,'ocellus','n','ocell',NULL,NULL,'[ɔˈkɛl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26862,'ocimum','n','ocim',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26865,'ocrea','n','ocre',NULL,NULL,'[ˈɔ.kre.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26893,'oculus','n','ocul',NULL,NULL,'[ˈɔ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (26894,'oculatus','a','oculat oculat oculat',NULL,NULL,'[ɔ.kʊˈɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26896,'odio','v','od od -',NULL,NULL,'[ˈɔ.di.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (26897,'odium','n','odi',NULL,NULL,'[ˈɔ.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26898,'odibilis','a','odibil odibil odibil',NULL,NULL,'[ɔˈdɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (26904,'odor','n','odor',NULL,NULL,'[ˈɔ.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (26905,'odorus','a','odor odor odor',NULL,NULL,'[ɔˈdoː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26906,'odoro','v','odor odorav odorat',NULL,NULL,'[ɔˈdoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26908,'odoramen','n','odoramin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (26909,'odoramentum','n','odorament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26910,'odoratus','a','odorat odorat odorat',NULL,NULL,'[ɔ.doːˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26913,'odorifer','a','odorifer odorifer odorifer',NULL,NULL,'[ɔˈdoː.rɪ.fɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (26918,'oeconomia','n','oeconomi',NULL,NULL,'[oe̯.kɔˈnɔ.mi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26919,'oeconomicus','a','oeconomic oeconomic oeconomic',NULL,NULL,'[oe̯.kɔˈnɔ.mɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26929,'ofella','n','ofell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26931,'offendo','v','offend offend offens',NULL,NULL,'[ɔfˈfɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (26932,'offendiculum','n','offendicul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26933,'offensa','n','offens',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26935,'offensus','n','offens',NULL,NULL,'[ɔfˈfẽː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (26936,'offenso','v','offens offensav offensat',NULL,NULL,'[ɔfˈfẽː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26940,'offero','v','offer offerav offerat','v--pna--3-=offerre v2spia--3-=offers v3spia--3-=offert v2ppia--3-=offertis',NULL,'[ˈɔf.fɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26944,'offertorium','n','offertori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (26947,'officium','n','offici',NULL,NULL,'[ɔfˈfɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26952,'officina','n','officin',NULL,NULL,'[ɔf.fɪˈkiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26953,'officiosus','a','officios officios officios',NULL,NULL,'[ɔf.fɪ.kɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (26955,'offirmo','v','offirm offirmav offirmat',NULL,NULL,'[ɔfˈfɪr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26958,'offoco','v','offoc offocav offocat',NULL,NULL,'[ɔfˈfoː.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (26962,'offucia','n','offuci',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (26975,'olea','n','ole',NULL,NULL,'[ˈɔ.ɫe.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (26976,'oleum','n','ole',NULL,NULL,'[ˈɔ.ɫe.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (26987,'olfacio','v','olfac olfec olfact',NULL,NULL,'[ɔɫˈfa.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (26988,'olfacto','v','olfact olfactav olfactat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (26999,'oliva','n','oliv',NULL,NULL,'[ɔˈliː.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27005,'olla','n','oll',NULL,NULL,'[ˈɔl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27008,'olor','n','olor',NULL,NULL,'[ˈɔ.ɫɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27015,'omega','n',NULL,NULL,NULL,NULL,'n-s---nn--');
INSERT INTO latin_morpho VALUES (27016,'omen','n','omin',NULL,NULL,'[ˈoː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (27017,'omentum','n','oment',NULL,NULL,'[oːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27018,'ominor','v','omin ominat -',NULL,NULL,'[ˈoː.mɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (27021,'omitto','v','omitt omis omiss',NULL,NULL,'[ɔˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27022,'omnis','a','omn omn omn',NULL,NULL,'[ˈɔm.nɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (27031,'omnino','r',NULL,NULL,NULL,'[ɔmˈniː.noː]','rp--------');
INSERT INTO latin_morpho VALUES (27034,'omnipotentia','n','omnipotenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27043,'onero','v','oner onerav onerat',NULL,NULL,'[ˈɔ.nɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27047,'onocrotalus','n','onocrotal',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (27049,'onus','n','oner',NULL,NULL,'[ˈɔ.nʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (27056,'opaco','v','opac opacav opacat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (27058,'opera','n','oper',NULL,NULL,'[ˈɔ.pɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27060,'operor','v','oper operat -',NULL,NULL,'[ˈɔ.pɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (27064,'operatio','n','operation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27068,'operculum','n','opercul',NULL,NULL,'[ɔˈpɛr.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27069,'operio','v','oper operu opert',NULL,NULL,'[ɔˈpɛ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (27070,'operimentum','n','operiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27081,'opium','n','opi',NULL,NULL,'[ˈɔ.pi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27084,'opifex','n','opific',NULL,NULL,'[ˈɔ.pɪ.fɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27085,'opilio','n','opilion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (27086,'opimus','a','opim opim opim',NULL,NULL,'[ɔˈpiː.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27087,'opinor','v','opin opinat -',NULL,NULL,'[ɔˈpiː.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (27090,'opinio','n','opinion',NULL,NULL,'[ɔˈpiː.ni.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27094,'opipare','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27097,'opitulor','v','opitul opitulat -',NULL,NULL,'[ɔˈpɪ.tʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (27109,'oppansum','n','oppans',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27112,'opperior','v','opper oppert -',NULL,NULL,'[ɔpˈpɛ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (27113,'oppeto','v','oppet oppetiv oppetit',NULL,NULL,'[ˈɔp.pɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27118,'oppido','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27119,'oppidulum','n','oppidul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27120,'oppilo','v','oppil oppilav oppilat',NULL,NULL,'[ɔpˈpiː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27121,'oppleo','v','oppl opplev opplet',NULL,NULL,'[ˈɔp.pɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (27122,'oppono','v','oppon opposu opposit',NULL,NULL,'[ɔpˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27123,'opportunus','a','opportun opportun opportun',NULL,NULL,'[ɔp.pɔrˈtuː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27124,'opportune','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27126,'opportunitas','n','opportunitat',NULL,NULL,'[ɔp.pɔrˈtuː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27130,'oppressio','n','oppression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27131,'opprimo','v','opprim oppress oppress',NULL,NULL,'[ˈɔp.prɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27133,'opprobrium','n','opprobri',NULL,NULL,'[ɔpˈprɔ.bri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27134,'oppugno','v','oppugn oppugnav oppugnat',NULL,NULL,'[ɔpˈpʊŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27135,'oppugnatio','n','oppugnation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27136,'oppugnator','n','oppugnator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (27140,'ops','n','op',NULL,NULL,'[ɔps]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27164,'opto','v','opt optav optat',NULL,NULL,'[ˈɔp.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27165,'optabilis','a','optabil optabil optabil',NULL,NULL,'[ɔpˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (27167,'optatus','a','optat optat optat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (27168,'optatio','n','optation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27179,'optio','n','option',NULL,NULL,'[ˈɔp.ti.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27186,'opulente','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27187,'opulentia','n','opulenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27189,'opus','n','opunt',NULL,NULL,'[ˈɔ.pʊs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (27191,'ora','n','or',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27192,'oro','v','or orav orat',NULL,NULL,'/ˈoː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27195,'oraculum','n','oracul',NULL,NULL,'[oːˈraː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27197,'orarium','n','orari',NULL,NULL,'[oːˈraː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27200,'oratio','n','oration',NULL,NULL,'/oːˈraː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27202,'orator','n','orator',NULL,NULL,'[oːˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27207,'orbo','v','orb orbav orbat',NULL,NULL,'[ˈɔr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27209,'orbiculus','n','orbicul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (27211,'orbiculatus','a','orbiculat orbiculat orbiculat',NULL,NULL,'[ɔr.bɪ.kʊˈɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27212,'orbis','n','orb',NULL,NULL,'[ˈɔr.bɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (27213,'orbita','n','orbit',NULL,NULL,'[ˈɔr.bɪ.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27217,'Orcus','n','Orc',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (27227,'ordior','v','ord ors -',NULL,NULL,'[ˈoːr.di.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (27231,'ordino','v','ordin ordinav ordinat',NULL,NULL,'[ˈoːr.dɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27234,'ordinarius','a','ordinari ordinari ordinari',NULL,NULL,'[oːr.dɪˈnaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27236,'ordinate','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27243,'ordo','n','ordin',NULL,NULL,'/ˈoːr.doː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27244,'orestes','n','orest',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (27246,'orexis','n','orex',NULL,NULL,'[ɔˈrɛk.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (27248,'organum','n','organ',NULL,NULL,'[ˈɔr.ɡa.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27252,'organicus','a','organic organic organic',NULL,NULL,'[ɔrˈɡa.nɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27262,'orior','v','or ort -',NULL,NULL,'[ˈɔ.ri.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (27265,'orichalcum','n','orichalc',NULL,NULL,'[ɔ.riːˈkʰaɫ.kũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27271,'oriens','n','orient',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (27275,'orificium','n','orifici',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27277,'origanum','n','origan',NULL,NULL,'[ɔˈriː.ɡa.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27278,'originalis','a','original original original',NULL,NULL,'[ɔ.riː.ɡɪˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (27279,'origo','n','origin',NULL,NULL,'[ɔˈriː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27282,'orno','v','orn ornav ornat',NULL,NULL,'/ˈoːr.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27283,'ornamentum','n','ornament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27291,'orphanus','n','orphan',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (27292,'orphanotrophium','n','orphanotrophi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27294,'orsus','n','ors',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (27295,'ortus','n','ort',NULL,NULL,'[ˈɔr.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (27300,'orthodoxus','a','orthodox orthodox orthodox',NULL,NULL,'[ɔr.tʰɔˈdɔk.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27303,'orthographia','n','orthographi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27312,'oryza','n','oryz',NULL,NULL,'[ɔˈryː.za]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27313,'os','n','oss',NULL,NULL,'/oːs/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (27319,'oscillum','n','oscill',NULL,NULL,'[oːsˈkɪl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27323,'oscito','v','oscit oscitav oscitat',NULL,NULL,'[ˈoːs.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27326,'osculum','n','oscul',NULL,NULL,'[ˈoːs.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27327,'osculor','v','oscul osculat -',NULL,NULL,'[ˈoːs.kʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (27339,'ostendo','v','ostend ostend ostent',NULL,NULL,'[ɔsˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27343,'ostentum','n','ostent',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27345,'ostento','v','ostent ostentav ostentat',NULL,NULL,'[ɔsˈtɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27346,'ostentatio','n','ostentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27364,'otium','n','oti',NULL,NULL,'[ˈoː.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27371,'ovum','n','ov',NULL,NULL,'[ˈoː.wũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27372,'ovo','v','ov ovav ovat',NULL,NULL,'[ˈɔ.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27377,'ovile','n','ovil',NULL,NULL,'[ɔˈwiː.ɫɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (27379,'ovis','n','ov',NULL,NULL,'[ˈɔ.wɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (27391,'pabillus','n','pabill',NULL,NULL,'/paˈbil.lus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27392,'pabulum','n','pabul',NULL,NULL,'[ˈpaː.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27396,'paco','v','pac pacav pacat',NULL,NULL,'/ˈpaː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27399,'pacatus','a','pacat pacat pacat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (27413,'paciscor','v','pacisc pact -',NULL,NULL,'[paːˈkɪs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (27414,'pactum','n','pact',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27416,'pactio','n','paction',NULL,NULL,'/ˈpak.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27421,'paedagogus','n','paedagog',NULL,NULL,'[pae̯.daˈɡoː.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27430,'paedicator','n','paedicator',NULL,NULL,'[pae̯.diːˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27433,'paedor','n','paedor',NULL,NULL,'[ˈpae̯.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27434,'paelex','n','paelic',NULL,NULL,'[ˈpae̯.ɫɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27435,'paene','r',NULL,NULL,NULL,'[ˈpae̯.nɛ]','rp--------');
INSERT INTO latin_morpho VALUES (27436,'paeninsula','n','paeninsul',NULL,NULL,'[pae̯ˈnĩː.sʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27439,'paenitentia','n','paenitenti',NULL,NULL,'[pae̯.nɪˈtɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27449,'pagus','n','pag',NULL,NULL,'[ˈpaː.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27452,'paganus','a','pagan pagan pagan',NULL,NULL,'/paːˈɡaː.nus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (27455,'paganitas','n','paganitat',NULL,NULL,'/paːˈɡaː.ni.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27460,'pagina','n','pagin',NULL,NULL,'[ˈpaː.ɡɪ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27462,'pala','n','pal',NULL,NULL,'[ˈpaː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27465,'palor','v','pal palat -',NULL,NULL,'[ˈpaː.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (27471,'palaestra','n','palaestr',NULL,NULL,'/paˈlaɪs.tra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27475,'palam','r',NULL,NULL,NULL,'[ˈpa.ɫã]','rp--------');
INSERT INTO latin_morpho VALUES (27477,'palatum','n','palat',NULL,'n-s---nn2-=palatus','[paˈɫaː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27481,'palea','n','pale',NULL,NULL,'[ˈpa.ɫe.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27486,'palimpsestus','n','palimpsest',NULL,NULL,'[pa.lɪmˈpseːs.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27487,'palinodia','n','palinodi',NULL,NULL,'[pa.lɪˈnoː.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27490,'palleo','v','pall pallu -',NULL,NULL,'/ˈpal.le.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (27491,'pallaca','n','pallac',NULL,NULL,'/ˈpal.la.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27492,'pallas','n','pallad',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27495,'pallium','n','palli',NULL,NULL,'[ˈpal.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27502,'pallor','n','pallor',NULL,NULL,'/ˈpal.lor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27503,'palma','n','palm',NULL,'n-s---fn1-=parma','[ˈpaɫ.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27509,'palmes','n','palmit',NULL,NULL,'[ˈpaɫ.mɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27513,'palmula','n','palmul',NULL,NULL,'[ˈpaɫ.mʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27516,'palpo','v','palp palpav palpat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (27517,'palpor','v','palp palpat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (27519,'palpebra','n','palpebr',NULL,NULL,'[ˈpaɫ.pɛ.bra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27520,'palpito','v','palpit palpitav palpitat',NULL,NULL,'[ˈpaɫ.pɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27527,'palumbes','n','palumb',NULL,NULL,'[paˈɫʊm.beːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (27528,'palus','n','palud',NULL,NULL,'[ˈpa.ɫuːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27532,'pampino','v','pampin pampinav pampinat',NULL,NULL,'[ˈpam.pɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27538,'panacea','n','panace',NULL,NULL,'/pa.naˈkeː.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27539,'panaces','n','panac',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (27551,'pando','v','pand pandav pandat',NULL,NULL,'/ˈpan.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27554,'pane','n','pan',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (27556,'pango','v','pang pepig pact',NULL,NULL,'[ˈpaŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27565,'panis','n','pan',NULL,NULL,'[ˈpaː.nɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (27566,'pannus','n','pann',NULL,NULL,'[ˈpan.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27574,'pantex','n','pantic',NULL,NULL,'[ˈpan.tɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27577,'Pantheon','n','Panthe','n-s---na2-=Pantheon',NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27584,'papa','n','pap',NULL,NULL,'/ˈpaː.pa/','n-s---mn1-');
INSERT INTO latin_morpho VALUES (27591,'papaver','n','papaver',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (27593,'papilio','n','papilion',NULL,NULL,'[paːˈpɪ.li.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27594,'papilla','n','papill',NULL,NULL,'[paˈpɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27598,'pappo','v','papp pappav pappat',NULL,NULL,'/ˈpap.poː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27599,'papula','n','papul',NULL,NULL,'[ˈpa.pʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27607,'par','a','par par par',NULL,NULL,'/paːr/','aps---an3i');
INSERT INTO latin_morpho VALUES (27608,'paro','v','par parav parat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (27609,'pareo','v','par paru parit',NULL,NULL,'/ˈpaː.re.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (27611,'parabola','n','parabol',NULL,NULL,'[paˈra.bɔ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27617,'paracharactes','n','paracharact',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (27619,'paracletus','n','paraclet',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (27621,'paradisus','n','paradis',NULL,NULL,'[pa.raˈdiː.sʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27625,'paragraphus','n','paragraph',NULL,NULL,'[paˈra.ɡra.pʰʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (27633,'paralysis','n','paralys',NULL,NULL,'[paˈra.lʏ.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (27634,'paralyticus','n','paralytic',NULL,NULL,'[pa.raˈlʏ.tɪ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27635,'paralyticus','a','paralytic paralytic paralytic',NULL,NULL,'[pa.raˈlʏ.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27640,'paraphrasis','n','paraphras',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (27648,'parasitus','n','parasit',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (27654,'paratus','a','parat parat parat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (27659,'parco','v','parc peperc pars',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (27665,'parens','n','parent',NULL,NULL,'[ˈpa.rẽːs]','n-s---cn3-');
INSERT INTO latin_morpho VALUES (27673,'pario','v','pari pariav pariat',NULL,NULL,'/ˈpa.ri.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (27676,'paries','n','pariet',NULL,NULL,'/ˈpa.ri.eːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27679,'parilis','a','paril paril paril',NULL,NULL,'[ˈpa.rɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (27680,'parilitas','n','parilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27683,'paritas','n','paritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27684,'pariter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27697,'paroecia','n','paroeci',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27706,'parricida','n','parricida',NULL,NULL,'[par.rɪˈkiː.da]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (27708,'parricidium','n','parricidi',NULL,NULL,'[paːr.rɪˈkiː.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27709,'pars','n','part',NULL,NULL,'/pars/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (27710,'parsimonia','n','parsimoni',NULL,NULL,'[par.sɪˈmoː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27712,'partus','n','part',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (27717,'partio','v','part partiv partit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (27719,'partibilis','a','partibil partibil partibil',NULL,NULL,'[parˈtɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (27723,'participatio','n','participation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27724,'participium','n','participi',NULL,NULL,'[par.tɪˈkɪ.pi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27728,'particula','n','particul',NULL,NULL,'[parˈtɪ.kʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27729,'particularis','a','particular particular particular',NULL,NULL,'[par.tɪ.kʊˈɫaː.rɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (27734,'partim','r',NULL,NULL,NULL,'[ˈpar.tĩ]','rp--------');
INSERT INTO latin_morpho VALUES (27737,'partitio','n','partition',NULL,NULL,'/parˈtiː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27739,'parturio','v','partur parturiv -',NULL,NULL,'[parˈtʊ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (27742,'parvus','a','parv parv parv','acs---cn3-=minor ass---mn1-=minimus',NULL,'[ˈpar.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27745,'parvitas','n','parvitat',NULL,NULL,'[ˈpar.wɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27750,'pasco','v','pasc pav past',NULL,NULL,'/ˈpaːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (27751,'Pascha','n','Paschat',NULL,NULL,'/ˈpas.kʰa/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (27753,'pascua','n','pascu',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27754,'pascuum','n','pascu',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (27757,'passus','n','pass',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (27759,'passer','n','passer',NULL,NULL,'[ˈpas.sɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27764,'passio','n','passion',NULL,NULL,'[ˈpas.si.ɔ]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27765,'passivus','a','passiv passiv passiv',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (27767,'pastus','n','past',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (27768,'pastillus','n','pastill',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (27770,'pastinaca','n','pastinac',NULL,NULL,'[pas.tɪˈnaː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27776,'pastor','n','pastor',NULL,NULL,'[ˈpaːs.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27777,'pastoralis','a','pastoral pastoral pastoral',NULL,NULL,'[pas.toːˈraː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (27781,'patefacio','v','patefac patefec patefact',NULL,NULL,'[pa.tɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (27784,'patens','a','patent patent patent',NULL,NULL,'[ˈpa.tẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (27786,'pater','n','patr',NULL,NULL,'[ˈpa.tɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27788,'paternitas','n','paternitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27789,'patesco','v','patesc - -',NULL,NULL,'/paˈteːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (27794,'patior','v','pat pass -',NULL,NULL,'[ˈpa.ti.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (27796,'patibulum','n','patibul',NULL,NULL,'[paˈtɪ.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27798,'patiens','a','patient patient patient',NULL,NULL,'/ˈpa.ti.eːns/','aps---an3i');
INSERT INTO latin_morpho VALUES (27799,'patienter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27800,'patientia','n','patienti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27801,'patina','n','patin',NULL,NULL,'[ˈpa.tɪ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27806,'pator','n','pator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (27807,'patro','v','patr patrav patrat',NULL,NULL,'/ˈpa.troː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27809,'patria','n','patri',NULL,NULL,'/ˈpa.tri.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27824,'patrocinor','v','patrocin patrocinat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (27827,'patronus','n','patron',NULL,NULL,'[paˈtroː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27837,'paucitas','n','paucitat',NULL,NULL,'[ˈpau̯.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27841,'paulus','a','paul paul paul',NULL,NULL,'[ˈpau̯.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27842,'paulatim','r',NULL,NULL,NULL,'[pau̯ˈɫaː.tĩ]','rp--------');
INSERT INTO latin_morpho VALUES (27856,'paulo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27862,'paulum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27865,'paupero','v','pauper pauperav pauperat',NULL,NULL,'[ˈpau̯.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27866,'pauper','a','pauper pauper pauper',NULL,NULL,'[ˈpau̯.pɛr]','aps---an3-');
INSERT INTO latin_morpho VALUES (27868,'pauperies','n','pauperi',NULL,NULL,'[pau̯ˈpɛ.ri.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (27869,'paupertas','n','paupertat',NULL,NULL,'[pau̯ˈpɛr.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27871,'pausa','n','paus',NULL,NULL,'/ˈpau̯.sa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27872,'pauso','v','paus pausav pausat',NULL,NULL,'/ˈpau̯.soː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27883,'pavio','v','pav paviv pavit',NULL,NULL,'/ˈpa.wi.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (27886,'pavimentum','n','paviment',NULL,NULL,'/pa.wiːˈmen.tum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27890,'pavor','n','pavor',NULL,NULL,'[ˈpa.wɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27891,'pax','n','pac',NULL,NULL,'/paːks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (27893,'pecu','n','-',NULL,NULL,'[ˈpɛ.kuː]','n-s---nn--');
INSERT INTO latin_morpho VALUES (27894,'pecco','v','pecc peccav peccat',NULL,NULL,'[ˈpɛk.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (27899,'peccamen','n','peccamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (27900,'peccatum','n','peccat',NULL,NULL,'/pekˈkaː.tum/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27902,'peccatio','n','peccation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (27904,'peccator','n','peccator',NULL,NULL,'[pɛkˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27910,'pecto','v','pect pex pex',NULL,NULL,'[ˈpɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27912,'pecten','n','pectin',NULL,NULL,'/ˈpek.ten/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27915,'pectus','n','pector',NULL,NULL,'[ˈpɛk.tʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (27927,'pecunia','n','pecuni',NULL,NULL,'[pɛˈkuː.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27928,'pecuniarius','a','pecuniari pecuniari pecuniari',NULL,NULL,'[pɛ.kuː.nɪˈaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27929,'pecuniosus','a','pecunios pecunios pecunios',NULL,NULL,'[pɛ.kuː.nɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (27930,'pecus','n','pecor',NULL,NULL,'[ˈpɛ.kʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (27938,'pedatus','n','pedat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (27941,'pedes','n','pedit',NULL,NULL,'[ˈpɛ.dɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (27944,'pedetemptim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (27948,'pedica','n','pedic',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27960,'pedisequa','n','pedisequ',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (27961,'pedisequus','n','pedisequ',NULL,NULL,'[pɛˈdɪ.sɛ.kʷʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (27966,'peditatus','n','peditat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (27967,'pegma','n','pegmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (27968,'peioro','v','peior peiorav peiorat',NULL,NULL,'/peːjˈjoː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (27978,'pelagus','n','pelag','n-s---na2-=pelagus',NULL,'[ˈpɛ.ɫa.ɡʊs]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (27979,'pelagius','a','pelagi pelagi pelagi',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (27984,'pello','v','pell pepul puls',NULL,NULL,'[ˈpɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (27986,'pellax','a','pellac pellac pellac',NULL,NULL,'[ˈpɛl.laːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (27992,'pellicio','v','pellic pellex pellect',NULL,NULL,'[pɛlˈlɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (27995,'pellicula','n','pellicul',NULL,NULL,'[pɛlˈlɪ.kʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (27996,'pellis','n','pell',NULL,NULL,'[ˈpɛl.lɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (28012,'pendo','v','pend pepend pens',NULL,NULL,'[ˈpɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28020,'penetro','v','penetr penetrav penetrat',NULL,NULL,'[pɛˈneː.troː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28021,'penetrabilis','a','penetrabil penetrabil penetrabil',NULL,NULL,'[pɛ.nɛˈtraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (28026,'penetratio','n','penetration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28029,'peniculus','n','penicul',NULL,NULL,'[peːˈnɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (28030,'penis','n','pen',NULL,NULL,'[ˈpeː.nɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (28039,'penna','n','penn',NULL,NULL,'[ˈpɛn.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28040,'pennatus','a','pennat pennat pennat',NULL,NULL,'[pɛnˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28041,'penniger','a','penniger penniger penniger',NULL,NULL,'[ˈpɛn.nɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (28046,'pensum','n','pens',NULL,NULL,'[ˈpẽː.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28047,'penso','v','pens pensav pensat',NULL,NULL,'[ˈpẽː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28049,'pensio','n','pension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28050,'pensito','v','pensit pensitav pensitat',NULL,NULL,'[ˈpẽː.sɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28051,'pensitatio','n','pensitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28055,'pentameter','n','pentametr',NULL,NULL,NULL,'n-s---mn2r');
INSERT INTO latin_morpho VALUES (28058,'Pentecoste','n','Pentecost','n-s---fg1-=Pentecostes',NULL,'[pɛn.teːˈkɔs.teː]','n-s---fn1g');
INSERT INTO latin_morpho VALUES (28064,'penuria','n','penuri',NULL,NULL,'/peːˈnuː.ri.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28085,'perago','v','perag pereg peract',NULL,NULL,'[ˈpɛ.ra.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28110,'perbonus','a','perbon perbon perbon',NULL,NULL,'[ˈpɛr.bɔ.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28119,'percello','v','percell percul perculs',NULL,NULL,'[pɛrˈkɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28120,'percenseo','v','percens percensu -',NULL,NULL,'[pɛrˈkẽː.se.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28121,'perceptibilis','a','perceptibil perceptibil perceptibil',NULL,NULL,'[pɛr.kɛpˈtiː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (28123,'percieo','v','perci perci percit',NULL,NULL,'[pɛrˈki.e.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28125,'percipio','v','percip percep percept',NULL,NULL,'[pɛrˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (28130,'percontatio','n','percontation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28133,'percoquo','v','percoqu percox percoct',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (28149,'percussio','n','percussion',NULL,NULL,'[pɛrˈkʊs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (28150,'percussor','n','percussor',NULL,NULL,'/perˈkus.sor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28152,'percutio','v','percut percuss percuss',NULL,NULL,'[pɛrˈkʊ.ti.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (28153,'perdo','v','perd perdid perdit',NULL,NULL,'[ˈpɛr.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28161,'perditus','a','perdit perdit perdit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (28162,'perdite','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (28165,'perditor','n','perditor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (28178,'perduco','v','perduc perdux perduct',NULL,NULL,'[pɛrˈduː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28183,'perduellio','n','perduellion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28184,'perduro','v','perdur perdurav perdurat',NULL,NULL,'[pɛrˈduː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28185,'pereo','v','per peri perit','v2spia--4-=peris v3spia--4-=perit v1ppia--4-=perimus v2ppia--4-=peritis v3ppia--4-=pereunt v1siia--4-=peribam v2siia--4-=peribas v3siia--4-=peribat v1piia--4-=peribamus v2piia--4-=peribatis v3piia--4-=peribant v1sfia--4-=peribo v2sfia--4-=peribis v3sfia--4-=peribit v1pfia--4-=peribimus v2pfia--4-=peribitis v3pfia--4-=peribunt v-sppamn4-=periens v-sppafn4-=periens v-sppann4-=periens v-sfpamn4-=periturus v-sfpafn4-=peritura v-sfpann4-=periturum v-sfppmn4-=pereundus v-sfppfn4-=pereunda v-sfppnn4-=pereundum v-s-gang4-=pereundi v-s-damn4-=pereundus v-s-dafn4-=pereunda v-s-dann4-=pereundum',NULL,'[ˈpɛ.re.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (28186,'peredo','v','pered - -','v--pna--3-=peresse v2spia--3-=peres v2spia--3-=perest',NULL,'[ˈpɛ.rɛ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28204,'perennis','a','perenn perenn perenn',NULL,NULL,'[pɛˈrɛn.nɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (28217,'perfectus','a','perfect perfect perfect',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (28218,'perfectio','n','perfection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28221,'perfero','v','perfer pertul perlat','v--pna--3-=perferre v2spia--3-=perfers v3spia--3-=perfert v2ppia--3-=perfertis',NULL,'[ˈpɛr.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28222,'perficio','v','perfic perfec perfect',NULL,NULL,'[pɛrˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (28223,'perfidus','a','perfid perfid perfid',NULL,NULL,'[ˈpɛr.fɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28231,'perfluo','v','perflu - -',NULL,NULL,'[ˈpɛr.fɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28233,'perfodio','v','perfod perfod perfoss',NULL,NULL,'[pɛrˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (28235,'perforo','v','perfor perforav perforat',NULL,NULL,'[ˈpɛr.fɔ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28242,'perfrictio','n','perfriction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28249,'perfuga','n','perfug',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (28250,'perfugio','v','perfug perfug -',NULL,NULL,'[pɛrˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (28251,'perfugium','n','perfugi',NULL,NULL,'[pɛrˈfʊ.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28253,'perfundo','v','perfund perfud perfus',NULL,NULL,'[pɛrˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28254,'perfungor','v','perfung perfunct -',NULL,NULL,'[pɛrˈfʊŋ.ɡɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (28255,'perfuro','v','perfur - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (28256,'pergo','v','perg perrex perrect',NULL,NULL,'[ˈpɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28265,'pergula','n','pergul',NULL,NULL,'[ˈpɛr.ɡʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28267,'perhibeo','v','perhib perhibu perhibit',NULL,NULL,'[pɛrˈhɪ.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28278,'periclitor','v','periclit periclitat -',NULL,NULL,'[pɛˈriː.klɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (28280,'periculum','n','pericul',NULL,NULL,'[pɛˈriː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28281,'periculosus','a','periculos periculos periculos',NULL,NULL,'[pɛ.riː.kʊˈɫoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28286,'perimo','v','perem perem perempt',NULL,NULL,'[ˈpɛ.rɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28288,'perimetros','n','perimetr',NULL,NULL,'[pɛˈrɪ.mɛ.trɔs]','n-s---fn2g');
INSERT INTO latin_morpho VALUES (28291,'perinde','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (28297,'periodus','n','period',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (28302,'peripheria','n','peripheri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28303,'periphrasis','n','periphras',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (28317,'peristroma','n','peristromat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (28320,'peristylium','n','peristyli',NULL,NULL,'[pɛ.rɪsˈtyː.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28321,'peritus','a','perit perit perit',NULL,NULL,'[pɛˈriː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28322,'peritia','n','periti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28324,'periurium','n','periuri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (28345,'perluo','v','perlu perlu perlut',NULL,'v1spia--3-=pelluo','[ˈpɛr.ɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28350,'perlustro','v','perlustr perlustrav perlustrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (28353,'permano','v','perman permanav permanat',NULL,NULL,'[pɛrˈmaː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28354,'permaneo','v','perman permans permans',NULL,NULL,'[pɛrˈma.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28359,'permeo','v','perme permeav permeat',NULL,NULL,'[ˈpɛr.me.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28361,'permetior','v','permet permens -',NULL,NULL,'[pɛrˈmeː.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (28363,'permisceo','v','permisc permiscu permixt',NULL,NULL,'[pɛrˈmɪs.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28364,'permissus','n','permiss',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (28365,'permissio','n','permission',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28368,'permities','n','permiti',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (28370,'permitto','v','permitt permis permiss',NULL,NULL,'[pɛrˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28372,'permixtio','n','permixtion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28376,'permoveo','v','permov permov permot',NULL,NULL,'[pɛrˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28377,'permulceo','v','permulc permuls permuls',NULL,NULL,'[pɛrˈmʊɫ.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28380,'permuto','v','permut permutav permutat',NULL,NULL,'[pɛrˈmuː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28381,'permutatio','n','permutation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28382,'perna','n','pern',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28385,'pernicies','n','permiti',NULL,NULL,'[pɛrˈnɪ.ki.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (28388,'pernicitas','n','pernicitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28390,'pernio','n','pernion',NULL,NULL,'[ˈpɛr.ni.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28431,'perpes','a','perpet perpet perpet',NULL,NULL,'[ˈpɛr.pɛs]','aps---an3-');
INSERT INTO latin_morpho VALUES (28433,'perpetro','v','perpetr perpetrav perpetrat',NULL,NULL,'[ˈpɛr.pɛ.troː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28434,'perpetuus','a','perpetu perpetu perpetu',NULL,NULL,'[pɛrˈpɛ.tʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28437,'perpetuitas','n','perpetuitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28438,'perpetuo','r',NULL,NULL,NULL,'[pɛrˈpɛ.tʊ.oː]','rp--------');
INSERT INTO latin_morpho VALUES (28440,'perplexor','v','perplex perplexat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (28444,'perpopulor','v','perpopul perpopulat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (28482,'persector','v','persect persectat -',NULL,NULL,'[pɛrˈsɛk.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (28483,'persecutio','n','persecution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28485,'persecutor','n','persecutor',NULL,NULL,'[pɛr.sɛˈkuː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28489,'persequor','v','persequ persecut -',NULL,NULL,'[ˈpɛr.sɛ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (28491,'persevero','v','persever perseverav perseverat',NULL,NULL,'[pɛr.sɛˈweː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28494,'perseverantia','n','perseveranti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28496,'Persicus','a','Persic Persic Persic',NULL,NULL,'[ˈpɛr.sɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28505,'persolvo','v','persolv persolv persolut',NULL,NULL,'Hyphenation: per‧sol‧vō','v1spia--3-');
INSERT INTO latin_morpho VALUES (28506,'persona','n','person',NULL,NULL,'[pɛrˈsoː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28507,'persono','v','person personu personit',NULL,NULL,'[ˈpɛr.sɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28517,'perspergo','v','persperg - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (28520,'perspicio','v','perspic perspex perspect',NULL,NULL,'[pɛrˈspɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (28524,'perspicuus','a','perspicu perspicu perspicu',NULL,NULL,'[pɛrˈspɪ.kʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28525,'perspicue','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (28526,'persto','v','perst perstet perstat',NULL,NULL,'[ˈpɛr.stoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28529,'perstringo','v','perstring perstrinx perstrict',NULL,NULL,'[pɛrˈstrɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28532,'persuadeo','v','persuad persuas persuas',NULL,NULL,'[pɛrˈswaː.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28533,'persuasibilis','a','persuasibil persuasibil persuasibil',NULL,NULL,'[pɛr.swaːˈsɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (28540,'pertendo','v','pertend pertend pertent',NULL,NULL,'[pɛrˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28541,'pertento','v','pertent pertentav pertentat',NULL,NULL,'[pɛrˈtɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28545,'perterreo','v','perterr perterru perterrit',NULL,NULL,'[pɛrˈtɛr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28552,'pertica','n','pertic',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28555,'pertineo','v','pertin pertinu -',NULL,NULL,'[pɛrˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (28556,'pertinacia','n','pertinaci',NULL,NULL,'[pɛr.tɪˈnaː.ki.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28557,'pertinaciter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (28559,'pertingo','v','perting - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (28566,'pertranseo','v','pertrans pertransiv pertransit','v2spia--4-=pertransis v3spia--4-=pertransit v1ppia--4-=pertransimus v2ppia--4-=pertransitis v3ppia--4-=pertranseunt v1siia--4-=pertransibam v2siia--4-=pertransibas v3siia--4-=pertransibat v1piia--4-=pertransibamus v2piia--4-=pertransibatis v3piia--4-=pertransibant v1sfia--4-=pertransibo v2sfia--4-=pertransibis v3sfia--4-=pertransibit v1pfia--4-=pertransibimus v2pfia--4-=pertransibitis v3pfia--4-=pertransibunt v-sppamn4-=pertransiens v-sppafn4-=pertransiens v-sppann4-=pertransiens v-sfpamn4-=pertransiturus v-sfpafn4-=pertransitura v-sfpann4-=pertransiturum v-sfppmn4-=pertranseundus v-sfppfn4-=pertranseunda v-sfppnn4-=pertranseundum v-s-gang4-=pertranseundi v-s-damn4-=pertranseundus v-s-dafn4-=pertranseunda v-s-dann4-=pertranseundum',NULL,'[pɛrˈtrãː.se.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (28569,'pertundo','v','pertund pertud pertus',NULL,NULL,'[pɛrˈtʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28571,'perturbo','v','perturb perturbav perturbat',NULL,NULL,'[pɛrˈtʊr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28573,'perturbatio','n','perturbation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28578,'peruro','v','perur peruss perust',NULL,NULL,'[pɛˈruː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28581,'pervado','v','pervad pervas pervas',NULL,NULL,'[pɛrˈwaː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28583,'pervagor','v','pervag pervagat -',NULL,NULL,'[ˈpɛr.wa.ɡɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (28585,'perveho','v','perveh pervex pervect',NULL,NULL,'[ˈpɛr.wɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28587,'pervenio','v','perven perven pervent',NULL,NULL,'[pɛrˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (28588,'perversus','a','pervers pervers pervers',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (28589,'perverto','v','pervert pervert pervers',NULL,NULL,'[pɛrˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28592,'pervestigatio','n','pervestigation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28594,'pervius','a','pervi pervi pervi',NULL,NULL,'[ˈpɛr.wi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28595,'pervicacia','n','pervicaci',NULL,NULL,'[pɛr.wɪˈkaː.ki.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28596,'pervicax','a','pervicac pervicac pervicac',NULL,NULL,'[ˈpɛr.wɪ.kaːks]','aps---an3-');
INSERT INTO latin_morpho VALUES (28611,'pes','n','ped',NULL,NULL,'/peːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28613,'pessimo','v','pessim pessimav pessima',NULL,NULL,'[ˈpɛs.sɪ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28618,'pessulus','n','pessul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (28622,'pessumdo','v','pessumd pessumded pessumdat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (28625,'pestilens','a','pestilent pestilent pestilent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (28626,'pestilentia','n','pestilenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28629,'pestis','n','pest',NULL,NULL,'[ˈpɛs.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (28630,'peto','v','pet - petit',NULL,NULL,'[ˈpɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28636,'petaurum','n','petaur',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (28637,'petaurista','n','petaurist',NULL,NULL,'[pɛ.tau̯ˈrɪs.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (28639,'petilus','a','petil petil petil',NULL,NULL,'[pɛˈtiː.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28641,'petitio','n','petition',NULL,NULL,'[pɛˈtiː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (28642,'petitor','n','petitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (28654,'petroselinum','n','petroselin',NULL,NULL,'[pɛ.trɔ.sɛˈliː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28655,'petulans','a','petulant petulant petulant',NULL,NULL,'[ˈpɛ.tʊ.ɫãːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (28656,'petulanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (28670,'phalanx','n','phalang',NULL,NULL,'[ˈpʰa.ɫaŋks]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (28674,'phantasia','n','phantasi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28678,'phantasma','n','phantasmat',NULL,NULL,'/pʰanˈtas.ma/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (28682,'pharetra','n','pharetr',NULL,NULL,'/ˈpʰa.re.tra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28685,'pharmacus','n','pharmac',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (28686,'pharmaceuticus','a','pharmaceutic pharmaceutic pharmaceutic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (28688,'pharmacopola','n','pharmacopol',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (28709,'philologus','a','philolog philolog philolog',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (28713,'philosophus','n','philosoph',NULL,NULL,'[pʰɪˈɫɔ.sɔ.pʰʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (28715,'philosophor','v','philosoph philosophat -',NULL,NULL,'[pʰɪˈɫɔ.sɔ.pʰɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (28716,'philosophia','n','philosophi',NULL,NULL,'[pʰɪ.ɫɔˈsɔ.pʰi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28719,'philtrum','n','philtr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (28724,'phlebotomo','v','phlebotom phlebotomav phlebotomat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (28725,'phlegma','n','phlegmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (28727,'phoca','n','phoc',NULL,NULL,'/ˈpʰoː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28731,'phoenicopterus','n','phoenicopter',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (28732,'phoenix','n','phoenic',NULL,NULL,'/ˈpʰoe̯.niːks/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28750,'phreneticus','a','phrenetic phrenetic phrenetic',NULL,NULL,'[pʰrɛˈneː.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28754,'Phrygia','n','Phrygi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28755,'Phrygius','a','Phrygi Phrygi Phrygi',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (28757,'phthisis','n','phthis',NULL,NULL,'[ˈpʰtʰɪ.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (28758,'phthongus','n','phthong',NULL,NULL,'[ˈpʰtʰɔŋ.ɡʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (28764,'phylacterium','n','phylacteri',NULL,NULL,'[pʰʏ.ɫakˈteː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28784,'pio','v','pi piav piat',NULL,NULL,'/ˈpi.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (28785,'pius','a','pi pi pi','ass---mn1-=piemptissimus',NULL,'[ˈpi.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28787,'piacularis','a','piacular piacular piacular',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (28790,'pica','n','pic',NULL,NULL,'/ˈpiː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28791,'picus','n','pic',NULL,NULL,'[ˈpiː.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (28797,'pictor','n','pictor',NULL,NULL,'[ˈpɪk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28798,'pictura','n','pictur',NULL,NULL,'[pɪkˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28801,'pietas','n','pietat',NULL,NULL,'[ˈpi.ɛ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (28805,'pigmentum','n','pigment',NULL,NULL,'[pɪɡˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28807,'pignero','v','pigner pignerav pignerat',NULL,NULL,'[ˈpɪŋ.nɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28812,'pignus','n','pignor',NULL,NULL,'[ˈpɪŋ.nʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (28815,'pigredo','n','pigredin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28817,'pigritia','n','pigriti',NULL,NULL,'[pɪˈɡrɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28819,'pigror','n','pigror',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (28821,'pila','n','pil',NULL,NULL,'[ˈpiː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28826,'pilum','n','pil',NULL,NULL,'[ˈpiː.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28828,'pilo','v','pil pilav pilat',NULL,NULL,'[ˈpɪ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28837,'pilleus','n','pille',NULL,NULL,'[ˈpɪl.le.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (28841,'pilosus','a','pilos pilos pilos',NULL,NULL,'[pɪˈɫoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28844,'pinus','n','pin',NULL,NULL,'[ˈpiː.nʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (28849,'pincerna','n','pincern',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (28853,'pingo','v','ping pinx pict',NULL,NULL,'[ˈpɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28854,'pinguis','a','pingu pingu pingu',NULL,NULL,'[ˈpɪŋ.ɡᶣɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (28856,'pinguedo','n','pinguedin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28859,'pinguitudo','n','pinguitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28862,'pinna','n','pinn',NULL,NULL,'[ˈpɪn.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28864,'pinnaculum','n','pinnacul',NULL,NULL,'[pɪnˈnaː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28866,'pinnatus','a','pinnat pinnat pinnat',NULL,NULL,'[pɪnˈnaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28868,'pinniger','a','pinniger pinniger pinniger',NULL,NULL,'[ˈpɪn.nɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (28873,'pinso','v','pins pinsav pinsat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (28881,'piperatorium','n','piperatori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (28884,'pipio','v','pipi  ',NULL,NULL,'/ˈpiː.pi.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (28889,'pirum','n','pir',NULL,NULL,'[ˈpi.rũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28893,'pisum','n','pis',NULL,NULL,'[ˈpɪ.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28898,'piscator','n','piscator',NULL,NULL,'[pɪsˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28902,'piscina','n','piscin',NULL,NULL,'[pɪsˈkiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28904,'piscis','n','pisc',NULL,NULL,'[ˈpɪs.kɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (28912,'pistacium','n','pistaci',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (28916,'pistor','n','pistor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (28918,'pistrina','n','pistrin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28919,'pistrinum','n','pistrin',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (28924,'pistrix','n','pistric',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28927,'pittacium','n','pittaci',NULL,NULL,'/pitˈta.ki.um/','n-s---nn2-');
INSERT INTO latin_morpho VALUES (28930,'pituita','n','pituit',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28940,'placo','v','plac placav placat',NULL,NULL,'[ˈpɫaː.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28947,'placatus','a','placat placat placat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (28950,'placidus','a','placid placid placid',NULL,NULL,'[ˈpɫa.kɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (28951,'placide','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (28956,'plaga','n','plag',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (28958,'plago','v','plag plagav plagat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (28961,'plagiarius','n','plagiari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (28969,'planctus','n','planct',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (28970,'plane','r',NULL,NULL,NULL,'[ˈpɫaː.neː]','rp--------');
INSERT INTO latin_morpho VALUES (28972,'planeta','n','planet',NULL,NULL,'/plaˈneː.ta/','n-s---mn1-');
INSERT INTO latin_morpho VALUES (28973,'plango','v','plang planx planct',NULL,NULL,'[ˈpɫaŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (28979,'planta','n','plant',NULL,NULL,'[ˈpɫan.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (28981,'planto','v','plant plantav plantat',NULL,NULL,'[ˈpɫan.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28982,'plantago','n','plantagin',NULL,NULL,'[pɫanˈtaː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (28987,'plantatio','n','plantation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (28990,'plasmo','v','plasm plasmav plasmat',NULL,NULL,'[ˈpɫas.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (28993,'plasmator','n','plasmator',NULL,NULL,'[pɫasˈmaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (28994,'plastes','n','plast',NULL,NULL,'[ˈpɫas.teːs]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (29004,'plaudo','v','plaud plaus plaus',NULL,NULL,'[ˈpɫau̯.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29005,'plausus','n','plaus',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29008,'plaustrum','n','plaustr',NULL,NULL,'[ˈpɫau̯s.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29011,'plebeius','a','plebei plebei plebei',NULL,NULL,'(tetrasyllabic) [pɫeːˈbeː.i.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29015,'plebs','n','pleb',NULL,NULL,'[pɫeːps]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29016,'plecto','v','plect - -',NULL,NULL,'/ˈplɛk.toː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (29018,'plectrum','n','plectr',NULL,NULL,'[ˈpɫeːk.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29025,'plene','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29026,'pleniter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29027,'plenitudo','n','plenitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29031,'plerumque','r',NULL,NULL,'rp--------=plerunque','[pɫeːˈrʊŋ.kᶣɛ]','rp--------');
INSERT INTO latin_morpho VALUES (29039,'plico','v','plic plicav plicat',NULL,NULL,'[ˈplɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29047,'plipio','v','plipi plipiav plipiat',NULL,NULL,'[ˈplɪ.pi.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29049,'ploro','v','plor plorav plorat',NULL,NULL,'[ˈpɫoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29051,'ploratus','n','plorat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29058,'pluma','n','plum',NULL,NULL,'[ˈpɫuː.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29070,'plumosus','a','plumos plumos plumos',NULL,NULL,'[pɫuːˈmoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29072,'pluralis','a','plural plural plural',NULL,NULL,'[pɫuːˈraː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (29078,'plurativus','a','plurativ plurativ plurativ',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (29088,'pluteus','n','plute',NULL,NULL,'[ˈpɫʊ.te.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (29090,'pluvia','n','pluvi',NULL,NULL,'[ˈpɫʊ.wi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29094,'pneuma','n','pneumat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (29095,'pneumaticus','a','pneumatic pneumatic pneumatic',NULL,NULL,'[pneu̯ˈma.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29099,'pocillator','n','pocillator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29101,'poculum','n','pocul',NULL,NULL,'[ˈpoː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29103,'podagra','n','podagr',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (29105,'podex','n','podic',NULL,NULL,'[ˈpoː.dɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (29107,'poema','n','poemat',NULL,NULL,'[pɔˈeː.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (29121,'poesis','n','poes',NULL,NULL,'[pɔˈeː.sɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29122,'poeta','n','poet',NULL,NULL,'[pɔˈeː.ta]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (29125,'poetria','n','poetri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (29127,'polus','n','pol',NULL,NULL,'/ˈpo.lus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (29133,'polio','v','pol poliv polit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (29144,'pollens','a','pollent pollent pollent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (29146,'pollex','n','pollic',NULL,NULL,'[ˈpɔl.lɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (29147,'polliceor','v','pollic pollicit -',NULL,NULL,'[pɔlˈlɪ.ke.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (29149,'pollicitum','n','pollicit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29150,'pollicitor','v','pollicit pollicitat -',NULL,NULL,'[pɔlˈlɪ.kɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29151,'pollicitatio','n','pollicitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29154,'polluo','v','pollu pollu pollut',NULL,NULL,'[ˈpɔl.lʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29156,'polluceo','v','polluc pollux polluct',NULL,NULL,'[pɔlˈluː.ke.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (29162,'Pollux','n','Polluc',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29180,'pomus','n','pom',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (29181,'pomum','n','pom',NULL,NULL,'[ˈpoː.mũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29183,'pomarium','n','pomari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29189,'pompa','n','pomp',NULL,NULL,'[ˈpɔm.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29202,'pono','v','pon posu posit',NULL,NULL,'/ˈpoː.noː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (29203,'pondero','v','ponder ponderav ponderat',NULL,NULL,'[ˈpɔn.dɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29204,'ponderatio','n','ponderation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29207,'pondus','n','ponder',NULL,NULL,'[ˈpɔn.dʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (29209,'pons','n','pont',NULL,NULL,'[põːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (29211,'pontus','n','pont',NULL,NULL,'[ˈpɔn.tʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (29215,'pontifex','n','pontific',NULL,NULL,'[ˈpɔn.tɪ.fɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (29230,'poples','n','poplit',NULL,NULL,'[ˈpɔ.pɫɛs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29233,'populus','n','popul',NULL,NULL,'[ˈpɔ.pʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (29236,'populor','v','popul populat -',NULL,NULL,'[ˈpɔ.pʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29239,'popularis','a','popular popular popular',NULL,NULL,'[pɔ.pʊˈɫaː.rɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (29244,'populatus','n','populat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29245,'populatio','n','population',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29246,'populator','n','populator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29250,'porca','n','porc',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (29251,'porcus','n','porc',NULL,NULL,'[ˈpɔr.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (29254,'porcellus','n','porcell',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (29273,'porrum','n','porr',NULL,NULL,'[ˈpɔr.rũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29277,'porrigo','v','porg porx porrect',NULL,NULL,'[ˈpɔr.rɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29279,'porta','n','port',NULL,NULL,'[ˈpɔr.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29280,'portus','n','port',NULL,NULL,'[ˈpɔr.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (29281,'porto','v','port portav portat',NULL,NULL,'[ˈpɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29285,'portendo','v','portend portend portent',NULL,NULL,'[pɔrˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29286,'portentum','n','portent',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29289,'porthmeus','n','porthme',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29290,'porticus','n','portic',NULL,NULL,'[ˈpɔr.tɪ.kʊs]','n-s---fn4-');
INSERT INTO latin_morpho VALUES (29292,'portio','n','portion',NULL,NULL,'[ˈpɔr.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29296,'portorium','n','portori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29300,'posco','v','posc poposc -',NULL,NULL,'[ˈpɔs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29303,'positus','n','posit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29306,'positor','n','positor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29307,'possum','v','- potu -','v--pna--3-=posse v1spia--3-=possum v2spia--3-=potes v3spia--3-=potest v1ppia--3-=possumus v2ppia--3-=potestis v3ppia--3-=possunt v-sfpamn3-=potfuturus v-sfpafn3-=potfutura v-sfpann3-=potfuturum',NULL,'[ˈpɔs.sũ]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29308,'possessio','n','possession',NULL,NULL,'[pɔsˈsɛs.si.ɔ]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29310,'possessor','n','possessor',NULL,NULL,'[pɔsˈsɛs.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (29311,'possibilis','a','possibil possibil possibil',NULL,NULL,'[pɔsˈsɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (29312,'possideo','v','possid possed possess',NULL,NULL,'[pɔsˈsɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (29313,'possido','v','possid possed possess',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (29314,'post','r',NULL,NULL,NULL,'[pɔst]','rp--------');
INSERT INTO latin_morpho VALUES (29318,'postea','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29321,'posterus','a','poster poster poster',NULL,NULL,'/ˈpos.te.rus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (29326,'posterius','r',NULL,NULL,NULL,NULL,'rc--------');
INSERT INTO latin_morpho VALUES (29331,'posthabeo','v','posthab posthabu posthabit',NULL,NULL,'[pɔstˈha.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (29338,'postibi','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29342,'postidea','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29344,'postilla','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29348,'postmodo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29353,'postpono','v','postpon postposu postposit',NULL,NULL,'[pɔstˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29364,'postulo','v','postul postulav postulat',NULL,NULL,'[ˈpɔs.tʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29365,'postulatum','n','postulat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29366,'postulatio','n','postulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29367,'potus','n','pot',NULL,NULL,'[ˈpoː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (29369,'poto','v','pot - potat',NULL,NULL,'/ˈpoː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (29372,'potator','n','potator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29374,'potens','a','potent potent potent',NULL,NULL,'[ˈpɔ.tẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (29375,'potentatus','n','potentat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29377,'potentia','n','potenti',NULL,NULL,'/poˈten.ti.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29379,'potestas','n','potestat',NULL,NULL,'[pɔˈtɛs.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29382,'potio','n','potion',NULL,NULL,'/ˈpoː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29387,'potissimum','r',NULL,NULL,NULL,NULL,'rs--------');
INSERT INTO latin_morpho VALUES (29389,'potito','v','potit potitav potitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (29390,'potius','r',NULL,NULL,NULL,NULL,'rc--------');
INSERT INTO latin_morpho VALUES (29391,'potor','n','potor',NULL,NULL,'[ˈpoː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (29401,'practicus','a','practic practic practic',NULL,NULL,'[ˈprak.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29403,'prae','r',NULL,NULL,NULL,'/prae̯/','rp--------');
INSERT INTO latin_morpho VALUES (29412,'praebeo','v','praeb praebu praebit',NULL,NULL,'/ˈprae̯.be.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (29418,'praecantrix','n','praecantric',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29420,'praecedo','v','praeced praecess praecess',NULL,NULL,'/prae̯ˈkeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (29423,'praecello','v','praecell - -',NULL,NULL,'[prae̯ˈkɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29426,'praecellentia','n','praecellenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (29432,'praeceps','a','praecipit praecipit praecipit',NULL,NULL,'[ˈprae̯.kɛps]','aps---an3-');
INSERT INTO latin_morpho VALUES (29433,'praeceptum','n','praecept',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29435,'praeceptor','n','praeceptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29437,'praecido','v','praecid praecid praecis',NULL,NULL,'/prae̯ˈkiː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (29439,'praecino','v','praecin praececin -',NULL,NULL,'[ˈprae̯.kɪ.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29440,'praecingo','v','praecing praecinx praecinct',NULL,NULL,'[prae̯ˈkɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29441,'praecipio','v','praecip praecep praecept',NULL,NULL,'[prae̯ˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (29444,'praecipue','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29448,'praecludo','v','praeclud praeclus praeclus',NULL,NULL,'[prae̯ˈkɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29449,'praeco','n','praecon',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29453,'praeconium','n','praeconi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29459,'praecoquus','a','praecoqu praecoqu praecoqu',NULL,NULL,'[ˈprae̯.kɔ.kʷʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29460,'praecoquis','a','praecoqu praecoqu praecoqu',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (29465,'praecox','a','praecoc praecoc praecoc',NULL,NULL,'[ˈprae̯.kɔks]','aps---an3-');
INSERT INTO latin_morpho VALUES (29467,'praecurro','v','praecurr praecucurr praecurs',NULL,NULL,'[prae̯ˈkʊr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29472,'praeda','n','praed',NULL,NULL,'/ˈprae̯.da/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29473,'praedo','v','praed praedav praeda',NULL,NULL,'/ˈprae̯.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (29474,'praedor','v','praed praedat -',NULL,NULL,'[ˈprae̯.dɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29476,'praedator','n','praedator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29478,'praedecessor','n','praedecessor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29481,'praedestino','v','praedestin praedestinav praedestinat',NULL,NULL,'[prae̯ˈdɛs.tɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29482,'praedestinatio','n','praedestination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29484,'praedium','n','praedi',NULL,NULL,'[ˈprae̯.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29487,'praedico','v','praedic praedicav praedicat',NULL,NULL,'[ˈprae̯.dɪ.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29490,'praedicatio','n','praedication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29492,'praedictum','n','praedict',NULL,NULL,'[prae̯ˈdɪk.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29502,'praedo','n','praedon',NULL,NULL,'/ˈprae̯.doː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (29504,'praeduco','v','praeduc praedux praeduct',NULL,NULL,'/prae̯ˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (29508,'praeeo','v','prae praeiv praeit','v2spia--4-=praeis v3spia--4-=praeit v1ppia--4-=praeimus v2ppia--4-=praeitis v3ppia--4-=praeeunt v1siia--4-=praeibam v2siia--4-=praeibas v3siia--4-=praeibat v1piia--4-=praeibamus v2piia--4-=praeibatis v3piia--4-=praeibant v1sfia--4-=praeibo v2sfia--4-=praeibis v3sfia--4-=praeibit v1pfia--4-=praeibimus v2pfia--4-=praeibitis v3pfia--4-=praeibunt v-sppamn4-=praeiens v-sppafn4-=praeiens v-sppann4-=praeiens v-sfpamn4-=praeiturus v-sfpafn4-=praeitura v-sfpann4-=praeiturum v-sfppmn4-=praeeundus v-sfppfn4-=praeeunda v-sfppnn4-=praeeundum v-s-gang4-=praeeundi v-s-damn4-=praeeundus v-s-dafn4-=praeeunda v-s-dann4-=praeeundum',NULL,'/ˈprae̯.e.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (29509,'praefor','v','praef praefat -',NULL,NULL,'[ˈprae̯.fɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29511,'praefatio','n','praefation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29513,'praefectus','n','praefect',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (29516,'praefectura','n','praefectur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (29517,'praefero','v','praefer praetul praelat','v--pna--3-=praeferre v2spia--3-=praefers v3spia--3-=praefert v2ppia--3-=praefertis',NULL,'[ˈprae̯.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29524,'praefiguratio','n','praefiguration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29530,'praefoco','v','praefoc praefocav praefocat',NULL,NULL,'/prae̯ˈfoː.koː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (29543,'praegnas','a','praegnat praegnat praegnat',NULL,NULL,'[ˈprae̯ŋ.naːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (29548,'praegredior','v','praegred praegress -',NULL,NULL,'[prae̯ˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (29576,'praelusio','n','praelusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29580,'praematurus','a','praematur praematur praematur',NULL,NULL,'[prae̯.maːˈtuː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29585,'praemium','n','praemi',NULL,NULL,'[ˈprae̯.mi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29595,'praemonitus','n','praemonit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29600,'praemunio','v','praemun praemuniv praemunit',NULL,NULL,'/prae̯ˈmuː.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (29612,'praenoto','v','praenot praenotav praenotat',NULL,NULL,'[ˈprae̯.nɔ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29617,'praeoccupo','v','praeoccup praeoccupav praeoccupat',NULL,NULL,'[prae̯ˈɔk.kʊ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29619,'praeopto','v','praeopt praeoptav praeoptat',NULL,NULL,'[prae̯ˈɔp.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29621,'praeparo','v','praepar praeparav praeparat',NULL,NULL,'/ˈprae̯.pa.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (29622,'praeparatio','n','praeparation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29623,'praepedio','v','praeped praepediv praepedit',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (29626,'praepes','a','praepet praepet praepet',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (29634,'praepositio','n','praeposition',NULL,NULL,'[prae̯.pɔˈsɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29640,'praeputium','n','praeputi',NULL,NULL,'[prae̯ˈpuː.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29657,'praes','n','praed',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29665,'praesagium','n','praesagi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29671,'praescientia','n','praescienti',NULL,NULL,'[prae̯s.kɪˈɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29676,'praescriptum','n','praescript',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29677,'praescriptio','n','praescription',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29678,'praeseco','v','praesec praesecu praesect',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (29681,'praesens','a','praesent praesent praesent',NULL,NULL,'[ˈprae̯.sẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (29682,'praesento','v','praesent - praesentat',NULL,NULL,'[prae̯ˈsɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29683,'praesentarius','a','praesentari praesentari praesentari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (29685,'praesentatio','n','praesentation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29692,'praesepe','n','praesep',NULL,NULL,'[prae̯ˈseː.pɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (29694,'praesepio','v','praesep praeseps praesept',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (29696,'praesertim','r',NULL,NULL,NULL,'[prae̯ˈsɛr.tĩ]','rp--------');
INSERT INTO latin_morpho VALUES (29699,'praeses','n','praesid',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29700,'praesideo','v','praesid praesed -',NULL,NULL,'[prae̯ˈsɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (29704,'praesidium','n','praesidi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29709,'praesto','v','praest praestit -',NULL,NULL,'/ˈprae̯s.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (29712,'praestabilis','a','praestabil praestabil praestabil',NULL,NULL,'[prae̯sˈtaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (29714,'praestantia','n','praestanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (29715,'praestatio','n','praestation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29717,'praestigia','n','praestigi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (29719,'praestigiator','n','praestigiator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29722,'praestino','v','praestin praestinav praestinat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (29725,'praestolor','v','praestol praestolat -',NULL,NULL,'[prae̯sˈtoː.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29726,'praestolatio','n','praestolation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29729,'praestruo','v','praestru praestrux praestruct',NULL,NULL,'[ˈprae̯s.trʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29730,'praesul','n','praesul',NULL,NULL,'[ˈprae̯.sʊɫ]','n-s---cn3-');
INSERT INTO latin_morpho VALUES (29734,'praesumo','v','praesum praesumps praesumpt',NULL,NULL,'/prae̯ˈsuː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (29736,'praesumptio','n','praesumption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29738,'praesumptive','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29744,'praetendo','v','praetend praetend praetent',NULL,NULL,'[prae̯ˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29752,'praetereo','v','praeteri praeteriv praeterit',NULL,NULL,'[prae̯ˈtɛ.re.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29753,'praeterea','r',NULL,NULL,NULL,'[prae̯ˈtɛ.re.aː]','rp--------');
INSERT INTO latin_morpho VALUES (29758,'praeteritus','a','praeterit praeterit praeterit',NULL,NULL,'[prae̯ˈtɛ.rɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29762,'praetermitto','v','praetermitt praetermis praetermiss',NULL,NULL,'[prae̯.tɛrˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29772,'praetextum','n','praetext',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29777,'praetor','n','praetor',NULL,NULL,'[ˈprae̯.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (29780,'praetorius','a','praetori praetori praetori',NULL,NULL,'[prae̯ˈtoː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29791,'praevaleo','v','praeval praevalu -',NULL,NULL,'[prae̯ˈwa.ɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (29794,'praevaricor','v','praevaric praevaricat -',NULL,NULL,'[prae̯ˈwaː.rɪ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29797,'praevaricator','n','praevaricator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (29800,'praevenio','v','praeven praeven praevent',NULL,NULL,'[prae̯ˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (29801,'praeverbium','n','praeverbi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29803,'praeverto','v','praevert praevert praevers',NULL,NULL,'[prae̯ˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29805,'praevideo','v','praevid praevid praevis',NULL,NULL,'[prae̯ˈwɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (29813,'prandium','n','prandi',NULL,NULL,'[ˈpran.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29819,'pratum','n','prat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29823,'pravus','a','prav prav prav',NULL,NULL,'/ˈpraː.wus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (29833,'precor','v','prec precat -',NULL,NULL,'[ˈprɛ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29834,'precabundus','a','precabund precabund precabund',NULL,NULL,'[prɛ.kaːˈbʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29836,'precatus','n','precat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29837,'precatio','n','precation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29845,'prehendo','v','prehend prehend prehens',NULL,NULL,'[prɛˈhɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29850,'premo','v','prem press press',NULL,NULL,'[ˈprɛ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29856,'prenso','v','prens prensav prensat',NULL,NULL,'[ˈprẽː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29860,'presbyter','n','presbyter',NULL,NULL,'[ˈprɛs.bʏ.tɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (29869,'presso','v','press pressav pressat',NULL,NULL,'[ˈprɛs.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29874,'pretium','n','preti',NULL,NULL,'[ˈprɛ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29875,'pretiosus','a','pretios pretios pretios',NULL,NULL,'[prɛ.tɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29877,'prex','n','prec',NULL,NULL,'[prɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29878,'prior','a','prior prior prior',NULL,NULL,'[ˈpri.ɔr]','aps---an3-');
INSERT INTO latin_morpho VALUES (29891,'primatus','n','primat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29893,'primicerius','n','primiceri',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (29895,'primigenius','a','primigeni primigeni primigeni',NULL,NULL,'[priː.mɪˈɡɛ.ni.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29901,'primitus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29902,'primo','r',NULL,NULL,'rp--------=primum',NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29910,'primordium','n','primordi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29914,'primum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29915,'prinus','n','prin',NULL,NULL,'[ˈpriː.nʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (29917,'princeps','a','princip princip princip',NULL,NULL,'[ˈpriːŋ.kɛps]','aps---an3-');
INSERT INTO latin_morpho VALUES (29918,'principor','v','princip principat -',NULL,NULL,'[ˈprɪŋ.kɪ.pɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (29921,'principaliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (29922,'principatus','n','principat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (29923,'principium','n','principi',NULL,NULL,'[priːŋˈkɪ.pi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (29932,'priscus','a','prisc prisc prisc',NULL,NULL,'[ˈpriːs.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29936,'prius','r',NULL,NULL,NULL,'[ˈpri.ʊs]','rc--------');
INSERT INTO latin_morpho VALUES (29945,'privignus','n','privign',NULL,NULL,'[priːˈwɪŋ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (29955,'probo','v','prob probav probat',NULL,NULL,'[ˈprɔ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29960,'probatio','n','probation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29964,'probitas','n','probitat',NULL,NULL,'[ˈprɔ.bɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (29965,'problema','n','problemat',NULL,NULL,'[prɔˈbɫeː.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (29969,'proboscis','n','proboscid',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29970,'probrum','n','probr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (29972,'procus','n','proc',NULL,'n-s---mn2-=n-s---mn2-procer',NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (29973,'proco','v','proc procav procat',NULL,NULL,'[ˈprɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29975,'procacitas','n','procacitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29977,'procedo','v','proced process process',NULL,NULL,'/proːˈkeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (29979,'procella','n','procell',NULL,NULL,'[prɔˈkɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (29980,'procellosus','a','procellos procellos procellos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (29983,'procerus','a','procer procer procer',NULL,NULL,'[proːˈkeː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (29985,'proceritas','n','proceritat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (29986,'processus','n','process',NULL,NULL,'[proːˈkɛs.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (29988,'procido','v','procid - procis',NULL,NULL,'[ˈproː.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (29993,'proclamo','v','proclam proclamav proclamat',NULL,NULL,'[proːˈkɫaː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (29997,'proclivis','a','procliv procliv procliv',NULL,NULL,'[proːˈkliː.wɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (29999,'procoeton','n','procoeton',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (30001,'proconsularis','a','proconsular proconsular proconsular',NULL,NULL,'/proː.koːn.suˈlaː.ris/','aps---cn3i');
INSERT INTO latin_morpho VALUES (30002,'proconsulatus','n','proconsulat',NULL,NULL,'/proː.koːn.suˈlaː.tus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (30003,'procrastino','v','procrastin procrastinav procrastinat',NULL,NULL,'[proːˈkraːs.tɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30005,'procreo','v','procre procreav procreat',NULL,NULL,'/ˈproː.kre.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30011,'procumbo','v','procumb procubu procubit',NULL,NULL,'[proːˈkʊm.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30012,'procuro','v','procur procurav procurat',NULL,NULL,'/proːˈkuː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30013,'procuratio','n','procuration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30014,'procurator','n','procurator',NULL,NULL,'[proː.kuːˈraː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30018,'procursus','n','procurs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30023,'prodo','v','prod prodid prodit',NULL,NULL,'/ˈproː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30024,'prodeo','v','prod prodiv prodit','v2spia--4-=prodis v3spia--4-=prodit v1ppia--4-=prodimus v2ppia--4-=proditis v3ppia--4-=prodeunt v1siia--4-=prodibam v2siia--4-=prodibas v3siia--4-=prodibat v1piia--4-=prodibamus v2piia--4-=prodibatis v3piia--4-=prodibant v1sfia--4-=prodibo v2sfia--4-=prodibis v3sfia--4-=prodibit v1pfia--4-=prodibimus v2pfia--4-=prodibitis v3pfia--4-=prodibunt v-sppamn4-=prodiens v-sppafn4-=prodiens v-sppann4-=prodiens v-sfpamn4-=proditurus v-sfpafn4-=proditura v-sfpann4-=proditurum v-sfppmn4-=prodeundus v-sfppfn4-=prodeunda v-sfppnn4-=prodeundum v-s-gang4-=prodeundi v-s-damn4-=prodeundus v-s-dafn4-=prodeunda v-s-dann4-=prodeundum',NULL,'/ˈproː.de.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (30026,'prodecessor','n','prodecessor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (30032,'prodigo','v','prodig prodeg prodact',NULL,NULL,'[ˈproː.dɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30034,'prodigium','n','prodigi',NULL,NULL,'[proːˈdɪ.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30041,'proditor','n','proditor',NULL,NULL,'[ˈproː.dɪ.toːr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30045,'produco','v','produc produx product',NULL,NULL,'/proːˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30047,'producto','v','product productav producta',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (30051,'proelium','n','proeli',NULL,NULL,'[ˈproe̯.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30052,'proelior','v','proeli proeliat -',NULL,NULL,'[ˈproe̯.li.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (30055,'profanus','a','profan profan profan',NULL,NULL,'[prɔˈfaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30056,'profano','v','profan profanav profanat',NULL,NULL,'[prɔˈfaː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30057,'profectus','n','profect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30059,'profectio','n','profection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30061,'profecto','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30062,'profero','v','profer protul prolat','v--pna--3-=proferre v2spia--3-=profers v3spia--3-=profert v2ppia--3-=profertis',NULL,'[ˈproː.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30063,'professio','n','profession',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30069,'proficiscor','v','proficisc profect -',NULL,NULL,'/pro.fiˈkiːs.kor/','v1spid--3-');
INSERT INTO latin_morpho VALUES (30070,'proficuus','a','proficu proficu proficu',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (30072,'profiteor','v','profit profess -',NULL,NULL,'[proːˈfɪ.te.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (30073,'proflo','v','profl proflav proflat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (30074,'profligo','v','proflig proflix proflict',NULL,NULL,'/proːˈfliː.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30081,'profugio','v','profug profug profugit',NULL,NULL,'[proːˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (30082,'profundum','n','profund',NULL,NULL,'[prɔˈfʊn.dũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30083,'profundus','a','profund profund profund',NULL,NULL,'/proˈfun.dus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (30084,'profundo','v','profund profud profus',NULL,NULL,'[prɔˈfʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30085,'profunditas','n','profunditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30087,'profusio','n','profusion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30090,'progenero','v','progener progenerav progenerat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (30091,'progenies','n','progeni',NULL,NULL,'[proːˈɡɛ.ni.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (30092,'progenitor','n','progenitor',NULL,NULL,'[proːˈɡɛ.nɪ.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30094,'progigno','v','progign progenu progenit',NULL,NULL,'[proːˈɡɪŋ.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30098,'programma','n','programmat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (30101,'progredior','v','progred progress -',NULL,NULL,'[proːˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (30102,'progressus','n','progress',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30103,'progressio','n','progression',NULL,NULL,'[proːˈɡrɛs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30106,'prohibeo','v','prohib prohibu prohibit',NULL,NULL,'[prɔˈhɪ.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (30108,'prohibitio','n','prohibition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30121,'prolabor','v','prolab prolaps -',NULL,NULL,'[proːˈɫaː.bɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (30123,'prolato','v','prolat prolatav prolatat',NULL,NULL,'[proːˈɫaː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30124,'prolatio','n','prolation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30126,'proles','n','prol',NULL,NULL,'[ˈproː.ɫeːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (30128,'proletarius','a','proletari proletari proletari',NULL,NULL,'[proː.ɫeːˈtaː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30131,'prolixus','a','prolix prolix prolix',NULL,NULL,'[proːˈlɪk.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30133,'prolixe','r',NULL,NULL,NULL,'[proːˈlɪk.seː]','rp--------');
INSERT INTO latin_morpho VALUES (30135,'prologus','n','prolog',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (30136,'prolongo','v','prolong prolongav prolongat',NULL,NULL,'[proːˈɫɔŋ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30138,'proloquium','n','proloqui',NULL,NULL,'[proːˈɫɔ.kᶣi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30141,'proluvies','n','proluvi',NULL,NULL,NULL,'n-s---fn5-');
INSERT INTO latin_morpho VALUES (30143,'promus','n','prom',NULL,NULL,'[ˈproː.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (30144,'promo','v','prom promps prompt',NULL,NULL,'/ˈproː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30149,'promereo','v','promer promeru promerit',NULL,NULL,'[proːˈmɛ.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (30153,'promineo','v','promin prominu -',NULL,NULL,'[proːˈmɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (30156,'prominentia','n','prominenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30159,'promissum','n','promiss',NULL,NULL,'[proːˈmɪs.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30161,'promissio','n','promission',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30163,'promitto','v','promitt promis promiss',NULL,NULL,'[proːˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30168,'promotio','n','promotion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30172,'promptus','a','prompt prompt prompt',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (30176,'promptuarium','n','promptuari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (30186,'promunturium','n','promunturi',NULL,NULL,'[proː.mʊnˈtʊ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30194,'pronuntio','v','pronunti pronuntiav pronuntiat',NULL,NULL,'/proːˈnuːn.ti.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30195,'pronuntiatio','n','pronuntiation',NULL,NULL,'[proː.nuːn.tɪˈaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30197,'prooemium','n','prooemi',NULL,NULL,'[prɔˈoe̯.mi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30199,'propago','v','propag propagav propagat',NULL,NULL,'/proːˈpaː.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30201,'propagatio','n','propagation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30202,'propago','n','propagin',NULL,NULL,'/proːˈpaː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30204,'propalam','r',NULL,NULL,NULL,'/ˈproː.pa.lam/','rp--------');
INSERT INTO latin_morpho VALUES (30208,'propatulus','a','propatul propatul propatul',NULL,NULL,'[proːˈpa.tʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30210,'prope','r',NULL,'rc--------=propius rs--------=proxime',NULL,'[ˈprɔ.pɛ]','rp--------');
INSERT INTO latin_morpho VALUES (30212,'propello','v','propell propul propuls',NULL,NULL,'[proːˈpɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30214,'propemodum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30217,'propensio','n','propension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30220,'propero','v','proper properav properat',NULL,NULL,'[ˈprɔ.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30222,'properantia','n','properanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30227,'propheta','n','prophet',NULL,NULL,'/proˈpʰeː.ta/','n-s---mn1-');
INSERT INTO latin_morpho VALUES (30229,'propheto','v','prophet - prophetat',NULL,NULL,'[prɔˈpʰeː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30230,'prophetia','n','propheti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30231,'prophetizo','v','prophetiz prophetizav prophetizat',NULL,NULL,'[prɔ.pʰeːˈtiː.zoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30238,'propinquus','a','propinqu propinqu propinqu',NULL,NULL,'[prɔˈpɪŋ.kʷʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30240,'propinquitas','n','propinquitat',NULL,NULL,'[prɔˈpɪŋ.kᶣɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30242,'propitius','a','propiti propiti propiti',NULL,NULL,'[prɔˈpɪ.ti.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30248,'propola','n','propol',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30249,'propoma','n','propomat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (30250,'propono','v','propon proposu proposit',NULL,NULL,'/proːˈpoː.noː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30252,'proportio','n','proportion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30255,'proportionalitas','n','proportionalitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30256,'propositum','n','proposit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (30257,'propositio','n','proposition',NULL,NULL,'[proː.pɔˈsɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30260,'proprius','a','propri propri propri',NULL,NULL,'[ˈproː.pri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30261,'proprie','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30268,'propugnaculum','n','propugnacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (30270,'propugnator','n','propugnator',NULL,NULL,'[proː.pʊŋˈnaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30272,'propulso','v','propuls propulsav propulsat',NULL,NULL,'[proːˈpʊɫ.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30277,'prora','n','pror',NULL,NULL,'/ˈproː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30283,'prorito','v','prorit proritav proritat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (30284,'prorogo','v','prorog prorogav prorogat',NULL,NULL,'[ˈproː.rɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30285,'prorogatio','n','prorogation',NULL,NULL,'[proː.rɔˈɡaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30287,'prorsum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30288,'prorsus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30289,'proruo','v','proru proru prorut',NULL,NULL,'[ˈproː.rʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30290,'prorumpo','v','prorump prorup prorupt',NULL,NULL,'[proːˈrʊm.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30295,'prosapia','n','prosapi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30296,'proscaenium','n','proscaeni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (30297,'proscindo','v','proscind proscid prosciss',NULL,NULL,'[proːsˈkɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30298,'proscribo','v','proscrib proscrips proscript',NULL,NULL,'/proːsˈkriː.boː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30300,'proscriptio','n','proscription',NULL,NULL,'/proːsˈkriːp.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30303,'proseda','n','prosed',NULL,NULL,'[ˈprɔ.sɛ.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30309,'prosequor','v','prosequ prosecut -',NULL,NULL,'[ˈproː.sɛ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (30310,'prosero','v','proser prosev prosat',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (30313,'prosilio','v','prosil prosiliv -',NULL,NULL,'[proːˈsɪ.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (30319,'prospectus','n','prospect',NULL,NULL,'[prɔsˈpɛk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (30323,'prospero','v','prosper prosperav prosperat',NULL,NULL,'/ˈpros.pe.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30324,'prosperus','a','prosper prosper prosper',NULL,NULL,'[ˈprɔs.pɛ.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30325,'prosperitas','n','prosperitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30326,'prospicio','v','prospic prospex prospect',NULL,NULL,'[proːsˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (30329,'prosterno','v','prostern prostrav prostrat',NULL,NULL,'[proːsˈtɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30333,'prostibulum','n','prostibul',NULL,NULL,'[proːsˈtɪ.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30335,'prostituta','n','prostitut',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30337,'prostitutio','n','prostitution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30342,'protectio','n','protection',NULL,NULL,'[proːˈtɛk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30343,'protector','n','protector',NULL,NULL,'[proːˈtɛk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30344,'protego','v','proteg protex protect',NULL,NULL,'[ˈproː.tɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30346,'protelum','n','protel',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (30347,'protelo','v','protel protelav protelat',NULL,NULL,'[proːˈteː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30348,'protendo','v','protend protend protent',NULL,NULL,'[proːˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30350,'protero','v','proter protriv protrit',NULL,NULL,'[ˈproː.tɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30355,'protestor','v','protest protestat -',NULL,NULL,'Hyphenation: prō‧tes‧tor','v1spid--1-');
INSERT INTO latin_morpho VALUES (30358,'protestatio','n','protestation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30363,'protinam','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30368,'protraho','v','protrah protrax protract',NULL,NULL,'/ˈproː.tra.hoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30369,'protritus','a','protrit protrit protrit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (30371,'protrudo','v','protrud protrus protrus',NULL,NULL,'/proːˈtruː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30373,'proturbo','v','proturb proturbav proturbat',NULL,NULL,'[proːˈtʊr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30376,'provectus','a','provect provect provect',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (30377,'provectio','n','provection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30378,'proveho','v','proveh provex provect',NULL,NULL,'[ˈproː.wɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30380,'proventus','n','provent',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30381,'proverbium','n','proverbi',NULL,NULL,'[proːˈwɛr.bi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30382,'proverbialis','a','proverbial proverbial proverbial',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (30383,'proverbialiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30384,'providus','a','provid provid provid',NULL,NULL,'[ˈproː.wɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30385,'provideo','v','provid provid provis',NULL,NULL,'[proːˈwɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (30386,'providentia','n','providenti',NULL,NULL,'[proː.wɪˈdɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30388,'provincia','n','provinci',NULL,NULL,'/proːˈwin.ki.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30393,'provoco','v','provoc provocav provocat',NULL,NULL,'[ˈproː.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30394,'provocatio','n','provocation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30400,'proxeneta','n','proxenet',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (30405,'proximo','v','proxim proximav proxima',NULL,NULL,'[ˈprɔk.sɪ.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30407,'proximitas','n','proximitat',NULL,NULL,'[prɔkˈsɪ.mɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30410,'prudens','a','prudent prudent prudent',NULL,NULL,'[ˈpruː.dẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (30411,'prudenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30412,'prudentia','n','prudenti',NULL,NULL,'[pruːˈdɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30413,'pruina','n','pruin',NULL,NULL,'[prʊˈiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30416,'prunus','n','prun',NULL,NULL,'[ˈpruː.nʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (30417,'prunum','n','prun',NULL,NULL,'[ˈpruː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30420,'prurigo','n','prurigin',NULL,NULL,'/pruːˈriː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30421,'pruritus','n','prurit',NULL,NULL,'[pruːˈriː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (30425,'psalmus','n','psalm',NULL,NULL,'[ˈpsaɫ.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (30426,'psalmista','n','psalmist',NULL,NULL,NULL,'n-s---mn1-');
INSERT INTO latin_morpho VALUES (30427,'psalmodia','n','psalmodi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30443,'psittacus','n','psittac',NULL,NULL,'[ˈpsɪt.ta.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (30477,'pubertas','n','pubertat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30483,'publicus','a','public public public',NULL,NULL,'[ˈpuː.blɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30484,'publico','v','public publicav publicat',NULL,NULL,'[ˈpuː.blɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30487,'publicatio','n','publication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30491,'publicitus','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30496,'pudens','a','pudent pudent pudent',NULL,NULL,'[ˈpʊ.dẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (30499,'pudicus','a','pudic pudic pudic',NULL,NULL,'[pʊˈdiː.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30500,'pudicitia','n','pudiciti',NULL,NULL,'[pʊ.diːˈkɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30501,'pudor','n','pudor',NULL,NULL,'[ˈpʊ.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30502,'puella','n','puell',NULL,NULL,'[pʊˈɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30503,'puellus','n','puell',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (30505,'puellula','n','puellul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30507,'puer','n','puer',NULL,NULL,'[ˈpʊ.ɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (30518,'pugil','n','pugil',NULL,NULL,'[ˈpʊ.ɡɪɫ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30520,'pugilatus','n','pugilat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30523,'pugillus','n','pugill',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (30528,'pugio','n','pugion',NULL,NULL,'/ˈpuː.ɡi.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30530,'pugna','n','pugn',NULL,NULL,'[ˈpʊŋ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30531,'pugnus','n','pugn',NULL,NULL,'[ˈpʊŋ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (30532,'pugno','v','pugn pugnav pugnat',NULL,NULL,'[ˈpʊŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30535,'pugnator','n','pugnator',NULL,NULL,'[pʊŋˈnaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30540,'pulcher','a','  ',NULL,NULL,'[ˈpʊɫ.kʰɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (30541,'pulchre','r',NULL,'rs--------=pulcherrime',NULL,'[ˈpʊɫ.kʰreː]','rp--------');
INSERT INTO latin_morpho VALUES (30543,'pulchritudo','n','pulchritudin',NULL,NULL,'[pʊɫ.kʰrɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30549,'pulex','n','pulic',NULL,NULL,'[ˈpuː.ɫɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30556,'pulmentum','n','pulment',NULL,NULL,'[pʊɫˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30560,'pulpa','n','pulp',NULL,NULL,'[ˈpʊɫ.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30562,'pulpitum','n','pulpit',NULL,NULL,'[ˈpʊɫ.pɪ.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30563,'pulsus','n','puls',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30564,'pulso','v','puls pulsav pulsat',NULL,NULL,'[ˈpʊɫ.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30569,'pulto','v','pult pultav pultat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (30575,'pulvinus','n','pulvin',NULL,NULL,'[pʊɫˈwiː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (30578,'pulvis','n','pulver',NULL,NULL,'[ˈpʊɫ.wɪs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (30580,'pumex','n','pumic',NULL,NULL,'[ˈpuː.mɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30585,'pumilio','n','pumilion',NULL,NULL,NULL,'n-s---cn3-');
INSERT INTO latin_morpho VALUES (30588,'punctum','n','punct',NULL,NULL,'[ˈpʊŋk.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30593,'pungo','v','pung pupug punct',NULL,NULL,'[ˈpʊŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30595,'punio','v','pun puniv punit',NULL,NULL,'/ˈpuː.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (30597,'Punicus','a','Punic Punic Punic',NULL,NULL,'ˈpuː.nɪ.kʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (30600,'Puniceus','a','Punice Punice Punice',NULL,NULL,'puːnikeus','aps---mn1-');
INSERT INTO latin_morpho VALUES (30602,'punitor','n','punitor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (30604,'pupa','n','pup',NULL,NULL,'/ˈpuː.pa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30610,'puppis','n','pupp',NULL,NULL,'/ˈpup.pis/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30614,'purus','a','pur pur pur',NULL,NULL,'[ˈpuː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30615,'purgo','v','purg purgav purgat',NULL,NULL,'/ˈpuːr.ɡoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30616,'purgamen','n','purgamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (30617,'purgamentum','n','purgament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (30618,'purgatio','n','purgation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30620,'purifico','v','purific purificav purificat',NULL,NULL,'[puːˈrɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30632,'pus','n','pur',NULL,NULL,'/puːs/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (30633,'pusa','n','pus',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30634,'pusus','n','pus',NULL,NULL,'[ˈpuː.sʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (30645,'pustula','n','pustul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30648,'puto','v','put putav putat',NULL,NULL,'[ˈpʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30650,'putamen','n','putamin',NULL,NULL,'[pʊˈtaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (30651,'putatio','n','putation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30653,'puteus','n','pute',NULL,NULL,'[ˈpʊ.te.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (30662,'putris','a','putr putr putr',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (30664,'putredo','n','putredin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30665,'putrefacio','v','putrefac putrefec putrefact',NULL,NULL,'[puː.trɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (30668,'putresco','v','putresc putru -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (30674,'pyelus','n','pyel',NULL,NULL,'[ˈpʏ.ɛ.ɫʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (30678,'pylorus','n','pylor',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (30679,'pyra','n','pyr',NULL,NULL,'[ˈpʏ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30680,'pyramis','n','pyramid',NULL,NULL,'[ˈpyː.ra.mɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30701,'Pythagoricus','a','Pythagoric Pythagoric Pythagoric',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (30703,'pythonicus','a','pythonic pythonic pythonic',NULL,NULL,'[pyːˈtʰoː.nɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30795,'quadrum','n','quadr',NULL,NULL,'[ˈkʷaː.drũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (30797,'quadro','v','quadr quadrav quadrat',NULL,NULL,'/ˈkʷa.droː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (30801,'quadragesima','n','quadragesim',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30805,'quadrangulatus','a','quadrangulat quadrangulat quadrangulat',NULL,NULL,'[kʷaː.draŋ.ɡʊˈɫaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30807,'quadrantal','n','quadrantal',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (30812,'quadriangulus','a','quadriangul quadriangul quadriangul',NULL,NULL,'[kʷaː.drɪˈaŋ.ɡʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30843,'quadrupedans','a','quadrupedant quadrupedant quadrupedant',NULL,NULL,'[kʷaˈdrʊ.pɛ.dãːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (30846,'quadrupes','a','quadruped quadruped quadruped',NULL,NULL,'[ˈkʷa.drʊ.peːs]','aps---an3-');
INSERT INTO latin_morpho VALUES (30854,'quaero','v','quaer quaesi quaesit',NULL,NULL,'/ˈkʷae̯.roː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30855,'quaerito','v','quaerit quaeritav quaeritat',NULL,NULL,'[ˈkʷae̯.rɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (30856,'quaeso','v','quaes - -',NULL,NULL,'/ˈkʷae̯.soː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (30857,'quaesitum','n','quaesit',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (30858,'quaesitus','a','quaesit quaesit quaesit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (30860,'quaestus','n','quaest',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30862,'quaestio','n','quaestion',NULL,NULL,'/ˈkʷae̯s.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30868,'quaestuosus','a','quaestuos quaestuos quaestuos',NULL,NULL,'[kʷae̯s.tʊˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30876,'qualitas','n','qualitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30881,'quam','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (30894,'quando','r',NULL,NULL,NULL,'/ˈkʷan.doː/','rp--------');
INSERT INTO latin_morpho VALUES (30903,'quantitas','n','quantitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (30940,'quatio','v','quat - quass',NULL,NULL,'/ˈkʷa.ti.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (30952,'quemadmodum','r',NULL,NULL,NULL,'[kᶣɛˈmad.mɔ.dũ]','rp--------');
INSERT INTO latin_morpho VALUES (30953,'queror','v','quer quest -',NULL,NULL,'[ˈkᶣɛ.rɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (30954,'quercus','n','querc',NULL,NULL,'[ˈkᶣɛr.kʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (30958,'querella','n','querell',NULL,'n-s---fn1-=querela','[kᶣɛˈrɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (30960,'querimonia','n','querimoni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (30967,'questus','n','quest',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (30973,'quidem','r',NULL,NULL,NULL,'[ˈkᶣɪ.dẽ]','rp--------');
INSERT INTO latin_morpho VALUES (30976,'quies','n','quiet',NULL,NULL,'[ˈkᶣi.eːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (30977,'quiesco','v','quiesc quiev quiet',NULL,NULL,'[kᶣɪˈeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (30978,'quietus','a','quiet quiet quiet',NULL,NULL,'[kᶣɪˈeː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (30979,'quiete','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31031,'quippe','r',NULL,NULL,NULL,'[ˈkᶣɪp.pɛ]','rp--------');
INSERT INTO latin_morpho VALUES (31038,'quiritatus','n','quiritat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (31073,'quoque','r',NULL,NULL,NULL,'[ˈkʷoː.kᶣɛ]','rp--------');
INSERT INTO latin_morpho VALUES (31112,'res','n','r',NULL,NULL,'/reːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (31113,'reor','v','r rat -',NULL,NULL,'[ˈre.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (31118,'rabies','n','rabi',NULL,NULL,'/ˈra.bi.eːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (31119,'rabidus','a','rabid rabid rabid',NULL,NULL,'[ˈra.bɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31130,'rado','v','rad ras ras',NULL,NULL,'/ˈraː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (31132,'radius','n','radi',NULL,NULL,'[ˈra.di.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31133,'radio','v','radi radiav radiat',NULL,NULL,'/ˈra.di.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (31156,'radix','n','radic',NULL,NULL,'/ˈraː.diːks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31160,'ramus','n','ram',NULL,NULL,'[ˈraː.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31167,'ramulus','n','ramul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (31168,'ramusculus','n','ramuscul',NULL,NULL,'[raːˈmʊs.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31169,'rana','n','ran',NULL,NULL,'/ˈraː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31171,'rancidus','a','rancid rancid rancid',NULL,NULL,'[ˈraŋ.kɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31174,'rapa','n','rap',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (31175,'rapum','n','rap',NULL,NULL,'[ˈraː.pũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (31177,'rapacitas','n','rapacitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31178,'rapax','a','rapac rapac rapac',NULL,NULL,'/ˈra.paːks/','aps---an3i');
INSERT INTO latin_morpho VALUES (31179,'raphanus','n','raphan',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (31183,'rapio','v','rap rapu rapt',NULL,NULL,'/ˈra.pi.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (31186,'rapina','n','rapin',NULL,NULL,'/raˈpiː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31188,'raptus','n','rapt',NULL,NULL,'[ˈrap.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (31189,'rapto','v','rapt raptav raptat',NULL,NULL,'/ˈrap.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (31190,'raptim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31191,'raptor','n','raptor',NULL,NULL,'[ˈrap.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31193,'rarus','a','rar rar rar',NULL,NULL,'[ˈraː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31194,'rare','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31197,'rarenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31199,'raro','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31200,'rasilis','a','rasil rasil rasil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (31202,'rasorium','n','rasori',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (31206,'rastellus','n','rastell',NULL,NULL,'[raːsˈtɛl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31210,'ratus','a','rat rat rat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (31214,'ratihabitio','n','ratihabition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31215,'ratio','n','ration',NULL,NULL,'/ˈra.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31216,'ratiocinor','v','ratiocin ratiocinat -',NULL,NULL,'[ra.tɪˈoː.kɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (31217,'ratiocinatio','n','ratiocination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31218,'ratiocinativus','a','ratiocinativ ratiocinativ ratiocinativ',NULL,NULL,'[ra.ti.oː.kɪ.naːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31220,'ratiocinium','n','ratiocini',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (31221,'rationabilis','a','rationabil rationabil rationabil',NULL,NULL,'[ra.ti.oːˈnaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (31224,'rationalis','a','rational rational rational',NULL,NULL,'[ra.ti.oːˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (31234,'ratis','n','rat',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (31242,'Ravenna','n','Ravenn',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (31244,'reus','n','re',NULL,NULL,'[ˈre.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31255,'reatus','n','reat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (31259,'rebello','v','rebell rebellav rebellat',NULL,NULL,'[rɛˈbɛl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31261,'rebellatrix','n','rebellatric',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31262,'rebellio','n','rebellion',NULL,NULL,'/reˈbel.li.oː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31265,'reboo','v','rebo reboav reboat',NULL,NULL,'[ˈrɛ.bɔ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31272,'recanto','v','recant recantav recantat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31273,'recapitulo','v','recapitul recapitulav recapitulat',NULL,NULL,'[rɛ.kaˈpɪ.tʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31274,'recapitulatio','n','recapitulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31276,'recedo','v','reced recess recess',NULL,NULL,'[rɛˈkeː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31279,'recenseo','v','recens recensu recens',NULL,NULL,'[rɛˈkẽː.se.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31285,'recepto','v','recept receptav receptat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31286,'receptaculum','n','receptacul',NULL,NULL,'[rɛ.kɛpˈtaː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (31287,'receptio','n','reception',NULL,NULL,'[rɛˈkɛp.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31293,'recido','v','recid recid recis',NULL,NULL,'[ˈrɛ.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31295,'recino','v','recin - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (31303,'recipio','v','recip recep recept',NULL,NULL,'[rɛˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (31307,'recito','v','recit recitav recitat',NULL,NULL,'[ˈrɛ.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31315,'recludo','v','reclud reclus reclus',NULL,NULL,'[rɛˈkɫuː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31316,'recogito','v','recogit recogitav recogitat',NULL,NULL,'[rɛˈkoː.ɡɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31317,'recognitio','n','recognition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31321,'recolligo','v','recollig recolleg recollect',NULL,NULL,'[rɛˈkɔl.lɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31324,'reconcilio','v','reconcili reconciliav reconciliat',NULL,NULL,'[rɛ.kɔŋˈkɪ.li.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31325,'reconciliatio','n','reconciliation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31328,'recondo','v','recond recondid recondit',NULL,NULL,'[rɛˈkɔn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31332,'recordor','v','record recordat -',NULL,NULL,'[rɛˈkɔr.dɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (31333,'recordatio','n','recordation',NULL,NULL,'[rɛ.kɔrˈdaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31334,'recreo','v','recre recreav recreat',NULL,NULL,'[ˈrɛ.kre.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31335,'recreatio','n','recreation',NULL,NULL,'[rɛ.krɛˈaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31336,'recrepo','v','recrep recrepav recrepat',NULL,NULL,'[ˈrɛ.krɛ.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31340,'rectus','a','rect rect rect',NULL,NULL,'[ˈreːk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31341,'recta','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31342,'recte','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31347,'rectitudo','n','rectitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31348,'rector','n','rector',NULL,NULL,'[ˈreːk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31352,'recumbo','v','recumb recubu -',NULL,NULL,'[rɛˈkʊm.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31353,'recupero','v','recuper recuperav recuperat',NULL,NULL,'[rɛˈkʊ.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31354,'recuperatio','n','recuperation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31358,'recuro','v','recur recurav recurat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31359,'recurro','v','recurr recurr recurs',NULL,NULL,'[rɛˈkʊr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31361,'recursus','n','recurs',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (31365,'recuso','v','recus recusav recusat',NULL,NULL,'[rɛˈkuː.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31366,'recusatio','n','recusation',NULL,NULL,'[rɛ.kuːˈsaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31373,'redarguo','v','redargu redargu redargut',NULL,NULL,'[rɛˈdar.ɡʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31375,'reddo','v','redd reddid reddit',NULL,NULL,'[ˈrɛd.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31376,'redeo','v','red rediv redit','v2spia--4-=redis v3spia--4-=redit v1ppia--4-=redimus v2ppia--4-=reditis v3ppia--4-=redeunt v1siia--4-=redibam v2siia--4-=redibas v3siia--4-=redibat v1piia--4-=redibamus v2piia--4-=redibatis v3piia--4-=redibant v1sfia--4-=redibo v2sfia--4-=redibis v3sfia--4-=redibit v1pfia--4-=redibimus v2pfia--4-=redibitis v3pfia--4-=redibunt v-sppamn4-=rediens v-sppafn4-=rediens v-sppann4-=rediens v-sfpamn4-=rediturus v-sfpafn4-=reditura v-sfpann4-=rediturum v-sfppmn4-=redeundus v-sfppfn4-=redeunda v-sfppnn4-=redeundum v-s-gang4-=redeundi v-s-damn4-=redeundus v-s-dafn4-=redeunda v-s-dann4-=redeundum',NULL,'[ˈrɛ.de.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (31377,'redemptio','n','redemption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31378,'redemptor','n','redemptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (31382,'redigo','v','redig redeg redact',NULL,NULL,'[ˈrɛ.dɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31383,'redimo','v','redim redem redempt',NULL,NULL,'[ˈrɛ.dɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31385,'redimio','v','redim redimi redimit',NULL,NULL,'[rɛˈdɪ.mi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (31389,'reditus','n','redit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (31396,'redono','v','redon redonav redonat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31399,'reduco','v','reduc redux reduct',NULL,NULL,'[rɛˈduː.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31402,'reductor','n','reductor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (31403,'reduncus','a','redunc redunc redunc',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (31404,'redundo','v','redund redundav redundat',NULL,NULL,'[rɛˈdʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31407,'reduvia','n','reduvi',NULL,'n-s---fn1-=redivia','[rɛˈdʊ.wi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31410,'refectio','n','refection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31412,'refector','n','refector',NULL,NULL,'[rɛˈfɛk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31415,'refello','v','refell refell -',NULL,NULL,'[rɛˈfɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31416,'refero','v','refer retul relat','v--pna--3-=referre v2spia--3-=refers v3spia--3-=refert v2ppia--3-=refertis',NULL,'[ˈrɛ.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31424,'reficio','v','refic refec refect',NULL,NULL,'[rɛˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (31425,'refigo','v','refig refix refix',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (31434,'refocillo','v','refocill refocillav refocillat',NULL,NULL,'[rɛ.fɔˈkɪl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31437,'reformo','v','reform reformav reformat',NULL,NULL,'[rɛˈfoːr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31439,'reformido','v','reformid reformidav reformidat',NULL,NULL,'[rɛ.fɔrˈmiː.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31440,'refoveo','v','refov refov refot',NULL,NULL,'[rɛˈfɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31446,'refreno','v','refren refrenav refrenat',NULL,NULL,'[rɛˈfreː.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31450,'refrigerium','n','refrigeri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (31451,'refrigesco','v','refrigesc refrix -',NULL,NULL,'[rɛ.friːˈɡeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31454,'refugio','v','refug refug -',NULL,NULL,'[rɛˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (31455,'refugium','n','refugi',NULL,NULL,'[rɛˈfʊ.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (31456,'refulgeo','v','refulg refuls -',NULL,NULL,'[rɛˈfʊɫ.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31459,'refuto','v','refut refutav refutat',NULL,NULL,'[rɛˈfuː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31462,'rego','v','reg rex rect',NULL,NULL,'[ˈrɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31464,'regeneratio','n','regeneration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31466,'regia','n','regi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (31470,'regimen','n','regimin',NULL,NULL,'[ˈrɛ.ɡɪ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (31471,'regina','n','regin',NULL,NULL,'/reːˈɡiː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31472,'regio','n','region',NULL,NULL,'[ˈrɛ.ɡi.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31475,'regnum','n','regn',NULL,NULL,'[ˈreːŋ.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (31476,'regno','v','regn regnav regnat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31477,'regnator','n','regnator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (31479,'regredior','v','regred regress -',NULL,NULL,'[rɛˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (31480,'regressus','n','regress',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (31482,'regula','n','regul',NULL,NULL,'[ˈreː.ɡʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31483,'regulus','n','regul',NULL,NULL,'[ˈreː.ɡʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31485,'regularis','a','regular regular regular',NULL,NULL,'[reː.ɡʊˈɫaː.rɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (31491,'reicio','v','reic reiec reiect',NULL,NULL,'[rɛjˈjɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (31503,'relatus','n','relat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (31504,'relatio','n','relation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31507,'relativus','a','relativ relativ relativ',NULL,NULL,'[rɛ.ɫaːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31508,'relative','r',NULL,NULL,NULL,'[rɛ.ɫaːˈtiː.weː]','rp--------');
INSERT INTO latin_morpho VALUES (31513,'relaxo','v','relax relaxav relaxat',NULL,NULL,'[rɛˈɫak.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31514,'relego','v','releg releg relect',NULL,NULL,'[ˈrɛ.ɫɛ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31518,'relevo','v','relev relevav relevat',NULL,NULL,'[ˈrɛ.ɫɛ.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31527,'relido','v','relid relis relis',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (31530,'religio','n','religion',NULL,NULL,'[rɛˈlɪ.ɡi.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31532,'religiosus','a','religios religios religios',NULL,NULL,'[rɛ.lɪ.ɡɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31533,'religiose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31544,'remus','n','rem',NULL,NULL,'[ˈreː.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31546,'remaneo','v','reman remans remans',NULL,NULL,'[rɛˈma.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31548,'remeo','v','reme remeav remeat',NULL,NULL,'[ˈrɛ.me.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31549,'remedium','n','remedi',NULL,NULL,'[rɛˈmɛ.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (31552,'remex','n','remig',NULL,NULL,'[ˈreː.mɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31553,'remigo','v','remig remigav remigat',NULL,NULL,'[ˈreː.mɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31556,'remigro','v','remigr remigrav remigrat',NULL,NULL,'[ˈrɛ.mɪ.ɡroː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31557,'reminiscor','v','reminisc  -',NULL,NULL,'[rɛ.mɪˈniːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (31561,'remissus','a','remiss remiss remiss',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (31564,'remitto','v','remitt remis remiss',NULL,NULL,'[rɛˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31569,'remoror','v','remor remorat -',NULL,NULL,'[ˈrɛ.mɔ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (31574,'removeo','v','remov remov remot',NULL,NULL,'[rɛˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31575,'remugio','v','remug remugiv remugit',NULL,NULL,'[rɛˈmuː.ɡi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (31580,'remuneror','v','remuner remunerat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (31581,'remuneratio','n','remuneration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31589,'renideo','v','renid - -',NULL,NULL,'[rɛˈniː.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31596,'renovo','v','renov renovav renovat',NULL,NULL,'[ˈrɛ.nɔ.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31598,'renovatio','n','renovation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31599,'renuo','v','renu renu -',NULL,NULL,'[ˈrɛ.nʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31604,'renuntio','v','renunti renuntiav renuntiat',NULL,NULL,'[rɛˈnʊn.ti.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31607,'repo','v','rep reps rept',NULL,NULL,'/ˈreː.poː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (31610,'reparo','v','repar reparav reparat',NULL,NULL,'[ˈrɛ.pa.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31612,'reparatio','n','reparation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31617,'repedo','v','reped repedav repedat',NULL,NULL,'[ˈrɛ.pɛ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31618,'repello','v','repell repul repuls',NULL,NULL,'[rɛˈpɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31620,'rependo','v','repend repend repens',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (31621,'repens','a','repent repent repent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (31623,'repentinus','a','repentin repentin repentin',NULL,NULL,'[rɛ.pɛnˈtiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31627,'repercussio','n','repercussion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31628,'repercutio','v','repercut repercuss repercuss',NULL,NULL,'[rɛ.pɛrˈkʊ.ti.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (31629,'reperio','v','reper reper repert',NULL,NULL,'[rɛˈpɛ.ri.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (31630,'repertum','n','repert',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (31631,'repertor','n','repertor',NULL,NULL,'[rɛˈpɛr.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31632,'repeto','v','repet repetiv repetit',NULL,NULL,'[ˈrɛ.pɛ.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31634,'repetitio','n','repetition',NULL,NULL,'[rɛ.pɛˈtiː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31642,'replico','v','replic replicav replicat',NULL,NULL,'[ˈrɛ.plɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31644,'repono','v','repon reposu reposit',NULL,NULL,'[rɛˈpoː.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31645,'reporto','v','report reportav reportat',NULL,NULL,'[rɛˈpɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31649,'repositorium','n','repositori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (31651,'repostor','n','repostor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (31655,'repraesento','v','repraesent repraesentav repraesentat',NULL,NULL,'[rɛ.prae̯ˈsɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31657,'reprehendo','v','reprehend reprehend reprehens',NULL,NULL,'[rɛ.prɛˈhɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31660,'reprehensio','n','reprehension',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31663,'reprimo','v','reprim repress repress',NULL,NULL,'[ˈrɛ.prɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31665,'reprobo','v','reprob - reprobat',NULL,NULL,'[ˈrɛ.prɔ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31666,'reprobatio','n','reprobation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31670,'repromitto','v','repromitt repromis repromiss',NULL,NULL,'[rɛ.proːˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31671,'repto','v','rept reptav reptat',NULL,NULL,'/ˈreːp.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (31678,'repudium','n','repudi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (31679,'repudio','v','repudi repudiav repudiat',NULL,NULL,'[rɛˈpʊ.di.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31683,'repugnantia','n','repugnant',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (31686,'repulso','v','repuls repulsav repulsat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31690,'reputo','v','reput reputav reputat',NULL,NULL,'[ˈrɛ.pʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31692,'requies','n','requi',NULL,NULL,'[ˈrɛ.kᶣi.eːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31694,'requiesco','v','requiesc requiev requiet',NULL,NULL,'[rɛ.kᶣɪˈeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31695,'requietus','a','requiet requiet requiet',NULL,NULL,'[rɛ.kᶣɪˈeː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31696,'requietio','n','requietion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31697,'requiro','v','requir - requisit',NULL,NULL,'[rɛˈkᶣiː.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31704,'resarcio','v','resarc resars resart',NULL,NULL,'[rɛˈsar.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (31706,'rescindo','v','rescind rescid resciss',NULL,NULL,'[rɛsˈkɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31713,'resemino','v','resemin reseminav reseminat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31715,'resero','v','reser resev -',NULL,NULL,'[ˈrɛ.sɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31716,'reservo','v','reserv reservav reservat',NULL,NULL,'[rɛˈsɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31717,'reses','a','resid resid resid',NULL,NULL,NULL,'aps---an3-');
INSERT INTO latin_morpho VALUES (31718,'resideo','v','resid resed resess',NULL,NULL,'[rɛˈsɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31719,'resido','v','resid resed resess',NULL,NULL,'[rɛˈsiː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31723,'resigno','v','resign resignav resignat',NULL,NULL,'[rɛˈsɪŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31725,'resilio','v','resil resiliv result',NULL,NULL,'[rɛˈsɪ.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (31727,'resina','n','resin',NULL,NULL,'/reːˈsiː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31736,'resolutio','n','resolution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31737,'resolvo','v','resolv resolv resolut',NULL,NULL,'[rɛˈsɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31739,'resono','v','reson resonav resonat',NULL,NULL,'[ˈrɛ.sɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31742,'respectus','n','respect',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (31743,'respecto','v','respect respectav respectat',NULL,NULL,'[rɛsˈpɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31744,'respergo','v','resperg respers respers',NULL,NULL,'[reːsˈpɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31746,'respicio','v','respic respex respect',NULL,NULL,'[rɛsˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (31747,'respiro','v','respir respirav respirat',NULL,NULL,'[rɛsˈpiː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31752,'respondeo','v','respond respond respons',NULL,NULL,'[rɛsˈpɔn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31753,'responsum','n','respons',NULL,NULL,'[rɛsˈpõː.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (31754,'responso','v','respons responsav responsat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31763,'respuo','v','respu respu -',NULL,NULL,'[ˈrɛs.pʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31764,'resto','v','rest restav restat',NULL,NULL,'[ˈrɛs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31766,'restagno','v','restagn restagnav restagnat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31767,'restauro','v','restaur restaurav restaurat',NULL,NULL,'[rɛsˈtau̯.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31770,'restinguo','v','restingu restinx restinct',NULL,NULL,'[rɛsˈtɪŋ.ɡʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31774,'restis','n','rest',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (31776,'restituo','v','restitu restitu restitut',NULL,NULL,'[rɛsˈtɪ.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31777,'restitutio','n','restitution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31778,'restitutor','n','restitutor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (31784,'resumo','v','resum resumps resumpt',NULL,NULL,'[rɛˈsuː.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31788,'resurrectio','n','resurrection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31790,'retardo','v','retard retardav retardat',NULL,NULL,'[rɛˈtar.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31792,'rete','n','ret',NULL,NULL,'[ˈreː.tɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (31793,'retego','v','reteg retex retect',NULL,NULL,'[ˈrɛ.tɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31797,'retento','v','retempt retemptav retemptat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (31799,'retexo','v','retex retexu retext',NULL,NULL,'[rɛˈtɛk.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31808,'retineo','v','retin retinu retent',NULL,NULL,'[rɛˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (31809,'retinaculum','n','retinacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (31817,'retracto','v','retract retractav retractat',NULL,NULL,'[rɛˈtrak.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31820,'retribuo','v','retribu retribu retribut',NULL,NULL,'[rɛˈtrɪ.bʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31821,'retributio','n','retribution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31822,'retro','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31823,'retroago','v','retroag retroeg retroact',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (31832,'retundo','v','retund retud retus',NULL,NULL,'[rɛˈtʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31839,'revelo','v','revel revelav revelat',NULL,NULL,'[rɛˈweː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31843,'revenio','v','reven reven revent',NULL,NULL,'[rɛˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (31844,'revereor','v','rever reverit -',NULL,NULL,'[rɛˈwɛ.re.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (31850,'reverens','a','reverent reverent reverent',NULL,NULL,'[ˈrɛ.wɛ.rẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (31851,'reverenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31852,'reverentia','n','reverenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (31853,'reversio','n','reversion',NULL,'n-s---fn3-=revorsio',NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (31856,'revinco','v','revinc revic revict',NULL,NULL,'[rɛˈwɪŋ.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (31862,'revoco','v','revoc revocav revocat',NULL,NULL,'[ˈrɛ.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31870,'rex','n','reg',NULL,NULL,'/reːks/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31873,'Rhenus','n','Rhen',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (31875,'rhetor','n','rhetor',NULL,NULL,'[ˈreː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31877,'rhetorice','n','rhetoric',NULL,NULL,NULL,'n-s---fn1g');
INSERT INTO latin_morpho VALUES (31879,'rheumatismus','n','rheumatism',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (31880,'rhinoceros','n','rhinocerot',NULL,NULL,'[riːˈnɔ.kɛ.roːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31882,'Rhodanus','n','Rhodan',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (31883,'rhododendron','n','rhododendr',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (31888,'rhythmus','n','rhythm',NULL,NULL,'[ˈrʏtʰ.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31891,'rhythmicus','a','rhythmic rhythmic rhythmic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (31900,'rideo','v','rid ris ris',NULL,NULL,'/ˈriː.de.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (31911,'rigo','v','rig rigav rigat',NULL,NULL,'[ˈrɪ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31917,'rigor','n','rigor',NULL,NULL,'[ˈrɪ.ɡɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31919,'rima','n','rim',NULL,NULL,'/ˈriː.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31920,'rimor','v','rim rimat -',NULL,NULL,'[ˈriː.mɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (31923,'ringor','v','ring rict -',NULL,NULL,'[ˈrɪŋ.ɡɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (31928,'risus','n','ris',NULL,NULL,'[ˈriː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (31934,'ritus','n','rit',NULL,NULL,'[ˈriː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (31935,'rite','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (31939,'rivus','n','riv',NULL,NULL,'[ˈriː.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31942,'rivulus','n','rivul',NULL,NULL,'[ˈriː.wʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (31943,'rixa','n','rix',NULL,NULL,'[ˈrɪk.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (31946,'robus','a','rob rob rob',NULL,NULL,'[ˈroː.bʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31952,'robigo','n','robigin',NULL,NULL,'/roːˈbiː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (31956,'robur','n','robor',NULL,NULL,'[ˈroː.bʊr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (31964,'robustus','a','robust robust robust',NULL,NULL,'[roːˈbʊs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (31968,'rogo','v','rog rogav rogat',NULL,NULL,'[ˈrɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (31977,'Roma','n','Rom',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (31984,'Romulus','n','Romul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (31991,'ros','n','ror',NULL,NULL,'/roːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (31992,'rosa','n','ros',NULL,NULL,'[ˈrɔ.sa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32004,'rostrum','n','rostr',NULL,NULL,'[ˈroːs.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32009,'rotatio','n','rotation',NULL,NULL,'[rɔˈtaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32011,'rotundo','v','rotund rotundav rotundat',NULL,NULL,'[rɔˈtʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32012,'rotundus','a','rotund rotund rotund',NULL,NULL,'[rɔˈtʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32014,'rotunditas','n','rotunditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32015,'ruo','v','ru ru -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (32018,'rubeus','a','rube rube rube',NULL,'aps---mn1-=robeus',NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (32024,'ruber','a','  ',NULL,NULL,'[ˈrʊ.bɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (32025,'rubesco','v','rubesc rubu -',NULL,NULL,'[rʊˈbeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (32034,'rubor','n','rubor',NULL,NULL,'[ˈrʊ.bɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32039,'ructus','n','ruct',NULL,NULL,'[ˈruːk.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (32040,'ructo','v','ruct ructav ructat',NULL,NULL,'[ˈrʊk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32043,'rudo','v','rud rudiv rudit',NULL,NULL,'[ˈrʊ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (32045,'rudens','n','rudent',NULL,NULL,'[ˈrʊ.dẽːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (32047,'rudicula','n','rudicul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (32053,'rufus','a','ruf ruf ruf',NULL,NULL,'[ˈruː.fʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32056,'ruga','n','rug',NULL,NULL,'/ˈruː.ɡa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32060,'ruina','n','ruin',NULL,NULL,'[rʊˈiː.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32067,'rumor','n','rumor',NULL,NULL,'[ˈruː.mɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32068,'rumpo','v','rump rup rupt',NULL,NULL,'[ˈrʊm.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (32072,'runco','v','runc runcav runcat',NULL,NULL,'[ˈrʊŋ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32075,'rupes','n','rup',NULL,NULL,'/ˈruː.peːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (32081,'rursum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32083,'rus','n','rur',NULL,NULL,'/ruːs/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (32085,'russus','a','russ russ russ',NULL,NULL,'/ˈrus.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (32097,'ruta','n','rut',NULL,NULL,'/ˈruː.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32099,'rutabulum','n','rutabul',NULL,NULL,'[rʊˈtaː.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32104,'rutrum','n','rutr',NULL,NULL,'[ˈrʊ.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32122,'sabulum','n','sabul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32124,'saccus','n','sacc',NULL,NULL,'/ˈsak.kus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (32130,'sacciperium','n','sacciperi',NULL,NULL,'[sak.kɪˈpeː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32131,'sacculus','n','saccul',NULL,NULL,'[ˈsak.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (32133,'sacer','a','  ',NULL,NULL,'[ˈsa.kɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (32134,'sacerdos','n','sacerdot',NULL,NULL,'[saˈkɛr.doːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32137,'sacerdotium','n','sacerdoti',NULL,NULL,'[sa.kɛrˈdoː.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32139,'sacoma','n','sacomat',NULL,NULL,'/saːˈkoː.ma/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (32142,'sacro','v','sacr sacrav sacrat',NULL,NULL,'/ˈsa.kroː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (32143,'sacramentum','n','sacrament',NULL,NULL,'[sa.kraːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32146,'sacratus','a','sacrat sacrat sacrat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (32151,'sacrificus','a','sacrific sacrific sacrific',NULL,NULL,'[saˈkrɪ.fɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32152,'sacrifico','v','sacrific sacrificav sacrificat',NULL,NULL,'[saˈkrɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32153,'sacrificium','n','sacrifici',NULL,NULL,'[sa.krɪˈfɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32156,'sacrilegus','a','sacrileg sacrileg sacrileg',NULL,NULL,'[saˈkrɪ.ɫɛ.ɡʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32157,'sacrilegium','n','sacrilegi',NULL,NULL,'[sa.krɪˈɫɛ.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32162,'sacrosanctus','a','sacrosanct sacrosanct sacrosanct',NULL,NULL,'[sa.kroːˈsaːŋk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32166,'saeculum','n','saecul',NULL,NULL,'[ˈsae̯.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32171,'saepe','r',NULL,NULL,NULL,'[ˈsae̯.pɛ]','rp--------');
INSERT INTO latin_morpho VALUES (32173,'saepes','n','saep',NULL,NULL,'/ˈsae̯.peːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (32174,'saepio','v','saep saeps saept',NULL,NULL,'/ˈsae̯.pi.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (32176,'saepimentum','n','saepiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32178,'saeptum','n','saept',NULL,'n-s---nn2-=septum','[ˈsae̯p.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32179,'saeta','n','saet',NULL,NULL,'/ˈsae̯.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32181,'saetosus','a','saetos saetos saetos',NULL,NULL,'[sae̯ˈtoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32183,'saevio','v','saev saevi saevit',NULL,NULL,'/ˈsae̯.wi.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (32185,'saevitia','n','saeviti',NULL,NULL,'[sae̯ˈwɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32187,'saga','n','sag',NULL,NULL,'/ˈsaː.ɡa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32190,'sagacitas','n','sagacitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32193,'sagax','a','sagac sagac sagac',NULL,NULL,'/ˈsa.ɡaːks/','aps---an3i');
INSERT INTO latin_morpho VALUES (32195,'sagino','v','sagin saginav saginat',NULL,NULL,'/saˈɡiː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (32196,'sagitta','n','sagitt',NULL,NULL,'[saˈɡɪt.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32198,'sagittarius','n','sagittari',NULL,NULL,'[sa.ɡɪtˈtaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (32205,'sagulum','n','sagul',NULL,NULL,'[ˈsa.ɡʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32208,'sal','n','sal',NULL,NULL,'[saːɫ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32211,'salaco','n','salacon',NULL,NULL,'[ˈsa.ɫa.koː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32216,'salax','a','salac salac salac',NULL,NULL,'[ˈsa.ɫaːks]','aps---an3i');
INSERT INTO latin_morpho VALUES (32217,'salebra','n','salebr',NULL,NULL,'[ˈsa.ɫɛ.bra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32220,'salio','v','sal salu salt',NULL,NULL,NULL,'v1spia--4-');
INSERT INTO latin_morpho VALUES (32232,'saliva','n','saliv',NULL,NULL,'/saˈliː.wa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32233,'salix','n','salic',NULL,NULL,'[ˈsa.lɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32234,'sallo','v','sall - sals',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (32241,'salsamentum','n','salsament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32242,'salsedo','n','salsedin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32243,'salsugo','n','salsugin',NULL,NULL,'[saɫˈsuː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32245,'saltus','n','salt',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (32247,'salto','v','salt saltav saltat',NULL,NULL,'[ˈsaɫ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32248,'saltatus','n','saltat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (32249,'saltatio','n','saltation',NULL,NULL,'/salˈtaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32251,'saltator','n','saltator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (32259,'saluber','a','salubr salubr salubr',NULL,NULL,'[saˈɫuː.bɛr]','aps---mn3-');
INSERT INTO latin_morpho VALUES (32262,'salus','n','sal',NULL,NULL,'[ˈsa.ɫuːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32263,'saluto','v','salut salutav salutat',NULL,NULL,'[saˈɫuː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32265,'salutaris','a','salutar salutar salutar',NULL,NULL,'[sa.ɫuːˈtaː.rɪs]','aps---an3-');
INSERT INTO latin_morpho VALUES (32267,'salutatio','n','salutation',NULL,NULL,'[sa.ɫuːˈtaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32271,'salutificator','n','salutificator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (32273,'salvus','a','salv salv salv',NULL,NULL,'[ˈsaɫ.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32274,'salvo','v','salv salvav salvat',NULL,NULL,'[ˈsaɫ.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32276,'salvatio','n','salvation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32277,'salvator','n','salvator',NULL,NULL,'[saɫˈwaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32279,'salvia','n','salvi',NULL,NULL,'/ˈsal.wi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32281,'salvifico','v','salvific salvificav salvifica',NULL,NULL,'[saɫˈwɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32283,'Samarites','n','Samarit',NULL,NULL,NULL,'n-s---mn1g');
INSERT INTO latin_morpho VALUES (32295,'sanus','a','san san san',NULL,NULL,'[ˈsaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32296,'sano','v','san sanav sanat',NULL,NULL,'/ˈsaː.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (32297,'sanabilis','a','sanabil sanabil sanabil',NULL,NULL,'[saːˈnaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (32299,'sancio','v','sanc sanx sancit',NULL,NULL,'[ˈsaŋ.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (32301,'sanctus','a','sanct sanct sanct',NULL,NULL,'[ˈsaːŋk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32302,'sanctifico','v','sanctific sanctificav sanctificat',NULL,NULL,'[saːŋkˈtɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32304,'sanctimonia','n','sanctimoni',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (32307,'sanctio','n','sanction',NULL,NULL,'[ˈsaːŋk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32308,'sanctitas','n','sanctitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32309,'sanctitudo','n','sanctitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32312,'sandalium','n','sandali',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32317,'sane','r',NULL,NULL,NULL,'/ˈsaː.neː/','rp--------');
INSERT INTO latin_morpho VALUES (32318,'sanesco','v','sanesc - -',NULL,NULL,'/saːˈneːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32324,'sanguis','n','sanguin',NULL,NULL,'[ˈsaŋ.ɡᶣɪs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32325,'sanguisuga','n','sanguisug',NULL,NULL,'[saŋ.ɡᶣɪˈsuː.ɡa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32326,'sanies','n','sani',NULL,NULL,'/ˈsa.ni.eːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (32328,'sanitas','n','sanitat',NULL,NULL,'/ˈsaː.ni.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32333,'sapio','v','sap - -',NULL,NULL,'/ˈsa.pi.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (32337,'sapiens','a','sapient sapient sapient',NULL,NULL,'[ˈsa.pi.ẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (32339,'sapientia','n','sapienti',NULL,NULL,'[sa.pɪˈɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32342,'sapo','n','sapon',NULL,NULL,'/ˈsaː.poː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32344,'sapor','n','sapor',NULL,NULL,'/ˈsa.por/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32356,'sarcasmos','n','sarcasm',NULL,NULL,NULL,'n-s---mn2g');
INSERT INTO latin_morpho VALUES (32357,'sarcio','v','sarc sars sart',NULL,NULL,'/ˈsar.ki.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (32358,'sarcina','n','sarcin',NULL,NULL,'[ˈsar.kɪ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32363,'sarculum','n','sarcul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32368,'sardina','n','sardin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (32370,'Sardinia','n','Sardini',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (32376,'sario','v','sar sariv sarit',NULL,NULL,'/ˈsa.ri.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (32381,'sarmentum','n','sarment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32387,'sartago','n','sartagin',NULL,'n-s---fg3-=sartiginis','/sarˈtaː.ɡoː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32394,'Satanas','n','Satan',NULL,NULL,'/ˈsa.ta.naːs/','n-s---mn1g');
INSERT INTO latin_morpho VALUES (32399,'satelles','n','satellit',NULL,NULL,'[saˈtɛl.lɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32400,'satellitium','n','satelliti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32401,'satio','v','sati satiav satiat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (32402,'satias','n','satiat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32403,'satietas','n','satietat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32405,'satis','a',NULL,NULL,NULL,'[ˈsa.tɪs]','aps---nn--');
INSERT INTO latin_morpho VALUES (32413,'sator','n','sator',NULL,NULL,'[ˈsa.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32419,'saturo','v','satur saturav saturat',NULL,NULL,'[ˈsa.tʊ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32422,'saturitas','n','saturitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32429,'saucius','a','sauci sauci sauci',NULL,NULL,'[ˈsau̯.ki.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32430,'saucio','v','sauci sauciav sauciat',NULL,NULL,'/ˈsau̯.ki.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (32436,'savium','n','savi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32437,'savior','v','savi saviat -',NULL,NULL,'[ˈsaː.wi.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (32440,'saxum','n','sax',NULL,NULL,'[ˈsak.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32447,'scabo','v','scab scab -',NULL,NULL,'/ˈska.boː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32450,'scabies','n','scabi',NULL,NULL,'/ˈska.bi.eːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (32460,'scaena','n','scaen',NULL,NULL,'/ˈskae̯.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32467,'scalmus','n','scalm',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (32468,'scalpo','v','scalp scalps scalpt',NULL,NULL,'[ˈskaɫ.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (32470,'scalpellum','n','scalpell',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32477,'scamnum','n','scamn',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32479,'scando','v','scand scand scans',NULL,NULL,'/ˈskan.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32480,'scandalum','n','scandal',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32481,'scandalizo','v','scandaliz scandalizav scandalizat',NULL,NULL,'[skanˈda.lɪ.zoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32486,'scapus','n','scap',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (32490,'scapulare','n','scapular',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (32497,'scateo','v','scat - -',NULL,NULL,'/ˈska.te.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (32501,'scaturrio','v','scaturr - -',NULL,NULL,NULL,'v1spia--3i');
INSERT INTO latin_morpho VALUES (32504,'scelero','v','sceler scelerav scelerat',NULL,NULL,'[ˈskɛ.ɫɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32506,'sceleratus','a','scelerat scelerat scelerat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (32508,'scelestus','a','scelest scelest scelest',NULL,NULL,'[skɛˈɫɛs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32510,'scelus','n','sceler',NULL,NULL,'[ˈskɛ.ɫʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (32517,'sceptrum','n','sceptr',NULL,NULL,'[ˈskeːp.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32523,'schema','n','schem',NULL,NULL,'/ˈskʰeː.ma/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (32527,'schisma','n','schismat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (32529,'schismaticus','a','schismatic schismatic schismatic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (32533,'schola','n','schol',NULL,NULL,'[ˈskʰɔ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32538,'scholasticus','n','scholastic',NULL,NULL,'[skʰɔˈɫas.tɪ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (32542,'scio','v','sc sciv scit',NULL,NULL,'/ˈski.oː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32547,'sciens','a','scient scient scient',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (32549,'scientia','n','scienti',NULL,NULL,'[skɪˈɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32551,'scilicet','r',NULL,NULL,NULL,'[ˈskiː.lɪ.kɛt]','rp--------');
INSERT INTO latin_morpho VALUES (32554,'scindo','v','scind scid sciss',NULL,NULL,'[ˈskɪn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (32558,'scintilla','n','scintill',NULL,NULL,'[skɪnˈtɪl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32576,'sciscitor','v','sciscit sciscitat -',NULL,NULL,'[ˈskiːs.kɪ.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (32583,'scitus','a','scit scit scit',NULL,NULL,'[ˈskiː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32584,'scitor','v','scit scitat -',NULL,NULL,'[ˈskiː.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (32587,'sciurus','n','sciur',NULL,NULL,'[skɪˈuː.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (32592,'scobis','n','scob',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (32598,'scomber','n','scombr',NULL,NULL,'[ˈskɔm.bɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (32599,'scopa','n','scop',NULL,NULL,'/ˈskoː.pa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32601,'scopo','v','scop scopav scopat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (32602,'scopulus','n','scopul',NULL,NULL,'[ˈskɔ.pʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (32607,'scorpios','n','scorpi',NULL,NULL,NULL,'n-s---fn2g');
INSERT INTO latin_morpho VALUES (32609,'scorpio','n','scorpion',NULL,NULL,'[ˈskɔr.pi.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32610,'scortum','n','scort',NULL,NULL,'[ˈskɔr.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32617,'Scotia','n','Scoti',NULL,NULL,'[ˈskɔ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32621,'scriba','n','scrib',NULL,NULL,'/ˈskriː.ba/','n-s---mn1-');
INSERT INTO latin_morpho VALUES (32622,'scribo','v','scrib scrips script',NULL,NULL,'/ˈskriː.boː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32625,'scrinium','n','scrini',NULL,NULL,'[ˈskriː.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32629,'scriptito','v','scriptit scriptitav scriptitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (32630,'scriptor','n','scriptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (32633,'scriptura','n','scriptur',NULL,NULL,'/skriːpˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32638,'scrofa','n','scrof',NULL,NULL,'/ˈskroː.fa/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32642,'scrotum','n','scrot',NULL,NULL,'[ˈskroː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32649,'scrupulus','n','scrupul',NULL,NULL,'[ˈskruː.pʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (32651,'scrupulosus','a','scrupulos scrupulos scrupulos',NULL,NULL,'[skruː.pʊˈɫoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32656,'scrutor','v','scrut scrutat -',NULL,NULL,'[ˈskruː.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (32663,'scrutino','v','scrutin scrutinav scrutinat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (32665,'scrutinium','n','scrutini',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32667,'sculpo','v','sculp sculps sculpt',NULL,NULL,'/ˈskul.poː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32670,'sculptor','n','sculptor',NULL,NULL,'[ˈskʊɫp.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32671,'scurra','n','scurr',NULL,NULL,'[ˈskʊr.ra]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (32675,'scutum','n','scut',NULL,NULL,'[ˈskuː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32683,'scutica','n','scutic',NULL,NULL,'[ˈskʊ.tɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32691,'scymnus','n','scymn',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (32692,'scyphus','n','scyph',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (32695,'sebum','n','seb',NULL,NULL,'[ˈseː.bũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32698,'seco','v','sec secu sect',NULL,NULL,'[ˈsɛ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32702,'secedo','v','seced secess secess',NULL,NULL,'/seːˈkeː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32703,'secerno','v','secern secrev secret',NULL,NULL,'[seːˈkɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (32705,'secessus','n','secess',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (32706,'secessio','n','secession',NULL,NULL,'[seːˈkɛs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32710,'secretum','n','secret',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32716,'secreto','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32717,'sector','v','sect sectat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (32720,'sectio','n','section',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32736,'secundus','a','secund secund secund',NULL,NULL,'[sɛˈkʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32741,'securus','a','secur secur secur',NULL,NULL,'[seːˈkuː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32745,'securis','n','secur',NULL,NULL,'[sɛˈkuː.rɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (32746,'securitas','n','securitat',NULL,NULL,'[seːˈkuː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32748,'secus','r',NULL,NULL,NULL,'[ˈsɛ.kʊs]','rp--------');
INSERT INTO latin_morpho VALUES (32753,'sedeo','v','sed sed sess',NULL,NULL,'[ˈsɛ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (32754,'sedo','v','sed sedav sedat',NULL,NULL,'/ˈseː.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (32755,'sedatus','a','sedat sedat sedat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (32760,'sedes','n','sed',NULL,NULL,'/ˈseː.deːs/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (32761,'sedile','n','sedil',NULL,NULL,'[sɛˈdiː.ɫɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (32762,'seditio','n','sedition',NULL,NULL,'/seːˈdi.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32764,'seduco','v','seduc sedux seduct',NULL,NULL,'/seːˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32766,'seductio','n','seduction',NULL,NULL,'[seːˈdʊk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32767,'seductor','n','seductor',NULL,NULL,'[seːˈdʊk.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32768,'sedulus','a','sedul sedul sedul',NULL,NULL,'[ˈseː.dʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32770,'sedulo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32771,'seges','n','seget',NULL,NULL,'/ˈse.ɡes/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32772,'segmentum','n','segment',NULL,NULL,'[sɛɡˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (32776,'segnitas','n','segnitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32778,'segnitia','n','segniti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (32790,'seiunctim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32793,'selectio','n','selection',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32797,'seligo','v','selig seleg select',NULL,NULL,'[ˈseː.lɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (32798,'sella','n','sell',NULL,NULL,'[ˈsɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32806,'semen','n','semin',NULL,NULL,'[ˈseː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (32856,'semino','v','semin seminav seminat',NULL,NULL,'[ˈseː.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (32895,'semper','r',NULL,NULL,NULL,'[ˈsɛm.pɛr]','rp--------');
INSERT INTO latin_morpho VALUES (32899,'sempiterne','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32900,'sempiternitas','n','sempiternitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32901,'sempiterno','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32914,'senatus','n','senat',NULL,NULL,'[sɛˈnaː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (32916,'senator','n','senator',NULL,NULL,'[sɛˈnaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32921,'senecta','n','senect',NULL,NULL,'[sɛˈnɛk.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32922,'senectus','a','senect senect senect',NULL,NULL,'[sɛˈnɛk.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (32923,'senectus','n','senectut',NULL,NULL,'[sɛˈnɛk.tʊs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (32925,'senex','n','sen',NULL,NULL,'[ˈsɛ.nɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32927,'senium','n','seni',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (32934,'sensus','n','sens',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (32936,'sensibilis','a','sensibil sensibil sensibil',NULL,NULL,'[sẽːˈsɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (32937,'sensibilitas','n','sensibilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32942,'sensim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32948,'sententia','n','sententi',NULL,NULL,'[sɛnˈtɛn.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32950,'sententiola','n','sententiol',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (32953,'sentio','v','sent sens sens',NULL,NULL,'[ˈsɛn.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (32960,'seorsum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32962,'separ','a','separ separ separ',NULL,NULL,'/ˈseː.paːr/','aps---an3-');
INSERT INTO latin_morpho VALUES (32963,'separo','v','separ separav separat',NULL,NULL,'/ˈseː.pa.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (32964,'separatim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (32965,'separatio','n','separation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (32969,'sepelio','v','sepel sepeli sepult',NULL,NULL,'[sɛˈpɛ.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (32974,'sepia','n','sepi',NULL,NULL,'/ˈseː.pi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (32977,'sepono','v','sepon seposu seposit',NULL,NULL,'/seːˈpoː.noː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (32996,'septentrio','n','septentrion',NULL,NULL,'[sɛpˈtɛn.tri.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (32998,'septentrionalis','a','septentrional septentrional septentrional',NULL,NULL,'[sɛp.tɛn.tri.oːˈnaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (32999,'septentrionarius','a','septentrionari septentrionari septentrionari',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (33026,'sepulchrum','n','sepulchr',NULL,'n-s---nn2-=sepulcrum','[sɛˈpʊɫ.kʰrũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33032,'sepultura','n','sepultur',NULL,NULL,'[sɛ.pʊɫˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33033,'sequor','v','sequ secut -',NULL,NULL,'[ˈsɛ.kʷɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (33042,'sequester','n','sequestr',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (33047,'sequestratio','n','sequestration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33048,'sequius','r',NULL,NULL,NULL,NULL,'rc--------');
INSERT INTO latin_morpho VALUES (33050,'sera','n','ser',NULL,NULL,'[ˈsɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33054,'serus','a','ser ser ser',NULL,NULL,'[ˈseː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33055,'sero','v','ser serav serat',NULL,NULL,'[ˈsɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33065,'serenus','a','seren seren seren',NULL,NULL,'[sɛˈreː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33070,'series','n','seri',NULL,NULL,'[ˈsɛ.ri.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (33071,'serius','a','seri seri seri',NULL,NULL,'[ˈseː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33079,'serio','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33086,'sermo','n','sermon',NULL,NULL,'[ˈsɛr.moː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33087,'sermocinor','v','sermon sermonat -',NULL,NULL,'[sɛrˈmoː.kɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (33090,'sermunculus','n','sermuncul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (33093,'serpo','v','serp serps -',NULL,NULL,'[ˈsɛr.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33094,'serpens','n','serpent',NULL,NULL,'[ˈsɛr.pẽːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (33099,'serra','n','serr',NULL,NULL,'[ˈsɛr.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33100,'serro','v','serr serrav serra',NULL,NULL,'[ˈsɛr.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33105,'serta','n','sert',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33109,'servus','n','serv',NULL,NULL,'[ˈsɛr.wʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33111,'servo','v','serv servav servat',NULL,NULL,'[ˈsɛr.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33114,'servator','n','servator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (33116,'servio','v','serv serv servit',NULL,NULL,'[ˈsɛr.wi.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (33120,'servitium','n','serviti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (33121,'servitudo','n','servitudin',NULL,NULL,'[sɛr.wɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33122,'servitus','n','servitut',NULL,NULL,'[ˈsɛr.wɪ.tuːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33161,'sessorium','n','sessori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (33172,'severus','a','sever sever sever',NULL,NULL,'[sɛˈweː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33173,'severitas','n','severitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33174,'severitudo','n','severitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33176,'sevoco','v','sevoc sevocav sevocat',NULL,NULL,'[ˈseː.wɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33178,'sexus','n','sex',NULL,NULL,'/ˈsek.sus/','n-s---mn4-');
INSERT INTO latin_morpho VALUES (33185,'sexangulus','a','sexangul sexangul sexangul',NULL,NULL,'[sɛkˈsaŋ.ɡʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33216,'sibilus','n','sibil',NULL,NULL,'[ˈsiː.bɪ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33219,'sibilo','v','sibil sibilav sibilat',NULL,NULL,'[ˈsiː.bɪ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33222,'sic','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33223,'sica','n','sic',NULL,NULL,'/ˈsiː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33225,'sicarius','n','sicari',NULL,NULL,'[siːˈkaː.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33228,'sicco','v','sicc siccav siccat',NULL,NULL,'[ˈsɪk.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33232,'siccitas','n','siccitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33237,'Sicilia','n','Sicili',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33241,'siclus','n','sicl',NULL,NULL,'[ˈsɪ.kɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33245,'Siculus','a','Sicul Sicul Sicul',NULL,NULL,'ˈsɪ.kʊ.ɫʊs','aps---mn1-');
INSERT INTO latin_morpho VALUES (33248,'sicut','r',NULL,NULL,NULL,'[ˈsiː.kʊt]','rp--------');
INSERT INTO latin_morpho VALUES (33252,'sido','v','sid sid siss',NULL,NULL,'/ˈsiː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (33253,'sidereus','a','sidere sidere sidere',NULL,NULL,'[siːˈdɛ.re.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33254,'sidus','n','sider',NULL,NULL,'[ˈsiː.dʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33260,'sigillum','n','sigill',NULL,NULL,'[sɪˈɡɪl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33266,'signum','n','sign',NULL,NULL,'[ˈsɪŋ.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33267,'signo','v','sign signav signat',NULL,NULL,'[ˈsɪŋ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33268,'signaculum','n','signacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (33270,'signanter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33273,'significo','v','signific significav significat',NULL,NULL,'[sɪŋˈnɪ.fɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33274,'significans','a','significant significant significant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (33276,'significantia','n','significanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33277,'significatio','n','signification',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33279,'sileo','v','sil silu -',NULL,NULL,'[ˈsɪ.ɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (33283,'silentium','n','silenti',NULL,NULL,'[sɪˈɫɛn.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33288,'silex','n','silic',NULL,NULL,'[ˈsɪ.ɫɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33293,'siligo','n','siligin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33294,'siliqua','n','siliqu',NULL,NULL,'[ˈsɪ.lɪ.kʷa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33299,'silva','n','silv',NULL,NULL,'[ˈsɪɫ.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33302,'silvester','a','silvestr silvestr silvestr',NULL,NULL,'[sɪɫˈwɛs.tɛr]','aps---mn3-');
INSERT INTO latin_morpho VALUES (33313,'simia','n','simi',NULL,NULL,'/ˈsiː.mi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33323,'similiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33324,'similitudo','n','similitudin',NULL,NULL,'[sɪ.mɪ.lɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33332,'simplex','a','simplic simplic simplic',NULL,NULL,'[ˈsɪm.pɫɛks]','aps---an3-');
INSERT INTO latin_morpho VALUES (33333,'simplicitas','n','simplicitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33334,'simpliciter','r',NULL,NULL,NULL,'[sɪmˈplɪ.kɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (33417,'sisto','v','sist stit stat',NULL,NULL,'[ˈsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33420,'situs','n','sit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (33427,'sitiens','a','sitient sitient sitient',NULL,NULL,NULL,'aps---cn3-');
INSERT INTO latin_morpho VALUES (33428,'sitis','n','sit',NULL,NULL,'[ˈsɪ.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (33432,'situla','n','situl',NULL,'n-s---mn2-=situlus n-s---nn2-=situlum',NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33436,'smaragdus','n','smaragd',NULL,NULL,'[smaˈraɡ.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33442,'smyrna','n','smyrn',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33444,'sobrius','a','sobri sobri sobri',NULL,NULL,'[ˈsoː.bri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33447,'sobrietas','n','sobrietat',NULL,NULL,'[soːˈbri.ɛ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33452,'soccus','n','socc',NULL,NULL,'[ˈsɔk.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33455,'socia','n','soci',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33456,'socius','n','soci',NULL,NULL,'[ˈsɔ.ki.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33458,'socio','v','soci sociav sociat',NULL,NULL,'[ˈsɔ.ki.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33459,'socialis','a','social social social',NULL,NULL,'/so.kiˈaː.lis/','aps---cn3i');
INSERT INTO latin_morpho VALUES (33465,'societas','n','societat',NULL,NULL,'/soˈki.e.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33472,'socordia','n','socordi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33475,'socrus','n','socr',NULL,NULL,'/ˈsok.rus/','n-s---fn4-');
INSERT INTO latin_morpho VALUES (33478,'Socrates','n','Socrat',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (33479,'Socraticus','a','Socratic Socratic Socratic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (33480,'sodalicium','n','sodalici',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (33482,'sodalis','n','sodal',NULL,NULL,'[sɔˈdaː.lɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (33483,'sodalitas','n','sodalitat',NULL,NULL,'[sɔˈdaː.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33492,'solum','n','sol',NULL,NULL,'[ˈsɔ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33493,'sol','n','sol',NULL,NULL,'[soːɫ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33495,'solor','v','sol solat -',NULL,NULL,'[ˈsoː.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (33497,'solacium','n','solaci',NULL,NULL,'[soːˈɫaː.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33499,'solamen','n','solamin',NULL,NULL,'[soːˈɫaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33500,'solarium','n','solari',NULL,NULL,'[soːˈɫaː.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33507,'solea','n','sole',NULL,NULL,'[ˈsɔ.ɫe.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33515,'solium','n','soli',NULL,NULL,'[ˈsɔ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33518,'solido','v','solid solidav solidat',NULL,NULL,'[ˈsɔ.lɪ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33519,'solidus','a','solid solid solid',NULL,NULL,'[ˈsɔ.lɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33529,'solitus','a','solit solit solit',NULL,NULL,'[ˈsɔ.lɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33534,'solitudo','n','solitudin',NULL,NULL,'[soː.lɪˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33537,'sollemnis','a','sollemn sollemn sollemn',NULL,NULL,NULL,'aps---cn3-');
INSERT INTO latin_morpho VALUES (33544,'sollerter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33545,'sollertia','n','sollerti',NULL,NULL,'[sɔlˈlɛr.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33546,'sollicitus','a','sollicit sollicit sollicit',NULL,NULL,'[sɔlˈlɪ.kɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33547,'sollicito','v','sollicit sollicitav sollicitat',NULL,NULL,'[sɔlˈlɪ.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33550,'sollicitudo','n','sollicitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33557,'solstitium','n','solstiti',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (33559,'solum','r',NULL,NULL,NULL,'[ˈsɔ.ɫũ]','rp--------');
INSERT INTO latin_morpho VALUES (33560,'solummodo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33561,'solutus','a','solut solut solut',NULL,NULL,'[sɔˈɫuː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33563,'solutio','n','solution',NULL,NULL,'/soˈluː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33564,'solvo','v','solv solv solut',NULL,NULL,'[ˈsɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33565,'somnus','n','somn',NULL,NULL,'[ˈsɔm.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33566,'somnium','n','somni',NULL,NULL,'[ˈsɔm.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33567,'somnio','v','somni somniav somniat',NULL,NULL,'[ˈsɔm.ni.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33573,'sonus','n','son',NULL,NULL,'/ˈso.nus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33575,'sono','v','son sonu sonit',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (33577,'sonipes','n','soniped',NULL,NULL,'[ˈsɔ.nɪ.peːs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33578,'sonitus','n','sonit',NULL,NULL,'[ˈsɔ.nɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (33581,'sonorus','a','sonor sonor sonor',NULL,NULL,'[sɔˈnoː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33584,'sons','a','sont sont sont',NULL,NULL,'[sõːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (33585,'sonticus','a','sontic sontic sontic',NULL,NULL,'[ˈsɔn.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33588,'sophia','n','sophi',NULL,NULL,'/ˈso.pʰi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33589,'sophisma','n','sophismat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (33593,'sophistes','n','sophist',NULL,NULL,'[sɔˈpʰɪs.teːs]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (33602,'soporo','v','sopor soporav soporat',NULL,NULL,'[sɔˈpoː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33606,'sorbeo','v','sorb - -',NULL,NULL,'[ˈsɔr.be.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (33611,'sorbitio','n','sorbition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33614,'sordes','n','sord',NULL,NULL,'[ˈsɔr.dɛs]','n-p---fn3i');
INSERT INTO latin_morpho VALUES (33616,'sordidus','a','sordid sordid sordid',NULL,NULL,'[ˈsɔr.dɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33618,'sordide','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33623,'soror','n','soror',NULL,NULL,'[ˈsɔ.rɔr]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33627,'sors','n','sort',NULL,NULL,'[sɔrs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (33628,'sortior','v','sort sortit -',NULL,NULL,'[ˈsɔr.ti.ɔr]','v1spid--4-');
INSERT INTO latin_morpho VALUES (33630,'sortilegus','a','sortileg sortileg sortileg',NULL,NULL,'[sɔrˈtɪ.ɫɛ.ɡʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33635,'sospito','v','sospit sospitav sospitat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (33637,'soter','n','soter',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (33641,'spes','n','sp',NULL,NULL,'/speːs/','n-s---fn5-');
INSERT INTO latin_morpho VALUES (33646,'spado','n','spadon',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (33649,'spargo','v','sparg spars spars',NULL,NULL,'/ˈspar.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (33660,'spatium','n','spati',NULL,NULL,'[ˈspa.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33661,'spatior','v','spati spatiat -',NULL,NULL,'[ˈspa.ti.ɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (33664,'spatiosus','a','spatios spatios spatios',NULL,NULL,'[spa.tɪˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33665,'spatula','n','spatul',NULL,NULL,'[ˈspa.tʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33667,'specus','n','spec',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (33668,'specio','v','spec spex spect',NULL,NULL,'[ˈspɛ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (33669,'species','n','speci',NULL,NULL,'[ˈspɛ.ki.eːs]','n-s---fn5-');
INSERT INTO latin_morpho VALUES (33672,'specialitas','n','specialitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33673,'specialiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33676,'specimen','n','specimin',NULL,NULL,'[ˈspɛ.kɪ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33679,'specto','v','spect spectav spectat',NULL,NULL,'[ˈspɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33684,'spectaculum','n','spectacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (33685,'spectamen','n','spectamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (33687,'spectator','n','spectator',NULL,NULL,'[spɛkˈtaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33693,'speculor','v','specul speculat -',NULL,NULL,'[ˈspɛ.kʊ.ɫɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (33697,'speculator','n','speculator',NULL,NULL,'[spɛ.kʊˈɫaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33702,'spelunca','n','spelunc',NULL,NULL,'[speːˈɫʊŋ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33706,'sperma','n','spermat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (33708,'sperno','v','spern sprev spret',NULL,NULL,'[ˈspɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33709,'sphacos','n','sphac',NULL,NULL,'[ˈspʰa.kɔs]','n-s---mn2g');
INSERT INTO latin_morpho VALUES (33710,'sphaera','n','sphaer',NULL,NULL,'/ˈspʰae̯.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33720,'Sphinx','n','Sphing',NULL,NULL,'[spʰɪŋks]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (33728,'spiculum','n','spicul',NULL,NULL,'[ˈspiː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33730,'spina','n','spin',NULL,NULL,'/ˈspiː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33736,'spineus','a','spine spine spine',NULL,NULL,'[ˈspiː.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33739,'spinosus','a','spinos spinos spinos',NULL,NULL,'[spiːˈnoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33742,'spiro','v','spir spirav spirat',NULL,NULL,'/ˈspiː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (33744,'spiraculum','n','spiracul',NULL,NULL,'[spiːˈraː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33746,'spiramen','n','spiramin',NULL,NULL,'[spiːˈraː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33747,'spiramentum','n','spirament',NULL,NULL,'[spiː.raːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33748,'spiratio','n','spiration',NULL,NULL,'/spiːˈraː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33749,'spiritus','n','spirit',NULL,NULL,'[ˈspiː.rɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (33750,'spiritalis','a','spirital spirital spirital',NULL,NULL,'[spiː.rɪˈtaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (33752,'spiritaliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33757,'spissus','a','spiss spiss spiss',NULL,NULL,'/ˈspis.sus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (33758,'spisso','v','spiss spissav spissat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (33759,'spissesco','v','spissesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (33761,'splendeo','v','splend - -',NULL,NULL,'[ˈspɫɛn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (33764,'splendor','n','splendor',NULL,NULL,'[ˈspɫɛn.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33767,'spolium','n','spoli',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (33768,'spolio','v','spoli spoliav spoliat',NULL,NULL,'[ˈspɔ.li.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33769,'spoliatio','n','spoliation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33772,'sponda','n','spond',NULL,NULL,'[ˈspɔn.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33773,'spondeo','v','spond spopond spons',NULL,NULL,'[ˈspɔn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (33779,'spongia','n','spongi',NULL,NULL,'[ˈspɔŋ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33791,'sponsor','n','sponsor',NULL,NULL,'[ˈspõː.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33794,'spontaneus','a','spontane spontane spontane',NULL,NULL,'[spɔnˈtaː.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33797,'sporta','n','sport',NULL,NULL,'[ˈspɔr.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33803,'spuo','v','spu spu sput',NULL,NULL,'[ˈspʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33804,'spuma','n','spum',NULL,NULL,'/ˈspuː.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33805,'spumo','v','spum spumav spumat',NULL,NULL,'/ˈspuː.moː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (33811,'spurcus','a','spurc spurc spurc',NULL,NULL,'/ˈspur.kus/','aps---mn1-');
INSERT INTO latin_morpho VALUES (33812,'spurco','v','spurc spurcav spurcat',NULL,NULL,'[ˈspʊr.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33817,'spurcitia','n','spurciti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33823,'sputum','n','sput',NULL,NULL,'[ˈspuː.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33825,'sputamen','n','sputamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (33830,'squalor','n','squalor',NULL,NULL,'[ˈskʷaː.ɫɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33831,'squama','n','squam',NULL,NULL,'/ˈskʷaː.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33840,'sto','v','st stet stat',NULL,NULL,'/stoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (33841,'stabilis','a','stabil stabil stabil',NULL,NULL,'[ˈsta.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (33842,'stabilio','v','stabil stabiliv stabilit',NULL,NULL,'[staˈbɪ.li.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (33843,'stabilimentum','n','stabiliment',NULL,NULL,'[sta.bɪ.liːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33844,'stabilitas','n','stabilitat',NULL,NULL,'[staˈbɪ.lɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (33845,'stabulum','n','stabul',NULL,NULL,'[ˈsta.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33851,'stagnum','n','stagn',NULL,NULL,'[ˈstaŋ.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33856,'stamen','n','stamin',NULL,NULL,'[ˈstaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33861,'staphylinus','n','staphylin',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (33862,'status','n','stat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (33872,'statim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33880,'statua','n','statu',NULL,NULL,'[ˈsta.tʊ.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33881,'statuo','v','statu statu statut',NULL,NULL,'[ˈsta.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33889,'statura','n','statur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (33893,'stella','n','stell',NULL,NULL,'/ˈsteːl.la/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33895,'stellans','a','stellant stellant stellant',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (33896,'stellatus','a','stellat stellat stellat',NULL,NULL,'[stɛlˈlaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33897,'stellifer','a','stellifer stellifer stellifer',NULL,NULL,NULL,'aps---mn1r');
INSERT INTO latin_morpho VALUES (33898,'stelliger','a','stelliger stelliger stelliger',NULL,NULL,'[ˈsteːl.lɪ.ɡɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (33899,'stellio','n','stellion',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (33901,'stemma','n','stemmat',NULL,NULL,'[ˈstɛm.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33914,'stercus','n','stercor',NULL,NULL,'[ˈstɛr.kʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33919,'sterilitas','n','sterilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33922,'sterno','v','stern strav strat',NULL,NULL,'[ˈstɛr.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33924,'sternuo','v','sternu sternu -',NULL,NULL,'[ˈstɛr.nʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33926,'sternuto','v','sternut sternutav sternutat',NULL,NULL,'[stɛrˈnuː.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33942,'stilus','n','stil',NULL,NULL,'[ˈstɪ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33946,'stillo','v','still stillav stillat',NULL,NULL,'[ˈstɪl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33949,'stimulus','n','stimul',NULL,NULL,'[ˈstɪ.mʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33950,'stimulo','v','stimul stimulav stimulat',NULL,NULL,'[ˈstɪ.mʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33954,'stinguo','v','stingu - -',NULL,NULL,'[ˈstɪŋ.ɡʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (33955,'stipo','v','stip stipav stipat',NULL,NULL,'/ˈstiː.poː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (33957,'stipator','n','stipator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (33958,'stipendium','n','stipendi',NULL,NULL,'[stiːˈpɛn.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (33960,'stipes','n','stipit',NULL,NULL,'[ˈstiː.pɛs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (33962,'stipula','n','stipul',NULL,NULL,'[ˈstɪ.pʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33966,'stiria','n','stiri',NULL,NULL,'/ˈstiː.ri.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33968,'stirps','n','stirp',NULL,NULL,'/stirps/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (33974,'stola','n','stol',NULL,NULL,'[ˈstɔ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (33976,'stolidus','a','stolid stolid stolid',NULL,NULL,'[ˈstɔ.lɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (33977,'stolide','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (33978,'stoliditas','n','stoliditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (33979,'stomachus','n','stomach',NULL,NULL,'[ˈstɔ.ma.kʰʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (33987,'strages','n','strag',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (33990,'stramen','n','stramin',NULL,NULL,'[ˈstraː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (33993,'strangulo','v','strangul strangulav strangulat',NULL,NULL,'[ˈstraŋ.ɡʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (33996,'stratus','n','strat',NULL,NULL,'[ˈstraː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (33998,'strategus','n','strateg',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (33999,'strategema','n','strategemat',NULL,NULL,'/stra.teːˈɡeː.ma/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (34005,'strenuitas','n','strenuitat',NULL,NULL,'[streːˈnʊ.ɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (34006,'strepo','v','strep strepu strepit',NULL,NULL,'[ˈstrɛ.poː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34007,'strepitus','n','strepit',NULL,NULL,'[ˈstrɛ.pɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (34009,'stria','n','stri',NULL,NULL,'/ˈstri.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34010,'strio','v','stri - striat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (34015,'strido','v','strid strid -',NULL,NULL,'/stri.do/','v1spia--3-');
INSERT INTO latin_morpho VALUES (34016,'stridor','n','stridor',NULL,NULL,'[ˈstriː.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (34018,'striga','n','strig',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (34021,'strigo','v','strig strigav strigat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (34024,'strigosus','a','strigos strigos strigos',NULL,NULL,'[strɪˈɡoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34031,'stropha','n','stroph',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (34035,'struo','v','stru strux struct',NULL,NULL,'[ˈstrʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34037,'structor','n','structor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (34038,'structura','n','structur',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (34041,'strues','n','stru',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (34042,'struix','n','struic',NULL,NULL,'[ˈstrʊ.ɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (34049,'struthocamelus','n','struthocamel',NULL,NULL,NULL,'n-s---fn2-');
INSERT INTO latin_morpho VALUES (34053,'studium','n','studi',NULL,NULL,'[ˈstʊ.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34056,'studiose','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (34058,'stultus','a','stult stult stult',NULL,NULL,'[ˈstʊɫ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34059,'stulte','r',NULL,NULL,NULL,'[ˈstʊɫ.teː]','rp--------');
INSERT INTO latin_morpho VALUES (34062,'stultitia','n','stultiti',NULL,NULL,'[stʊɫˈtɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34069,'stupidus','a','stupid stupid stupid',NULL,NULL,'[ˈstʊ.pɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34071,'stupor','n','stupor',NULL,NULL,'[ˈstʊ.pɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (34072,'stuppa','n','stupp',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (34074,'stuprum','n','stupr',NULL,NULL,'[ˈstʊ.prũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34078,'sturnus','n','sturn',NULL,NULL,'[ˈstʊr.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (34094,'suadus','a','suad suad suad',NULL,NULL,'[sʊˈaː.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34095,'suadeo','v','suad suas suas',NULL,NULL,'/ˈswaː.de.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (34098,'suasor','n','suasor',NULL,NULL,'[sʊˈaː.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (34100,'suasorius','a','suasori suasori suasori',NULL,NULL,'[sʊ.aːˈsoː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34101,'suavis','a','suav suav suav',NULL,NULL,'[ˈswaː.wɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (34109,'suavitas','n','suavitat',NULL,NULL,'[sʊˈaː.wɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (34110,'suaviter','r',NULL,NULL,NULL,'[sʊˈaː.wɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (34146,'subdiaconus','n','subdiacon',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (34155,'subditivus','a','subditiv subditiv subditiv',NULL,NULL,'[sʊb.dɪˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34160,'subeo','v','sub subiv subit','v2spia--4-=subis v3spia--4-=subit v1ppia--4-=subimus v2ppia--4-=subitis v3ppia--4-=subeunt v1siia--4-=subibam v2siia--4-=subibas v3siia--4-=subibat v1piia--4-=subibamus v2piia--4-=subibatis v3piia--4-=subibant v1sfia--4-=subibo v2sfia--4-=subibis v3sfia--4-=subibit v1pfia--4-=subibimus v2pfia--4-=subibitis v3pfia--4-=subibunt v-sppamn4-=subiens v-sppafn4-=subiens v-sppann4-=subiens v-sfpamn4-=subiturus v-sfpafn4-=subitura v-sfpann4-=subiturum v-sfppmn4-=subeundus v-sfppfn4-=subeunda v-sfppnn4-=subeundum v-s-gang4-=subeundi v-s-damn4-=subeundus v-s-dafn4-=subeunda v-s-dann4-=subeundum',NULL,'[ˈsʊ.be.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (34173,'subigo','v','subig subeg subact',NULL,NULL,'[ˈsʊ.bɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34190,'subitus','a','subit subit subit',NULL,NULL,'[ˈsʊ.bɪ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34191,'subitaneus','a','subitane subitane subitane',NULL,NULL,'[sʊ.bɪˈtaː.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34211,'sublabor','v','sublab sublaps -',NULL,NULL,NULL,'v1spid--3-');
INSERT INTO latin_morpho VALUES (34216,'sublevo','v','sublev sublevav sublevat',NULL,NULL,'[ˈsʊ.bɫɛ.woː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34224,'sublimo','v','sublim sublimav sublimat',NULL,NULL,'[sʊˈbliː.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34225,'sublimus','a','sublim sublim sublim',NULL,NULL,'[sʊˈbliː.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34226,'sublimis','a','sublim sublim sublim',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (34229,'sublimitas','n','sublimitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34235,'subluo','v','sublu sublu sublut',NULL,NULL,'[ˈsʊ.bɫʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34241,'submergo','v','submerg submers submers',NULL,NULL,'[sʊbˈmɛr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34242,'subministro','v','subministr subministrav subministrat',NULL,'v1spia--1-=sumministro v--pna--1-=sumministrare v1sria--1-=sumministravi v-srppmn1-=sumministratus v-srppfn1-=sumministrata v-srppnn1-=sumministratum','[sʊb.mɪˈnɪs.troː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34245,'submitto','v','submitt submis submiss',NULL,NULL,'[sʊbˈmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34250,'submoveo','v','submov submov submot',NULL,NULL,'[sʊbˈmɔ.we.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (34255,'subnecto','v','subnect subnexu subnex',NULL,NULL,'[sʊbˈnɛk.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34262,'subnoto','v','subnot subnotav subnotat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (34274,'suboles','n','subol',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (34275,'subolesco','v','subolesc - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (34276,'suborior','v','subor  -',NULL,NULL,NULL,'v1spid--4-');
INSERT INTO latin_morpho VALUES (34277,'suborno','v','suborn subornav subornat',NULL,NULL,'/suˈboːr.noː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (34289,'subreptio','n','subreption',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34290,'subrideo','v','subrid subris subris',NULL,NULL,'[sʊˈbriː.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (34291,'subrigo','v','subrig subrex subrect',NULL,NULL,'[ˈsʊ.brɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34294,'subrogo','v','subrog subrogav subrogat',NULL,NULL,'[ˈsʊ.brɔ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34301,'subsanno','v','subsann subsannav subsanna',NULL,NULL,'[sʊˈpsan.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34303,'subsannator','n','subsannator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (34304,'subscribo','v','subscrib subscrips subscript',NULL,NULL,'[sʊpˈskriː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34309,'subsellium','n','subselli',NULL,NULL,'[sʊˈpsɛl.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34317,'subsido','v','subsid subsed subsess',NULL,NULL,'[sʊˈpsiː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34318,'subsidium','n','subsidi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34328,'subsisto','v','subsist substit -',NULL,NULL,'[sʊˈpsɪs.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34332,'substantia','n','substanti',NULL,NULL,'[sʊpˈstan.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34333,'substantialis','a','substantial substantial substantial',NULL,NULL,'[sʊp.stan.tɪˈaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (34334,'substantialiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (34337,'substituo','v','substitu substitu substitut',NULL,NULL,'[sʊpˈstɪ.tʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34339,'substitutio','n','substitution',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34344,'substructio','n','substruction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34353,'subtemen','n','subtemin',NULL,NULL,'[sʊpˈteː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (34355,'subter','r',NULL,NULL,NULL,'[ˈsʊp.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (34360,'subterfugio','v','subterfug subterfug -',NULL,NULL,'[sʊp.tɛrˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (34363,'subtexo','v','subtex subtexu subtext',NULL,NULL,'[sʊpˈtɛk.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34364,'subtilis','a','subtil subtil subtil',NULL,NULL,'[sʊpˈtiː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (34365,'subtilitas','n','subtilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34369,'subtraho','v','subtrah subtrax subtract',NULL,NULL,'[ˈsʊp.tra.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34375,'subtus','r',NULL,NULL,NULL,'[ˈsʊp.tʊs]','rp--------');
INSERT INTO latin_morpho VALUES (34379,'subulcus','n','subulc',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (34384,'suburbium','n','suburbi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34390,'subvenio','v','subven subven subvent',NULL,NULL,'[sʊbˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (34393,'subversio','n','subversion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34394,'subverto','v','subvert subvert subvers',NULL,NULL,'[sʊbˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34399,'sucus','n','suc',NULL,NULL,'[ˈsuː.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (34402,'succedo','v','succed success success',NULL,NULL,'[sʊkˈkeː.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34407,'successus','n','success',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (34408,'successio','n','succession',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34409,'successor','n','successor',NULL,NULL,'[sʊkˈkɛs.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (34410,'succido','v','succid succidav succida',NULL,'v1spia--3-=subcido v--pna--1-=subcidere v1sria--1-=subcidi','[ˈsʊk.kɪ.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34423,'succresco','v','succresc succrev succret',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (34425,'succumbo','v','succumb succubu succubit',NULL,NULL,'[sʊkˈkʊm.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34427,'succurro','v','succurr succurr succurs',NULL,NULL,'[sʊkˈkʊr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34432,'sucidus','a','sucid sucid sucid',NULL,NULL,'[ˈsuː.kɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34435,'suculentus','a','suculent suculent suculent',NULL,NULL,'[suː.kʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34438,'sudo','v','sud sudav sudat',NULL,NULL,'/ˈsuː.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (34439,'sudarium','n','sudari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34443,'sudor','n','sudor',NULL,NULL,'[ˈsuː.dɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (34446,'suetus','a','suet suet suet',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (34449,'suffarcino','v','suffarcin suffarcinav suffarcinat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (34450,'suffero','v','suffer sustul sublat','v--pna--3-=sufferre v2spia--3-=suffers v3spia--3-=suffert v2ppia--3-=suffertis',NULL,'[ˈsʊf.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34454,'sufficio','v','suffic suffec suffect',NULL,NULL,'[sʊfˈfɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (34455,'sufficiens','a','sufficient sufficient sufficient',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (34457,'suffigo','v','suffig suffix suffix',NULL,NULL,'[sʊfˈfiː.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34458,'suffimen','n','suffimin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (34459,'suffimentum','n','suffiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34460,'sufflo','v','suffl sufflav sufflat',NULL,NULL,'[ˈsʊf.fɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34461,'sufflamen','n','sufflamin',NULL,NULL,'[sʊfˈfɫaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (34464,'suffoco','v','suffoc suffocav suffocat',NULL,NULL,'[sʊfˈfoː.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34465,'suffocatio','n','suffocation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34466,'suffodio','v','suffod suffod suffoss',NULL,NULL,'[sʊfˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (34468,'suffragor','v','suffrag suffragat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (34471,'suffragator','n','suffragator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (34473,'suffragium','n','suffragi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34474,'suffrago','n','suffragin',NULL,NULL,'[sʊfˈfraː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (34478,'suffugium','n','suffugi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34485,'sugo','v','sug sux suct',NULL,NULL,'/ˈsuː.ɡoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (34486,'suggero','v','sugger suggess suggest',NULL,NULL,'[ˈsʊɡ.ɡɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34487,'suggestus','n','suggest',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (34488,'suggestio','n','suggestion',NULL,NULL,'[sʊɡˈɡɛs.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (34489,'suggillo','v','suggill suggillav suggillat',NULL,NULL,'[sʊɡˈɡɪl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34491,'suggredior','v','suggred suggress -',NULL,NULL,NULL,'v1spid--3i');
INSERT INTO latin_morpho VALUES (34503,'sulcus','n','sulc',NULL,NULL,'[ˈsʊɫ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (34504,'sulco','v','sulc sulcav sulcat',NULL,NULL,'[ˈsʊɫ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34509,'sulphur','n','sulphur',NULL,NULL,'[ˈsʊɫ.pʰʊr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (34514,'summus','a','summ summ summ',NULL,NULL,'[ˈsʊm.mʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34516,'sumo','v','sum sumps sumpt',NULL,NULL,'/ˈsuː.moː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (34520,'summa','n','summ',NULL,NULL,'[ˈsʊm.ma]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34521,'summum','n','summ',NULL,NULL,'[ˈsʊm.mũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34531,'summitas','n','summitat',NULL,NULL,'[ˈsʊm.mɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (34545,'sumptus','n','sumpt',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (34547,'sumptuosus','a','sumptuos sumptuos sumptuos',NULL,NULL,'[sʊmp.tʊˈoː.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34552,'super','r',NULL,NULL,NULL,'[ˈsʊ.pɛr]','rp--------');
INSERT INTO latin_morpho VALUES (34557,'supero','v','super superav superat',NULL,NULL,'[ˈsʊ.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34570,'superbus','a','superb superb superb',NULL,NULL,'[sʊˈpɛr.bʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34574,'superbia','n','superbi',NULL,NULL,'[sʊˈpɛr.bi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34578,'supercilium','n','supercili',NULL,NULL,'[sʊ.pɛrˈkɪ.li.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34585,'superemineo','v','superemin - -',NULL,NULL,'[sʊ.pɛ.reːˈmɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (34597,'superfluo','v','superflu superflux superfluct',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (34599,'supergredior','v','supergred supergress -',NULL,NULL,'[sʊ.pɛrˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (34618,'superlatus','a','superlat superlat superlat',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (34626,'supernus','a','supern supern supern',NULL,NULL,'[sʊˈpɛr.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34639,'supersum','v','super superfu -','v--pna--3-=superesse v1spia--3-=supersum v2spia--3-=superes v3spia--3-=superest v1ppia--3-=supersumus v2ppia--3-=superestis v3ppia--3-=supersunt',NULL,'[sʊˈpɛr.sũ]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34647,'superstitio','n','superstition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34656,'supervacaneus','a','supervacane supervacane supervacane',NULL,NULL,'[sʊ.pɛr.waˈkaː.ne.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34657,'supervacuus','a','supervacu supervacu supervacu',NULL,NULL,'[sʊ.pɛrˈwa.kʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34659,'supervado','v','supervad - -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (34666,'supinus','a','supin supin supin',NULL,NULL,'[sʊˈpiː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34689,'supplico','v','supplic supplicav supplicat',NULL,NULL,'[ˈsʊp.plɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34690,'supplicatio','n','supplication',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34691,'supplicium','n','supplici',NULL,NULL,'[sʊpˈplɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34696,'supporto','v','support supportav supportat',NULL,NULL,'[sʊpˈpɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34700,'suppressio','n','suppression',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34701,'supprimo','v','supprim suppress suppress',NULL,NULL,'[ˈsʊp.prɪ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34705,'suppuro','v','suppur suppurav suppurat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (34709,'supputo','v','supput supputav supputat',NULL,NULL,'[ˈsʊp.pʊ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34710,'supputatio','n','supputation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34711,'supra','r',NULL,NULL,NULL,'[ˈsʊ.praː]','rp--------');
INSERT INTO latin_morpho VALUES (34716,'suprascribo','v','suprascrib suprascrips suprascript',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (34730,'surculosus','a','surculos surculos surculos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (34731,'surdus','a','surd surd surd',NULL,NULL,'[ˈsʊr.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34733,'surditas','n','surditat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34735,'surgo','v','surg surrex surrect',NULL,NULL,'[ˈsʊr.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34754,'sus','n','su',NULL,NULL,'/suːs/','n-s---cn3-');
INSERT INTO latin_morpho VALUES (34759,'susceptor','n','susceptor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (34761,'suscipio','v','suscip suscep suscept',NULL,NULL,'[sʊsˈkɪ.pi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (34762,'suscito','v','suscit suscitav suscitat',NULL,NULL,'[ˈsʊs.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34767,'suspecto','v','suspect suspectav suspectat',NULL,NULL,'[sʊsˈpɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34770,'suspendo','v','suspend suspend suspens',NULL,NULL,'[sʊsˈpɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34773,'suspicor','v','suspic suspicat -',NULL,NULL,'[ˈsʊs.pɪ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (34775,'suspicio','v','suspic suspex suspect',NULL,NULL,'[sʊsˈpɪ.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (34778,'suspiro','v','suspir suspirav suspirat',NULL,NULL,'[sʊsˈpiː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34780,'suspirium','n','suspiri',NULL,NULL,'[sʊsˈpɪ.ri.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34782,'suspiritus','n','suspirit',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (34785,'sustento','v','sustent sustentav sustentat',NULL,NULL,'[sʊsˈtɛn.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34786,'sustentaculum','n','sustentacul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34787,'sustentatus','n','sustentat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (34788,'sustineo','v','sustin sustinu sustent',NULL,NULL,'[sʊsˈtɪ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (34791,'susurrus','n','susurr',NULL,NULL,'[sʊˈsʊr.rʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (34793,'susurro','v','susurr susurrav susurrat',NULL,NULL,'[sʊˈsʊr.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (34795,'susurratio','n','susurration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34802,'sutor','n','sutor',NULL,NULL,'[ˈsuː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (34807,'sutura','n','sutur',NULL,NULL,'/suːˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34818,'syllogismus','n','syllogism',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (34823,'symbolus','n','symbol',NULL,NULL,'[ˈsʏm.bɔ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (34827,'symmetria','n','symmetri',NULL,NULL,'[sʏmˈmɛ.tri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34833,'symptoma','n','symptomat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (34835,'synagoga','n','synagog',NULL,NULL,'[sʏ.naˈɡoː.ɡa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34844,'syncopa','n','syncop',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (34846,'syncopo','v','syncop - syncopat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (34861,'syngraphus','n','syngraph',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (34866,'synonymum','n','synonym',NULL,NULL,'[sʏˈnoː.nʏ.mũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34875,'Syria','n','Syri',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (34882,'systema','n','systemat',NULL,NULL,'[sʏsˈteː.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (34892,'tabefacio','v','tabefac tabefec tabefact',NULL,NULL,'[taː.bɛˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (34895,'tabella','n','tabell',NULL,NULL,'[taˈbɛl.la]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34899,'taberna','n','tabern',NULL,NULL,'[taˈbɛr.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34900,'tabernaculum','n','tabernacul',NULL,NULL,'[ta.bɛrˈnaː.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34903,'tabes','n','tab',NULL,NULL,'[ˈtaː.bɛs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (34904,'tabesco','v','tabesc tabu -',NULL,NULL,'/taːˈbeːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (34909,'tablinum','n','tablin',NULL,NULL,'[taˈbliː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34910,'tabula','n','tabul',NULL,NULL,'[ˈta.bʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34912,'tabulatum','n','tabulat',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (34914,'tabulatio','n','tabulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (34921,'tactus','n','tact',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (34928,'taedium','n','taedi',NULL,NULL,'[ˈtae̯.di.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34931,'taenia','n','taeni',NULL,NULL,'/ˈtae̯.ni.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34936,'talus','n','tal',NULL,NULL,'[ˈtaː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (34942,'talentum','n','talent',NULL,NULL,'[taˈɫɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (34944,'taliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (34948,'talpa','n','talp',NULL,NULL,'[ˈtaɫ.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (34949,'tam','r',NULL,NULL,NULL,'[tã]','rp--------');
INSERT INTO latin_morpho VALUES (34950,'tamarix','n','tamaric',NULL,NULL,'[ˈta.ma.rɪks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (34957,'tandem','r',NULL,NULL,NULL,'[ˈtan.dẽ]','rp--------');
INSERT INTO latin_morpho VALUES (34958,'tango','v','tang tetig tact',NULL,NULL,'[ˈtaŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (34967,'tantum','r',NULL,NULL,NULL,'[ˈtan.tũ]','rp--------');
INSERT INTO latin_morpho VALUES (34968,'tantummodo','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (34974,'tapete','n','tapet',NULL,NULL,'[taˈpeː.tɛ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (34976,'tarandrus','n','tarandr',NULL,'n-s---mn2-=tarandus',NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (34978,'tardo','v','tard tardav tardat',NULL,NULL,'/ˈtar.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (34979,'tardus','a','tard tard tard',NULL,NULL,'[ˈtar.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (34991,'taurus','n','taur',NULL,NULL,'[ˈtau̯.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (34998,'taxo','v','tax taxav taxat',NULL,NULL,'/ˈtak.soː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (35016,'tectum','n','tect',NULL,NULL,'[ˈteːk.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35017,'tectus','a','tect tect tect',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (35019,'tectorium','n','tectori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35022,'tego','v','teg tex tect',NULL,NULL,'[ˈtɛ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35023,'tegimen','n','tegimin',NULL,NULL,'[ˈtɛ.ɡɪ.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (35024,'tegimentum','n','tegiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35032,'telum','n','tel',NULL,NULL,'[ˈteː.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35059,'tellus','n','tellur',NULL,NULL,'[ˈtɛl.luːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35068,'temero','v','temer temerav temerat',NULL,NULL,'[ˈtɛ.mɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35070,'temere','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (35071,'temeritas','n','temeritat',NULL,NULL,'/teˈme.ri.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35073,'temno','v','temn - -',NULL,NULL,'[ˈtɛm.noː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35074,'temo','n','temon',NULL,NULL,'/ˈteː.moː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35075,'tempus','n','tempor',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (35076,'tempero','v','temper temperav temperat',NULL,NULL,'[ˈtɛm.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35077,'temperamentum','n','temperament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35080,'temperantia','n','temperanti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35081,'temperatus','a','temperat temperat temperat',NULL,NULL,'[tɛm.pɛˈraː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35086,'tempestas','n','tempestat',NULL,NULL,'[tɛmˈpɛs.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35087,'tempestivus','a','tempestiv tempestiv tempestiv',NULL,NULL,'[tɛm.pɛsˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35088,'tempestuosus','a','tempestuos tempestuos tempestuos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (35089,'templum','n','templ',NULL,NULL,'[ˈtɛm.pɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35090,'temporalis','a','temporal temporal temporal',NULL,NULL,'[tɛm.pɔˈraː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (35092,'temporarius','a','temporari temporari temporari',NULL,NULL,'[tɛm.pɔˈraː.ri.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35095,'tempto','v','tempt temptav temptat',NULL,NULL,'[ˈtɛmp.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35097,'temptamen','n','temptamin',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (35098,'temptamentum','n','temptament',NULL,NULL,'[tɛmp.taˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35099,'temptatio','n','temptation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (35101,'tempus','n','tempor',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (35102,'temulentus','a','temulent temulent temulent',NULL,NULL,'[teː.mʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35103,'temulentia','n','temulenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35104,'teneo','v','ten tenu tent',NULL,NULL,'[ˈtɛ.ne.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (35108,'tenax','a','tenac tenac tenac',NULL,NULL,'[ˈtɛ.naːks]','aps---an3-');
INSERT INTO latin_morpho VALUES (35110,'tendo','v','tend tetend tens',NULL,NULL,'[ˈtɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35111,'tendicula','n','tendicul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35113,'tenebro','v','tenebr tenebrav tenebrat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (35121,'tener','a','tener tener tener',NULL,NULL,'[ˈtɛ.nɛr]','aps---mn1r');
INSERT INTO latin_morpho VALUES (35123,'teneritas','n','teneritat',NULL,NULL,'[tɛˈnɛ.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35139,'tentorium','n','tentori',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35140,'tenuo','v','tenu tenuav tenuat',NULL,NULL,'[ˈtɛ.nʊ.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35141,'tenuis','a','tenu tenu tenu',NULL,NULL,'[ˈtɛ.nʊ.ɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (35148,'tepefacio','v','tepefac tepefec tepefact',NULL,NULL,'/te.peˈfa.ki.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (35152,'tepor','n','tepor',NULL,NULL,'[ˈtɛ.pɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35154,'tero','v','ter triv trit',NULL,NULL,'[ˈtɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35167,'tergum','n','terg',NULL,NULL,'[ˈtɛr.ɡũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35168,'tergeo','v','terg ters ters',NULL,NULL,'[ˈtɛr.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (35174,'tergus','n','terg',NULL,NULL,'[ˈtɛr.ɡʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (35176,'termen','n','termin',NULL,'n-s---nn3-=termo','[ˈtɛr.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (35179,'terminus','n','termin',NULL,NULL,'[ˈtɛr.mɪ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35180,'termino','v','termin terminav terminat',NULL,NULL,'[ˈtɛr.mɪ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35183,'terminatio','n','termination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (35189,'terra','n','terr',NULL,NULL,'[ˈtɛr.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35190,'terreo','v','terr terru territ',NULL,NULL,'[ˈtɛr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (35191,'terraemotus','n','terraemot',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (35194,'terrenus','a','terren terren terren',NULL,NULL,'[tɛrˈreː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35199,'terrifico','v','terrific terrificav terrificat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (35207,'terror','n','terror',NULL,NULL,'[ˈtɛr.rɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35225,'tessella','n','tessell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35228,'tessera','n','tesser',NULL,NULL,'[ˈtɛs.sɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35230,'testa','n','test',NULL,NULL,'[ˈtɛs.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35233,'testor','v','test testat -',NULL,NULL,'[ˈtɛs.tɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (35236,'testamentum','n','testament',NULL,NULL,'[tɛs.taːˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35244,'testiculus','n','testicul',NULL,NULL,'[tɛsˈtɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35245,'testificor','v','testific testificat -',NULL,NULL,'[tɛsˈtɪ.fɪ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (35246,'testimonium','n','testimoni',NULL,NULL,'[tɛs.tɪˈmoː.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35251,'testudo','n','testudin',NULL,NULL,'[tɛsˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35252,'testula','n','testul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35281,'texo','v','tex texu text',NULL,NULL,'[ˈtɛk.soː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35282,'textum','n','text',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35283,'textus','n','text',NULL,NULL,'[ˈtɛk.stʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (35285,'textor','n','textor',NULL,NULL,'[ˈtɛk.stɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35288,'textura','n','textur',NULL,NULL,'[tɛkˈstuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35289,'thalamus','n','thalam',NULL,NULL,'[ˈtʰa.ɫa.mʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35297,'theatrum','n','theatr',NULL,NULL,'[tʰɛˈaː.trũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35300,'theca','n','thec',NULL,NULL,'/ˈtʰeː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35303,'thema','n','themat',NULL,NULL,'[ˈtʰɛ.ma]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (35310,'theologus','n','theolog',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (35311,'theologia','n','theologi',NULL,NULL,'[tʰe.ɔˈɫɔ.ɡi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35312,'theologicus','a','theologic theologic theologic',NULL,NULL,'[tʰe.ɔˈɫɔ.ɡɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35332,'thesaurizo','v','thesauriz thesaurizav thesauriza',NULL,NULL,'[tʰeːˈsau̯.rɪ.zoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35339,'thorax','n','thorac',NULL,NULL,'/ˈtʰoː.raks/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35352,'thronus','n','thron',NULL,NULL,'[ˈtʰrɔ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35360,'thymum','n','thym',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35367,'thymiama','n','thymiamat',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (35368,'thymiamaterium','n','thymiamateri',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35378,'Tiberinus','n','Tiberin',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (35380,'Tiberis','n','Tiber',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (35381,'tibia','n','tibi',NULL,NULL,'/ˈtiː.bi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35383,'tibicen','n','tibicin',NULL,NULL,'[tiːˈbiː.kẽ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35388,'tigris','n','tigrid',NULL,NULL,'[ˈtɪ.ɡrɪs]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35395,'timeo','v','tim timu -',NULL,NULL,'[ˈtɪ.me.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (35397,'timidus','a','timid timid timid',NULL,NULL,'[ˈtɪ.mɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35398,'timide','r',NULL,NULL,NULL,'[ˈtɪ.mɪ.dɛ]','rp--------');
INSERT INTO latin_morpho VALUES (35399,'timor','n','timor',NULL,NULL,'/ˈti.mor/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35405,'tinea','n','tine',NULL,NULL,'[ˈtɪ.ne.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35407,'tingo','v','ting tinx tinct',NULL,NULL,'[ˈtɪŋ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35416,'tintinnabulum','n','tintinnabul',NULL,NULL,'[tɪn.tɪnˈnaː.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35418,'tiro','n','tiron',NULL,NULL,'/ˈtiː.roː/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35428,'titillo','v','titill titillav titillat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (35430,'titio','n','tition',NULL,NULL,'[ˈtɪ.ti.ɔ]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35432,'titubo','v','titub titubav titubat',NULL,NULL,'[ˈtɪ.tʊ.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35434,'titulus','n','titul',NULL,NULL,'[ˈtɪ.tʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35438,'toga','n','tog',NULL,NULL,'[ˈtɔ.ɡa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35440,'togatus','a','togat togat togat',NULL,NULL,'[tɔˈɡaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35446,'tolero','v','toler tolerav tolerat',NULL,NULL,'[ˈtɔ.ɫɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35447,'tolerabilis','a','tolerabil tolerabil tolerabil',NULL,NULL,'[tɔ.ɫɛˈraː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (35454,'tollo','v','toll sustul sublat',NULL,NULL,'[ˈtɔl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35461,'tomix','n','tomic',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (35463,'tonus','n','ton',NULL,NULL,'[ˈtɔ.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35467,'tono','v','ton tonu -',NULL,NULL,'[ˈtɔ.noː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35470,'tondeo','v','tond totond tons',NULL,NULL,'[ˈtɔn.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (35479,'tonsa','n','tons',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35482,'tonsilis','a','tonsil tonsil tonsil',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (35484,'tonsor','n','tonsor',NULL,NULL,'[ˈtõː.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35490,'tonsura','n','tonsur',NULL,NULL,'[tõːˈsuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35491,'toparchia','n','toparchi',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35502,'torus','n','tor',NULL,NULL,'[ˈtɔ.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35513,'tormentum','n','torment',NULL,NULL,'[tɔrˈmɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35515,'tormento','v','torment tormentav tormentat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (35519,'tornus','n','torn',NULL,NULL,'[ˈtɔr.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35523,'tornator','n','tornator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (35532,'torpor','n','torpor',NULL,NULL,'[ˈtɔr.pɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35533,'torqueo','v','torqu tors tort',NULL,NULL,'[ˈtɔr.kᶣe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (35535,'torques','n','torqu',NULL,NULL,'[ˈtɔr.kᶣeːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (35538,'torreo','v','torr torru tost',NULL,NULL,'[ˈtɔr.re.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (35539,'torrens','n','torrent',NULL,NULL,NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (35543,'torris','n','torr',NULL,'n-s---mn2-=torrus n-s---mn3-=torres',NULL,'n-s---mn3i');
INSERT INTO latin_morpho VALUES (35549,'tortor','n','tortor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (35552,'tortura','n','tortur',NULL,NULL,'[tɔrˈtuː.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35558,'totus','a','tot tot tot',NULL,NULL,'[ˈtoː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35565,'toxicum','n','toxic',NULL,NULL,'[ˈtɔk.sɪ.kũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35579,'trabs','n','trab',NULL,NULL,'/traps/','n-s---fn3i');
INSERT INTO latin_morpho VALUES (35581,'tractus','n','tract',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (35582,'tracto','v','tract tractav tractat',NULL,NULL,'/ˈtrak.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (35587,'tractatio','n','tractation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (35590,'trado','v','trad tradid tradit',NULL,NULL,'/ˈtraː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (35591,'traditio','n','tradition',NULL,NULL,'[traːˈdɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35595,'traduco','v','traduc tradux traduct',NULL,NULL,'/traːˈduː.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (35596,'traductio','n','traduction',NULL,NULL,'[traːˈdʊk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35604,'tragicus','a','tragic tragic tragic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (35609,'tragula','n','tragul',NULL,NULL,'[ˈtraː.ɡʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35611,'traho','v','trah trax tract',NULL,NULL,'/ˈtra.hoː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (35613,'traicio','v','traic traiec traiect',NULL,NULL,'/traːˈji.ki.oː/','v1spia--3i');
INSERT INTO latin_morpho VALUES (35629,'tranquillus','a','tranquill tranquill tranquill',NULL,NULL,'[traŋˈkᶣɪl.lʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35630,'tranquillo','v','tranquill tranquillav tranquillat',NULL,NULL,'[traŋˈkᶣɪl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35631,'tranquillitas','n','tranquillitat',NULL,NULL,'/tranˈkʷil.li.taːs/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35634,'transactio','n','transaction',NULL,NULL,'[trãːˈsaːk.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35639,'transcendo','v','transcend transcend transcens',NULL,NULL,'[trãːˈskɛn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35643,'transcribo','v','transcrib transcrips transcript',NULL,NULL,'[trãːˈskriː.boː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35649,'transeo','v','trans transiv transit','v2spia--4-=transis v3spia--4-=transit v1ppia--4-=transimus v2ppia--4-=transitis v3ppia--4-=transeunt v1siia--4-=transibam v2siia--4-=transibas v3siia--4-=transibat v1piia--4-=transibamus v2piia--4-=transibatis v3piia--4-=transibant v1sfia--4-=transibo v2sfia--4-=transibis v3sfia--4-=transibit v1pfia--4-=transibimus v2pfia--4-=transibitis v3pfia--4-=transibunt v-sppamn4-=transiens v-sppafn4-=transiens v-sppann4-=transiens v-sfpamn4-=transiturus v-sfpafn4-=transitura v-sfpann4-=transiturum v-sfppmn4-=transeundus v-sfppfn4-=transeunda v-sfppnn4-=transeundum v-s-gang4-=transeundi v-s-damn4-=transeundus v-s-dafn4-=transeunda v-s-dann4-=transeundum',NULL,'[ˈtrãː.se.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (35650,'transenna','n','transenn',NULL,NULL,'[trãːˈsɛn.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35651,'transeunter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (35652,'transfero','v','transfer transtul translat','v--pna--3-=transferre v2spia--3-=transfers v3spia--3-=transfert v2ppia--3-=transfertis',NULL,'[ˈtrãːs.fɛ.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35654,'transfiguro','v','transfigur transfigurav transfigurat',NULL,NULL,'[trãːs.fɪˈɡuː.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35656,'transfodio','v','transfod transfod transfoss',NULL,NULL,'[trãːsˈfɔ.di.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (35659,'transformo','v','transform transformav transformat',NULL,NULL,'[trãːsˈfoːr.moː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35663,'transfuga','n','transfug',NULL,NULL,'[ˈtrãːs.fʊ.ɡa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (35664,'transfugio','v','transfug transfug transfugit',NULL,NULL,'[trãːsˈfʊ.ɡi.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (35665,'transfugium','n','transfugi',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35670,'transgredior','v','transgred transgress -',NULL,NULL,'[trãːsˈɡrɛ.di.ɔr]','v1spid--3i');
INSERT INTO latin_morpho VALUES (35672,'transgressio','n','transgression',NULL,NULL,'[trãːsˈɡrɛs.si.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35674,'transgressor','n','transgressor',NULL,NULL,'[trãːsˈɡrɛs.sɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35676,'transigo','v','transig transeg transact',NULL,NULL,'[ˈtrãː.sɪ.ɡoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35678,'transitus','n','transit',NULL,NULL,'[ˈtrãː.sɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (35679,'transitio','n','transition',NULL,NULL,'[trãːˈsɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35682,'transitorie','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (35685,'translaticius','a','translatici translatici translatici',NULL,NULL,'[trãː.sɫaːˈtiː.ki.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (35686,'translatio','n','translation',NULL,NULL,'[trãːˈsɫaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35694,'transmeo','v','transme transmeav transmeat',NULL,NULL,'[ˈtrãː.sme.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35699,'transmitto','v','transmitt transmis transmiss',NULL,NULL,'[trãːˈsmɪt.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35718,'transplanto','v','transplant transplantav transplantat',NULL,NULL,'[trãːˈspɫan.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35719,'transporto','v','transport transportav transportat',NULL,NULL,'[trãːˈspɔr.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35726,'transtrum','n','transtr',NULL,NULL,'[ˈtrãː.strũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35731,'transveho','v','transveh transvex transvect',NULL,NULL,'[ˈtrãː.swɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35761,'tremo','v','trem tremu -',NULL,NULL,'[ˈtrɛ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35765,'tremesco','v','tremesc - -',NULL,NULL,'[trɛˈmeːs.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35768,'tremor','n','tremor',NULL,NULL,'[ˈtrɛ.mɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35771,'trepido','v','trepid trepidav trepidat',NULL,NULL,'[ˈtrɛ.pɪ.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35787,'tribus','n','trib',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (35788,'tribolus','n','tribol',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (35792,'tribuo','v','tribu tribu tribut',NULL,NULL,'[ˈtrɪ.bʊ.oː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (35796,'tribulo','v','tribul tribulav tribulat',NULL,NULL,'[ˈtrɪ.bʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35797,'tribulatio','n','tribulation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (35799,'tribunus','n','tribun',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (35800,'tribunal','n','tribunal',NULL,NULL,'[trɪˈbuː.naɫ]','n-s---nn3i');
INSERT INTO latin_morpho VALUES (35806,'tributum','n','tribut',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (35811,'tributor','n','tributor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (35816,'trico','v','tric tricav tricat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (35824,'triclinium','n','triclini',NULL,NULL,'[trɪˈkliː.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35889,'trinitas','n','trinitat',NULL,NULL,'[ˈtriː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35916,'tristis','a','trist trist trist',NULL,NULL,'[ˈtriːs.tɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (35922,'tristifico','v','tristific tristificav tristifica',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (35924,'tristitia','n','tristiti',NULL,NULL,'[triːsˈtɪ.ti.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35926,'tristitudo','n','tristitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (35929,'tritus','a','trit trit trit',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (35931,'triticum','n','tritic',NULL,NULL,'[ˈtriː.tɪ.kũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35934,'tritura','n','tritur',NULL,NULL,'/triːˈtuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35935,'trituro','v','tritur triturav triturat',NULL,NULL,'/triːˈtuː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (35937,'triumphus','n','triumph',NULL,NULL,'[trɪˈʊm.pʰʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35938,'triumpho','v','triumph triumphav triumphat',NULL,NULL,'/triˈum.pʰoː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (35943,'triumvir','n','triumvir',NULL,NULL,'[trɪˈʊm.wɪr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (35951,'trochaeus','n','trochae',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (35953,'trochlea','n','trochle',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35962,'tropus','n','trop',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (35964,'tropaeum','n','tropae',NULL,NULL,'[trɔˈpae̯.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (35969,'trucido','v','trucid trucidav trucidat',NULL,NULL,'[trʊˈkiː.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35970,'trucidatio','n','trucidation',NULL,NULL,'[trʊ.kiːˈdaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (35974,'trudo','v','trud trus trus',NULL,NULL,'/ˈtruː.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (35978,'truncus','n','trunc',NULL,NULL,'[ˈtrʊŋ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35979,'trunco','v','trunc truncav truncat',NULL,NULL,'[ˈtrʊŋ.kɔ]','v1spia--1-');
INSERT INTO latin_morpho VALUES (35982,'trutina','n','trutin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (35983,'trutino','v','trutin trutinav trutinat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (35989,'tueor','v','tu tuit -',NULL,NULL,'[ˈtʊ.e.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (35992,'tuba','n','tub',NULL,NULL,'[ˈtʊ.ba]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (35993,'tubus','n','tub',NULL,NULL,'[ˈtʊ.bʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (35997,'tuber','n','tuber',NULL,'n-s---nn3-=tubur','[ˈtuː.bɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (35998,'tuberculum','n','tubercul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36012,'tuitio','n','tuition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36019,'tum','r',NULL,NULL,NULL,'[tũ]','rp--------');
INSERT INTO latin_morpho VALUES (36022,'tumba','n','tumb',NULL,NULL,'[ˈtʊm.ba]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36027,'tumidus','a','tumid tumid tumid',NULL,NULL,'[ˈtʊ.mɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36028,'tumor','n','tumor',NULL,NULL,'[ˈtʊ.mɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36029,'tumulus','n','tumul',NULL,NULL,'[ˈtʊ.mʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36032,'tumultus','n','tumult',NULL,NULL,'[tʊˈmʊɫ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (36039,'tunc','r',NULL,NULL,NULL,'[tʊŋk]','rp--------');
INSERT INTO latin_morpho VALUES (36040,'tundo','v','tund tutud tuns',NULL,NULL,'[ˈtʊn.doː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (36044,'tunica','n','tunic',NULL,NULL,'[ˈtʊ.nɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36048,'turba','n','turb',NULL,NULL,'[ˈtʊr.ba]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36049,'turbo','v','turb turbav turbat',NULL,NULL,'[ˈtʊr.boː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36051,'turbatio','n','turbation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36056,'turbidus','a','turbid turbid turbid',NULL,NULL,'[ˈtʊr.bɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36057,'turbido','v','turbid turbidav turbidat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (36058,'turbido','n','turbidin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36060,'turbo','n','turbin',NULL,NULL,'[ˈtʊr.boː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36062,'turbulentus','a','turbulent turbulent turbulent',NULL,NULL,'[tʊr.bʊˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36063,'turdus','n','turd',NULL,NULL,'[ˈtʊr.dʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36067,'turgidus','a','turgid turgid turgid',NULL,NULL,'[ˈtʊr.ɡɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36069,'turgor','n','turgor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (36075,'turma','n','turm',NULL,NULL,'/ˈtur.ma/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36079,'turpo','v','turp turpav turpat',NULL,NULL,'[ˈtʊr.poː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36080,'turpis','a','turp turp turp',NULL,NULL,'[ˈtʊr.pɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (36090,'turpiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36091,'turpitudo','n','turpitudin',NULL,NULL,'/tur.piˈtuː.doː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36092,'turricula','n','turricul',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36095,'turris','n','turr',NULL,NULL,'[ˈtʊr.rɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (36102,'tussio','v','tussiv tussiv tussit',NULL,NULL,'[ˈtʊs.si.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (36105,'tussis','n','tuss',NULL,NULL,'[ˈtʊs.sɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (36106,'tuto','v','tut tutav tutat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (36107,'tutus','a','tut tut tut',NULL,NULL,'[ˈtuː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36108,'tutor','v','tut tutat -',NULL,NULL,NULL,'v1spid--1-');
INSERT INTO latin_morpho VALUES (36112,'tutela','n','tutel',NULL,NULL,'[tuːˈteː.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36114,'tutor','n','tutor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (36119,'typus','n','typ',NULL,NULL,'[ˈtʏ.pʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36124,'typicus','a','typic typic typic',NULL,NULL,'[ˈtʏ.pɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36133,'tyrannus','n','tyrann',NULL,NULL,'/tʏˈran.nus/','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36138,'tyrannis','n','tyrannid',NULL,NULL,'[tʏˈran.nɪs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36142,'uber','n','uber',NULL,NULL,'[ˈuː.bɛr]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36143,'uber','a','uber uber uber',NULL,NULL,'[ˈuː.bɛr]','aps---an3-');
INSERT INTO latin_morpho VALUES (36144,'ubertas','n','ubertat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36159,'ulciscor','v','ulcisc ult -',NULL,NULL,'[ʊɫˈkiːs.kɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (36160,'ulcus','n','ulcer',NULL,NULL,'[ˈʊɫ.kʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36168,'ulmus','n','ulm',NULL,NULL,'[ˈʊɫ.mʊs]','n-s---fn2-');
INSERT INTO latin_morpho VALUES (36170,'ulna','n','uln',NULL,NULL,'[ˈʊɫ.na]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36176,'ultio','n','ultion',NULL,NULL,'[ˈʊɫ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36177,'ultor','n','ultor',NULL,NULL,'[ˈʊɫ.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36179,'ultra','r',NULL,NULL,NULL,'[ˈʊɫ.traː]','rp--------');
INSERT INTO latin_morpho VALUES (36188,'ulula','n','ulul',NULL,NULL,'[ˈʊ.ɫʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36189,'ululo','v','ulul ululav ululat',NULL,NULL,'[ˈʊ.ɫʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36190,'ululatus','n','ululat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (36194,'umbella','n','umbell',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36195,'umbilicus','n','umbilic',NULL,NULL,'[ʊm.bɪˈliː.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36196,'umbo','n','umbon',NULL,NULL,'[ˈʊm.boː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36197,'umbra','n','umbr',NULL,NULL,'[ˈʊm.bra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36198,'umbro','v','umbr umbrav umbrat',NULL,NULL,'[ˈʊm.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36199,'umbraculum','n','umbracul',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36207,'umecto','v','umect umectav umectat',NULL,NULL,'[uːˈmɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36215,'umor','n','umor',NULL,NULL,'[ˈuː.mɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36219,'una','r',NULL,NULL,NULL,'Nominative/vocative singular forms: /ˈuː.na/','rp--------');
INSERT INTO latin_morpho VALUES (36223,'unanimitas','n','unanimitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36224,'unanimiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36225,'uncus','n','unc',NULL,NULL,'[ˈʊŋ.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36226,'uncus','a','unc unc unc',NULL,NULL,'[ˈʊŋ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36227,'uncia','n','unci',NULL,NULL,'[ˈʊŋ.ki.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36230,'uncinus','n','uncin',NULL,NULL,'[ʊŋˈkiː.nʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36236,'unctio','n','unction',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36240,'unda','n','und',NULL,NULL,'[ˈʊn.da]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36241,'undo','v','und undav undat',NULL,NULL,'[ˈʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36242,'unde','r',NULL,NULL,NULL,'[ˈʊn.dɛ]','rp--------');
INSERT INTO latin_morpho VALUES (36260,'undique','r',NULL,NULL,NULL,'[ˈʊn.dɪ.kᶣɛ]','rp--------');
INSERT INTO latin_morpho VALUES (36269,'unguo','v','ungu unx unct',NULL,NULL,'[ˈʊŋ.ɡʷoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (36271,'unguedo','n','unguedin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36272,'unguen','n','unguin',NULL,NULL,'[ˈʊŋ.ɡᶣẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36273,'unguentum','n','unguent',NULL,NULL,'[ʊŋˈɡᶣɛn.tũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36277,'unguis','n','ungu',NULL,NULL,'[ˈʊŋ.ɡᶣɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (36278,'ungula','n','ungul',NULL,NULL,'[ˈʊŋ.ɡʊ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36279,'unio','v','un uni unit',NULL,NULL,'/ˈuː.ni.oː/','v1spia--4-');
INSERT INTO latin_morpho VALUES (36285,'unice','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36291,'unicornuus','n','unicornu',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (36293,'unifico','v','unific unificav unificat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (36294,'uniformis','a','uniform uniform uniform',NULL,NULL,'[uː.nɪˈfoːr.mɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (36295,'uniformiter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36300,'unitas','n','unitat',NULL,NULL,'[ˈuː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36303,'universus','a','univers univers univers',NULL,NULL,'[uː.nɪˈwɛr.sʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36306,'universaliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36310,'universitas','n','universitat',NULL,NULL,'[uː.nɪˈwɛr.sɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36321,'upupa','n','upup',NULL,NULL,'[ˈʊ.pʊ.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36323,'uro','v','ur uss ust',NULL,NULL,'/ˈuː.roː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (36326,'urbanus','a','urban urban urban',NULL,NULL,'[ʊrˈbaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36328,'urbanitas','n','urbanitat',NULL,NULL,'[ʊrˈbaː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36331,'urbs','n','urb',NULL,NULL,'[ʊrps]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (36333,'urceus','n','urce',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (36339,'urgeo','v','urg urs -',NULL,NULL,'[ˈʊr.ɡe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (36348,'ursus','n','urs',NULL,NULL,'[ˈʊr.sʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36352,'usus','n','us',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (36355,'usitatus','a','usitat usitat usitat',NULL,NULL,'[uː.sɪˈtaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36358,'usque','r',NULL,NULL,NULL,'[ˈuːs.kᶣɛ]','rp--------');
INSERT INTO latin_morpho VALUES (36360,'usquequaque','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36363,'ustio','n','ustion',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36365,'ustrina','n','ustrin',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36366,'ustulo','v','ustul ustulav ustulat',NULL,NULL,'[ˈʊs.tʊ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36367,'usualis','a','usual usual usual',NULL,NULL,'[uː.sʊˈaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (36371,'usura','n','usur',NULL,NULL,'/uːˈsuː.ra/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36373,'usurpo','v','usurp usurpav usurpat',NULL,NULL,'/uːˈsuːr.poː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (36374,'usurpatio','n','usurpation',NULL,NULL,'[uː.sʊrˈpaː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36376,'utor','v','ut us -',NULL,NULL,'[ˈuː.tɔr]','v1spid--3-');
INSERT INTO latin_morpho VALUES (36381,'uterus','n','uter',NULL,NULL,'[ˈʊ.tɛ.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36388,'utilis','a','util util util',NULL,NULL,'[ˈuː.tɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (36389,'utilitas','n','utilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36390,'utiliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36422,'uxor','n','uxor',NULL,NULL,'[ˈʊk.sɔr]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36428,'vacatio','n','vacation',NULL,NULL,'/waˈkaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36429,'vacca','n','vacc',NULL,NULL,'/ˈwak.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36433,'vaccinium','n','vaccini',NULL,NULL,'[wakˈkiː.ni.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36438,'vacillo','v','vacill vacillav vacillat',NULL,NULL,'[waˈkɪl.loː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36441,'vacuus','a','vacu vacu vacu',NULL,NULL,'[ˈwa.kʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36442,'vacuo','v','vacu vacuav vacuat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (36443,'vacuefacio','v','vacuefac vacuefec vacuefact',NULL,NULL,'[wa.kʊ.eːˈfa.ki.oː]','v1spia--3i');
INSERT INTO latin_morpho VALUES (36444,'vacuitas','n','vacuitat',NULL,NULL,'[waˈkʊ.ɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36445,'vadum','n','vad',NULL,NULL,'[ˈwa.dũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36446,'vado','v','vad vadav vadat',NULL,NULL,'/ˈwaː.doː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (36456,'vaframentum','n','vaframent',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36458,'vagor','v','vag vagat -',NULL,NULL,'[ˈwa.ɡɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (36462,'vagina','n','vagin',NULL,NULL,'/waːˈɡiː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36463,'vagitus','n','vagit',NULL,NULL,'[waːˈɡiː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (36466,'valeo','v','val valu valit',NULL,NULL,'[ˈwa.ɫe.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (36468,'valde','r',NULL,NULL,NULL,'[ˈwaɫ.deː]','rp--------');
INSERT INTO latin_morpho VALUES (36472,'valens','a','valent valent valent',NULL,NULL,'[ˈwa.ɫẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (36473,'valenter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36480,'valetudinarium','n','valetudinari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36482,'valetudo','n','valetudin',NULL,NULL,'[wa.ɫeːˈtuː.doː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36484,'validus','a','valid valid valid',NULL,NULL,'[ˈwa.lɪ.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36486,'vallus','n','vall',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (36487,'vallum','n','vall',NULL,NULL,'[ˈwal.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36488,'vallo','v','vall vallav vallat',NULL,NULL,'/ˈwal.loː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (36492,'vallis','n','vall',NULL,NULL,'[ˈwal.lɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (36497,'vanus','a','van van van',NULL,NULL,'[ˈwaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36498,'vanesco','v','vanesc - -',NULL,NULL,'/waːˈneːs.koː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (36506,'vanitas','n','vanitat',NULL,NULL,'[ˈwaː.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36510,'vapor','n','vapor',NULL,NULL,'[ˈwa.pɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36512,'vaporo','v','vapor vaporav vaporat',NULL,NULL,'/waˈpoː.roː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (36523,'vario','v','vari variav variat',NULL,NULL,'/ˈwa.ri.oː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (36524,'variabilis','a','variabil variabil variabil',NULL,NULL,'[wa.rɪˈaː.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (36526,'variantia','n','varianti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36531,'varietas','n','varietat',NULL,NULL,'[waˈri.ɛ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36532,'varix','n','varic',NULL,NULL,'[ˈwa.rɪks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36535,'vas','n','vas',NULL,NULL,'/waːs/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36547,'vates','n','vat',NULL,NULL,'/ˈwaː.teːs/','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36550,'vaticinor','v','vaticin vaticinat -',NULL,NULL,'[waːˈtɪ.kɪ.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (36551,'vaticinatio','n','vaticination',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36552,'vaticinator','n','vaticinator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (36553,'vaticinium','n','vaticini',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36556,'vatillum','n','vatill',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36561,'vecors','a','vecord vecord vecord',NULL,NULL,'[ˈweː.kɔrs]','aps---an3-');
INSERT INTO latin_morpho VALUES (36562,'vecto','v','vect vectav vectat',NULL,NULL,'[ˈwɛk.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36563,'vectigal','n','vectigal',NULL,NULL,NULL,'n-s---nn3i');
INSERT INTO latin_morpho VALUES (36566,'vectis','n','vect',NULL,NULL,'[ˈwɛk.tɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (36571,'vegeto','v','veget vegetav vegetat',NULL,NULL,'[ˈwɛ.ɡɛ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36572,'vegetus','a','veget veget veget',NULL,NULL,'[ˈwɛ.ɡɛ.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36581,'veho','v','veh vex vect',NULL,NULL,'[ˈwɛ.hoː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (36582,'vehemens','a','vehement vehement vehement',NULL,NULL,'[ˈwɛ.hɛ.mẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (36583,'vehementer','r',NULL,NULL,NULL,'[wɛ.hɛˈmɛn.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (36584,'vehiculum','n','vehicul',NULL,NULL,'[wɛˈhɪ.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36587,'velum','n','vel',NULL,NULL,'[ˈweː.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36588,'velo','v','vel velav velat',NULL,NULL,'[ˈweː.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36589,'velamen','n','velamin',NULL,NULL,'[weːˈɫaː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36590,'velamentum','n','velament',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36594,'velifico','v','velific velificav velificat',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (36595,'velificor','v','velific velificat -',NULL,NULL,'[weːˈlɪ.fɪ.kɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (36604,'vello','v','vell vuls vuls',NULL,NULL,'[ˈwɛl.loː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (36612,'vellus','n','vell',NULL,NULL,'[ˈwɛl.lʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36613,'velocitas','n','velocitat',NULL,NULL,'[weːˈɫoː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36614,'velociter','r',NULL,NULL,NULL,'[weːˈɫoː.kɪ.tɛr]','rp--------');
INSERT INTO latin_morpho VALUES (36619,'vena','n','ven',NULL,NULL,'/ˈweː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36621,'venor','v','ven venat -',NULL,NULL,'[ˈweː.nɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (36627,'venatus','n','venat',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (36629,'venatio','n','venation',NULL,NULL,'/weːˈnaː.ti.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36630,'venator','n','venator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (36632,'venatrix','n','venatric',NULL,NULL,'/weːˈnaː.triːks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36633,'vendo','v','vend vendid vendit',NULL,NULL,'/ˈweːn.doː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (36638,'venditio','n','vendition',NULL,NULL,'[weːnˈdɪ.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36639,'venditor','n','venditor',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (36645,'veneficium','n','venefici',NULL,NULL,'[wɛ.neːˈfɪ.ki.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36646,'venenum','n','venen',NULL,NULL,'[wɛˈneː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36651,'veneror','v','vener venerat -',NULL,NULL,'[ˈwɛ.nɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (36655,'veneratio','n','veneration',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36662,'Venetia','n','Veneti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36663,'venio','v','ven ven vent',NULL,NULL,'[ˈwɛ.ni.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (36664,'venia','n','veni',NULL,NULL,'[ˈwɛ.ni.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36667,'ventus','n','vent',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (36669,'venter','n','ventr',NULL,NULL,'[ˈwɛn.tɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36670,'ventilo','v','ventil ventilav ventilat',NULL,NULL,'[ˈwɛn.tɪ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36677,'ventriculus','n','ventricul',NULL,NULL,'[wɛnˈtrɪ.kʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36681,'venumdo','v','venumd venumded venumdat',NULL,'v1spia--1-=venundo v--pna--1-=venundare v1sria--1-=venumdedi v-srppmn1-=venumdatus v-srppfn1-=venumdata v-srppnn1-=venumdatum','[weːˈnʊn.doː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36683,'Venus','n','Vener',NULL,NULL,'[ˈweː.nʊs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36684,'venustus','a','venust venust venust',NULL,NULL,'[wɛˈnʊs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36685,'venusto','v','venust venustav venusta',NULL,NULL,'[wɛˈnʊs.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36686,'venustas','n','venustat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36693,'ver','n','ver',NULL,NULL,'/weːr/','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36694,'veru','n','ver',NULL,NULL,'[ˈwɛ.ruː]','n-s---nn4-');
INSERT INTO latin_morpho VALUES (36695,'verus','a','ver ver ver',NULL,NULL,'[ˈweː.rʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36696,'vereor','v','ver verit -',NULL,NULL,'[ˈwɛ.re.ɔr]','v1spid--2-');
INSERT INTO latin_morpho VALUES (36697,'veraciter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36699,'verax','a','verac verac verac',NULL,NULL,'/ˈweː.raːks/','aps---an3i');
INSERT INTO latin_morpho VALUES (36700,'verbum','n','verb',NULL,NULL,'[ˈwɛr.bũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36704,'verber','n','verber',NULL,NULL,NULL,'n-s---nn3-');
INSERT INTO latin_morpho VALUES (36705,'verbero','v','verber verberav verberat',NULL,NULL,'[ˈwɛr.bɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36708,'verbero','n','verberon',NULL,NULL,'[ˈwɛr.bɛ.roː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36711,'vere','r',NULL,NULL,NULL,'/ˈweː.reː/','rp--------');
INSERT INTO latin_morpho VALUES (36712,'verecundus','a','verecund verecund verecund',NULL,NULL,'[wɛ.reːˈkʊn.dʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36714,'verecundia','n','verecundi',NULL,NULL,'[wɛ.reːˈkʊn.di.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36728,'veridicus','a','veridic veridic veridic',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (36730,'veriloquium','n','veriloqui',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36733,'veritas','n','veritat',NULL,NULL,'[ˈweː.rɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36734,'vermiculus','n','vermicul',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (36737,'vermis','n','verm',NULL,NULL,'[ˈwɛr.mɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (36741,'vernaculus','a','vernacul vernacul vernacul',NULL,NULL,'[wɛrˈnaː.kʊ.ɫʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36743,'verniliter','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36746,'vero','r',NULL,NULL,NULL,'/ˈweː.roː/','rp--------');
INSERT INTO latin_morpho VALUES (36747,'verpa','n','verp',NULL,NULL,'[ˈwɛr.pa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36749,'verro','v','verr verr vers',NULL,NULL,'[ˈwɛr.roː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (36750,'verres','n','verr',NULL,NULL,'[ˈwɛr.reːs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (36754,'verruca','n','verruc',NULL,NULL,'[wɛrˈruː.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36758,'versus','n','vers',NULL,'n-s---mn4-=vorsus',NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (36759,'verso','v','vers versav versat',NULL,NULL,'[ˈwɛr.soː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36760,'versor','v','vers versat -',NULL,NULL,'[ˈwɛr.sɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (36769,'versificator','n','versificator',NULL,NULL,'[wɛr.sɪ.fɪˈkaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36778,'versutia','n','versuti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36780,'verto','v','vert vert vers',NULL,NULL,'[ˈwɛr.toː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (36781,'vertebra','n','vertebr',NULL,NULL,'[ˈwɛr.tɛ.bra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36782,'vertex','n','vertic',NULL,NULL,'[ˈwɛr.tɛks]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36787,'vertigo','n','vertigin',NULL,NULL,'[wɛrˈtiː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36788,'verum','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (36794,'vesanus','a','vesan vesan vesan',NULL,NULL,'[weːˈsaː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36795,'vesania','n','vesani',NULL,NULL,'/weːˈsaː.ni.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36797,'vescus','a','vesc vesc vesc',NULL,NULL,'[ˈweːs.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36799,'vesica','n','vesic',NULL,NULL,'/weːˈsiː.ka/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36802,'vespa','n','vesp',NULL,NULL,'[ˈwɛs.pa]','n-s---mn1-');
INSERT INTO latin_morpho VALUES (36803,'Vespasianus','n','Vespasian',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (36804,'vespera','n','vesper',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36805,'vesper','n','vesper',NULL,NULL,'[ˈwɛs.pɛr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (36810,'vespertilio','n','vespertilion',NULL,NULL,'[wɛs.pɛrˈtiː.li.oː]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36817,'vestio','v','vest vesti vestit',NULL,NULL,'[ˈwɛs.ti.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (36818,'vestiarium','n','vestiari',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36822,'vestibulum','n','vestibul',NULL,NULL,'[wɛsˈtɪ.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36823,'vestigo','v','vestig vestigav vestigat',NULL,NULL,'[wɛsˈtiː.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36824,'vestigium','n','vestigi',NULL,NULL,'[wɛsˈtiː.ɡi.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36825,'vestimentum','n','vestiment',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (36827,'vestis','n','vest',NULL,NULL,'[ˈwɛs.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (36829,'vestitus','n','vestit',NULL,NULL,'[wɛsˈtiː.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (36830,'veto','v','vot vetu vetit',NULL,NULL,'[ˈwɛ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36834,'veteranus','a','veteran veteran veteran',NULL,NULL,'[wɛ.tɛˈraː.nʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36847,'vetus','a','veter veter veter',NULL,NULL,'[ˈwɛ.tʊs]','aps---an3-');
INSERT INTO latin_morpho VALUES (36848,'vetustus','a','vetust vetust vetust',NULL,NULL,'[wɛˈtʊs.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36850,'vetustas','n','vetustat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36852,'vexo','v','vex vexav vexat',NULL,NULL,'/ˈweːk.soː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (36854,'vexatio','n','vexation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36855,'vexillum','n','vexill',NULL,NULL,'[wɛkˈsɪl.lũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36856,'vexillarius','n','vexillari',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (36860,'via','n','vi',NULL,NULL,'/ˈwi.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36861,'vieo','v','vi - viet',NULL,NULL,'/ˈwi.e.oː/','v1spia--2-');
INSERT INTO latin_morpho VALUES (36865,'viator','n','viator',NULL,NULL,'[wɪˈaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36867,'vibro','v','vibr vibrav vibrat',NULL,NULL,'[ˈwɪ.broː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36870,'vicus','n','vic',NULL,NULL,'[ˈwiː.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36889,'vicia','n','vici',NULL,NULL,'[ˈwɪ.ki.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36895,'vicinia','n','vicini',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36896,'vicinitas','n','vicinitat',NULL,NULL,'[wiːˈkiː.nɪ.tas]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (36897,'vicis','n','vic',NULL,NULL,'[ˈwɪ.kɪs]','n-s---mn3i');
INSERT INTO latin_morpho VALUES (36900,'vicissitudo','n','vicissitudin',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36901,'victus','n','vict',NULL,NULL,NULL,'n-s---mn4-');
INSERT INTO latin_morpho VALUES (36907,'victoria','n','victori',NULL,NULL,'[wɪkˈtoː.ri.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36917,'video','v','vid vid vis',NULL,NULL,'[ˈwɪ.de.oː]','v1spia--2-');
INSERT INTO latin_morpho VALUES (36918,'videlicet','r',NULL,NULL,NULL,'[wɪˈdeː.lɪ.kɛt]','rp--------');
INSERT INTO latin_morpho VALUES (36919,'viduus','a','vidu vidu vidu',NULL,NULL,'[ˈwɪ.dʊ.ʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (36922,'viduitas','n','viduitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (36923,'vidulus','n','vidul',NULL,NULL,'[ˈwiː.dʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (36935,'vigil','a','vigil vigil vigil',NULL,NULL,'[ˈwɪ.ɡɪɫ]','aps---an3-');
INSERT INTO latin_morpho VALUES (36942,'vigilia','n','vigili',NULL,NULL,'[wɪˈɡɪ.li.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36947,'vigor','n','vigor',NULL,NULL,'[ˈwɪ.ɡɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36961,'villa','n','vill',NULL,NULL,'/ˈwiːl.la/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (36974,'vimen','n','vimin',NULL,NULL,'[ˈwiː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (36976,'vinum','n','vin',NULL,NULL,'[ˈwiː.nũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36981,'vinco','v','vinc vic vict',NULL,NULL,'[ˈwɪŋ.koː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (36983,'vincio','v','vinc vinx vinct',NULL,NULL,'[ˈwɪŋ.ki.oː]','v1spia--4-');
INSERT INTO latin_morpho VALUES (36985,'vinculum','n','vincul',NULL,NULL,'[ˈwɪŋ.kʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (36988,'vindemiator','n','vindemiator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (36991,'vindex','n','vindic',NULL,NULL,'[ˈwɪn.dɛks]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (36992,'vindico','v','vindic vindicav vindicat',NULL,NULL,'[ˈwɪn.dɪ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (36995,'vindicta','n','vindict',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (36996,'vinea','n','vine',NULL,NULL,'/ˈwiː.ne.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37006,'viola','n','viol',NULL,NULL,'[ˈwi.ɔ.ɫa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37008,'violo','v','viol violav violat',NULL,NULL,'[ˈwi.ɔ.ɫoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37013,'violatio','n','violation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (37014,'violator','n','violator',NULL,NULL,'[wi.ɔˈɫaː.tɔr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (37015,'violens','a','violent violent violent',NULL,NULL,'[ˈwi.ɔ.ɫẽːs]','aps---an3i');
INSERT INTO latin_morpho VALUES (37016,'violentus','a','violent violent violent',NULL,NULL,'[wi.ɔˈɫɛn.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (37018,'violentia','n','violenti',NULL,NULL,NULL,'n-s---fn1-');
INSERT INTO latin_morpho VALUES (37022,'vipera','n','viper',NULL,NULL,'[ˈwiː.pɛ.ra]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37025,'virus','n','vir','n-s---na2-=virus',NULL,'[ˈwiː.rʊs]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (37027,'vir','n','vir',NULL,NULL,'[wɪr]','n-s---mn2r');
INSERT INTO latin_morpho VALUES (37035,'virga','n','virg',NULL,NULL,'[ˈwɪr.ɡa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37048,'virginitas','n','virginitat',NULL,NULL,'[wɪrˈɡɪ.nɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37049,'virgo','n','virgin',NULL,NULL,'[ˈwɪr.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37053,'viridis','a','virid virid virid',NULL,NULL,'[ˈwɪ.rɪ.dɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (37059,'virilis','a','viril viril viril',NULL,NULL,'[wɪˈriː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (37061,'viripotens','a','viripotent viripotent viripotent',NULL,NULL,NULL,'aps---an3i');
INSERT INTO latin_morpho VALUES (37062,'viritim','r',NULL,NULL,NULL,NULL,'rp--------');
INSERT INTO latin_morpho VALUES (37064,'viror','n','viror',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (37072,'virtus','n','virtut',NULL,NULL,'[ˈwɪr.tuːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37075,'vis','n','vis',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (37078,'visum','n','vis',NULL,NULL,'[ˈwiː.sũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (37079,'visus','n','vis',NULL,NULL,'[ˈwiː.sʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (37080,'viso','v','vis vis vis',NULL,NULL,'/ˈwiː.soː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (37082,'viscum','n','visc',NULL,NULL,'[ˈwɪs.kũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (37088,'viscus','n','viscer',NULL,NULL,'[ˈwɪs.kʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (37089,'visibilis','a','visibil visibil visibil',NULL,NULL,'[wiːˈsɪ.bɪ.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (37092,'visio','n','vision',NULL,NULL,'/ˈwiː.si.oː/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37093,'visito','v','visit visitav visitat',NULL,NULL,'[ˈwiː.sɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37094,'visitatio','n','visitation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (37096,'visitator','n','visitator',NULL,NULL,NULL,'n-s---mn3-');
INSERT INTO latin_morpho VALUES (37105,'vita','n','vit',NULL,NULL,'/ˈwiː.ta/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37107,'vito','v','vit vitav vitat',NULL,NULL,'/ˈwiː.toː/','v1spia--1-');
INSERT INTO latin_morpho VALUES (37111,'vitalis','a','vital vital vital',NULL,NULL,'[wiːˈtaː.lɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (37117,'vitellus','n','vitell',NULL,NULL,'[wɪˈtɛl.lʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (37121,'vitium','n','viti',NULL,NULL,'[ˈwɪ.ti.ũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (37122,'vitio','v','viti vitiav vitiat',NULL,NULL,'[ˈwɪ.ti.oː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37132,'vitis','n','vit',NULL,NULL,'[ˈwiː.tɪs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (37137,'vitricus','n','vitric',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (37140,'vitta','n','vitt',NULL,NULL,'[ˈwɪt.ta]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37143,'vitulus','n','vitul',NULL,NULL,'[ˈwɪ.tʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (37147,'vitupero','v','vituper vituperav vituperat',NULL,NULL,'[wɪˈtʊ.pɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37150,'vituperatio','n','vituperation',NULL,NULL,'[wɪ.tʊ.pɛˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37151,'vivus','a','viv viv viv',NULL,NULL,'[ˈwiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (37152,'vivo','v','viv vix vict',NULL,NULL,'/ˈwiː.woː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (37157,'vivesco','v','vivesc vivix -',NULL,NULL,NULL,'v1spia--3-');
INSERT INTO latin_morpho VALUES (37163,'vix','r',NULL,NULL,NULL,'[wɪks]','rp--------');
INSERT INTO latin_morpho VALUES (37165,'voco','v','voc vocav vocat',NULL,NULL,'[ˈwɔ.koː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37166,'vocabulum','n','vocabul',NULL,NULL,'[wɔˈkaː.bʊ.ɫũ]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (37168,'vocalis','a','vocal vocal vocal',NULL,NULL,NULL,'aps---cn3i');
INSERT INTO latin_morpho VALUES (37171,'vocatio','n','vocation',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (37173,'vocativus','a','vocativ vocativ vocativ',NULL,NULL,'[wɔ.kaːˈtiː.wʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (37174,'vociferor','v','vocifer vociferat -',NULL,NULL,'[woːˈkɪ.fɛ.rɔr]','v1spid--1-');
INSERT INTO latin_morpho VALUES (37175,'vociferatio','n','vociferation',NULL,NULL,'[woː.kɪ.fɛˈraː.ti.oː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37176,'vocito','v','vocit vocitav vocitat',NULL,NULL,'[ˈwɔ.kɪ.toː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37179,'volo','v','vol volu ',NULL,NULL,NULL,'v1spia--1-');
INSERT INTO latin_morpho VALUES (37185,'volaticus','a','volatic volatic volatic',NULL,NULL,'[wɔˈɫaː.tɪ.kʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (37208,'volubilitas','n','volubilitat',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (37211,'volucer','a','volucr volucr volucr',NULL,NULL,'[ˈwɔ.ɫʊ.kɛr]','aps---mn3-');
INSERT INTO latin_morpho VALUES (37212,'volucris','n','volucr',NULL,NULL,NULL,'n-s---fn3i');
INSERT INTO latin_morpho VALUES (37213,'volumen','n','volumin',NULL,NULL,'[wɔˈɫuː.mẽ]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (37217,'voluntas','n','voluntat',NULL,NULL,'[wɔˈɫʊn.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37222,'voluptas','n','voluptat',NULL,NULL,'[wɔˈɫʊp.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37228,'volvo','v','volv volv volut',NULL,NULL,'[ˈwɔɫ.woː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (37229,'vomo','v','vom vomu vomit',NULL,NULL,'[ˈwɔ.moː]','v1spia--3-');
INSERT INTO latin_morpho VALUES (37230,'vomer','n','vomer',NULL,NULL,'[ˈwoː.mɛr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (37231,'vomica','n','vomic',NULL,NULL,'[ˈwɔ.mɪ.ka]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37232,'vomitus','n','vomit',NULL,NULL,'[ˈwɔ.mɪ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (37234,'vomitio','n','vomition',NULL,NULL,NULL,'n-s---fn3-');
INSERT INTO latin_morpho VALUES (37237,'voro','v','vor vorav vorat',NULL,NULL,'[ˈwɔ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37238,'voracitas','n','voracitat',NULL,NULL,'[wɔˈraː.kɪ.taːs]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37240,'vorago','n','voragin',NULL,NULL,'[wɔˈraː.ɡoː]','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37249,'votum','n','vot',NULL,NULL,NULL,'n-s---nn2-');
INSERT INTO latin_morpho VALUES (37253,'vox','n','voc',NULL,NULL,'/woːks/','n-s---fn3-');
INSERT INTO latin_morpho VALUES (37255,'Vulcanus','n','Vulcan',NULL,NULL,NULL,'n-s---mn2-');
INSERT INTO latin_morpho VALUES (37257,'vulgus','n','vulgus',NULL,NULL,'[ˈwʊɫ.ɡʊs]','n-s---nn2-');
INSERT INTO latin_morpho VALUES (37258,'vulgo','v','vulg vulgav vulgat',NULL,NULL,'[ˈwʊɫ.ɡoː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37259,'vulgaris','a','vulgar vulgar vulgar',NULL,NULL,'[wʊɫˈɡaː.rɪs]','aps---cn3i');
INSERT INTO latin_morpho VALUES (37260,'vulgatus','a','vulgat vulgat vulgat',NULL,NULL,'[wʊɫˈɡaː.tʊs]','aps---mn1-');
INSERT INTO latin_morpho VALUES (37263,'vulgo','r',NULL,NULL,NULL,'[ˈwʊɫ.ɡoː]','rp--------');
INSERT INTO latin_morpho VALUES (37264,'vulnero','v','vulner vulnerav vulnerat',NULL,NULL,'[ˈwʊɫ.nɛ.roː]','v1spia--1-');
INSERT INTO latin_morpho VALUES (37266,'vulnus','n','vulner',NULL,NULL,'[ˈwʊɫ.nʊs]','n-s---nn3-');
INSERT INTO latin_morpho VALUES (37268,'vulpes','n','vulp',NULL,NULL,'[ˈwʊɫ.peːs]','n-s---fn3i');
INSERT INTO latin_morpho VALUES (37269,'vultus','n','vult',NULL,NULL,'[ˈwʊɫ.tʊs]','n-s---mn4-');
INSERT INTO latin_morpho VALUES (37271,'vultuosus','a','vultuos vultuos vultuos',NULL,NULL,NULL,'aps---mn1-');
INSERT INTO latin_morpho VALUES (37272,'vultur','n','vultur',NULL,NULL,'[ˈwʊɫ.tʊr]','n-s---mn3-');
INSERT INTO latin_morpho VALUES (37273,'vulturius','n','vulturi',NULL,NULL,'[wʊɫˈtʊ.ri.ʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (37275,'vulva','n','vulv',NULL,'n-s---fn1-=volva','[ˈwʊɫ.wa]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37293,'xiphias','n','xiphi',NULL,NULL,'[ˈksɪ.pʰi.aːs]','n-s---mn1g');
INSERT INTO latin_morpho VALUES (37302,'zabulus','n','zabul',NULL,NULL,'[ˈzaː.bʊ.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (37305,'zelus','n','zel',NULL,NULL,'[ˈzeː.ɫʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (37309,'zelotypia','n','zelotypi',NULL,NULL,'[zeː.ɫɔˈtʏ.pi.a]','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37311,'Zephyrus','n','Zephyr',NULL,NULL,'[ˈzɛ.pʰʏ.rʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (37317,'zizania','n','zizani',NULL,NULL,'/ziːˈza.ni.a/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37328,'zodiacus','n','zodiac',NULL,NULL,'[zoːˈdi.a.kʊs]','n-s---mn2-');
INSERT INTO latin_morpho VALUES (37329,'zona','n','zon',NULL,NULL,'/ˈzoː.na/','n-s---fn1-');
INSERT INTO latin_morpho VALUES (37341,'deterius','r',NULL,NULL,NULL,NULL,'rc--------');
INSERT INTO latin_morpho VALUES (37356,'commemini','v','- commemin -',NULL,NULL,'[kɔmˈmɛ.mɪ.niː]','v1sria--3-');
INSERT INTO latin_morpho VALUES (37360,'deterior','a','deterior deterior deterior',NULL,NULL,'[deːˈtɛ.ri.ɔr]','aps---an3-');
INSERT INTO latin_morpho VALUES (37365,'odi','v','- od os',NULL,NULL,'/ˈoː.diː/','v1spia--3-');
INSERT INTO latin_morpho VALUES (37366,'Creta','n','Cret',NULL,NULL,NULL,'n-s---fn1-');
