# License

UUID-Forge is released under the MIT License.

## MIT License

Copyright (c) 2024 Darth Veitcher

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

## Third-Party Licenses

UUID-Forge depends on several third-party packages, each with their own licenses:

### Runtime Dependencies

- **Python Standard Library**: Python Software Foundation License
- **typing_extensions** (if Python < 3.11): Python Software Foundation License

### Development Dependencies

- **pytest**: MIT License
- **black**: MIT License
- **ruff**: MIT License
- **mypy**: MIT License
- **coverage**: Apache License 2.0
- **pre-commit**: MIT License
- **typer**: MIT License
- **rich**: MIT License

### Documentation Dependencies

- **mkdocs**: BSD License
- **mkdocs-material**: MIT License
- **mkdocstrings**: ISC License

## License Compatibility

The MIT License is:

- **Permissive**: Allows commercial and private use
- **Compatible**: Works with most other licenses
- **Simple**: Minimal restrictions and requirements
- **Popular**: Widely adopted in the Python ecosystem

## Using UUID-Forge in Your Project

You can freely use UUID-Forge in your projects, whether:

- **Open source**: Include the license in your project
- **Commercial**: No additional requirements beyond attribution
- **Private**: Use internally without restrictions
- **Modified**: Create derivative works with attribution

## Attribution Requirements

When using UUID-Forge, you must:

1. **Include the license**: Keep the MIT license text in your distribution
2. **Include copyright notice**: Maintain the copyright notice
3. **No trademark use**: Don't use UUID-Forge name without permission

## Warranty Disclaimer

UUID-Forge is provided "as is" without warranty of any kind. The authors are not liable for any damages arising from the use of this software.

## Contributing

By contributing to UUID-Forge, you agree that your contributions will be licensed under the same MIT License that covers the project.

For more information about contributing, see [Contributing Guide](../development/contributing.md).
