# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['src']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0',
 'lxml>=4.6.3,<5.0.0',
 'python-dotenv>=0.17.0,<0.18.0',
 'requests>=2.25.1,<3.0.0',
 'urllib3>=1.23']

entry_points = \
{'console_scripts': ['axs = src:arxiv_script.cli']}

setup_kwargs = {
    'name': 'arxiv-script',
    'version': '0.2.0',
    'description': 'Command line tool to handle arXiv articles and their BibTeX entries.',
    'long_description': "# arXiv-script v0.2\nThe [arXiv](www.arxiv.org) is the most important open-access repository for preprints in various sciences, e.g. Computer Science, Mathematics and Physics. Each preprint has its unique [arXiv identifier](https://arxiv.org/help/arxiv_identifier) (often called arXiv number). The _arXiv script_ (`axs`) is a minimal command line tool to interact with the preprint of an arXiv identifier:\n\n- `show` print its title, authors and abstract to the terminal.\n- `get` download the preprint and save it with a uniform file name.\n- `bib` create a BibTeX entry for the preprint (and optionally add it to a .bib-file) to easily cite the preprint in LaTeX documents.\n\n## example\nGiven the arXiv identifier `math/0211159`, let's see what we can do with it (after the installation which is explained below). Let's take a look at the preprint via\n```bash\naxs show math/0211159 \n```\nThis command prints the title, author(s), abstract and arXiv subject to the terminal. If we like the article, simply change `show` to `get` in the above command.\nThen the article is downloaded (to the default directory, see below) in the convenient formate `AUTHOR(S)-TITLE-YEAR.pdf`. In this example:\n```bash\nPerelman-The_entropy_formula_for_the_Ricci_flow_and_its_geometric_applications-2002.pdf\n```\nIf we decide to cite this preprint in some LaTeX document using BibTeX, simply modify the command to `axs bib math/0211159`.\nThis yields the following BibTeX-entry:\n```\n@article{Perelman-EntropyFormulaFor-math/0211159,\n\tAuthor = {Perelman, Grisha},\n\tTitle = {{The} entropy formula for the {Ricci} flow and its geometric applications},\n\tYear = {2002},\n\tNote = {\\href{https://arxiv.org/abs/math/0211159}{arXiv:math/0211159}}\n}\n```\nWe are then asked if we want to automatically add this entry to our (default) .bib-file enabling us to cite the preprint in LaTeX right away.\n\n## installation\nAt this stage, the _axs_ is still under development. Hence we require Python (=>3.6) and pip for its installation. It is also recommended to install it in a virtual environment. With these requirements in place, do the follwing:\n\n- Pull this repository to your preferred directory via `git` or simply download all files.\n- In the terminal, change to the directory where you downloaded this repository to. Then create a new virtual environment, e.g. with the name `venv`, and activate it:\n```bash\nvirtualenv venv\n. venv/bin/activate\n```\n- Finally, install the _arXiv script_ via\n```bash\npip install --editable .\n```\nThis also installs the required packages. We will soon release the _axs_ on _pypi_ making the installation easier. \n\n**NOTE:** In the following we will run all our commands in this virtual environment.\n\n## setup\nAfter installation it is recommended to set a default directory, which needs to exist already, where articles are downloaded to. This is done via\n```bash\naxs --set-directory PATH_TO_DIR\n```\nwhere PATH_TO_DIR is our chosen directory path. Alternatively, we can give a directory for each download, see below. To set a default .bib-file, where BibTeX-entries are added to, simply use\n```bash\naxs --set-bib-file PATH_TO_FILE\n```\nHere PATH_TO_FILE is our chosen default .bib-file where our BibTeX-entries will be added to. As before, we can alternatively choose a .bib-file for each BibTeX-entry individually, see below.\n\n## the commands in detail\nThe basic usage is the following\n```bash\naxs cmd flag ax_id  \n```\nwhere `cmd` one of the commands below, `flag` is an (optional) flag and `ax_id` is an arXiv identifier. In fact, you can combine several flags.\n\nThe flag `--help` provides help for each command. Note that `axs --help` gives quick general help.\n\n### `show`\nThis command prints the title, (some of) the authors, the abstract and the main arXiv subject of the corresponding arXiv preprint. The flag `-f` gives a full version, i.e. additionally all authors and the main arXiv subject.\n\n### `get`\nSimply downloads the article to your default directory (if it was already set as explained above) under the file name `AUTHOR(S)-TITLE-YEAR.pdf`. Two comments on the file name:\n\n+ For => 3 authors, we use the first author and append 'et al'.\n+ The title name is shortened to 15 words to prevent too long file names.\n\nBefore the download, the title and author(s) are printed to the terminal and there is a short countdown so that we can still cancel if we accidentally entered the wrong arXiv identifier.\n\nWith the flag `-d` (or `--directory`) we can download the article to another directory, i.e.\n```bash\naxs ax_id get -dir PATH_TO_DIR\n```\ndownloads the article to the directory at PATH_TO_DIR.\nThe flag `-o` (or `--open`) opens the preprint after the download.\n\n### `bib`\nPrints a BibTeX-entry of the article to the terminal and asks if it should be added to our default .bib-file (if it has been set before). Alternatively, use the flag `-a` (or `--add-to`) combined with the path to another .bib-file to which we want to add the BibTeX-entry. Note that at the moment, the BibTeX-entry is simply added to the end of the corresponding .bib-file, so it is _not_ (yet) sorted e.g. alphabetically.\n\nThree comments on the BibTeX-entry:\n+ The BibTeX-key, which is used to cite the preprint in a LaTeX document (`Perelman-EntropyFormulaFor-math/0211159` in our example above), is created is in the formate `AUTHOR(S)-SHORT_TITLE-AX_ID` where\n++ `AUTHOR(S)`: as for the file name but without white spaces.\n++ `SHORT_TITLE`: created from the title by removing all articles & most common prepositions and then taking the first three words. Finally, remove all white spaces.\n++ `AX_ID`: the arXiv identifier which is added to make the BibTeX-entry unique.\n+ The BibTeX-key is reasonably concise but contains enough information so that it can be easily found with the auto-completion for citations in any modern LaTeX editor.\n+ We only put curly braces around capital words to make it compatible with as many citation styles in LaTeX as possible (see for example [this discussion](https://tex.stackexchange.com/questions/10772/bibtex-loses-capitals-when-creating-bbl-file)).\n\n## planned features\nIn the future we plan to implement the following:\n+ Option to automatically download articles of different arXiv main subjects to different folders.\n+ Many arXiv preprints have already been published. Give an option to search for the BibTeX-entry of the published version (e.g. in [zbMATH](https://www.zbmath.org/) for Mathematics).\n+ More convenient installation without requiring an installed version of Python.\n+ 'Browsing' arXiv in the terminal?\n\n## background\nEven though there are great tools to manage scientific articles (e.g. Mendeley or Zotero), I realized - after using them for a while - that I saved way too many arXiv articles. Eventually, I manually downloaded only the important ones to one and the same directory. However, one problem, e.g. when trying to find an article, was that I did not stick to a systematic file name. So the idea for the arXiv script was born.\nSince I was not that satisfied with the available common BibTeX-entries of arXiv articles, I've automated them myself.\n\nAltogether I hope that this script is useful for others as well who prefer a minimalistic management of (arXiv) articles.\n\n## main changes from v0.1 to v0.2\n+ In v0.1 the syntax was quite unconventional (`axs AX_ID CMD` instead of `axs CMD AX_ID`).\n+ BUG FIX: The _axs_ now works 'anywhere' in the terminal not just in its directory. To do so, we now use use environment variables (via the dotenv package to make them last) to store the default directory and bib-file. Thanks @r-raymond! ",
    'author': 'Florian Beck',
    'author_email': 'flrn.beck@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/flrnbc/arxiv_script',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4',
}


setup(**setup_kwargs)
