from fideslib.oauth.scopes import (
    CONNECTION_AUTHORIZE,
    CONNECTION_CREATE_OR_UPDATE,
    CONNECTION_DELETE,
    CONNECTION_READ,
    DATASET_CREATE_OR_UPDATE,
    DATASET_DELETE,
    DATASET_READ,
    PRIVACY_REQUEST_CALLBACK_RESUME,
    PRIVACY_REQUEST_DELETE,
    PRIVACY_REQUEST_READ,
    PRIVACY_REQUEST_REVIEW,
    SAAS_CONFIG_CREATE_OR_UPDATE,
    SAAS_CONFIG_DELETE,
    SAAS_CONFIG_READ,
    USER_CREATE,
    USER_DELETE,
    USER_READ,
)

VIEW = "view"
MANAGE = "manage"

VIEW_SUBJECT_REQUESTS = f"{VIEW}_subject_requests"
MANAGE_SUBJECT_REQUESTS = f"{MANAGE}_subject_requests"

VIEW_CONNECTIONS = f"{VIEW}_datastore_connections"
MANAGE_CONNECTIONS = f"{MANAGE}_datastore_connections"

VIEW_USERS = f"{VIEW}_users"
MANAGE_USERS = f"{MANAGE}_users"


privileges = {
    VIEW_SUBJECT_REQUESTS: {PRIVACY_REQUEST_READ},
    MANAGE_SUBJECT_REQUESTS: {
        PRIVACY_REQUEST_CALLBACK_RESUME,
        PRIVACY_REQUEST_DELETE,
        PRIVACY_REQUEST_READ,
        PRIVACY_REQUEST_REVIEW,
    },
    VIEW_CONNECTIONS: {
        CONNECTION_READ,
        DATASET_READ,
        SAAS_CONFIG_READ,
    },
    MANAGE_CONNECTIONS: {
        CONNECTION_AUTHORIZE,
        CONNECTION_CREATE_OR_UPDATE,
        CONNECTION_DELETE,
        CONNECTION_READ,
        DATASET_CREATE_OR_UPDATE,
        DATASET_DELETE,
        DATASET_READ,
        SAAS_CONFIG_CREATE_OR_UPDATE,
        SAAS_CONFIG_DELETE,
        SAAS_CONFIG_READ,
    },
    VIEW_USERS: {USER_READ},
    MANAGE_USERS: {USER_CREATE, USER_DELETE, USER_READ},
}
