# Ibis: Expressive analytics in Python at any scale

|        Service | Status                                                                                                                                                                                                |
| -------------: | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  Documentation | [![Documentation Status](https://img.shields.io/badge/docs-docs.ibis--project.org-blue.svg)](http://ibis-project.org)                                                                                 |
| Conda packages | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/ibis-framework/badges/version.svg)](https://anaconda.org/conda-forge/ibis-framework)                                                       |
|           PyPI | [![PyPI](https://img.shields.io/pypi/v/ibis-framework.svg)](https://pypi.org/project/ibis-framework)                                                                                                  |
|        Ibis CI | [![Build status](https://github.com/ibis-project/ibis/actions/workflows/ibis-main.yml/badge.svg)](https://github.com/ibis-project/ibis/actions/workflows/ibis-main.yml?query=branch%3Amaster)         |
|     Backend CI | [![Build status](https://github.com/ibis-project/ibis/actions/workflows/ibis-backends.yml/badge.svg)](https://github.com/ibis-project/ibis/actions/workflows/ibis-backends.yml?query=branch%3Amaster) |
|       Coverage | [![Codecov branch](https://img.shields.io/codecov/c/github/ibis-project/ibis/master.svg)](https://codecov.io/gh/ibis-project/ibis)                                                                    |

Ibis is a Python library to help you write expressive analytics at any scale,
small to large. Its goal is to simplify analytical workflows and make you more
productive.

Install Ibis from PyPI with:

```sh
pip install ibis-framework
```

or from conda-forge with

```sh
conda install ibis-framework -c conda-forge
```

Ibis provides tools for interacting with the following systems:

- [Apache Impala](https://ibis-project.org/docs/latest/backends/Impala/)
- [Google BigQuery](https://github.com/ibis-project/ibis-bigquery)
- [ClickHouse](https://ibis-project.org/docs/latest/backends/ClickHouse/)
- [Dask](https://ibis-project.org/docs/latest/backends/Dask/)
- [DuckDB](https://ibis-project.org/docs/latest/backends/DuckDB/)
- [MySQL](https://ibis-project.org/docs/latest/backends/MySQL/)
- [Pandas](https://ibis-project.org/docs/latest/backends/Pandas/)
- [PostgreSQL](https://ibis-project.org/docs/latest/backends/PostgreSQL/)
- [PySpark](https://ibis-project.org/docs/latest/backends/PySpark/)
- [SQLite](https://ibis-project.org/docs/latest/backends/SQLite/)

Learn more about using the library at https://ibis-project.org.
