中文简体|[English](#)
<p align="center">
<a href="https://gitee.com/CV_Lab/opencv_webcam">
<img src="https://gitee.com/CV_Lab/opencv_webcam/attach_files/952125/download/opencv-webcam-script_logo.png" alt="Simple Icons" >
</a>
<p align="center">
    基于OpenCV的Webcam程序，适用于实时视频帧采集、计算机视觉数据收集等。
</p>
<p align="center">
    具有安装便捷、操作简单、跨平台等特点。
</p>
</p>
<p align="center">
<a href="https://gitee.com/CV_Lab/opencv_webcam/blob/master/codeCheck.md"><img src="https://img.shields.io/badge/CodeCheck-passing-success" alt="code check" /></a>
<a href="https://pypi.org/project/opencv-webcam-script/0.3.0/"><img src="https://img.shields.io/badge/PyPi-v0.3.0-brightgreen?logo=pypi" alt="PyPi" /></a>
<a href="https://gitee.com/CV_Lab/opencv_webcam/releases/v0.3"><img src="https://img.shields.io/badge/Releases-v0.3-green" alt="Releases Version" /></a>
<a href="https://hub.docker.com/r/zengdockerdocker/opencv-webcam-script"><img src="https://img.shields.io/badge/docker-v0.3-blue?logo=docker" alt="Docker" /></a>
<a href="https://gitee.com/CV_Lab/opencv_webcam/blob/master/tutorial.ipynb"><img src="https://img.shields.io/badge/Jupyter-v0.4-orange?logo=jupyter" alt="Jupyter" /></a>
<a href="https://gitee.com/CV_Lab/opencv_webcam/blob/master/LICENSE"><img src="https://img.shields.io/badge/License-GPL--3.0-blue" alt="License" /></a>
</p>
<h3 align="center">更新走势</h3>
<hr>

- `2022-01-24` **:zap: [opencv-webcam-script v0.4 Jupyter版](https://gitee.com/CV_Lab/opencv_webcam/blob/master/tutorial.ipynb)正式上线**
- :zap: [opencv-webcam-script v0.3](./v_change/v03_change.md)
- :zap: [opencv-webcam-script v0.2](./v_change/v02_change.md)
- :zap: [opencv-webcam-script v0.1](./v_change/v01_change.md)


<h3 align="center">项目结构</h3>
<hr>

```
.
├── opencv_webcam							# 项目名称
│   ├── utils								# 工具包
│   │   ├── args_yaml.py					# 指令管理
│   │   ├── compress.py						# 压缩管理
│   │   ├── frame_opt.py					# 帧保存管理
│   │   └── hotkey.py						# 热键管理
│   │   └── __init__.py						# 工具包初始化
│   │   └── log.py							# 日志管理
│   │   └── ows_path.py						# 保存路径管理
│   │   └── time_format.py					# 时间格式化
│   ├── v_change							# 版本变更
│   │   ├── v01_change.md					# v0.1版本变更
│   │   └── v02_change.md					# v0.2版本变更
│   ├── codeCheck.md						# 代码检查
│   ├── Dockerfile							# docker构建文件
│   ├── __init__.py							# 项目初始化
│   ├── LICENSE								# 项目许可
│   ├── opencv_webcam.py					# 脚本主运行文件
│   ├── README.md							# 项目说明
│   ├── requirements.txt					# pip组件
│   ├── tutorial.ipynb						# Jupyter版
│   └── v04.md								# v0.4记录
```

<h3 align="center">安装教程</h3>
<hr>

#### :white_check_mark: 方法一：Linux Shell安装（开发版）

- 第一步：克隆项目

```shell
git clone https://gitee.com/CV_Lab/opencv_webcam.git # 克隆项目
```

- 第二步：创建虚拟环境

```shell
# 创建conda虚拟环境，以python 3.8为例
conda create -n ows python==3.8 # 虚拟环境名称为ows
conda activate ows # 激活虚拟环境
```

- 第三步：安装脚本

```shell
pip install -r ./requirements.txt -U # 安装OpenCV Webcam脚本
```



#### :white_check_mark: 方法二：pip 快速安装（PyPi版）

- 第一步：创建ows虚拟环境，参见方法一
- 第二步：执行pip指令

```shell 
pip install opencv-webcam-script==0.3.0
```

- 第三步：编写python程序

```python
from opencv_webcam.opencv_webcam import webcam_opencv
# 例举两个功能
webcam_opencv() # 常规调用
webcam_opencv(is_autoSaveFrame=True) # 自动保存帧
webcam_opencv(is_autoSaveFrame=True, is_compress=True) # 压缩帧
```



#### :white_check_mark: 方法三：docker 镜像安装（容器版）

- 第一步：下载镜像

```shell
sudo docker pull zengdockerdocker/opencv-webcam-script:v0.3 # 镜像拉取
```

- 第二步：创建容器

```shell
xhost +local:root # 允许root用户访问正在运行的X服务器（重要）
sudo docker run --name=ows --ipc=host -it -v /tmp/.X11-unix:/tmp/.X11-unix -e DISPLAY=unix$DISPLAY --device=/dev/video0:/dev/video0 zengdockerdocker/opencv-webcam-script:v0.3 # 创建名称为ows的容器
```

- 第三步：运行程序

```shell
python3 opencv_webcam.py # 运行脚本程序
python3 opencv_webcam.py -isasf # 自动保存帧

# 获取docker帧数据到本机
sudo docker cp 容器名称:容器目录 本机宿主目录
sudo docker cp ows:/usr/src/app/WebcamFrame /home/用户名 # 举例
```

<h3 align="center">使用教程</h3>
<hr>

#### :bulb: 常规调用

```shell
# 默认按q键退出
python opencv_webcam.py
```



#### :bulb: 设备选择

```shell
# 多摄像头切换示例，默认为0
python opencv_webcam.py -dev 0
python opencv_webcam.py -dev 1
python opencv_webcam.py -dev 2
# RTSP
python opencv_webcam.py -dev rtsp://username:password@xxx.xxx.xxx
```



#### :bulb: 设置退出键

```shell
# 默认按q键退出
python opencv_webcam.py -q z # 设置z键退出
python opencv_webcam.py -q k # 设置k键退出
```



#### :bulb: 自动保存帧

```shell
python opencv_webcam.py -isasf
```



#### :bulb: 每隔n帧保存一次帧

```shell
# 每隔10帧保存一次帧
python opencv_webcam.py -isasf -fns 10
```



#### :bulb: 手动保存帧

```shell
# 默认按a键捕获一帧
python opencv_webcam.py -ishsf
```



#### :bulb: 自定义捕获键

```shell
# 设置z键为捕获键，默认为a键
python opencv_webcam.py -ishsf -fck z
```



#### :bulb: 重塑帧尺寸（自定义宽高）

```shell
# 重塑宽度300 高度200
python opencv_webcam.py -isasf -isrf -rf 300 200 # 自动版
python opencv_webcam.py -ishsf -isrf -rf 300 200 # 手动版
```



#### :bulb: 重塑帧尺寸（自定义宽高缩放比）

```shell
# 宽高缩放比为0.5
python opencv_webcam.py -isasf -isrf -rrf 0.5 # 自动版
python opencv_webcam.py -ishsf -isrf -rrf 0.5 # 手动版
```



#### :bulb: 自定义保存路径

```shell
# 设置保存路径，默认保存路径为./WebcamFrame
python opencv_webcam.py -fsd custom_dir -isasf # 以自动版为例
```



#### :bulb: 自定义帧目录名称

```shell
# 设置帧目录名称，默认保存路径为frames
python opencv_webcam.py -fdn frames_custom -isasf # 以自动版为例
```




#### :bulb: 自定义帧名前缀

```shell
# 设置帧图片的前缀名称
python opencv_webcam.py -isasf -fnp webcam
```



#### :bulb: 设置帧保存格式

```shell
# 设置JPG质量为100，默认为95
python opencv_webcam.py -isasf -fss jpg -jq 100
# 设置PNG质量为5，默认为3
python opencv_webcam.py -isasf -fss png -jq 5
```



#### :bulb: 设置暂停键

```shell
# 设置w键为暂停键，默认为p键
python opencv_webcam.py -p w # 按任意键继续
```



#### :bulb: 设置保存帧数

```shell
# 设置保存100帧
python opencv_webcam.py -isasf -afn 100
```



#### :bulb: 日志设置

```shell
# 日志文件默认保存在项目根目录，test.log
python opencv_webcam.py
# 设置日志文件名称及类型，类型包括.log、.txt、.data
python opencv_webcam.py -ln test02.txt
# 设置日志保存方式，，默认为追加模式
python opencv_webcam.py -lm w # 设置为覆盖模式
```

 

#### :bulb: 视频帧压缩

```shell
# 常规压缩，默认test.zip（以自动版为例）
python opencv_webcam.py -isasf -isc
# 自定义压缩文件名称
python opencv_webcam.py -isasf -isc -cn test02
# 自动命名压缩文件
python opencv_webcam.py -isasf -isc -isacn
# 自定义压缩模式，默认为写覆盖
python opencv_webcam.py -isasf -isc -cm a # 追加模式(a模式仅限zip)
python opencv_webcam.py -isasf -isc -cs tar -cm w:gz # tar压缩
```



#### :bulb: 指令查询

```shell
# 查询脚本参数
python opencv_webcam.py --help
```

<details open>
<summary>指令查询结果</summary>

```shell
usage: opencv_webcam.py [-h] [--device DEVICE] [--quit QUIT] [--is_autoSaveFrame] [--is_handSaveFrame] [--is_resizeFrame] [--frame_saveDir FRAME_SAVEDIR] [--frame_dirName FRAME_DIRNAME]
                        [--frame_nSave FRAME_NSAVE] [--frame_capKey FRAME_CAPKEY] [--resize_frame RESIZE_FRAME [RESIZE_FRAME ...]] [--resizeRatio_frame RESIZERATIO_FRAME]
                        [--frame_namePrefix FRAME_NAMEPREFIX] [--frame_saveStyle FRAME_SAVESTYLE] [--jpg_quality JPG_QUALITY] [--png_quality PNG_QUALITY] [--pause PAUSE]
                        [--auto_frameNum AUTO_FRAMENUM] [--logName LOGNAME] [--logMode LOGMODE] [--is_compress] [--compressStyle COMPRESSSTYLE] [--is_autoCompressName]
                        [--compressName COMPRESSNAME] [--compressMode COMPRESSMODE]

OpenCV Webcam Script v0.4

optional arguments:
  -h, --help            show this help message and exit
  --device DEVICE, -dev DEVICE
                        device index for webcam, 0 or rtsp
  --quit QUIT, -q QUIT  quit key for webcam
  --is_autoSaveFrame, -isasf
                        is auto save frame
  --is_handSaveFrame, -ishsf
                        is hand save frame
  --is_resizeFrame, -isrf
                        is resize frame
  --frame_saveDir FRAME_SAVEDIR, -fsd FRAME_SAVEDIR
                        save frame dir
  --frame_dirName FRAME_DIRNAME, -fdn FRAME_DIRNAME
                        save frame dir name
  --frame_nSave FRAME_NSAVE, -fns FRAME_NSAVE
                        n frames save a frame (auto save frame)
  --frame_capKey FRAME_CAPKEY, -fck FRAME_CAPKEY
                        frame capture key (hand save frame)
  --resize_frame RESIZE_FRAME [RESIZE_FRAME ...], -rf RESIZE_FRAME [RESIZE_FRAME ...]
                        resize frame save
  --resizeRatio_frame RESIZERATIO_FRAME, -rrf RESIZERATIO_FRAME
                        resize ratio frame save
  --frame_namePrefix FRAME_NAMEPREFIX, -fnp FRAME_NAMEPREFIX
                        frame name prefix
  --frame_saveStyle FRAME_SAVESTYLE, -fss FRAME_SAVESTYLE
                        frame save style
  --jpg_quality JPG_QUALITY, -jq JPG_QUALITY
                        frame save jpg quality (0-100) default 95
  --png_quality PNG_QUALITY, -pq PNG_QUALITY
                        frame save jpg quality (0-9) default 3
  --pause PAUSE, -p PAUSE
                        webcam pause
  --auto_frameNum AUTO_FRAMENUM, -afn AUTO_FRAMENUM
                        auto save number of frames
  --logName LOGNAME, -ln LOGNAME
                        log save name
  --logMode LOGMODE, -lm LOGMODE
                        log write mode
  --is_compress, -isc   is compress file
  --compressStyle COMPRESSSTYLE, -cs COMPRESSSTYLE
                        compress style
  --is_autoCompressName, -isacn
                        is auto compress name
  --compressName COMPRESSNAME, -cn COMPRESSNAME
                        compress save name
  --compressMode COMPRESSMODE, -cm COMPRESSMODE
                        compress save mode, tar w:gz
```

</details>
