from typing import List

from com.inductiveautomation.ignition.common.functional import FragileRunnable
from java.lang import Object, String
from java.util import Locale
from java.util.function import Consumer

class MessageInterface:
    def addMessageReceiver(self, protocol, rcv) -> None: ...
    def sendCall(self, protocol, scope, msg) -> None: ...
    def sendMessage(self, protocol, scope, msg) -> None: ...

class MessageReceiver:
    def receiveCall(self, msg) -> None: ...

class UIResponse(Object):
    errors: List[String]
    infos: List[String]
    locale: Locale
    warns: List[String]
    def __init__(self, locale: Locale) -> None: ...
    def attempt(self, method: FragileRunnable) -> None: ...
    def error(self, message: String, *args: Object) -> None: ...
    def getErrors(self) -> List[String]: ...
    def getInfos(self) -> List[String]: ...
    def getLocale(self) -> Locale: ...
    def getWarns(self) -> List[String]: ...
    def info(self, message: String, *args: Object) -> None: ...
    def warn(self, message: String, *args: Object) -> None: ...
    @staticmethod
    def wrap(locale: Locale, fx: Consumer) -> UIResponse: ...
