from typing import Any, Iterable, Optional, Union

from java.lang import Object
from java.lang import String as String

class JsonElement:
    def deepCopy(self) -> JsonElement: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsJsonArray(self) -> JsonArray: ...
    def getAsJsonObject(self) -> JsonObject: ...
    def getAsJsonPrimitive(self) -> JsonPrimitive: ...
    def getAsJsonNull(self) -> JsonNull: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Union[float, int, long]: ...
    def getAsShort(self) -> int: ...
    def isJsonArray(self) -> bool: ...
    def isJsonObject(self) -> bool: ...
    def isJsonPrimitive(self) -> bool: ...
    def isJsonNull(self) -> bool: ...

class JsonArray(JsonElement):
    def __init__(self, capacity: Optional[int] = ...) -> None: ...
    def add(self, arg: Any) -> None: ...
    def addAll(self, array: JsonArray) -> None: ...
    def contains(self, element: JsonElement) -> bool: ...
    def get(self, i: int) -> JsonElement: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Union[float, int, long]: ...
    def getAsShort(self) -> int: ...
    def iterator(self) -> Iterable[JsonElement]: ...
    def remove(self, index: int) -> JsonElement: ...
    def size(self) -> int: ...

class JsonNull(JsonElement):
    def equals(self, other: Object) -> bool: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Union[float, int, long]: ...
    def getAsShort(self) -> int: ...
    def hashCode(self) -> int: ...

class JsonObject(JsonElement):
    def add(self, property: String, value: JsonElement) -> None: ...
    def addProperty(self, property: String, value: Any) -> None: ...
    def createJsonElement(self, value: Object) -> JsonElement: ...
    def get(self, memberName: String) -> JsonElement: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Union[float, int, long]: ...
    def getAsShort(self) -> int: ...
    def has(self, memberName: String) -> bool: ...
    def remove(self, property: String) -> JsonElement: ...
    def size(self) -> int: ...

class JsonPrimitive(JsonElement):
    def __init__(self, arg: Any) -> None: ...
    def equals(self, other: Object) -> bool: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Union[float, int, long]: ...
    def getAsShort(self) -> int: ...
    def hashCode(self) -> int: ...
    def isBoolean(self) -> bool: ...
    @staticmethod
    def isPrimitiveOrString(target: Object) -> bool: ...
    @staticmethod
    def isIntegral(primitive: JsonPrimitive) -> bool: ...
    def isString(self) -> bool: ...
