![pybind11 logo](https://github.com/pybind/pybind11/raw/master/docs/pybind11-logo.png)

# pybind11 — Seamless operability between C++11 and Python

[![Documentation Status](https://readthedocs.org/projects/pybind11/badge/?version=master)](http://pybind11.readthedocs.org/en/master/?badge=master)
[![Documentation Status](https://readthedocs.org/projects/pybind11/badge/?version=stable)](http://pybind11.readthedocs.org/en/stable/?badge=stable)
[![Gitter chat](https://img.shields.io/gitter/room/gitterHQ/gitter.svg)](https://gitter.im/pybind/Lobby)
[![CI](https://github.com/pybind/pybind11/workflows/CI/badge.svg)](https://github.com/pybind/pybind11/actions)
[![Build status](https://ci.appveyor.com/api/projects/status/riaj54pn4h08xy40?svg=true)](https://ci.appveyor.com/project/wjakob/pybind11)

**pybind11** is a lightweight header-only library that exposes C++ types in
Python and vice versa, mainly to create Python bindings of existing C++ code.
Its goals and syntax are similar to the excellent [Boost.Python][] library by
David Abrahams: to minimize boilerplate code in traditional extension modules
by inferring type information using compile-time introspection.

The main issue with Boost.Python—and the reason for creating such a similar
project—is Boost. Boost is an enormously large and complex suite of utility
libraries that works with almost every C++ compiler in existence. This
compatibility has its cost: arcane template tricks and workarounds are
necessary to support the oldest and buggiest of compiler specimens. Now that
C++11-compatible compilers are widely available, this heavy machinery has
become an excessively large and unnecessary dependency.

Think of this library as a tiny self-contained version of Boost.Python with
everything stripped away that isn't relevant for binding generation. Without
comments, the core header files only require ~4K lines of code and depend on
Python (2.7 or 3.5+, or PyPy) and the C++ standard library. This compact
implementation was possible thanks to some of the new C++11 language features
(specifically: tuples, lambda functions and variadic templates). Since its
creation, this library has grown beyond Boost.Python in many ways, leading to
dramatically simpler binding code in many common situations.

Tutorial and reference documentation is provided at
[pybind11.readthedocs.org][].  A PDF version of the manual is available
[here][docs-pdf].

## Core features
pybind11 can map the following core C++ features to Python:

- Functions accepting and returning custom data structures per value, reference, or pointer
- Instance methods and static methods
- Overloaded functions
- Instance attributes and static attributes
- Arbitrary exception types
- Enumerations
- Callbacks
- Iterators and ranges
- Custom operators
- Single and multiple inheritance
- STL data structures
- Smart pointers with reference counting like `std::shared_ptr`
- Internal references with correct reference counting
- C++ classes with virtual (and pure virtual) methods can be extended in Python

## Goodies
In addition to the core functionality, pybind11 provides some extra goodies:

- Python 2.7, 3.5+, and PyPy (tested on 7.3) are supported with an implementation-agnostic
  interface.

- It is possible to bind C++11 lambda functions with captured variables. The
  lambda capture data is stored inside the resulting Python function object.

- pybind11 uses C++11 move constructors and move assignment operators whenever
  possible to efficiently transfer custom data types.

- It's easy to expose the internal storage of custom data types through
  Pythons' buffer protocols. This is handy e.g. for fast conversion between
  C++ matrix classes like Eigen and NumPy without expensive copy operations.

- pybind11 can automatically vectorize functions so that they are transparently
  applied to all entries of one or more NumPy array arguments.

- Python's slice-based access and assignment operations can be supported with
  just a few lines of code.

- Everything is contained in just a few header files; there is no need to link
  against any additional libraries.

- Binaries are generally smaller by a factor of at least 2 compared to
  equivalent bindings generated by Boost.Python. A recent pybind11 conversion
  of PyRosetta, an enormous Boost.Python binding project,
  [reported][pyrosetta-report] a binary size reduction of **5.4x** and compile
  time reduction by **5.8x**.

- Function signatures are precomputed at compile time (using `constexpr`),
  leading to smaller binaries.

- With little extra effort, C++ types can be pickled and unpickled similar to
  regular Python objects.

## Supported compilers

1. Clang/LLVM 3.3 or newer (for Apple Xcode's clang, this is 5.0.0 or newer)
2. GCC 4.8 or newer
3. Microsoft Visual Studio 2015 Update 3 or newer
4. Intel C++ compiler 17 or newer (16 with pybind11 v2.0 and 15 with pybind11
   v2.0 and a [workaround][intel-15-workaround])
5. Cygwin/GCC (tested on 2.5.1)
6. NVCC (CUDA 11 tested)
7. NVIDIA PGI (20.7 tested)

## About

This project was created by [Wenzel Jakob](http://rgl.epfl.ch/people/wjakob).
Significant features and/or improvements to the code were contributed by
Jonas Adler,
Lori A. Burns,
Sylvain Corlay,
Trent Houliston,
Axel Huebl,
@hulucc,
Sergey Lyskov
Johan Mabille,
Tomasz Miąsko,
Dean Moldovan,
Ben Pritchard,
Jason Rhinelander,
Boris Schäling,
Pim Schellart,
Henry Schreiner,
Ivan Smirnov, and
Patrick Stewart.

### Contributing

See the [contributing guide][] for information on building and contributing to
pybind11.


### License

pybind11 is provided under a BSD-style license that can be found in the
[`LICENSE`][] file. By using, distributing, or contributing to this project,
you agree to the terms and conditions of this license.


[pybind11.readthedocs.org]: http://pybind11.readthedocs.org/en/master
[docs-pdf]: https://media.readthedocs.org/pdf/pybind11/master/pybind11.pdf
[Boost.Python]: http://www.boost.org/doc/libs/1_58_0/libs/python/doc/
[pyrosetta-report]: http://graylab.jhu.edu/RosettaCon2016/PyRosetta-4.pdf
[contributing guide]:  https://github.com/pybind/pybind11/blob/master/.github/CONTRIBUTING.md
[`LICENSE`]: https://github.com/pybind/pybind11/blob/master/LICENSE
[intel-15-workaround]: https://github.com/pybind/pybind11/issues/276
