/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x1000004a generated on 2018-07-20 15:25:52.167515
/// Generated using solver transform6d
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==0x1000004a);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

//// START
#include "python2.7/Python.h"
//// END

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif


inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2Simple(float fy, float fx) {
    return atan2f(fy,fx);
}
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2Simple(double fy, double fx) {
    return atan2(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

template <typename T>
struct CheckValue
{
    T value;
    bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
    CheckValue<T> ret;
    ret.valid = false;
    ret.value = 0;
    if( !isnan(fy) && !isnan(fx) ) {
        if( IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH ) {
            ret.value = IKatan2Simple(fy,fx);
            ret.valid = true;
        }
    }
    return ret;
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
    CheckValue<T> ret;
    ret.valid = true;
    if( n == 0 ) {
        ret.value = 1.0;
        return ret;
    }
    else if( n == 1 )
    {
        ret.value = f;
        return ret;
    }
    else if( n < 0 )
    {
        if( f == 0 )
        {
            ret.valid = false;
            ret.value = (T)1.0e30;
            return ret;
        }
        if( n == -1 ) {
            ret.value = T(1.0)/f;
            return ret;
        }
    }

    int num = n > 0 ? n : -n;
    if( num == 2 ) {
        ret.value = f*f;
    }
    else if( num == 3 ) {
        ret.value = f*f*f;
    }
    else {
        ret.value = 1.0;
        while(num>0) {
            if( num & 1 ) {
                ret.value *= f;
            }
            num >>= 1;
            f *= f;
        }
    }
    
    if( n < 0 ) {
        ret.value = T(1.0)/ret.value;
    }
    return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x36,x37,x38,x39,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x54,x55,x56,x57,x58,x59,x60,x61,x62,x63,x64,x65,x66;
x0=IKcos(j[1]);
x1=IKcos(j[4]);
x2=IKcos(j[2]);
x3=IKsin(j[4]);
x4=IKsin(j[2]);
x5=IKsin(j[3]);
x6=IKcos(j[3]);
x7=IKsin(j[1]);
x8=IKcos(j[5]);
x9=IKsin(j[5]);
x10=IKsin(j[6]);
x11=IKcos(j[6]);
x12=IKsin(j[7]);
x13=IKcos(j[7]);
x14=((1.0)*x1);
x15=((1.0)*x3);
x16=((0.18)*x8);
x17=((1.0)*x6);
x18=((0.321)*x5);
x19=((1.0)*x8);
x20=((0.18)*x9);
x21=((0.18)*x3);
x22=((0.18)*x1);
x23=((0.321)*x1);
x24=((1.0)*x9);
x25=((1.0)*x10);
x26=((0.321)*x6);
x27=((1.0)*x11);
x28=(x2*x7);
x29=((-1.0)*x3);
x30=(x0*x4);
x31=(x2*x5);
x32=((-1.0)*x10);
x33=(x0*x2);
x34=((-1.0)*x1);
x36=((-1.0)*x11);
x37=(x5*x7);
x38=(x2*x6);
x39=(x4*x7);
x41=(x15*x33);
x42=(x14*x38);
x43=(((x30*x5))+(((-1.0)*x17*x7)));
x44=(((x0*x5))+(((-1.0)*x17*x39)));
x45=(((x0*x6))+((x37*x4)));
x46=((((-1.0)*x42))+((x3*x4)));
x47=(x42+(((-1.0)*x15*x4)));
x48=((((-1.0)*x37))+(((-1.0)*x17*x30)));
x49=(x43*x9);
x50=(((x14*x4))+((x15*x38)));
x51=(x45*x9);
x52=(x45*x8);
x54=(x47*x9);
x55=(x1*x48);
x56=(((x31*x9))+((x46*x8)));
x57=((((-1.0)*x14*x44))+((x15*x28)));
x58=(((x28*x29))+((x1*x44)));
x59=(((x29*x33))+x55);
x60=(x58*x8);
x61=(x57*x9);
x62=(x59*x8);
x63=(x51+x60);
x64=(x49+x62);
x65=((((-1.0)*x27*x56))+(((-1.0)*x25*x50)));
x66=(((x36*x63))+((x32*((((x29*x44))+((x28*x34)))))));
eerot[0]=(((x11*((((x3*x48))+((x1*x33))))))+((x10*((x49+((x8*(((((-1.0)*x41))+x55)))))))));
eerot[1]=(((x13*((((x9*((((x34*x48))+x41))))+((x43*x8))))))+(((-1.0)*x12*((((x27*x64))+((x25*(((((-1.0)*x15*x48))+(((-1.0)*x14*x33)))))))))));
eerot[2]=(((x13*((((x36*x64))+((x32*((((x29*x48))+((x33*x34))))))))))+(((-1.0)*x12*((((x24*(((((-1.0)*x14*x48))+x41))))+((x19*x43)))))));
eetrans[0]=((-0.05)+((x10*((((x20*x43))+((x16*x59))))))+((x23*x33))+(((0.1)*x0))+((x3*(((((-1.0)*x18*x7))+(((-1.0)*x26*x30))))))+(((0.4)*x33))+((x11*((((x22*x33))+((x21*x48)))))));
eerot[3]=(((x11*((((x1*x28))+((x3*x44))))))+((x10*x63)));
eerot[4]=(((x12*x66))+((x13*((x52+x61)))));
eerot[5]=(((x12*(((((-1.0)*x19*x45))+(((-1.0)*x24*x57))))))+((x13*x66)));
eetrans[1]=((0.188)+(((0.1)*x7))+((x10*((((x20*x45))+((x16*x58))))))+((x23*x28))+(((0.4)*x28))+((x11*((((x22*x28))+((x21*x44))))))+((x3*((((x0*x18))+(((-1.0)*x26*x39)))))));
eerot[6]=((((-1.0)*x11*x50))+((x10*x56)));
eerot[7]=(((x13*((((x31*x8))+x54))))+((x12*x65)));
eerot[8]=(((x13*x65))+((x12*(((((-1.0)*x24*x47))+(((-1.0)*x19*x31)))))));
IkReal x67=((1.0)*x4);
eetrans[2]=((0.739675)+((x11*(((((-1.0)*x21*x38))+(((-1.0)*x22*x67))))))+((x10*((((x20*x31))+((x16*x46))))))+(((-1.0)*x2*x26*x3))+(((-1.0)*x23*x67))+(((-0.4)*x4))+j[0]);
}

IKFAST_API int GetNumFreeParameters() { return 2; }
IKFAST_API int* GetFreeParameters() { static int freeparams[] = {0, 3}; return freeparams; }
IKFAST_API int GetNumJoints() { return 8; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j15,cj15,sj15,htj15,j15mul,j16,cj16,sj16,htj16,j16mul,j18,cj18,sj18,htj18,j18mul,j19,cj19,sj19,htj19,j19mul,j20,cj20,sj20,htj20,j20mul,j21,cj21,sj21,htj21,j21mul,j12,cj12,sj12,htj12,j17,cj17,sj17,htj17,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij15[2], _nj15,_ij16[2], _nj16,_ij18[2], _nj18,_ij19[2], _nj19,_ij20[2], _nj20,_ij21[2], _nj21,_ij12[2], _nj12,_ij17[2], _nj17;

IkReal j100, cj100, sj100;
unsigned char _ij100[2], _nj100;
bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j15=numeric_limits<IkReal>::quiet_NaN(); _ij15[0] = -1; _ij15[1] = -1; _nj15 = -1; j16=numeric_limits<IkReal>::quiet_NaN(); _ij16[0] = -1; _ij16[1] = -1; _nj16 = -1; j18=numeric_limits<IkReal>::quiet_NaN(); _ij18[0] = -1; _ij18[1] = -1; _nj18 = -1; j19=numeric_limits<IkReal>::quiet_NaN(); _ij19[0] = -1; _ij19[1] = -1; _nj19 = -1; j20=numeric_limits<IkReal>::quiet_NaN(); _ij20[0] = -1; _ij20[1] = -1; _nj20 = -1; j21=numeric_limits<IkReal>::quiet_NaN(); _ij21[0] = -1; _ij21[1] = -1; _nj21 = -1;  _ij12[0] = -1; _ij12[1] = -1; _nj12 = 0;  _ij17[0] = -1; _ij17[1] = -1; _nj17 = 0; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
j12=pfree[0]; cj12=cos(pfree[0]); sj12=sin(pfree[0]), htj12=tan(pfree[0]*0.5);
j17=pfree[1]; cj17=cos(pfree[1]); sj17=sin(pfree[1]), htj17=tan(pfree[1]*0.5);
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=((-1.0)*r02);
new_r01=r01;
new_r02=r00;
new_px=((0.05)+(((-0.18)*r00))+px);
new_r10=((-1.0)*r12);
new_r11=r11;
new_r12=r10;
new_py=((-0.188)+(((-0.18)*r10))+py);
new_r20=((-1.0)*r22);
new_r21=r21;
new_r22=r20;
new_pz=((-0.739675)+(((-1.0)*j12))+pz+(((-0.18)*r20)));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
IkReal x68=((1.0)*px);
IkReal x69=((1.0)*pz);
IkReal x70=((1.0)*py);
pp=((px*px)+(py*py)+(pz*pz));
npx=(((px*r00))+((py*r10))+((pz*r20)));
npy=(((px*r01))+((py*r11))+((pz*r21)));
npz=(((px*r02))+((py*r12))+((pz*r22)));
rxp0_0=((((-1.0)*r20*x70))+((pz*r10)));
rxp0_1=(((px*r20))+(((-1.0)*r00*x69)));
rxp0_2=((((-1.0)*r10*x68))+((py*r00)));
rxp1_0=((((-1.0)*r21*x70))+((pz*r11)));
rxp1_1=(((px*r21))+(((-1.0)*r01*x69)));
rxp1_2=((((-1.0)*r11*x68))+((py*r01)));
rxp2_0=((((-1.0)*r22*x70))+((pz*r12)));
rxp2_1=(((px*r22))+(((-1.0)*r02*x69)));
rxp2_2=((((-1.0)*r12*x68))+((py*r02)));
IkReal op[8+1], zeror[8];
int numroots;
IkReal x71=((0.2)*px);
IkReal x72=((1.0)*pp);
IkReal x73=((0.509841)+(((-1.0)*x72))+x71);
IkReal x74=((-0.003759)+(((-1.0)*x72))+x71);
IkReal x75=(x72+x71);
IkReal x76=((0.509841)+(((-1.0)*x75)));
IkReal x77=((-0.003759)+(((-1.0)*x75)));
IkReal gconst0=x73;
IkReal gconst1=x74;
IkReal gconst2=x73;
IkReal gconst3=x74;
IkReal gconst4=x76;
IkReal gconst5=x77;
IkReal gconst6=x76;
IkReal gconst7=x77;
IkReal x78=py*py;
IkReal x79=sj17*sj17;
IkReal x80=px*px;
IkReal x81=((1.0)*gconst4);
IkReal x82=(gconst5*py);
IkReal x83=((4.0)*px);
IkReal x84=(gconst0*gconst3);
IkReal x85=(gconst1*gconst2);
IkReal x86=((2.0)*gconst5);
IkReal x87=((1.0)*gconst0);
IkReal x88=(gconst1*gconst7);
IkReal x89=(gconst0*gconst6);
IkReal x90=(gconst1*gconst3);
IkReal x91=(gconst4*gconst7);
IkReal x92=(gconst6*py);
IkReal x93=((2.0)*gconst0);
IkReal x94=(gconst0*gconst7);
IkReal x95=((2.0)*gconst4);
IkReal x96=(gconst3*gconst5);
IkReal x97=(gconst2*gconst5);
IkReal x98=(gconst3*gconst4);
IkReal x99=(gconst5*gconst6);
IkReal x100=(gconst2*gconst4);
IkReal x101=(gconst1*gconst6);
IkReal x102=(px*py);
IkReal x103=(gconst1*py);
IkReal x104=(gconst2*py);
IkReal x105=(gconst5*gconst7);
IkReal x106=((1.05513984)*x102);
IkReal x107=(gconst6*x78);
IkReal x108=((0.3297312)*x79);
IkReal x109=((4.0)*x80);
IkReal x110=(gconst2*x78);
IkReal x111=((2.0)*x78);
IkReal x112=((1.0)*x78);
IkReal x113=((0.824328)*x79);
IkReal x114=((0.412164)*x79);
IkReal x115=((0.1648656)*x79);
IkReal x116=(x78*x91);
IkReal x117=(x78*x99);
IkReal x118=(x78*x97);
IkReal x119=(x78*x98);
IkReal x120=(x78*x94);
IkReal x121=(x101*x78);
IkReal x122=((0.0834355125792)*py*x79);
IkReal x123=(x78*x85);
IkReal x124=(x78*x84);
IkReal x125=(x78*x79);
IkReal x126=(x114*x99);
IkReal x127=(x105*x112);
IkReal x128=(x107*x81);
IkReal x129=(py*x100*x83);
IkReal x130=(py*x83*x88);
IkReal x131=(gconst3*x82*x83);
IkReal x132=(py*x83*x89);
IkReal x133=(py*x83*x98);
IkReal x134=(py*x83*x94);
IkReal x135=(gconst2*x82*x83);
IkReal x136=(gconst1*x83*x92);
IkReal x137=(x112*x88);
IkReal x138=(x110*x81);
IkReal x139=(x101*x114);
IkReal x140=((0.06594624)*x125);
IkReal x141=(x107*x87);
IkReal x142=(x114*x97);
IkReal x143=(x112*x96);
IkReal x144=(pp*py*x108);
IkReal x145=((0.06594624)*x102*x79);
IkReal x146=(x110*x87);
IkReal x147=(x112*x90);
IkReal x148=(x114*x85);
IkReal x149=(x124+x123);
IkReal x150=(x117+x116);
IkReal x151=(x126+x127+x128);
IkReal x152=(x146+x147+x148);
IkReal x153=(x120+x121+x119+x118);
IkReal x154=(x135+x134+x136+x133);
IkReal x155=(x131+x130+x132+x129);
IkReal x156=(x140+x141+x142+x143+x137+x139+x138);
op[0]=((((-1.0)*x151))+x150);
op[1]=((((-1.0)*x106))+(((-1.0)*x122))+x144+x145);
op[2]=((((-1.0)*x156))+((gconst7*x78*x86))+((x107*x95))+(((-1.0)*x113*x99))+(((-1.0)*gconst4*gconst6*x109))+x153+(((-1.0)*x111*x91))+((x109*x99))+((x109*x91))+(((-1.0)*x105*x109))+(((-1.0)*x107*x86)));
op[3]=((((-1.0)*x155))+(((-1.0)*gconst6*x82*x83))+(((-1.0)*py*x83*x91))+((gconst4*x83*x92))+x154+(((-1.0)*x108*x82))+(((-1.0)*x108*x92))+((gconst7*x82*x83))+(((-1.0)*x103*x115))+(((-1.0)*x104*x115)));
op[4]=((((-0.13189248)*x125))+(((-1.0)*x151))+(((-1.0)*x152))+(((-1.0)*x101*x113))+(((-1.0)*x101*x111))+(((-1.0)*x100*x109))+(((-1.0)*x113*x97))+(((-1.0)*gconst3*x78*x95))+x150+x149+((gconst3*x78*x86))+(((-1.0)*x110*x86))+((x111*x88))+((x111*x89))+((x109*x98))+((x109*x94))+((x109*x97))+(((-1.0)*gconst7*x78*x93))+(((-1.0)*x109*x96))+(((-1.0)*x109*x88))+(((-1.0)*x109*x89))+((x101*x109))+((x110*x95)));
op[5]=((((-1.0)*x104*x108))+(((-1.0)*x115*x82))+(((-1.0)*x154))+(((-1.0)*x115*x92))+(((-1.0)*py*x83*x90))+x155+((py*x83*x85))+((py*x83*x84))+(((-1.0)*x103*x108))+(((-1.0)*gconst0*x104*x83)));
op[6]=((((-1.0)*x156))+(((-1.0)*x113*x85))+(((-1.0)*x111*x84))+(((-1.0)*x111*x85))+x153+(((-1.0)*gconst0*gconst2*x109))+((x111*x90))+((x109*x84))+((x109*x85))+(((-1.0)*x109*x90))+((x110*x93)));
op[7]=((((-1.0)*x145))+(((-1.0)*x122))+x144+x106);
op[8]=((((-1.0)*x152))+x149);
polyroots8(op,zeror,numroots);
IkReal j15array[8], cj15array[8], sj15array[8], tempj15array[1];
int numsolutions = 0;
for(int ij15 = 0; ij15 < numroots; ++ij15)
{
IkReal htj15 = zeror[ij15];
tempj15array[0]=((2.0)*(atan(htj15)));
for(int kj15 = 0; kj15 < 1; ++kj15)
{
j15array[numsolutions] = tempj15array[kj15];
if( j15array[numsolutions] > IKPI )
{
    j15array[numsolutions]-=IK2PI;
}
else if( j15array[numsolutions] < -IKPI )
{
    j15array[numsolutions]+=IK2PI;
}
sj15array[numsolutions] = IKsin(j15array[numsolutions]);
cj15array[numsolutions] = IKcos(j15array[numsolutions]);
numsolutions++;
}
}
bool j15valid[8]={true,true,true,true,true,true,true,true};
_nj15 = 8;
for(int ij15 = 0; ij15 < numsolutions; ++ij15)
    {
if( !j15valid[ij15] )
{
    continue;
}
    j15 = j15array[ij15]; cj15 = cj15array[ij15]; sj15 = sj15array[ij15];
htj15 = IKtan(j15/2);

_ij15[0] = ij15; _ij15[1] = -1;
for(int iij15 = ij15+1; iij15 < numsolutions; ++iij15)
{
if( j15valid[iij15] && IKabs(cj15array[ij15]-cj15array[iij15]) < IKFAST_SOLUTION_THRESH && IKabs(sj15array[ij15]-sj15array[iij15]) < IKFAST_SOLUTION_THRESH )
{
    j15valid[iij15]=false; _ij15[1] = iij15; break; 
}
}
{
IkReal j16eval[2];
IkReal x157=py*py;
IkReal x158=cj15*cj15;
IkReal x159=px*px;
IkReal x160=pz*pz;
IkReal x161=((4.0)*sj17);
IkReal x162=((20.0)*sj17);
IkReal x163=(py*sj15);
IkReal x164=(cj15*px);
IkReal x165=((100.0)*sj17);
IkReal x166=((0.8)*sj17);
IkReal x167=(x157*x158);
IkReal x168=(x158*x159);
j16eval[0]=((((-1.0)*x157*x165))+(((-200.0)*sj17*x163*x164))+(((-1.0)*x160*x165))+((x162*x163))+((x162*x164))+(((-1.0)*sj17))+((x165*x167))+(((-1.0)*x165*x168)));
j16eval[1]=IKsign(((((-1.0)*x157*x161))+((x161*x167))+(((-1.0)*x160*x161))+(((-1.0)*x161*x168))+((x164*x166))+(((-8.0)*sj17*x163*x164))+((x163*x166))+(((-0.04)*sj17))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  )
{
{
IkReal j18eval[1];
j18eval[0]=sj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j17))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[2], cj18array[2], sj18array[2];
bool j18valid[2]={false};
_nj18 = 2;
cj18array[0]=((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15)));
if( cj18array[0] >= -1-IKFAST_SINCOS_THRESH && cj18array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j18valid[0] = j18valid[1] = true;
    j18array[0] = IKacos(cj18array[0]);
    sj18array[0] = IKsin(j18array[0]);
    cj18array[1] = cj18array[0];
    j18array[1] = -j18array[0];
    sj18array[1] = -sj18array[0];
}
else if( isnan(cj18array[0]) )
{
    // probably any value will work
    j18valid[0] = true;
    cj18array[0] = 1; sj18array[0] = 0; j18array[0] = 0;
}
for(int ij18 = 0; ij18 < 2; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 2; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];

{
IkReal j16eval[3];
sj17=0;
cj17=1.0;
j17=0;
IkReal x169=((321000.0)*sj18);
IkReal x170=(py*sj15);
IkReal x171=((321000.0)*cj18);
IkReal x172=(cj15*px);
j16eval[0]=((1.02430295950156)+cj18);
j16eval[1]=IKsign(((263041.0)+(((256800.0)*cj18))));
j16eval[2]=((IKabs(((((-1.0)*pz*x171))+(((-400000.0)*pz))+(((32100.0)*sj18))+(((-1.0)*x169*x170))+(((-1.0)*x169*x172)))))+(IKabs(((-40000.0)+(((400000.0)*x170))+(((400000.0)*x172))+(((-1.0)*pz*x169))+(((-32100.0)*cj18))+((x171*x172))+((x170*x171))))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
{
IkReal j16eval[3];
sj17=0;
cj17=1.0;
j17=0;
IkReal x173=(cj15*px);
IkReal x174=((1000.0)*pz);
IkReal x175=(py*sj15);
IkReal x176=((10.0)*cj18);
IkReal x177=((321.0)*cj18);
IkReal x178=(pz*sj18);
j16eval[0]=((1.24610591900312)+(((-10.0)*x178))+(((-1.0)*x175*x176))+cj18+(((-12.4610591900312)*x175))+(((-12.4610591900312)*x173))+(((-1.0)*x173*x176)));
j16eval[1]=IKsign(((40.0)+(((-1.0)*x175*x177))+(((-400.0)*x175))+(((-400.0)*x173))+(((32.1)*cj18))+(((-321.0)*x178))+(((-1.0)*x173*x177))));
j16eval[2]=((IKabs(((((-100.0)*pz))+(((103.041)*cj18*sj18))+((x173*x174))+((x174*x175))+(((128.4)*sj18)))))+(IKabs(((-160.0)+((pz*x174))+(((-256.8)*cj18))+(((-103.041)*(cj18*cj18)))))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
{
IkReal j16eval[3];
sj17=0;
cj17=1.0;
j17=0;
IkReal x179=cj15*cj15;
IkReal x180=py*py;
IkReal x181=px*px;
IkReal x182=pz*pz;
IkReal x183=(py*sj15);
IkReal x184=((321.0)*sj18);
IkReal x185=(cj15*px);
IkReal x186=((321.0)*cj18);
IkReal x187=((100.0)*x179);
IkReal x188=((1000.0)*x179);
j16eval[0]=((-1.0)+((x180*x187))+(((20.0)*x183))+(((20.0)*x185))+(((-100.0)*x180))+(((-100.0)*x182))+(((-200.0)*x183*x185))+(((-1.0)*x181*x187)));
j16eval[1]=IKsign(((-10.0)+((x180*x188))+(((-1000.0)*x180))+(((-1000.0)*x182))+(((200.0)*x183))+(((200.0)*x185))+(((-2000.0)*x183*x185))+(((-1.0)*x181*x188))));
j16eval[2]=((IKabs((((pz*x186))+(((400.0)*pz))+((x184*x185))+(((-32.1)*sj18))+((x183*x184)))))+(IKabs(((40.0)+((pz*x184))+(((-400.0)*x185))+(((-400.0)*x183))+(((32.1)*cj18))+(((-1.0)*x185*x186))+(((-1.0)*x183*x186))))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j16]

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x189=py*py;
IkReal x190=cj15*cj15;
IkReal x191=(py*sj15);
IkReal x192=((321.0)*sj18);
IkReal x193=(cj15*px);
IkReal x194=((321.0)*cj18);
IkReal x195=((1000.0)*x190);
CheckValue<IkReal> x196=IKPowWithIntegerCheck(IKsign(((-10.0)+(((-1000.0)*(pz*pz)))+(((-2000.0)*x191*x193))+((x189*x195))+(((-1000.0)*x189))+(((-1.0)*x195*(px*px)))+(((200.0)*x191))+(((200.0)*x193)))),-1);
if(!x196.valid){
continue;
}
CheckValue<IkReal> x197 = IKatan2WithCheck(IkReal(((((400.0)*pz))+((x192*x193))+(((-32.1)*sj18))+((x191*x192))+((pz*x194)))),IkReal(((40.0)+(((-400.0)*x191))+(((-400.0)*x193))+(((-1.0)*x191*x194))+(((32.1)*cj18))+(((-1.0)*x193*x194))+((pz*x192)))),IKFAST_ATAN2_MAGTHRESH);
if(!x197.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(((1.5707963267949)*(x196.value)))+(x197.value));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x198=IKsin(j16);
IkReal x199=IKcos(j16);
IkReal x200=((0.321)*sj18);
IkReal x201=((0.321)*cj18);
IkReal x202=(py*sj15);
IkReal x203=(cj15*px);
IkReal x204=(pz*x198);
IkReal x205=(x199*x203);
evalcond[0]=(((x198*x201))+(((0.4)*x198))+pz+((x199*x200)));
evalcond[1]=(((x198*x202))+((x198*x203))+x200+(((-0.1)*x198))+((pz*x199)));
evalcond[2]=((0.1)+(((0.4)*x199))+(((-1.0)*x198*x200))+(((-1.0)*x203))+(((-1.0)*x202))+((x199*x201)));
evalcond[3]=((0.4)+(((0.1)*x199))+x204+x201+(((-1.0)*x199*x202))+(((-1.0)*x205)));
evalcond[4]=((-0.066959)+(((0.2)*x202))+(((0.2)*x203))+(((0.8)*x199*x202))+(((-1.0)*pp))+(((0.8)*x205))+(((-0.08)*x199))+(((-0.8)*x204)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x689=(cj15*px);
IkReal x690=((1000.0)*pz);
IkReal x691=((321.0)*cj18);
IkReal x692=(py*sj15);
CheckValue<IkReal> x693 = IKatan2WithCheck(IkReal(((((-100.0)*pz))+(((103.041)*cj18*sj18))+((x690*x692))+((x689*x690))+(((128.4)*sj18)))),IkReal(((-160.0)+((pz*x690))+(((-256.8)*cj18))+(((-103.041)*(cj18*cj18))))),IKFAST_ATAN2_MAGTHRESH);
if(!x693.valid){
continue;
}
CheckValue<IkReal> x694=IKPowWithIntegerCheck(IKsign(((40.0)+(((-321.0)*pz*sj18))+(((-400.0)*x689))+(((32.1)*cj18))+(((-400.0)*x692))+(((-1.0)*x689*x691))+(((-1.0)*x691*x692)))),-1);
if(!x694.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(x693.value)+(((1.5707963267949)*(x694.value))));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x695=IKsin(j16);
IkReal x696=IKcos(j16);
IkReal x697=((0.321)*sj18);
IkReal x698=((0.321)*cj18);
IkReal x699=(py*sj15);
IkReal x700=(cj15*px);
IkReal x701=(pz*x695);
IkReal x702=(x696*x700);
evalcond[0]=(((x695*x698))+((x696*x697))+(((0.4)*x695))+pz);
evalcond[1]=(((x695*x699))+((pz*x696))+((x695*x700))+x697+(((-0.1)*x695)));
evalcond[2]=((0.1)+((x696*x698))+(((-1.0)*x700))+(((0.4)*x696))+(((-1.0)*x695*x697))+(((-1.0)*x699)));
evalcond[3]=((0.4)+(((-1.0)*x696*x699))+(((-1.0)*x702))+(((0.1)*x696))+x698+x701);
evalcond[4]=((-0.066959)+(((-0.8)*x701))+(((-1.0)*pp))+(((0.8)*x696*x699))+(((-0.08)*x696))+(((0.2)*x700))+(((0.8)*x702))+(((0.2)*x699)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x703=((321000.0)*sj18);
IkReal x704=(py*sj15);
IkReal x705=((321000.0)*cj18);
IkReal x706=(cj15*px);
CheckValue<IkReal> x707=IKPowWithIntegerCheck(IKsign(((263041.0)+(((256800.0)*cj18)))),-1);
if(!x707.valid){
continue;
}
CheckValue<IkReal> x708 = IKatan2WithCheck(IkReal(((((-1.0)*pz*x705))+(((-1.0)*x703*x706))+(((-1.0)*x703*x704))+(((-400000.0)*pz))+(((32100.0)*sj18)))),IkReal(((-40000.0)+(((-1.0)*pz*x703))+(((400000.0)*x706))+(((400000.0)*x704))+(((-32100.0)*cj18))+((x704*x705))+((x705*x706)))),IKFAST_ATAN2_MAGTHRESH);
if(!x708.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(((1.5707963267949)*(x707.value)))+(x708.value));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x709=IKsin(j16);
IkReal x710=IKcos(j16);
IkReal x711=((0.321)*sj18);
IkReal x712=((0.321)*cj18);
IkReal x713=(py*sj15);
IkReal x714=(cj15*px);
IkReal x715=(pz*x709);
IkReal x716=(x710*x714);
evalcond[0]=((((0.4)*x709))+((x709*x712))+((x710*x711))+pz);
evalcond[1]=((((-0.1)*x709))+((x709*x714))+((x709*x713))+x711+((pz*x710)));
evalcond[2]=((0.1)+(((0.4)*x710))+(((-1.0)*x709*x711))+(((-1.0)*x713))+(((-1.0)*x714))+((x710*x712)));
evalcond[3]=((0.4)+(((-1.0)*x710*x713))+(((-1.0)*x716))+(((0.1)*x710))+x712+x715);
evalcond[4]=((-0.066959)+(((-1.0)*pp))+(((-0.8)*x715))+(((0.2)*x713))+(((0.2)*x714))+(((0.8)*x710*x713))+(((-0.08)*x710))+(((0.8)*x716)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[2], cj18array[2], sj18array[2];
bool j18valid[2]={false};
_nj18 = 2;
cj18array[0]=((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15)));
if( cj18array[0] >= -1-IKFAST_SINCOS_THRESH && cj18array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j18valid[0] = j18valid[1] = true;
    j18array[0] = IKacos(cj18array[0]);
    sj18array[0] = IKsin(j18array[0]);
    cj18array[1] = cj18array[0];
    j18array[1] = -j18array[0];
    sj18array[1] = -sj18array[0];
}
else if( isnan(cj18array[0]) )
{
    // probably any value will work
    j18valid[0] = true;
    cj18array[0] = 1; sj18array[0] = 0; j18array[0] = 0;
}
for(int ij18 = 0; ij18 < 2; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 2; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];

{
IkReal j16eval[3];
sj17=0;
cj17=-1.0;
j17=3.14159265358979;
IkReal x717=((321000.0)*pz);
IkReal x718=((321000.0)*py*sj15);
IkReal x719=((321000.0)*cj15*px);
j16eval[0]=((-1.02430295950156)+(((-1.0)*cj18)));
j16eval[1]=IKsign(((-263041.0)+(((-256800.0)*cj18))));
j16eval[2]=((IKabs(((40000.0)+(((32100.0)*cj18))+(((-1.0)*sj18*x717))+(((-400000.0)*cj15*px))+(((-400000.0)*py*sj15))+(((-1.0)*cj18*x719))+(((-1.0)*cj18*x718)))))+(IKabs(((((-1.0)*sj18*x718))+(((-1.0)*sj18*x719))+((cj18*x717))+(((400000.0)*pz))+(((32100.0)*sj18))))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
{
IkReal j16eval[3];
sj17=0;
cj17=-1.0;
j17=3.14159265358979;
IkReal x720=(cj15*px);
IkReal x721=((1000.0)*pz);
IkReal x722=(py*sj15);
IkReal x723=((10.0)*cj18);
IkReal x724=((321.0)*cj18);
IkReal x725=(pz*sj18);
j16eval[0]=((-1.24610591900312)+((x720*x723))+(((-10.0)*x725))+(((12.4610591900312)*x722))+(((12.4610591900312)*x720))+((x722*x723))+(((-1.0)*cj18)));
j16eval[1]=((IKabs(((160.0)+(((256.8)*cj18))+(((-1.0)*pz*x721))+(((103.041)*(cj18*cj18))))))+(IKabs(((((100.0)*pz))+(((103.041)*cj18*sj18))+(((-1.0)*x721*x722))+(((-1.0)*x720*x721))+(((128.4)*sj18))))));
j16eval[2]=IKsign(((-40.0)+((x720*x724))+(((400.0)*x720))+(((400.0)*x722))+(((-321.0)*x725))+((x722*x724))+(((-32.1)*cj18))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
{
IkReal j16eval[3];
sj17=0;
cj17=-1.0;
j17=3.14159265358979;
IkReal x726=cj15*cj15;
IkReal x727=py*py;
IkReal x728=px*px;
IkReal x729=pz*pz;
IkReal x730=(py*sj15);
IkReal x731=((321.0)*cj18);
IkReal x732=(cj15*px);
IkReal x733=((321.0)*sj18);
IkReal x734=(x726*x728);
IkReal x735=(x726*x727);
j16eval[0]=((-1.0)+(((100.0)*x735))+(((-200.0)*x730*x732))+(((-100.0)*x727))+(((-100.0)*x729))+(((-100.0)*x734))+(((20.0)*x730))+(((20.0)*x732)));
j16eval[1]=IKsign(((-10.0)+(((200.0)*x732))+(((200.0)*x730))+(((1000.0)*x735))+(((-2000.0)*x730*x732))+(((-1000.0)*x727))+(((-1000.0)*x729))+(((-1000.0)*x734))));
j16eval[2]=((IKabs(((((32.1)*sj18))+(((-1.0)*x732*x733))+(((400.0)*pz))+(((-1.0)*x730*x733))+((pz*x731)))))+(IKabs(((40.0)+(((-1.0)*x731*x732))+(((32.1)*cj18))+(((-400.0)*x730))+(((-400.0)*x732))+(((-1.0)*x730*x731))+(((-1.0)*pz*x733))))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j16]

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x736=py*py;
IkReal x737=cj15*cj15;
IkReal x738=(py*sj15);
IkReal x739=((321.0)*sj18);
IkReal x740=(cj15*px);
IkReal x741=((321.0)*cj18);
IkReal x742=((1000.0)*x737);
CheckValue<IkReal> x743 = IKatan2WithCheck(IkReal(((((32.1)*sj18))+(((400.0)*pz))+(((-1.0)*x739*x740))+(((-1.0)*x738*x739))+((pz*x741)))),IkReal(((40.0)+(((32.1)*cj18))+(((-1.0)*x738*x741))+(((-400.0)*x738))+(((-1.0)*x740*x741))+(((-400.0)*x740))+(((-1.0)*pz*x739)))),IKFAST_ATAN2_MAGTHRESH);
if(!x743.valid){
continue;
}
CheckValue<IkReal> x744=IKPowWithIntegerCheck(IKsign(((-10.0)+(((200.0)*x738))+(((-1.0)*x742*(px*px)))+(((-1000.0)*(pz*pz)))+(((200.0)*x740))+(((-1000.0)*x736))+(((-2000.0)*x738*x740))+((x736*x742)))),-1);
if(!x744.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(x743.value)+(((1.5707963267949)*(x744.value))));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x745=IKsin(j16);
IkReal x746=IKcos(j16);
IkReal x747=((0.321)*sj18);
IkReal x748=((0.321)*cj18);
IkReal x749=(cj15*px);
IkReal x750=(py*sj15);
IkReal x751=(pz*x745);
IkReal x752=((1.0)*x745);
IkReal x753=((1.0)*x746);
IkReal x754=(x746*x749);
evalcond[0]=(((x745*x748))+(((-1.0)*x746*x747))+pz+(((0.4)*x745)));
evalcond[1]=((0.1)+((x745*x747))+((x746*x748))+(((-1.0)*x750))+(((-1.0)*x749))+(((0.4)*x746)));
evalcond[2]=((0.4)+(((-1.0)*x750*x753))+(((0.1)*x746))+x751+x748+(((-1.0)*x749*x753)));
evalcond[3]=((((-1.0)*x750*x752))+(((0.1)*x745))+x747+(((-1.0)*pz*x753))+(((-1.0)*x749*x752)));
evalcond[4]=((-0.066959)+(((0.8)*x746*x750))+(((0.8)*x754))+(((-0.08)*x746))+(((0.2)*x750))+(((-1.0)*pp))+(((0.2)*x749))+(((-0.8)*x751)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x755=(cj15*px);
IkReal x756=((1000.0)*pz);
IkReal x757=((321.0)*cj18);
IkReal x758=(py*sj15);
CheckValue<IkReal> x759 = IKatan2WithCheck(IkReal(((((100.0)*pz))+(((103.041)*cj18*sj18))+(((-1.0)*x755*x756))+(((-1.0)*x756*x758))+(((128.4)*sj18)))),IkReal(((160.0)+(((256.8)*cj18))+(((-1.0)*pz*x756))+(((103.041)*(cj18*cj18))))),IKFAST_ATAN2_MAGTHRESH);
if(!x759.valid){
continue;
}
CheckValue<IkReal> x760=IKPowWithIntegerCheck(IKsign(((-40.0)+(((-321.0)*pz*sj18))+(((-32.1)*cj18))+(((400.0)*x755))+(((400.0)*x758))+((x755*x757))+((x757*x758)))),-1);
if(!x760.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(x759.value)+(((1.5707963267949)*(x760.value))));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x761=IKsin(j16);
IkReal x762=IKcos(j16);
IkReal x763=((0.321)*sj18);
IkReal x764=((0.321)*cj18);
IkReal x765=(cj15*px);
IkReal x766=(py*sj15);
IkReal x767=(pz*x761);
IkReal x768=((1.0)*x761);
IkReal x769=((1.0)*x762);
IkReal x770=(x762*x765);
evalcond[0]=((((-1.0)*x762*x763))+((x761*x764))+pz+(((0.4)*x761)));
evalcond[1]=((0.1)+((x761*x763))+((x762*x764))+(((-1.0)*x765))+(((-1.0)*x766))+(((0.4)*x762)));
evalcond[2]=((0.4)+(((-1.0)*x765*x769))+(((-1.0)*x766*x769))+(((0.1)*x762))+x764+x767);
evalcond[3]=((((-1.0)*x765*x768))+(((-1.0)*x766*x768))+(((0.1)*x761))+x763+(((-1.0)*pz*x769)));
evalcond[4]=((-0.066959)+(((0.8)*x762*x766))+(((0.8)*x770))+(((-0.08)*x762))+(((0.2)*x766))+(((0.2)*x765))+(((-1.0)*pp))+(((-0.8)*x767)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x771=((321000.0)*pz);
IkReal x772=((321000.0)*py*sj15);
IkReal x773=((321000.0)*cj15*px);
CheckValue<IkReal> x774 = IKatan2WithCheck(IkReal(((((400000.0)*pz))+(((-1.0)*sj18*x772))+(((-1.0)*sj18*x773))+(((32100.0)*sj18))+((cj18*x771)))),IkReal(((40000.0)+(((32100.0)*cj18))+(((-1.0)*cj18*x773))+(((-1.0)*cj18*x772))+(((-1.0)*sj18*x771))+(((-400000.0)*cj15*px))+(((-400000.0)*py*sj15)))),IKFAST_ATAN2_MAGTHRESH);
if(!x774.valid){
continue;
}
CheckValue<IkReal> x775=IKPowWithIntegerCheck(IKsign(((-263041.0)+(((-256800.0)*cj18)))),-1);
if(!x775.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(x774.value)+(((1.5707963267949)*(x775.value))));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x776=IKsin(j16);
IkReal x777=IKcos(j16);
IkReal x778=((0.321)*sj18);
IkReal x779=((0.321)*cj18);
IkReal x780=(cj15*px);
IkReal x781=(py*sj15);
IkReal x782=(pz*x776);
IkReal x783=((1.0)*x776);
IkReal x784=((1.0)*x777);
IkReal x785=(x777*x780);
evalcond[0]=(((x776*x779))+pz+(((0.4)*x776))+(((-1.0)*x777*x778)));
evalcond[1]=((0.1)+((x776*x778))+((x777*x779))+(((0.4)*x777))+(((-1.0)*x781))+(((-1.0)*x780)));
evalcond[2]=((0.4)+(((0.1)*x777))+(((-1.0)*x781*x784))+x779+x782+(((-1.0)*x780*x784)));
evalcond[3]=((((0.1)*x776))+(((-1.0)*x781*x783))+x778+(((-1.0)*pz*x784))+(((-1.0)*x780*x783)));
evalcond[4]=((-0.066959)+(((-0.8)*x782))+(((-0.08)*x777))+(((0.2)*x781))+(((0.2)*x780))+(((-1.0)*pp))+(((0.8)*x777*x781))+(((0.8)*x785)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j16, j18]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x786=IKPowWithIntegerCheck(sj17,-1);
if(!x786.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x786.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x786.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.00311526479750779)*(x786.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[2];
evalcond[0]=(((px*sj15))+(((-1.0)*cj15*py))+(((0.321)*sj17*(IKsin(j18)))));
evalcond[1]=((0.253041)+(((0.2)*cj15*px))+(((0.2)*py*sj15))+(((-1.0)*pp))+(((0.2568)*(IKcos(j18)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j16eval[3];
IkReal x787=(cj15*px);
IkReal x788=((1000.0)*pz);
IkReal x789=(py*sj15);
IkReal x790=((10.0)*cj18);
IkReal x791=((321.0)*cj18);
IkReal x792=(cj17*sj18);
IkReal x793=(pz*x792);
j16eval[0]=((-1.24610591900312)+(((10.0)*x793))+(((12.4610591900312)*x789))+(((12.4610591900312)*x787))+((x787*x790))+(((-1.0)*cj18))+((x789*x790)));
j16eval[1]=((IKabs(((((-128.4)*x792))+(((100.0)*pz))+(((-1.0)*x788*x789))+(((-1.0)*x787*x788))+(((-103.041)*cj18*x792)))))+(IKabs(((160.0)+(((256.8)*cj18))+(((-1.0)*pz*x788))+(((103.041)*(cj18*cj18)))))));
j16eval[2]=IKsign(((-40.0)+(((400.0)*x789))+(((400.0)*x787))+(((321.0)*x793))+((x787*x791))+(((-32.1)*cj18))+((x789*x791))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
{
IkReal j16eval[3];
IkReal x794=cj17*cj17;
IkReal x795=cj18*cj18;
IkReal x796=(cj15*px);
IkReal x797=(py*sj15);
IkReal x798=((321000.0)*cj18);
IkReal x799=((321000.0)*cj17*sj18);
IkReal x800=((103041.0)*x795);
j16eval[0]=((1.5527799613746)+(((2.49221183800623)*cj18))+(((-1.0)*x794*x795))+x795+x794);
j16eval[1]=((IKabs(((((32100.0)*cj17*sj18))+(((-1.0)*x796*x799))+(((-1.0)*x797*x799))+(((-400000.0)*pz))+(((-1.0)*pz*x798)))))+(IKabs(((-40000.0)+((x796*x798))+(((-32100.0)*cj18))+(((-1.0)*pz*x799))+(((400000.0)*x796))+(((400000.0)*x797))+((x797*x798))))));
j16eval[2]=IKsign(((160000.0)+(((256800.0)*cj18))+x800+(((-1.0)*x794*x800))+(((103041.0)*x794))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  || IKabs(j16eval[2]) < 0.0000010000000000  )
{
{
IkReal j16eval[2];
IkReal x801=(cj17*sj18);
IkReal x802=(py*sj15);
IkReal x803=(cj18*pz);
IkReal x804=(cj15*px);
j16eval[0]=((((-10.0)*x801*x804))+(((-10.0)*x801*x802))+(((10.0)*x803))+x801+(((12.4610591900312)*pz)));
j16eval[1]=IKsign(((((-321.0)*x801*x802))+(((-321.0)*x801*x804))+(((32.1)*x801))+(((400.0)*pz))+(((321.0)*x803))));
if( IKabs(j16eval[0]) < 0.0000010000000000  || IKabs(j16eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(((-3.14159265358979)+(IKfmod(((1.5707963267949)+j17), 6.28318530717959)))))+(IKabs(pz)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16eval[1];
IkReal x805=((-1.0)*py);
pz=0;
j17=1.5707963267949;
sj17=1.0;
cj17=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x805);
rxp0_1=(px*r20);
rxp1_0=(r21*x805);
rxp1_1=(px*r21);
rxp2_0=(r22*x805);
rxp2_1=(px*r22);
j16eval[0]=((1.0)+(((-10.0)*cj15*px))+(((-10.0)*py*sj15)));
if( IKabs(j16eval[0]) < 0.0000010000000000  )
{
{
IkReal j16eval[1];
IkReal x806=((-1.0)*py);
pz=0;
j17=1.5707963267949;
sj17=1.0;
cj17=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x806);
rxp0_1=(px*r20);
rxp1_0=(r21*x806);
rxp1_1=(px*r21);
rxp2_0=(r22*x806);
rxp2_1=(px*r22);
j16eval[0]=((1.24610591900312)+cj18);
if( IKabs(j16eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
IkReal x807=((((100.0)*(px*px)))+(((100.0)*(py*py))));
if((x807) < -0.00001)
continue;
IkReal x808=IKabs(IKsqrt(x807));
IkReal x814 = x807;
if(IKabs(x814)==0){
continue;
}
IkReal x809=pow(x814,-0.5);
CheckValue<IkReal> x815=IKPowWithIntegerCheck(x808,-1);
if(!x815.valid){
continue;
}
IkReal x810=x815.value;
IkReal x811=((10.0)*px*x809);
IkReal x812=((10.0)*py*x809);
if((((1.0)+(((-1.0)*(x810*x810))))) < -0.00001)
continue;
IkReal x813=IKsqrt(((1.0)+(((-1.0)*(x810*x810)))));
if( (x810) < -1-IKFAST_SINCOS_THRESH || (x810) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x816 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x816.valid){
continue;
}
IkReal gconst25=(((x810*x812))+((x811*x813)));
IkReal gconst26=((((-1.0)*x812*x813))+((x810*x811)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x817=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x817.valid){
continue;
}
if( (x817.value) < -1-IKFAST_SINCOS_THRESH || (x817.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x818 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x818.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((IKasin(x817.value))+j15+(x818.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x820=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst25*py))+(((-1.0)*gconst26*px))),-1);
if(!x820.valid){
continue;
}
IkReal x819=x820.value;
cj16array[0]=((((-0.321)*cj18*x819))+(((-0.4)*x819)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x821=IKsin(j16);
IkReal x822=IKcos(j16);
IkReal x823=(gconst26*px);
IkReal x824=(gconst25*py);
IkReal x825=((0.321)*cj18);
IkReal x826=((0.8)*x822);
IkReal x827=((1.0)*x821);
evalcond[0]=(((x821*x825))+(((0.4)*x821)));
evalcond[1]=((((0.1)*x821))+(((-1.0)*x823*x827))+(((-1.0)*x824*x827)));
evalcond[2]=((0.1)+(((0.4)*x822))+(((-1.0)*x824))+(((-1.0)*x823))+((x822*x825)));
evalcond[3]=((-0.066959)+(((-1.0)*(px*px)))+(((-0.08)*x822))+((x824*x826))+((x823*x826))+(((-1.0)*(py*py)))+(((0.2)*x823))+(((0.2)*x824)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x828=((((100.0)*(px*px)))+(((100.0)*(py*py))));
IkReal x835 = x828;
if(IKabs(x835)==0){
continue;
}
IkReal x829=pow(x835,-0.5);
if((x828) < -0.00001)
continue;
IkReal x830=IKabs(IKsqrt(x828));
CheckValue<IkReal> x836=IKPowWithIntegerCheck(x830,-1);
if(!x836.valid){
continue;
}
IkReal x831=x836.value;
IkReal x832=((10.0)*px*x829);
IkReal x833=((10.0)*py*x829);
if((((1.0)+(((-1.0)*(x831*x831))))) < -0.00001)
continue;
IkReal x834=IKsqrt(((1.0)+(((-1.0)*(x831*x831)))));
if( (x831) < -1-IKFAST_SINCOS_THRESH || (x831) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x837 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x837.valid){
continue;
}
IkReal gconst28=((((-1.0)*x832*x834))+((x831*x833)));
IkReal gconst29=(((x831*x832))+((x833*x834)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x838=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x838.valid){
continue;
}
if( (x838.value) < -1-IKFAST_SINCOS_THRESH || (x838.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x839 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x839.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(((-1.0)*(IKasin(x838.value))))+j15+(x839.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x841=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst29*px))+(((-1.0)*gconst28*py))),-1);
if(!x841.valid){
continue;
}
IkReal x840=x841.value;
cj16array[0]=((((-0.4)*x840))+(((-0.321)*cj18*x840)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x842=IKsin(j16);
IkReal x843=IKcos(j16);
IkReal x844=(gconst29*px);
IkReal x845=((0.321)*cj18);
IkReal x846=(gconst28*py);
IkReal x847=((1.0)*x842);
IkReal x848=((0.8)*x843);
evalcond[0]=((((0.4)*x842))+((x842*x845)));
evalcond[1]=((((-1.0)*x846*x847))+(((0.1)*x842))+(((-1.0)*x844*x847)));
evalcond[2]=((0.1)+(((0.4)*x843))+((x843*x845))+(((-1.0)*x846))+(((-1.0)*x844)));
evalcond[3]=((-0.066959)+(((-1.0)*(px*px)))+(((-0.08)*x843))+((x846*x848))+(((0.2)*x844))+(((0.2)*x846))+(((-1.0)*(py*py)))+((x844*x848)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j16]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x850=IKPowWithIntegerCheck(((0.4)+(((0.321)*cj18))),-1);
if(!x850.valid){
continue;
}
IkReal x849=x850.value;
cj16array[0]=(((py*sj15*x849))+(((-0.1)*x849))+((cj15*px*x849)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x851=IKsin(j16);
IkReal x852=IKcos(j16);
IkReal x853=(cj15*px);
IkReal x854=((0.321)*cj18);
IkReal x855=(py*sj15);
IkReal x856=((1.0)*x855);
IkReal x857=((0.8)*x852);
evalcond[0]=(((x851*x854))+(((0.4)*x851)));
evalcond[1]=((((0.1)*x851))+(((-1.0)*x851*x853))+(((-1.0)*x851*x856)));
evalcond[2]=((0.4)+(((-1.0)*x852*x853))+(((0.1)*x852))+(((-1.0)*x852*x856))+x854);
evalcond[3]=((-0.066959)+(((-1.0)*(px*px)))+((x855*x857))+(((-0.08)*x852))+(((-1.0)*(py*py)))+((x853*x857))+(((0.2)*x853))+(((0.2)*x855)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x859=IKPowWithIntegerCheck(((0.1)+(((-1.0)*cj15*px))+(((-1.0)*py*sj15))),-1);
if(!x859.valid){
continue;
}
IkReal x858=x859.value;
cj16array[0]=((((-0.321)*cj18*x858))+(((-0.4)*x858)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x860=IKsin(j16);
IkReal x861=IKcos(j16);
IkReal x862=(py*sj15);
IkReal x863=((0.321)*cj18);
IkReal x864=(cj15*px);
IkReal x865=((1.0)*x860);
IkReal x866=((0.8)*x861);
evalcond[0]=((((0.4)*x860))+((x860*x863)));
evalcond[1]=((((0.1)*x860))+(((-1.0)*x862*x865))+(((-1.0)*x864*x865)));
evalcond[2]=((0.1)+(((-1.0)*x862))+(((-1.0)*x864))+((x861*x863))+(((0.4)*x861)));
evalcond[3]=((-0.066959)+(((-1.0)*(px*px)))+(((0.2)*x864))+(((0.2)*x862))+((x862*x866))+((x864*x866))+(((-1.0)*(py*py)))+(((-0.08)*x861)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(((-3.14159265358979)+(IKfmod(((4.71238898038469)+j17), 6.28318530717959)))))+(IKabs(pz)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16eval[1];
IkReal x867=((-1.0)*py);
pz=0;
j17=-1.5707963267949;
sj17=-1.0;
cj17=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x867);
rxp0_1=(px*r20);
rxp1_0=(r21*x867);
rxp1_1=(px*r21);
rxp2_0=(r22*x867);
rxp2_1=(px*r22);
j16eval[0]=((1.0)+(((-10.0)*cj15*px))+(((-10.0)*py*sj15)));
if( IKabs(j16eval[0]) < 0.0000010000000000  )
{
{
IkReal j16eval[1];
IkReal x868=((-1.0)*py);
pz=0;
j17=-1.5707963267949;
sj17=-1.0;
cj17=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x868);
rxp0_1=(px*r20);
rxp1_0=(r21*x868);
rxp1_1=(px*r21);
rxp2_0=(r22*x868);
rxp2_1=(px*r22);
j16eval[0]=((1.24610591900312)+cj18);
if( IKabs(j16eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
IkReal x869=((((100.0)*(px*px)))+(((100.0)*(py*py))));
if((x869) < -0.00001)
continue;
IkReal x870=IKabs(IKsqrt(x869));
IkReal x876 = x869;
if(IKabs(x876)==0){
continue;
}
IkReal x871=pow(x876,-0.5);
CheckValue<IkReal> x877=IKPowWithIntegerCheck(x870,-1);
if(!x877.valid){
continue;
}
IkReal x872=x877.value;
IkReal x873=((10.0)*px*x871);
IkReal x874=((10.0)*py*x871);
if((((1.0)+(((-1.0)*(x872*x872))))) < -0.00001)
continue;
IkReal x875=IKsqrt(((1.0)+(((-1.0)*(x872*x872)))));
if( (x872) < -1-IKFAST_SINCOS_THRESH || (x872) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x878 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x878.valid){
continue;
}
IkReal gconst31=(((x872*x874))+((x873*x875)));
IkReal gconst32=(((x872*x873))+(((-1.0)*x874*x875)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x879=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x879.valid){
continue;
}
if( (x879.value) < -1-IKFAST_SINCOS_THRESH || (x879.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x880 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x880.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((IKasin(x879.value))+j15+(x880.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x882=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst32*px))+(((-1.0)*gconst31*py))),-1);
if(!x882.valid){
continue;
}
IkReal x881=x882.value;
cj16array[0]=((((-0.4)*x881))+(((-0.321)*cj18*x881)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x883=IKsin(j16);
IkReal x884=IKcos(j16);
IkReal x885=(gconst32*px);
IkReal x886=(gconst31*py);
IkReal x887=((0.321)*cj18);
IkReal x888=((0.8)*x884);
evalcond[0]=(((x883*x887))+(((0.4)*x883)));
evalcond[1]=(((x883*x885))+((x883*x886))+(((-0.1)*x883)));
evalcond[2]=((0.1)+(((-1.0)*x885))+(((-1.0)*x886))+(((0.4)*x884))+((x884*x887)));
evalcond[3]=((-0.066959)+((x886*x888))+(((-1.0)*(px*px)))+(((0.2)*x885))+(((0.2)*x886))+(((-1.0)*(py*py)))+((x885*x888))+(((-0.08)*x884)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x889=((((100.0)*(px*px)))+(((100.0)*(py*py))));
IkReal x896 = x889;
if(IKabs(x896)==0){
continue;
}
IkReal x890=pow(x896,-0.5);
if((x889) < -0.00001)
continue;
IkReal x891=IKabs(IKsqrt(x889));
CheckValue<IkReal> x897=IKPowWithIntegerCheck(x891,-1);
if(!x897.valid){
continue;
}
IkReal x892=x897.value;
IkReal x893=((10.0)*px*x890);
IkReal x894=((10.0)*py*x890);
if((((1.0)+(((-1.0)*(x892*x892))))) < -0.00001)
continue;
IkReal x895=IKsqrt(((1.0)+(((-1.0)*(x892*x892)))));
if( (x892) < -1-IKFAST_SINCOS_THRESH || (x892) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x898 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x898.valid){
continue;
}
IkReal gconst34=(((x892*x894))+(((-1.0)*x893*x895)));
IkReal gconst35=(((x894*x895))+((x892*x893)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x899=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x899.valid){
continue;
}
if( (x899.value) < -1-IKFAST_SINCOS_THRESH || (x899.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x900 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x900.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(((-1.0)*(IKasin(x899.value))))+j15+(x900.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x902=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst34*py))+(((-1.0)*gconst35*px))),-1);
if(!x902.valid){
continue;
}
IkReal x901=x902.value;
cj16array[0]=((((-0.321)*cj18*x901))+(((-0.4)*x901)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x903=IKsin(j16);
IkReal x904=IKcos(j16);
IkReal x905=(gconst34*py);
IkReal x906=(gconst35*px);
IkReal x907=((0.321)*cj18);
IkReal x908=((0.8)*x904);
evalcond[0]=(((x903*x907))+(((0.4)*x903)));
evalcond[1]=(((x903*x905))+((x903*x906))+(((-0.1)*x903)));
evalcond[2]=((0.1)+(((0.4)*x904))+(((-1.0)*x906))+(((-1.0)*x905))+((x904*x907)));
evalcond[3]=((-0.066959)+((x905*x908))+(((-1.0)*(px*px)))+(((0.2)*x905))+(((0.2)*x906))+((x906*x908))+(((-0.08)*x904))+(((-1.0)*(py*py))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j16]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x910=IKPowWithIntegerCheck(((0.4)+(((0.321)*cj18))),-1);
if(!x910.valid){
continue;
}
IkReal x909=x910.value;
cj16array[0]=(((py*sj15*x909))+((cj15*px*x909))+(((-0.1)*x909)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x911=IKsin(j16);
IkReal x912=IKcos(j16);
IkReal x913=(cj15*px);
IkReal x914=(py*sj15);
IkReal x915=((0.321)*cj18);
IkReal x916=((1.0)*x912);
IkReal x917=((0.8)*x912);
evalcond[0]=(((x911*x915))+(((0.4)*x911)));
evalcond[1]=(((x911*x914))+((x911*x913))+(((-0.1)*x911)));
evalcond[2]=((0.4)+(((-1.0)*x913*x916))+(((0.1)*x912))+(((-1.0)*x914*x916))+x915);
evalcond[3]=((-0.066959)+(((0.2)*x913))+(((0.2)*x914))+(((-1.0)*(px*px)))+(((-0.08)*x912))+((x914*x917))+((x913*x917))+(((-1.0)*(py*py))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
CheckValue<IkReal> x919=IKPowWithIntegerCheck(((0.1)+(((-1.0)*cj15*px))+(((-1.0)*py*sj15))),-1);
if(!x919.valid){
continue;
}
IkReal x918=x919.value;
cj16array[0]=((((-0.4)*x918))+(((-0.321)*cj18*x918)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[4];
IkReal x920=IKsin(j16);
IkReal x921=IKcos(j16);
IkReal x922=(py*sj15);
IkReal x923=((0.321)*cj18);
IkReal x924=(cj15*px);
IkReal x925=((0.8)*x921);
evalcond[0]=(((x920*x923))+(((0.4)*x920)));
evalcond[1]=((((-0.1)*x920))+((x920*x924))+((x920*x922)));
evalcond[2]=((0.1)+((x921*x923))+(((-1.0)*x922))+(((-1.0)*x924))+(((0.4)*x921)));
evalcond[3]=((-0.066959)+(((-1.0)*(px*px)))+(((-0.08)*x921))+((x924*x925))+(((0.2)*x924))+(((0.2)*x922))+((x922*x925))+(((-1.0)*(py*py))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(pz))+(IKabs(((-3.14159265358979)+(IKfmod(((3.14159265358979)+j18), 6.28318530717959))))));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
cj16array[0]=((-0.13869625520111)+(((1.3869625520111)*py*sj15))+(((1.3869625520111)*cj15*px)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x926=IKcos(j16);
IkReal x927=IKsin(j16);
CheckValue<IkReal> x937=IKPowWithIntegerCheck(px,-1);
if(!x937.valid){
continue;
}
IkReal x928=x937.value;
IkReal x929=py*py;
IkReal x930=((1.0)*cj15);
IkReal x931=(cj15*cj17);
IkReal x932=((0.8)*cj15);
IkReal x933=(px*x926);
IkReal x934=(px*x927);
IkReal x935=((0.1)*x927);
IkReal x936=(x927*x928*x929);
evalcond[0]=((0.721)*x927);
evalcond[1]=((0.721)+(((0.1)*x926))+(((-1.0)*x930*x933))+(((-1.0)*py*sj15*x926)));
evalcond[2]=((-0.5768)+(((-0.08)*x926))+((x926*x928*x929*x932))+((x932*x933)));
evalcond[3]=((((-1.0)*cj17*x935))+((x931*x936))+((x931*x934)));
evalcond[4]=((((-1.0)*sj17*x930*x934))+(((-1.0)*sj17*x930*x936))+((sj17*x935)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(((-3.14159265358979)+(IKfmod(j18, 6.28318530717959)))))+(IKabs(pz)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j16array[2], cj16array[2], sj16array[2];
bool j16valid[2]={false};
_nj16 = 2;
cj16array[0]=((-1.26582278481013)+(((12.6582278481013)*cj15*px))+(((12.6582278481013)*py*sj15)));
if( cj16array[0] >= -1-IKFAST_SINCOS_THRESH && cj16array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j16valid[0] = j16valid[1] = true;
    j16array[0] = IKacos(cj16array[0]);
    sj16array[0] = IKsin(j16array[0]);
    cj16array[1] = cj16array[0];
    j16array[1] = -j16array[0];
    sj16array[1] = -sj16array[0];
}
else if( isnan(cj16array[0]) )
{
    // probably any value will work
    j16valid[0] = true;
    cj16array[0] = 1; sj16array[0] = 0; j16array[0] = 0;
}
for(int ij16 = 0; ij16 < 2; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 2; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[5];
IkReal x938=IKcos(j16);
IkReal x939=IKsin(j16);
CheckValue<IkReal> x949=IKPowWithIntegerCheck(px,-1);
if(!x949.valid){
continue;
}
IkReal x940=x949.value;
IkReal x941=py*py;
IkReal x942=((1.0)*cj15);
IkReal x943=(cj15*cj17);
IkReal x944=((0.8)*cj15);
IkReal x945=(px*x938);
IkReal x946=(px*x939);
IkReal x947=((0.1)*x939);
IkReal x948=(x939*x940*x941);
evalcond[0]=((0.079)*x939);
evalcond[1]=((0.079)+(((0.1)*x938))+(((-1.0)*py*sj15*x938))+(((-1.0)*x942*x945)));
evalcond[2]=((-0.0632)+(((-0.08)*x938))+((x938*x940*x941*x944))+((x944*x945)));
evalcond[3]=((((-1.0)*cj17*x947))+((x943*x948))+((x943*x946)));
evalcond[4]=((((-1.0)*sj17*x942*x946))+(((-1.0)*sj17*x942*x948))+((sj17*x947)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j16]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x950=cj15*cj15;
IkReal x951=py*py;
IkReal x952=(py*sj15);
IkReal x953=(cj15*px);
IkReal x954=((1000.0)*pz);
IkReal x955=(cj17*sj18);
IkReal x956=((1000.0)*x950);
CheckValue<IkReal> x957=IKPowWithIntegerCheck(IKsign(((((-321.0)*x953*x955))+(((321.0)*cj18*pz))+(((32.1)*x955))+(((400.0)*pz))+(((-321.0)*x952*x955)))),-1);
if(!x957.valid){
continue;
}
CheckValue<IkReal> x958 = IKatan2WithCheck(IkReal(((-150.0)+(((2000.0)*x952*x953))+((x956*(px*px)))+(((-256.8)*cj18))+(((1000.0)*x951))+(((-1.0)*x951*x956))+(((-103.041)*(cj18*cj18)))+(((-200.0)*x953))+(((-200.0)*x952)))),IkReal(((((-100.0)*pz))+((x952*x954))+(((-128.4)*x955))+(((-103.041)*cj18*x955))+((x953*x954)))),IKFAST_ATAN2_MAGTHRESH);
if(!x958.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(((1.5707963267949)*(x957.value)))+(x958.value));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[6];
IkReal x959=IKsin(j16);
IkReal x960=IKcos(j16);
IkReal x961=((0.321)*sj18);
IkReal x962=(cj15*px);
IkReal x963=(py*sj15);
IkReal x964=(px*sj15);
IkReal x965=((1.0)*sj17);
IkReal x966=(cj15*py);
IkReal x967=((0.321)*cj18);
IkReal x968=(pz*x960);
IkReal x969=((1.0)*x962);
IkReal x971=(sj17*x959);
IkReal x972=(pz*x959);
IkReal x973=((0.8)*x960);
IkReal x974=(cj17*x959);
evalcond[0]=(((cj17*x960*x961))+pz+((x959*x967))+(((0.4)*x959)));
evalcond[1]=((0.1)+(((-1.0)*x963))+((x960*x967))+(((-1.0)*x961*x974))+(((-1.0)*x969))+(((0.4)*x960)));
evalcond[2]=((0.4)+(((-1.0)*x960*x969))+(((-1.0)*x960*x963))+(((0.1)*x960))+x972+x967);
evalcond[3]=((-0.066959)+(((-0.8)*x972))+((x963*x973))+((x962*x973))+(((-1.0)*pp))+(((0.2)*x962))+(((0.2)*x963))+(((-0.08)*x960)));
evalcond[4]=((((0.1)*x971))+(((-1.0)*x959*x962*x965))+(((-1.0)*x965*x968))+((cj17*x964))+(((-1.0)*cj17*x966))+(((-1.0)*x959*x963*x965)));
evalcond[5]=((((-0.1)*x974))+((sj17*x964))+(((-1.0)*x965*x966))+((cj17*x968))+((x963*x974))+((x962*x974))+x961);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x975=cj17*cj17;
IkReal x976=cj18*cj18;
IkReal x977=(cj15*px);
IkReal x978=(py*sj15);
IkReal x979=((321000.0)*cj18);
IkReal x980=((321000.0)*cj17*sj18);
IkReal x981=((103041.0)*x976);
CheckValue<IkReal> x982=IKPowWithIntegerCheck(IKsign(((160000.0)+(((256800.0)*cj18))+(((103041.0)*x975))+(((-1.0)*x975*x981))+x981)),-1);
if(!x982.valid){
continue;
}
CheckValue<IkReal> x983 = IKatan2WithCheck(IkReal(((((32100.0)*cj17*sj18))+(((-1.0)*pz*x979))+(((-1.0)*x978*x980))+(((-400000.0)*pz))+(((-1.0)*x977*x980)))),IkReal(((-40000.0)+((x978*x979))+(((-1.0)*pz*x980))+((x977*x979))+(((-32100.0)*cj18))+(((400000.0)*x978))+(((400000.0)*x977)))),IKFAST_ATAN2_MAGTHRESH);
if(!x983.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(((1.5707963267949)*(x982.value)))+(x983.value));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[6];
IkReal x984=IKsin(j16);
IkReal x985=IKcos(j16);
IkReal x986=((0.321)*sj18);
IkReal x987=(cj15*px);
IkReal x988=(py*sj15);
IkReal x989=(px*sj15);
IkReal x990=((1.0)*sj17);
IkReal x991=(cj15*py);
IkReal x992=((0.321)*cj18);
IkReal x993=(pz*x985);
IkReal x994=((1.0)*x987);
IkReal x996=(sj17*x984);
IkReal x997=(pz*x984);
IkReal x998=((0.8)*x985);
IkReal x999=(cj17*x984);
evalcond[0]=((((0.4)*x984))+pz+((cj17*x985*x986))+((x984*x992)));
evalcond[1]=((0.1)+(((0.4)*x985))+(((-1.0)*x988))+(((-1.0)*x994))+(((-1.0)*x986*x999))+((x985*x992)));
evalcond[2]=((0.4)+(((0.1)*x985))+(((-1.0)*x985*x994))+x992+x997+(((-1.0)*x985*x988)));
evalcond[3]=((-0.066959)+(((-0.8)*x997))+((x988*x998))+(((-1.0)*pp))+(((0.2)*x988))+(((0.2)*x987))+((x987*x998))+(((-0.08)*x985)));
evalcond[4]=((((-1.0)*cj17*x991))+((cj17*x989))+(((-1.0)*x984*x987*x990))+(((-1.0)*x990*x993))+(((0.1)*x996))+(((-1.0)*x984*x988*x990)));
evalcond[5]=(((sj17*x989))+((x988*x999))+(((-1.0)*x990*x991))+(((-0.1)*x999))+((x987*x999))+((cj17*x993))+x986);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x1000=(cj15*px);
IkReal x1001=((1000.0)*pz);
IkReal x1002=(cj17*sj18);
IkReal x1003=((321.0)*cj18);
IkReal x1004=(py*sj15);
CheckValue<IkReal> x1005=IKPowWithIntegerCheck(IKsign(((-40.0)+((x1000*x1003))+(((400.0)*x1004))+(((400.0)*x1000))+(((-32.1)*cj18))+(((321.0)*pz*x1002))+((x1003*x1004)))),-1);
if(!x1005.valid){
continue;
}
CheckValue<IkReal> x1006 = IKatan2WithCheck(IkReal(((((100.0)*pz))+(((-128.4)*x1002))+(((-1.0)*x1001*x1004))+(((-1.0)*x1000*x1001))+(((-103.041)*cj18*x1002)))),IkReal(((160.0)+(((-1.0)*pz*x1001))+(((256.8)*cj18))+(((103.041)*(cj18*cj18))))),IKFAST_ATAN2_MAGTHRESH);
if(!x1006.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1005.value)))+(x1006.value));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[6];
IkReal x1007=IKsin(j16);
IkReal x1008=IKcos(j16);
IkReal x1009=((0.321)*sj18);
IkReal x1010=(cj15*px);
IkReal x1011=(py*sj15);
IkReal x1012=(px*sj15);
IkReal x1013=((1.0)*sj17);
IkReal x1014=(cj15*py);
IkReal x1015=((0.321)*cj18);
IkReal x1016=(pz*x1008);
IkReal x1017=((1.0)*x1010);
IkReal x1019=(sj17*x1007);
IkReal x1020=(pz*x1007);
IkReal x1021=((0.8)*x1008);
IkReal x1022=(cj17*x1007);
evalcond[0]=(((cj17*x1008*x1009))+(((0.4)*x1007))+pz+((x1007*x1015)));
evalcond[1]=((0.1)+(((0.4)*x1008))+(((-1.0)*x1017))+(((-1.0)*x1009*x1022))+((x1008*x1015))+(((-1.0)*x1011)));
evalcond[2]=((0.4)+(((0.1)*x1008))+x1015+x1020+(((-1.0)*x1008*x1011))+(((-1.0)*x1008*x1017)));
evalcond[3]=((-0.066959)+((x1010*x1021))+((x1011*x1021))+(((-0.08)*x1008))+(((-1.0)*pp))+(((0.2)*x1011))+(((0.2)*x1010))+(((-0.8)*x1020)));
evalcond[4]=((((-1.0)*x1007*x1011*x1013))+(((-1.0)*x1013*x1016))+((cj17*x1012))+(((0.1)*x1019))+(((-1.0)*cj17*x1014))+(((-1.0)*x1007*x1010*x1013)));
evalcond[5]=(((x1010*x1022))+((x1011*x1022))+x1009+((sj17*x1012))+(((-0.1)*x1022))+(((-1.0)*x1013*x1014))+((cj17*x1016)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j16array[1], cj16array[1], sj16array[1];
bool j16valid[1]={false};
_nj16 = 1;
IkReal x1023=py*py;
IkReal x1024=cj15*cj15;
IkReal x1025=px*px;
IkReal x1026=((5.0)*pp);
IkReal x1027=(py*sj15);
IkReal x1028=(pz*sj17);
IkReal x1029=(cj17*py);
IkReal x1030=(cj15*px*sj17);
IkReal x1031=((4.0)*x1023);
IkReal x1032=(cj15*cj17*sj15);
IkReal x1033=(sj17*x1024);
IkReal x1034=((4.0)*x1025);
IkReal x1035=((4.0)*x1029);
IkReal x1036=(cj17*px*sj15);
CheckValue<IkReal> x1037 = IKatan2WithCheck(IkReal((((x1031*x1032))+(((0.4)*x1036))+(((-1.0)*x1032*x1034))+(((-0.4)*cj15*x1029))+(((0.334795)*x1028))+(((8.0)*px*x1024*x1029))+((x1026*x1028))+(((-1.0)*x1027*x1028))+(((-1.0)*cj15*px*x1028))+(((-1.0)*px*x1035)))),IkReal(((((-4.0)*pz*x1036))+(((-1.0)*x1023*x1033))+(((-1.0)*sj17*x1026*x1027))+(((-1.0)*x1026*x1030))+((sj17*x1023))+(((0.5)*pp*sj17))+(((-0.434795)*x1030))+((cj15*pz*x1035))+(((-0.434795)*sj17*x1027))+(((2.0)*x1027*x1030))+((x1025*x1033))+(((0.0334795)*sj17)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1037.valid){
continue;
}
CheckValue<IkReal> x1038=IKPowWithIntegerCheck(IKsign((((x1031*x1033))+(((-1.0)*x1033*x1034))+(((-8.0)*x1027*x1030))+(((0.8)*sj17*x1027))+(((0.8)*x1030))+(((-4.0)*pz*x1028))+(((-0.04)*sj17))+(((-1.0)*sj17*x1031)))),-1);
if(!x1038.valid){
continue;
}
j16array[0]=((-1.5707963267949)+(x1037.value)+(((1.5707963267949)*(x1038.value))));
sj16array[0]=IKsin(j16array[0]);
cj16array[0]=IKcos(j16array[0]);
if( j16array[0] > IKPI )
{
    j16array[0]-=IK2PI;
}
else if( j16array[0] < -IKPI )
{    j16array[0]+=IK2PI;
}
j16valid[0] = true;
for(int ij16 = 0; ij16 < 1; ++ij16)
{
if( !j16valid[ij16] )
{
    continue;
}
_ij16[0] = ij16; _ij16[1] = -1;
for(int iij16 = ij16+1; iij16 < 1; ++iij16)
{
if( j16valid[iij16] && IKabs(cj16array[ij16]-cj16array[iij16]) < IKFAST_SOLUTION_THRESH && IKabs(sj16array[ij16]-sj16array[iij16]) < IKFAST_SOLUTION_THRESH )
{
    j16valid[iij16]=false; _ij16[1] = iij16; break; 
}
}
j16 = j16array[ij16]; cj16 = cj16array[ij16]; sj16 = sj16array[ij16];
{
IkReal evalcond[2];
IkReal x1039=IKcos(j16);
IkReal x1040=IKsin(j16);
IkReal x1041=((1.0)*py);
IkReal x1042=(cj15*px);
IkReal x1043=(py*sj15);
IkReal x1044=(sj17*x1040);
IkReal x1045=((0.8)*x1039);
evalcond[0]=((-0.066959)+(((0.2)*x1042))+(((0.2)*x1043))+((x1042*x1045))+((x1043*x1045))+(((-0.08)*x1039))+(((-1.0)*pp))+(((-0.8)*pz*x1040)));
evalcond[1]=((((0.1)*x1044))+(((-1.0)*pz*sj17*x1039))+(((-1.0)*sj15*x1041*x1044))+((cj17*px*sj15))+(((-1.0)*x1042*x1044))+(((-1.0)*cj15*cj17*x1041)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j18eval[1];
j18eval[0]=sj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal j18eval[2];
j18eval[0]=cj16;
j18eval[1]=cj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  || IKabs(j18eval[1]) < 0.0000010000000000  )
{
{
IkReal j18eval[2];
j18eval[0]=sj17;
j18eval[1]=sj16;
if( IKabs(j18eval[0]) < 0.0000010000000000  || IKabs(j18eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j17))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1046=((3.11526479750779)*cj16);
IkReal x1047=(py*sj15);
IkReal x1048=((3.11526479750779)*sj16);
IkReal x1049=(cj15*px);
if( IKabs(((((0.311526479750779)*sj16))+(((-1.0)*pz*x1046))+(((-1.0)*x1048*x1049))+(((-1.0)*x1047*x1048)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-1.0)*pz*x1048))+(((-0.311526479750779)*cj16))+((x1046*x1049))+((x1046*x1047)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((0.311526479750779)*sj16))+(((-1.0)*pz*x1046))+(((-1.0)*x1048*x1049))+(((-1.0)*x1047*x1048))))+IKsqr(((-1.24610591900312)+(((-1.0)*pz*x1048))+(((-0.311526479750779)*cj16))+((x1046*x1049))+((x1046*x1047))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((0.311526479750779)*sj16))+(((-1.0)*pz*x1046))+(((-1.0)*x1048*x1049))+(((-1.0)*x1047*x1048))), ((-1.24610591900312)+(((-1.0)*pz*x1048))+(((-0.311526479750779)*cj16))+((x1046*x1049))+((x1046*x1047))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1050=IKcos(j18);
IkReal x1051=IKsin(j18);
IkReal x1052=(py*sj15);
IkReal x1053=(cj15*px);
IkReal x1054=((1.0)*cj16);
IkReal x1055=((0.321)*x1050);
IkReal x1056=((0.321)*x1051);
evalcond[0]=(((cj16*x1056))+(((0.4)*sj16))+pz+((sj16*x1055)));
evalcond[1]=((0.253041)+(((0.2)*x1053))+(((0.2)*x1052))+(((-1.0)*pp))+(((0.2568)*x1050)));
evalcond[2]=((((-0.1)*sj16))+x1056+((cj16*pz))+((sj16*x1053))+((sj16*x1052)));
evalcond[3]=((0.4)+(((-1.0)*x1052*x1054))+x1055+((pz*sj16))+(((-1.0)*x1053*x1054))+(((0.1)*cj16)));
evalcond[4]=((0.1)+((cj16*x1055))+(((-1.0)*sj16*x1056))+(((0.4)*cj16))+(((-1.0)*x1052))+(((-1.0)*x1053)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1057=((3.11526479750779)*cj16);
IkReal x1058=((3.11526479750779)*sj16);
IkReal x1059=(py*sj15);
IkReal x1060=(cj15*px);
if( IKabs(((((-0.311526479750779)*sj16))+((pz*x1057))+((x1058*x1059))+((x1058*x1060)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+((x1057*x1059))+((x1057*x1060))+(((-1.0)*pz*x1058))+(((-0.311526479750779)*cj16)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-0.311526479750779)*sj16))+((pz*x1057))+((x1058*x1059))+((x1058*x1060))))+IKsqr(((-1.24610591900312)+((x1057*x1059))+((x1057*x1060))+(((-1.0)*pz*x1058))+(((-0.311526479750779)*cj16))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-0.311526479750779)*sj16))+((pz*x1057))+((x1058*x1059))+((x1058*x1060))), ((-1.24610591900312)+((x1057*x1059))+((x1057*x1060))+(((-1.0)*pz*x1058))+(((-0.311526479750779)*cj16))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1061=IKcos(j18);
IkReal x1062=IKsin(j18);
IkReal x1063=((1.0)*cj16);
IkReal x1064=(py*sj15);
IkReal x1065=(cj15*px);
IkReal x1066=((0.321)*x1061);
IkReal x1067=((1.0)*x1065);
IkReal x1068=((0.321)*x1062);
evalcond[0]=((((0.4)*sj16))+pz+(((-1.0)*cj16*x1068))+((sj16*x1066)));
evalcond[1]=((0.253041)+(((0.2)*x1064))+(((0.2)*x1065))+(((-1.0)*pp))+(((0.2568)*x1061)));
evalcond[2]=((0.4)+(((-1.0)*x1063*x1065))+(((-1.0)*x1063*x1064))+x1066+((pz*sj16))+(((0.1)*cj16)));
evalcond[3]=(x1068+(((-1.0)*pz*x1063))+(((-1.0)*sj16*x1067))+(((-1.0)*sj16*x1064))+(((0.1)*sj16)));
evalcond[4]=((0.1)+((cj16*x1066))+(((0.4)*cj16))+(((-1.0)*x1067))+((sj16*x1068))+(((-1.0)*x1064)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j16))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18eval[1];
sj16=0;
cj16=1.0;
j16=0;
j18eval[0]=cj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal j18eval[1];
sj16=0;
cj16=1.0;
j16=0;
j18eval[0]=sj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[2];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j17))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((-3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-3.11526479750779)*pz))+IKsqr(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((-3.11526479750779)*pz), ((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1069=IKcos(j18);
IkReal x1070=(py*sj15);
IkReal x1071=(cj15*px);
evalcond[0]=(pz+(((0.321)*(IKsin(j18)))));
evalcond[1]=((0.4)+(((-0.8)*x1070))+(((-0.8)*x1071))+(((0.2568)*x1069)));
evalcond[2]=((0.5)+(((0.321)*x1069))+(((-1.0)*x1070))+(((-1.0)*x1071)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((3.11526479750779)*pz))+IKsqr(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((3.11526479750779)*pz), ((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1072=IKcos(j18);
IkReal x1073=(py*sj15);
IkReal x1074=(cj15*px);
evalcond[0]=((((-0.321)*(IKsin(j18))))+pz);
evalcond[1]=((0.4)+(((-0.8)*x1074))+(((-0.8)*x1073))+(((0.2568)*x1072)));
evalcond[2]=((0.5)+(((0.321)*x1072))+(((-1.0)*x1073))+(((-1.0)*x1074)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j17)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1075=((3.11526479750779)*cj15);
IkReal x1076=((3.11526479750779)*sj15);
if( IKabs(((((-1.0)*px*x1076))+((py*x1075)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.55763239875389)+((px*x1075))+((py*x1076)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*px*x1076))+((py*x1075))))+IKsqr(((-1.55763239875389)+((px*x1075))+((py*x1076))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-1.0)*px*x1076))+((py*x1075))), ((-1.55763239875389)+((px*x1075))+((py*x1076))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1077=IKcos(j18);
IkReal x1078=(py*sj15);
IkReal x1079=(cj15*px);
evalcond[0]=(((px*sj15))+(((-1.0)*cj15*py))+(((0.321)*(IKsin(j18)))));
evalcond[1]=((0.4)+(((-0.8)*x1078))+(((-0.8)*x1079))+(((0.2568)*x1077)));
evalcond[2]=((0.5)+(((0.321)*x1077))+(((-1.0)*x1078))+(((-1.0)*x1079)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j17)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1080=((3.11526479750779)*cj15);
IkReal x1081=((3.11526479750779)*sj15);
if( IKabs(((((-1.0)*py*x1080))+((px*x1081)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.55763239875389)+((py*x1081))+((px*x1080)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*py*x1080))+((px*x1081))))+IKsqr(((-1.55763239875389)+((py*x1081))+((px*x1080))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-1.0)*py*x1080))+((px*x1081))), ((-1.55763239875389)+((py*x1081))+((px*x1080))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1082=IKcos(j18);
IkReal x1083=(py*sj15);
IkReal x1084=(cj15*px);
evalcond[0]=(((px*sj15))+(((-1.0)*cj15*py))+(((-0.321)*(IKsin(j18)))));
evalcond[1]=((0.4)+(((-0.8)*x1084))+(((-0.8)*x1083))+(((0.2568)*x1082)));
evalcond[2]=((0.5)+(((-1.0)*x1084))+(((-1.0)*x1083))+(((0.321)*x1082)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j18]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1085=IKPowWithIntegerCheck(sj17,-1);
if(!x1085.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1085.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1085.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))))+IKsqr(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.00311526479750779)*(x1085.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))), ((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1086=IKsin(j18);
IkReal x1087=IKcos(j18);
IkReal x1088=(py*sj15);
IkReal x1089=(cj15*px);
IkReal x1090=(px*sj15);
IkReal x1091=((0.321)*x1086);
IkReal x1092=((1.0)*cj15*py);
evalcond[0]=(pz+((cj17*x1091)));
evalcond[1]=(x1090+(((-1.0)*x1092))+((sj17*x1091)));
evalcond[2]=((0.4)+(((-0.8)*x1089))+(((-0.8)*x1088))+(((0.2568)*x1087)));
evalcond[3]=((0.5)+(((-1.0)*x1088))+(((-1.0)*x1089))+(((0.321)*x1087)));
evalcond[4]=(x1091+((sj17*x1090))+(((-1.0)*sj17*x1092))+((cj17*pz)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1093=IKPowWithIntegerCheck(cj17,-1);
if(!x1093.valid){
continue;
}
if( IKabs(((-3.11526479750779)*pz*(x1093.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-3.11526479750779)*pz*(x1093.value)))+IKsqr(((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((-3.11526479750779)*pz*(x1093.value)), ((-1.55763239875389)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1094=IKsin(j18);
IkReal x1095=IKcos(j18);
IkReal x1096=(py*sj15);
IkReal x1097=(cj15*px);
IkReal x1098=(px*sj15);
IkReal x1099=((0.321)*x1094);
IkReal x1100=((1.0)*cj15*py);
evalcond[0]=(pz+((cj17*x1099)));
evalcond[1]=(x1098+((sj17*x1099))+(((-1.0)*x1100)));
evalcond[2]=((0.4)+(((0.2568)*x1095))+(((-0.8)*x1096))+(((-0.8)*x1097)));
evalcond[3]=((0.5)+(((-1.0)*x1096))+(((-1.0)*x1097))+(((0.321)*x1095)));
evalcond[4]=(x1099+(((-1.0)*sj17*x1100))+((sj17*x1098))+((cj17*pz)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j16)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18eval[1];
sj16=0;
cj16=-1.0;
j16=3.14159265358979;
j18eval[0]=cj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal j18eval[1];
sj16=0;
cj16=-1.0;
j16=3.14159265358979;
j18eval[0]=sj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[2];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j17))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((3.11526479750779)*pz))+IKsqr(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((3.11526479750779)*pz), ((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1101=IKcos(j18);
IkReal x1102=(py*sj15);
IkReal x1103=(cj15*px);
evalcond[0]=((((-0.321)*(IKsin(j18))))+pz);
evalcond[1]=((0.3)+x1102+x1103+(((0.321)*x1101)));
evalcond[2]=((0.24)+(((0.8)*x1102))+(((0.8)*x1103))+(((0.2568)*x1101)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((-3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-3.11526479750779)*pz))+IKsqr(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((-3.11526479750779)*pz), ((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1104=IKcos(j18);
IkReal x1105=(py*sj15);
IkReal x1106=(cj15*px);
evalcond[0]=(pz+(((0.321)*(IKsin(j18)))));
evalcond[1]=((0.3)+x1106+x1105+(((0.321)*x1104)));
evalcond[2]=((0.24)+(((0.8)*x1106))+(((0.8)*x1105))+(((0.2568)*x1104)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j17)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1107=((3.11526479750779)*cj15);
IkReal x1108=((3.11526479750779)*sj15);
if( IKabs(((((-1.0)*px*x1108))+((py*x1107)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.934579439252336)+(((-1.0)*px*x1107))+(((-1.0)*py*x1108)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*px*x1108))+((py*x1107))))+IKsqr(((-0.934579439252336)+(((-1.0)*px*x1107))+(((-1.0)*py*x1108))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-1.0)*px*x1108))+((py*x1107))), ((-0.934579439252336)+(((-1.0)*px*x1107))+(((-1.0)*py*x1108))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1109=IKcos(j18);
IkReal x1110=(py*sj15);
IkReal x1111=(cj15*px);
evalcond[0]=(((px*sj15))+(((-1.0)*cj15*py))+(((0.321)*(IKsin(j18)))));
evalcond[1]=((0.3)+x1111+x1110+(((0.321)*x1109)));
evalcond[2]=((0.24)+(((0.8)*x1110))+(((0.8)*x1111))+(((0.2568)*x1109)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j17)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1112=((3.11526479750779)*cj15);
IkReal x1113=((3.11526479750779)*sj15);
if( IKabs(((((-1.0)*py*x1112))+((px*x1113)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.934579439252336)+(((-1.0)*px*x1112))+(((-1.0)*py*x1113)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*py*x1112))+((px*x1113))))+IKsqr(((-0.934579439252336)+(((-1.0)*px*x1112))+(((-1.0)*py*x1113))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-1.0)*py*x1112))+((px*x1113))), ((-0.934579439252336)+(((-1.0)*px*x1112))+(((-1.0)*py*x1113))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1114=IKcos(j18);
IkReal x1115=(py*sj15);
IkReal x1116=(cj15*px);
evalcond[0]=(((px*sj15))+(((-1.0)*cj15*py))+(((-0.321)*(IKsin(j18)))));
evalcond[1]=((0.3)+x1115+x1116+(((0.321)*x1114)));
evalcond[2]=((0.24)+(((0.8)*x1115))+(((0.8)*x1116))+(((0.2568)*x1114)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j18]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1117=IKPowWithIntegerCheck(sj17,-1);
if(!x1117.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1117.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1117.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))))+IKsqr(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.00311526479750779)*(x1117.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))), ((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1118=IKsin(j18);
IkReal x1119=IKcos(j18);
IkReal x1120=(py*sj15);
IkReal x1121=(cj15*px);
IkReal x1122=(px*sj15);
IkReal x1123=((0.321)*x1118);
IkReal x1124=((1.0)*cj15*py);
evalcond[0]=((((-1.0)*cj17*x1123))+pz);
evalcond[1]=((0.3)+x1120+x1121+(((0.321)*x1119)));
evalcond[2]=(x1122+((sj17*x1123))+(((-1.0)*x1124)));
evalcond[3]=((0.24)+(((0.8)*x1120))+(((0.8)*x1121))+(((0.2568)*x1119)));
evalcond[4]=(x1123+(((-1.0)*sj17*x1124))+((sj17*x1122))+(((-1.0)*cj17*pz)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1125=IKPowWithIntegerCheck(cj17,-1);
if(!x1125.valid){
continue;
}
if( IKabs(((3.11526479750779)*pz*(x1125.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((3.11526479750779)*pz*(x1125.value)))+IKsqr(((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((3.11526479750779)*pz*(x1125.value)), ((-0.934579439252336)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1126=IKsin(j18);
IkReal x1127=IKcos(j18);
IkReal x1128=(py*sj15);
IkReal x1129=(cj15*px);
IkReal x1130=(px*sj15);
IkReal x1131=((0.321)*x1126);
IkReal x1132=((1.0)*cj15*py);
evalcond[0]=((((-1.0)*cj17*x1131))+pz);
evalcond[1]=((0.3)+x1128+x1129+(((0.321)*x1127)));
evalcond[2]=(x1130+((sj17*x1131))+(((-1.0)*x1132)));
evalcond[3]=((0.24)+(((0.8)*x1129))+(((0.8)*x1128))+(((0.2568)*x1127)));
evalcond[4]=(x1131+(((-1.0)*sj17*x1132))+((sj17*x1130))+(((-1.0)*cj17*pz)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j16)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1133=((3.11526479750779)*cj15);
IkReal x1134=((3.11526479750779)*sj15);
if( IKabs(((((-1.0)*px*sj17*x1134))+(((-1.0)*cj17*px*x1133))+(((0.311526479750779)*cj17))+((py*sj17*x1133))+(((-1.0)*cj17*py*x1134)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*px*sj17*x1134))+(((-1.0)*cj17*px*x1133))+(((0.311526479750779)*cj17))+((py*sj17*x1133))+(((-1.0)*cj17*py*x1134))))+IKsqr(((-1.24610591900312)+(((-3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-1.0)*px*sj17*x1134))+(((-1.0)*cj17*px*x1133))+(((0.311526479750779)*cj17))+((py*sj17*x1133))+(((-1.0)*cj17*py*x1134))), ((-1.24610591900312)+(((-3.11526479750779)*pz))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1135=IKsin(j18);
IkReal x1136=IKcos(j18);
IkReal x1137=(py*sj15);
IkReal x1138=(px*sj15);
IkReal x1139=(cj15*px);
IkReal x1140=((0.321)*x1135);
IkReal x1141=((1.0)*cj15*py);
evalcond[0]=((0.4)+pz+(((0.321)*x1136)));
evalcond[1]=(x1138+(((-1.0)*x1141))+((sj17*x1140)));
evalcond[2]=((0.1)+(((-1.0)*x1137))+(((-1.0)*x1139))+(((-1.0)*cj17*x1140)));
evalcond[3]=((0.253041)+(((-1.0)*pp))+(((0.2)*x1139))+(((0.2)*x1137))+(((0.2568)*x1136)));
evalcond[4]=(x1140+(((-0.1)*cj17))+((sj17*x1138))+((cj17*x1137))+((cj17*x1139))+(((-1.0)*sj17*x1141)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j16)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18eval[1];
sj16=-1.0;
cj16=0;
j16=-1.5707963267949;
j18eval[0]=sj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal j18eval[1];
sj16=-1.0;
cj16=0;
j16=-1.5707963267949;
j18eval[0]=cj17;
if( IKabs(j18eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((((-3.11526479750779)*px*sj15))+(((3.11526479750779)*cj15*py)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-3.11526479750779)*px*sj15))+(((3.11526479750779)*cj15*py))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-3.11526479750779)*px*sj15))+(((3.11526479750779)*cj15*py))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1142=IKcos(j18);
evalcond[0]=((-0.4)+pz+(((-0.321)*x1142)));
evalcond[1]=((0.273041)+(((-1.0)*pp))+(((0.2568)*x1142)));
evalcond[2]=(((px*sj15))+(((-1.0)*cj15*py))+(((0.321)*(IKsin(j18)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((((3.11526479750779)*px*sj15))+(((-3.11526479750779)*cj15*py)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((3.11526479750779)*px*sj15))+(((-3.11526479750779)*cj15*py))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((3.11526479750779)*px*sj15))+(((-3.11526479750779)*cj15*py))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1143=IKcos(j18);
evalcond[0]=((-0.4)+pz+(((-0.321)*x1143)));
evalcond[1]=((0.273041)+(((-1.0)*pp))+(((0.2568)*x1143)));
evalcond[2]=(((px*sj15))+(((-1.0)*cj15*py))+(((-0.321)*(IKsin(j18)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j17))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((-0.311526479750779)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.311526479750779)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((-0.311526479750779)+(((3.11526479750779)*py*sj15))+(((3.11526479750779)*cj15*px))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1144=IKcos(j18);
IkReal x1145=(cj15*px);
IkReal x1146=(py*sj15);
evalcond[0]=((-0.4)+pz+(((-0.321)*x1144)));
evalcond[1]=((0.1)+(((-1.0)*x1145))+(((-1.0)*x1146))+(((0.321)*(IKsin(j18)))));
evalcond[2]=((0.253041)+(((-1.0)*pp))+(((0.2)*x1145))+(((0.2)*x1146))+(((0.2568)*x1144)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((0.311526479750779)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.311526479750779)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.311526479750779)+(((-3.11526479750779)*py*sj15))+(((-3.11526479750779)*cj15*px))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[3];
IkReal x1147=IKcos(j18);
IkReal x1148=(cj15*px);
IkReal x1149=(py*sj15);
evalcond[0]=((-0.4)+pz+(((-0.321)*x1147)));
evalcond[1]=((0.1)+(((-1.0)*x1148))+(((-1.0)*x1149))+(((-0.321)*(IKsin(j18)))));
evalcond[2]=((0.253041)+(((-1.0)*pp))+(((0.2)*x1149))+(((0.2)*x1148))+(((0.2568)*x1147)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j18]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1150=IKPowWithIntegerCheck(cj17,-1);
if(!x1150.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1150.value)*(((-100.0)+(((1000.0)*py*sj15))+(((1000.0)*cj15*px)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1150.value)*(((-100.0)+(((1000.0)*py*sj15))+(((1000.0)*cj15*px))))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.00311526479750779)*(x1150.value)*(((-100.0)+(((1000.0)*py*sj15))+(((1000.0)*cj15*px))))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1151=IKsin(j18);
IkReal x1152=IKcos(j18);
IkReal x1153=(py*sj15);
IkReal x1154=((1.0)*cj15);
IkReal x1155=(px*sj15);
IkReal x1156=((0.321)*x1151);
evalcond[0]=((-0.4)+(((-0.321)*x1152))+pz);
evalcond[1]=(x1155+(((-1.0)*py*x1154))+((sj17*x1156)));
evalcond[2]=((0.1)+(((-1.0)*px*x1154))+(((-1.0)*x1153))+((cj17*x1156)));
evalcond[3]=((0.253041)+(((0.2)*x1153))+(((0.2568)*x1152))+(((0.2)*cj15*px))+(((-1.0)*pp)));
evalcond[4]=((((-1.0)*cj17*px*x1154))+x1156+(((-1.0)*py*sj17*x1154))+(((-1.0)*cj17*x1153))+((sj17*x1155))+(((0.1)*cj17)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1157=IKPowWithIntegerCheck(sj17,-1);
if(!x1157.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1157.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1157.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.00311526479750779)*(x1157.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1158=IKsin(j18);
IkReal x1159=IKcos(j18);
IkReal x1160=(py*sj15);
IkReal x1161=((1.0)*cj15);
IkReal x1162=(px*sj15);
IkReal x1163=((0.321)*x1158);
evalcond[0]=((-0.4)+(((-0.321)*x1159))+pz);
evalcond[1]=(x1162+((sj17*x1163))+(((-1.0)*py*x1161)));
evalcond[2]=((0.1)+((cj17*x1163))+(((-1.0)*px*x1161))+(((-1.0)*x1160)));
evalcond[3]=((0.253041)+(((0.2568)*x1159))+(((0.2)*cj15*px))+(((-1.0)*pp))+(((0.2)*x1160)));
evalcond[4]=(x1163+(((-1.0)*cj17*px*x1161))+((sj17*x1162))+(((-1.0)*py*sj17*x1161))+(((-1.0)*cj17*x1160))+(((0.1)*cj17)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((((-3.11526479750779)*px*sj15))+(((3.11526479750779)*cj15*py)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-3.11526479750779)*px*sj15))+(((3.11526479750779)*cj15*py))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((-3.11526479750779)*px*sj15))+(((3.11526479750779)*cj15*py))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1164=IKcos(j18);
IkReal x1165=(py*sj15);
IkReal x1166=((1.0)*cj16);
IkReal x1167=((1.0)*cj15);
IkReal x1168=(cj15*px);
IkReal x1169=((0.321)*x1164);
evalcond[0]=(((sj16*x1169))+(((0.4)*sj16))+pz);
evalcond[1]=(((px*sj15))+(((-1.0)*py*x1167))+(((0.321)*(IKsin(j18)))));
evalcond[2]=((0.253041)+(((0.2568)*x1164))+(((-1.0)*pp))+(((0.2)*x1165))+(((0.2)*x1168)));
evalcond[3]=((0.1)+((cj16*x1169))+(((0.4)*cj16))+(((-1.0)*px*x1167))+(((-1.0)*x1165)));
evalcond[4]=((0.4)+(((-1.0)*x1166*x1168))+x1169+((pz*sj16))+(((-1.0)*x1165*x1166))+(((0.1)*cj16)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j17)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
if( IKabs(((((3.11526479750779)*px*sj15))+(((-3.11526479750779)*cj15*py)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((3.11526479750779)*px*sj15))+(((-3.11526479750779)*cj15*py))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((((3.11526479750779)*px*sj15))+(((-3.11526479750779)*cj15*py))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[5];
IkReal x1170=IKcos(j18);
IkReal x1171=(py*sj15);
IkReal x1172=((1.0)*cj16);
IkReal x1173=((1.0)*cj15);
IkReal x1174=(cj15*px);
IkReal x1175=((0.321)*x1170);
evalcond[0]=(((sj16*x1175))+(((0.4)*sj16))+pz);
evalcond[1]=(((px*sj15))+(((-1.0)*py*x1173))+(((-0.321)*(IKsin(j18)))));
evalcond[2]=((0.253041)+(((0.2568)*x1170))+(((0.2)*x1171))+(((0.2)*x1174))+(((-1.0)*pp)));
evalcond[3]=((0.1)+((cj16*x1175))+(((0.4)*cj16))+(((-1.0)*px*x1173))+(((-1.0)*x1171)));
evalcond[4]=((0.4)+x1175+(((-1.0)*x1172*x1174))+((pz*sj16))+(((-1.0)*x1171*x1172))+(((0.1)*cj16)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j18]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1181=IKPowWithIntegerCheck(sj17,-1);
if(!x1181.valid){
continue;
}
IkReal x1176=x1181.value;
IkReal x1177=((0.00311526479750779)*x1176);
IkReal x1178=(px*sj15);
IkReal x1179=(cj15*py);
IkReal x1180=((1000.0)*cj16*cj17);
CheckValue<IkReal> x1182=IKPowWithIntegerCheck(sj16,-1);
if(!x1182.valid){
continue;
}
if( IKabs((x1177*(((((-1000.0)*x1178))+(((1000.0)*x1179)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1177*(x1182.value)*(((((-1000.0)*pz*sj17))+((x1178*x1180))+(((-400.0)*sj16*sj17))+(((-1.0)*x1179*x1180)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x1177*(((((-1000.0)*x1178))+(((1000.0)*x1179))))))+IKsqr((x1177*(x1182.value)*(((((-1000.0)*pz*sj17))+((x1178*x1180))+(((-400.0)*sj16*sj17))+(((-1.0)*x1179*x1180))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2((x1177*(((((-1000.0)*x1178))+(((1000.0)*x1179))))), (x1177*(x1182.value)*(((((-1000.0)*pz*sj17))+((x1178*x1180))+(((-400.0)*sj16*sj17))+(((-1.0)*x1179*x1180))))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[6];
IkReal x1183=IKcos(j18);
IkReal x1184=IKsin(j18);
IkReal x1185=(cj17*sj16);
IkReal x1186=(cj16*cj17);
IkReal x1187=(cj15*px);
IkReal x1188=((1.0)*cj16);
IkReal x1189=(py*sj15);
IkReal x1190=(px*sj15);
IkReal x1191=((0.321)*x1184);
IkReal x1192=((0.321)*x1183);
IkReal x1193=((1.0)*cj15*py);
evalcond[0]=(x1190+(((-1.0)*x1193))+((sj17*x1191)));
evalcond[1]=((0.253041)+(((-1.0)*pp))+(((0.2)*x1189))+(((0.2)*x1187))+(((0.2568)*x1183)));
evalcond[2]=(((x1186*x1191))+(((0.4)*sj16))+((sj16*x1192))+pz);
evalcond[3]=((0.4)+x1192+(((-1.0)*x1188*x1189))+((pz*sj16))+(((-1.0)*x1187*x1188))+(((0.1)*cj16)));
evalcond[4]=((0.1)+((cj16*x1192))+(((0.4)*cj16))+(((-1.0)*x1185*x1191))+(((-1.0)*x1189))+(((-1.0)*x1187)));
evalcond[5]=(x1191+((pz*x1186))+(((-0.1)*x1185))+(((-1.0)*sj17*x1193))+((x1185*x1187))+((x1185*x1189))+((sj17*x1190)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
IkReal x1194=((250.0)*sj16);
IkReal x1195=(py*sj15);
IkReal x1196=(cj15*px);
CheckValue<IkReal> x1197=IKPowWithIntegerCheck(cj16,-1);
if(!x1197.valid){
continue;
}
CheckValue<IkReal> x1198=IKPowWithIntegerCheck(cj17,-1);
if(!x1198.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1197.value)*(x1198.value)*(((((-1000.0)*pz))+((x1194*x1196))+((x1194*x1195))+(((-1250.0)*pp*sj16))+(((-83.69875)*sj16)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*x1196))+(((-0.778816199376947)*x1195)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1197.value)*(x1198.value)*(((((-1000.0)*pz))+((x1194*x1196))+((x1194*x1195))+(((-1250.0)*pp*sj16))+(((-83.69875)*sj16))))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*x1196))+(((-0.778816199376947)*x1195))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.00311526479750779)*(x1197.value)*(x1198.value)*(((((-1000.0)*pz))+((x1194*x1196))+((x1194*x1195))+(((-1250.0)*pp*sj16))+(((-83.69875)*sj16))))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*x1196))+(((-0.778816199376947)*x1195))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[6];
IkReal x1199=IKcos(j18);
IkReal x1200=IKsin(j18);
IkReal x1201=(cj17*sj16);
IkReal x1202=(cj16*cj17);
IkReal x1203=(cj15*px);
IkReal x1204=((1.0)*cj16);
IkReal x1205=(py*sj15);
IkReal x1206=(px*sj15);
IkReal x1207=((0.321)*x1200);
IkReal x1208=((0.321)*x1199);
IkReal x1209=((1.0)*cj15*py);
evalcond[0]=(x1206+((sj17*x1207))+(((-1.0)*x1209)));
evalcond[1]=((0.253041)+(((-1.0)*pp))+(((0.2568)*x1199))+(((0.2)*x1205))+(((0.2)*x1203)));
evalcond[2]=(((sj16*x1208))+((x1202*x1207))+(((0.4)*sj16))+pz);
evalcond[3]=((0.4)+(((-1.0)*x1204*x1205))+x1208+((pz*sj16))+(((-1.0)*x1203*x1204))+(((0.1)*cj16)));
evalcond[4]=((0.1)+(((0.4)*cj16))+(((-1.0)*x1203))+(((-1.0)*x1205))+((cj16*x1208))+(((-1.0)*x1201*x1207)));
evalcond[5]=(x1207+(((-0.1)*x1201))+((sj17*x1206))+(((-1.0)*sj17*x1209))+((pz*x1202))+((x1201*x1203))+((x1201*x1205)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j18array[1], cj18array[1], sj18array[1];
bool j18valid[1]={false};
_nj18 = 1;
CheckValue<IkReal> x1210=IKPowWithIntegerCheck(sj17,-1);
if(!x1210.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1210.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1210.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j18array[0]=IKatan2(((0.00311526479750779)*(x1210.value)*(((((-1000.0)*px*sj15))+(((1000.0)*cj15*py))))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*cj15*px))+(((-0.778816199376947)*py*sj15))));
sj18array[0]=IKsin(j18array[0]);
cj18array[0]=IKcos(j18array[0]);
if( j18array[0] > IKPI )
{
    j18array[0]-=IK2PI;
}
else if( j18array[0] < -IKPI )
{    j18array[0]+=IK2PI;
}
j18valid[0] = true;
for(int ij18 = 0; ij18 < 1; ++ij18)
{
if( !j18valid[ij18] )
{
    continue;
}
_ij18[0] = ij18; _ij18[1] = -1;
for(int iij18 = ij18+1; iij18 < 1; ++iij18)
{
if( j18valid[iij18] && IKabs(cj18array[ij18]-cj18array[iij18]) < IKFAST_SOLUTION_THRESH && IKabs(sj18array[ij18]-sj18array[iij18]) < IKFAST_SOLUTION_THRESH )
{
    j18valid[iij18]=false; _ij18[1] = iij18; break; 
}
}
j18 = j18array[ij18]; cj18 = cj18array[ij18]; sj18 = sj18array[ij18];
{
IkReal evalcond[6];
IkReal x1211=IKcos(j18);
IkReal x1212=IKsin(j18);
IkReal x1213=(cj17*sj16);
IkReal x1214=(cj16*cj17);
IkReal x1215=(cj15*px);
IkReal x1216=((1.0)*cj16);
IkReal x1217=(py*sj15);
IkReal x1218=(px*sj15);
IkReal x1219=((0.321)*x1212);
IkReal x1220=((0.321)*x1211);
IkReal x1221=((1.0)*cj15*py);
evalcond[0]=(x1218+(((-1.0)*x1221))+((sj17*x1219)));
evalcond[1]=((0.253041)+(((0.2)*x1215))+(((0.2)*x1217))+(((0.2568)*x1211))+(((-1.0)*pp)));
evalcond[2]=(((x1214*x1219))+(((0.4)*sj16))+pz+((sj16*x1220)));
evalcond[3]=((0.4)+x1220+(((-1.0)*x1215*x1216))+(((-1.0)*x1216*x1217))+((pz*sj16))+(((0.1)*cj16)));
evalcond[4]=((0.1)+((cj16*x1220))+(((-1.0)*x1213*x1219))+(((0.4)*cj16))+(((-1.0)*x1217))+(((-1.0)*x1215)));
evalcond[5]=(x1219+(((-0.1)*x1213))+((x1213*x1215))+((x1213*x1217))+(((-1.0)*sj17*x1221))+((sj17*x1218))+((pz*x1214)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}
    }
}
return solutions.GetNumSolutions()>0;
}
inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions) {
for(int rotationiter = 0; rotationiter < 1; ++rotationiter) {
IkReal x206=((1.0)*cj17);
IkReal x207=(cj18*sj16);
IkReal x208=(cj16*sj17);
IkReal x209=(sj16*sj18);
IkReal x210=(sj16*sj17);
IkReal x211=(cj16*cj18);
IkReal x212=(sj17*sj18);
IkReal x213=(cj16*sj18);
IkReal x214=(cj18*sj15*sj17);
IkReal x215=((((-1.0)*x206*x211))+x209);
IkReal x216=(((sj15*x210))+((cj15*cj17)));
IkReal x217=(((cj15*x210))+(((-1.0)*sj15*x206)));
IkReal x218=((((-1.0)*x206*x209))+x211);
IkReal x219=(cj15*x218);
IkReal x220=((((-1.0)*x206*x207))+(((-1.0)*x213)));
IkReal x221=((((-1.0)*x206*x213))+(((-1.0)*x207)));
IkReal x222=(cj15*x220);
IkReal x223=(((cj15*x212))+((sj15*x218)));
IkReal x224=((((-1.0)*sj15*x212))+x219);
IkReal x225=(((cj15*cj18*sj17))+((sj15*x220)));
IkReal x226=(x222+(((-1.0)*x214)));
new_r00=(((r00*x226))+((r10*x225))+((r20*x215)));
new_r01=(((r21*x215))+((r01*x226))+((r11*x225)));
new_r02=(((r02*((x222+(((-1.0)*x214))))))+((r12*x225))+((r22*x215)));
new_r10=(((r20*x208))+((r00*x217))+((r10*x216)));
new_r11=(((r11*x216))+((r21*x208))+((r01*x217)));
new_r12=(((r22*x208))+((r12*x216))+((r02*x217)));
new_r20=(((r20*x221))+((r10*x223))+((r00*(((((-1.0)*sj15*x212))+x219)))));
new_r21=(((r01*x224))+((r11*x223))+((r21*x221)));
new_r22=(((r12*x223))+((r02*x224))+((r22*x221)));
{
IkReal j20array[2], cj20array[2], sj20array[2];
bool j20valid[2]={false};
_nj20 = 2;
cj20array[0]=new_r22;
if( cj20array[0] >= -1-IKFAST_SINCOS_THRESH && cj20array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j20valid[0] = j20valid[1] = true;
    j20array[0] = IKacos(cj20array[0]);
    sj20array[0] = IKsin(j20array[0]);
    cj20array[1] = cj20array[0];
    j20array[1] = -j20array[0];
    sj20array[1] = -sj20array[0];
}
else if( isnan(cj20array[0]) )
{
    // probably any value will work
    j20valid[0] = true;
    cj20array[0] = 1; sj20array[0] = 0; j20array[0] = 0;
}
for(int ij20 = 0; ij20 < 2; ++ij20)
{
if( !j20valid[ij20] )
{
    continue;
}
_ij20[0] = ij20; _ij20[1] = -1;
for(int iij20 = ij20+1; iij20 < 2; ++iij20)
{
if( j20valid[iij20] && IKabs(cj20array[ij20]-cj20array[iij20]) < IKFAST_SOLUTION_THRESH && IKabs(sj20array[ij20]-sj20array[iij20]) < IKFAST_SOLUTION_THRESH )
{
    j20valid[iij20]=false; _ij20[1] = iij20; break; 
}
}
j20 = j20array[ij20]; cj20 = cj20array[ij20]; sj20 = sj20array[ij20];

{
IkReal j19eval[3];
j19eval[0]=sj20;
j19eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j19eval[2]=IKsign(sj20);
if( IKabs(j19eval[0]) < 0.0000010000000000  || IKabs(j19eval[1]) < 0.0000010000000000  || IKabs(j19eval[2]) < 0.0000010000000000  )
{
{
IkReal j21eval[3];
j21eval[0]=sj20;
j21eval[1]=((IKabs(new_r20))+(IKabs(new_r21)));
j21eval[2]=IKsign(sj20);
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal j19eval[2];
j19eval[0]=new_r12;
j19eval[1]=sj20;
if( IKabs(j19eval[0]) < 0.0000010000000000  || IKabs(j19eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j20))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j21mul = 1;
j21=0;
j19mul=-1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19=IKatan2(((-1.0)*new_r01), new_r00);
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].fmul = j19mul;
vinfos[5].freeind = 0;
vinfos[5].maxsolutions = 0;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].fmul = j21mul;
vinfos[7].freeind = 0;
vinfos[7].maxsolutions = 0;
std::vector<int> vfree(1);
vfree[0] = 7;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j20)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j21mul = 1;
j21=0;
j19mul=1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r00))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r00));
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].fmul = j19mul;
vinfos[5].freeind = 0;
vinfos[5].maxsolutions = 0;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].fmul = j21mul;
vinfos[7].freeind = 0;
vinfos[7].maxsolutions = 0;
std::vector<int> vfree(1);
vfree[0] = 7;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j19eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x227=new_r22*new_r22;
IkReal x228=((16.0)*new_r10);
IkReal x229=((16.0)*new_r01);
IkReal x230=((16.0)*new_r22);
IkReal x231=((8.0)*new_r11);
IkReal x232=((8.0)*new_r00);
IkReal x233=(x227*x228);
IkReal x234=(x227*x229);
j19eval[0]=((IKabs(((((-1.0)*new_r22*x232))+((x227*x231)))))+(IKabs(((((32.0)*new_r11))+(((-16.0)*new_r11*x227))+(((-1.0)*new_r00*x230)))))+(IKabs((x233+(((-1.0)*x228)))))+(IKabs((((new_r11*x230))+(((16.0)*new_r00))+(((-32.0)*new_r00*x227)))))+(IKabs(((((-1.0)*x233))+x228)))+(IKabs(((((-1.0)*x234))+x229)))+(IKabs((x234+(((-1.0)*x229)))))+(IKabs((((new_r22*x231))+(((-1.0)*x232))))));
if( IKabs(j19eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j19, j21]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j19evalpoly[1];
IkReal x235=new_r22*new_r22;
IkReal x236=((16.0)*new_r10);
IkReal x237=(new_r11*new_r22);
IkReal x238=(x235*x236);
IkReal x239=((((8.0)*x237))+(((-8.0)*new_r00)));
op[0]=x239;
op[1]=((((-1.0)*x238))+x236);
op[2]=((((16.0)*new_r00))+(((16.0)*x237))+(((-32.0)*new_r00*x235)));
op[3]=((((-1.0)*x236))+x238);
op[4]=x239;
polyroots4(op,zeror,numroots);
IkReal j19array[4], cj19array[4], sj19array[4], tempj19array[1];
int numsolutions = 0;
for(int ij19 = 0; ij19 < numroots; ++ij19)
{
IkReal htj19 = zeror[ij19];
tempj19array[0]=((2.0)*(atan(htj19)));
for(int kj19 = 0; kj19 < 1; ++kj19)
{
j19array[numsolutions] = tempj19array[kj19];
if( j19array[numsolutions] > IKPI )
{
    j19array[numsolutions]-=IK2PI;
}
else if( j19array[numsolutions] < -IKPI )
{
    j19array[numsolutions]+=IK2PI;
}
sj19array[numsolutions] = IKsin(j19array[numsolutions]);
cj19array[numsolutions] = IKcos(j19array[numsolutions]);
numsolutions++;
}
}
bool j19valid[4]={true,true,true,true};
_nj19 = 4;
for(int ij19 = 0; ij19 < numsolutions; ++ij19)
    {
if( !j19valid[ij19] )
{
    continue;
}
    j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
htj19 = IKtan(j19/2);

IkReal x240=((16.0)*new_r01);
IkReal x241=new_r22*new_r22;
IkReal x242=(new_r00*new_r22);
IkReal x243=((8.0)*x242);
IkReal x244=(new_r11*x241);
IkReal x245=(x240*x241);
IkReal x246=((8.0)*x244);
j19evalpoly[0]=(((htj19*((x240+(((-1.0)*x245))))))+(((htj19*htj19*htj19)*((x245+(((-1.0)*x240))))))+x246+(((-1.0)*x243))+(((htj19*htj19*htj19*htj19)*((x246+(((-1.0)*x243))))))+(((htj19*htj19)*(((((32.0)*new_r11))+(((-16.0)*x244))+(((-16.0)*x242)))))));
if( IKabs(j19evalpoly[0]) > 0.0000001000000000  )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < numsolutions; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
{
IkReal j21eval[3];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x247=cj19*cj19;
IkReal x248=(cj19*new_r22);
IkReal x249=((-1.0)+x247+(((-1.0)*x247*(new_r22*new_r22))));
j21eval[0]=x249;
j21eval[1]=((IKabs(((((-1.0)*new_r00*x248))+((new_r01*sj19)))))+(IKabs((((new_r01*x248))+((new_r00*sj19))))));
j21eval[2]=IKsign(x249);
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal j21eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j21eval[0]=new_r22;
if( IKabs(j21eval[0]) < 0.0000010000000000  )
{
{
IkReal j21eval[2];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x250=new_r22*new_r22;
j21eval[0]=(((cj19*x250))+(((-1.0)*cj19)));
j21eval[1]=(((sj19*x250))+(((-1.0)*sj19)));
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j19)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x251=IKsin(j21);
IkReal x252=IKcos(j21);
evalcond[0]=x251;
evalcond[1]=((-1.0)*x252);
evalcond[2]=((((-1.0)*new_r00))+(((-1.0)*x251)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x252)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j19)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r00, new_r01);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x253=IKsin(j21);
IkReal x254=IKcos(j21);
evalcond[0]=x253;
evalcond[1]=((-1.0)*x254);
evalcond[2]=(new_r00+(((-1.0)*x253)));
evalcond[3]=(new_r01+(((-1.0)*x254)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j19))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r10, new_r11);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x255=IKsin(j21);
IkReal x256=IKcos(j21);
evalcond[0]=x255;
evalcond[1]=((-1.0)*x256);
evalcond[2]=(new_r10+(((-1.0)*x255)));
evalcond[3]=(new_r11+(((-1.0)*x256)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j19)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x257=IKsin(j21);
IkReal x258=IKcos(j21);
evalcond[0]=x257;
evalcond[1]=((-1.0)*x258);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x257)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x258)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x259=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x259.valid){
continue;
}
if((x259.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x259.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj19)))))+(IKabs((cj19+(((-1.0)*gconst36)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
sj19=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
cj19=gconst36;
if( (gconst36) < -1-IKFAST_SINCOS_THRESH || (gconst36) > 1+IKFAST_SINCOS_THRESH )
    continue;
j19=IKacos(gconst36);
CheckValue<IkReal> x260=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x260.valid){
continue;
}
if((x260.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x260.value)));
j21eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j21eval[0]) < 0.0000010000000000  )
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
CheckValue<IkReal> x261=IKPowWithIntegerCheck(gconst36,-1);
if(!x261.valid){
continue;
}
if( IKabs((((gconst36*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x261.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst36*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))))+IKsqr((new_r11*(x261.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((((gconst36*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))), (new_r11*(x261.value)));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x262=IKcos(j21);
IkReal x263=IKsin(j21);
IkReal x264=((1.0)*x263);
IkReal x265=((1.0)*x262);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x266=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
IkReal x267=((1.0)*x266);
evalcond[0]=x263;
evalcond[1]=((-1.0)*x262);
evalcond[2]=((((-1.0)*gconst36*x265))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x264))+new_r10);
evalcond[4]=(((x262*x266))+new_r01);
evalcond[5]=(((x263*x266))+new_r00);
evalcond[6]=((((-1.0)*new_r00*x267))+((gconst36*new_r10))+(((-1.0)*x264)));
evalcond[7]=((((-1.0)*new_r01*x267))+((gconst36*new_r11))+(((-1.0)*x265)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x268 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x268.valid){
continue;
}
CheckValue<IkReal> x269=IKPowWithIntegerCheck(IKsign(gconst36),-1);
if(!x269.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(x268.value)+(((1.5707963267949)*(x269.value))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x270=IKcos(j21);
IkReal x271=IKsin(j21);
IkReal x272=((1.0)*x271);
IkReal x273=((1.0)*x270);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x274=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
IkReal x275=((1.0)*x274);
evalcond[0]=x271;
evalcond[1]=((-1.0)*x270);
evalcond[2]=((((-1.0)*gconst36*x273))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x272))+new_r10);
evalcond[4]=(((x270*x274))+new_r01);
evalcond[5]=(((x271*x274))+new_r00);
evalcond[6]=((((-1.0)*new_r00*x275))+((gconst36*new_r10))+(((-1.0)*x272)));
evalcond[7]=((((-1.0)*new_r01*x275))+((gconst36*new_r11))+(((-1.0)*x273)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x276=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x276.valid){
continue;
}
if((x276.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x276.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj19)))))+(IKabs((cj19+(((-1.0)*gconst36)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
sj19=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))))));
cj19=gconst36;
if( (gconst36) < -1-IKFAST_SINCOS_THRESH || (gconst36) > 1+IKFAST_SINCOS_THRESH )
    continue;
j19=((-1.0)*(IKacos(gconst36)));
CheckValue<IkReal> x277=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x277.valid){
continue;
}
if((x277.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x277.value)));
j21eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j21eval[0]) < 0.0000010000000000  )
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
CheckValue<IkReal> x278=IKPowWithIntegerCheck(gconst36,-1);
if(!x278.valid){
continue;
}
if( IKabs((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))+((gconst36*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x278.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))+((gconst36*new_r10))))+IKsqr((new_r11*(x278.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))+((gconst36*new_r10))), (new_r11*(x278.value)));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x279=IKcos(j21);
IkReal x280=IKsin(j21);
IkReal x281=((1.0)*x280);
IkReal x282=((1.0)*x279);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x283=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
evalcond[0]=x280;
evalcond[1]=((-1.0)*x279);
evalcond[2]=((((-1.0)*gconst36*x282))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x281))+new_r10);
evalcond[4]=((((-1.0)*x282*x283))+new_r01);
evalcond[5]=((((-1.0)*x281*x283))+new_r00);
evalcond[6]=(((gconst36*new_r10))+(((-1.0)*x281))+((new_r00*x283)));
evalcond[7]=(((gconst36*new_r11))+(((-1.0)*x282))+((new_r01*x283)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x285 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x285.valid){
continue;
}
CheckValue<IkReal> x286=IKPowWithIntegerCheck(IKsign(gconst36),-1);
if(!x286.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(x285.value)+(((1.5707963267949)*(x286.value))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x287=IKcos(j21);
IkReal x288=IKsin(j21);
IkReal x289=((1.0)*x288);
IkReal x290=((1.0)*x287);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x291=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
evalcond[0]=x288;
evalcond[1]=((-1.0)*x287);
evalcond[2]=((((-1.0)*gconst36*x290))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x289))+new_r10);
evalcond[4]=((((-1.0)*x290*x291))+new_r01);
evalcond[5]=((((-1.0)*x289*x291))+new_r00);
evalcond[6]=(((new_r00*x291))+((gconst36*new_r10))+(((-1.0)*x289)));
evalcond[7]=((((-1.0)*x290))+((new_r01*x291))+((gconst36*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x293=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x293.valid){
continue;
}
if((x293.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x293.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj19)))))+(IKabs((cj19+(((-1.0)*gconst37)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
sj19=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
cj19=gconst37;
if( (gconst37) < -1-IKFAST_SINCOS_THRESH || (gconst37) > 1+IKFAST_SINCOS_THRESH )
    continue;
j19=IKacos(gconst37);
CheckValue<IkReal> x294=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x294.valid){
continue;
}
if((x294.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x294.value);
j21eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j21eval[0]) < 0.0000010000000000  )
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
CheckValue<IkReal> x295=IKPowWithIntegerCheck(gconst37,-1);
if(!x295.valid){
continue;
}
if( IKabs(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))+((gconst37*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x295.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))+((gconst37*new_r10))))+IKsqr((new_r11*(x295.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))+((gconst37*new_r10))), (new_r11*(x295.value)));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x296=IKcos(j21);
IkReal x297=IKsin(j21);
IkReal x298=((1.0)*x297);
IkReal x299=((1.0)*x296);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x300=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
IkReal x301=((1.0)*x300);
evalcond[0]=x297;
evalcond[1]=((-1.0)*x296);
evalcond[2]=((((-1.0)*gconst37*x299))+new_r11);
evalcond[3]=((((-1.0)*gconst37*x298))+new_r10);
evalcond[4]=(((x296*x300))+new_r01);
evalcond[5]=(((x297*x300))+new_r00);
evalcond[6]=((((-1.0)*x298))+((gconst37*new_r10))+(((-1.0)*new_r00*x301)));
evalcond[7]=((((-1.0)*x299))+(((-1.0)*new_r01*x301))+((gconst37*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x302=IKPowWithIntegerCheck(IKsign(gconst37),-1);
if(!x302.valid){
continue;
}
CheckValue<IkReal> x303 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x303.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(((1.5707963267949)*(x302.value)))+(x303.value));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x304=IKcos(j21);
IkReal x305=IKsin(j21);
IkReal x306=((1.0)*x305);
IkReal x307=((1.0)*x304);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x308=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
IkReal x309=((1.0)*x308);
evalcond[0]=x305;
evalcond[1]=((-1.0)*x304);
evalcond[2]=(new_r11+(((-1.0)*gconst37*x307)));
evalcond[3]=(new_r10+(((-1.0)*gconst37*x306)));
evalcond[4]=(((x304*x308))+new_r01);
evalcond[5]=(((x305*x308))+new_r00);
evalcond[6]=(((gconst37*new_r10))+(((-1.0)*new_r00*x309))+(((-1.0)*x306)));
evalcond[7]=((((-1.0)*new_r01*x309))+((gconst37*new_r11))+(((-1.0)*x307)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x310=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x310.valid){
continue;
}
if((x310.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x310.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj19)))))+(IKabs((cj19+(((-1.0)*gconst37)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
sj19=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))))));
cj19=gconst37;
if( (gconst37) < -1-IKFAST_SINCOS_THRESH || (gconst37) > 1+IKFAST_SINCOS_THRESH )
    continue;
j19=((-1.0)*(IKacos(gconst37)));
CheckValue<IkReal> x311=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x311.valid){
continue;
}
if((x311.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x311.value);
j21eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j21eval[0]) < 0.0000010000000000  )
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
CheckValue<IkReal> x312=IKPowWithIntegerCheck(gconst37,-1);
if(!x312.valid){
continue;
}
if( IKabs((((gconst37*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x312.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst37*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))))+IKsqr((new_r11*(x312.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((((gconst37*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))), (new_r11*(x312.value)));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x313=IKcos(j21);
IkReal x314=IKsin(j21);
IkReal x315=((1.0)*x313);
IkReal x316=((1.0)*x314);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x317=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
evalcond[0]=x314;
evalcond[1]=((-1.0)*x313);
evalcond[2]=((((-1.0)*gconst37*x315))+new_r11);
evalcond[3]=((((-1.0)*gconst37*x316))+new_r10);
evalcond[4]=((((-1.0)*x315*x317))+new_r01);
evalcond[5]=(new_r00+(((-1.0)*x316*x317)));
evalcond[6]=(((new_r00*x317))+(((-1.0)*x316))+((gconst37*new_r10)));
evalcond[7]=(((new_r01*x317))+(((-1.0)*x315))+((gconst37*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x318=IKPowWithIntegerCheck(IKsign(gconst37),-1);
if(!x318.valid){
continue;
}
CheckValue<IkReal> x319 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x319.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(((1.5707963267949)*(x318.value)))+(x319.value));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x320=IKcos(j21);
IkReal x321=IKsin(j21);
IkReal x322=((1.0)*x320);
IkReal x323=((1.0)*x321);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x324=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
evalcond[0]=x321;
evalcond[1]=((-1.0)*x320);
evalcond[2]=((((-1.0)*gconst37*x322))+new_r11);
evalcond[3]=((((-1.0)*gconst37*x323))+new_r10);
evalcond[4]=((((-1.0)*x322*x324))+new_r01);
evalcond[5]=((((-1.0)*x323*x324))+new_r00);
evalcond[6]=(((new_r00*x324))+(((-1.0)*x323))+((gconst37*new_r10)));
evalcond[7]=(((new_r01*x324))+(((-1.0)*x322))+((gconst37*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j21]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
IkReal x325=new_r22*new_r22;
CheckValue<IkReal> x326=IKPowWithIntegerCheck((((cj19*x325))+(((-1.0)*cj19))),-1);
if(!x326.valid){
continue;
}
CheckValue<IkReal> x327=IKPowWithIntegerCheck((((sj19*x325))+(((-1.0)*sj19))),-1);
if(!x327.valid){
continue;
}
if( IKabs(((x326.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x327.value)*((((new_r10*new_r22))+new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x326.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))))+IKsqr(((x327.value)*((((new_r10*new_r22))+new_r01))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((x326.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))), ((x327.value)*((((new_r10*new_r22))+new_r01))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[10];
IkReal x328=IKsin(j21);
IkReal x329=IKcos(j21);
IkReal x330=(cj19*new_r22);
IkReal x331=(new_r22*sj19);
IkReal x332=((1.0)*sj19);
IkReal x333=((1.0)*x329);
IkReal x334=((1.0)*x328);
evalcond[0]=(((new_r22*x328))+((cj19*new_r01))+((new_r11*sj19)));
evalcond[1]=(((new_r01*x330))+((new_r11*x331))+x328);
evalcond[2]=((((-1.0)*new_r00*x332))+(((-1.0)*x334))+((cj19*new_r10)));
evalcond[3]=((((-1.0)*x333))+((cj19*new_r11))+(((-1.0)*new_r01*x332)));
evalcond[4]=(((sj19*x329))+((x328*x330))+new_r01);
evalcond[5]=((((-1.0)*new_r22*x333))+((new_r10*sj19))+((cj19*new_r00)));
evalcond[6]=(((sj19*x328))+(((-1.0)*x330*x333))+new_r00);
evalcond[7]=((((-1.0)*cj19*x333))+((x328*x331))+new_r11);
evalcond[8]=(((new_r00*x330))+((new_r10*x331))+(((-1.0)*x333)));
evalcond[9]=((((-1.0)*cj19*x334))+(((-1.0)*x331*x333))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
IkReal x335=((1.0)*new_r01);
CheckValue<IkReal> x336=IKPowWithIntegerCheck(new_r22,-1);
if(!x336.valid){
continue;
}
if( IKabs(((x336.value)*(((((-1.0)*cj19*x335))+(((-1.0)*new_r11*sj19)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*sj19*x335))+((cj19*new_r11)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x336.value)*(((((-1.0)*cj19*x335))+(((-1.0)*new_r11*sj19))))))+IKsqr(((((-1.0)*sj19*x335))+((cj19*new_r11))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((x336.value)*(((((-1.0)*cj19*x335))+(((-1.0)*new_r11*sj19))))), ((((-1.0)*sj19*x335))+((cj19*new_r11))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[10];
IkReal x337=IKsin(j21);
IkReal x338=IKcos(j21);
IkReal x339=(cj19*new_r22);
IkReal x340=(new_r22*sj19);
IkReal x341=((1.0)*sj19);
IkReal x342=((1.0)*x338);
IkReal x343=((1.0)*x337);
evalcond[0]=(((new_r22*x337))+((cj19*new_r01))+((new_r11*sj19)));
evalcond[1]=(((new_r01*x339))+((new_r11*x340))+x337);
evalcond[2]=((((-1.0)*new_r00*x341))+((cj19*new_r10))+(((-1.0)*x343)));
evalcond[3]=((((-1.0)*new_r01*x341))+((cj19*new_r11))+(((-1.0)*x342)));
evalcond[4]=(((sj19*x338))+((x337*x339))+new_r01);
evalcond[5]=(((new_r10*sj19))+((cj19*new_r00))+(((-1.0)*new_r22*x342)));
evalcond[6]=(((sj19*x337))+new_r00+(((-1.0)*x339*x342)));
evalcond[7]=(((x337*x340))+(((-1.0)*cj19*x342))+new_r11);
evalcond[8]=(((new_r00*x339))+((new_r10*x340))+(((-1.0)*x342)));
evalcond[9]=((((-1.0)*cj19*x343))+(((-1.0)*x340*x342))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
IkReal x344=cj19*cj19;
IkReal x345=(cj19*new_r22);
CheckValue<IkReal> x346 = IKatan2WithCheck(IkReal((((new_r01*x345))+((new_r00*sj19)))),IkReal(((((-1.0)*new_r00*x345))+((new_r01*sj19)))),IKFAST_ATAN2_MAGTHRESH);
if(!x346.valid){
continue;
}
CheckValue<IkReal> x347=IKPowWithIntegerCheck(IKsign(((-1.0)+(((-1.0)*x344*(new_r22*new_r22)))+x344)),-1);
if(!x347.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(x346.value)+(((1.5707963267949)*(x347.value))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[10];
IkReal x348=IKsin(j21);
IkReal x349=IKcos(j21);
IkReal x350=(cj19*new_r22);
IkReal x351=(new_r22*sj19);
IkReal x352=((1.0)*sj19);
IkReal x353=((1.0)*x349);
IkReal x354=((1.0)*x348);
evalcond[0]=(((new_r22*x348))+((cj19*new_r01))+((new_r11*sj19)));
evalcond[1]=(((new_r01*x350))+x348+((new_r11*x351)));
evalcond[2]=((((-1.0)*x354))+(((-1.0)*new_r00*x352))+((cj19*new_r10)));
evalcond[3]=((((-1.0)*x353))+(((-1.0)*new_r01*x352))+((cj19*new_r11)));
evalcond[4]=(((sj19*x349))+((x348*x350))+new_r01);
evalcond[5]=((((-1.0)*new_r22*x353))+((new_r10*sj19))+((cj19*new_r00)));
evalcond[6]=(((sj19*x348))+new_r00+(((-1.0)*x350*x353)));
evalcond[7]=((((-1.0)*cj19*x353))+((x348*x351))+new_r11);
evalcond[8]=((((-1.0)*x353))+((new_r10*x351))+((new_r00*x350)));
evalcond[9]=((((-1.0)*cj19*x354))+(((-1.0)*x351*x353))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j19, j21]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
CheckValue<IkReal> x356=IKPowWithIntegerCheck(sj20,-1);
if(!x356.valid){
continue;
}
IkReal x355=x356.value;
CheckValue<IkReal> x357=IKPowWithIntegerCheck(new_r12,-1);
if(!x357.valid){
continue;
}
if( IKabs((x355*(x357.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj20*cj20))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x355)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x355*(x357.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj20*cj20)))))))+IKsqr((new_r02*x355))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19array[0]=IKatan2((x355*(x357.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj20*cj20)))))), (new_r02*x355));
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[8];
IkReal x358=IKcos(j19);
IkReal x359=IKsin(j19);
IkReal x360=((1.0)*sj20);
IkReal x361=(new_r02*x358);
IkReal x362=(new_r12*x359);
IkReal x363=(sj20*x358);
IkReal x364=(sj20*x359);
evalcond[0]=((((-1.0)*x358*x360))+new_r02);
evalcond[1]=((((-1.0)*x359*x360))+new_r12);
evalcond[2]=((((-1.0)*new_r02*x359))+((new_r12*x358)));
evalcond[3]=((((-1.0)*x360))+x361+x362);
evalcond[4]=(((new_r00*x363))+((cj20*new_r20))+((new_r10*x364)));
evalcond[5]=(((new_r01*x363))+((cj20*new_r21))+((new_r11*x364)));
evalcond[6]=((-1.0)+((cj20*new_r22))+((sj20*x361))+((sj20*x362)));
evalcond[7]=((((-1.0)*new_r22*x360))+((cj20*x362))+((cj20*x361)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j21eval[3];
j21eval[0]=sj20;
j21eval[1]=((IKabs(new_r20))+(IKabs(new_r21)));
j21eval[2]=IKsign(sj20);
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal j21eval[2];
j21eval[0]=sj20;
j21eval[1]=sj19;
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  )
{
{
IkReal j21eval[3];
j21eval[0]=cj20;
j21eval[1]=sj19;
j21eval[2]=sj20;
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x365=IKcos(j21);
IkReal x366=IKsin(j21);
IkReal x367=((1.0)*cj19);
IkReal x368=((1.0)*sj19);
IkReal x369=((1.0)*x366);
evalcond[0]=(x365+new_r20);
evalcond[1]=((((-1.0)*x369))+new_r21);
evalcond[2]=(((sj19*x365))+new_r01);
evalcond[3]=(((sj19*x366))+new_r00);
evalcond[4]=(new_r11+(((-1.0)*x365*x367)));
evalcond[5]=((((-1.0)*x366*x367))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x368))+(((-1.0)*x369))+((cj19*new_r10)));
evalcond[7]=((((-1.0)*x365))+((cj19*new_r11))+(((-1.0)*new_r01*x368)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x370=IKcos(j21);
IkReal x371=IKsin(j21);
IkReal x372=((1.0)*cj19);
IkReal x373=((1.0)*sj19);
IkReal x374=((1.0)*x370);
evalcond[0]=(x371+new_r21);
evalcond[1]=((((-1.0)*x374))+new_r20);
evalcond[2]=(((sj19*x370))+new_r01);
evalcond[3]=(((sj19*x371))+new_r00);
evalcond[4]=((((-1.0)*x370*x372))+new_r11);
evalcond[5]=((((-1.0)*x371*x372))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x373))+(((-1.0)*x371))+((cj19*new_r10)));
evalcond[7]=((((-1.0)*x374))+((cj19*new_r11))+(((-1.0)*new_r01*x373)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j19))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r10, new_r11);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x375=IKcos(j21);
IkReal x376=IKsin(j21);
IkReal x377=((1.0)*sj20);
IkReal x378=((1.0)*x375);
IkReal x379=((1.0)*x376);
evalcond[0]=(new_r20+((sj20*x375)));
evalcond[1]=((((-1.0)*x379))+new_r10);
evalcond[2]=((((-1.0)*x378))+new_r11);
evalcond[3]=(new_r01+((cj20*x376)));
evalcond[4]=((((-1.0)*x376*x377))+new_r21);
evalcond[5]=((((-1.0)*cj20*x378))+new_r00);
evalcond[6]=((((-1.0)*new_r21*x377))+((cj20*new_r01))+x376);
evalcond[7]=((((-1.0)*new_r20*x377))+((cj20*new_r00))+(((-1.0)*x378)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j19)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[3];
sj19=0;
cj19=-1.0;
j19=3.14159265358979;
j21eval[0]=sj20;
j21eval[1]=((IKabs(new_r20))+(IKabs(new_r21)));
j21eval[2]=IKsign(sj20);
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal j21eval[1];
sj19=0;
cj19=-1.0;
j19=3.14159265358979;
j21eval[0]=sj20;
if( IKabs(j21eval[0]) < 0.0000010000000000  )
{
{
IkReal j21eval[2];
sj19=0;
cj19=-1.0;
j19=3.14159265358979;
j21eval[0]=cj20;
j21eval[1]=sj20;
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x380=IKcos(j21);
IkReal x381=((1.0)*(IKsin(j21)));
evalcond[0]=(x380+new_r20);
evalcond[1]=((((-1.0)*x381))+new_r21);
evalcond[2]=((((-1.0)*x381))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x380))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x382=IKsin(j21);
IkReal x383=((1.0)*(IKcos(j21)));
evalcond[0]=(x382+new_r21);
evalcond[1]=((((-1.0)*x383))+new_r20);
evalcond[2]=((((-1.0)*x382))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x383))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j20))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x384=IKsin(j21);
IkReal x385=((1.0)*(IKcos(j21)));
evalcond[0]=(x384+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*x384))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*x385))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x385))+(((-1.0)*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j20)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x386=IKcos(j21);
IkReal x387=((1.0)*(IKsin(j21)));
evalcond[0]=(x386+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*x387))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*x386))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x387))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[6];
IkReal x388=IKsin(j21);
IkReal x389=IKcos(j21);
IkReal x390=((-1.0)*x389);
evalcond[0]=x388;
evalcond[1]=(new_r22*x388);
evalcond[2]=x390;
evalcond[3]=(new_r22*x390);
evalcond[4]=((((-1.0)*x388))+(((-1.0)*new_r10)));
evalcond[5]=((((-1.0)*x389))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j21]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x391=IKPowWithIntegerCheck(cj20,-1);
if(!x391.valid){
continue;
}
CheckValue<IkReal> x392=IKPowWithIntegerCheck(sj20,-1);
if(!x392.valid){
continue;
}
if( IKabs((new_r01*(x391.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x392.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x391.value)))+IKsqr(((-1.0)*new_r20*(x392.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((new_r01*(x391.value)), ((-1.0)*new_r20*(x392.value)));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x393=IKsin(j21);
IkReal x394=IKcos(j21);
IkReal x395=((1.0)*sj20);
IkReal x396=((1.0)*new_r00);
IkReal x397=((1.0)*new_r01);
IkReal x398=((1.0)*x394);
IkReal x399=((1.0)*x393);
evalcond[0]=(new_r20+((sj20*x394)));
evalcond[1]=(new_r21+(((-1.0)*x393*x395)));
evalcond[2]=((((-1.0)*x399))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x398))+(((-1.0)*new_r11)));
evalcond[4]=((((-1.0)*x397))+((cj20*x393)));
evalcond[5]=((((-1.0)*cj20*x398))+(((-1.0)*x396)));
evalcond[6]=((((-1.0)*cj20*x397))+(((-1.0)*new_r21*x395))+x393);
evalcond[7]=((((-1.0)*cj20*x396))+(((-1.0)*x398))+(((-1.0)*new_r20*x395)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x400=IKPowWithIntegerCheck(sj20,-1);
if(!x400.valid){
continue;
}
if( IKabs((new_r21*(x400.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x400.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((new_r21*(x400.value)), ((-1.0)*new_r11));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x401=IKsin(j21);
IkReal x402=IKcos(j21);
IkReal x403=((1.0)*sj20);
IkReal x404=((1.0)*new_r00);
IkReal x405=((1.0)*new_r01);
IkReal x406=((1.0)*x402);
IkReal x407=((1.0)*x401);
evalcond[0]=(((sj20*x402))+new_r20);
evalcond[1]=((((-1.0)*x401*x403))+new_r21);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x407)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x406)));
evalcond[4]=(((cj20*x401))+(((-1.0)*x405)));
evalcond[5]=((((-1.0)*cj20*x406))+(((-1.0)*x404)));
evalcond[6]=((((-1.0)*cj20*x405))+x401+(((-1.0)*new_r21*x403)));
evalcond[7]=((((-1.0)*cj20*x404))+(((-1.0)*new_r20*x403))+(((-1.0)*x406)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x408=IKPowWithIntegerCheck(IKsign(sj20),-1);
if(!x408.valid){
continue;
}
CheckValue<IkReal> x409 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x409.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(((1.5707963267949)*(x408.value)))+(x409.value));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x410=IKsin(j21);
IkReal x411=IKcos(j21);
IkReal x412=((1.0)*sj20);
IkReal x413=((1.0)*new_r00);
IkReal x414=((1.0)*new_r01);
IkReal x415=((1.0)*x411);
IkReal x416=((1.0)*x410);
evalcond[0]=(((sj20*x411))+new_r20);
evalcond[1]=((((-1.0)*x410*x412))+new_r21);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x416)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x415)));
evalcond[4]=(((cj20*x410))+(((-1.0)*x414)));
evalcond[5]=((((-1.0)*cj20*x415))+(((-1.0)*x413)));
evalcond[6]=((((-1.0)*cj20*x414))+x410+(((-1.0)*new_r21*x412)));
evalcond[7]=((((-1.0)*cj20*x413))+(((-1.0)*new_r20*x412))+(((-1.0)*x415)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j20))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
IkReal x417=((1.0)*sj19);
if( IKabs(((((-1.0)*cj19*new_r01))+(((-1.0)*new_r00*x417)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj19*new_r00))+(((-1.0)*new_r01*x417)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj19*new_r01))+(((-1.0)*new_r00*x417))))+IKsqr((((cj19*new_r00))+(((-1.0)*new_r01*x417))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((((-1.0)*cj19*new_r01))+(((-1.0)*new_r00*x417))), (((cj19*new_r00))+(((-1.0)*new_r01*x417))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x418=IKsin(j21);
IkReal x419=IKcos(j21);
IkReal x420=((1.0)*sj19);
IkReal x421=((1.0)*x419);
IkReal x422=(sj19*x418);
IkReal x423=((1.0)*x418);
IkReal x424=(cj19*x421);
evalcond[0]=(x418+((cj19*new_r01))+((new_r11*sj19)));
evalcond[1]=(((cj19*x418))+new_r01+((sj19*x419)));
evalcond[2]=((((-1.0)*x421))+((new_r10*sj19))+((cj19*new_r00)));
evalcond[3]=((((-1.0)*new_r00*x420))+(((-1.0)*x423))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*x421))+((cj19*new_r11))+(((-1.0)*new_r01*x420)));
evalcond[5]=((((-1.0)*x424))+x422+new_r00);
evalcond[6]=((((-1.0)*x424))+x422+new_r11);
evalcond[7]=((((-1.0)*x419*x420))+new_r10+(((-1.0)*cj19*x423)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j20)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
IkReal x425=((1.0)*sj19);
if( IKabs(((((-1.0)*new_r00*x425))+((cj19*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*cj19*new_r00))+(((-1.0)*new_r01*x425)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x425))+((cj19*new_r01))))+IKsqr(((((-1.0)*cj19*new_r00))+(((-1.0)*new_r01*x425))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((((-1.0)*new_r00*x425))+((cj19*new_r01))), ((((-1.0)*cj19*new_r00))+(((-1.0)*new_r01*x425))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x426=IKsin(j21);
IkReal x427=IKcos(j21);
IkReal x428=((1.0)*cj19);
IkReal x429=((1.0)*sj19);
IkReal x430=((1.0)*x426);
IkReal x431=(sj19*x427);
IkReal x432=(sj19*x426);
IkReal x433=(x426*x428);
evalcond[0]=(x427+((new_r10*sj19))+((cj19*new_r00)));
evalcond[1]=((((-1.0)*x430))+((cj19*new_r01))+((new_r11*sj19)));
evalcond[2]=(((cj19*x427))+x432+new_r00);
evalcond[3]=((((-1.0)*x430))+(((-1.0)*new_r00*x429))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*x427))+((cj19*new_r11))+(((-1.0)*new_r01*x429)));
evalcond[5]=((((-1.0)*x433))+x431+new_r01);
evalcond[6]=((((-1.0)*x433))+x431+new_r10);
evalcond[7]=((((-1.0)*x427*x428))+(((-1.0)*x426*x429))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j21eval[0]=1.0;
if( IKabs(j21eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j21]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=1.0;
op[1]=0;
op[2]=-1.0;
polyroots2(op,zeror,numroots);
IkReal j21array[2], cj21array[2], sj21array[2], tempj21array[1];
int numsolutions = 0;
for(int ij21 = 0; ij21 < numroots; ++ij21)
{
IkReal htj21 = zeror[ij21];
tempj21array[0]=((2.0)*(atan(htj21)));
for(int kj21 = 0; kj21 < 1; ++kj21)
{
j21array[numsolutions] = tempj21array[kj21];
if( j21array[numsolutions] > IKPI )
{
    j21array[numsolutions]-=IK2PI;
}
else if( j21array[numsolutions] < -IKPI )
{
    j21array[numsolutions]+=IK2PI;
}
sj21array[numsolutions] = IKsin(j21array[numsolutions]);
cj21array[numsolutions] = IKcos(j21array[numsolutions]);
numsolutions++;
}
}
bool j21valid[2]={true,true};
_nj21 = 2;
for(int ij21 = 0; ij21 < numsolutions; ++ij21)
    {
if( !j21valid[ij21] )
{
    continue;
}
    j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
htj21 = IKtan(j21/2);

_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < numsolutions; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j21]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x435=IKPowWithIntegerCheck(sj20,-1);
if(!x435.valid){
continue;
}
IkReal x434=x435.value;
CheckValue<IkReal> x436=IKPowWithIntegerCheck(cj20,-1);
if(!x436.valid){
continue;
}
CheckValue<IkReal> x437=IKPowWithIntegerCheck(sj19,-1);
if(!x437.valid){
continue;
}
if( IKabs((x434*(x436.value)*(x437.value)*(((((-1.0)*new_r11*sj20))+(((-1.0)*cj19*new_r20)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x434)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x434*(x436.value)*(x437.value)*(((((-1.0)*new_r11*sj20))+(((-1.0)*cj19*new_r20))))))+IKsqr(((-1.0)*new_r20*x434))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((x434*(x436.value)*(x437.value)*(((((-1.0)*new_r11*sj20))+(((-1.0)*cj19*new_r20))))), ((-1.0)*new_r20*x434));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[12];
IkReal x438=IKsin(j21);
IkReal x439=IKcos(j21);
IkReal x440=(cj20*sj19);
IkReal x441=(cj19*new_r01);
IkReal x442=((1.0)*sj20);
IkReal x443=(cj19*new_r00);
IkReal x444=((1.0)*sj19);
IkReal x445=((1.0)*x439);
IkReal x446=(cj20*x438);
IkReal x447=((1.0)*x438);
IkReal x448=(cj19*x445);
evalcond[0]=(((sj20*x439))+new_r20);
evalcond[1]=((((-1.0)*x438*x442))+new_r21);
evalcond[2]=(x446+x441+((new_r11*sj19)));
evalcond[3]=((((-1.0)*x447))+(((-1.0)*new_r00*x444))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*x445))+(((-1.0)*new_r01*x444))+((cj19*new_r11)));
evalcond[5]=(((cj19*x446))+((sj19*x439))+new_r01);
evalcond[6]=((((-1.0)*cj20*x445))+x443+((new_r10*sj19)));
evalcond[7]=(((sj19*x438))+(((-1.0)*cj20*x448))+new_r00);
evalcond[8]=((((-1.0)*x448))+((x438*x440))+new_r11);
evalcond[9]=((((-1.0)*cj19*x447))+new_r10+(((-1.0)*x440*x445)));
evalcond[10]=(((new_r11*x440))+x438+((cj20*x441))+(((-1.0)*new_r21*x442)));
evalcond[11]=((((-1.0)*x445))+((new_r10*x440))+(((-1.0)*new_r20*x442))+((cj20*x443)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x450=IKPowWithIntegerCheck(sj20,-1);
if(!x450.valid){
continue;
}
IkReal x449=x450.value;
CheckValue<IkReal> x451=IKPowWithIntegerCheck(sj19,-1);
if(!x451.valid){
continue;
}
if( IKabs((new_r21*x449)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x449*(x451.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj19*cj20*new_r21)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*x449))+IKsqr((x449*(x451.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj19*cj20*new_r21))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((new_r21*x449), (x449*(x451.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj19*cj20*new_r21))))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[12];
IkReal x452=IKsin(j21);
IkReal x453=IKcos(j21);
IkReal x454=(cj20*sj19);
IkReal x455=(cj19*new_r01);
IkReal x456=((1.0)*sj20);
IkReal x457=(cj19*new_r00);
IkReal x458=((1.0)*sj19);
IkReal x459=((1.0)*x453);
IkReal x460=(cj20*x452);
IkReal x461=((1.0)*x452);
IkReal x462=(cj19*x459);
evalcond[0]=(((sj20*x453))+new_r20);
evalcond[1]=((((-1.0)*x452*x456))+new_r21);
evalcond[2]=(x455+x460+((new_r11*sj19)));
evalcond[3]=((((-1.0)*x461))+(((-1.0)*new_r00*x458))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*new_r01*x458))+(((-1.0)*x459))+((cj19*new_r11)));
evalcond[5]=(((cj19*x460))+((sj19*x453))+new_r01);
evalcond[6]=(x457+((new_r10*sj19))+(((-1.0)*cj20*x459)));
evalcond[7]=(((sj19*x452))+new_r00+(((-1.0)*cj20*x462)));
evalcond[8]=(((x452*x454))+(((-1.0)*x462))+new_r11);
evalcond[9]=((((-1.0)*cj19*x461))+(((-1.0)*x454*x459))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x456))+((new_r11*x454))+((cj20*x455))+x452);
evalcond[11]=(((new_r10*x454))+(((-1.0)*new_r20*x456))+((cj20*x457))+(((-1.0)*x459)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x463=IKPowWithIntegerCheck(IKsign(sj20),-1);
if(!x463.valid){
continue;
}
CheckValue<IkReal> x464 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x464.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(((1.5707963267949)*(x463.value)))+(x464.value));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[12];
IkReal x465=IKsin(j21);
IkReal x466=IKcos(j21);
IkReal x467=(cj20*sj19);
IkReal x468=(cj19*new_r01);
IkReal x469=((1.0)*sj20);
IkReal x470=(cj19*new_r00);
IkReal x471=((1.0)*sj19);
IkReal x472=((1.0)*x466);
IkReal x473=(cj20*x465);
IkReal x474=((1.0)*x465);
IkReal x475=(cj19*x472);
evalcond[0]=(new_r20+((sj20*x466)));
evalcond[1]=((((-1.0)*x465*x469))+new_r21);
evalcond[2]=(x468+x473+((new_r11*sj19)));
evalcond[3]=((((-1.0)*new_r00*x471))+(((-1.0)*x474))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*x472))+(((-1.0)*new_r01*x471))+((cj19*new_r11)));
evalcond[5]=(((sj19*x466))+((cj19*x473))+new_r01);
evalcond[6]=(x470+(((-1.0)*cj20*x472))+((new_r10*sj19)));
evalcond[7]=(((sj19*x465))+new_r00+(((-1.0)*cj20*x475)));
evalcond[8]=(((x465*x467))+(((-1.0)*x475))+new_r11);
evalcond[9]=((((-1.0)*x467*x472))+(((-1.0)*cj19*x474))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x469))+((new_r11*x467))+((cj20*x468))+x465);
evalcond[11]=(((cj20*x470))+((new_r10*x467))+(((-1.0)*new_r20*x469))+(((-1.0)*x472)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x476=IKPowWithIntegerCheck(IKsign(sj20),-1);
if(!x476.valid){
continue;
}
CheckValue<IkReal> x477 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x477.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(((1.5707963267949)*(x476.value)))+(x477.value));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[2];
evalcond[0]=(((sj20*(IKcos(j21))))+new_r20);
evalcond[1]=((((-1.0)*sj20*(IKsin(j21))))+new_r21);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j19eval[3];
j19eval[0]=sj20;
j19eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j19eval[2]=IKsign(sj20);
if( IKabs(j19eval[0]) < 0.0000010000000000  || IKabs(j19eval[1]) < 0.0000010000000000  || IKabs(j19eval[2]) < 0.0000010000000000  )
{
{
IkReal j19eval[2];
j19eval[0]=cj21;
j19eval[1]=sj20;
if( IKabs(j19eval[0]) < 0.0000010000000000  || IKabs(j19eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j21)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19array[0]=IKatan2(((-1.0)*new_r00), new_r10);
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[18];
IkReal x478=IKsin(j19);
IkReal x479=IKcos(j19);
IkReal x480=((1.0)*sj20);
IkReal x481=(new_r11*x478);
IkReal x482=(new_r00*x479);
IkReal x483=(sj20*x478);
IkReal x484=(sj20*x479);
IkReal x485=((1.0)*x478);
IkReal x486=(new_r10*x478);
IkReal x487=(new_r02*x479);
IkReal x488=(new_r22*x478);
IkReal x489=(new_r01*x479);
evalcond[0]=(x478+new_r00);
evalcond[1]=(((new_r22*x479))+new_r01);
evalcond[2]=(x488+new_r11);
evalcond[3]=((((-1.0)*x479))+new_r10);
evalcond[4]=((((-1.0)*x479*x480))+new_r02);
evalcond[5]=(new_r12+(((-1.0)*x478*x480)));
evalcond[6]=(x482+x486);
evalcond[7]=(((new_r12*x479))+(((-1.0)*new_r02*x485)));
evalcond[8]=((((-1.0)*new_r01*x485))+((new_r11*x479)));
evalcond[9]=(x489+x481+new_r22);
evalcond[10]=((-1.0)+(((-1.0)*new_r00*x485))+((new_r10*x479)));
evalcond[11]=(((sj20*x482))+((new_r10*x483)));
evalcond[12]=(((new_r22*x482))+((new_r22*x486)));
evalcond[13]=(((new_r12*x478))+(((-1.0)*x480))+x487);
evalcond[14]=(((sj20*x481))+((cj20*new_r21))+((new_r01*x484)));
evalcond[15]=((-1.0)+(new_r22*new_r22)+((new_r02*x484))+((new_r12*x483)));
evalcond[16]=(((new_r12*x488))+(((-1.0)*new_r22*x480))+((new_r22*x487)));
evalcond[17]=((1.0)+((new_r22*x481))+((new_r22*x489))+(((-1.0)*sj20*x480)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j21)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19array[0]=IKatan2(new_r00, ((-1.0)*new_r10));
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[18];
IkReal x490=IKcos(j19);
IkReal x491=IKsin(j19);
IkReal x492=((1.0)*sj20);
IkReal x493=(new_r11*x491);
IkReal x494=(new_r00*x490);
IkReal x495=(sj20*x491);
IkReal x496=(new_r22*x490);
IkReal x497=(sj20*x490);
IkReal x498=((1.0)*x491);
IkReal x499=(new_r10*x491);
IkReal x500=(new_r12*x491);
evalcond[0]=(x490+new_r10);
evalcond[1]=((((-1.0)*x498))+new_r00);
evalcond[2]=((((-1.0)*x490*x492))+new_r02);
evalcond[3]=((((-1.0)*x491*x492))+new_r12);
evalcond[4]=((((-1.0)*x496))+new_r01);
evalcond[5]=((((-1.0)*new_r22*x498))+new_r11);
evalcond[6]=(x499+x494);
evalcond[7]=((((-1.0)*new_r02*x498))+((new_r12*x490)));
evalcond[8]=((((-1.0)*new_r01*x498))+((new_r11*x490)));
evalcond[9]=((1.0)+(((-1.0)*new_r00*x498))+((new_r10*x490)));
evalcond[10]=(((sj20*x494))+((new_r10*x495)));
evalcond[11]=(((new_r22*x494))+((new_r22*x499)));
evalcond[12]=(((new_r02*x490))+(((-1.0)*x492))+x500);
evalcond[13]=(x493+(((-1.0)*new_r22))+((new_r01*x490)));
evalcond[14]=(((sj20*x493))+((cj20*new_r21))+((new_r01*x497)));
evalcond[15]=((-1.0)+(new_r22*new_r22)+((new_r02*x497))+((new_r12*x495)));
evalcond[16]=(((new_r02*x496))+((new_r22*x500))+(((-1.0)*new_r22*x492)));
evalcond[17]=((-1.0)+(sj20*sj20)+((new_r22*x493))+((new_r01*x496)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j20))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
IkReal x501=((1.0)*sj21);
if( IKabs(((((-1.0)*new_r00*x501))+(((-1.0)*cj21*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r01*x501))+((cj21*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x501))+(((-1.0)*cj21*new_r01))))+IKsqr(((((-1.0)*new_r01*x501))+((cj21*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19array[0]=IKatan2(((((-1.0)*new_r00*x501))+(((-1.0)*cj21*new_r01))), ((((-1.0)*new_r01*x501))+((cj21*new_r00))));
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[8];
IkReal x502=IKcos(j19);
IkReal x503=IKsin(j19);
IkReal x504=((1.0)*cj21);
IkReal x505=(sj21*x503);
IkReal x506=((1.0)*x502);
IkReal x507=((1.0)*x503);
IkReal x508=(x502*x504);
evalcond[0]=(((new_r11*x503))+sj21+((new_r01*x502)));
evalcond[1]=(new_r01+((sj21*x502))+((cj21*x503)));
evalcond[2]=((((-1.0)*x508))+x505+new_r00);
evalcond[3]=((((-1.0)*x508))+x505+new_r11);
evalcond[4]=((((-1.0)*x504))+((new_r10*x503))+((new_r00*x502)));
evalcond[5]=((((-1.0)*x503*x504))+(((-1.0)*sj21*x506))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x507))+(((-1.0)*sj21))+((new_r10*x502)));
evalcond[7]=((((-1.0)*new_r01*x507))+(((-1.0)*x504))+((new_r11*x502)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j20)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
IkReal x509=((1.0)*new_r00);
if( IKabs(((((-1.0)*cj21*new_r01))+(((-1.0)*sj21*x509)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((new_r01*sj21))+(((-1.0)*cj21*x509)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj21*new_r01))+(((-1.0)*sj21*x509))))+IKsqr((((new_r01*sj21))+(((-1.0)*cj21*x509))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19array[0]=IKatan2(((((-1.0)*cj21*new_r01))+(((-1.0)*sj21*x509))), (((new_r01*sj21))+(((-1.0)*cj21*x509))));
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[8];
IkReal x510=IKcos(j19);
IkReal x511=IKsin(j19);
IkReal x512=((1.0)*sj21);
IkReal x513=(cj21*x511);
IkReal x514=((1.0)*x510);
IkReal x515=((1.0)*x511);
IkReal x516=(x510*x512);
evalcond[0]=(((new_r00*x510))+((new_r10*x511))+cj21);
evalcond[1]=(((cj21*x510))+((sj21*x511))+new_r00);
evalcond[2]=(x513+new_r01+(((-1.0)*x516)));
evalcond[3]=(x513+new_r10+(((-1.0)*x516)));
evalcond[4]=(((new_r01*x510))+((new_r11*x511))+(((-1.0)*x512)));
evalcond[5]=((((-1.0)*x511*x512))+(((-1.0)*cj21*x514))+new_r11);
evalcond[6]=(((new_r10*x510))+(((-1.0)*new_r00*x515))+(((-1.0)*x512)));
evalcond[7]=(((new_r11*x510))+(((-1.0)*cj21))+(((-1.0)*new_r01*x515)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j19eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j19eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j19eval[0]) < 0.0000010000000000  )
{
{
IkReal j19eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j19eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j19eval[0]) < 0.0000010000000000  )
{
{
IkReal j19eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j19eval[0]=((IKabs((new_r11*new_r22)))+(IKabs((new_r01*new_r22))));
if( IKabs(j19eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j19]

} else
{
{
IkReal j19array[2], cj19array[2], sj19array[2];
bool j19valid[2]={false};
_nj19 = 2;
CheckValue<IkReal> x518 = IKatan2WithCheck(IkReal((new_r01*new_r22)),IkReal((new_r11*new_r22)),IKFAST_ATAN2_MAGTHRESH);
if(!x518.valid){
continue;
}
IkReal x517=x518.value;
j19array[0]=((-1.0)*x517);
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
j19array[1]=((3.14159265358979)+(((-1.0)*x517)));
sj19array[1]=IKsin(j19array[1]);
cj19array[1]=IKcos(j19array[1]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
if( j19array[1] > IKPI )
{
    j19array[1]-=IK2PI;
}
else if( j19array[1] < -IKPI )
{    j19array[1]+=IK2PI;
}
j19valid[1] = true;
for(int ij19 = 0; ij19 < 2; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 2; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[5];
IkReal x519=IKcos(j19);
IkReal x520=IKsin(j19);
IkReal x521=(new_r10*x520);
IkReal x522=((1.0)*x520);
IkReal x523=(new_r00*x519);
evalcond[0]=(((new_r01*x519))+((new_r11*x520)));
evalcond[1]=(x523+x521);
evalcond[2]=(((new_r10*x519))+(((-1.0)*new_r00*x522)));
evalcond[3]=(((new_r11*x519))+(((-1.0)*new_r01*x522)));
evalcond[4]=(((new_r22*x521))+((new_r22*x523)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j19array[2], cj19array[2], sj19array[2];
bool j19valid[2]={false};
_nj19 = 2;
CheckValue<IkReal> x525 = IKatan2WithCheck(IkReal(new_r00),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x525.valid){
continue;
}
IkReal x524=x525.value;
j19array[0]=((-1.0)*x524);
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
j19array[1]=((3.14159265358979)+(((-1.0)*x524)));
sj19array[1]=IKsin(j19array[1]);
cj19array[1]=IKcos(j19array[1]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
if( j19array[1] > IKPI )
{
    j19array[1]-=IK2PI;
}
else if( j19array[1] < -IKPI )
{    j19array[1]+=IK2PI;
}
j19valid[1] = true;
for(int ij19 = 0; ij19 < 2; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 2; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[5];
IkReal x526=IKcos(j19);
IkReal x527=IKsin(j19);
IkReal x528=(new_r22*x527);
IkReal x529=((1.0)*x527);
IkReal x530=(new_r01*x526);
evalcond[0]=(((new_r11*x527))+x530);
evalcond[1]=((((-1.0)*new_r00*x529))+((new_r10*x526)));
evalcond[2]=(((new_r11*x526))+(((-1.0)*new_r01*x529)));
evalcond[3]=(((new_r11*x528))+((new_r22*x530)));
evalcond[4]=(((new_r00*new_r22*x526))+((new_r10*x528)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j19array[2], cj19array[2], sj19array[2];
bool j19valid[2]={false};
_nj19 = 2;
CheckValue<IkReal> x532 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x532.valid){
continue;
}
IkReal x531=x532.value;
j19array[0]=((-1.0)*x531);
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
j19array[1]=((3.14159265358979)+(((-1.0)*x531)));
sj19array[1]=IKsin(j19array[1]);
cj19array[1]=IKcos(j19array[1]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
if( j19array[1] > IKPI )
{
    j19array[1]-=IK2PI;
}
else if( j19array[1] < -IKPI )
{    j19array[1]+=IK2PI;
}
j19valid[1] = true;
for(int ij19 = 0; ij19 < 2; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 2; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[5];
IkReal x533=IKcos(j19);
IkReal x534=IKsin(j19);
IkReal x535=(new_r22*x534);
IkReal x536=((1.0)*x534);
IkReal x537=(new_r00*x533);
evalcond[0]=(((new_r10*x534))+x537);
evalcond[1]=((((-1.0)*new_r00*x536))+((new_r10*x533)));
evalcond[2]=(((new_r11*x533))+(((-1.0)*new_r01*x536)));
evalcond[3]=(((new_r11*x535))+((new_r01*new_r22*x533)));
evalcond[4]=(((new_r10*x535))+((new_r22*x537)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j19]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
CheckValue<IkReal> x539=IKPowWithIntegerCheck(sj20,-1);
if(!x539.valid){
continue;
}
IkReal x538=x539.value;
CheckValue<IkReal> x540=IKPowWithIntegerCheck(cj21,-1);
if(!x540.valid){
continue;
}
if( IKabs((x538*(x540.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj20*new_r02*sj21)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x538)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x538*(x540.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj20*new_r02*sj21))))))+IKsqr((new_r02*x538))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j19array[0]=IKatan2((x538*(x540.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj20*new_r02*sj21))))), (new_r02*x538));
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[18];
IkReal x541=IKcos(j19);
IkReal x542=IKsin(j19);
IkReal x543=((1.0)*cj21);
IkReal x544=((1.0)*sj21);
IkReal x545=((1.0)*sj20);
IkReal x546=(new_r11*x542);
IkReal x547=(new_r00*x541);
IkReal x548=(cj20*x542);
IkReal x549=(sj20*x542);
IkReal x550=(new_r01*x541);
IkReal x551=((1.0)*x542);
IkReal x552=(new_r02*x541);
IkReal x553=(cj20*x541);
evalcond[0]=((((-1.0)*x541*x545))+new_r02);
evalcond[1]=((((-1.0)*x542*x545))+new_r12);
evalcond[2]=(((new_r12*x541))+(((-1.0)*new_r02*x551)));
evalcond[3]=(((sj21*x553))+((cj21*x542))+new_r01);
evalcond[4]=(((new_r12*x542))+(((-1.0)*x545))+x552);
evalcond[5]=(x550+x546+((cj20*sj21)));
evalcond[6]=(((sj21*x542))+(((-1.0)*x543*x553))+new_r00);
evalcond[7]=((((-1.0)*x541*x543))+((sj21*x548))+new_r11);
evalcond[8]=(((new_r10*x541))+(((-1.0)*x544))+(((-1.0)*new_r00*x551)));
evalcond[9]=((((-1.0)*new_r01*x551))+((new_r11*x541))+(((-1.0)*x543)));
evalcond[10]=(((new_r10*x542))+x547+(((-1.0)*cj20*x543)));
evalcond[11]=((((-1.0)*x541*x544))+new_r10+(((-1.0)*x543*x548)));
evalcond[12]=(((sj20*x547))+((new_r10*x549))+((cj20*new_r20)));
evalcond[13]=(((sj20*x550))+((sj20*x546))+((cj20*new_r21)));
evalcond[14]=((-1.0)+((sj20*x552))+((new_r12*x549))+((cj20*new_r22)));
evalcond[15]=(((cj20*x552))+(((-1.0)*new_r22*x545))+((new_r12*x548)));
evalcond[16]=(((cj20*x550))+(((-1.0)*new_r21*x545))+sj21+((cj20*x546)));
evalcond[17]=(((new_r10*x548))+(((-1.0)*new_r20*x545))+(((-1.0)*x543))+((cj20*x547)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
CheckValue<IkReal> x554=IKPowWithIntegerCheck(IKsign(sj20),-1);
if(!x554.valid){
continue;
}
CheckValue<IkReal> x555 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x555.valid){
continue;
}
j19array[0]=((-1.5707963267949)+(((1.5707963267949)*(x554.value)))+(x555.value));
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[18];
IkReal x556=IKcos(j19);
IkReal x557=IKsin(j19);
IkReal x558=((1.0)*cj21);
IkReal x559=((1.0)*sj21);
IkReal x560=((1.0)*sj20);
IkReal x561=(new_r11*x557);
IkReal x562=(new_r00*x556);
IkReal x563=(cj20*x557);
IkReal x564=(sj20*x557);
IkReal x565=(new_r01*x556);
IkReal x566=((1.0)*x557);
IkReal x567=(new_r02*x556);
IkReal x568=(cj20*x556);
evalcond[0]=((((-1.0)*x556*x560))+new_r02);
evalcond[1]=((((-1.0)*x557*x560))+new_r12);
evalcond[2]=((((-1.0)*new_r02*x566))+((new_r12*x556)));
evalcond[3]=(((cj21*x557))+((sj21*x568))+new_r01);
evalcond[4]=(((new_r12*x557))+x567+(((-1.0)*x560)));
evalcond[5]=(x565+x561+((cj20*sj21)));
evalcond[6]=(((sj21*x557))+(((-1.0)*x558*x568))+new_r00);
evalcond[7]=((((-1.0)*x556*x558))+((sj21*x563))+new_r11);
evalcond[8]=((((-1.0)*new_r00*x566))+((new_r10*x556))+(((-1.0)*x559)));
evalcond[9]=(((new_r11*x556))+(((-1.0)*x558))+(((-1.0)*new_r01*x566)));
evalcond[10]=(((new_r10*x557))+x562+(((-1.0)*cj20*x558)));
evalcond[11]=((((-1.0)*x556*x559))+(((-1.0)*x558*x563))+new_r10);
evalcond[12]=(((sj20*x562))+((cj20*new_r20))+((new_r10*x564)));
evalcond[13]=(((sj20*x565))+((sj20*x561))+((cj20*new_r21)));
evalcond[14]=((-1.0)+((sj20*x567))+((cj20*new_r22))+((new_r12*x564)));
evalcond[15]=(((cj20*x567))+(((-1.0)*new_r22*x560))+((new_r12*x563)));
evalcond[16]=(sj21+((cj20*x561))+((cj20*x565))+(((-1.0)*new_r21*x560)));
evalcond[17]=((((-1.0)*new_r20*x560))+(((-1.0)*x558))+((cj20*x562))+((new_r10*x563)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j19array[1], cj19array[1], sj19array[1];
bool j19valid[1]={false};
_nj19 = 1;
CheckValue<IkReal> x569=IKPowWithIntegerCheck(IKsign(sj20),-1);
if(!x569.valid){
continue;
}
CheckValue<IkReal> x570 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x570.valid){
continue;
}
j19array[0]=((-1.5707963267949)+(((1.5707963267949)*(x569.value)))+(x570.value));
sj19array[0]=IKsin(j19array[0]);
cj19array[0]=IKcos(j19array[0]);
if( j19array[0] > IKPI )
{
    j19array[0]-=IK2PI;
}
else if( j19array[0] < -IKPI )
{    j19array[0]+=IK2PI;
}
j19valid[0] = true;
for(int ij19 = 0; ij19 < 1; ++ij19)
{
if( !j19valid[ij19] )
{
    continue;
}
_ij19[0] = ij19; _ij19[1] = -1;
for(int iij19 = ij19+1; iij19 < 1; ++iij19)
{
if( j19valid[iij19] && IKabs(cj19array[ij19]-cj19array[iij19]) < IKFAST_SOLUTION_THRESH && IKabs(sj19array[ij19]-sj19array[iij19]) < IKFAST_SOLUTION_THRESH )
{
    j19valid[iij19]=false; _ij19[1] = iij19; break; 
}
}
j19 = j19array[ij19]; cj19 = cj19array[ij19]; sj19 = sj19array[ij19];
{
IkReal evalcond[8];
IkReal x571=IKcos(j19);
IkReal x572=IKsin(j19);
IkReal x573=((1.0)*sj20);
IkReal x574=(new_r02*x571);
IkReal x575=(new_r12*x572);
IkReal x576=(sj20*x571);
IkReal x577=(sj20*x572);
evalcond[0]=((((-1.0)*x571*x573))+new_r02);
evalcond[1]=(new_r12+(((-1.0)*x572*x573)));
evalcond[2]=((((-1.0)*new_r02*x572))+((new_r12*x571)));
evalcond[3]=((((-1.0)*x573))+x575+x574);
evalcond[4]=(((new_r00*x576))+((new_r10*x577))+((cj20*new_r20)));
evalcond[5]=(((new_r11*x577))+((new_r01*x576))+((cj20*new_r21)));
evalcond[6]=((-1.0)+((sj20*x575))+((sj20*x574))+((cj20*new_r22)));
evalcond[7]=(((cj20*x574))+((cj20*x575))+(((-1.0)*new_r22*x573)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j21eval[3];
j21eval[0]=sj20;
j21eval[1]=((IKabs(new_r20))+(IKabs(new_r21)));
j21eval[2]=IKsign(sj20);
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal j21eval[2];
j21eval[0]=sj20;
j21eval[1]=sj19;
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  )
{
{
IkReal j21eval[3];
j21eval[0]=cj20;
j21eval[1]=sj19;
j21eval[2]=sj20;
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x578=IKcos(j21);
IkReal x579=IKsin(j21);
IkReal x580=((1.0)*cj19);
IkReal x581=((1.0)*sj19);
IkReal x582=((1.0)*x579);
evalcond[0]=(x578+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x582)));
evalcond[2]=(((sj19*x578))+new_r01);
evalcond[3]=(((sj19*x579))+new_r00);
evalcond[4]=((((-1.0)*x578*x580))+new_r11);
evalcond[5]=((((-1.0)*x579*x580))+new_r10);
evalcond[6]=(((cj19*new_r10))+(((-1.0)*x582))+(((-1.0)*new_r00*x581)));
evalcond[7]=((((-1.0)*new_r01*x581))+(((-1.0)*x578))+((cj19*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x583=IKcos(j21);
IkReal x584=IKsin(j21);
IkReal x585=((1.0)*cj19);
IkReal x586=((1.0)*sj19);
IkReal x587=((1.0)*x583);
evalcond[0]=(x584+new_r21);
evalcond[1]=(new_r20+(((-1.0)*x587)));
evalcond[2]=(((sj19*x583))+new_r01);
evalcond[3]=(((sj19*x584))+new_r00);
evalcond[4]=((((-1.0)*x583*x585))+new_r11);
evalcond[5]=((((-1.0)*x584*x585))+new_r10);
evalcond[6]=((((-1.0)*x584))+((cj19*new_r10))+(((-1.0)*new_r00*x586)));
evalcond[7]=((((-1.0)*new_r01*x586))+((cj19*new_r11))+(((-1.0)*x587)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j19))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r10, new_r11);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x588=IKcos(j21);
IkReal x589=IKsin(j21);
IkReal x590=((1.0)*sj20);
IkReal x591=((1.0)*x588);
IkReal x592=((1.0)*x589);
evalcond[0]=(((sj20*x588))+new_r20);
evalcond[1]=((((-1.0)*x592))+new_r10);
evalcond[2]=((((-1.0)*x591))+new_r11);
evalcond[3]=(((cj20*x589))+new_r01);
evalcond[4]=((((-1.0)*x589*x590))+new_r21);
evalcond[5]=((((-1.0)*cj20*x591))+new_r00);
evalcond[6]=((((-1.0)*new_r21*x590))+((cj20*new_r01))+x589);
evalcond[7]=((((-1.0)*new_r20*x590))+((cj20*new_r00))+(((-1.0)*x591)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j19)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[3];
sj19=0;
cj19=-1.0;
j19=3.14159265358979;
j21eval[0]=sj20;
j21eval[1]=((IKabs(new_r20))+(IKabs(new_r21)));
j21eval[2]=IKsign(sj20);
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  || IKabs(j21eval[2]) < 0.0000010000000000  )
{
{
IkReal j21eval[1];
sj19=0;
cj19=-1.0;
j19=3.14159265358979;
j21eval[0]=sj20;
if( IKabs(j21eval[0]) < 0.0000010000000000  )
{
{
IkReal j21eval[2];
sj19=0;
cj19=-1.0;
j19=3.14159265358979;
j21eval[0]=cj20;
j21eval[1]=sj20;
if( IKabs(j21eval[0]) < 0.0000010000000000  || IKabs(j21eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x593=IKcos(j21);
IkReal x594=((1.0)*(IKsin(j21)));
evalcond[0]=(x593+new_r20);
evalcond[1]=((((-1.0)*x594))+new_r21);
evalcond[2]=((((-1.0)*x594))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x593))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j20)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x595=IKsin(j21);
IkReal x596=((1.0)*(IKcos(j21)));
evalcond[0]=(x595+new_r21);
evalcond[1]=((((-1.0)*x596))+new_r20);
evalcond[2]=((((-1.0)*x595))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x596))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j20))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x597=IKsin(j21);
IkReal x598=((1.0)*(IKcos(j21)));
evalcond[0]=(x597+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*x597))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*x598))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x598))+(((-1.0)*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j20)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[4];
IkReal x599=IKcos(j21);
IkReal x600=((1.0)*(IKsin(j21)));
evalcond[0]=(x599+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*new_r10))+(((-1.0)*x600)));
evalcond[2]=((((-1.0)*x599))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x600))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[6];
IkReal x601=IKsin(j21);
IkReal x602=IKcos(j21);
IkReal x603=((-1.0)*x602);
evalcond[0]=x601;
evalcond[1]=(new_r22*x601);
evalcond[2]=x603;
evalcond[3]=(new_r22*x603);
evalcond[4]=((((-1.0)*x601))+(((-1.0)*new_r10)));
evalcond[5]=((((-1.0)*x602))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j21]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x604=IKPowWithIntegerCheck(cj20,-1);
if(!x604.valid){
continue;
}
CheckValue<IkReal> x605=IKPowWithIntegerCheck(sj20,-1);
if(!x605.valid){
continue;
}
if( IKabs((new_r01*(x604.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x605.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x604.value)))+IKsqr(((-1.0)*new_r20*(x605.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((new_r01*(x604.value)), ((-1.0)*new_r20*(x605.value)));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x606=IKsin(j21);
IkReal x607=IKcos(j21);
IkReal x608=((1.0)*sj20);
IkReal x609=((1.0)*new_r00);
IkReal x610=((1.0)*new_r01);
IkReal x611=((1.0)*x607);
IkReal x612=((1.0)*x606);
evalcond[0]=(((sj20*x607))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x606*x608)));
evalcond[2]=((((-1.0)*x612))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x611))+(((-1.0)*new_r11)));
evalcond[4]=((((-1.0)*x610))+((cj20*x606)));
evalcond[5]=((((-1.0)*cj20*x611))+(((-1.0)*x609)));
evalcond[6]=((((-1.0)*cj20*x610))+x606+(((-1.0)*new_r21*x608)));
evalcond[7]=((((-1.0)*new_r20*x608))+(((-1.0)*cj20*x609))+(((-1.0)*x611)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x613=IKPowWithIntegerCheck(sj20,-1);
if(!x613.valid){
continue;
}
if( IKabs((new_r21*(x613.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x613.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((new_r21*(x613.value)), ((-1.0)*new_r11));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x614=IKsin(j21);
IkReal x615=IKcos(j21);
IkReal x616=((1.0)*sj20);
IkReal x617=((1.0)*new_r00);
IkReal x618=((1.0)*new_r01);
IkReal x619=((1.0)*x615);
IkReal x620=((1.0)*x614);
evalcond[0]=(((sj20*x615))+new_r20);
evalcond[1]=((((-1.0)*x614*x616))+new_r21);
evalcond[2]=((((-1.0)*x620))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x619))+(((-1.0)*new_r11)));
evalcond[4]=(((cj20*x614))+(((-1.0)*x618)));
evalcond[5]=((((-1.0)*cj20*x619))+(((-1.0)*x617)));
evalcond[6]=((((-1.0)*new_r21*x616))+(((-1.0)*cj20*x618))+x614);
evalcond[7]=((((-1.0)*cj20*x617))+(((-1.0)*x619))+(((-1.0)*new_r20*x616)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x621=IKPowWithIntegerCheck(IKsign(sj20),-1);
if(!x621.valid){
continue;
}
CheckValue<IkReal> x622 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x622.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(((1.5707963267949)*(x621.value)))+(x622.value));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x623=IKsin(j21);
IkReal x624=IKcos(j21);
IkReal x625=((1.0)*sj20);
IkReal x626=((1.0)*new_r00);
IkReal x627=((1.0)*new_r01);
IkReal x628=((1.0)*x624);
IkReal x629=((1.0)*x623);
evalcond[0]=(new_r20+((sj20*x624)));
evalcond[1]=((((-1.0)*x623*x625))+new_r21);
evalcond[2]=((((-1.0)*x629))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x628))+(((-1.0)*new_r11)));
evalcond[4]=(((cj20*x623))+(((-1.0)*x627)));
evalcond[5]=((((-1.0)*cj20*x628))+(((-1.0)*x626)));
evalcond[6]=((((-1.0)*cj20*x627))+(((-1.0)*new_r21*x625))+x623);
evalcond[7]=((((-1.0)*cj20*x626))+(((-1.0)*x628))+(((-1.0)*new_r20*x625)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j20))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
IkReal x630=((1.0)*sj19);
if( IKabs(((((-1.0)*new_r00*x630))+(((-1.0)*cj19*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r01*x630))+((cj19*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x630))+(((-1.0)*cj19*new_r01))))+IKsqr(((((-1.0)*new_r01*x630))+((cj19*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((((-1.0)*new_r00*x630))+(((-1.0)*cj19*new_r01))), ((((-1.0)*new_r01*x630))+((cj19*new_r00))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x631=IKsin(j21);
IkReal x632=IKcos(j21);
IkReal x633=((1.0)*sj19);
IkReal x634=((1.0)*x632);
IkReal x635=(sj19*x631);
IkReal x636=((1.0)*x631);
IkReal x637=(cj19*x634);
evalcond[0]=(x631+((cj19*new_r01))+((new_r11*sj19)));
evalcond[1]=(((cj19*x631))+((sj19*x632))+new_r01);
evalcond[2]=((((-1.0)*x634))+((new_r10*sj19))+((cj19*new_r00)));
evalcond[3]=((((-1.0)*new_r00*x633))+(((-1.0)*x636))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*new_r01*x633))+(((-1.0)*x634))+((cj19*new_r11)));
evalcond[5]=((((-1.0)*x637))+x635+new_r00);
evalcond[6]=((((-1.0)*x637))+x635+new_r11);
evalcond[7]=(new_r10+(((-1.0)*cj19*x636))+(((-1.0)*x632*x633)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j20)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
IkReal x638=((1.0)*sj19);
if( IKabs(((((-1.0)*new_r00*x638))+((cj19*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r01*x638))+(((-1.0)*cj19*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x638))+((cj19*new_r01))))+IKsqr(((((-1.0)*new_r01*x638))+(((-1.0)*cj19*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2(((((-1.0)*new_r00*x638))+((cj19*new_r01))), ((((-1.0)*new_r01*x638))+(((-1.0)*cj19*new_r00))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[8];
IkReal x639=IKsin(j21);
IkReal x640=IKcos(j21);
IkReal x641=((1.0)*cj19);
IkReal x642=((1.0)*sj19);
IkReal x643=((1.0)*x639);
IkReal x644=(sj19*x640);
IkReal x645=(sj19*x639);
IkReal x646=(x639*x641);
evalcond[0]=(x640+((new_r10*sj19))+((cj19*new_r00)));
evalcond[1]=((((-1.0)*x643))+((cj19*new_r01))+((new_r11*sj19)));
evalcond[2]=(((cj19*x640))+x645+new_r00);
evalcond[3]=((((-1.0)*x643))+(((-1.0)*new_r00*x642))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*x640))+(((-1.0)*new_r01*x642))+((cj19*new_r11)));
evalcond[5]=((((-1.0)*x646))+x644+new_r01);
evalcond[6]=((((-1.0)*x646))+x644+new_r10);
evalcond[7]=((((-1.0)*x640*x641))+(((-1.0)*x639*x642))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j21eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j21eval[0]=1.0;
if( IKabs(j21eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j21]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=1.0;
op[1]=0;
op[2]=-1.0;
polyroots2(op,zeror,numroots);
IkReal j21array[2], cj21array[2], sj21array[2], tempj21array[1];
int numsolutions = 0;
for(int ij21 = 0; ij21 < numroots; ++ij21)
{
IkReal htj21 = zeror[ij21];
tempj21array[0]=((2.0)*(atan(htj21)));
for(int kj21 = 0; kj21 < 1; ++kj21)
{
j21array[numsolutions] = tempj21array[kj21];
if( j21array[numsolutions] > IKPI )
{
    j21array[numsolutions]-=IK2PI;
}
else if( j21array[numsolutions] < -IKPI )
{
    j21array[numsolutions]+=IK2PI;
}
sj21array[numsolutions] = IKsin(j21array[numsolutions]);
cj21array[numsolutions] = IKcos(j21array[numsolutions]);
numsolutions++;
}
}
bool j21valid[2]={true,true};
_nj21 = 2;
for(int ij21 = 0; ij21 < numsolutions; ++ij21)
    {
if( !j21valid[ij21] )
{
    continue;
}
    j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
htj21 = IKtan(j21/2);

_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < numsolutions; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j21]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x648=IKPowWithIntegerCheck(sj20,-1);
if(!x648.valid){
continue;
}
IkReal x647=x648.value;
CheckValue<IkReal> x649=IKPowWithIntegerCheck(cj20,-1);
if(!x649.valid){
continue;
}
CheckValue<IkReal> x650=IKPowWithIntegerCheck(sj19,-1);
if(!x650.valid){
continue;
}
if( IKabs((x647*(x649.value)*(x650.value)*(((((-1.0)*new_r11*sj20))+(((-1.0)*cj19*new_r20)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x647)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x647*(x649.value)*(x650.value)*(((((-1.0)*new_r11*sj20))+(((-1.0)*cj19*new_r20))))))+IKsqr(((-1.0)*new_r20*x647))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((x647*(x649.value)*(x650.value)*(((((-1.0)*new_r11*sj20))+(((-1.0)*cj19*new_r20))))), ((-1.0)*new_r20*x647));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[12];
IkReal x651=IKsin(j21);
IkReal x652=IKcos(j21);
IkReal x653=(cj20*sj19);
IkReal x654=(cj19*new_r01);
IkReal x655=((1.0)*sj20);
IkReal x656=(cj19*new_r00);
IkReal x657=((1.0)*sj19);
IkReal x658=((1.0)*x652);
IkReal x659=(cj20*x651);
IkReal x660=((1.0)*x651);
IkReal x661=(cj19*x658);
evalcond[0]=(((sj20*x652))+new_r20);
evalcond[1]=((((-1.0)*x651*x655))+new_r21);
evalcond[2]=(x654+x659+((new_r11*sj19)));
evalcond[3]=((((-1.0)*new_r00*x657))+(((-1.0)*x660))+((cj19*new_r10)));
evalcond[4]=((((-1.0)*x658))+(((-1.0)*new_r01*x657))+((cj19*new_r11)));
evalcond[5]=(((cj19*x659))+new_r01+((sj19*x652)));
evalcond[6]=((((-1.0)*cj20*x658))+x656+((new_r10*sj19)));
evalcond[7]=((((-1.0)*cj20*x661))+new_r00+((sj19*x651)));
evalcond[8]=(((x651*x653))+(((-1.0)*x661))+new_r11);
evalcond[9]=((((-1.0)*cj19*x660))+new_r10+(((-1.0)*x653*x658)));
evalcond[10]=(((cj20*x654))+x651+((new_r11*x653))+(((-1.0)*new_r21*x655)));
evalcond[11]=(((cj20*x656))+(((-1.0)*x658))+(((-1.0)*new_r20*x655))+((new_r10*x653)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x663=IKPowWithIntegerCheck(sj20,-1);
if(!x663.valid){
continue;
}
IkReal x662=x663.value;
CheckValue<IkReal> x664=IKPowWithIntegerCheck(sj19,-1);
if(!x664.valid){
continue;
}
if( IKabs((new_r21*x662)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x662*(x664.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj19*cj20*new_r21)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*x662))+IKsqr((x662*(x664.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj19*cj20*new_r21))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j21array[0]=IKatan2((new_r21*x662), (x662*(x664.value)*(((((-1.0)*new_r01*sj20))+(((-1.0)*cj19*cj20*new_r21))))));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[12];
IkReal x665=IKsin(j21);
IkReal x666=IKcos(j21);
IkReal x667=(cj20*sj19);
IkReal x668=(cj19*new_r01);
IkReal x669=((1.0)*sj20);
IkReal x670=(cj19*new_r00);
IkReal x671=((1.0)*sj19);
IkReal x672=((1.0)*x666);
IkReal x673=(cj20*x665);
IkReal x674=((1.0)*x665);
IkReal x675=(cj19*x672);
evalcond[0]=(new_r20+((sj20*x666)));
evalcond[1]=((((-1.0)*x665*x669))+new_r21);
evalcond[2]=(x668+x673+((new_r11*sj19)));
evalcond[3]=((((-1.0)*new_r00*x671))+((cj19*new_r10))+(((-1.0)*x674)));
evalcond[4]=((((-1.0)*new_r01*x671))+((cj19*new_r11))+(((-1.0)*x672)));
evalcond[5]=(((sj19*x666))+((cj19*x673))+new_r01);
evalcond[6]=(x670+((new_r10*sj19))+(((-1.0)*cj20*x672)));
evalcond[7]=(((sj19*x665))+new_r00+(((-1.0)*cj20*x675)));
evalcond[8]=(((x665*x667))+new_r11+(((-1.0)*x675)));
evalcond[9]=((((-1.0)*cj19*x674))+(((-1.0)*x667*x672))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x669))+((new_r11*x667))+((cj20*x668))+x665);
evalcond[11]=(((cj20*x670))+((new_r10*x667))+(((-1.0)*x672))+(((-1.0)*new_r20*x669)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j21array[1], cj21array[1], sj21array[1];
bool j21valid[1]={false};
_nj21 = 1;
CheckValue<IkReal> x676=IKPowWithIntegerCheck(IKsign(sj20),-1);
if(!x676.valid){
continue;
}
CheckValue<IkReal> x677 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x677.valid){
continue;
}
j21array[0]=((-1.5707963267949)+(((1.5707963267949)*(x676.value)))+(x677.value));
sj21array[0]=IKsin(j21array[0]);
cj21array[0]=IKcos(j21array[0]);
if( j21array[0] > IKPI )
{
    j21array[0]-=IK2PI;
}
else if( j21array[0] < -IKPI )
{    j21array[0]+=IK2PI;
}
j21valid[0] = true;
for(int ij21 = 0; ij21 < 1; ++ij21)
{
if( !j21valid[ij21] )
{
    continue;
}
_ij21[0] = ij21; _ij21[1] = -1;
for(int iij21 = ij21+1; iij21 < 1; ++iij21)
{
if( j21valid[iij21] && IKabs(cj21array[ij21]-cj21array[iij21]) < IKFAST_SOLUTION_THRESH && IKabs(sj21array[ij21]-sj21array[iij21]) < IKFAST_SOLUTION_THRESH )
{
    j21valid[iij21]=false; _ij21[1] = iij21; break; 
}
}
j21 = j21array[ij21]; cj21 = cj21array[ij21]; sj21 = sj21array[ij21];
{
IkReal evalcond[12];
IkReal x678=IKsin(j21);
IkReal x679=IKcos(j21);
IkReal x680=(cj20*sj19);
IkReal x681=(cj19*new_r01);
IkReal x682=((1.0)*sj20);
IkReal x683=(cj19*new_r00);
IkReal x684=((1.0)*sj19);
IkReal x685=((1.0)*x679);
IkReal x686=(cj20*x678);
IkReal x687=((1.0)*x678);
IkReal x688=(cj19*x685);
evalcond[0]=(new_r20+((sj20*x679)));
evalcond[1]=((((-1.0)*x678*x682))+new_r21);
evalcond[2]=(x681+x686+((new_r11*sj19)));
evalcond[3]=((((-1.0)*x687))+((cj19*new_r10))+(((-1.0)*new_r00*x684)));
evalcond[4]=((((-1.0)*new_r01*x684))+(((-1.0)*x685))+((cj19*new_r11)));
evalcond[5]=(((cj19*x686))+((sj19*x679))+new_r01);
evalcond[6]=(x683+((new_r10*sj19))+(((-1.0)*cj20*x685)));
evalcond[7]=(((sj19*x678))+new_r00+(((-1.0)*cj20*x688)));
evalcond[8]=(((x678*x680))+(((-1.0)*x688))+new_r11);
evalcond[9]=((((-1.0)*x680*x685))+(((-1.0)*cj19*x687))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x682))+x678+((new_r11*x680))+((cj20*x681)));
evalcond[11]=((((-1.0)*x685))+(((-1.0)*new_r20*x682))+((new_r10*x680))+((cj20*x683)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j15;
vinfos[1].indices[0] = _ij15[0];
vinfos[1].indices[1] = _ij15[1];
vinfos[1].maxsolutions = _nj15;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j16;
vinfos[2].indices[0] = _ij16[0];
vinfos[2].indices[1] = _ij16[1];
vinfos[2].maxsolutions = _nj16;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j17;
vinfos[3].indices[0] = _ij17[0];
vinfos[3].indices[1] = _ij17[1];
vinfos[3].maxsolutions = _nj17;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j18;
vinfos[4].indices[0] = _ij18[0];
vinfos[4].indices[1] = _ij18[1];
vinfos[4].maxsolutions = _nj18;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j19;
vinfos[5].indices[0] = _ij19[0];
vinfos[5].indices[1] = _ij19[1];
vinfos[5].maxsolutions = _nj19;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j20;
vinfos[6].indices[0] = _ij20[0];
vinfos[6].indices[1] = _ij20[1];
vinfos[6].maxsolutions = _nj20;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j21;
vinfos[7].indices[0] = _ij21[0];
vinfos[7].indices[1] = _ij21[1];
vinfos[7].maxsolutions = _nj21;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
}
}static inline void polyroots3(IkReal rawcoeffs[3+1], IkReal rawroots[3], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots2(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[3];
    const int maxsteps = 110;
    for(int i = 0; i < 3; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[3];
    IkReal err[3];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 3; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 3; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 3; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 3; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[3] = {false};
    for(int i = 0; i < 3; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 3; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots2(IkReal rawcoeffs[2+1], IkReal rawroots[2], int& numroots) {
    IkReal det = rawcoeffs[1]*rawcoeffs[1]-4*rawcoeffs[0]*rawcoeffs[2];
    if( det < 0 ) {
        numroots=0;
    }
    else if( det == 0 ) {
        rawroots[0] = -0.5*rawcoeffs[1]/rawcoeffs[0];
        numroots = 1;
    }
    else {
        det = IKsqrt(det);
        rawroots[0] = (-rawcoeffs[1]+det)/(2*rawcoeffs[0]);
        rawroots[1] = (-rawcoeffs[1]-det)/(2*rawcoeffs[0]);//rawcoeffs[2]/(rawcoeffs[0]*rawroots[0]);
        numroots = 2;
    }
}
static inline void polyroots5(IkReal rawcoeffs[5+1], IkReal rawroots[5], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots4(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[5];
    const int maxsteps = 110;
    for(int i = 0; i < 5; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[5];
    IkReal err[5];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 5; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 5; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 5; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 5; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[5] = {false};
    for(int i = 0; i < 5; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 5; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots3(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots7(IkReal rawcoeffs[7+1], IkReal rawroots[7], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots6(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[7];
    const int maxsteps = 110;
    for(int i = 0; i < 7; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[7];
    IkReal err[7];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 7; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 7; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 7; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 7; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[7] = {false};
    for(int i = 0; i < 7; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 7; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots6(IkReal rawcoeffs[6+1], IkReal rawroots[6], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots5(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[6];
    const int maxsteps = 110;
    for(int i = 0; i < 6; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[6];
    IkReal err[6];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 6; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 6; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 6; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 6; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[6] = {false};
    for(int i = 0; i < 6; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 6; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots8(IkReal rawcoeffs[8+1], IkReal rawroots[8], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots7(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[8];
    const int maxsteps = 110;
    for(int i = 0; i < 8; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[8];
    IkReal err[8];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 8; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 8; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 8; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 8; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[8] = {false};
    for(int i = 0; i < 8; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 8; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API bool ComputeIk2(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions, void* pOpenRAVEManip) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return ""; }

IKFAST_API const char* GetIkFastVersion() { return "0x1000004a"; }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif

int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif

//// START
static PyObject *left_arm_ik(PyObject *self, PyObject *args) {
    IkSolutionList<IkReal> solutions;

    // Should only have two free parameters (torso and upper arm)
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9], eetrans[3];

    // First list if 3x3 rotation matrix, easier to compute in Python.
    // Next list is [x, y, z] translation matrix.
    // Last list is free joints (torso and upper arm roll (in that order)).
    PyObject *rotList; // 3x3 rotation matrix
    PyObject *transList; // [x,y,z]
    PyObject *freeList; // [torso, upper arm]

    if(!PyArg_ParseTuple(args, "O!O!O!", &PyList_Type, &rotList, &PyList_Type, &transList, &PyList_Type, &freeList)) {
        return NULL;
    }

    for(std::size_t i = 0; i < 3; ++i) {
        eetrans[i] = PyFloat_AsDouble(PyList_GetItem(transList, i));

        PyObject* rowList = PyList_GetItem(rotList, i);
        for( std::size_t j = 0; j < 3; ++j) {
            eerot[3*i + j] = PyFloat_AsDouble(PyList_GetItem(rowList, j));
        }
    }

    for(int i = 0; i < GetNumFreeParameters(); ++i) {
        vfree[i] = PyFloat_AsDouble(PyList_GetItem(freeList, i));
    }

    // I don't understand why we pass &vfree[0] instead of just vfree.
    // Clearly ComputeIk takes an IkReal* parameter there, but it treats that parameter like an array.
    // It probably does work because the computeIk call in main specifically makes this change.
    // So it's hopefully right, and I don't understand because I don't know C++.
    bool bSuccess = ComputeIk(eetrans, eerot, &vfree[0], solutions);

    if (!bSuccess) {
        return Py_BuildValue(""); // Equivalent to returning None
    }

    // There are 8 joints in each solution (torso + 7 arm joints).
    std::vector<IkReal> solvalues(GetNumJoints());
    PyObject *solutionList = PyList_New(solutions.GetNumSolutions());

    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);

        PyObject *individualSolution = PyList_New(GetNumJoints());
        for( std::size_t j = 0; j < solvalues.size(); ++j) {
            // I think IkReal is just a wrapper for double. So this should work.
            PyList_SetItem(individualSolution, j, PyFloat_FromDouble(solvalues[j]));
        }
        PyList_SetItem(solutionList, i, individualSolution);
    }
    return solutionList;
}

static PyObject *left_arm_fk(PyObject *self, PyObject *args) {
    std::vector<IkReal> joints(8);
    IkReal eerot[9], eetrans[3];

    // First double is torso height. Next 7 doubles are arm joints
    PyObject *jointList;
    if(!PyArg_ParseTuple(args, "O!", &PyList_Type, &jointList)) {
        return NULL;
    }

    for(std::size_t i = 0; i < 8; ++i){
        joints[i] = PyFloat_AsDouble(PyList_GetItem(jointList, i));
    }

    ComputeFk(&joints[0], eetrans, eerot);

    PyObject *pose = PyList_New(2);
    PyObject *pos = PyList_New(3);
    PyObject *rot = PyList_New(3);

    for(std::size_t i = 0; i < 3; ++i) {
        PyList_SetItem(pos, i, PyFloat_FromDouble(eetrans[i]));

        PyObject *row = PyList_New(3);
        for( std::size_t j = 0; j < 3; ++j) {
            PyList_SetItem(row, j, PyFloat_FromDouble(eerot[3*i + j]));
        }
        PyList_SetItem(rot, i, row);
    }

    PyList_SetItem(pose, 0, pos);
    PyList_SetItem(pose, 1, rot);

    return pose;
}

static PyMethodDef ikLeftMethods[] = {
    {"leftIK", left_arm_ik, METH_VARARGS, "Compute IK for the PR2's left arm."},
    {"leftFK", left_arm_fk, METH_VARARGS, "Compute FK for the PR2's left arm."},
    {NULL, NULL, 0, NULL} // Not sure why/if this is needed. It shows up in the examples though(something about Sentinel).
};

PyMODINIT_FUNC initikLeft(void) {
    (void) Py_InitModule("ikLeft", ikLeftMethods);
}

//// END