# Configuration constants for Opinion CLOB SDK

# Supported chain IDs
SUPPORTED_CHAIN_IDS = [56]  # BNB Chain (BSC) mainnet

# BNB Chain (BSC) Mainnet Contract Addresses
BNB_CHAIN_CONDITIONAL_TOKENS_ADDR = "0xAD1a38cEc043e70E83a3eC30443dB285ED10D774"
BNB_CHAIN_MULTISEND_ADDR = "0x998739BFdAAdde7C933B942a68053933098f9EDa"
BNB_CHAIN_FEE_MANAGER_ADDR = "0xc9063dc52deefb518e5b6634a6b8d624bc5d7c36"

# Default contract addresses by chain ID
DEFAULT_CONTRACT_ADDRESSES = {
    56: {  # BNB Chain Mainnet
        "conditional_tokens": BNB_CHAIN_CONDITIONAL_TOKENS_ADDR,
        "multisend": BNB_CHAIN_MULTISEND_ADDR,
        "fee_manager": BNB_CHAIN_FEE_MANAGER_ADDR,
    }
}
