/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.mgt;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.mgt.DefaultFilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.util.WebUtils;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMatchingFilterChainResolver
implements FilterChainResolver {
    private static final transient Logger log = LoggerFactory.getLogger(PathMatchingFilterChainResolver.class);
    private FilterChainManager filterChainManager;
    private PatternMatcher pathMatcher = new AntPathMatcher();
    private static final String DEFAULT_PATH_SEPARATOR = "/";

    public PathMatchingFilterChainResolver() {
        this.filterChainManager = new DefaultFilterChainManager();
    }

    public PathMatchingFilterChainResolver(FilterConfig filterConfig) {
        this.filterChainManager = new DefaultFilterChainManager(filterConfig);
    }

    public PatternMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PatternMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public FilterChainManager getFilterChainManager() {
        return this.filterChainManager;
    }

    public void setFilterChainManager(FilterChainManager filterChainManager) {
        this.filterChainManager = filterChainManager;
    }

    @Override
    public FilterChain getChain(ServletRequest request, ServletResponse response, FilterChain originalChain) {
        FilterChainManager filterChainManager = this.getFilterChainManager();
        if (!filterChainManager.hasChains()) {
            return null;
        }
        String requestURI = this.getPathWithinApplication(request);
        String requestURINoTrailingSlash = PathMatchingFilterChainResolver.removeTrailingSlash(requestURI);
        for (String pathPattern : filterChainManager.getChainNames()) {
            if (this.pathMatches(pathPattern, requestURI)) {
                if (log.isTraceEnabled()) {
                    log.trace("Matched path pattern [{}] for requestURI [{}].  Utilizing corresponding filter chain...", (Object)pathPattern, (Object)Encode.forHtml(requestURI));
                }
                return filterChainManager.proxy(originalChain, pathPattern);
            }
            if (!this.pathMatches(pathPattern = PathMatchingFilterChainResolver.removeTrailingSlash(pathPattern), requestURINoTrailingSlash)) continue;
            if (log.isTraceEnabled()) {
                log.trace("Matched path pattern [{}] for requestURI [{}].  Utilizing corresponding filter chain...", (Object)pathPattern, (Object)Encode.forHtml(requestURINoTrailingSlash));
            }
            return filterChainManager.proxy(originalChain, pathPattern);
        }
        return null;
    }

    protected boolean pathMatches(String pattern, String path) {
        PatternMatcher pathMatcher = this.getPathMatcher();
        return pathMatcher.matches(pattern, path);
    }

    protected String getPathWithinApplication(ServletRequest request) {
        return WebUtils.getPathWithinApplication(WebUtils.toHttp(request));
    }

    private static String removeTrailingSlash(String path) {
        if (path != null && !DEFAULT_PATH_SEPARATOR.equals(path) && path.endsWith(DEFAULT_PATH_SEPARATOR)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }
}

