/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.http.HttpLib;

public class Params {
    private List<Param> paramList = new ArrayList<Param>();
    private Map<String, List<String>> params = new HashMap<String, List<String>>();

    protected Params() {
    }

    public static Params create() {
        return new Params();
    }

    public static Params create(Params other) {
        return new Params(other);
    }

    private Params(Params other) {
        this.merge(other);
    }

    public void merge(Params other) {
        this.params.putAll(other.params);
        this.paramList.addAll(other.paramList);
    }

    public Params add(String name, String value) {
        Param p = new Param(name, value);
        this.paramList.add(p);
        this.params.computeIfAbsent(name, n -> new ArrayList()).add(value);
        return this;
    }

    public Params add(String name) {
        return this.add(name, null);
    }

    public boolean containsParam(String name) {
        return this.params.containsKey(name);
    }

    public String getValue(String name) {
        List<String> x = this.getMV(name);
        if (x == null) {
            return null;
        }
        if (x.size() != 1) {
            throw new MultiValueException("Multiple value (" + x.size() + " when exactly one requested");
        }
        return x.get(0);
    }

    public List<String> getValues(String name) {
        return this.getMV(name);
    }

    public void remove(String name) {
        this.paramList.removeIf(p -> p.getName().equals(name));
        this.params.remove(name);
    }

    public List<Param> pairs() {
        return this.paramList;
    }

    public int count() {
        return this.paramList.size();
    }

    public List<String> names() {
        return this.paramList.stream().map(Param::getName).distinct().collect(Collectors.toList());
    }

    public String httpString() {
        return Params.format(new StringBuilder(), this.paramList).toString();
    }

    private static StringBuilder format(StringBuilder result, List<Param> parameters) {
        parameters.forEach(param -> {
            String encodedName = Params.encode(param.getName());
            String encodedValue = Params.encode(param.getValue());
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            if (encodedValue != null) {
                result.append("=");
                result.append(encodedValue);
            }
        });
        return result;
    }

    private static String encode(String name) {
        if (name == null) {
            return name;
        }
        return HttpLib.urlEncodeQueryString(name);
    }

    public String toString() {
        return this.paramList.toString();
    }

    private List<String> getMV(String name) {
        return this.params.get(name);
    }

    public static class Param
    extends Pair<String, String>
    implements NameValuePair {
        public Param(String name, String value) {
            super(name, value);
        }

        @Override
        public String getName() {
            return (String)this.getLeft();
        }

        @Override
        public String getValue() {
            return (String)this.getRight();
        }
    }

    static class MultiValueException
    extends RuntimeException {
        MultiValueException(String msg) {
            super(msg);
        }
    }
}

