/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class RDFReaderRIOT
implements RDFReaderI {
    private final String basename;
    protected final Lang hintlang;
    protected Context context = new Context();
    protected RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFReaderRIOT() {
        this((Lang)null);
    }

    public RDFReaderRIOT(String lang) {
        this(lang != null ? RDFLanguages.nameToLang(lang) : null);
    }

    public RDFReaderRIOT(Lang hintlang) {
        this.hintlang = hintlang;
        this.basename = hintlang == null ? "org.apache.jena.riot.reader.generic" : "org.apache.jena.riot.reader." + hintlang.getLabel().toLowerCase(Locale.ROOT);
    }

    @Override
    public void read(Model model, Reader r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public void read(Model model, InputStream r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public void read(Model model, String url) {
        this.startRead(model);
        RDFDataMgr.read(model, url, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        Symbol sym = Symbol.create(this.basename + propName);
        Object oldObj = this.context.get(sym);
        return oldObj;
    }

    protected void startRead(Model model) {
        model.notifyEvent(GraphEvents.startRead);
    }

    protected void finishRead(Model model) {
        model.notifyEvent(GraphEvents.finishRead);
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }
}

