/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.ValidString;
import org.apache.jena.fuseki.server.Validators;
import org.apache.jena.fuseki.servlets.HttpAction;

public class DataAccessPoint {
    private final ValidString name;
    private final DataService dataService;
    private AtomicLong requests = new AtomicLong(0L);

    public DataAccessPoint(String name, DataService dataService) {
        ValidString vs;
        Objects.requireNonNull(name, "DataAccessPoint name");
        Objects.requireNonNull(dataService, "DataService");
        name = DataAccessPoint.canonical(name);
        this.name = vs = Validators.serviceName(name);
        this.dataService = dataService;
        dataService.noteDataAccessPoint(this);
    }

    public String getName() {
        return this.name.string;
    }

    public static String canonical(String datasetPath) {
        if (datasetPath == null) {
            return datasetPath;
        }
        if (((String)datasetPath).equals("/")) {
            return datasetPath;
        }
        if (((String)datasetPath).equals("")) {
            return "/";
        }
        if (!((String)datasetPath).startsWith("/")) {
            datasetPath = "/" + (String)datasetPath;
        }
        if (((String)datasetPath).endsWith("/")) {
            datasetPath = ((String)datasetPath).substring(0, ((String)datasetPath).length() - 1);
        }
        return datasetPath;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public long requestCount() {
        return this.requests.get();
    }

    public void startRequest(HttpAction httpAction) {
        this.requests.incrementAndGet();
    }

    public void finishRequest(HttpAction httpAction) {
        this.requests.getAndDecrement();
    }

    public String toString() {
        return "DataAccessPoint[" + this.name + "]";
    }
}

