/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.compaction;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DirectionType;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.Optional;

public final class ValueCompaction {
    private final ActiveContext activeContext;

    private ValueCompaction(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static ValueCompaction with(ActiveContext activeContext) {
        return new ValueCompaction(activeContext);
    }

    public JsonValue compact(JsonObject value, String activeProperty) throws JsonLdError {
        JsonValue result = value;
        if (this.activeContext.getInverseContext() == null) {
            this.activeContext.createInverseContext();
        }
        Optional<TermDefinition> activePropertyDefinition = this.activeContext.getTerm(activeProperty);
        JsonValue language = null;
        DirectionType direction = null;
        if (activePropertyDefinition.isPresent()) {
            language = activePropertyDefinition.get().getLanguageMapping();
            direction = activePropertyDefinition.get().getDirectionMapping();
        }
        if (language == null) {
            JsonValue jsonValue = language = this.activeContext.getDefaultLanguage() != null ? Json.createValue(this.activeContext.getDefaultLanguage()) : null;
        }
        if (direction == null) {
            direction = this.activeContext.getDefaultBaseDirection();
        }
        if (value.containsKey("@id") && (value.size() == 1 || value.size() == 2 && value.containsKey("@index"))) {
            if (activePropertyDefinition.map(TermDefinition::getTypeMapping).filter("@id"::equals).isPresent()) {
                result = JsonUtils.toJsonValue(this.activeContext.uriCompaction().compact(value.getString("@id")));
            } else if (activePropertyDefinition.map(TermDefinition::getTypeMapping).filter("@vocab"::equals).isPresent()) {
                result = JsonUtils.toJsonValue(this.activeContext.uriCompaction().vocab(true).compact(value.getString("@id")));
            }
        } else if (value.containsKey("@type") && activePropertyDefinition.map(TermDefinition::getTypeMapping).filter(d -> JsonUtils.contains(d, (JsonValue)value.get("@type"))).isPresent()) {
            result = (JsonValue)value.get("@value");
        } else if (activePropertyDefinition.map(TermDefinition::getTypeMapping).filter("@none"::equals).isPresent() || value.containsKey("@type") && activePropertyDefinition.map(TermDefinition::getTypeMapping).map(d -> !JsonUtils.contains(d, (JsonValue)value.get("@type"))).orElse(true).booleanValue()) {
            JsonArrayBuilder types = Json.createArrayBuilder();
            JsonValue resultTypes = (JsonValue)result.asJsonObject().get("@type");
            if (JsonUtils.isNotNull(resultTypes)) {
                for (JsonValue type : JsonUtils.toCollection(resultTypes)) {
                    types.add(this.activeContext.uriCompaction().vocab(true).compact(((JsonString)type).getString()));
                }
                result = Json.createObjectBuilder(result.asJsonObject()).add("@type", types.build()).build();
            }
        } else if (JsonUtils.isNotString((JsonValue)value.get("@value"))) {
            if (!value.containsKey("@index") || activePropertyDefinition.filter(td -> td.hasContainerMapping("@index")).isPresent()) {
                result = (JsonValue)value.get("@value");
            }
        } else if ((value.containsKey("@language") && JsonUtils.isString((JsonValue)value.get("@language")) && JsonUtils.isString(language) && ((JsonString)language).getString().equalsIgnoreCase(value.getString("@language")) || JsonUtils.isNull(language) && (!value.containsKey("@language") || JsonUtils.isNull((JsonValue)value.get("@language")))) && (direction != null && direction != DirectionType.NULL && JsonUtils.isString((JsonValue)value.get("@direction")) && direction == DirectionType.valueOf(value.getString("@direction").toUpperCase()) || (direction == null || direction == DirectionType.NULL) && (!value.containsKey("@direction") || DirectionType.NULL == DirectionType.valueOf(value.getString("@direction").toUpperCase()))) && (!value.containsKey("@index") || activePropertyDefinition.filter(d -> d.hasContainerMapping("@index")).isPresent())) {
            result = (JsonValue)value.get("@value");
        }
        if (JsonUtils.isObject(result)) {
            JsonObjectBuilder resultBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : result.asJsonObject().entrySet()) {
                resultBuilder.add(this.activeContext.uriCompaction().vocab(true).compact((String)entry.getKey()), (JsonValue)entry.getValue());
            }
            result = resultBuilder.build();
        }
        return result;
    }
}

