/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.tw.jena.query.fulltext;

import edu.rpi.tw.jena.query.fulltext.Entity;
import edu.rpi.tw.jena.query.fulltext.EntityDefinition;
import edu.rpi.tw.jena.query.fulltext.TextDocProducer;
import edu.rpi.tw.jena.query.fulltext.TextIndex;
import edu.rpi.tw.jena.query.fulltext.TextQueryFuncs;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetChangesBatched;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDocProducerEntities
extends DatasetChangesBatched
implements TextDocProducer {
    private static Logger log = LoggerFactory.getLogger(TextDocProducer.class);
    private final EntityDefinition defn;
    private final TextIndex indexer;
    private final ThreadLocal<Boolean> inTransaction = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public TextDocProducerEntities(TextIndex indexer) {
        this.defn = indexer.getDocDef();
        this.indexer = indexer;
        this.inTransaction.set(false);
    }

    protected void startBatched() {
        this.inTransaction.set(true);
    }

    protected void finishBatched() {
        this.inTransaction.set(false);
    }

    protected void dispatch(QuadAction quadAction, List<Quad> batch) {
        if (!this.inTransaction.get().booleanValue()) {
            throw new IllegalStateException("Not started");
        }
        if (!QuadAction.ADD.equals((Object)quadAction)) {
            return;
        }
        if (batch.size() == 0) {
            return;
        }
        this.docQuads(batch);
    }

    private void docEntity(Node g, Node s, List<Quad> batch) {
        String x = TextQueryFuncs.subjectToString(s);
        String gx = TextQueryFuncs.graphNodeToString(g);
        Entity entity = new Entity(x, gx);
        String graphField = this.defn.getGraphField();
        if (this.defn.getGraphField() != null) {
            entity.put(graphField, gx);
        }
        for (Quad quad : batch) {
            String field = this.defn.getPrimaryField();
            if (field == null) continue;
            Node o = quad.getObject();
            String val = null;
            if (o.isURI()) {
                val = o.getURI();
            } else {
                if (!o.isLiteral()) continue;
                val = o.getLiteralLexicalForm();
            }
            entity.put(field, val);
        }
        this.indexer.addEntity(entity);
    }

    private void docQuads(List<Quad> batch) {
        for (Quad quad : batch) {
            Entity entity = TextQueryFuncs.entityFromQuad(this.defn, quad);
            if (entity == null) continue;
            this.indexer.addEntity(entity);
        }
    }
}

