(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_language_typescript_tsMode_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/language/typescript/tsMode.js":
/*!*************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/language/typescript/tsMode.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Adapter": () => (/* binding */ Adapter),
/* harmony export */   "CodeActionAdaptor": () => (/* binding */ CodeActionAdaptor),
/* harmony export */   "DefinitionAdapter": () => (/* binding */ DefinitionAdapter),
/* harmony export */   "DiagnosticsAdapter": () => (/* binding */ DiagnosticsAdapter),
/* harmony export */   "FormatAdapter": () => (/* binding */ FormatAdapter),
/* harmony export */   "FormatHelper": () => (/* binding */ FormatHelper),
/* harmony export */   "FormatOnTypeAdapter": () => (/* binding */ FormatOnTypeAdapter),
/* harmony export */   "InlayHintsAdapter": () => (/* binding */ InlayHintsAdapter),
/* harmony export */   "Kind": () => (/* binding */ Kind),
/* harmony export */   "LibFiles": () => (/* binding */ LibFiles),
/* harmony export */   "OccurrencesAdapter": () => (/* binding */ OccurrencesAdapter),
/* harmony export */   "OutlineAdapter": () => (/* binding */ OutlineAdapter),
/* harmony export */   "QuickInfoAdapter": () => (/* binding */ QuickInfoAdapter),
/* harmony export */   "ReferenceAdapter": () => (/* binding */ ReferenceAdapter),
/* harmony export */   "RenameAdapter": () => (/* binding */ RenameAdapter),
/* harmony export */   "SignatureHelpAdapter": () => (/* binding */ SignatureHelpAdapter),
/* harmony export */   "SuggestAdapter": () => (/* binding */ SuggestAdapter),
/* harmony export */   "WorkerManager": () => (/* binding */ WorkerManager),
/* harmony export */   "flattenDiagnosticMessageText": () => (/* binding */ flattenDiagnosticMessageText),
/* harmony export */   "getJavaScriptWorker": () => (/* binding */ getJavaScriptWorker),
/* harmony export */   "getTypeScriptWorker": () => (/* binding */ getTypeScriptWorker),
/* harmony export */   "setupJavaScript": () => (/* binding */ setupJavaScript),
/* harmony export */   "setupTypeScript": () => (/* binding */ setupTypeScript)
/* harmony export */ });
/* harmony import */ var _editor_editor_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../editor/editor.api.js */ "include-loader!./node_modules/monaco-editor/esm/vs/editor/editor.api.js");
/* harmony import */ var _monaco_contribution_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./monaco.contribution.js */ "./node_modules/monaco-editor/esm/vs/language/typescript/monaco.contribution.js");
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};

// src/fillers/monaco-editor-core.ts
var monaco_editor_core_exports = {};
__reExport(monaco_editor_core_exports, _editor_editor_api_js__WEBPACK_IMPORTED_MODULE_0__);


// src/language/typescript/workerManager.ts
var WorkerManager = class {
  constructor(_modeId, _defaults) {
    this._modeId = _modeId;
    this._defaults = _defaults;
    this._worker = null;
    this._client = null;
    this._configChangeListener = this._defaults.onDidChange(() => this._stopWorker());
    this._updateExtraLibsToken = 0;
    this._extraLibsChangeListener = this._defaults.onDidExtraLibsChange(() => this._updateExtraLibs());
  }
  _configChangeListener;
  _updateExtraLibsToken;
  _extraLibsChangeListener;
  _worker;
  _client;
  dispose() {
    this._configChangeListener.dispose();
    this._extraLibsChangeListener.dispose();
    this._stopWorker();
  }
  _stopWorker() {
    if (this._worker) {
      this._worker.dispose();
      this._worker = null;
    }
    this._client = null;
  }
  async _updateExtraLibs() {
    if (!this._worker) {
      return;
    }
    const myToken = ++this._updateExtraLibsToken;
    const proxy = await this._worker.getProxy();
    if (this._updateExtraLibsToken !== myToken) {
      return;
    }
    proxy.updateExtraLibs(this._defaults.getExtraLibs());
  }
  _getClient() {
    if (!this._client) {
      this._client = (async () => {
        this._worker = monaco_editor_core_exports.editor.createWebWorker({
          moduleId: "vs/language/typescript/tsWorker",
          label: this._modeId,
          keepIdleModels: true,
          createData: {
            compilerOptions: this._defaults.getCompilerOptions(),
            extraLibs: this._defaults.getExtraLibs(),
            customWorkerPath: this._defaults.workerOptions.customWorkerPath,
            inlayHintsOptions: this._defaults.inlayHintsOptions
          }
        });
        if (this._defaults.getEagerModelSync()) {
          return await this._worker.withSyncedResources(monaco_editor_core_exports.editor.getModels().filter((model) => model.getLanguageId() === this._modeId).map((model) => model.uri));
        }
        return await this._worker.getProxy();
      })();
    }
    return this._client;
  }
  async getLanguageServiceWorker(...resources) {
    const client = await this._getClient();
    if (this._worker) {
      await this._worker.withSyncedResources(resources);
    }
    return client;
  }
};

// src/language/typescript/languageFeatures.ts


// src/language/typescript/lib/lib.index.ts
var libFileSet = {};
libFileSet["lib.d.ts"] = true;
libFileSet["lib.dom.d.ts"] = true;
libFileSet["lib.dom.iterable.d.ts"] = true;
libFileSet["lib.es2015.collection.d.ts"] = true;
libFileSet["lib.es2015.core.d.ts"] = true;
libFileSet["lib.es2015.d.ts"] = true;
libFileSet["lib.es2015.generator.d.ts"] = true;
libFileSet["lib.es2015.iterable.d.ts"] = true;
libFileSet["lib.es2015.promise.d.ts"] = true;
libFileSet["lib.es2015.proxy.d.ts"] = true;
libFileSet["lib.es2015.reflect.d.ts"] = true;
libFileSet["lib.es2015.symbol.d.ts"] = true;
libFileSet["lib.es2015.symbol.wellknown.d.ts"] = true;
libFileSet["lib.es2016.array.include.d.ts"] = true;
libFileSet["lib.es2016.d.ts"] = true;
libFileSet["lib.es2016.full.d.ts"] = true;
libFileSet["lib.es2017.d.ts"] = true;
libFileSet["lib.es2017.full.d.ts"] = true;
libFileSet["lib.es2017.intl.d.ts"] = true;
libFileSet["lib.es2017.object.d.ts"] = true;
libFileSet["lib.es2017.sharedmemory.d.ts"] = true;
libFileSet["lib.es2017.string.d.ts"] = true;
libFileSet["lib.es2017.typedarrays.d.ts"] = true;
libFileSet["lib.es2018.asyncgenerator.d.ts"] = true;
libFileSet["lib.es2018.asynciterable.d.ts"] = true;
libFileSet["lib.es2018.d.ts"] = true;
libFileSet["lib.es2018.full.d.ts"] = true;
libFileSet["lib.es2018.intl.d.ts"] = true;
libFileSet["lib.es2018.promise.d.ts"] = true;
libFileSet["lib.es2018.regexp.d.ts"] = true;
libFileSet["lib.es2019.array.d.ts"] = true;
libFileSet["lib.es2019.d.ts"] = true;
libFileSet["lib.es2019.full.d.ts"] = true;
libFileSet["lib.es2019.object.d.ts"] = true;
libFileSet["lib.es2019.string.d.ts"] = true;
libFileSet["lib.es2019.symbol.d.ts"] = true;
libFileSet["lib.es2020.bigint.d.ts"] = true;
libFileSet["lib.es2020.d.ts"] = true;
libFileSet["lib.es2020.full.d.ts"] = true;
libFileSet["lib.es2020.intl.d.ts"] = true;
libFileSet["lib.es2020.promise.d.ts"] = true;
libFileSet["lib.es2020.sharedmemory.d.ts"] = true;
libFileSet["lib.es2020.string.d.ts"] = true;
libFileSet["lib.es2020.symbol.wellknown.d.ts"] = true;
libFileSet["lib.es2021.d.ts"] = true;
libFileSet["lib.es2021.full.d.ts"] = true;
libFileSet["lib.es2021.intl.d.ts"] = true;
libFileSet["lib.es2021.promise.d.ts"] = true;
libFileSet["lib.es2021.string.d.ts"] = true;
libFileSet["lib.es2021.weakref.d.ts"] = true;
libFileSet["lib.es5.d.ts"] = true;
libFileSet["lib.es6.d.ts"] = true;
libFileSet["lib.esnext.d.ts"] = true;
libFileSet["lib.esnext.full.d.ts"] = true;
libFileSet["lib.esnext.intl.d.ts"] = true;
libFileSet["lib.esnext.promise.d.ts"] = true;
libFileSet["lib.esnext.string.d.ts"] = true;
libFileSet["lib.esnext.weakref.d.ts"] = true;
libFileSet["lib.scripthost.d.ts"] = true;
libFileSet["lib.webworker.d.ts"] = true;
libFileSet["lib.webworker.importscripts.d.ts"] = true;
libFileSet["lib.webworker.iterable.d.ts"] = true;

// src/language/typescript/languageFeatures.ts
function flattenDiagnosticMessageText(diag, newLine, indent = 0) {
  if (typeof diag === "string") {
    return diag;
  } else if (diag === void 0) {
    return "";
  }
  let result = "";
  if (indent) {
    result += newLine;
    for (let i = 0; i < indent; i++) {
      result += "  ";
    }
  }
  result += diag.messageText;
  indent++;
  if (diag.next) {
    for (const kid of diag.next) {
      result += flattenDiagnosticMessageText(kid, newLine, indent);
    }
  }
  return result;
}
function displayPartsToString(displayParts) {
  if (displayParts) {
    return displayParts.map((displayPart) => displayPart.text).join("");
  }
  return "";
}
var Adapter = class {
  constructor(_worker) {
    this._worker = _worker;
  }
  _textSpanToRange(model, span) {
    let p1 = model.getPositionAt(span.start);
    let p2 = model.getPositionAt(span.start + span.length);
    let { lineNumber: startLineNumber, column: startColumn } = p1;
    let { lineNumber: endLineNumber, column: endColumn } = p2;
    return { startLineNumber, startColumn, endLineNumber, endColumn };
  }
};
var LibFiles = class {
  constructor(_worker) {
    this._worker = _worker;
    this._libFiles = {};
    this._hasFetchedLibFiles = false;
    this._fetchLibFilesPromise = null;
  }
  _libFiles;
  _hasFetchedLibFiles;
  _fetchLibFilesPromise;
  isLibFile(uri) {
    if (!uri) {
      return false;
    }
    if (uri.path.indexOf("/lib.") === 0) {
      return !!libFileSet[uri.path.slice(1)];
    }
    return false;
  }
  getOrCreateModel(fileName) {
    const uri = monaco_editor_core_exports.Uri.parse(fileName);
    const model = monaco_editor_core_exports.editor.getModel(uri);
    if (model) {
      return model;
    }
    if (this.isLibFile(uri) && this._hasFetchedLibFiles) {
      return monaco_editor_core_exports.editor.createModel(this._libFiles[uri.path.slice(1)], "typescript", uri);
    }
    const matchedLibFile = _monaco_contribution_js__WEBPACK_IMPORTED_MODULE_1__.typescriptDefaults.getExtraLibs()[fileName];
    if (matchedLibFile) {
      return monaco_editor_core_exports.editor.createModel(matchedLibFile.content, "typescript", uri);
    }
    return null;
  }
  _containsLibFile(uris) {
    for (let uri of uris) {
      if (this.isLibFile(uri)) {
        return true;
      }
    }
    return false;
  }
  async fetchLibFilesIfNecessary(uris) {
    if (!this._containsLibFile(uris)) {
      return;
    }
    await this._fetchLibFiles();
  }
  _fetchLibFiles() {
    if (!this._fetchLibFilesPromise) {
      this._fetchLibFilesPromise = this._worker().then((w) => w.getLibFiles()).then((libFiles) => {
        this._hasFetchedLibFiles = true;
        this._libFiles = libFiles;
      });
    }
    return this._fetchLibFilesPromise;
  }
};
var DiagnosticsAdapter = class extends Adapter {
  constructor(_libFiles, _defaults, _selector, worker) {
    super(worker);
    this._libFiles = _libFiles;
    this._defaults = _defaults;
    this._selector = _selector;
    const onModelAdd = (model) => {
      if (model.getLanguageId() !== _selector) {
        return;
      }
      const maybeValidate = () => {
        const { onlyVisible } = this._defaults.getDiagnosticsOptions();
        if (onlyVisible) {
          if (model.isAttachedToEditor()) {
            this._doValidate(model);
          }
        } else {
          this._doValidate(model);
        }
      };
      let handle;
      const changeSubscription = model.onDidChangeContent(() => {
        clearTimeout(handle);
        handle = window.setTimeout(maybeValidate, 500);
      });
      const visibleSubscription = model.onDidChangeAttached(() => {
        const { onlyVisible } = this._defaults.getDiagnosticsOptions();
        if (onlyVisible) {
          if (model.isAttachedToEditor()) {
            maybeValidate();
          } else {
            monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, []);
          }
        }
      });
      this._listener[model.uri.toString()] = {
        dispose() {
          changeSubscription.dispose();
          visibleSubscription.dispose();
          clearTimeout(handle);
        }
      };
      maybeValidate();
    };
    const onModelRemoved = (model) => {
      monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, []);
      const key = model.uri.toString();
      if (this._listener[key]) {
        this._listener[key].dispose();
        delete this._listener[key];
      }
    };
    this._disposables.push(monaco_editor_core_exports.editor.onDidCreateModel((model) => onModelAdd(model)));
    this._disposables.push(monaco_editor_core_exports.editor.onWillDisposeModel(onModelRemoved));
    this._disposables.push(monaco_editor_core_exports.editor.onDidChangeModelLanguage((event) => {
      onModelRemoved(event.model);
      onModelAdd(event.model);
    }));
    this._disposables.push({
      dispose() {
        for (const model of monaco_editor_core_exports.editor.getModels()) {
          onModelRemoved(model);
        }
      }
    });
    const recomputeDiagostics = () => {
      for (const model of monaco_editor_core_exports.editor.getModels()) {
        onModelRemoved(model);
        onModelAdd(model);
      }
    };
    this._disposables.push(this._defaults.onDidChange(recomputeDiagostics));
    this._disposables.push(this._defaults.onDidExtraLibsChange(recomputeDiagostics));
    monaco_editor_core_exports.editor.getModels().forEach((model) => onModelAdd(model));
  }
  _disposables = [];
  _listener = /* @__PURE__ */ Object.create(null);
  dispose() {
    this._disposables.forEach((d) => d && d.dispose());
    this._disposables = [];
  }
  async _doValidate(model) {
    const worker = await this._worker(model.uri);
    if (model.isDisposed()) {
      return;
    }
    const promises = [];
    const { noSyntaxValidation, noSemanticValidation, noSuggestionDiagnostics } = this._defaults.getDiagnosticsOptions();
    if (!noSyntaxValidation) {
      promises.push(worker.getSyntacticDiagnostics(model.uri.toString()));
    }
    if (!noSemanticValidation) {
      promises.push(worker.getSemanticDiagnostics(model.uri.toString()));
    }
    if (!noSuggestionDiagnostics) {
      promises.push(worker.getSuggestionDiagnostics(model.uri.toString()));
    }
    const allDiagnostics = await Promise.all(promises);
    if (!allDiagnostics || model.isDisposed()) {
      return;
    }
    const diagnostics = allDiagnostics.reduce((p, c) => c.concat(p), []).filter((d) => (this._defaults.getDiagnosticsOptions().diagnosticCodesToIgnore || []).indexOf(d.code) === -1);
    const relatedUris = diagnostics.map((d) => d.relatedInformation || []).reduce((p, c) => c.concat(p), []).map((relatedInformation) => relatedInformation.file ? monaco_editor_core_exports.Uri.parse(relatedInformation.file.fileName) : null);
    await this._libFiles.fetchLibFilesIfNecessary(relatedUris);
    if (model.isDisposed()) {
      return;
    }
    monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, diagnostics.map((d) => this._convertDiagnostics(model, d)));
  }
  _convertDiagnostics(model, diag) {
    const diagStart = diag.start || 0;
    const diagLength = diag.length || 1;
    const { lineNumber: startLineNumber, column: startColumn } = model.getPositionAt(diagStart);
    const { lineNumber: endLineNumber, column: endColumn } = model.getPositionAt(diagStart + diagLength);
    const tags = [];
    if (diag.reportsUnnecessary) {
      tags.push(monaco_editor_core_exports.MarkerTag.Unnecessary);
    }
    if (diag.reportsDeprecated) {
      tags.push(monaco_editor_core_exports.MarkerTag.Deprecated);
    }
    return {
      severity: this._tsDiagnosticCategoryToMarkerSeverity(diag.category),
      startLineNumber,
      startColumn,
      endLineNumber,
      endColumn,
      message: flattenDiagnosticMessageText(diag.messageText, "\n"),
      code: diag.code.toString(),
      tags,
      relatedInformation: this._convertRelatedInformation(model, diag.relatedInformation)
    };
  }
  _convertRelatedInformation(model, relatedInformation) {
    if (!relatedInformation) {
      return [];
    }
    const result = [];
    relatedInformation.forEach((info) => {
      let relatedResource = model;
      if (info.file) {
        relatedResource = this._libFiles.getOrCreateModel(info.file.fileName);
      }
      if (!relatedResource) {
        return;
      }
      const infoStart = info.start || 0;
      const infoLength = info.length || 1;
      const { lineNumber: startLineNumber, column: startColumn } = relatedResource.getPositionAt(infoStart);
      const { lineNumber: endLineNumber, column: endColumn } = relatedResource.getPositionAt(infoStart + infoLength);
      result.push({
        resource: relatedResource.uri,
        startLineNumber,
        startColumn,
        endLineNumber,
        endColumn,
        message: flattenDiagnosticMessageText(info.messageText, "\n")
      });
    });
    return result;
  }
  _tsDiagnosticCategoryToMarkerSeverity(category) {
    switch (category) {
      case 1 /* Error */:
        return monaco_editor_core_exports.MarkerSeverity.Error;
      case 3 /* Message */:
        return monaco_editor_core_exports.MarkerSeverity.Info;
      case 0 /* Warning */:
        return monaco_editor_core_exports.MarkerSeverity.Warning;
      case 2 /* Suggestion */:
        return monaco_editor_core_exports.MarkerSeverity.Hint;
    }
    return monaco_editor_core_exports.MarkerSeverity.Info;
  }
};
var SuggestAdapter = class extends Adapter {
  get triggerCharacters() {
    return ["."];
  }
  async provideCompletionItems(model, position, _context, token) {
    const wordInfo = model.getWordUntilPosition(position);
    const wordRange = new monaco_editor_core_exports.Range(position.lineNumber, wordInfo.startColumn, position.lineNumber, wordInfo.endColumn);
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const info = await worker.getCompletionsAtPosition(resource.toString(), offset);
    if (!info || model.isDisposed()) {
      return;
    }
    const suggestions = info.entries.map((entry) => {
      let range = wordRange;
      if (entry.replacementSpan) {
        const p1 = model.getPositionAt(entry.replacementSpan.start);
        const p2 = model.getPositionAt(entry.replacementSpan.start + entry.replacementSpan.length);
        range = new monaco_editor_core_exports.Range(p1.lineNumber, p1.column, p2.lineNumber, p2.column);
      }
      const tags = [];
      if (entry.kindModifiers?.indexOf("deprecated") !== -1) {
        tags.push(monaco_editor_core_exports.languages.CompletionItemTag.Deprecated);
      }
      return {
        uri: resource,
        position,
        offset,
        range,
        label: entry.name,
        insertText: entry.name,
        sortText: entry.sortText,
        kind: SuggestAdapter.convertKind(entry.kind),
        tags
      };
    });
    return {
      suggestions
    };
  }
  async resolveCompletionItem(item, token) {
    const myItem = item;
    const resource = myItem.uri;
    const position = myItem.position;
    const offset = myItem.offset;
    const worker = await this._worker(resource);
    const details = await worker.getCompletionEntryDetails(resource.toString(), offset, myItem.label);
    if (!details) {
      return myItem;
    }
    return {
      uri: resource,
      position,
      label: details.name,
      kind: SuggestAdapter.convertKind(details.kind),
      detail: displayPartsToString(details.displayParts),
      documentation: {
        value: SuggestAdapter.createDocumentationString(details)
      }
    };
  }
  static convertKind(kind) {
    switch (kind) {
      case Kind.primitiveType:
      case Kind.keyword:
        return monaco_editor_core_exports.languages.CompletionItemKind.Keyword;
      case Kind.variable:
      case Kind.localVariable:
        return monaco_editor_core_exports.languages.CompletionItemKind.Variable;
      case Kind.memberVariable:
      case Kind.memberGetAccessor:
      case Kind.memberSetAccessor:
        return monaco_editor_core_exports.languages.CompletionItemKind.Field;
      case Kind.function:
      case Kind.memberFunction:
      case Kind.constructSignature:
      case Kind.callSignature:
      case Kind.indexSignature:
        return monaco_editor_core_exports.languages.CompletionItemKind.Function;
      case Kind.enum:
        return monaco_editor_core_exports.languages.CompletionItemKind.Enum;
      case Kind.module:
        return monaco_editor_core_exports.languages.CompletionItemKind.Module;
      case Kind.class:
        return monaco_editor_core_exports.languages.CompletionItemKind.Class;
      case Kind.interface:
        return monaco_editor_core_exports.languages.CompletionItemKind.Interface;
      case Kind.warning:
        return monaco_editor_core_exports.languages.CompletionItemKind.File;
    }
    return monaco_editor_core_exports.languages.CompletionItemKind.Property;
  }
  static createDocumentationString(details) {
    let documentationString = displayPartsToString(details.documentation);
    if (details.tags) {
      for (const tag of details.tags) {
        documentationString += `

${tagToString(tag)}`;
      }
    }
    return documentationString;
  }
};
function tagToString(tag) {
  let tagLabel = `*@${tag.name}*`;
  if (tag.name === "param" && tag.text) {
    const [paramName, ...rest] = tag.text;
    tagLabel += `\`${paramName.text}\``;
    if (rest.length > 0)
      tagLabel += ` \u2014 ${rest.map((r) => r.text).join(" ")}`;
  } else if (Array.isArray(tag.text)) {
    tagLabel += ` \u2014 ${tag.text.map((r) => r.text).join(" ")}`;
  } else if (tag.text) {
    tagLabel += ` \u2014 ${tag.text}`;
  }
  return tagLabel;
}
var SignatureHelpAdapter = class extends Adapter {
  signatureHelpTriggerCharacters = ["(", ","];
  static _toSignatureHelpTriggerReason(context) {
    switch (context.triggerKind) {
      case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.TriggerCharacter:
        if (context.triggerCharacter) {
          if (context.isRetrigger) {
            return { kind: "retrigger", triggerCharacter: context.triggerCharacter };
          } else {
            return { kind: "characterTyped", triggerCharacter: context.triggerCharacter };
          }
        } else {
          return { kind: "invoked" };
        }
      case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.ContentChange:
        return context.isRetrigger ? { kind: "retrigger" } : { kind: "invoked" };
      case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.Invoke:
      default:
        return { kind: "invoked" };
    }
  }
  async provideSignatureHelp(model, position, token, context) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const info = await worker.getSignatureHelpItems(resource.toString(), offset, {
      triggerReason: SignatureHelpAdapter._toSignatureHelpTriggerReason(context)
    });
    if (!info || model.isDisposed()) {
      return;
    }
    const ret = {
      activeSignature: info.selectedItemIndex,
      activeParameter: info.argumentIndex,
      signatures: []
    };
    info.items.forEach((item) => {
      const signature = {
        label: "",
        parameters: []
      };
      signature.documentation = {
        value: displayPartsToString(item.documentation)
      };
      signature.label += displayPartsToString(item.prefixDisplayParts);
      item.parameters.forEach((p, i, a) => {
        const label = displayPartsToString(p.displayParts);
        const parameter = {
          label,
          documentation: {
            value: displayPartsToString(p.documentation)
          }
        };
        signature.label += label;
        signature.parameters.push(parameter);
        if (i < a.length - 1) {
          signature.label += displayPartsToString(item.separatorDisplayParts);
        }
      });
      signature.label += displayPartsToString(item.suffixDisplayParts);
      ret.signatures.push(signature);
    });
    return {
      value: ret,
      dispose() {
      }
    };
  }
};
var QuickInfoAdapter = class extends Adapter {
  async provideHover(model, position, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const info = await worker.getQuickInfoAtPosition(resource.toString(), offset);
    if (!info || model.isDisposed()) {
      return;
    }
    const documentation = displayPartsToString(info.documentation);
    const tags = info.tags ? info.tags.map((tag) => tagToString(tag)).join("  \n\n") : "";
    const contents = displayPartsToString(info.displayParts);
    return {
      range: this._textSpanToRange(model, info.textSpan),
      contents: [
        {
          value: "```typescript\n" + contents + "\n```\n"
        },
        {
          value: documentation + (tags ? "\n\n" + tags : "")
        }
      ]
    };
  }
};
var OccurrencesAdapter = class extends Adapter {
  async provideDocumentHighlights(model, position, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const entries = await worker.getOccurrencesAtPosition(resource.toString(), offset);
    if (!entries || model.isDisposed()) {
      return;
    }
    return entries.map((entry) => {
      return {
        range: this._textSpanToRange(model, entry.textSpan),
        kind: entry.isWriteAccess ? monaco_editor_core_exports.languages.DocumentHighlightKind.Write : monaco_editor_core_exports.languages.DocumentHighlightKind.Text
      };
    });
  }
};
var DefinitionAdapter = class extends Adapter {
  constructor(_libFiles, worker) {
    super(worker);
    this._libFiles = _libFiles;
  }
  async provideDefinition(model, position, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const entries = await worker.getDefinitionAtPosition(resource.toString(), offset);
    if (!entries || model.isDisposed()) {
      return;
    }
    await this._libFiles.fetchLibFilesIfNecessary(entries.map((entry) => monaco_editor_core_exports.Uri.parse(entry.fileName)));
    if (model.isDisposed()) {
      return;
    }
    const result = [];
    for (let entry of entries) {
      const refModel = this._libFiles.getOrCreateModel(entry.fileName);
      if (refModel) {
        result.push({
          uri: refModel.uri,
          range: this._textSpanToRange(refModel, entry.textSpan)
        });
      }
    }
    return result;
  }
};
var ReferenceAdapter = class extends Adapter {
  constructor(_libFiles, worker) {
    super(worker);
    this._libFiles = _libFiles;
  }
  async provideReferences(model, position, context, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const entries = await worker.getReferencesAtPosition(resource.toString(), offset);
    if (!entries || model.isDisposed()) {
      return;
    }
    await this._libFiles.fetchLibFilesIfNecessary(entries.map((entry) => monaco_editor_core_exports.Uri.parse(entry.fileName)));
    if (model.isDisposed()) {
      return;
    }
    const result = [];
    for (let entry of entries) {
      const refModel = this._libFiles.getOrCreateModel(entry.fileName);
      if (refModel) {
        result.push({
          uri: refModel.uri,
          range: this._textSpanToRange(refModel, entry.textSpan)
        });
      }
    }
    return result;
  }
};
var OutlineAdapter = class extends Adapter {
  async provideDocumentSymbols(model, token) {
    const resource = model.uri;
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const items = await worker.getNavigationBarItems(resource.toString());
    if (!items || model.isDisposed()) {
      return;
    }
    const convert = (bucket, item, containerLabel) => {
      let result2 = {
        name: item.text,
        detail: "",
        kind: outlineTypeTable[item.kind] || monaco_editor_core_exports.languages.SymbolKind.Variable,
        range: this._textSpanToRange(model, item.spans[0]),
        selectionRange: this._textSpanToRange(model, item.spans[0]),
        tags: []
      };
      if (containerLabel)
        result2.containerName = containerLabel;
      if (item.childItems && item.childItems.length > 0) {
        for (let child of item.childItems) {
          convert(bucket, child, result2.name);
        }
      }
      bucket.push(result2);
    };
    let result = [];
    items.forEach((item) => convert(result, item));
    return result;
  }
};
var Kind = class {
};
__publicField(Kind, "unknown", "");
__publicField(Kind, "keyword", "keyword");
__publicField(Kind, "script", "script");
__publicField(Kind, "module", "module");
__publicField(Kind, "class", "class");
__publicField(Kind, "interface", "interface");
__publicField(Kind, "type", "type");
__publicField(Kind, "enum", "enum");
__publicField(Kind, "variable", "var");
__publicField(Kind, "localVariable", "local var");
__publicField(Kind, "function", "function");
__publicField(Kind, "localFunction", "local function");
__publicField(Kind, "memberFunction", "method");
__publicField(Kind, "memberGetAccessor", "getter");
__publicField(Kind, "memberSetAccessor", "setter");
__publicField(Kind, "memberVariable", "property");
__publicField(Kind, "constructorImplementation", "constructor");
__publicField(Kind, "callSignature", "call");
__publicField(Kind, "indexSignature", "index");
__publicField(Kind, "constructSignature", "construct");
__publicField(Kind, "parameter", "parameter");
__publicField(Kind, "typeParameter", "type parameter");
__publicField(Kind, "primitiveType", "primitive type");
__publicField(Kind, "label", "label");
__publicField(Kind, "alias", "alias");
__publicField(Kind, "const", "const");
__publicField(Kind, "let", "let");
__publicField(Kind, "warning", "warning");
var outlineTypeTable = /* @__PURE__ */ Object.create(null);
outlineTypeTable[Kind.module] = monaco_editor_core_exports.languages.SymbolKind.Module;
outlineTypeTable[Kind.class] = monaco_editor_core_exports.languages.SymbolKind.Class;
outlineTypeTable[Kind.enum] = monaco_editor_core_exports.languages.SymbolKind.Enum;
outlineTypeTable[Kind.interface] = monaco_editor_core_exports.languages.SymbolKind.Interface;
outlineTypeTable[Kind.memberFunction] = monaco_editor_core_exports.languages.SymbolKind.Method;
outlineTypeTable[Kind.memberVariable] = monaco_editor_core_exports.languages.SymbolKind.Property;
outlineTypeTable[Kind.memberGetAccessor] = monaco_editor_core_exports.languages.SymbolKind.Property;
outlineTypeTable[Kind.memberSetAccessor] = monaco_editor_core_exports.languages.SymbolKind.Property;
outlineTypeTable[Kind.variable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.const] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.localVariable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.variable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
outlineTypeTable[Kind.function] = monaco_editor_core_exports.languages.SymbolKind.Function;
outlineTypeTable[Kind.localFunction] = monaco_editor_core_exports.languages.SymbolKind.Function;
var FormatHelper = class extends Adapter {
  static _convertOptions(options) {
    return {
      ConvertTabsToSpaces: options.insertSpaces,
      TabSize: options.tabSize,
      IndentSize: options.tabSize,
      IndentStyle: 2 /* Smart */,
      NewLineCharacter: "\n",
      InsertSpaceAfterCommaDelimiter: true,
      InsertSpaceAfterSemicolonInForStatements: true,
      InsertSpaceBeforeAndAfterBinaryOperators: true,
      InsertSpaceAfterKeywordsInControlFlowStatements: true,
      InsertSpaceAfterFunctionKeywordForAnonymousFunctions: true,
      InsertSpaceAfterOpeningAndBeforeClosingNonemptyParenthesis: false,
      InsertSpaceAfterOpeningAndBeforeClosingNonemptyBrackets: false,
      InsertSpaceAfterOpeningAndBeforeClosingTemplateStringBraces: false,
      PlaceOpenBraceOnNewLineForControlBlocks: false,
      PlaceOpenBraceOnNewLineForFunctions: false
    };
  }
  _convertTextChanges(model, change) {
    return {
      text: change.newText,
      range: this._textSpanToRange(model, change.span)
    };
  }
};
var FormatAdapter = class extends FormatHelper {
  async provideDocumentRangeFormattingEdits(model, range, options, token) {
    const resource = model.uri;
    const startOffset = model.getOffsetAt({
      lineNumber: range.startLineNumber,
      column: range.startColumn
    });
    const endOffset = model.getOffsetAt({
      lineNumber: range.endLineNumber,
      column: range.endColumn
    });
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const edits = await worker.getFormattingEditsForRange(resource.toString(), startOffset, endOffset, FormatHelper._convertOptions(options));
    if (!edits || model.isDisposed()) {
      return;
    }
    return edits.map((edit) => this._convertTextChanges(model, edit));
  }
};
var FormatOnTypeAdapter = class extends FormatHelper {
  get autoFormatTriggerCharacters() {
    return [";", "}", "\n"];
  }
  async provideOnTypeFormattingEdits(model, position, ch, options, token) {
    const resource = model.uri;
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const edits = await worker.getFormattingEditsAfterKeystroke(resource.toString(), offset, ch, FormatHelper._convertOptions(options));
    if (!edits || model.isDisposed()) {
      return;
    }
    return edits.map((edit) => this._convertTextChanges(model, edit));
  }
};
var CodeActionAdaptor = class extends FormatHelper {
  async provideCodeActions(model, range, context, token) {
    const resource = model.uri;
    const start = model.getOffsetAt({
      lineNumber: range.startLineNumber,
      column: range.startColumn
    });
    const end = model.getOffsetAt({
      lineNumber: range.endLineNumber,
      column: range.endColumn
    });
    const formatOptions = FormatHelper._convertOptions(model.getOptions());
    const errorCodes = context.markers.filter((m) => m.code).map((m) => m.code).map(Number);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const codeFixes = await worker.getCodeFixesAtPosition(resource.toString(), start, end, errorCodes, formatOptions);
    if (!codeFixes || model.isDisposed()) {
      return { actions: [], dispose: () => {
      } };
    }
    const actions = codeFixes.filter((fix) => {
      return fix.changes.filter((change) => change.isNewFile).length === 0;
    }).map((fix) => {
      return this._tsCodeFixActionToMonacoCodeAction(model, context, fix);
    });
    return {
      actions,
      dispose: () => {
      }
    };
  }
  _tsCodeFixActionToMonacoCodeAction(model, context, codeFix) {
    const edits = [];
    for (const change of codeFix.changes) {
      for (const textChange of change.textChanges) {
        edits.push({
          resource: model.uri,
          versionId: void 0,
          textEdit: {
            range: this._textSpanToRange(model, textChange.span),
            text: textChange.newText
          }
        });
      }
    }
    const action = {
      title: codeFix.description,
      edit: { edits },
      diagnostics: context.markers,
      kind: "quickfix"
    };
    return action;
  }
};
var RenameAdapter = class extends Adapter {
  constructor(_libFiles, worker) {
    super(worker);
    this._libFiles = _libFiles;
  }
  async provideRenameEdits(model, position, newName, token) {
    const resource = model.uri;
    const fileName = resource.toString();
    const offset = model.getOffsetAt(position);
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return;
    }
    const renameInfo = await worker.getRenameInfo(fileName, offset, {
      allowRenameOfImportPath: false
    });
    if (renameInfo.canRename === false) {
      return {
        edits: [],
        rejectReason: renameInfo.localizedErrorMessage
      };
    }
    if (renameInfo.fileToRename !== void 0) {
      throw new Error("Renaming files is not supported.");
    }
    const renameLocations = await worker.findRenameLocations(fileName, offset, false, false, false);
    if (!renameLocations || model.isDisposed()) {
      return;
    }
    const edits = [];
    for (const renameLocation of renameLocations) {
      const model2 = this._libFiles.getOrCreateModel(renameLocation.fileName);
      if (model2) {
        edits.push({
          resource: model2.uri,
          versionId: void 0,
          textEdit: {
            range: this._textSpanToRange(model2, renameLocation.textSpan),
            text: newName
          }
        });
      } else {
        throw new Error(`Unknown file ${renameLocation.fileName}.`);
      }
    }
    return { edits };
  }
};
var InlayHintsAdapter = class extends Adapter {
  async provideInlayHints(model, range, token) {
    const resource = model.uri;
    const fileName = resource.toString();
    const start = model.getOffsetAt({
      lineNumber: range.startLineNumber,
      column: range.startColumn
    });
    const end = model.getOffsetAt({
      lineNumber: range.endLineNumber,
      column: range.endColumn
    });
    const worker = await this._worker(resource);
    if (model.isDisposed()) {
      return null;
    }
    const tsHints = await worker.provideInlayHints(fileName, start, end);
    const hints = tsHints.map((hint) => {
      return {
        ...hint,
        label: hint.text,
        position: model.getPositionAt(hint.position),
        kind: this._convertHintKind(hint.kind)
      };
    });
    return { hints, dispose: () => {
    } };
  }
  _convertHintKind(kind) {
    switch (kind) {
      case "Parameter":
        return monaco_editor_core_exports.languages.InlayHintKind.Parameter;
      case "Type":
        return monaco_editor_core_exports.languages.InlayHintKind.Type;
      default:
        return monaco_editor_core_exports.languages.InlayHintKind.Type;
    }
  }
};

// src/language/typescript/tsMode.ts
var javaScriptWorker;
var typeScriptWorker;
function setupTypeScript(defaults) {
  typeScriptWorker = setupMode(defaults, "typescript");
}
function setupJavaScript(defaults) {
  javaScriptWorker = setupMode(defaults, "javascript");
}
function getJavaScriptWorker() {
  return new Promise((resolve, reject) => {
    if (!javaScriptWorker) {
      return reject("JavaScript not registered!");
    }
    resolve(javaScriptWorker);
  });
}
function getTypeScriptWorker() {
  return new Promise((resolve, reject) => {
    if (!typeScriptWorker) {
      return reject("TypeScript not registered!");
    }
    resolve(typeScriptWorker);
  });
}
function setupMode(defaults, modeId) {
  const client = new WorkerManager(modeId, defaults);
  const worker = (...uris) => {
    return client.getLanguageServiceWorker(...uris);
  };
  const libFiles = new LibFiles(worker);
  monaco_editor_core_exports.languages.registerCompletionItemProvider(modeId, new SuggestAdapter(worker));
  monaco_editor_core_exports.languages.registerSignatureHelpProvider(modeId, new SignatureHelpAdapter(worker));
  monaco_editor_core_exports.languages.registerHoverProvider(modeId, new QuickInfoAdapter(worker));
  monaco_editor_core_exports.languages.registerDocumentHighlightProvider(modeId, new OccurrencesAdapter(worker));
  monaco_editor_core_exports.languages.registerDefinitionProvider(modeId, new DefinitionAdapter(libFiles, worker));
  monaco_editor_core_exports.languages.registerReferenceProvider(modeId, new ReferenceAdapter(libFiles, worker));
  monaco_editor_core_exports.languages.registerDocumentSymbolProvider(modeId, new OutlineAdapter(worker));
  monaco_editor_core_exports.languages.registerDocumentRangeFormattingEditProvider(modeId, new FormatAdapter(worker));
  monaco_editor_core_exports.languages.registerOnTypeFormattingEditProvider(modeId, new FormatOnTypeAdapter(worker));
  monaco_editor_core_exports.languages.registerCodeActionProvider(modeId, new CodeActionAdaptor(worker));
  monaco_editor_core_exports.languages.registerRenameProvider(modeId, new RenameAdapter(libFiles, worker));
  monaco_editor_core_exports.languages.registerInlayHintsProvider(modeId, new InlayHintsAdapter(worker));
  new DiagnosticsAdapter(libFiles, defaults, modeId, worker);
  return worker;
}



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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