"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageManager = void 0;
const os = require("os");
const path = require("path");
/**
 * A node package manager
 */
class PackageManager {
    constructor(props) {
        this.lockFile = props.lockFile;
        this.installCommand = props.installCommand;
        this.runCommand = props.runCommand;
        this.argsSeparator = props.argsSeparator;
    }
    static fromLockFile(lockFilePath) {
        const lockFile = path.basename(lockFilePath);
        switch (lockFile) {
            case PackageManager.NPM.lockFile:
                return PackageManager.NPM;
            case PackageManager.YARN.lockFile:
                return PackageManager.YARN;
            case PackageManager.PNPM.lockFile:
                return PackageManager.PNPM;
            default:
                return PackageManager.NPM;
        }
    }
    runBinCommand(bin) {
        const [runCommand, ...runArgs] = this.runCommand;
        return [
            os.platform() === 'win32' ? `${runCommand}.cmd` : runCommand,
            ...runArgs,
            ...(this.argsSeparator ? [this.argsSeparator] : []),
            bin,
        ].join(' ');
    }
}
exports.PackageManager = PackageManager;
PackageManager.NPM = new PackageManager({
    lockFile: 'package-lock.json',
    installCommand: ['npm', 'ci'],
    runCommand: ['npx', '--no-install'],
});
PackageManager.YARN = new PackageManager({
    lockFile: 'yarn.lock',
    installCommand: ['yarn', 'install'],
    runCommand: ['yarn', 'run'],
});
PackageManager.PNPM = new PackageManager({
    lockFile: 'pnpm-lock.yaml',
    installCommand: ['pnpm', 'install'],
    runCommand: ['pnpm', 'exec'],
    argsSeparator: '--',
});
//# sourceMappingURL=data:application/json;base64,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