import os
import time

from io import BytesIO
from datetime import datetime

from urllib.request import urlopen
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart

from croniter import croniter
from flask.wrappers import Response

import jwt
import boto3
import flask
import requests

from .renderer.excel import ExcelRenderer
from .models import Session, AnalysisRun, AnalysisSend
from .constants import DATETIME_FORMAT

import logging

#import sys
#sys.path.insert(0, '/home/rajumummidi/Analytics-Apps/analytics-apps/asset-insights')
#import Kafka
#from Kafka import kafkaProcess



BASE_API_URL = os.getenv('DATA_API_BASE_URL', '')
AWS_ACCESS_KEY_ID = os.getenv('AWS_ACCESS_KEY_ID')
AWS_SECRET_ACCESS_KEY = os.getenv('AWS_SECRET_ACCESS_KEY')
REGION_NAME = os.getenv('REGION_NAME')
S3_BUCKET_NAME = os.getenv('S3_BUCKET_NAME')
API_RETRY = int(os.getenv('API_RETRY', 3))


def get_jwt_token():
    try:
        jwt_token = flask.request.cookies.get('OPSRAMP_JWT_TOKEN', '')
    except:  # outside Flask
        jwt_token = os.getenv('OPSRAMP_JWT_TOKEN', '')

    return jwt_token


def get_headers():
    headers = {
        'Authorization': f'Bearer {get_jwt_token()}'
    }

    return headers


def get_msp_id():
    msp_id = None
    jwt_token = get_jwt_token()
    if jwt_token:
        decoded = jwt.decode(jwt_token, options={"verify_signature": False})
        msp_id = decoded['orgId']

    return msp_id


def get_user_id():
    user_id = None
    jwt_token = get_jwt_token()
    if jwt_token:
        decoded = jwt.decode(jwt_token, options={"verify_signature": False})
        user_id = decoded['userId']

    return user_id


def call_requests(method, url, params=None, data=None, json=None, verify=True):
    headers = get_headers()
    retry = 1
    while retry <= API_RETRY:
        try:
            resp = requests.request(method, url, params=params, data=data, json=json, headers=headers, verify=verify)
        except requests.exceptions.ConnectionError:
            time.sleep(retry * 2)
            continue

        return resp


def call_get_requests(url, params=None, verify=True):
    return call_requests('GET', url, params, verify=verify)


def call_post_requests(url, params=None, data=None, verify=True):
    return call_requests('POST', url, params, data, verify=verify)


def is_authenticated():
    REQUIRE_AUTH_REDIRECT = os.getenv('REQUIRE_AUTH_REDIRECT') == 'true'
    if not REQUIRE_AUTH_REDIRECT:
        return True

    url = f'{BASE_API_URL}/api/v2/users/me'
    res = call_get_requests(url)

    return res.status_code == 200


def login_required(view):
    '''Decorator that check authentication'''
  
    def wrap(*args, **kwargs):
        if not is_authenticated():
            return Response('Not authorized', status=401)
        result = view(*args, **kwargs)
        return result
    return wrap


def get_epoc_from_datetime_string(str_datetime):
    timestamp = datetime.strptime(str_datetime, DATETIME_FORMAT).timestamp()
    return timestamp


def get_run_result(run_id, field=None, default_value=None):
    with Session() as session:
        run = session.query(AnalysisRun).filter_by(id=run_id).first()

    result = run.get_result() if run else {}
    if field:
        result = result.get(field, default_value)

    return result


def get_ses_client():
    return boto3.client('ses',
                        region_name=REGION_NAME,
                        aws_access_key_id=AWS_ACCESS_KEY_ID,
                        aws_secret_access_key=AWS_SECRET_ACCESS_KEY)


def send_email(subject, from_email, to_emails, body, attachment=None):
    message = MIMEMultipart()
    message['Subject'] = subject
    message['From'] = from_email
    message['To'] = to_emails

    # message body
    part = MIMEText(body, 'html')
    message.attach(part)

    if attachment:
        attachment_body = urlopen(attachment).read()
        part = MIMEApplication(attachment_body)
        part.add_header('Content-Disposition', 'attachment', filename=attachment)
        message.attach(part)

    resp = get_ses_client().send_raw_email(
        Source=message['From'],
        Destinations=to_emails.split(','),
        RawMessage={
            'Data': message.as_string()
        }
    )

    return resp


def upload_to_s3(content, location):
    '''
    :param: content: bytes
    :param: location: str
    '''
    s3 = boto3.resource('s3',
                        region_name=REGION_NAME,
                        aws_access_key_id=AWS_ACCESS_KEY_ID,
                        aws_secret_access_key=AWS_SECRET_ACCESS_KEY)
    object_url = f'https://{S3_BUCKET_NAME}.s3.{REGION_NAME}.amazonaws.com/{location}'

    try:
        s3.Bucket(S3_BUCKET_NAME).put_object(Body=content,
                                             Key=location,
                                             ACL='public-read')
        return object_url
    except Exception:
        pass


#def generate_pdf(analysis_run):
#    url = os.getenv("PDF_SERVICE")

#    data = {
#        'domain': analysis_run.analysis.app.app_domain,
#        'report': analysis_run.analysis.app.slug,
#        'run': analysis_run.id,
#        'route': '/full-view',
#        'jwt_token': get_jwt_token(),
#        'size': 'A4'
#    }

#    res = requests.post(url, data=data).json()

#    return res


def generate_pdf(analysis_run):
    a=1
    logging.error(f'{a} <******  generate_pdf utilities.py  ******>')
    url = os.getenv("PDF_SERVICE")
    
    data = {
        'domain': 'https://asura.opsramp.net',
        'report': 'analytics-apps',
        #'run': analysis_run,
        'route': '/full-view',
        'jwt_token': 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.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.dTqw-q291FAO-lfUQmrUD_I9QgWUnn0VIx1Q7j_QR4PF2f4XsAuE3sp6dsTditz1DzMirqfK3SkoGfhLiPfRtvSpRvTCZqVq2gFh18vKorUMVeK83yWEmofBwHfOCqtpPyeDSgY1qERDlhBna6dwce1k5Q8kfsYf3opqz5pExOLyEBSH5TDR4ST0tPmogDNlx4lqihcAP1fGKFrRpWNz9lOdXAxaUGtQqC1kkot5iGtJLKQDlUANG3ECn58VLo19tZEPrB0-wwyzyQ1Nwe5I4D6_h2UROaE4ILNnA44saBXHwxCbtU8sN8hjxide8wUZpX-Ye8AZrp6LER_r9_DPoA',
        'size': 'A4'
    }

    res = requests.post(url, data=data)
    logging.error(f'{res} <******  pdf-res utilities.py  ******>')	
    return res


def generate_excel(analysis_run, file_name=None):
    a=1
    logging.error(f'{a} <******  generate_excel utilities.py  ******>')
    try:
        excel_renderer = ExcelRenderer(analysis_run)
        workbook = excel_renderer.render()
    except Exception as ex:
        raise ex

    if file_name:
        output = None
        workbook.save(file_name)
    else:
        output = BytesIO()
        workbook.save(output)

    return output


def upload_excel(analysis_run, excel_file):
    timestamp = datetime.now().strftime("%Y-%m-%d-%H-%M-%S")
    s3_path = f'{analysis_run.analysis.app.slug}/excel/{timestamp}.xlsx'

    return upload_to_s3(excel_file, s3_path)


def run_scheduled_send(analysis_send, func_compute):
    a=1
    logging.error(f'{a} <******  run_schedule_send utilities.py  ******>')
    analysis_run = analysis_send.analysis.run(func_compute, None, True)
    logging.error(f'{analysis_run} <******  run_schedule_send analysis_run utilities.py  ******>')
    if analysis_run:
        if analysis_send.format == 'pdf':
            pdf_info = generate_pdf(analysis_run)
            attachment = pdf_info['Location']
        elif analysis_send.format == 'excel':
            excel_file = generate_excel(analysis_run)
            if excel_file:
                attachment = upload_excel(analysis_run, excel_file.getvalue())
            else:
                attachment = None

        with Session.begin() as session:
            update_send = session.query(AnalysisSend).filter_by(id=analysis_send.id).first()
            update_send.attachment = attachment
            update_send.is_ran = True

        to_emails = analysis_send.recepients
        send_email(analysis_send.subject, os.getenv('FROM_EMAIL'), to_emails, analysis_send.message, attachment)


def check_schedule_send(func_compute):
    a=1
    logging.error(f'{a} <******  check_schedule_send utilities.py  ******>')
    app_id = os.getenv('OAP_APP_ID')
    now = datetime.now()
    now_hour = datetime(now.year, now.month, now.day, now.hour)

    with Session() as session:
        sends = session.query(AnalysisSend) \
                       .filter_by(is_active=True) \
                       .filter(AnalysisSend.schedule.is_not(None)) \
                       .join(AnalysisSend.analysis) \
                       .filter_by(app_id=app_id).all()

    for send in sends:
        if croniter.is_valid(send.schedule) and croniter.match(send.schedule, now_hour):
            os.environ['OPSRAMP_JWT_TOKEN'] = send.jwt_token
            run_scheduled_send(send, func_compute)
            print(send.id, '='*10)
