"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactMetadataEntryType = void 0;
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aliyun:ros:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aliyun:ros:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aliyun:ros:error";
    /**
     * Represents the ROS logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aliyun:ros:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aliyun:ros:stack-tags";
})(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
//# sourceMappingURL=data:application/json;base64,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