# About Lila

Lila is a  Python framework based on Starlette and Pydantic. Designed for developers seeking simplicity, flexibility, and robustness, it enables efficient and customizable Web or API application development. Its modular structure and support for advanced configurations make it suitable for both beginners and experienced developers.


# Acerca de  Lila (Español)

Lila es un framework  de Python basado en Starlette y Pydantic. Diseñado para desarrolladores que buscan simplicidad, flexibilidad y robustez, permite crear aplicaciones Web o APIs de manera eficiente y personalizable. Su estructura modular y soporte para configuraciones avanzadas lo hacen ideal tanto para principiantes como para desarrolladores experimentados.

# Learning Lila
https://seip25.github.io/Lila 

# Documentación de Lila
https://seip25.github.io/Lila


https://pypi.org/project/lila-framework/   
 

## Key Features

- **Simplicity**: Intuitive and minimalist design.
- **Flexibility**: Support for multiple databases (MySQL, SQLite) and adaptation to various environments.
- **Speed**: Built on Starlette, known for its high performance in asynchronous applications.
- **Robust Validation**: Uses Pydantic to ensure consistent data.
- **Editable and Configurable**: Ready to use but fully customizable.
- **Multi-language Support**: Integrated support for multilingual applications.
- **Compatibility**: Can be used with frameworks like Next.js, Remix, and others.
- **Easy Migrations**: Quick and straightforward database configuration.
- **Jinja2 and HTML Sessions**: Ready-to-use with dynamic templates and session handling, while remaining compatible with React, Angular, Vue, and other frontend frameworks.
- **SQLAlchemy** :For the ORM or you can also use the connectors directly (mysql.connector, sqlite3, etc...)
- **JWT** :It comes integrated with helpers to generate tokens and the middleware already has a function that validates it.
- **Admin Panel**: Includes a built-in admin panel for easy management of your application's data and settings.
- **Robust Security**: Features IP blocking, URL filtering, and request sanitization to prevent malicious attacks and suspicious requests.
- **REST CRUD Generator**: Generate REST APIs with just a few lines of code. Includes field validations and middleware support.

---

## Características principales

- **Simplicidad**: Diseño intuitivo y minimalista.
- **Flexibilidad**: Soporte para múltiples bases de datos (MySQL, SQLite) y adaptación a diversos entornos.
- **Rapidez**: Basado en Starlette, conocido por su alto rendimiento en aplicaciones asíncronas.
- **Validación robusta**: Uso de Pydantic para garantizar datos consistentes.
- **Editable y configurable**: Todo está listo para usar, pero también es completamente personalizable.
- **Multi-idioma**: Soporte integrado para aplicaciones multilingües.
- **Compatibilidad**: Puede ser utilizado con frameworks como Next.js, Remix js, entre otros.
- **Migraciones sencillas**: Configuración rápida y fácil para bases de datos.
- **Jinja2 y sesiones HTML**: Listo para usar con plantillas dinámicas y manejo de sesiones, pero compatible con React, Angular, Vue, entre otros frameworks frontend.
- **SQLAlchemy** :Para la ORM o también se puede utilizar los connectores directamente(mysql.connector,sqlite3,etc...)
- **JWT** :Viene integrado con helpers para generar token y en el middleware ya viene una función que válida el mismo.
- **Panel de Administración**: Incluye un panel de administración integrado para gestionar fácilmente los datos y configuraciones de tu aplicación.
- **Seguridad Robusta**: Cuenta con bloqueo de IPs, filtrado de URLs y sanitización de solicitudes para prevenir ataques maliciosos y solicitudes sospechosas.
- **Generador de APIs REST**: Genera APIs REST con solo unas pocas líneas de código. Incluye validaciones de campos y soporte para middlewares.


---

## Installation (Instalación)
## Installation

### English

1. Install Lila Framework using pip:

```bash
   pip install lila-framework
    
```
2. Initialize your Lila project:
 ```bash
  lila-init
    
```
3. Run application:

```bash
   python app.py #Or python3 app.py
```

---

### Español

1. Instala Lila Framework usando pip:

```bash
   pip install lila-framework
    
```
2. Inicializa tu proyecto Lila:
 ```bash
  lila-init
    
```
3. Ejecutar aplicación:

```bash
   python app.py #Or python3 app.py
```
---

## Contributions (Contribuciones)

At this stage, all official modifications to the framework will be made only by the original author. However, any feedback or suggestions to improve the project are welcome.

Actualmente, todas las modificaciones oficiales al framework serán realizadas únicamente por el autor original. Sin embargo, se agradece cualquier comentario o sugerencia que pueda mejorar el proyecto.
