# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_io.ipynb (unless otherwise specified).

__all__ = ['load_dcm', 'load_mat', 'load_h5']

# Cell
from fastscript import call_parse, Param, bool_arg
from scipy import ndimage

import h5py
import math
import matplotlib.pyplot as plt
import numpy as np
import os
import pandas as pd
import pydicom
import scipy.io as spio

# Cell
def load_dcm(path_to_dicom_dir=None, sort_by_slice_location=True):
    """
    Loads DICOM data as a numpy array.

    Attributes:
        path_to_dicom_dir (str): Path to folder containing all dicom files for one subject
        sort_by_slice_location (bool): Whether to return array ordered by slice location

    Returns:
        pixel_array (arr): Array of pixel data
    """
    try:
        import gdcm

    except ImportError:
        print("GDCM needs to be installed.")
        print("Try: conda install -c conda-forge gdcm")

    if not path_to_dicom_dir.endswith(('/')):
        path_to_dicom_dir = f"{data_path}/"

    try:
        os.listdir(path_to_dicom_dir)

    except:
        print("path to dicom failed")

    else:
        df = pd.DataFrame()
        df['filename'] = os.listdir(path_to_dicom_dir)
        df['pathname'] = path_to_dicom_dir + df['filename']

        df['DS'] = [pydicom.dcmread(x) for x in df['pathname']]
        df['SOPInstanceUID'] = [x.SOPInstanceUID for x in df['DS']]
        df['SliceLoc'] = [x.InstanceNumber for x in df['DS']]
        df['Pixels'] = [x.pixel_array for x in df['DS']]
        tempo = df['DS'][0]
        im_at = tempo.AcquisitionMatrix, tempo.PixelSpacing

        if sort_by_slice_location == True:
            df = df.sort_values(by=['SliceLoc'])
        pixel_array = np.dstack(np.asarray(df['Pixels']))

        return pixel_array
    return None

# Cell
def load_mat(path_to_mat_file=None, key='img'):
    """
    Loads matlab data as a numpy array.

    Attributes:
        path_to_mat_file (str): Path to mat file containing image / segmentation
        key (str): key to load from matlab dictionary

    Returns:
        pixel_array (arr): Array of pixel data
    """

    try:
        os.path.isfile(path_to_mat_file)

    except:
        print("mat file not found")

    else:
        pixel_array = spio.loadmat(path_to_mat_file)[key]

        return pixel_array
    return None

# Cell
def load_h5(path_to_h5_file=None):
    """
    Loads h5 files into numpy array.

    Attributes:
        path_to_h5_file (str): Path h5 file for one subject

    Returns:
        h5_file_dict (dict): Dictionary of pixel data
    """

    try:
        h5_file = h5py.File(path_to_h5_file, 'r')

    except:
        print("File", str(path_to_h5_file), "not found.")
        print("Make sure file exists")

    else:
        h5_file_dict = dict()
        keys = h5_file.keys()

        for k in keys:
            h5_file_dict[k] = h5_file.get(k)

        return(h5_file_dict)