"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import grpc
import osmosis.lockup.query_pb2

class QueryStub:
    """Query defines the gRPC querier service."""

    def __init__(self, channel: grpc.Channel) -> None: ...
    ModuleBalance: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.ModuleBalanceRequest,
        osmosis.lockup.query_pb2.ModuleBalanceResponse,
    ]
    """Return full balance of the module"""
    ModuleLockedAmount: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.ModuleLockedAmountRequest,
        osmosis.lockup.query_pb2.ModuleLockedAmountResponse,
    ]
    """Return locked balance of the module"""
    AccountUnlockableCoins: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountUnlockableCoinsRequest,
        osmosis.lockup.query_pb2.AccountUnlockableCoinsResponse,
    ]
    """Returns unlockable coins which are not withdrawn yet"""
    AccountUnlockingCoins: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountUnlockingCoinsRequest,
        osmosis.lockup.query_pb2.AccountUnlockingCoinsResponse,
    ]
    """Returns unlocking coins"""
    AccountLockedCoins: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedCoinsRequest,
        osmosis.lockup.query_pb2.AccountLockedCoinsResponse,
    ]
    """Return a locked coins that can't be withdrawn"""
    AccountLockedPastTime: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedPastTimeRequest,
        osmosis.lockup.query_pb2.AccountLockedPastTimeResponse,
    ]
    """Returns locked records of an account with unlock time beyond timestamp"""
    AccountLockedPastTimeNotUnlockingOnly: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedPastTimeNotUnlockingOnlyRequest,
        osmosis.lockup.query_pb2.AccountLockedPastTimeNotUnlockingOnlyResponse,
    ]
    """Returns locked records of an account with unlock time beyond timestamp
    excluding tokens started unlocking
    """
    AccountUnlockedBeforeTime: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountUnlockedBeforeTimeRequest,
        osmosis.lockup.query_pb2.AccountUnlockedBeforeTimeResponse,
    ]
    """Returns unlocked records with unlock time before timestamp"""
    AccountLockedPastTimeDenom: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedPastTimeDenomRequest,
        osmosis.lockup.query_pb2.AccountLockedPastTimeDenomResponse,
    ]
    """Returns lock records by address, timestamp, denom"""
    LockedDenom: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.LockedDenomRequest,
        osmosis.lockup.query_pb2.LockedDenomResponse,
    ]
    """Returns total locked per denom with longer past given time"""
    LockedByID: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.LockedRequest,
        osmosis.lockup.query_pb2.LockedResponse,
    ]
    """Returns lock record by id"""
    SyntheticLockupsByLockupID: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.SyntheticLockupsByLockupIDRequest,
        osmosis.lockup.query_pb2.SyntheticLockupsByLockupIDResponse,
    ]
    """Returns synthetic lockups by native lockup id"""
    AccountLockedLongerDuration: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedLongerDurationRequest,
        osmosis.lockup.query_pb2.AccountLockedLongerDurationResponse,
    ]
    """Returns account locked records with longer duration"""
    AccountLockedDuration: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedDurationRequest,
        osmosis.lockup.query_pb2.AccountLockedDurationResponse,
    ]
    """Returns account locked records with a specific duration"""
    AccountLockedLongerDurationNotUnlockingOnly: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedLongerDurationNotUnlockingOnlyRequest,
        osmosis.lockup.query_pb2.AccountLockedLongerDurationNotUnlockingOnlyResponse,
    ]
    """Returns account locked records with longer duration excluding tokens
    started unlocking
    """
    AccountLockedLongerDurationDenom: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.AccountLockedLongerDurationDenomRequest,
        osmosis.lockup.query_pb2.AccountLockedLongerDurationDenomResponse,
    ]
    """Returns account's locked records for a denom with longer duration"""
    Params: grpc.UnaryUnaryMultiCallable[
        osmosis.lockup.query_pb2.QueryParamsRequest,
        osmosis.lockup.query_pb2.QueryParamsResponse,
    ]
    """Params returns lockup params."""

class QueryServicer(metaclass=abc.ABCMeta):
    """Query defines the gRPC querier service."""

    @abc.abstractmethod
    def ModuleBalance(
        self,
        request: osmosis.lockup.query_pb2.ModuleBalanceRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.ModuleBalanceResponse:
        """Return full balance of the module"""
    @abc.abstractmethod
    def ModuleLockedAmount(
        self,
        request: osmosis.lockup.query_pb2.ModuleLockedAmountRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.ModuleLockedAmountResponse:
        """Return locked balance of the module"""
    @abc.abstractmethod
    def AccountUnlockableCoins(
        self,
        request: osmosis.lockup.query_pb2.AccountUnlockableCoinsRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountUnlockableCoinsResponse:
        """Returns unlockable coins which are not withdrawn yet"""
    @abc.abstractmethod
    def AccountUnlockingCoins(
        self,
        request: osmosis.lockup.query_pb2.AccountUnlockingCoinsRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountUnlockingCoinsResponse:
        """Returns unlocking coins"""
    @abc.abstractmethod
    def AccountLockedCoins(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedCoinsRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedCoinsResponse:
        """Return a locked coins that can't be withdrawn"""
    @abc.abstractmethod
    def AccountLockedPastTime(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedPastTimeRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedPastTimeResponse:
        """Returns locked records of an account with unlock time beyond timestamp"""
    @abc.abstractmethod
    def AccountLockedPastTimeNotUnlockingOnly(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedPastTimeNotUnlockingOnlyRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedPastTimeNotUnlockingOnlyResponse:
        """Returns locked records of an account with unlock time beyond timestamp
        excluding tokens started unlocking
        """
    @abc.abstractmethod
    def AccountUnlockedBeforeTime(
        self,
        request: osmosis.lockup.query_pb2.AccountUnlockedBeforeTimeRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountUnlockedBeforeTimeResponse:
        """Returns unlocked records with unlock time before timestamp"""
    @abc.abstractmethod
    def AccountLockedPastTimeDenom(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedPastTimeDenomRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedPastTimeDenomResponse:
        """Returns lock records by address, timestamp, denom"""
    @abc.abstractmethod
    def LockedDenom(
        self,
        request: osmosis.lockup.query_pb2.LockedDenomRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.LockedDenomResponse:
        """Returns total locked per denom with longer past given time"""
    @abc.abstractmethod
    def LockedByID(
        self,
        request: osmosis.lockup.query_pb2.LockedRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.LockedResponse:
        """Returns lock record by id"""
    @abc.abstractmethod
    def SyntheticLockupsByLockupID(
        self,
        request: osmosis.lockup.query_pb2.SyntheticLockupsByLockupIDRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.SyntheticLockupsByLockupIDResponse:
        """Returns synthetic lockups by native lockup id"""
    @abc.abstractmethod
    def AccountLockedLongerDuration(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedLongerDurationRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedLongerDurationResponse:
        """Returns account locked records with longer duration"""
    @abc.abstractmethod
    def AccountLockedDuration(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedDurationRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedDurationResponse:
        """Returns account locked records with a specific duration"""
    @abc.abstractmethod
    def AccountLockedLongerDurationNotUnlockingOnly(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedLongerDurationNotUnlockingOnlyRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedLongerDurationNotUnlockingOnlyResponse:
        """Returns account locked records with longer duration excluding tokens
        started unlocking
        """
    @abc.abstractmethod
    def AccountLockedLongerDurationDenom(
        self,
        request: osmosis.lockup.query_pb2.AccountLockedLongerDurationDenomRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.AccountLockedLongerDurationDenomResponse:
        """Returns account's locked records for a denom with longer duration"""
    @abc.abstractmethod
    def Params(
        self,
        request: osmosis.lockup.query_pb2.QueryParamsRequest,
        context: grpc.ServicerContext,
    ) -> osmosis.lockup.query_pb2.QueryParamsResponse:
        """Params returns lockup params."""

def add_QueryServicer_to_server(servicer: QueryServicer, server: grpc.Server) -> None: ...
