"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
this is a legacy package that requires additional migration logic
in order to use the correct packge. Decision made to use legacy package path
until clear steps for migration logic and the unknowns for state breaking are
investigated for changing proto package.
"""
import builtins
import collections.abc
import cosmos.base.v1beta1.coin_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class SmoothWeightChangeParams(google.protobuf.message.Message):
    """Parameters for changing the weights in a balancer pool smoothly from
    a start weight and end weight over a period of time.
    Currently, the only smooth change supported is linear changing between
    the two weights, but more types may be added in the future.
    When these parameters are set, the weight w(t) for pool time `t` is the
    following:
      t <= start_time: w(t) = initial_pool_weights
      start_time < t <= start_time + duration:
        w(t) = initial_pool_weights + (t - start_time) *
          (target_pool_weights - initial_pool_weights) / (duration)
      t > start_time + duration: w(t) = target_pool_weights
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    INITIAL_POOL_WEIGHTS_FIELD_NUMBER: builtins.int
    TARGET_POOL_WEIGHTS_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The start time for beginning the weight change.
        If a parameter change / pool instantiation leaves this blank,
        it should be generated by the state_machine as the current time.
        """
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """Duration for the weights to change over"""
    @property
    def initial_pool_weights(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PoolAsset]:
        """The initial pool weights. These are copied from the pool's settings
        at the time of weight change instantiation.
        The amount PoolAsset.token.amount field is ignored if present,
        future type refactorings should just have a type with the denom & weight
        here.
        """
    @property
    def target_pool_weights(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PoolAsset]:
        """The target pool weights. The pool weights will change linearly with respect
        to time between start_time, and start_time + duration. The amount
        PoolAsset.token.amount field is ignored if present, future type
        refactorings should just have a type with the denom & weight here.
        Intermediate variable for the 'slope' of pool weights. This is equal to
        (target_pool_weights - initial_pool_weights) / (duration)
        TODO: Work out precision, and decide if this is good to add
        repeated PoolAsset poolWeightSlope = 5 [
         (gogoproto.moretags) = "yaml:\\"pool_weight_slope\\"",
         (gogoproto.nullable) = false
        ];
        """
    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
        initial_pool_weights: collections.abc.Iterable[global___PoolAsset] | None = ...,
        target_pool_weights: collections.abc.Iterable[global___PoolAsset] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["duration", b"duration", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["duration", b"duration", "initial_pool_weights", b"initial_pool_weights", "start_time", b"start_time", "target_pool_weights", b"target_pool_weights"]) -> None: ...

global___SmoothWeightChangeParams = SmoothWeightChangeParams

@typing_extensions.final
class PoolParams(google.protobuf.message.Message):
    """PoolParams defined the parameters that will be managed by the pool
    governance in the future. This params are not managed by the chain
    governance. Instead they will be managed by the token holders of the pool.
    The pool's token holders are specified in future_pool_governor.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SWAP_FEE_FIELD_NUMBER: builtins.int
    EXIT_FEE_FIELD_NUMBER: builtins.int
    SMOOTH_WEIGHT_CHANGE_PARAMS_FIELD_NUMBER: builtins.int
    swap_fee: builtins.str
    exit_fee: builtins.str
    @property
    def smooth_weight_change_params(self) -> global___SmoothWeightChangeParams: ...
    def __init__(
        self,
        *,
        swap_fee: builtins.str = ...,
        exit_fee: builtins.str = ...,
        smooth_weight_change_params: global___SmoothWeightChangeParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["smooth_weight_change_params", b"smooth_weight_change_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["exit_fee", b"exit_fee", "smooth_weight_change_params", b"smooth_weight_change_params", "swap_fee", b"swap_fee"]) -> None: ...

global___PoolParams = PoolParams

@typing_extensions.final
class PoolAsset(google.protobuf.message.Message):
    """Pool asset is an internal struct that combines the amount of the
    token in the pool, and its balancer weight.
    This is an awkward packaging of data,
    and should be revisited in a future state migration.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    @property
    def token(self) -> cosmos.base.v1beta1.coin_pb2.Coin:
        """Coins we are talking about,
        the denomination must be unique amongst all PoolAssets for this pool.
        """
    weight: builtins.str
    """Weight that is not normalized. This weight must be less than 2^50"""
    def __init__(
        self,
        *,
        token: cosmos.base.v1beta1.coin_pb2.Coin | None = ...,
        weight: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["token", b"token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["token", b"token", "weight", b"weight"]) -> None: ...

global___PoolAsset = PoolAsset

@typing_extensions.final
class Pool(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    POOL_PARAMS_FIELD_NUMBER: builtins.int
    FUTURE_POOL_GOVERNOR_FIELD_NUMBER: builtins.int
    TOTAL_SHARES_FIELD_NUMBER: builtins.int
    POOL_ASSETS_FIELD_NUMBER: builtins.int
    TOTAL_WEIGHT_FIELD_NUMBER: builtins.int
    address: builtins.str
    id: builtins.int
    @property
    def pool_params(self) -> global___PoolParams: ...
    future_pool_governor: builtins.str
    """This string specifies who will govern the pool in the future.
    Valid forms of this are:
    {token name},{duration}
    {duration}
    where {token name} if specified is the token which determines the
    governor, and if not specified is the LP token for this pool.duration is
    a time specified as 0w,1w,2w, etc. which specifies how long the token
    would need to be locked up to count in governance. 0w means no lockup.
    TODO: Further improve these docs
    """
    @property
    def total_shares(self) -> cosmos.base.v1beta1.coin_pb2.Coin:
        """sum of all LP tokens sent out"""
    @property
    def pool_assets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PoolAsset]:
        """These are assumed to be sorted by denomiation.
        They contain the pool asset and the information about the weight
        """
    total_weight: builtins.str
    """sum of all non-normalized pool weights"""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
        id: builtins.int = ...,
        pool_params: global___PoolParams | None = ...,
        future_pool_governor: builtins.str = ...,
        total_shares: cosmos.base.v1beta1.coin_pb2.Coin | None = ...,
        pool_assets: collections.abc.Iterable[global___PoolAsset] | None = ...,
        total_weight: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pool_params", b"pool_params", "total_shares", b"total_shares"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["address", b"address", "future_pool_governor", b"future_pool_governor", "id", b"id", "pool_assets", b"pool_assets", "pool_params", b"pool_params", "total_shares", b"total_shares", "total_weight", b"total_weight"]) -> None: ...

global___Pool = Pool
