# stackl-client
stackl

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import stackl_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import stackl_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import stackl_client
from stackl_client.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"
# Enter a context with an instance of the API client
with stackl_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = stackl_client.AboutApi(api_client)
    
    try:
        # Get Hostname
        api_response = api_instance.get_hostname()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AboutApi->get_hostname: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AboutApi* | [**get_hostname**](docs/AboutApi.md#get_hostname) | **GET** /about | Get Hostname
*ConfiguratorApi* | [**delete_configurator_file**](docs/ConfiguratorApi.md#delete_configurator_file) | **DELETE** /configurator/{state} | Delete Configurator File
*ConfiguratorApi* | [**get_configurator_file**](docs/ConfiguratorApi.md#get_configurator_file) | **GET** /configurator/{state} | Get Configurator File
*ConfiguratorApi* | [**post_configurator_file**](docs/ConfiguratorApi.md#post_configurator_file) | **POST** /configurator/{state} | Post Configurator File
*DocumentsApi* | [**delete_document**](docs/DocumentsApi.md#delete_document) | **DELETE** /documents/{type_name}/{document_name} | Delete Document
*DocumentsApi* | [**get_all_documents_by_type**](docs/DocumentsApi.md#get_all_documents_by_type) | **GET** /documents/{type_name} | Get All Documents By Type
*DocumentsApi* | [**get_document_by_type_and_name**](docs/DocumentsApi.md#get_document_by_type_and_name) | **GET** /documents/{type_name}/{document_name} | Get Document By Type And Name
*DocumentsApi* | [**get_types**](docs/DocumentsApi.md#get_types) | **GET** /documents/types | Get Types
*DocumentsApi* | [**post_document**](docs/DocumentsApi.md#post_document) | **POST** /documents | Post Document
*DocumentsApi* | [**put_document**](docs/DocumentsApi.md#put_document) | **PUT** /documents | Put Document
*FunctionalRequirementsApi* | [**delete_functional_requirement**](docs/FunctionalRequirementsApi.md#delete_functional_requirement) | **DELETE** /functional_requirements/{document_name} | Delete Functional Requirement
*FunctionalRequirementsApi* | [**get_functional_requirement_by_name**](docs/FunctionalRequirementsApi.md#get_functional_requirement_by_name) | **GET** /functional_requirements/{document_name} | Get Functional Requirement By Name
*FunctionalRequirementsApi* | [**get_functional_requirements**](docs/FunctionalRequirementsApi.md#get_functional_requirements) | **GET** /functional_requirements | Get Functional Requirements
*FunctionalRequirementsApi* | [**post_functional_requirement**](docs/FunctionalRequirementsApi.md#post_functional_requirement) | **POST** /functional_requirements | Post Functional Requirement
*FunctionalRequirementsApi* | [**put_functional_requirement**](docs/FunctionalRequirementsApi.md#put_functional_requirement) | **PUT** /functional_requirements | Put Functional Requirement
*PolicyAgentApi* | [**delete_data**](docs/PolicyAgentApi.md#delete_data) | **DELETE** /policy_agent/data | Delete Data
*PolicyAgentApi* | [**delete_policy**](docs/PolicyAgentApi.md#delete_policy) | **DELETE** /policy_agent/policy | Delete Policy
*PolicyAgentApi* | [**get_agent_policies**](docs/PolicyAgentApi.md#get_agent_policies) | **GET** /policy_agent/all | Get Agent Policies
*PolicyAgentApi* | [**get_data**](docs/PolicyAgentApi.md#get_data) | **GET** /policy_agent/data | Get Data
*PolicyAgentApi* | [**get_sat_data_from_sat**](docs/PolicyAgentApi.md#get_sat_data_from_sat) | **GET** /policy_agent/query/sat_data | Get Sat Data From Sat
*PolicyAgentApi* | [**get_sat_policies_from_sat**](docs/PolicyAgentApi.md#get_sat_policies_from_sat) | **GET** /policy_agent/query/sat_policies | Get Sat Policies From Sat
*PolicyAgentApi* | [**get_sit_data_from_sit**](docs/PolicyAgentApi.md#get_sit_data_from_sit) | **GET** /policy_agent/query/sit_data | Get Sit Data From Sit
*PolicyAgentApi* | [**get_sit_policies_from_sit**](docs/PolicyAgentApi.md#get_sit_policies_from_sit) | **GET** /policy_agent/query/sit_policies | Get Sit Policies From Sit
*PolicyAgentApi* | [**put_data**](docs/PolicyAgentApi.md#put_data) | **PUT** /policy_agent/data | Put Data
*PolicyAgentApi* | [**put_sat_policies**](docs/PolicyAgentApi.md#put_sat_policies) | **PUT** /policy_agent/sat | Put Sat Policies
*PolicyAgentApi* | [**put_sit_policies**](docs/PolicyAgentApi.md#put_sit_policies) | **PUT** /policy_agent/sit | Put Sit Policies
*PolicyAgentApi* | [**run_query_for_sit_and_sat**](docs/PolicyAgentApi.md#run_query_for_sit_and_sat) | **GET** /policy_agent/query | Run Query For Sit And Sat
*PolicyTemplatesApi* | [**get_policy_template_by_name**](docs/PolicyTemplatesApi.md#get_policy_template_by_name) | **GET** /policy_templates/{policy_name} | Get Policy Template By Name
*PolicyTemplatesApi* | [**get_policy_templates**](docs/PolicyTemplatesApi.md#get_policy_templates) | **GET** /policy_templates | Get Policy Templates
*PolicyTemplatesApi* | [**put_policy_template**](docs/PolicyTemplatesApi.md#put_policy_template) | **PUT** /policy_templates | Put Policy Template
*ServicesApi* | [**delete_service**](docs/ServicesApi.md#delete_service) | **DELETE** /services/{document_name} | Delete Service
*ServicesApi* | [**get_service_by_name**](docs/ServicesApi.md#get_service_by_name) | **GET** /services/{document_name} | Get Service By Name
*ServicesApi* | [**get_services**](docs/ServicesApi.md#get_services) | **GET** /services | Get Services
*ServicesApi* | [**post_service**](docs/ServicesApi.md#post_service) | **POST** /services | Post Service
*ServicesApi* | [**put_service**](docs/ServicesApi.md#put_service) | **PUT** /services | Put Service
*StackApplicationTemplatesApi* | [**delete_stack_application_template**](docs/StackApplicationTemplatesApi.md#delete_stack_application_template) | **DELETE** /stack_application_templates/{document_name} | Delete Stack Application Template
*StackApplicationTemplatesApi* | [**get_stack_application_template_by_name**](docs/StackApplicationTemplatesApi.md#get_stack_application_template_by_name) | **GET** /stack_application_templates/{document_name} | Get Stack Application Template By Name
*StackApplicationTemplatesApi* | [**get_stack_application_templates**](docs/StackApplicationTemplatesApi.md#get_stack_application_templates) | **GET** /stack_application_templates | Get Stack Application Templates
*StackApplicationTemplatesApi* | [**post_stack_application_template**](docs/StackApplicationTemplatesApi.md#post_stack_application_template) | **POST** /stack_application_templates | Post Stack Application Template
*StackApplicationTemplatesApi* | [**put_stack_application_template**](docs/StackApplicationTemplatesApi.md#put_stack_application_template) | **PUT** /stack_application_templates | Put Stack Application Template
*StackInfrastructureTemplatesApi* | [**delete_stack_infrastructure_template**](docs/StackInfrastructureTemplatesApi.md#delete_stack_infrastructure_template) | **DELETE** /stack_infrastructure_templates/{document_name} | Delete Stack Infrastructure Template
*StackInfrastructureTemplatesApi* | [**get_stack_infrastructure_template_by_name**](docs/StackInfrastructureTemplatesApi.md#get_stack_infrastructure_template_by_name) | **GET** /stack_infrastructure_templates/{document_name} | Get Stack Infrastructure Template By Name
*StackInfrastructureTemplatesApi* | [**get_stack_infrastructure_templates**](docs/StackInfrastructureTemplatesApi.md#get_stack_infrastructure_templates) | **GET** /stack_infrastructure_templates | Get Stack Infrastructure Templates
*StackInfrastructureTemplatesApi* | [**post_stack_infrastructure_template**](docs/StackInfrastructureTemplatesApi.md#post_stack_infrastructure_template) | **POST** /stack_infrastructure_templates | Post Stack Infrastructure Template
*StackInfrastructureTemplatesApi* | [**put_stack_infrastructure_template**](docs/StackInfrastructureTemplatesApi.md#put_stack_infrastructure_template) | **PUT** /stack_infrastructure_templates | Put Stack Infrastructure Template
*StackInstancesApi* | [**delete_stack_instance**](docs/StackInstancesApi.md#delete_stack_instance) | **DELETE** /stack_instances/{stack_instance_name} | Delete Stack Instance
*StackInstancesApi* | [**get_stack_instance**](docs/StackInstancesApi.md#get_stack_instance) | **GET** /stack_instances/{stack_instance_name} | Get Stack Instance
*StackInstancesApi* | [**get_stack_instances**](docs/StackInstancesApi.md#get_stack_instances) | **GET** /stack_instances | Get Stack Instances
*StackInstancesApi* | [**post_stack_instance**](docs/StackInstancesApi.md#post_stack_instance) | **POST** /stack_instances | Post Stack Instance
*StackInstancesApi* | [**put_stack_instance**](docs/StackInstancesApi.md#put_stack_instance) | **PUT** /stack_instances | Put Stack Instance


## Documentation For Models

 - [CollectionDocument](docs/CollectionDocument.md)
 - [FunctionalRequirement](docs/FunctionalRequirement.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [InfrastructureBaseDocument](docs/InfrastructureBaseDocument.md)
 - [InfrastructureTarget](docs/InfrastructureTarget.md)
 - [Invocation](docs/Invocation.md)
 - [PolicyTemplate](docs/PolicyTemplate.md)
 - [Service](docs/Service.md)
 - [StackApplicationTemplate](docs/StackApplicationTemplate.md)
 - [StackInfrastructureTemplate](docs/StackInfrastructureTemplate.md)
 - [StackInstance](docs/StackInstance.md)
 - [StackInstanceInvocation](docs/StackInstanceInvocation.md)
 - [StackInstanceService](docs/StackInstanceService.md)
 - [StackInstanceStatus](docs/StackInstanceStatus.md)
 - [StackInstanceUpdate](docs/StackInstanceUpdate.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




