###########################################################################################
# Copyright 2024 Garmin International, Inc.
# Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
# may not use this file except in compliance with the Flexible and Interoperable Data
# Transfer (FIT) Protocol License.
###########################################################################################
# ****WARNING****  This file is auto-generated!  Do NOT edit this file.
# Profile Version = 21.158.0Release
# Tag = production/release/21.158.0-0-gc9428aa
############################################################################################


Profile = {
    'version': {
        'major': 21,
        'minor': 158,
        'patch': 0,
        'type': "Release"
    },
    'common_fields': {
        'part_index': 250,
        'timestamp': 253,
        'message_index': 254
    },
    'messages': {
        0: {
        'num': "0", # Must be first message in file.
        'name': "file_id",
        'messages_key': "file_id_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "type",
            'type': "file",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "manufacturer",
            'type': "manufacturer",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "product",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "favero_product", 
                'type': "favero_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 263, 'value_name': "favero_electronics" },
                ],
               },
               {
                'name': "garmin_product", 
                'type': "garmin_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 1, 'value_name': "garmin" },
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 15, 'value_name': "dynastream" },
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 13, 'value_name': "dynastream_oem" },
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 89, 'value_name': "tacx" },
                ],
               },
               ]
            },
        3: {
            'num': 3,
            'name': "serial_number",
            'type': "uint32z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Only set for files that are can be created/erased.
            'name': "time_created",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Only set for files that are not created/erased.
            'name': "number",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Optional free form string to indicate the devices name or model
            'name': "product_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        49: {
        'num': "49",
        'name': "file_creator",
        'messages_key': "file_creator_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "software_version",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "hardware_version",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        162: {
        'num': "162",
        'name': "timestamp_correlation",
        'messages_key': "timestamp_correlation_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of UTC timestamp at the time the system timestamp was recorded.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Fractional part of the UTC timestamp at the time the system timestamp was recorded.
            'name': "fractional_timestamp",
            'type': "uint16",
            'array': "false",
            'scale': [32768],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Whole second part of the system timestamp
            'name': "system_timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Fractional part of the system timestamp
            'name': "fractional_system_timestamp",
            'type': "uint16",
            'array': "false",
            'scale': [32768],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # timestamp epoch expressed in local time used to convert timestamps to local time
            'name': "local_timestamp",
            'type': "local_date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Millisecond part of the UTC timestamp at the time the system timestamp was recorded.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Millisecond part of the system timestamp
            'name': "system_timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        35: {
        'num': "35",
        'name': "software",
        'messages_key': "software_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "version",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "part_number",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        106: {
        'num': "106",
        'name': "slave_device",
        'messages_key': "slave_device_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "manufacturer",
            'type': "manufacturer",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "product",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "favero_product", 
                'type': "favero_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 263, 'value_name': "favero_electronics" },
                ],
               },
               {
                'name': "garmin_product", 
                'type': "garmin_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 1, 'value_name': "garmin" },
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 15, 'value_name': "dynastream" },
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 13, 'value_name': "dynastream_oem" },
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 89, 'value_name': "tacx" },
                ],
               },
               ]
            },
    },
},
        1: {
        'num': "1",
        'name': "capabilities",
        'messages_key': "capabilities_mesgs",
        'fields': {
        0: {
            'num': 0, # Use language_bits_x types where x is index of array.
            'name': "languages",
            'type': "uint8z",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Use sport_bits_x types where x is index of array.
            'name': "sports",
            'type': "sport_bits_0",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "workouts_supported",
            'type': "workout_capabilities",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "connectivity_supported",
            'type': "connectivity_capabilities",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        37: {
        'num': "37",
        'name': "file_capabilities",
        'messages_key': "file_capabilities_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "type",
            'type': "file",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "flags",
            'type': "file_flags",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "directory",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "max_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "max_size",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bytes",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        38: {
        'num': "38",
        'name': "mesg_capabilities",
        'messages_key': "mesg_capabilities_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "file",
            'type': "file",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "mesg_num",
            'type': "mesg_num",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "count_type",
            'type': "mesg_count",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "num_per_file", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 2, 'name': "count_type", 'raw_value': 0, 'value_name': "num_per_file" },
                ],
               },
               {
                'name': "max_per_file", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 2, 'name': "count_type", 'raw_value': 1, 'value_name': "max_per_file" },
                ],
               },
               {
                'name': "max_per_file_type", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 2, 'name': "count_type", 'raw_value': 2, 'value_name': "max_per_file_type" },
                ],
               },
               ]
            },
    },
},
        39: {
        'num': "39",
        'name': "field_capabilities",
        'messages_key': "field_capabilities_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "file",
            'type': "file",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "mesg_num",
            'type': "mesg_num",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "field_num",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        2: {
        'num': "2",
        'name': "device_settings",
        'messages_key': "device_settings_mesgs",
        'fields': {
        0: {
            'num': 0, # Index into time zone arrays.
            'name': "active_time_zone",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Offset from system time. Required to convert timestamp from system time to UTC.
            'name': "utc_offset",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Offset from system time.
            'name': "time_offset",
            'type': "uint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Display mode for the time
            'name': "time_mode",
            'type': "time_mode",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # timezone offset in 1/4 hour increments
            'name': "time_zone_offset",
            'type': "sint8",
            'array': "true",
            'scale': [4],
            'offset': [0],
            'units': "hr",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # Mode for backlight
            'name': "backlight_mode",
            'type': "backlight_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        36: {
            'num': 36, # Enabled state of the activity tracker functionality
            'name': "activity_tracker_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        39: {
            'num': 39, # UTC timestamp used to set the devices clock and date
            'name': "clock_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        40: {
            'num': 40, # Bitfield to configure enabled screens for each supported loop
            'name': "pages_enabled",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        46: {
            'num': 46, # Enabled state of the move alert
            'name': "move_alert_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        47: {
            'num': 47, # Display mode for the date
            'name': "date_mode",
            'type': "date_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        55: {
            'num': 55,
            'name': "display_orientation",
            'type': "display_orientation",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        56: {
            'num': 56,
            'name': "mounting_side",
            'type': "side",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        57: {
            'num': 57, # Bitfield to indicate one page as default for each supported loop
            'name': "default_page",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        58: {
            'num': 58, # Minimum steps before an autosync can occur
            'name': "autosync_min_steps",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "steps",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        59: {
            'num': 59, # Minimum minutes before an autosync can occur
            'name': "autosync_min_time",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "minutes",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        80: {
            'num': 80, # Enable auto-detect setting for the lactate threshold feature.
            'name': "lactate_threshold_autodetect_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        86: {
            'num': 86, # Automatically upload using BLE
            'name': "ble_auto_upload_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        89: {
            'num': 89, # Helps to conserve battery by changing modes
            'name': "auto_sync_frequency",
            'type': "auto_sync_frequency",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        90: {
            'num': 90, # Allows setting specific activities auto-activity detect enabled/disabled settings
            'name': "auto_activity_detect",
            'type': "auto_activity_detect",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        94: {
            'num': 94, # Number of screens configured to display
            'name': "number_of_screens",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        95: {
            'num': 95, # Smart Notification display orientation
            'name': "smart_notification_display_orientation",
            'type': "display_orientation",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        134: {
            'num': 134,
            'name': "tap_interface",
            'type': "switch",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        174: {
            'num': 174, # Used to hold the tap threshold setting
            'name': "tap_sensitivity",
            'type': "tap_sensitivity",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        3: {
        'num': "3",
        'name': "user_profile",
        'messages_key': "user_profile_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Used for Morning Report greeting
            'name': "friendly_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "gender",
            'type': "gender",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "age",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "years",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "height",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "weight",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "language",
            'type': "language",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "elev_setting",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "weight_setting",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "resting_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "default_max_running_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "default_max_biking_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "default_max_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "hr_setting",
            'type': "display_heart",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "speed_setting",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "dist_setting",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        16: {
            'num': 16,
            'name': "power_setting",
            'type': "display_power",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17,
            'name': "activity_class",
            'type': "activity_class",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18,
            'name': "position_setting",
            'type': "display_position",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "temperature_setting",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "local_id",
            'type': "user_local_id",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "global_id",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        28: {
            'num': 28, # Typical wake time
            'name': "wake_time",
            'type': "localtime_into_day",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        29: {
            'num': 29, # Typical bed time
            'name': "sleep_time",
            'type': "localtime_into_day",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        30: {
            'num': 30,
            'name': "height_setting",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        31: {
            'num': 31, # User defined running step length set to 0 for auto length
            'name': "user_running_step_length",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        32: {
            'num': 32, # User defined walking step length set to 0 for auto length
            'name': "user_walking_step_length",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        47: {
            'num': 47,
            'name': "depth_setting",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        49: {
            'num': 49,
            'name': "dive_count",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        4: {
        'num': "4",
        'name': "hrm_profile",
        'messages_key': "hrm_profile_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "hrm_ant_id",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "log_hrv",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "hrm_ant_id_trans_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        5: {
        'num': "5",
        'name': "sdm_profile",
        'messages_key': "sdm_profile_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "sdm_ant_id",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "sdm_cal_factor",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "odometer",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Use footpod for speed source instead of GPS
            'name': "speed_source",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "sdm_ant_id_trans_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Rollover counter that can be used to extend the odometer
            'name': "odometer_rollover",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        6: {
        'num': "6",
        'name': "bike_profile",
        'messages_key': "bike_profile_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "odometer",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "bike_spd_ant_id",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "bike_cad_ant_id",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "bike_spdcad_ant_id",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "bike_power_ant_id",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "custom_wheelsize",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "auto_wheelsize",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "bike_weight",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "power_cal_factor",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "auto_wheel_cal",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "auto_power_zero",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "id",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "spd_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        16: {
            'num': 16,
            'name': "cad_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17,
            'name': "spdcad_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18,
            'name': "power_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        19: {
            'num': 19,
            'name': "crank_length",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [-110],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        20: {
            'num': 20,
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "bike_spd_ant_id_trans_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "bike_cad_ant_id_trans_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "bike_spdcad_ant_id_trans_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24,
            'name': "bike_power_ant_id_trans_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        37: {
            'num': 37, # Rollover counter that can be used to extend the odometer
            'name': "odometer_rollover",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        38: {
            'num': 38, # Number of front gears
            'name': "front_gear_num",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        39: {
            'num': 39, # Number of teeth on each gear 0 is innermost
            'name': "front_gear",
            'type': "uint8z",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        40: {
            'num': 40, # Number of rear gears
            'name': "rear_gear_num",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        41: {
            'num': 41, # Number of teeth on each gear 0 is innermost
            'name': "rear_gear",
            'type': "uint8z",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        44: {
            'num': 44,
            'name': "shimano_di2_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        127: {
        'num': "127",
        'name': "connectivity",
        'messages_key': "connectivity_mesgs",
        'fields': {
        0: {
            'num': 0, # Use Bluetooth for connectivity features
            'name': "bluetooth_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Use Bluetooth Low Energy for connectivity features
            'name': "bluetooth_le_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Use ANT for connectivity features
            'name': "ant_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "live_tracking_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "weather_conditions_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "weather_alerts_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "auto_activity_upload_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "course_download_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "workout_download_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "gps_ephemeris_download_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "incident_detection_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "grouptrack_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        159: {
        'num': "159",
        'name': "watchface_settings",
        'messages_key': "watchface_settings_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "mode",
            'type': "watchface_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "layout",
            'type': "byte",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "digital_layout", 
                'type': "digital_watchface_layout",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "mode", 'raw_value': 0, 'value_name': "digital" },
                ],
               },
               {
                'name': "analog_layout", 
                'type': "analog_watchface_layout",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "mode", 'raw_value': 1, 'value_name': "analog" },
                ],
               },
               ]
            },
    },
},
        188: {
        'num': "188",
        'name': "ohr_settings",
        'messages_key': "ohr_settings_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "enabled",
            'type': "switch",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        216: {
        'num': "216",
        'name': "time_in_zone",
        'messages_key': "time_in_zone_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "reference_mesg",
            'type': "mesg_num",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "reference_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "time_in_hr_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "time_in_speed_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "time_in_cadence_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "time_in_power_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "hr_zone_high_boundary",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "speed_zone_high_boundary",
            'type': "uint16",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "cadence_zone_high_bondary",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "power_zone_high_boundary",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "hr_calc_type",
            'type': "hr_zone_calc",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "max_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "resting_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "threshold_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "pwr_calc_type",
            'type': "pwr_zone_calc",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "functional_threshold_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        7: {
        'num': "7",
        'name': "zones_target",
        'messages_key': "zones_target_mesgs",
        'fields': {
        1: {
            'num': 1,
            'name': "max_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "threshold_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "functional_threshold_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "hr_calc_type",
            'type': "hr_zone_calc",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "pwr_calc_type",
            'type': "pwr_zone_calc",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        12: {
        'num': "12",
        'name': "sport",
        'messages_key': "sport_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        8: {
        'num': "8",
        'name': "hr_zone",
        'messages_key': "hr_zone_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "high_bpm",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        53: {
        'num': "53",
        'name': "speed_zone",
        'messages_key': "speed_zone_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "high_value",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        131: {
        'num': "131",
        'name': "cadence_zone",
        'messages_key': "cadence_zone_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "high_value",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        9: {
        'num': "9",
        'name': "power_zone",
        'messages_key': "power_zone_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "high_value",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        10: {
        'num': "10",
        'name': "met_zone",
        'messages_key': "met_zone_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "high_bpm",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "calories",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "kcal / min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "fat_calories",
            'type': "uint8",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "kcal / min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        258: {
        'num': "258",
        'name': "dive_settings",
        'messages_key': "dive_settings_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "model",
            'type': "tissue_model_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "gf_low",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "gf_high",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "water_type",
            'type': "water_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Fresh water is usually 1000; salt water is usually 1025
            'name': "water_density",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kg/m^3",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Typically 1.40
            'name': "po2_warn",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Typically 1.60
            'name': "po2_critical",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "po2_deco",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "safety_stop_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "bottom_depth",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "bottom_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "apnea_countdown_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "apnea_countdown_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "backlight_mode",
            'type': "dive_backlight_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "backlight_brightness",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        16: {
            'num': 16,
            'name': "backlight_timeout",
            'type': "backlight_timeout",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17, # Time between surfacing and ending the activity
            'name': "repeat_dive_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18, # Time at safety stop (if enabled)
            'name': "safety_stop_time",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        19: {
            'num': 19,
            'name': "heart_rate_source_type",
            'type': "source_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        20: {
            'num': 20,
            'name': "heart_rate_source",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "heart_rate_antplus_device_type", 
                'type': "antplus_device_type",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "heart_rate_source_type", 'raw_value': 1, 'value_name': "antplus" },
                ],
               },
               {
                'name': "heart_rate_local_device_type", 
                'type': "local_device_type",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "heart_rate_source_type", 'raw_value': 5, 'value_name': "local" },
                ],
               },
               ]
            },
        21: {
            'num': 21, # Index of travel dive_gas message
            'name': "travel_gas",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22, # If low PO2 should be switched to automatically
            'name': "ccr_low_setpoint_switch_mode",
            'type': "ccr_setpoint_switch_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23, # Target PO2 when using low setpoint
            'name': "ccr_low_setpoint",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24, # Depth to switch to low setpoint in automatic mode
            'name': "ccr_low_setpoint_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        25: {
            'num': 25, # If high PO2 should be switched to automatically
            'name': "ccr_high_setpoint_switch_mode",
            'type': "ccr_setpoint_switch_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        26: {
            'num': 26, # Target PO2 when using high setpoint
            'name': "ccr_high_setpoint",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        27: {
            'num': 27, # Depth to switch to high setpoint in automatic mode
            'name': "ccr_high_setpoint_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        29: {
            'num': 29, # Type of gas consumption rate to display. Some values are only valid if tank volume is known.
            'name': "gas_consumption_display",
            'type': "gas_consumption_rate_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        30: {
            'num': 30, # Indicates whether the up key is enabled during dives
            'name': "up_key_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        35: {
            'num': 35, # Sounds and vibration enabled or disabled in-dive
            'name': "dive_sounds",
            'type': "tone",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        36: {
            'num': 36, # Usually 1.0/1.5/2.0 representing 3/4.5/6m or 10/15/20ft
            'name': "last_stop_multiple",
            'type': "uint8",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        37: {
            'num': 37, # Indicates which guidelines to use for no-fly surface interval.
            'name': "no_fly_time_mode",
            'type': "no_fly_time_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        262: {
        'num': "262",
        'name': "dive_alarm",
        'messages_key': "dive_alarm_mesgs",
        'fields': {
        254: {
            'num': 254, # Index of the alarm
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Depth setting (m) for depth type alarms
            'name': "depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Time setting (s) for time type alarms
            'name': "time",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Enablement flag
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Alarm type setting
            'name': "alarm_type",
            'type': "dive_alarm_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Tone and Vibe setting for the alarm
            'name': "sound",
            'type': "tone",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Dive types the alarm will trigger on
            'name': "dive_types",
            'type': "sub_sport",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Alarm ID
            'name': "id",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Show a visible pop-up for this alarm
            'name': "popup_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Trigger the alarm on descent
            'name': "trigger_on_descent",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Trigger the alarm on ascent
            'name': "trigger_on_ascent",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10, # Repeat alarm each time threshold is crossed?
            'name': "repeating",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11, # Ascent/descent rate (mps) setting for speed type alarms
            'name': "speed",
            'type': "sint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "mps",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        393: {
        'num': "393",
        'name': "dive_apnea_alarm",
        'messages_key': "dive_apnea_alarm_mesgs",
        'fields': {
        254: {
            'num': 254, # Index of the alarm
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Depth setting (m) for depth type alarms
            'name': "depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Time setting (s) for time type alarms
            'name': "time",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Enablement flag
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Alarm type setting
            'name': "alarm_type",
            'type': "dive_alarm_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Tone and Vibe setting for the alarm.
            'name': "sound",
            'type': "tone",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Dive types the alarm will trigger on
            'name': "dive_types",
            'type': "sub_sport",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Alarm ID
            'name': "id",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Show a visible pop-up for this alarm
            'name': "popup_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Trigger the alarm on descent
            'name': "trigger_on_descent",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Trigger the alarm on ascent
            'name': "trigger_on_ascent",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10, # Repeat alarm each time threshold is crossed?
            'name': "repeating",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11, # Ascent/descent rate (mps) setting for speed type alarms
            'name': "speed",
            'type': "sint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "mps",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        259: {
        'num': "259",
        'name': "dive_gas",
        'messages_key': "dive_gas_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "helium_content",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "oxygen_content",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "status",
            'type': "dive_gas_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "mode",
            'type': "dive_gas_mode",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        15: {
        'num': "15",
        'name': "goal",
        'messages_key': "goal_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "start_date",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "end_date",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "type",
            'type': "goal",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "value",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "repeat",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "target_value",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "recurrence",
            'type': "goal_recurrence",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "recurrence_value",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "source",
            'type': "goal_source",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        34: {
        'num': "34",
        'name': "activity",
        'messages_key': "activity_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Exclude pauses
            'name': "total_timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "num_sessions",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "type",
            'type': "activity",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "event",
            'type': "event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "event_type",
            'type': "event_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # timestamp epoch expressed in local time, used to convert activity timestamps to local time
            'name': "local_timestamp",
            'type': "local_date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "event_group",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        18: {
        'num': "18",
        'name': "session",
        'messages_key': "session_mesgs",
        'fields': {
        254: {
            'num': 254, # Selected bit is set for the current session.
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        253: {
            'num': 253, # Sesson end time.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # session
            'name': "event",
            'type': "event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # stop
            'name': "event_type",
            'type': "event_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "start_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "start_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "start_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Time (includes pauses)
            'name': "total_elapsed_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Timer Time (excludes pauses)
            'name': "total_timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "total_distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "total_cycles",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "total_strides", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strides"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 5, 'name': "sport", 'raw_value': 1, 'value_name': "running" },
                    { 'num': 5, 'name': "sport", 'raw_value': 11, 'value_name': "walking" },
                ],
               },
               {
                'name': "total_strokes", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strokes"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 5, 'name': "sport", 'raw_value': 2, 'value_name': "cycling" },
                    { 'num': 5, 'name': "sport", 'raw_value': 5, 'value_name': "swimming" },
                    { 'num': 5, 'name': "sport", 'raw_value': 15, 'value_name': "rowing" },
                    { 'num': 5, 'name': "sport", 'raw_value': 37, 'value_name': "stand_up_paddleboarding" },
                ],
               },
               ]
            },
        11: {
            'num': 11,
            'name': "total_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "total_fat_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14, # total_distance / total_timer_time
            'name': "avg_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000, ],
            'offset': [0, ],
            'units': ["m/s", ],
            'bits': [16,],
            'components': [124, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "max_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000, ],
            'offset': [0, ],
            'units': ["m/s", ],
            'bits': [16,],
            'components': [125, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        16: {
            'num': 16, # average heart rate (excludes pause time)
            'name': "avg_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17,
            'name': "max_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18, # total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
            'name': "avg_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "avg_running_cadence", 
                'type': "uint8",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strides/min"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 5, 'name': "sport", 'raw_value': 1, 'value_name': "running" },
                ],
               },
               ]
            },
        19: {
            'num': 19,
            'name': "max_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "max_running_cadence", 
                'type': "uint8",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strides/min"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 5, 'name': "sport", 'raw_value': 1, 'value_name': "running" },
                ],
               },
               ]
            },
        20: {
            'num': 20, # total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
            'name': "avg_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "max_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "total_ascent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "total_descent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24,
            'name': "total_training_effect",
            'type': "uint8",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        25: {
            'num': 25,
            'name': "first_lap_index",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        26: {
            'num': 26,
            'name': "num_laps",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        27: {
            'num': 27,
            'name': "event_group",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        28: {
            'num': 28,
            'name': "trigger",
            'type': "session_trigger",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        29: {
            'num': 29, # North east corner latitude
            'name': "nec_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        30: {
            'num': 30, # North east corner longitude
            'name': "nec_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        31: {
            'num': 31, # South west corner latitude
            'name': "swc_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        32: {
            'num': 32, # South west corner longitude
            'name': "swc_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        33: {
            'num': 33, # # of lengths of swim pool
            'name': "num_lengths",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "lengths",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        34: {
            'num': 34,
            'name': "normalized_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        35: {
            'num': 35,
            'name': "training_stress_score",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "tss",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        36: {
            'num': 36,
            'name': "intensity_factor",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "if",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        37: {
            'num': 37,
            'name': "left_right_balance",
            'type': "left_right_balance_100",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        38: {
            'num': 38,
            'name': "end_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        39: {
            'num': 39,
            'name': "end_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        41: {
            'num': 41,
            'name': "avg_stroke_count",
            'type': "uint32",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "strokes/lap",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        42: {
            'num': 42,
            'name': "avg_stroke_distance",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        43: {
            'num': 43,
            'name': "swim_stroke",
            'type': "swim_stroke",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "swim_stroke",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        44: {
            'num': 44,
            'name': "pool_length",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        45: {
            'num': 45,
            'name': "threshold_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        46: {
            'num': 46,
            'name': "pool_length_unit",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        47: {
            'num': 47, # # of active lengths of swim pool
            'name': "num_active_lengths",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "lengths",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        48: {
            'num': 48,
            'name': "total_work",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "J",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        49: {
            'num': 49,
            'name': "avg_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [126, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        50: {
            'num': 50,
            'name': "max_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [128, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        51: {
            'num': 51,
            'name': "gps_accuracy",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        52: {
            'num': 52,
            'name': "avg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        53: {
            'num': 53,
            'name': "avg_pos_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        54: {
            'num': 54,
            'name': "avg_neg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        55: {
            'num': 55,
            'name': "max_pos_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        56: {
            'num': 56,
            'name': "max_neg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        57: {
            'num': 57,
            'name': "avg_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        58: {
            'num': 58,
            'name': "max_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        59: {
            'num': 59,
            'name': "total_moving_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        60: {
            'num': 60,
            'name': "avg_pos_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        61: {
            'num': 61,
            'name': "avg_neg_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        62: {
            'num': 62,
            'name': "max_pos_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        63: {
            'num': 63,
            'name': "max_neg_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        64: {
            'num': 64,
            'name': "min_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        65: {
            'num': 65,
            'name': "time_in_hr_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        66: {
            'num': 66,
            'name': "time_in_speed_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        67: {
            'num': 67,
            'name': "time_in_cadence_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        68: {
            'num': 68,
            'name': "time_in_power_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        69: {
            'num': 69,
            'name': "avg_lap_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        70: {
            'num': 70,
            'name': "best_lap_index",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        71: {
            'num': 71,
            'name': "min_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [127, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        82: {
            'num': 82,
            'name': "player_score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        83: {
            'num': 83,
            'name': "opponent_score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        84: {
            'num': 84,
            'name': "opponent_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        85: {
            'num': 85, # stroke_type enum used as the index
            'name': "stroke_count",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        86: {
            'num': 86, # zone number used as the index
            'name': "zone_count",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        87: {
            'num': 87,
            'name': "max_ball_speed",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        88: {
            'num': 88,
            'name': "avg_ball_speed",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        89: {
            'num': 89,
            'name': "avg_vertical_oscillation",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        90: {
            'num': 90,
            'name': "avg_stance_time_percent",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        91: {
            'num': 91,
            'name': "avg_stance_time",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        92: {
            'num': 92, # fractional part of the avg_cadence
            'name': "avg_fractional_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        93: {
            'num': 93, # fractional part of the max_cadence
            'name': "max_fractional_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        94: {
            'num': 94, # fractional part of the total_cycles
            'name': "total_fractional_cycles",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        95: {
            'num': 95, # Avg saturated and unsaturated hemoglobin
            'name': "avg_total_hemoglobin_conc",
            'type': "uint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        96: {
            'num': 96, # Min saturated and unsaturated hemoglobin
            'name': "min_total_hemoglobin_conc",
            'type': "uint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        97: {
            'num': 97, # Max saturated and unsaturated hemoglobin
            'name': "max_total_hemoglobin_conc",
            'type': "uint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        98: {
            'num': 98, # Avg percentage of hemoglobin saturated with oxygen
            'name': "avg_saturated_hemoglobin_percent",
            'type': "uint16",
            'array': "true",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        99: {
            'num': 99, # Min percentage of hemoglobin saturated with oxygen
            'name': "min_saturated_hemoglobin_percent",
            'type': "uint16",
            'array': "true",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        100: {
            'num': 100, # Max percentage of hemoglobin saturated with oxygen
            'name': "max_saturated_hemoglobin_percent",
            'type': "uint16",
            'array': "true",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        101: {
            'num': 101,
            'name': "avg_left_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        102: {
            'num': 102,
            'name': "avg_right_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        103: {
            'num': 103,
            'name': "avg_left_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        104: {
            'num': 104,
            'name': "avg_right_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        105: {
            'num': 105,
            'name': "avg_combined_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        110: {
            'num': 110, # Sport name from associated sport mesg
            'name': "sport_profile_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        111: {
            'num': 111,
            'name': "sport_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        112: {
            'num': 112, # Total time spend in the standing position
            'name': "time_standing",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        113: {
            'num': 113, # Number of transitions to the standing state
            'name': "stand_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        114: {
            'num': 114, # Average platform center offset Left
            'name': "avg_left_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        115: {
            'num': 115, # Average platform center offset Right
            'name': "avg_right_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        116: {
            'num': 116, # Average left power phase angles. Indexes defined by power_phase_type.
            'name': "avg_left_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        117: {
            'num': 117, # Average left power phase peak angles. Data value indexes defined by power_phase_type.
            'name': "avg_left_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        118: {
            'num': 118, # Average right power phase angles. Data value indexes defined by power_phase_type.
            'name': "avg_right_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        119: {
            'num': 119, # Average right power phase peak angles data value indexes defined by power_phase_type.
            'name': "avg_right_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        120: {
            'num': 120, # Average power by position. Data value indexes defined by rider_position_type.
            'name': "avg_power_position",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        121: {
            'num': 121, # Maximum power by position. Data value indexes defined by rider_position_type.
            'name': "max_power_position",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        122: {
            'num': 122, # Average cadence by position. Data value indexes defined by rider_position_type.
            'name': "avg_cadence_position",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        123: {
            'num': 123, # Maximum cadence by position. Data value indexes defined by rider_position_type.
            'name': "max_cadence_position",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        124: {
            'num': 124, # total_distance / total_timer_time
            'name': "enhanced_avg_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        125: {
            'num': 125,
            'name': "enhanced_max_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        126: {
            'num': 126,
            'name': "enhanced_avg_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        127: {
            'num': 127,
            'name': "enhanced_min_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        128: {
            'num': 128,
            'name': "enhanced_max_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        129: {
            'num': 129, # lev average motor power during session
            'name': "avg_lev_motor_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        130: {
            'num': 130, # lev maximum motor power during session
            'name': "max_lev_motor_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        131: {
            'num': 131, # lev battery consumption during session
            'name': "lev_battery_consumption",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        132: {
            'num': 132,
            'name': "avg_vertical_ratio",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        133: {
            'num': 133,
            'name': "avg_stance_time_balance",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        134: {
            'num': 134,
            'name': "avg_step_length",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        137: {
            'num': 137,
            'name': "total_anaerobic_training_effect",
            'type': "uint8",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        139: {
            'num': 139,
            'name': "avg_vam",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        140: {
            'num': 140, # 0 if above water
            'name': "avg_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        141: {
            'num': 141, # 0 if above water
            'name': "max_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        142: {
            'num': 142, # Time since end of last dive
            'name': "surface_interval",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        143: {
            'num': 143,
            'name': "start_cns",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        144: {
            'num': 144,
            'name': "end_cns",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        145: {
            'num': 145,
            'name': "start_n2",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        146: {
            'num': 146,
            'name': "end_n2",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        147: {
            'num': 147,
            'name': "avg_respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [8,],
            'components': [169, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        148: {
            'num': 148,
            'name': "max_respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [8,],
            'components': [170, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        149: {
            'num': 149,
            'name': "min_respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [8,],
            'components': [180, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        150: {
            'num': 150,
            'name': "min_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        155: {
            'num': 155,
            'name': "o2_toxicity",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "OTUs",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        156: {
            'num': 156,
            'name': "dive_number",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        168: {
            'num': 168,
            'name': "training_load_peak",
            'type': "sint32",
            'array': "false",
            'scale': [65536],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        169: {
            'num': 169,
            'name': "enhanced_avg_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "Breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        170: {
            'num': 170,
            'name': "enhanced_max_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "Breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        180: {
            'num': 180,
            'name': "enhanced_min_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        181: {
            'num': 181, # The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
            'name': "total_grit",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kGrit",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        182: {
            'num': 182, # The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
            'name': "total_flow",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "Flow",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        183: {
            'num': 183,
            'name': "jump_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        186: {
            'num': 186, # The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
            'name': "avg_grit",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kGrit",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        187: {
            'num': 187, # The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
            'name': "avg_flow",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "Flow",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        192: {
            'num': 192, # A 0-100 scale representing how a user felt while performing a workout. Low values are considered feeling bad, while high values are good.
            'name': "workout_feel",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        193: {
            'num': 193, # Common Borg CR10 / 0-10 RPE scale, multiplied 10x.. Aggregate score for all workouts in a single session.
            'name': "workout_rpe",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        194: {
            'num': 194, # Average SPO2 for the monitoring session
            'name': "avg_spo2",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        195: {
            'num': 195, # Average stress for the monitoring session
            'name': "avg_stress",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        197: {
            'num': 197, # Standard deviation of R-R interval (SDRR) - Heart rate variability measure most useful for wellness users.
            'name': "sdrr_hrv",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mS",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        198: {
            'num': 198, # Root mean square successive difference (RMSSD) - Heart rate variability measure most useful for athletes
            'name': "rmssd_hrv",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mS",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        199: {
            'num': 199, # fractional part of total_ascent
            'name': "total_fractional_ascent",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        200: {
            'num': 200, # fractional part of total_descent
            'name': "total_fractional_descent",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        208: {
            'num': 208,
            'name': "avg_core_temperature",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        209: {
            'num': 209,
            'name': "min_core_temperature",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        210: {
            'num': 210,
            'name': "max_core_temperature",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        19: {
        'num': "19",
        'name': "lap",
        'messages_key': "lap_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        253: {
            'num': 253, # Lap end time.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "event",
            'type': "event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "event_type",
            'type': "event_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "start_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "start_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "start_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "end_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "end_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Time (includes pauses)
            'name': "total_elapsed_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Timer Time (excludes pauses)
            'name': "total_timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "total_distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "total_cycles",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "total_strides", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strides"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "sport", 'raw_value': 1, 'value_name': "running" },
                    { 'num': 25, 'name': "sport", 'raw_value': 11, 'value_name': "walking" },
                ],
               },
               {
                'name': "total_strokes", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strokes"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "sport", 'raw_value': 2, 'value_name': "cycling" },
                    { 'num': 25, 'name': "sport", 'raw_value': 5, 'value_name': "swimming" },
                    { 'num': 25, 'name': "sport", 'raw_value': 15, 'value_name': "rowing" },
                    { 'num': 25, 'name': "sport", 'raw_value': 37, 'value_name': "stand_up_paddleboarding" },
                ],
               },
               ]
            },
        11: {
            'num': 11,
            'name': "total_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # If New Leaf
            'name': "total_fat_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "avg_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000, ],
            'offset': [0, ],
            'units': ["m/s", ],
            'bits': [16,],
            'components': [110, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "max_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000, ],
            'offset': [0, ],
            'units': ["m/s", ],
            'bits': [16,],
            'components': [111, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "avg_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        16: {
            'num': 16,
            'name': "max_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17, # total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
            'name': "avg_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "avg_running_cadence", 
                'type': "uint8",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strides/min"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "sport", 'raw_value': 1, 'value_name': "running" },
                ],
               },
               ]
            },
        18: {
            'num': 18,
            'name': "max_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "max_running_cadence", 
                'type': "uint8",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strides/min"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "sport", 'raw_value': 1, 'value_name': "running" },
                ],
               },
               ]
            },
        19: {
            'num': 19, # total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
            'name': "avg_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        20: {
            'num': 20,
            'name': "max_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "total_ascent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "total_descent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "intensity",
            'type': "intensity",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24,
            'name': "lap_trigger",
            'type': "lap_trigger",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        25: {
            'num': 25,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        26: {
            'num': 26,
            'name': "event_group",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        32: {
            'num': 32, # # of lengths of swim pool
            'name': "num_lengths",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "lengths",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        33: {
            'num': 33,
            'name': "normalized_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        34: {
            'num': 34,
            'name': "left_right_balance",
            'type': "left_right_balance_100",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        35: {
            'num': 35,
            'name': "first_length_index",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        37: {
            'num': 37,
            'name': "avg_stroke_distance",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        38: {
            'num': 38,
            'name': "swim_stroke",
            'type': "swim_stroke",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        39: {
            'num': 39,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        40: {
            'num': 40, # # of active lengths of swim pool
            'name': "num_active_lengths",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "lengths",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        41: {
            'num': 41,
            'name': "total_work",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "J",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        42: {
            'num': 42,
            'name': "avg_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [112, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        43: {
            'num': 43,
            'name': "max_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [114, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        44: {
            'num': 44,
            'name': "gps_accuracy",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        45: {
            'num': 45,
            'name': "avg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        46: {
            'num': 46,
            'name': "avg_pos_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        47: {
            'num': 47,
            'name': "avg_neg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        48: {
            'num': 48,
            'name': "max_pos_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        49: {
            'num': 49,
            'name': "max_neg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        50: {
            'num': 50,
            'name': "avg_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        51: {
            'num': 51,
            'name': "max_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        52: {
            'num': 52,
            'name': "total_moving_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        53: {
            'num': 53,
            'name': "avg_pos_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        54: {
            'num': 54,
            'name': "avg_neg_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        55: {
            'num': 55,
            'name': "max_pos_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        56: {
            'num': 56,
            'name': "max_neg_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        57: {
            'num': 57,
            'name': "time_in_hr_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        58: {
            'num': 58,
            'name': "time_in_speed_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        59: {
            'num': 59,
            'name': "time_in_cadence_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        60: {
            'num': 60,
            'name': "time_in_power_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        61: {
            'num': 61,
            'name': "repetition_num",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        62: {
            'num': 62,
            'name': "min_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [113, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        63: {
            'num': 63,
            'name': "min_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        71: {
            'num': 71,
            'name': "wkt_step_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        74: {
            'num': 74,
            'name': "opponent_score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        75: {
            'num': 75, # stroke_type enum used as the index
            'name': "stroke_count",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        76: {
            'num': 76, # zone number used as the index
            'name': "zone_count",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        77: {
            'num': 77,
            'name': "avg_vertical_oscillation",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        78: {
            'num': 78,
            'name': "avg_stance_time_percent",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        79: {
            'num': 79,
            'name': "avg_stance_time",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        80: {
            'num': 80, # fractional part of the avg_cadence
            'name': "avg_fractional_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        81: {
            'num': 81, # fractional part of the max_cadence
            'name': "max_fractional_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        82: {
            'num': 82, # fractional part of the total_cycles
            'name': "total_fractional_cycles",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        83: {
            'num': 83,
            'name': "player_score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        84: {
            'num': 84, # Avg saturated and unsaturated hemoglobin
            'name': "avg_total_hemoglobin_conc",
            'type': "uint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        85: {
            'num': 85, # Min saturated and unsaturated hemoglobin
            'name': "min_total_hemoglobin_conc",
            'type': "uint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        86: {
            'num': 86, # Max saturated and unsaturated hemoglobin
            'name': "max_total_hemoglobin_conc",
            'type': "uint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        87: {
            'num': 87, # Avg percentage of hemoglobin saturated with oxygen
            'name': "avg_saturated_hemoglobin_percent",
            'type': "uint16",
            'array': "true",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        88: {
            'num': 88, # Min percentage of hemoglobin saturated with oxygen
            'name': "min_saturated_hemoglobin_percent",
            'type': "uint16",
            'array': "true",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        89: {
            'num': 89, # Max percentage of hemoglobin saturated with oxygen
            'name': "max_saturated_hemoglobin_percent",
            'type': "uint16",
            'array': "true",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        91: {
            'num': 91,
            'name': "avg_left_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        92: {
            'num': 92,
            'name': "avg_right_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        93: {
            'num': 93,
            'name': "avg_left_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        94: {
            'num': 94,
            'name': "avg_right_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        95: {
            'num': 95,
            'name': "avg_combined_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        98: {
            'num': 98, # Total time spent in the standing position
            'name': "time_standing",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        99: {
            'num': 99, # Number of transitions to the standing state
            'name': "stand_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        100: {
            'num': 100, # Average left platform center offset
            'name': "avg_left_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        101: {
            'num': 101, # Average right platform center offset
            'name': "avg_right_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        102: {
            'num': 102, # Average left power phase angles. Data value indexes defined by power_phase_type.
            'name': "avg_left_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        103: {
            'num': 103, # Average left power phase peak angles. Data value indexes defined by power_phase_type.
            'name': "avg_left_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        104: {
            'num': 104, # Average right power phase angles. Data value indexes defined by power_phase_type.
            'name': "avg_right_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        105: {
            'num': 105, # Average right power phase peak angles. Data value indexes defined by power_phase_type.
            'name': "avg_right_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        106: {
            'num': 106, # Average power by position. Data value indexes defined by rider_position_type.
            'name': "avg_power_position",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        107: {
            'num': 107, # Maximum power by position. Data value indexes defined by rider_position_type.
            'name': "max_power_position",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        108: {
            'num': 108, # Average cadence by position. Data value indexes defined by rider_position_type.
            'name': "avg_cadence_position",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        109: {
            'num': 109, # Maximum cadence by position. Data value indexes defined by rider_position_type.
            'name': "max_cadence_position",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        110: {
            'num': 110,
            'name': "enhanced_avg_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        111: {
            'num': 111,
            'name': "enhanced_max_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        112: {
            'num': 112,
            'name': "enhanced_avg_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        113: {
            'num': 113,
            'name': "enhanced_min_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        114: {
            'num': 114,
            'name': "enhanced_max_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        115: {
            'num': 115, # lev average motor power during lap
            'name': "avg_lev_motor_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        116: {
            'num': 116, # lev maximum motor power during lap
            'name': "max_lev_motor_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        117: {
            'num': 117, # lev battery consumption during lap
            'name': "lev_battery_consumption",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        118: {
            'num': 118,
            'name': "avg_vertical_ratio",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        119: {
            'num': 119,
            'name': "avg_stance_time_balance",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        120: {
            'num': 120,
            'name': "avg_step_length",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        121: {
            'num': 121,
            'name': "avg_vam",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        122: {
            'num': 122, # 0 if above water
            'name': "avg_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        123: {
            'num': 123, # 0 if above water
            'name': "max_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        124: {
            'num': 124,
            'name': "min_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        136: {
            'num': 136,
            'name': "enhanced_avg_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "Breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        137: {
            'num': 137,
            'name': "enhanced_max_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "Breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        147: {
            'num': 147,
            'name': "avg_respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [8,],
            'components': [136, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        148: {
            'num': 148,
            'name': "max_respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [8,],
            'components': [137, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        149: {
            'num': 149, # The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
            'name': "total_grit",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kGrit",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        150: {
            'num': 150, # The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
            'name': "total_flow",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "Flow",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        151: {
            'num': 151,
            'name': "jump_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        153: {
            'num': 153, # The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
            'name': "avg_grit",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kGrit",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        154: {
            'num': 154, # The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
            'name': "avg_flow",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "Flow",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        156: {
            'num': 156, # fractional part of total_ascent
            'name': "total_fractional_ascent",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        157: {
            'num': 157, # fractional part of total_descent
            'name': "total_fractional_descent",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        158: {
            'num': 158,
            'name': "avg_core_temperature",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        159: {
            'num': 159,
            'name': "min_core_temperature",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        160: {
            'num': 160,
            'name': "max_core_temperature",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        101: {
        'num': "101",
        'name': "length",
        'messages_key': "length_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "event",
            'type': "event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "event_type",
            'type': "event_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "start_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "total_elapsed_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "total_timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "total_strokes",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "strokes",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "avg_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "swim_stroke",
            'type': "swim_stroke",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "swim_stroke",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "avg_swimming_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "strokes/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "event_group",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "total_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "length_type",
            'type': "length_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18,
            'name': "player_score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        19: {
            'num': 19,
            'name': "opponent_score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        20: {
            'num': 20, # stroke_type enum used as the index
            'name': "stroke_count",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21, # zone number used as the index
            'name': "zone_count",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "enhanced_avg_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "Breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "enhanced_max_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "Breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24,
            'name': "avg_respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [8,],
            'components': [22, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        25: {
            'num': 25,
            'name': "max_respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [8,],
            'components': [23, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
    },
},
        20: {
        'num': "20",
        'name': "record",
        'messages_key': "record_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [78, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': True,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000, ],
            'offset': [0, ],
            'units': ["m/s", ],
            'bits': [16,],
            'components': [73, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "compressed_speed_distance",
            'type': "byte",
            'array': "true",
            'scale': [100, 16, ],
            'offset': [0, 0, ],
            'units': ["m/s", "m", ],
            'bits': [12,12,],
            'components': [6, 5, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10, # Relative. 0 is none 254 is Max.
            'name': "resistance",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "time_from_course",
            'type': "sint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "cycle_length",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17, # Speed at 1s intervals. Timestamp field indicates time of last array element.
            'name': "speed_1s",
            'type': "uint8",
            'array': "true",
            'scale': [16],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18,
            'name': "cycles",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["cycles", ],
            'bits': [8,],
            'components': [19, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        19: {
            'num': 19,
            'name': "total_cycles",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': True,
            'has_components': False,
			'sub_fields': []
            },
        28: {
            'num': 28,
            'name': "compressed_accumulated_power",
            'type': "uint16",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["watts", ],
            'bits': [16,],
            'components': [29, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        29: {
            'num': 29,
            'name': "accumulated_power",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': True,
            'has_components': False,
			'sub_fields': []
            },
        30: {
            'num': 30,
            'name': "left_right_balance",
            'type': "left_right_balance",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        31: {
            'num': 31,
            'name': "gps_accuracy",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        32: {
            'num': 32,
            'name': "vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        33: {
            'num': 33,
            'name': "calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        39: {
            'num': 39,
            'name': "vertical_oscillation",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        40: {
            'num': 40,
            'name': "stance_time_percent",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        41: {
            'num': 41,
            'name': "stance_time",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        42: {
            'num': 42,
            'name': "activity_type",
            'type': "activity_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        43: {
            'num': 43,
            'name': "left_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        44: {
            'num': 44,
            'name': "right_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        45: {
            'num': 45,
            'name': "left_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        46: {
            'num': 46,
            'name': "right_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        47: {
            'num': 47,
            'name': "combined_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        48: {
            'num': 48,
            'name': "time128",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        49: {
            'num': 49,
            'name': "stroke_type",
            'type': "stroke_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        50: {
            'num': 50,
            'name': "zone",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        51: {
            'num': 51,
            'name': "ball_speed",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        52: {
            'num': 52, # Log cadence and fractional cadence for backwards compatability
            'name': "cadence256",
            'type': "uint16",
            'array': "false",
            'scale': [256],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        53: {
            'num': 53,
            'name': "fractional_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        54: {
            'num': 54, # Total saturated and unsaturated hemoglobin
            'name': "total_hemoglobin_conc",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        55: {
            'num': 55, # Min saturated and unsaturated hemoglobin
            'name': "total_hemoglobin_conc_min",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        56: {
            'num': 56, # Max saturated and unsaturated hemoglobin
            'name': "total_hemoglobin_conc_max",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "g/dL",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        57: {
            'num': 57, # Percentage of hemoglobin saturated with oxygen
            'name': "saturated_hemoglobin_percent",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        58: {
            'num': 58, # Min percentage of hemoglobin saturated with oxygen
            'name': "saturated_hemoglobin_percent_min",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        59: {
            'num': 59, # Max percentage of hemoglobin saturated with oxygen
            'name': "saturated_hemoglobin_percent_max",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        62: {
            'num': 62,
            'name': "device_index",
            'type': "device_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        67: {
            'num': 67, # Left platform center offset
            'name': "left_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        68: {
            'num': 68, # Right platform center offset
            'name': "right_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        69: {
            'num': 69, # Left power phase angles. Data value indexes defined by power_phase_type.
            'name': "left_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        70: {
            'num': 70, # Left power phase peak angles. Data value indexes defined by power_phase_type.
            'name': "left_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        71: {
            'num': 71, # Right power phase angles. Data value indexes defined by power_phase_type.
            'name': "right_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        72: {
            'num': 72, # Right power phase peak angles. Data value indexes defined by power_phase_type.
            'name': "right_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        73: {
            'num': 73,
            'name': "enhanced_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        78: {
            'num': 78,
            'name': "enhanced_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        81: {
            'num': 81, # lev battery state of charge
            'name': "battery_soc",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        82: {
            'num': 82, # lev motor power
            'name': "motor_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        83: {
            'num': 83,
            'name': "vertical_ratio",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        84: {
            'num': 84,
            'name': "stance_time_balance",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        85: {
            'num': 85,
            'name': "step_length",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        87: {
            'num': 87, # Supports larger cycle sizes needed for paddlesports. Max cycle size: 655.35
            'name': "cycle_length16",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        91: {
            'num': 91, # Includes atmospheric pressure
            'name': "absolute_pressure",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "Pa",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        92: {
            'num': 92, # 0 if above water
            'name': "depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        93: {
            'num': 93, # 0 if above water
            'name': "next_stop_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        94: {
            'num': 94,
            'name': "next_stop_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        95: {
            'num': 95,
            'name': "time_to_surface",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        96: {
            'num': 96,
            'name': "ndl_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        97: {
            'num': 97,
            'name': "cns_load",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        98: {
            'num': 98,
            'name': "n2_load",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        99: {
            'num': 99,
            'name': "respiration_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["s", ],
            'bits': [8,],
            'components': [108, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        108: {
            'num': 108,
            'name': "enhanced_respiration_rate",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "Breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        114: {
            'num': 114, # The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
            'name': "grit",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        115: {
            'num': 115, # The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
            'name': "flow",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        116: {
            'num': 116, # Current Stress value
            'name': "current_stress",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        117: {
            'num': 117,
            'name': "ebike_travel_range",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "km",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        118: {
            'num': 118,
            'name': "ebike_battery_level",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        119: {
            'num': 119,
            'name': "ebike_assist_mode",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "depends on sensor",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        120: {
            'num': 120,
            'name': "ebike_assist_level_percent",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        123: {
            'num': 123,
            'name': "air_time_remaining",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        124: {
            'num': 124, # Pressure-based surface air consumption
            'name': "pressure_sac",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "bar/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        125: {
            'num': 125, # Volumetric surface air consumption
            'name': "volume_sac",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "L/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        126: {
            'num': 126, # Respiratory minute volume
            'name': "rmv",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "L/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        127: {
            'num': 127,
            'name': "ascent_rate",
            'type': "sint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        129: {
            'num': 129, # Current partial pressure of oxygen
            'name': "po2",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        139: {
            'num': 139,
            'name': "core_temperature",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        21: {
        'num': "21",
        'name': "event",
        'messages_key': "event_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "event",
            'type': "event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "event_type",
            'type': "event_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "data16",
            'type': "uint16",
            'array': "false",
            'scale': [1, ],
            'offset': [0, ],
            'units': ["", ],
            'bits': [16,],
            'components': [3, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "data",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "timer_trigger", 
                'type': "timer_trigger",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 0, 'value_name': "timer" },
                ],
               },
               {
                'name': "course_point_index", 
                'type': "message_index",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 10, 'value_name': "course_point" },
                ],
               },
               {
                'name': "battery_level", 
                'type': "uint16",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["V"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 11, 'value_name': "battery" },
                ],
               },
               {
                'name': "virtual_partner_speed", 
                'type': "uint16",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["m/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 12, 'value_name': "virtual_partner_pace" },
                ],
               },
               {
                'name': "hr_high_alert", 
                'type': "uint8",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 13, 'value_name': "hr_high_alert" },
                ],
               },
               {
                'name': "hr_low_alert", 
                'type': "uint8",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 14, 'value_name': "hr_low_alert" },
                ],
               },
               {
                'name': "speed_high_alert", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["m/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 15, 'value_name': "speed_high_alert" },
                ],
               },
               {
                'name': "speed_low_alert", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["m/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 16, 'value_name': "speed_low_alert" },
                ],
               },
               {
                'name': "cad_high_alert", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["rpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 17, 'value_name': "cad_high_alert" },
                ],
               },
               {
                'name': "cad_low_alert", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["rpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 18, 'value_name': "cad_low_alert" },
                ],
               },
               {
                'name': "power_high_alert", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 19, 'value_name': "power_high_alert" },
                ],
               },
               {
                'name': "power_low_alert", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 20, 'value_name': "power_low_alert" },
                ],
               },
               {
                'name': "time_duration_alert", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 23, 'value_name': "time_duration_alert" },
                ],
               },
               {
                'name': "distance_duration_alert", 
                'type': "uint32",
                'array': "",
                'scale': [100],
                'offset': [0],
                'units': ["m"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 24, 'value_name': "distance_duration_alert" },
                ],
               },
               {
                'name': "calorie_duration_alert", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["calories"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 25, 'value_name': "calorie_duration_alert" },
                ],
               },
               {
                'name': "fitness_equipment_state", 
                'type': "fitness_equipment_state",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 27, 'value_name': "fitness_equipment" },
                ],
               },
               {
                'name': "sport_point", 
                'type': "uint32",
                'array': "",
                'scale': [1, 1, ],
                'offset': [0, 0, ],
                'units': ["", "", ],
                'bits': [16,16,],
                'components': [7, 8, ],
                'has_components': True,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 33, 'value_name': "sport_point" },
                ],
               },
               {
                'name': "gear_change_data", 
                'type': "uint32",
                'array': "",
                'scale': [1, 1, 1, 1, ],
                'offset': [0, 0, 0, 0, ],
                'units': ["", "", "", "", ],
                'bits': [8,8,8,8,],
                'components': [11, 12, 9, 10, ],
                'has_components': True,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 42, 'value_name': "front_gear_change" },
                    { 'num': 0, 'name': "event", 'raw_value': 43, 'value_name': "rear_gear_change" },
                ],
               },
               {
                'name': "rider_position",  # Indicates the rider position value.
                'type': "rider_position_type",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 44, 'value_name': "rider_position_change" },
                ],
               },
               {
                'name': "comm_timeout", 
                'type': "comm_timeout_type",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 47, 'value_name': "comm_timeout" },
                ],
               },
               {
                'name': "dive_alert", 
                'type': "dive_alert",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 56, 'value_name': "dive_alert" },
                ],
               },
               {
                'name': "auto_activity_detect_duration", 
                'type': "uint16",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["min"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 54, 'value_name': "auto_activity_detect" },
                ],
               },
               {
                'name': "radar_threat_alert",  # The first byte is the radar_threat_level_max, the second byte is the radar_threat_count, third bytes is the average approach speed, and the 4th byte is the max approach speed
                'type': "uint32",
                'array': "",
                'scale': [1, 1, 10, 10, ],
                'offset': [0, 0, 0, 0, ],
                'units': ["", "", "", "", ],
                'bits': [8,8,8,8,],
                'components': [21, 22, 23, 24, ],
                'has_components': True,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 75, 'value_name': "radar_threat_alert" },
                ],
               },
               ]
            },
        4: {
            'num': 4,
            'name': "event_group",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Do not populate directly. Autogenerated by decoder for sport_point subfield components
            'name': "score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Do not populate directly. Autogenerated by decoder for sport_point subfield components
            'name': "opponent_score",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Do not populate directly. Autogenerated by decoder for gear_change subfield components. Front gear number. 1 is innermost.
            'name': "front_gear_num",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10, # Do not populate directly. Autogenerated by decoder for gear_change subfield components. Number of front teeth.
            'name': "front_gear",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11, # Do not populate directly. Autogenerated by decoder for gear_change subfield components. Rear gear number. 1 is innermost.
            'name': "rear_gear_num",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # Do not populate directly. Autogenerated by decoder for gear_change subfield components. Number of rear teeth.
            'name': "rear_gear",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "device_index",
            'type': "device_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14, # Activity Type associated with an auto_activity_detect event
            'name': "activity_type",
            'type': "activity_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15, # Timestamp of when the event started
            'name': "start_timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "auto_activity_detect_start_timestamp",  # Auto Activity Detect Start Timestamp.
                'type': "date_time",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "event", 'raw_value': 54, 'value_name': "auto_activity_detect" },
                ],
               },
               ]
            },
        21: {
            'num': 21, # Do not populate directly. Autogenerated by decoder for threat_alert subfield components.
            'name': "radar_threat_level_max",
            'type': "radar_threat_level_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22, # Do not populate directly. Autogenerated by decoder for threat_alert subfield components.
            'name': "radar_threat_count",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23, # Do not populate directly. Autogenerated by decoder for radar_threat_alert subfield components
            'name': "radar_threat_avg_approach_speed",
            'type': "uint8",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24, # Do not populate directly. Autogenerated by decoder for radar_threat_alert subfield components
            'name': "radar_threat_max_approach_speed",
            'type': "uint8",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        23: {
        'num': "23",
        'name': "device_info",
        'messages_key': "device_info_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "device_index",
            'type': "device_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "device_type",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "ble_device_type", 
                'type': "ble_device_type",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "source_type", 'raw_value': 3, 'value_name': "bluetooth_low_energy" },
                ],
               },
               {
                'name': "antplus_device_type", 
                'type': "antplus_device_type",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "source_type", 'raw_value': 1, 'value_name': "antplus" },
                ],
               },
               {
                'name': "ant_device_type", 
                'type': "uint8",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "source_type", 'raw_value': 0, 'value_name': "ant" },
                ],
               },
               {
                'name': "local_device_type", 
                'type': "local_device_type",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 25, 'name': "source_type", 'raw_value': 5, 'value_name': "local" },
                ],
               },
               ]
            },
        2: {
            'num': 2,
            'name': "manufacturer",
            'type': "manufacturer",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "serial_number",
            'type': "uint32z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "product",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "favero_product", 
                'type': "favero_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 2, 'name': "manufacturer", 'raw_value': 263, 'value_name': "favero_electronics" },
                ],
               },
               {
                'name': "garmin_product", 
                'type': "garmin_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 2, 'name': "manufacturer", 'raw_value': 1, 'value_name': "garmin" },
                    { 'num': 2, 'name': "manufacturer", 'raw_value': 15, 'value_name': "dynastream" },
                    { 'num': 2, 'name': "manufacturer", 'raw_value': 13, 'value_name': "dynastream_oem" },
                    { 'num': 2, 'name': "manufacturer", 'raw_value': 89, 'value_name': "tacx" },
                ],
               },
               ]
            },
        5: {
            'num': 5,
            'name': "software_version",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "hardware_version",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Reset by new battery or charge.
            'name': "cum_operating_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "battery_voltage",
            'type': "uint16",
            'array': "false",
            'scale': [256],
            'offset': [0],
            'units': "V",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "battery_status",
            'type': "battery_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18, # Indicates the location of the sensor
            'name': "sensor_position",
            'type': "body_location",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        19: {
            'num': 19, # Used to describe the sensor or location
            'name': "descriptor",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        20: {
            'num': 20,
            'name': "ant_transmission_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "ant_device_number",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "ant_network",
            'type': "ant_network",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        25: {
            'num': 25,
            'name': "source_type",
            'type': "source_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        27: {
            'num': 27, # Optional free form string to indicate the devices name or model
            'name': "product_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        32: {
            'num': 32,
            'name': "battery_level",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        375: {
        'num': "375",
        'name': "device_aux_battery_info",
        'messages_key': "device_aux_battery_info_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "device_index",
            'type': "device_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "battery_voltage",
            'type': "uint16",
            'array': "false",
            'scale': [256],
            'offset': [0],
            'units': "V",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "battery_status",
            'type': "battery_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "battery_identifier",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        72: {
        'num': "72", # Corresponds to file_id of workout or course.
        'name': "training_file",
        'messages_key': "training_file_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "type",
            'type': "file",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "manufacturer",
            'type': "manufacturer",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "product",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "favero_product", 
                'type': "favero_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 263, 'value_name': "favero_electronics" },
                ],
               },
               {
                'name': "garmin_product", 
                'type': "garmin_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 1, 'value_name': "garmin" },
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 15, 'value_name': "dynastream" },
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 13, 'value_name': "dynastream_oem" },
                    { 'num': 1, 'name': "manufacturer", 'raw_value': 89, 'value_name': "tacx" },
                ],
               },
               ]
            },
        3: {
            'num': 3,
            'name': "serial_number",
            'type': "uint32z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "time_created",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        128: {
        'num': "128",
        'name': "weather_conditions",
        'messages_key': "weather_conditions_mesgs",
        'fields': {
        253: {
            'num': 253, # time of update for current conditions, else forecast time
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Current or forecast
            'name': "weather_report",
            'type': "weather_report",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Corresponds to GSC Response weatherIcon field
            'name': "condition",
            'type': "weather_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "wind_direction",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "wind_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # range 0-100
            'name': "precipitation_probability",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Heat Index if GCS heatIdx above or equal to 90F or wind chill if GCS windChill below or equal to 32F
            'name': "temperature_feels_like",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "relative_humidity",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # string corresponding to GCS response location string
            'name': "location",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "observed_at_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "observed_location_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "observed_location_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "day_of_week",
            'type': "day_of_week",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "high_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "low_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        129: {
        'num': "129",
        'name': "weather_alert",
        'messages_key': "weather_alert_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Unique identifier from GCS report ID string, length is 12
            'name': "report_id",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Time alert was issued
            'name': "issue_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Time alert expires
            'name': "expire_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Warning, Watch, Advisory, Statement
            'name': "severity",
            'type': "weather_severity",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Tornado, Severe Thunderstorm, etc.
            'name': "type",
            'type': "weather_severe_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        160: {
        'num': "160",
        'name': "gps_metadata",
        'messages_key': "gps_metadata_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond part of the timestamp.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "enhanced_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "enhanced_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "heading",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Used to correlate UTC to system time if the timestamp of the message is in system time. This UTC time is derived from the GPS data.
            'name': "utc_timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # velocity[0] is lon velocity. Velocity[1] is lat velocity. Velocity[2] is altitude velocity.
            'name': "velocity",
            'type': "sint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        161: {
        'num': "161",
        'name': "camera_event",
        'messages_key': "camera_event_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond part of the timestamp.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "camera_event_type",
            'type': "camera_event_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "camera_file_uuid",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "camera_orientation",
            'type': "camera_orientation_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        164: {
        'num': "164",
        'name': "gyroscope_data",
        'messages_key': "gyroscope_data_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond part of the timestamp.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Each time in the array describes the time at which the gyro sample with the corrosponding index was taken. Limited to 30 samples in each message. The samples may span across seconds. Array size must match the number of samples in gyro_x and gyro_y and gyro_z
            'name': "sample_time_offset",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "gyro_x",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "gyro_y",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "gyro_z",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Calibrated gyro reading
            'name': "calibrated_gyro_x",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "deg/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Calibrated gyro reading
            'name': "calibrated_gyro_y",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "deg/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Calibrated gyro reading
            'name': "calibrated_gyro_z",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "deg/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        165: {
        'num': "165",
        'name': "accelerometer_data",
        'messages_key': "accelerometer_data_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond part of the timestamp.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Each time in the array describes the time at which the accelerometer sample with the corrosponding index was taken. Limited to 30 samples in each message. The samples may span across seconds. Array size must match the number of samples in accel_x and accel_y and accel_z
            'name': "sample_time_offset",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "accel_x",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "accel_y",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "accel_z",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Calibrated accel reading
            'name': "calibrated_accel_x",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "g",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Calibrated accel reading
            'name': "calibrated_accel_y",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "g",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Calibrated accel reading
            'name': "calibrated_accel_z",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "g",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Calibrated accel reading
            'name': "compressed_calibrated_accel_x",
            'type': "sint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "mG",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Calibrated accel reading
            'name': "compressed_calibrated_accel_y",
            'type': "sint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "mG",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10, # Calibrated accel reading
            'name': "compressed_calibrated_accel_z",
            'type': "sint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "mG",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        208: {
        'num': "208",
        'name': "magnetometer_data",
        'messages_key': "magnetometer_data_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond part of the timestamp.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Each time in the array describes the time at which the compass sample with the corrosponding index was taken. Limited to 30 samples in each message. The samples may span across seconds. Array size must match the number of samples in cmps_x and cmps_y and cmps_z
            'name': "sample_time_offset",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "mag_x",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "mag_y",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "mag_z",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Calibrated Magnetometer reading
            'name': "calibrated_mag_x",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "G",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Calibrated Magnetometer reading
            'name': "calibrated_mag_y",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "G",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Calibrated Magnetometer reading
            'name': "calibrated_mag_z",
            'type': "float32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "G",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        209: {
        'num': "209",
        'name': "barometer_data",
        'messages_key': "barometer_data_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond part of the timestamp.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Each time in the array describes the time at which the barometer sample with the corrosponding index was taken. The samples may span across seconds. Array size must match the number of samples in baro_cal
            'name': "sample_time_offset",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # These are the raw ADC reading. The samples may span across seconds. A conversion will need to be done on this data once read.
            'name': "baro_pres",
            'type': "uint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "Pa",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        167: {
        'num': "167",
        'name': "three_d_sensor_calibration",
        'messages_key': "three_d_sensor_calibration_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Indicates which sensor the calibration is for
            'name': "sensor_type",
            'type': "sensor_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Calibration factor used to convert from raw ADC value to degrees, g, etc.
            'name': "calibration_factor",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "accel_cal_factor",  # Accelerometer calibration factor
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["g"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "sensor_type", 'raw_value': 0, 'value_name': "accelerometer" },
                ],
               },
               {
                'name': "gyro_cal_factor",  # Gyro calibration factor
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["deg/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "sensor_type", 'raw_value': 1, 'value_name': "gyroscope" },
                ],
               },
               ]
            },
        2: {
            'num': 2, # Calibration factor divisor
            'name': "calibration_divisor",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Level shift value used to shift the ADC value back into range
            'name': "level_shift",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Internal calibration factors, one for each: xy, yx, zx
            'name': "offset_cal",
            'type': "sint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # 3 x 3 rotation matrix (row major)
            'name': "orientation_matrix",
            'type': "sint32",
            'array': "true",
            'scale': [65535],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        210: {
        'num': "210",
        'name': "one_d_sensor_calibration",
        'messages_key': "one_d_sensor_calibration_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Indicates which sensor the calibration is for
            'name': "sensor_type",
            'type': "sensor_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Calibration factor used to convert from raw ADC value to degrees, g, etc.
            'name': "calibration_factor",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "baro_cal_factor",  # Barometer calibration factor
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["Pa"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "sensor_type", 'raw_value': 3, 'value_name': "barometer" },
                ],
               },
               ]
            },
        2: {
            'num': 2, # Calibration factor divisor
            'name': "calibration_divisor",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "counts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Level shift value used to shift the ADC value back into range
            'name': "level_shift",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Internal Calibration factor
            'name': "offset_cal",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        169: {
        'num': "169",
        'name': "video_frame",
        'messages_key': "video_frame_mesgs",
        'fields': {
        253: {
            'num': 253, # Whole second part of the timestamp
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond part of the timestamp.
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Number of the frame that the timestamp and timestamp_ms correlate to
            'name': "frame_number",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        174: {
        'num': "174",
        'name': "obdii_data",
        'messages_key': "obdii_data_mesgs",
        'fields': {
        253: {
            'num': 253, # Timestamp message was output
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Fractional part of timestamp, added to timestamp
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Offset of PID reading [i] from start_timestamp+start_timestamp_ms. Readings may span accross seconds.
            'name': "time_offset",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Parameter ID
            'name': "pid",
            'type': "byte",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Raw parameter data
            'name': "raw_data",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Optional, data size of PID[i]. If not specified refer to SAE J1979.
            'name': "pid_data_size",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # System time associated with sample expressed in ms, can be used instead of time_offset. There will be a system_time value for each raw_data element. For multibyte pids the system_time is repeated.
            'name': "system_time",
            'type': "uint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Timestamp of first sample recorded in the message. Used with time_offset to generate time of each sample
            'name': "start_timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Fractional part of start_timestamp
            'name': "start_timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        177: {
        'num': "177",
        'name': "nmea_sentence",
        'messages_key': "nmea_sentence_mesgs",
        'fields': {
        253: {
            'num': 253, # Timestamp message was output
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Fractional part of timestamp, added to timestamp
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # NMEA sentence
            'name': "sentence",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        178: {
        'num': "178",
        'name': "aviation_attitude",
        'messages_key': "aviation_attitude_mesgs",
        'fields': {
        253: {
            'num': 253, # Timestamp message was output
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Fractional part of timestamp, added to timestamp
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # System time associated with sample expressed in ms.
            'name': "system_time",
            'type': "uint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Range -PI/2 to +PI/2
            'name': "pitch",
            'type': "sint16",
            'array': "true",
            'scale': [10430.38],
            'offset': [0],
            'units': "radians",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Range -PI to +PI
            'name': "roll",
            'type': "sint16",
            'array': "true",
            'scale': [10430.38],
            'offset': [0],
            'units': "radians",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Range -78.4 to +78.4 (-8 Gs to 8 Gs)
            'name': "accel_lateral",
            'type': "sint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "m/s^2",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Range -78.4 to +78.4 (-8 Gs to 8 Gs)
            'name': "accel_normal",
            'type': "sint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "m/s^2",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Range -8.727 to +8.727 (-500 degs/sec to +500 degs/sec)
            'name': "turn_rate",
            'type': "sint16",
            'array': "true",
            'scale': [1024],
            'offset': [0],
            'units': "radians/second",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "stage",
            'type': "attitude_stage",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # The percent complete of the current attitude stage. Set to 0 for attitude stages 0, 1 and 2 and to 100 for attitude stage 3 by AHRS modules that do not support it. Range - 100
            'name': "attitude_stage_complete",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Track Angle/Heading Range 0 - 2pi
            'name': "track",
            'type': "uint16",
            'array': "true",
            'scale': [10430.38],
            'offset': [0],
            'units': "radians",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "validity",
            'type': "attitude_validity",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        184: {
        'num': "184",
        'name': "video",
        'messages_key': "video_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "url",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "hosting_provider",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Playback time of video
            'name': "duration",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        185: {
        'num': "185",
        'name': "video_title",
        'messages_key': "video_title_mesgs",
        'fields': {
        254: {
            'num': 254, # Long titles will be split into multiple parts
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Total number of title parts
            'name': "message_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "text",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        186: {
        'num': "186",
        'name': "video_description",
        'messages_key': "video_description_mesgs",
        'fields': {
        254: {
            'num': 254, # Long descriptions will be split into multiple parts
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Total number of description parts
            'name': "message_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "text",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        187: {
        'num': "187",
        'name': "video_clip",
        'messages_key': "video_clip_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "clip_number",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "start_timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "start_timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "end_timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "end_timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Start of clip in video time
            'name': "clip_start",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # End of clip in video time
            'name': "clip_end",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        225: {
        'num': "225",
        'name': "set",
        'messages_key': "set_mesgs",
        'fields': {
        254: {
            'num': 254, # Timestamp of the set
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "duration",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # # of repitions of the movement
            'name': "repetitions",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Amount of weight applied for the set
            'name': "weight",
            'type': "uint16",
            'array': "false",
            'scale': [16],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "set_type",
            'type': "set_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Start time of the set
            'name': "start_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "category",
            'type': "exercise_category",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Based on the associated category, see [category]_exercise_names
            'name': "category_subtype",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "weight_display_unit",
            'type': "fit_base_unit",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "wkt_step_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        285: {
        'num': "285",
        'name': "jump",
        'messages_key': "jump_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "distance",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "height",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "rotations",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "hang_time",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # A score for a jump calculated based on hang time, rotations, and distance.
            'name': "score",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000, ],
            'offset': [0, ],
            'units': ["m/s", ],
            'bits': [16,],
            'components': [8, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "enhanced_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        312: {
        'num': "312",
        'name': "split",
        'messages_key': "split_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "split_type",
            'type': "split_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "total_elapsed_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "total_timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "total_distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "avg_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "start_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "total_ascent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "total_descent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "start_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "start_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "end_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24,
            'name': "end_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        25: {
            'num': 25,
            'name': "max_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        26: {
            'num': 26,
            'name': "avg_vert_speed",
            'type': "sint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        27: {
            'num': 27,
            'name': "end_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        28: {
            'num': 28,
            'name': "total_calories",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        74: {
            'num': 74,
            'name': "start_elevation",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        110: {
            'num': 110,
            'name': "total_moving_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        313: {
        'num': "313",
        'name': "split_summary",
        'messages_key': "split_summary_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "split_type",
            'type': "split_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "num_splits",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "total_timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "total_distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "avg_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "max_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "total_ascent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "total_descent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "avg_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "max_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "avg_vert_speed",
            'type': "sint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "total_calories",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        77: {
            'num': 77,
            'name': "total_moving_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        317: {
        'num': "317",
        'name': "climb_pro",
        'messages_key': "climb_pro_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "climb_pro_event",
            'type': "climb_pro_event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "climb_number",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "climb_category",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "current_dist",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        206: {
        'num': "206", # Must be logged before developer field is used
        'name': "field_description",
        'messages_key': "field_description_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "developer_data_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "field_definition_number",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "fit_base_type_id",
            'type': "fit_base_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "field_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "array",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "components",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "scale",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "offset",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "units",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "bits",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "accumulate",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "fit_base_unit_id",
            'type': "fit_base_unit",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "native_mesg_num",
            'type': "mesg_num",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "native_field_num",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        207: {
        'num': "207", # Must be logged before field description
        'name': "developer_data_id",
        'messages_key': "developer_data_id_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "developer_id",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "application_id",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "manufacturer_id",
            'type': "manufacturer",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "developer_data_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "application_version",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        31: {
        'num': "31",
        'name': "course",
        'messages_key': "course_mesgs",
        'fields': {
        4: {
            'num': 4,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "capabilities",
            'type': "course_capabilities",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        32: {
        'num': "32",
        'name': "course_point",
        'messages_key': "course_point_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "type",
            'type': "course_point",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "favorite",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        148: {
        'num': "148", # Unique Identification data for a segment file
        'name': "segment_id",
        'messages_key': "segment_id_mesgs",
        'fields': {
        0: {
            'num': 0, # Friendly name assigned to segment
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # UUID of the segment
            'name': "uuid",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Sport associated with the segment
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Segment enabled for evaluation
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Primary key of the user that created the segment
            'name': "user_profile_primary_key",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # ID of the device that created the segment
            'name': "device_id",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Index for the Leader Board entry selected as the default race participant
            'name': "default_race_leader",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Indicates if any segments should be deleted
            'name': "delete_status",
            'type': "segment_delete_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Indicates how the segment was selected to be sent to the device
            'name': "selection_type",
            'type': "segment_selection_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        149: {
        'num': "149", # Unique Identification data for an individual segment leader within a segment file
        'name': "segment_leaderboard_entry",
        'messages_key': "segment_leaderboard_entry_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Friendly name assigned to leader
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Leader classification
            'name': "type",
            'type': "segment_leaderboard_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Primary user ID of this leader
            'name': "group_primary_key",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # ID of the activity associated with this leader time
            'name': "activity_id",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Segment Time (includes pauses)
            'name': "segment_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # String version of the activity_id. 21 characters long, express in decimal
            'name': "activity_id_string",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        150: {
        'num': "150", # Navigation and race evaluation point for a segment decribing a point along the segment path and time it took each segment leader to reach that point
        'name': "segment_point",
        'messages_key': "segment_point_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Accumulated distance along the segment at the described point
            'name': "distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Accumulated altitude along the segment at the described point
            'name': "altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [6, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        5: {
            'num': 5, # Accumualted time each leader board member required to reach the described point. This value is zero for all leader board members at the starting point of the segment.
            'name': "leader_time",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Accumulated altitude along the segment at the described point
            'name': "enhanced_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        142: {
        'num': "142",
        'name': "segment_lap",
        'messages_key': "segment_lap_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        253: {
            'num': 253, # Lap end time.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "event",
            'type': "event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "event_type",
            'type': "event_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "start_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "start_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "start_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "end_position_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "end_position_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Time (includes pauses)
            'name': "total_elapsed_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Timer Time (excludes pauses)
            'name': "total_timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "total_distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "total_cycles",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "total_strokes", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["strokes"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 23, 'name': "sport", 'raw_value': 2, 'value_name': "cycling" },
                ],
               },
               ]
            },
        11: {
            'num': 11,
            'name': "total_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # If New Leaf
            'name': "total_fat_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "avg_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "max_speed",
            'type': "uint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "avg_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        16: {
            'num': 16,
            'name': "max_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17, # total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
            'name': "avg_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        18: {
            'num': 18,
            'name': "max_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        19: {
            'num': 19, # total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
            'name': "avg_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        20: {
            'num': 20,
            'name': "max_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        21: {
            'num': 21,
            'name': "total_ascent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22,
            'name': "total_descent",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24,
            'name': "event_group",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        25: {
            'num': 25, # North east corner latitude.
            'name': "nec_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        26: {
            'num': 26, # North east corner longitude.
            'name': "nec_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        27: {
            'num': 27, # South west corner latitude.
            'name': "swc_lat",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        28: {
            'num': 28, # South west corner latitude.
            'name': "swc_long",
            'type': "sint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "semicircles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        29: {
            'num': 29,
            'name': "name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        30: {
            'num': 30,
            'name': "normalized_power",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        31: {
            'num': 31,
            'name': "left_right_balance",
            'type': "left_right_balance_100",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        32: {
            'num': 32,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        33: {
            'num': 33,
            'name': "total_work",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "J",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        34: {
            'num': 34,
            'name': "avg_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [91, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        35: {
            'num': 35,
            'name': "max_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [92, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        36: {
            'num': 36,
            'name': "gps_accuracy",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        37: {
            'num': 37,
            'name': "avg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        38: {
            'num': 38,
            'name': "avg_pos_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        39: {
            'num': 39,
            'name': "avg_neg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        40: {
            'num': 40,
            'name': "max_pos_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        41: {
            'num': 41,
            'name': "max_neg_grade",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        42: {
            'num': 42,
            'name': "avg_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        43: {
            'num': 43,
            'name': "max_temperature",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        44: {
            'num': 44,
            'name': "total_moving_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        45: {
            'num': 45,
            'name': "avg_pos_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        46: {
            'num': 46,
            'name': "avg_neg_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        47: {
            'num': 47,
            'name': "max_pos_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        48: {
            'num': 48,
            'name': "max_neg_vertical_speed",
            'type': "sint16",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        49: {
            'num': 49,
            'name': "time_in_hr_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        50: {
            'num': 50,
            'name': "time_in_speed_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        51: {
            'num': 51,
            'name': "time_in_cadence_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        52: {
            'num': 52,
            'name': "time_in_power_zone",
            'type': "uint32",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        53: {
            'num': 53,
            'name': "repetition_num",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        54: {
            'num': 54,
            'name': "min_altitude",
            'type': "uint16",
            'array': "false",
            'scale': [5, ],
            'offset': [500, ],
            'units': ["m", ],
            'bits': [16,],
            'components': [93, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        55: {
            'num': 55,
            'name': "min_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        56: {
            'num': 56,
            'name': "active_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        57: {
            'num': 57,
            'name': "wkt_step_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        58: {
            'num': 58,
            'name': "sport_event",
            'type': "sport_event",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        59: {
            'num': 59,
            'name': "avg_left_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        60: {
            'num': 60,
            'name': "avg_right_torque_effectiveness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        61: {
            'num': 61,
            'name': "avg_left_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        62: {
            'num': 62,
            'name': "avg_right_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        63: {
            'num': 63,
            'name': "avg_combined_pedal_smoothness",
            'type': "uint8",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        64: {
            'num': 64,
            'name': "status",
            'type': "segment_lap_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        65: {
            'num': 65,
            'name': "uuid",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        66: {
            'num': 66, # fractional part of the avg_cadence
            'name': "avg_fractional_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        67: {
            'num': 67, # fractional part of the max_cadence
            'name': "max_fractional_cadence",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        68: {
            'num': 68, # fractional part of the total_cycles
            'name': "total_fractional_cycles",
            'type': "uint8",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        69: {
            'num': 69,
            'name': "front_gear_shift_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        70: {
            'num': 70,
            'name': "rear_gear_shift_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        71: {
            'num': 71, # Total time spent in the standing position
            'name': "time_standing",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        72: {
            'num': 72, # Number of transitions to the standing state
            'name': "stand_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        73: {
            'num': 73, # Average left platform center offset
            'name': "avg_left_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        74: {
            'num': 74, # Average right platform center offset
            'name': "avg_right_pco",
            'type': "sint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        75: {
            'num': 75, # Average left power phase angles. Data value indexes defined by power_phase_type.
            'name': "avg_left_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        76: {
            'num': 76, # Average left power phase peak angles. Data value indexes defined by power_phase_type.
            'name': "avg_left_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        77: {
            'num': 77, # Average right power phase angles. Data value indexes defined by power_phase_type.
            'name': "avg_right_power_phase",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        78: {
            'num': 78, # Average right power phase peak angles. Data value indexes defined by power_phase_type.
            'name': "avg_right_power_phase_peak",
            'type': "uint8",
            'array': "true",
            'scale': [0.7111111],
            'offset': [0],
            'units': "degrees",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        79: {
            'num': 79, # Average power by position. Data value indexes defined by rider_position_type.
            'name': "avg_power_position",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        80: {
            'num': 80, # Maximum power by position. Data value indexes defined by rider_position_type.
            'name': "max_power_position",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "watts",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        81: {
            'num': 81, # Average cadence by position. Data value indexes defined by rider_position_type.
            'name': "avg_cadence_position",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        82: {
            'num': 82, # Maximum cadence by position. Data value indexes defined by rider_position_type.
            'name': "max_cadence_position",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "rpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        83: {
            'num': 83, # Manufacturer that produced the segment
            'name': "manufacturer",
            'type': "manufacturer",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        84: {
            'num': 84, # The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
            'name': "total_grit",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kGrit",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        85: {
            'num': 85, # The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
            'name': "total_flow",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "Flow",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        86: {
            'num': 86, # The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
            'name': "avg_grit",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kGrit",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        87: {
            'num': 87, # The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
            'name': "avg_flow",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "Flow",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        89: {
            'num': 89, # fractional part of total_ascent
            'name': "total_fractional_ascent",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        90: {
            'num': 90, # fractional part of total_descent
            'name': "total_fractional_descent",
            'type': "uint8",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        91: {
            'num': 91,
            'name': "enhanced_avg_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        92: {
            'num': 92,
            'name': "enhanced_max_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        93: {
            'num': 93,
            'name': "enhanced_min_altitude",
            'type': "uint32",
            'array': "false",
            'scale': [5],
            'offset': [500],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        151: {
        'num': "151", # Summary of the unique segment and leaderboard information associated with a segment file. This message is used to compile a segment list file describing all segment files on a device. The segment list file is used when refreshing the contents of a segment file with the latest available leaderboard information.
        'name': "segment_file",
        'messages_key': "segment_file_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # UUID of the segment file
            'name': "file_uuid",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Enabled state of the segment file
            'name': "enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Primary key of the user that created the segment file
            'name': "user_profile_primary_key",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Leader type of each leader in the segment file
            'name': "leader_type",
            'type': "segment_leaderboard_type",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Group primary key of each leader in the segment file
            'name': "leader_group_primary_key",
            'type': "uint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Activity ID of each leader in the segment file
            'name': "leader_activity_id",
            'type': "uint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10, # String version of the activity ID of each leader in the segment file. 21 characters long for each ID, express in decimal
            'name': "leader_activity_id_string",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11, # Index for the Leader Board entry selected as the default race participant
            'name': "default_race_leader",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        26: {
        'num': "26",
        'name': "workout",
        'messages_key': "workout_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "capabilities",
            'type': "workout_capabilities",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # number of valid steps
            'name': "num_valid_steps",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "wkt_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14,
            'name': "pool_length",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15,
            'name': "pool_length_unit",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17, # Description of the workout
            'name': "wkt_description",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        158: {
        'num': "158",
        'name': "workout_session",
        'messages_key': "workout_session_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "num_valid_steps",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "first_step_index",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "pool_length",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "pool_length_unit",
            'type': "display_measure",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        27: {
        'num': "27",
        'name': "workout_step",
        'messages_key': "workout_step_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "wkt_step_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "duration_type",
            'type': "wkt_step_duration",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "duration_value",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "duration_time", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 0, 'value_name': "time" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 28, 'value_name': "repetition_time" },
                ],
               },
               {
                'name': "duration_distance", 
                'type': "uint32",
                'array': "",
                'scale': [100],
                'offset': [0],
                'units': ["m"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 1, 'value_name': "distance" },
                ],
               },
               {
                'name': "duration_hr", 
                'type': "workout_hr",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 2, 'value_name': "hr_less_than" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 3, 'value_name': "hr_greater_than" },
                ],
               },
               {
                'name': "duration_calories", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["calories"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 4, 'value_name': "calories" },
                ],
               },
               {
                'name': "duration_step",  # message_index of step to loop back to. Steps are assumed to be in the order by message_index. custom_name and intensity members are undefined for this duration type.
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 6, 'value_name': "repeat_until_steps_cmplt" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 7, 'value_name': "repeat_until_time" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 8, 'value_name': "repeat_until_distance" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 9, 'value_name': "repeat_until_calories" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 10, 'value_name': "repeat_until_hr_less_than" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 11, 'value_name': "repeat_until_hr_greater_than" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 12, 'value_name': "repeat_until_power_less_than" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 13, 'value_name': "repeat_until_power_greater_than" },
                ],
               },
               {
                'name': "duration_power", 
                'type': "workout_power",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 14, 'value_name': "power_less_than" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 15, 'value_name': "power_greater_than" },
                ],
               },
               {
                'name': "duration_reps", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 29, 'value_name': "reps" },
                ],
               },
               ]
            },
        3: {
            'num': 3,
            'name': "target_type",
            'type': "wkt_step_target",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "target_value",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "target_speed_zone",  # speed zone (1-10);Custom =0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 0, 'value_name': "speed" },
                ],
               },
               {
                'name': "target_hr_zone",  # hr zone (1-5);Custom =0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 1, 'value_name': "heart_rate" },
                ],
               },
               {
                'name': "target_cadence_zone",  # Zone (1-?); Custom = 0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 3, 'value_name': "cadence" },
                ],
               },
               {
                'name': "target_power_zone",  # Power Zone ( 1-7); Custom = 0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 4, 'value_name': "power" },
                ],
               },
               {
                'name': "repeat_steps",  # # of repetitions
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 6, 'value_name': "repeat_until_steps_cmplt" },
                ],
               },
               {
                'name': "repeat_time", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 7, 'value_name': "repeat_until_time" },
                ],
               },
               {
                'name': "repeat_distance", 
                'type': "uint32",
                'array': "",
                'scale': [100],
                'offset': [0],
                'units': ["m"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 8, 'value_name': "repeat_until_distance" },
                ],
               },
               {
                'name': "repeat_calories", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["calories"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 9, 'value_name': "repeat_until_calories" },
                ],
               },
               {
                'name': "repeat_hr", 
                'type': "workout_hr",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 10, 'value_name': "repeat_until_hr_less_than" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 11, 'value_name': "repeat_until_hr_greater_than" },
                ],
               },
               {
                'name': "repeat_power", 
                'type': "workout_power",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 1, 'name': "duration_type", 'raw_value': 12, 'value_name': "repeat_until_power_less_than" },
                    { 'num': 1, 'name': "duration_type", 'raw_value': 13, 'value_name': "repeat_until_power_greater_than" },
                ],
               },
               {
                'name': "target_stroke_type", 
                'type': "swim_stroke",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 11, 'value_name': "swim_stroke" },
                ],
               },
               ]
            },
        5: {
            'num': 5,
            'name': "custom_target_value_low",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "custom_target_speed_low", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["m/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 0, 'value_name': "speed" },
                ],
               },
               {
                'name': "custom_target_heart_rate_low", 
                'type': "workout_hr",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 1, 'value_name': "heart_rate" },
                ],
               },
               {
                'name': "custom_target_cadence_low", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["rpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 3, 'value_name': "cadence" },
                ],
               },
               {
                'name': "custom_target_power_low", 
                'type': "workout_power",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 4, 'value_name': "power" },
                ],
               },
               ]
            },
        6: {
            'num': 6,
            'name': "custom_target_value_high",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "custom_target_speed_high", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["m/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 0, 'value_name': "speed" },
                ],
               },
               {
                'name': "custom_target_heart_rate_high", 
                'type': "workout_hr",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 1, 'value_name': "heart_rate" },
                ],
               },
               {
                'name': "custom_target_cadence_high", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["rpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 3, 'value_name': "cadence" },
                ],
               },
               {
                'name': "custom_target_power_high", 
                'type': "workout_power",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 3, 'name': "target_type", 'raw_value': 4, 'value_name': "power" },
                ],
               },
               ]
            },
        7: {
            'num': 7,
            'name': "intensity",
            'type': "intensity",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "notes",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "equipment",
            'type': "workout_equipment",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "exercise_category",
            'type': "exercise_category",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "exercise_name",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12,
            'name': "exercise_weight",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "weight_display_unit",
            'type': "fit_base_unit",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        19: {
            'num': 19,
            'name': "secondary_target_type",
            'type': "wkt_step_target",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        20: {
            'num': 20,
            'name': "secondary_target_value",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "secondary_target_speed_zone",  # speed zone (1-10);Custom =0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 0, 'value_name': "speed" },
                ],
               },
               {
                'name': "secondary_target_hr_zone",  # hr zone (1-5);Custom =0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 1, 'value_name': "heart_rate" },
                ],
               },
               {
                'name': "secondary_target_cadence_zone",  # Zone (1-?); Custom = 0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 3, 'value_name': "cadence" },
                ],
               },
               {
                'name': "secondary_target_power_zone",  # Power Zone ( 1-7); Custom = 0;
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 4, 'value_name': "power" },
                ],
               },
               {
                'name': "secondary_target_stroke_type", 
                'type': "swim_stroke",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 11, 'value_name': "swim_stroke" },
                ],
               },
               ]
            },
        21: {
            'num': 21,
            'name': "secondary_custom_target_value_low",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "secondary_custom_target_speed_low", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["m/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 0, 'value_name': "speed" },
                ],
               },
               {
                'name': "secondary_custom_target_heart_rate_low", 
                'type': "workout_hr",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 1, 'value_name': "heart_rate" },
                ],
               },
               {
                'name': "secondary_custom_target_cadence_low", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["rpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 3, 'value_name': "cadence" },
                ],
               },
               {
                'name': "secondary_custom_target_power_low", 
                'type': "workout_power",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 4, 'value_name': "power" },
                ],
               },
               ]
            },
        22: {
            'num': 22,
            'name': "secondary_custom_target_value_high",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "secondary_custom_target_speed_high", 
                'type': "uint32",
                'array': "",
                'scale': [1000],
                'offset': [0],
                'units': ["m/s"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 0, 'value_name': "speed" },
                ],
               },
               {
                'name': "secondary_custom_target_heart_rate_high", 
                'type': "workout_hr",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or bpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 1, 'value_name': "heart_rate" },
                ],
               },
               {
                'name': "secondary_custom_target_cadence_high", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["rpm"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 3, 'value_name': "cadence" },
                ],
               },
               {
                'name': "secondary_custom_target_power_high", 
                'type': "workout_power",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["% or watts"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 19, 'name': "secondary_target_type", 'raw_value': 4, 'value_name': "power" },
                ],
               },
               ]
            },
    },
},
        264: {
        'num': "264",
        'name': "exercise_title",
        'messages_key': "exercise_title_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "exercise_category",
            'type': "exercise_category",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "exercise_name",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "wkt_step_name",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        28: {
        'num': "28",
        'name': "schedule",
        'messages_key': "schedule_mesgs",
        'fields': {
        0: {
            'num': 0, # Corresponds to file_id of scheduled workout / course.
            'name': "manufacturer",
            'type': "manufacturer",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Corresponds to file_id of scheduled workout / course.
            'name': "product",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "favero_product", 
                'type': "favero_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 263, 'value_name': "favero_electronics" },
                ],
               },
               {
                'name': "garmin_product", 
                'type': "garmin_product",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': [""],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 1, 'value_name': "garmin" },
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 15, 'value_name': "dynastream" },
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 13, 'value_name': "dynastream_oem" },
                    { 'num': 0, 'name': "manufacturer", 'raw_value': 89, 'value_name': "tacx" },
                ],
               },
               ]
            },
        2: {
            'num': 2, # Corresponds to file_id of scheduled workout / course.
            'name': "serial_number",
            'type': "uint32z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Corresponds to file_id of scheduled workout / course.
            'name': "time_created",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # TRUE if this activity has been started
            'name': "completed",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "type",
            'type': "schedule",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "scheduled_time",
            'type': "local_date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        33: {
        'num': "33",
        'name': "totals",
        'messages_key': "totals_mesgs",
        'fields': {
        254: {
            'num': 254,
            'name': "message_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Excludes pauses
            'name': "timer_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "distance",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "calories",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Includes pauses
            'name': "elapsed_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "sessions",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "active_time",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "sport_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        30: {
        'num': "30",
        'name': "weight_scale",
        'messages_key': "weight_scale_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "weight",
            'type': "weight",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "percent_fat",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "percent_hydration",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "%",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "visceral_fat_mass",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "bone_mass",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "muscle_mass",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "kg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "basal_met",
            'type': "uint16",
            'array': "false",
            'scale': [4],
            'offset': [0],
            'units': "kcal/day",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "physique_rating",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # ~4kJ per kcal, 0.25 allows max 16384 kcal
            'name': "active_met",
            'type': "uint16",
            'array': "false",
            'scale': [4],
            'offset': [0],
            'units': "kcal/day",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "metabolic_age",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "years",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "visceral_fat_rating",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # Associates this weight scale message to a user. This corresponds to the index of the user profile message in the weight scale file.
            'name': "user_profile_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13,
            'name': "bmi",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "kg/m^2",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        51: {
        'num': "51",
        'name': "blood_pressure",
        'messages_key': "blood_pressure_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "systolic_pressure",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mmHg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "diastolic_pressure",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mmHg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "mean_arterial_pressure",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mmHg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "map_3_sample_mean",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mmHg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "map_morning_values",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mmHg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "map_evening_values",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "mmHg",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "heart_rate_type",
            'type': "hr_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "status",
            'type': "bp_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Associates this blood pressure message to a user. This corresponds to the index of the user profile message in the blood pressure file.
            'name': "user_profile_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        103: {
        'num': "103",
        'name': "monitoring_info",
        'messages_key': "monitoring_info_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Use to convert activity timestamps to local time if device does not support time zone and daylight savings time correction.
            'name': "local_timestamp",
            'type': "local_date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "activity_type",
            'type': "activity_type",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Indexed by activity_type
            'name': "cycles_to_distance",
            'type': "uint16",
            'array': "true",
            'scale': [5000],
            'offset': [0],
            'units': "m/cycle",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Indexed by activity_type
            'name': "cycles_to_calories",
            'type': "uint16",
            'array': "true",
            'scale': [5000],
            'offset': [0],
            'units': "kcal/cycle",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "resting_metabolic_rate",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal / day",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        55: {
        'num': "55",
        'name': "monitoring",
        'messages_key': "monitoring_mesgs",
        'fields': {
        253: {
            'num': 253, # Must align to logging interval, for example, time must be 00:00:00 for daily log.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Associates this data to device_info message. Not required for file with single device (sensor).
            'name': "device_index",
            'type': "device_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Accumulated total calories. Maintained by MonitoringReader for each activity_type. See SDK documentation
            'name': "calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Accumulated distance. Maintained by MonitoringReader for each activity_type. See SDK documentation.
            'name': "distance",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Accumulated cycles. Maintained by MonitoringReader for each activity_type. See SDK documentation.
            'name': "cycles",
            'type': "uint32",
            'array': "false",
            'scale': [2],
            'offset': [0],
            'units': "cycles",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': [{
                'name': "steps", 
                'type': "uint32",
                'array': "",
                'scale': [1],
                'offset': [0],
                'units': ["steps"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 5, 'name': "activity_type", 'raw_value': 6, 'value_name': "walking" },
                    { 'num': 5, 'name': "activity_type", 'raw_value': 1, 'value_name': "running" },
                ],
               },
               {
                'name': "strokes", 
                'type': "uint32",
                'array': "",
                'scale': [2],
                'offset': [0],
                'units': ["strokes"],
                'bits': [],
                'components': [],
                'has_components': False,
                'map':[
                    { 'num': 5, 'name': "activity_type", 'raw_value': 2, 'value_name': "cycling" },
                    { 'num': 5, 'name': "activity_type", 'raw_value': 5, 'value_name': "swimming" },
                ],
               },
               ]
            },
        4: {
            'num': 4,
            'name': "active_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "activity_type",
            'type': "activity_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "activity_subtype",
            'type': "activity_subtype",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "activity_level",
            'type': "activity_level",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "distance_16",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "100 * m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "cycles_16",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "2 * cycles (steps)",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "active_time_16",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11, # Must align to logging interval, for example, time must be 00:00:00 for daily log.
            'name': "local_timestamp",
            'type': "local_date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # Avg temperature during the logging interval ended at timestamp
            'name': "temperature",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14, # Min temperature during the logging interval ended at timestamp
            'name': "temperature_min",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15, # Max temperature during the logging interval ended at timestamp
            'name': "temperature_max",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "C",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        16: {
            'num': 16, # Indexed using minute_activity_level enum
            'name': "activity_time",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "minutes",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        19: {
            'num': 19,
            'name': "active_calories",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "kcal",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24, # Indicates single type / intensity for duration since last monitoring message.
            'name': "current_activity_type_intensity",
            'type': "byte",
            'array': "false",
            'scale': [1, 1, ],
            'offset': [0, 0, ],
            'units': ["", "", ],
            'bits': [5,3,],
            'components': [5, 28, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        25: {
            'num': 25,
            'name': "timestamp_min_8",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        26: {
            'num': 26,
            'name': "timestamp_16",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        27: {
            'num': 27,
            'name': "heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        28: {
            'num': 28,
            'name': "intensity",
            'type': "uint8",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        29: {
            'num': 29,
            'name': "duration_min",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        30: {
            'num': 30,
            'name': "duration",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        31: {
            'num': 31,
            'name': "ascent",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        32: {
            'num': 32,
            'name': "descent",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        33: {
            'num': 33,
            'name': "moderate_activity_minutes",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "minutes",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        34: {
            'num': 34,
            'name': "vigorous_activity_minutes",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "minutes",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        211: {
        'num': "211",
        'name': "monitoring_hr_data",
        'messages_key': "monitoring_hr_data_mesgs",
        'fields': {
        253: {
            'num': 253, # Must align to logging interval, for example, time must be 00:00:00 for daily log.
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # 7-day rolling average
            'name': "resting_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # RHR for today only. (Feeds into 7-day average)
            'name': "current_day_resting_heart_rate",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        269: {
        'num': "269",
        'name': "spo2_data",
        'messages_key': "spo2_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "reading_spo2",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "reading_confidence",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Mode when data was captured
            'name': "mode",
            'type': "spo2_measurement_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        132: {
        'num': "132",
        'name': "hr",
        'messages_key': "hr_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "fractional_timestamp",
            'type': "uint16",
            'array': "false",
            'scale': [32768],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "time256",
            'type': "uint8",
            'array': "false",
            'scale': [256, ],
            'offset': [0, ],
            'units': ["s", ],
            'bits': [8,],
            'components': [0, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "filtered_bpm",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "event_timestamp",
            'type': "uint32",
            'array': "true",
            'scale': [1024],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': True,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "event_timestamp_12",
            'type': "byte",
            'array': "true",
            'scale': [1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, ],
            'offset': [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ],
            'units': ["s", "", "", "", "", "", "", "", "", "", ],
            'bits': [12,12,12,12,12,12,12,12,12,12,],
            'components': [9, 9, 9, 9, 9, 9, 9, 9, 9, 9, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
    },
},
        227: {
        'num': "227", # Value from 1 to 100 calculated by FirstBeat
        'name': "stress_level",
        'messages_key': "stress_level_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "stress_level_value",
            'type': "sint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Time stress score was calculated
            'name': "stress_level_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        229: {
        'num': "229",
        'name': "max_met_data",
        'messages_key': "max_met_data_mesgs",
        'fields': {
        0: {
            'num': 0, # Time maxMET and vo2 were calculated
            'name': "update_time",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "vo2_max",
            'type': "uint16",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "mL/kg/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "sport",
            'type': "sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "sub_sport",
            'type': "sub_sport",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "max_met_category",
            'type': "max_met_category",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Indicates if calibrated data was used in the calculation
            'name': "calibrated_data",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # Indicates if the estimate was obtained using a chest strap or wrist heart rate
            'name': "hr_source",
            'type': "max_met_heart_rate_source",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13, # Indidcates if the estimate was obtained using onboard GPS or connected GPS
            'name': "speed_source",
            'type': "max_met_speed_source",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        314: {
        'num': "314", # Body battery data used for HSA custom data logging
        'name': "hsa_body_battery_data",
        'messages_key': "hsa_body_battery_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Processing interval length in seconds
            'name': "processing_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Body battery level: [0,100] Blank: -16
            'name': "level",
            'type': "sint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Body battery charged value
            'name': "charged",
            'type': "sint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Body battery uncharged value
            'name': "uncharged",
            'type': "sint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        315: {
        'num': "315", # HSA events
        'name': "hsa_event",
        'messages_key': "hsa_event_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Event ID. Health SDK use only
            'name': "event_id",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        302: {
        'num': "302", # Raw accelerometer data used for HSA custom data logging
        'name': "hsa_accelerometer_data",
        'messages_key': "hsa_accelerometer_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond resolution of the timestamp
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Sampling Interval in Milliseconds
            'name': "sampling_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # X-Axis Measurement
            'name': "accel_x",
            'type': "sint16",
            'array': "true",
            'scale': [1.024],
            'offset': [0],
            'units': "mG",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Y-Axis Measurement
            'name': "accel_y",
            'type': "sint16",
            'array': "true",
            'scale': [1.024],
            'offset': [0],
            'units': "mG",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Z-Axis Measurement
            'name': "accel_z",
            'type': "sint16",
            'array': "true",
            'scale': [1.024],
            'offset': [0],
            'units': "mG",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # 32 kHz timestamp
            'name': "timestamp_32k",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        376: {
        'num': "376",
        'name': "hsa_gyroscope_data",
        'messages_key': "hsa_gyroscope_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond resolution of the timestamp
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Sampling Interval in 32 kHz timescale
            'name': "sampling_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "1/32768 s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # X-Axis Measurement
            'name': "gyro_x",
            'type': "sint16",
            'array': "true",
            'scale': [28.57143],
            'offset': [0],
            'units': "deg/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Y-Axis Measurement
            'name': "gyro_y",
            'type': "sint16",
            'array': "true",
            'scale': [28.57143],
            'offset': [0],
            'units': "deg/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Z-Axis Measurement
            'name': "gyro_z",
            'type': "sint16",
            'array': "true",
            'scale': [28.57143],
            'offset': [0],
            'units': "deg/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # 32 kHz timestamp
            'name': "timestamp_32k",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "1/32768 s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        304: {
        'num': "304", # User's current daily step data used for HSA custom data logging
        'name': "hsa_step_data",
        'messages_key': "hsa_step_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Processing interval length in seconds. File start: 0xFFFFFFEF File stop: 0xFFFFFFEE
            'name': "processing_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Total step sum
            'name': "steps",
            'type': "uint32",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "steps",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        305: {
        'num': "305", # User's current SpO2 data used for HSA custom data logging
        'name': "hsa_spo2_data",
        'messages_key': "hsa_spo2_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Processing interval length in seconds
            'name': "processing_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # SpO2 Reading: [70,100] Blank: 240
            'name': "reading_spo2",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # SpO2 Confidence: [0,254]
            'name': "confidence",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        306: {
        'num': "306", # User's current stress data used for HSA custom data logging
        'name': "hsa_stress_data",
        'messages_key': "hsa_stress_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Processing interval length in seconds
            'name': "processing_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Stress Level: [0,100] Off wrist: -1 Excess motion: -2 Not enough data: -3 Recovering from exercise: -4 Unidentified: -5 Blank: -16
            'name': "stress_level",
            'type': "sint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        307: {
        'num': "307", # User's current respiration data used for HSA custom data logging
        'name': "hsa_respiration_data",
        'messages_key': "hsa_respiration_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Processing interval length in seconds
            'name': "processing_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Breaths / min: [1,100] Invalid: 255 Excess motion: 254 Off wrist: 253 Not available: 252 Blank: 2.4
            'name': "respiration_rate",
            'type': "sint16",
            'array': "true",
            'scale': [100],
            'offset': [0],
            'units': "breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        308: {
        'num': "308", # User's current heart rate data used for HSA custom data logging
        'name': "hsa_heart_rate_data",
        'messages_key': "hsa_heart_rate_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Processing interval length in seconds
            'name': "processing_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Status of measurements in buffer - 0 indicates SEARCHING 1 indicates LOCKED
            'name': "status",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Beats / min. Blank: 0
            'name': "heart_rate",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "bpm",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        389: {
        'num': "389", # Configuration data for HSA custom data logging
        'name': "hsa_configuration_data",
        'messages_key': "hsa_configuration_data_mesgs",
        'fields': {
        253: {
            'num': 253, # Encoded configuration data
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Encoded configuration data. Health SDK use only
            'name': "data",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Size in bytes of data field
            'name': "data_size",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        409: {
        'num': "409", # Wrist temperature data used for HSA custom data logging
        'name': "hsa_wrist_temperature_data",
        'messages_key': "hsa_wrist_temperature_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Processing interval length in seconds
            'name': "processing_interval",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Wrist temperature reading
            'name': "value",
            'type': "uint16",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "degC",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        145: {
        'num': "145",
        'name': "memo_glob",
        'messages_key': "memo_glob_mesgs",
        'fields': {
        250: {
            'num': 250, # Sequence number of memo blocks
            'name': "part_index",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Deprecated. Use data field.
            'name': "memo",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Message Number of the parent message
            'name': "mesg_num",
            'type': "mesg_num",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Index of mesg that this glob is associated with.
            'name': "parent_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Field within the parent that this glob is associated with
            'name': "field_num",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Block of utf8 bytes. Note, mutltibyte characters may be split across adjoining memo_glob messages.
            'name': "data",
            'type': "uint8z",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        275: {
        'num': "275",
        'name': "sleep_level",
        'messages_key': "sleep_level_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "sleep_level",
            'type': "sleep_level",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        82: {
        'num': "82",
        'name': "ant_channel_id",
        'messages_key': "ant_channel_id_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "channel_number",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "device_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "device_number",
            'type': "uint16z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "transmission_type",
            'type': "uint8z",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "device_index",
            'type': "device_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        80: {
        'num': "80",
        'name': "ant_rx",
        'messages_key': "ant_rx_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "fractional_timestamp",
            'type': "uint16",
            'array': "false",
            'scale': [32768],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "mesg_id",
            'type': "byte",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "mesg_data",
            'type': "byte",
            'array': "true",
            'scale': [1, 1, 1, 1, 1, 1, 1, 1, 1, ],
            'offset': [0, 0, 0, 0, 0, 0, 0, 0, 0, ],
            'units': ["", "", "", "", "", "", "", "", "", ],
            'bits': [8,8,8,8,8,8,8,8,8,],
            'components': [3, 4, 4, 4, 4, 4, 4, 4, 4, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "channel_number",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "data",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        81: {
        'num': "81",
        'name': "ant_tx",
        'messages_key': "ant_tx_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "fractional_timestamp",
            'type': "uint16",
            'array': "false",
            'scale': [32768],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "mesg_id",
            'type': "byte",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "mesg_data",
            'type': "byte",
            'array': "true",
            'scale': [1, 1, 1, 1, 1, 1, 1, 1, 1, ],
            'offset': [0, 0, 0, 0, 0, 0, 0, 0, 0, ],
            'units': ["", "", "", "", "", "", "", "", "", ],
            'bits': [8,8,8,8,8,8,8,8,8,],
            'components': [3, 4, 4, 4, 4, 4, 4, 4, 4, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "channel_number",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "data",
            'type': "byte",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        200: {
        'num': "200",
        'name': "exd_screen_configuration",
        'messages_key': "exd_screen_configuration_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "screen_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # number of fields in screen
            'name': "field_count",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "layout",
            'type': "exd_layout",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "screen_enabled",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        201: {
        'num': "201",
        'name': "exd_data_field_configuration",
        'messages_key': "exd_data_field_configuration_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "screen_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "concept_field",
            'type': "byte",
            'array': "false",
            'scale': [1, 1, ],
            'offset': [0, 0, ],
            'units': ["", "", ],
            'bits': [4,4,],
            'components': [2, 3, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "field_id",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "concept_count",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "display_type",
            'type': "exd_display_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "title",
            'type': "string",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        202: {
        'num': "202",
        'name': "exd_data_concept_configuration",
        'messages_key': "exd_data_concept_configuration_mesgs",
        'fields': {
        0: {
            'num': 0,
            'name': "screen_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "concept_field",
            'type': "byte",
            'array': "false",
            'scale': [1, 1, ],
            'offset': [0, 0, ],
            'units': ["", "", ],
            'bits': [4,4,],
            'components': [2, 3, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "field_id",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "concept_index",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "data_page",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "concept_key",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "scaling",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "data_units",
            'type': "exd_data_units",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "qualifier",
            'type': "exd_qualifiers",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "descriptor",
            'type': "exd_descriptors",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "is_signed",
            'type': "bool",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        268: {
        'num': "268",
        'name': "dive_summary",
        'messages_key': "dive_summary_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "reference_mesg",
            'type': "mesg_num",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "reference_index",
            'type': "message_index",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # 0 if above water
            'name': "avg_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # 0 if above water
            'name': "max_depth",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Time since end of last dive
            'name': "surface_interval",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "start_cns",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "end_cns",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7,
            'name': "start_n2",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8,
            'name': "end_n2",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "percent",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9,
            'name': "o2_toxicity",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "OTUs",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10,
            'name': "dive_number",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11,
            'name': "bottom_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        12: {
            'num': 12, # Average pressure-based surface air consumption
            'name': "avg_pressure_sac",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "bar/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        13: {
            'num': 13, # Average volumetric surface air consumption
            'name': "avg_volume_sac",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "L/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14, # Average respiratory minute volume
            'name': "avg_rmv",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "L/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15, # Time to reach deepest level stop
            'name': "descent_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        16: {
            'num': 16, # Time after leaving bottom until reaching surface
            'name': "ascent_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        17: {
            'num': 17, # Average ascent rate, not including descents or stops
            'name': "avg_ascent_rate",
            'type': "sint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        22: {
            'num': 22, # Average descent rate, not including ascents or stops
            'name': "avg_descent_rate",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        23: {
            'num': 23, # Maximum ascent rate
            'name': "max_ascent_rate",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        24: {
            'num': 24, # Maximum descent rate
            'name': "max_descent_rate",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        25: {
            'num': 25, # Time spent neither ascending nor descending
            'name': "hang_time",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        289: {
        'num': "289", # Number of acclerometer zero crossings summed over the specified time interval
        'name': "aad_accel_features",
        'messages_key': "aad_accel_features_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Time interval length in seconds
            'name': "time",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Total accelerometer energy in the interval
            'name': "energy_total",
            'type': "uint32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Count of zero crossings
            'name': "zero_cross_cnt",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Instance ID of zero crossing algorithm
            'name': "instance",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Total accelerometer time above threshold in the interval
            'name': "time_above_threshold",
            'type': "uint16",
            'array': "false",
            'scale': [25],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        78: {
        'num': "78", # Heart rate variability
        'name': "hrv",
        'messages_key': "hrv_mesgs",
        'fields': {
        0: {
            'num': 0, # Time between beats
            'name': "time",
            'type': "uint16",
            'array': "true",
            'scale': [1000],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        290: {
        'num': "290", # Array of heart beat intervals
        'name': "beat_intervals",
        'messages_key': "beat_intervals_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Milliseconds past date_time
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Array of millisecond times between beats
            'name': "time",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        370: {
        'num': "370",
        'name': "hrv_status_summary",
        'messages_key': "hrv_status_summary_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # 7 day RMSSD average over sleep
            'name': "weekly_average",
            'type': "uint16",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Last night RMSSD average over sleep
            'name': "last_night_average",
            'type': "uint16",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # 5 minute high RMSSD value over sleep
            'name': "last_night_5_min_high",
            'type': "uint16",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # 3 week baseline, upper boundary of low HRV status
            'name': "baseline_low_upper",
            'type': "uint16",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # 3 week baseline, lower boundary of balanced HRV status
            'name': "baseline_balanced_lower",
            'type': "uint16",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # 3 week baseline, upper boundary of balanced HRV status
            'name': "baseline_balanced_upper",
            'type': "uint16",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "status",
            'type': "hrv_status",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        371: {
        'num': "371",
        'name': "hrv_value",
        'messages_key': "hrv_value_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # 5 minute RMSSD
            'name': "value",
            'type': "uint16",
            'array': "false",
            'scale': [128],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        372: {
        'num': "372", # Raw Beat-to-Beat Interval values
        'name': "raw_bbi",
        'messages_key': "raw_bbi_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Millisecond resolution of the timestamp
            'name': "timestamp_ms",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # 1 bit for gap indicator, 1 bit for quality indicator, and 14 bits for Beat-to-Beat interval values in whole-integer millisecond resolution
            'name': "data",
            'type': "uint16",
            'array': "true",
            'scale': [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, ],
            'offset': [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ],
            'units': ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ],
            'bits': [14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,14,1,1,],
            'components': [2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, ],
            'is_accumulated': False,
            'has_components': True,
			'sub_fields': []
            },
        2: {
            'num': 2, # Array of millisecond times between beats
            'name': "time",
            'type': "uint16",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "ms",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # 1 = high confidence. 0 = low confidence. N/A when gap = 1
            'name': "quality",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # 1 = gap (time represents ms gap length). 0 = BBI data
            'name': "gap",
            'type': "uint8",
            'array': "true",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        297: {
        'num': "297",
        'name': "respiration_rate",
        'messages_key': "respiration_rate_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0, # Breaths * 100 /min, -300 indicates invalid, -200 indicates large motion, -100 indicates off wrist
            'name': "respiration_rate",
            'type': "sint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "breaths/min",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        387: {
        'num': "387", # Specifically used for XERO products.
        'name': "chrono_shot_session",
        'messages_key': "chrono_shot_session_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "min_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "max_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "avg_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "shot_count",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4,
            'name': "projectile_type",
            'type': "projectile_type",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5,
            'name': "grain_weight",
            'type': "uint32",
            'array': "false",
            'scale': [10],
            'offset': [0],
            'units': "gr",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6,
            'name': "standard_deviation",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        388: {
        'num': "388", # Specifically used for XERO products.
        'name': "chrono_shot_data",
        'messages_key': "chrono_shot_data_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "shot_speed",
            'type': "uint32",
            'array': "false",
            'scale': [1000],
            'offset': [0],
            'units': "m/s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "shot_num",
            'type': "uint16",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        319: {
        'num': "319",
        'name': "tank_update",
        'messages_key': "tank_update_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "sensor",
            'type': "ant_channel_id",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "pressure",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "bar",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        323: {
        'num': "323",
        'name': "tank_summary",
        'messages_key': "tank_summary_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "s",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "sensor",
            'type': "ant_channel_id",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1,
            'name': "start_pressure",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "bar",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2,
            'name': "end_pressure",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "bar",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3,
            'name': "volume_used",
            'type': "uint32",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "L",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        346: {
        'num': "346",
        'name': "sleep_assessment",
        'messages_key': "sleep_assessment_mesgs",
        'fields': {
        0: {
            'num': 0, # Average of awake_time_score and awakenings_count_score. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "combined_awake_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # Score that evaluates the total time spent awake between sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "awake_time_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # Score that evaluates the number of awakenings that interrupt sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "awakenings_count_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        3: {
            'num': 3, # Score that evaluates the amount of deep sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "deep_sleep_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Score that evaluates the quality of sleep based on sleep stages, heart-rate variability and possible awakenings during the night. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "sleep_duration_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        5: {
            'num': 5, # Score that evaluates the amount of light sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "light_sleep_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        6: {
            'num': 6, # Total score that summarizes the overall quality of sleep, combining sleep duration and quality. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "overall_sleep_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        7: {
            'num': 7, # Score that evaluates the quality of sleep based on sleep stages, heart-rate variability and possible awakenings during the night. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "sleep_quality_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        8: {
            'num': 8, # Score that evaluates stress and recovery during sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "sleep_recovery_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        9: {
            'num': 9, # Score that evaluates the amount of REM sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "rem_sleep_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        10: {
            'num': 10, # Score that evaluates the amount of restlessness during sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "sleep_restlessness_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        11: {
            'num': 11, # The number of awakenings during sleep.
            'name': "awakenings_count",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        14: {
            'num': 14, # Score that evaluates the sleep interruptions. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
            'name': "interruptions_score",
            'type': "uint8",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        15: {
            'num': 15, # Excludes stress during awake periods in the sleep window
            'name': "average_stress_during_sleep",
            'type': "uint16",
            'array': "false",
            'scale': [100],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        398: {
        'num': "398",
        'name': "skin_temp_overnight",
        'messages_key': "skin_temp_overnight_mesgs",
        'fields': {
        253: {
            'num': 253,
            'name': "timestamp",
            'type': "date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        0: {
            'num': 0,
            'name': "local_timestamp",
            'type': "local_date_time",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        1: {
            'num': 1, # The average overnight deviation from baseline temperature in degrees C
            'name': "average_deviation",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        2: {
            'num': 2, # The average 7 day overnight deviation from baseline temperature in degrees C
            'name': "average_7_day_deviation",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
        4: {
            'num': 4, # Final overnight temperature value
            'name': "nightly_value",
            'type': "float32",
            'array': "false",
            'scale': [1],
            'offset': [0],
            'units': "",
            'bits': [],
            'components': [],
            'is_accumulated': False,
            'has_components': False,
			'sub_fields': []
            },
    },
},
        105: {
        'num': "105",
        'name': "pad",
        'messages_key': "pad_mesgs",
        'fields': {
    },
},
},
'types': {
    'file': {
        '1': 'device', # Read only, single file. Must be in root directory.
        '2': 'settings', # Read/write, single file. Directory=Settings
        '3': 'sport', # Read/write, multiple files, file number = sport type. Directory=Sports
        '4': 'activity', # Read/erase, multiple files. Directory=Activities
        '5': 'workout', # Read/write/erase, multiple files. Directory=Workouts
        '6': 'course', # Read/write/erase, multiple files. Directory=Courses
        '7': 'schedules', # Read/write, single file. Directory=Schedules
        '9': 'weight', # Read only, single file. Circular buffer. All message definitions at start of file. Directory=Weight
        '10': 'totals', # Read only, single file. Directory=Totals
        '11': 'goals', # Read/write, single file. Directory=Goals
        '14': 'blood_pressure', # Read only. Directory=Blood Pressure
        '15': 'monitoring_a', # Read only. Directory=Monitoring. File number=sub type.
        '20': 'activity_summary', # Read/erase, multiple files. Directory=Activities
        '28': 'monitoring_daily',
        '32': 'monitoring_b', # Read only. Directory=Monitoring. File number=identifier
        '34': 'segment', # Read/write/erase. Multiple Files. Directory=Segments
        '35': 'segment_list', # Read/write/erase. Single File. Directory=Segments
        '40': 'exd_configuration', # Read/write/erase. Single File. Directory=Settings
        '0xF7': 'mfg_range_min', # 0xF7 - 0xFE reserved for manufacturer specific file types
        '0xFE': 'mfg_range_max', # 0xF7 - 0xFE reserved for manufacturer specific file types
        },
    'mesg_num': {
        '0': 'file_id',
        '1': 'capabilities',
        '2': 'device_settings',
        '3': 'user_profile',
        '4': 'hrm_profile',
        '5': 'sdm_profile',
        '6': 'bike_profile',
        '7': 'zones_target',
        '8': 'hr_zone',
        '9': 'power_zone',
        '10': 'met_zone',
        '12': 'sport',
        '15': 'goal',
        '18': 'session',
        '19': 'lap',
        '20': 'record',
        '21': 'event',
        '23': 'device_info',
        '26': 'workout',
        '27': 'workout_step',
        '28': 'schedule',
        '30': 'weight_scale',
        '31': 'course',
        '32': 'course_point',
        '33': 'totals',
        '34': 'activity',
        '35': 'software',
        '37': 'file_capabilities',
        '38': 'mesg_capabilities',
        '39': 'field_capabilities',
        '49': 'file_creator',
        '51': 'blood_pressure',
        '53': 'speed_zone',
        '55': 'monitoring',
        '72': 'training_file',
        '78': 'hrv',
        '80': 'ant_rx',
        '81': 'ant_tx',
        '82': 'ant_channel_id',
        '101': 'length',
        '103': 'monitoring_info',
        '105': 'pad',
        '106': 'slave_device',
        '127': 'connectivity',
        '128': 'weather_conditions',
        '129': 'weather_alert',
        '131': 'cadence_zone',
        '132': 'hr',
        '142': 'segment_lap',
        '145': 'memo_glob',
        '148': 'segment_id',
        '149': 'segment_leaderboard_entry',
        '150': 'segment_point',
        '151': 'segment_file',
        '158': 'workout_session',
        '159': 'watchface_settings',
        '160': 'gps_metadata',
        '161': 'camera_event',
        '162': 'timestamp_correlation',
        '164': 'gyroscope_data',
        '165': 'accelerometer_data',
        '167': 'three_d_sensor_calibration',
        '169': 'video_frame',
        '174': 'obdii_data',
        '177': 'nmea_sentence',
        '178': 'aviation_attitude',
        '184': 'video',
        '185': 'video_title',
        '186': 'video_description',
        '187': 'video_clip',
        '188': 'ohr_settings',
        '200': 'exd_screen_configuration',
        '201': 'exd_data_field_configuration',
        '202': 'exd_data_concept_configuration',
        '206': 'field_description',
        '207': 'developer_data_id',
        '208': 'magnetometer_data',
        '209': 'barometer_data',
        '210': 'one_d_sensor_calibration',
        '211': 'monitoring_hr_data',
        '216': 'time_in_zone',
        '225': 'set',
        '227': 'stress_level',
        '229': 'max_met_data',
        '258': 'dive_settings',
        '259': 'dive_gas',
        '262': 'dive_alarm',
        '264': 'exercise_title',
        '268': 'dive_summary',
        '269': 'spo2_data',
        '275': 'sleep_level',
        '285': 'jump',
        '289': 'aad_accel_features',
        '290': 'beat_intervals',
        '297': 'respiration_rate',
        '302': 'hsa_accelerometer_data',
        '304': 'hsa_step_data',
        '305': 'hsa_spo2_data',
        '306': 'hsa_stress_data',
        '307': 'hsa_respiration_data',
        '308': 'hsa_heart_rate_data',
        '312': 'split',
        '313': 'split_summary',
        '314': 'hsa_body_battery_data',
        '315': 'hsa_event',
        '317': 'climb_pro',
        '319': 'tank_update',
        '323': 'tank_summary',
        '346': 'sleep_assessment',
        '370': 'hrv_status_summary',
        '371': 'hrv_value',
        '372': 'raw_bbi',
        '375': 'device_aux_battery_info',
        '376': 'hsa_gyroscope_data',
        '387': 'chrono_shot_session',
        '388': 'chrono_shot_data',
        '389': 'hsa_configuration_data',
        '393': 'dive_apnea_alarm',
        '398': 'skin_temp_overnight',
        '409': 'hsa_wrist_temperature_data', # Message number for the HSA wrist temperature data message
        '0xFF00': 'mfg_range_min', # 0xFF00 - 0xFFFE reserved for manufacturer specific messages
        '0xFFFE': 'mfg_range_max', # 0xFF00 - 0xFFFE reserved for manufacturer specific messages
        },
    'checksum': {
        '0': 'clear', # Allows clear of checksum for flash memory where can only write 1 to 0 without erasing sector.
        '1': 'ok', # Set to mark checksum as valid if computes to invalid values 0 or 0xFF. Checksum can also be set to ok to save encoding computation time.
        },
    'file_flags': {
        '0x02': 'read',
        '0x04': 'write',
        '0x08': 'erase',
        },
    'mesg_count': {
        '0': 'num_per_file',
        '1': 'max_per_file',
        '2': 'max_per_file_type',
        },
    'date_time': {
        '0x10000000': 'min', # if date_time is < 0x10000000 then it is system time (seconds from device power on)
        },
    'local_date_time': {
        '0x10000000': 'min', # if date_time is < 0x10000000 then it is system time (seconds from device power on)
        },
    'message_index': {
        '0x8000': 'selected', # message is selected if set
        '0x7000': 'reserved', # reserved (default 0)
        '0x0FFF': 'mask', # index
        },
    'device_index': {
        '0': 'creator', # Creator of the file is always device index 0.
        },
    'gender': {
        '0': 'female',
        '1': 'male',
        },
    'language': {
        '0': 'english',
        '1': 'french',
        '2': 'italian',
        '3': 'german',
        '4': 'spanish',
        '5': 'croatian',
        '6': 'czech',
        '7': 'danish',
        '8': 'dutch',
        '9': 'finnish',
        '10': 'greek',
        '11': 'hungarian',
        '12': 'norwegian',
        '13': 'polish',
        '14': 'portuguese',
        '15': 'slovakian',
        '16': 'slovenian',
        '17': 'swedish',
        '18': 'russian',
        '19': 'turkish',
        '20': 'latvian',
        '21': 'ukrainian',
        '22': 'arabic',
        '23': 'farsi',
        '24': 'bulgarian',
        '25': 'romanian',
        '26': 'chinese',
        '27': 'japanese',
        '28': 'korean',
        '29': 'taiwanese',
        '30': 'thai',
        '31': 'hebrew',
        '32': 'brazilian_portuguese',
        '33': 'indonesian',
        '34': 'malaysian',
        '35': 'vietnamese',
        '36': 'burmese',
        '37': 'mongolian',
        '254': 'custom',
        },
    'language_bits_0': {
        '0x01': 'english',
        '0x02': 'french',
        '0x04': 'italian',
        '0x08': 'german',
        '0x10': 'spanish',
        '0x20': 'croatian',
        '0x40': 'czech',
        '0x80': 'danish',
        },
    'language_bits_1': {
        '0x01': 'dutch',
        '0x02': 'finnish',
        '0x04': 'greek',
        '0x08': 'hungarian',
        '0x10': 'norwegian',
        '0x20': 'polish',
        '0x40': 'portuguese',
        '0x80': 'slovakian',
        },
    'language_bits_2': {
        '0x01': 'slovenian',
        '0x02': 'swedish',
        '0x04': 'russian',
        '0x08': 'turkish',
        '0x10': 'latvian',
        '0x20': 'ukrainian',
        '0x40': 'arabic',
        '0x80': 'farsi',
        },
    'language_bits_3': {
        '0x01': 'bulgarian',
        '0x02': 'romanian',
        '0x04': 'chinese',
        '0x08': 'japanese',
        '0x10': 'korean',
        '0x20': 'taiwanese',
        '0x40': 'thai',
        '0x80': 'hebrew',
        },
    'language_bits_4': {
        '0x01': 'brazilian_portuguese',
        '0x02': 'indonesian',
        '0x04': 'malaysian',
        '0x08': 'vietnamese',
        '0x10': 'burmese',
        '0x20': 'mongolian',
        },
    'time_zone': {
        '0': 'almaty',
        '1': 'bangkok',
        '2': 'bombay',
        '3': 'brasilia',
        '4': 'cairo',
        '5': 'cape_verde_is',
        '6': 'darwin',
        '7': 'eniwetok',
        '8': 'fiji',
        '9': 'hong_kong',
        '10': 'islamabad',
        '11': 'kabul',
        '12': 'magadan',
        '13': 'mid_atlantic',
        '14': 'moscow',
        '15': 'muscat',
        '16': 'newfoundland',
        '17': 'samoa',
        '18': 'sydney',
        '19': 'tehran',
        '20': 'tokyo',
        '21': 'us_alaska',
        '22': 'us_atlantic',
        '23': 'us_central',
        '24': 'us_eastern',
        '25': 'us_hawaii',
        '26': 'us_mountain',
        '27': 'us_pacific',
        '28': 'other',
        '29': 'auckland',
        '30': 'kathmandu',
        '31': 'europe_western_wet',
        '32': 'europe_central_cet',
        '33': 'europe_eastern_eet',
        '34': 'jakarta',
        '35': 'perth',
        '36': 'adelaide',
        '37': 'brisbane',
        '38': 'tasmania',
        '39': 'iceland',
        '40': 'amsterdam',
        '41': 'athens',
        '42': 'barcelona',
        '43': 'berlin',
        '44': 'brussels',
        '45': 'budapest',
        '46': 'copenhagen',
        '47': 'dublin',
        '48': 'helsinki',
        '49': 'lisbon',
        '50': 'london',
        '51': 'madrid',
        '52': 'munich',
        '53': 'oslo',
        '54': 'paris',
        '55': 'prague',
        '56': 'reykjavik',
        '57': 'rome',
        '58': 'stockholm',
        '59': 'vienna',
        '60': 'warsaw',
        '61': 'zurich',
        '62': 'quebec',
        '63': 'ontario',
        '64': 'manitoba',
        '65': 'saskatchewan',
        '66': 'alberta',
        '67': 'british_columbia',
        '68': 'boise',
        '69': 'boston',
        '70': 'chicago',
        '71': 'dallas',
        '72': 'denver',
        '73': 'kansas_city',
        '74': 'las_vegas',
        '75': 'los_angeles',
        '76': 'miami',
        '77': 'minneapolis',
        '78': 'new_york',
        '79': 'new_orleans',
        '80': 'phoenix',
        '81': 'santa_fe',
        '82': 'seattle',
        '83': 'washington_dc',
        '84': 'us_arizona',
        '85': 'chita',
        '86': 'ekaterinburg',
        '87': 'irkutsk',
        '88': 'kaliningrad',
        '89': 'krasnoyarsk',
        '90': 'novosibirsk',
        '91': 'petropavlovsk_kamchatskiy',
        '92': 'samara',
        '93': 'vladivostok',
        '94': 'mexico_central',
        '95': 'mexico_mountain',
        '96': 'mexico_pacific',
        '97': 'cape_town',
        '98': 'winkhoek',
        '99': 'lagos',
        '100': 'riyahd',
        '101': 'venezuela',
        '102': 'australia_lh',
        '103': 'santiago',
        '253': 'manual',
        '254': 'automatic',
        },
    'display_measure': {
        '0': 'metric',
        '1': 'statute',
        '2': 'nautical',
        },
    'display_heart': {
        '0': 'bpm',
        '1': 'max',
        '2': 'reserve',
        },
    'display_power': {
        '0': 'watts',
        '1': 'percent_ftp',
        },
    'display_position': {
        '0': 'degree', # dd.dddddd
        '1': 'degree_minute', # dddmm.mmm
        '2': 'degree_minute_second', # dddmmss
        '3': 'austrian_grid', # Austrian Grid (BMN)
        '4': 'british_grid', # British National Grid
        '5': 'dutch_grid', # Dutch grid system
        '6': 'hungarian_grid', # Hungarian grid system
        '7': 'finnish_grid', # Finnish grid system Zone3 KKJ27
        '8': 'german_grid', # Gausss Krueger (German)
        '9': 'icelandic_grid', # Icelandic Grid
        '10': 'indonesian_equatorial', # Indonesian Equatorial LCO
        '11': 'indonesian_irian', # Indonesian Irian LCO
        '12': 'indonesian_southern', # Indonesian Southern LCO
        '13': 'india_zone_0', # India zone 0
        '14': 'india_zone_IA', # India zone IA
        '15': 'india_zone_IB', # India zone IB
        '16': 'india_zone_IIA', # India zone IIA
        '17': 'india_zone_IIB', # India zone IIB
        '18': 'india_zone_IIIA', # India zone IIIA
        '19': 'india_zone_IIIB', # India zone IIIB
        '20': 'india_zone_IVA', # India zone IVA
        '21': 'india_zone_IVB', # India zone IVB
        '22': 'irish_transverse', # Irish Transverse Mercator
        '23': 'irish_grid', # Irish Grid
        '24': 'loran', # Loran TD
        '25': 'maidenhead_grid', # Maidenhead grid system
        '26': 'mgrs_grid', # MGRS grid system
        '27': 'new_zealand_grid', # New Zealand grid system
        '28': 'new_zealand_transverse', # New Zealand Transverse Mercator
        '29': 'qatar_grid', # Qatar National Grid
        '30': 'modified_swedish_grid', # Modified RT-90 (Sweden)
        '31': 'swedish_grid', # RT-90 (Sweden)
        '32': 'south_african_grid', # South African Grid
        '33': 'swiss_grid', # Swiss CH-1903 grid
        '34': 'taiwan_grid', # Taiwan Grid
        '35': 'united_states_grid', # United States National Grid
        '36': 'utm_ups_grid', # UTM/UPS grid system
        '37': 'west_malayan', # West Malayan RSO
        '38': 'borneo_rso', # Borneo RSO
        '39': 'estonian_grid', # Estonian grid system
        '40': 'latvian_grid', # Latvian Transverse Mercator
        '41': 'swedish_ref_99_grid', # Reference Grid 99 TM (Swedish)
        },
    'switch': {
        '0': 'off',
        '1': 'on',
        '2': 'auto',
        },
    'sport': {
        '0': 'generic',
        '1': 'running',
        '2': 'cycling',
        '3': 'transition', # Mulitsport transition
        '4': 'fitness_equipment',
        '5': 'swimming',
        '6': 'basketball',
        '7': 'soccer',
        '8': 'tennis',
        '9': 'american_football',
        '10': 'training',
        '11': 'walking',
        '12': 'cross_country_skiing',
        '13': 'alpine_skiing',
        '14': 'snowboarding',
        '15': 'rowing',
        '16': 'mountaineering',
        '17': 'hiking',
        '18': 'multisport',
        '19': 'paddling',
        '20': 'flying',
        '21': 'e_biking',
        '22': 'motorcycling',
        '23': 'boating',
        '24': 'driving',
        '25': 'golf',
        '26': 'hang_gliding',
        '27': 'horseback_riding',
        '28': 'hunting',
        '29': 'fishing',
        '30': 'inline_skating',
        '31': 'rock_climbing',
        '32': 'sailing',
        '33': 'ice_skating',
        '34': 'sky_diving',
        '35': 'snowshoeing',
        '36': 'snowmobiling',
        '37': 'stand_up_paddleboarding',
        '38': 'surfing',
        '39': 'wakeboarding',
        '40': 'water_skiing',
        '41': 'kayaking',
        '42': 'rafting',
        '43': 'windsurfing',
        '44': 'kitesurfing',
        '45': 'tactical',
        '46': 'jumpmaster',
        '47': 'boxing',
        '48': 'floor_climbing',
        '49': 'baseball',
        '53': 'diving',
        '62': 'hiit',
        '64': 'racket',
        '65': 'wheelchair_push_walk',
        '66': 'wheelchair_push_run',
        '67': 'meditation',
        '69': 'disc_golf',
        '71': 'cricket',
        '72': 'rugby',
        '73': 'hockey',
        '74': 'lacrosse',
        '75': 'volleyball',
        '76': 'water_tubing',
        '77': 'wakesurfing',
        '80': 'mixed_martial_arts',
        '82': 'snorkeling',
        '83': 'dance',
        '84': 'jump_rope',
        '254': 'all', # All is for goals only to include all sports.
        },
    'sport_bits_0': {
        '0x01': 'generic',
        '0x02': 'running',
        '0x04': 'cycling',
        '0x08': 'transition', # Mulitsport transition
        '0x10': 'fitness_equipment',
        '0x20': 'swimming',
        '0x40': 'basketball',
        '0x80': 'soccer',
        },
    'sport_bits_1': {
        '0x01': 'tennis',
        '0x02': 'american_football',
        '0x04': 'training',
        '0x08': 'walking',
        '0x10': 'cross_country_skiing',
        '0x20': 'alpine_skiing',
        '0x40': 'snowboarding',
        '0x80': 'rowing',
        },
    'sport_bits_2': {
        '0x01': 'mountaineering',
        '0x02': 'hiking',
        '0x04': 'multisport',
        '0x08': 'paddling',
        '0x10': 'flying',
        '0x20': 'e_biking',
        '0x40': 'motorcycling',
        '0x80': 'boating',
        },
    'sport_bits_3': {
        '0x01': 'driving',
        '0x02': 'golf',
        '0x04': 'hang_gliding',
        '0x08': 'horseback_riding',
        '0x10': 'hunting',
        '0x20': 'fishing',
        '0x40': 'inline_skating',
        '0x80': 'rock_climbing',
        },
    'sport_bits_4': {
        '0x01': 'sailing',
        '0x02': 'ice_skating',
        '0x04': 'sky_diving',
        '0x08': 'snowshoeing',
        '0x10': 'snowmobiling',
        '0x20': 'stand_up_paddleboarding',
        '0x40': 'surfing',
        '0x80': 'wakeboarding',
        },
    'sport_bits_5': {
        '0x01': 'water_skiing',
        '0x02': 'kayaking',
        '0x04': 'rafting',
        '0x08': 'windsurfing',
        '0x10': 'kitesurfing',
        '0x20': 'tactical',
        '0x40': 'jumpmaster',
        '0x80': 'boxing',
        },
    'sport_bits_6': {
        '0x01': 'floor_climbing',
        },
    'sub_sport': {
        '0': 'generic',
        '1': 'treadmill', # Run/Fitness Equipment
        '2': 'street', # Run
        '3': 'trail', # Run
        '4': 'track', # Run
        '5': 'spin', # Cycling
        '6': 'indoor_cycling', # Cycling/Fitness Equipment
        '7': 'road', # Cycling
        '8': 'mountain', # Cycling
        '9': 'downhill', # Cycling
        '10': 'recumbent', # Cycling
        '11': 'cyclocross', # Cycling
        '12': 'hand_cycling', # Cycling
        '13': 'track_cycling', # Cycling
        '14': 'indoor_rowing', # Fitness Equipment
        '15': 'elliptical', # Fitness Equipment
        '16': 'stair_climbing', # Fitness Equipment
        '17': 'lap_swimming', # Swimming
        '18': 'open_water', # Swimming
        '19': 'flexibility_training', # Training
        '20': 'strength_training', # Training
        '21': 'warm_up', # Tennis
        '22': 'match', # Tennis
        '23': 'exercise', # Tennis
        '24': 'challenge',
        '25': 'indoor_skiing', # Fitness Equipment
        '26': 'cardio_training', # Training
        '27': 'indoor_walking', # Walking/Fitness Equipment
        '28': 'e_bike_fitness', # E-Biking
        '29': 'bmx', # Cycling
        '30': 'casual_walking', # Walking
        '31': 'speed_walking', # Walking
        '32': 'bike_to_run_transition', # Transition
        '33': 'run_to_bike_transition', # Transition
        '34': 'swim_to_bike_transition', # Transition
        '35': 'atv', # Motorcycling
        '36': 'motocross', # Motorcycling
        '37': 'backcountry', # Alpine Skiing/Snowboarding
        '38': 'resort', # Alpine Skiing/Snowboarding
        '39': 'rc_drone', # Flying
        '40': 'wingsuit', # Flying
        '41': 'whitewater', # Kayaking/Rafting
        '42': 'skate_skiing', # Cross Country Skiing
        '43': 'yoga', # Training
        '44': 'pilates', # Fitness Equipment
        '45': 'indoor_running', # Run
        '46': 'gravel_cycling', # Cycling
        '47': 'e_bike_mountain', # Cycling
        '48': 'commuting', # Cycling
        '49': 'mixed_surface', # Cycling
        '50': 'navigate',
        '51': 'track_me',
        '52': 'map',
        '53': 'single_gas_diving', # Diving
        '54': 'multi_gas_diving', # Diving
        '55': 'gauge_diving', # Diving
        '56': 'apnea_diving', # Diving
        '57': 'apnea_hunting', # Diving
        '58': 'virtual_activity',
        '59': 'obstacle', # Used for events where participants run, crawl through mud, climb over walls, etc.
        '62': 'breathing',
        '65': 'sail_race', # Sailing
        '67': 'ultra', # Ultramarathon
        '68': 'indoor_climbing', # Climbing
        '69': 'bouldering', # Climbing
        '70': 'hiit', # High Intensity Interval Training
        '73': 'amrap', # HIIT
        '74': 'emom', # HIIT
        '75': 'tabata', # HIIT
        '84': 'pickleball', # Racket
        '85': 'padel', # Racket
        '86': 'indoor_wheelchair_walk',
        '87': 'indoor_wheelchair_run',
        '88': 'indoor_hand_cycling',
        '94': 'squash',
        '95': 'badminton',
        '96': 'racquetball',
        '97': 'table_tennis',
        '110': 'fly_canopy', # Flying
        '111': 'fly_paraglide', # Flying
        '112': 'fly_paramotor', # Flying
        '113': 'fly_pressurized', # Flying
        '114': 'fly_navigate', # Flying
        '115': 'fly_timer', # Flying
        '116': 'fly_altimeter', # Flying
        '117': 'fly_wx', # Flying
        '118': 'fly_vfr', # Flying
        '119': 'fly_ifr', # Flying
        '254': 'all',
        },
    'sport_event': {
        '0': 'uncategorized',
        '1': 'geocaching',
        '2': 'fitness',
        '3': 'recreation',
        '4': 'race',
        '5': 'special_event',
        '6': 'training',
        '7': 'transportation',
        '8': 'touring',
        },
    'activity': {
        '0': 'manual',
        '1': 'auto_multi_sport',
        },
    'intensity': {
        '0': 'active',
        '1': 'rest',
        '2': 'warmup',
        '3': 'cooldown',
        '4': 'recovery',
        '5': 'interval',
        '6': 'other',
        },
    'session_trigger': {
        '0': 'activity_end',
        '1': 'manual', # User changed sport.
        '2': 'auto_multi_sport', # Auto multi-sport feature is enabled and user pressed lap button to advance session.
        '3': 'fitness_equipment', # Auto sport change caused by user linking to fitness equipment.
        },
    'autolap_trigger': {
        '0': 'time',
        '1': 'distance',
        '2': 'position_start',
        '3': 'position_lap',
        '4': 'position_waypoint',
        '5': 'position_marked',
        '6': 'off',
        '13': 'auto_select',
        },
    'lap_trigger': {
        '0': 'manual',
        '1': 'time',
        '2': 'distance',
        '3': 'position_start',
        '4': 'position_lap',
        '5': 'position_waypoint',
        '6': 'position_marked',
        '7': 'session_end',
        '8': 'fitness_equipment',
        },
    'time_mode': {
        '0': 'hour12',
        '1': 'hour24', # Does not use a leading zero and has a colon
        '2': 'military', # Uses a leading zero and does not have a colon
        '3': 'hour_12_with_seconds',
        '4': 'hour_24_with_seconds',
        '5': 'utc',
        },
    'backlight_mode': {
        '0': 'off',
        '1': 'manual',
        '2': 'key_and_messages',
        '3': 'auto_brightness',
        '4': 'smart_notifications',
        '5': 'key_and_messages_night',
        '6': 'key_and_messages_and_smart_notifications',
        },
    'date_mode': {
        '0': 'day_month',
        '1': 'month_day',
        },
    'backlight_timeout': {
        '0': 'infinite', # Backlight stays on forever.
        },
    'event': {
        '0': 'timer', # Group 0. Start / stop_all
        '3': 'workout', # start / stop
        '4': 'workout_step', # Start at beginning of workout. Stop at end of each step.
        '5': 'power_down', # stop_all group 0
        '6': 'power_up', # stop_all group 0
        '7': 'off_course', # start / stop group 0
        '8': 'session', # Stop at end of each session.
        '9': 'lap', # Stop at end of each lap.
        '10': 'course_point', # marker
        '11': 'battery', # marker
        '12': 'virtual_partner_pace', # Group 1. Start at beginning of activity if VP enabled, when VP pace is changed during activity or VP enabled mid activity. stop_disable when VP disabled.
        '13': 'hr_high_alert', # Group 0. Start / stop when in alert condition.
        '14': 'hr_low_alert', # Group 0. Start / stop when in alert condition.
        '15': 'speed_high_alert', # Group 0. Start / stop when in alert condition.
        '16': 'speed_low_alert', # Group 0. Start / stop when in alert condition.
        '17': 'cad_high_alert', # Group 0. Start / stop when in alert condition.
        '18': 'cad_low_alert', # Group 0. Start / stop when in alert condition.
        '19': 'power_high_alert', # Group 0. Start / stop when in alert condition.
        '20': 'power_low_alert', # Group 0. Start / stop when in alert condition.
        '21': 'recovery_hr', # marker
        '22': 'battery_low', # marker
        '23': 'time_duration_alert', # Group 1. Start if enabled mid activity (not required at start of activity). Stop when duration is reached. stop_disable if disabled.
        '24': 'distance_duration_alert', # Group 1. Start if enabled mid activity (not required at start of activity). Stop when duration is reached. stop_disable if disabled.
        '25': 'calorie_duration_alert', # Group 1. Start if enabled mid activity (not required at start of activity). Stop when duration is reached. stop_disable if disabled.
        '26': 'activity', # Group 1.. Stop at end of activity.
        '27': 'fitness_equipment', # marker
        '28': 'length', # Stop at end of each length.
        '32': 'user_marker', # marker
        '33': 'sport_point', # marker
        '36': 'calibration', # start/stop/marker
        '42': 'front_gear_change', # marker
        '43': 'rear_gear_change', # marker
        '44': 'rider_position_change', # marker
        '45': 'elev_high_alert', # Group 0. Start / stop when in alert condition.
        '46': 'elev_low_alert', # Group 0. Start / stop when in alert condition.
        '47': 'comm_timeout', # marker
        '54': 'auto_activity_detect', # marker
        '56': 'dive_alert', # marker
        '57': 'dive_gas_switched', # marker
        '71': 'tank_pressure_reserve', # marker
        '72': 'tank_pressure_critical', # marker
        '73': 'tank_lost', # marker
        '75': 'radar_threat_alert', # start/stop/marker
        '76': 'tank_battery_low', # marker
        '81': 'tank_pod_connected', # marker - tank pod has connected
        '82': 'tank_pod_disconnected', # marker - tank pod has lost connection
        },
    'event_type': {
        '0': 'start',
        '1': 'stop',
        '2': 'consecutive_depreciated',
        '3': 'marker',
        '4': 'stop_all',
        '5': 'begin_depreciated',
        '6': 'end_depreciated',
        '7': 'end_all_depreciated',
        '8': 'stop_disable',
        '9': 'stop_disable_all',
        },
    'timer_trigger': {
        '0': 'manual',
        '1': 'auto',
        '2': 'fitness_equipment',
        },
    'fitness_equipment_state': {
        '0': 'ready',
        '1': 'in_use',
        '2': 'paused',
        '3': 'unknown', # lost connection to fitness equipment
        },
    'tone': {
        '0': 'off',
        '1': 'tone',
        '2': 'vibrate',
        '3': 'tone_and_vibrate',
        },
    'autoscroll': {
        '0': 'none',
        '1': 'slow',
        '2': 'medium',
        '3': 'fast',
        },
    'activity_class': {
        '0x7F': 'level', # 0 to 100
        '100': 'level_max',
        '0x80': 'athlete',
        },
    'hr_zone_calc': {
        '0': 'custom',
        '1': 'percent_max_hr',
        '2': 'percent_hrr',
        '3': 'percent_lthr',
        },
    'pwr_zone_calc': {
        '0': 'custom',
        '1': 'percent_ftp',
        },
    'wkt_step_duration': {
        '0': 'time',
        '1': 'distance',
        '2': 'hr_less_than',
        '3': 'hr_greater_than',
        '4': 'calories',
        '5': 'open',
        '6': 'repeat_until_steps_cmplt',
        '7': 'repeat_until_time',
        '8': 'repeat_until_distance',
        '9': 'repeat_until_calories',
        '10': 'repeat_until_hr_less_than',
        '11': 'repeat_until_hr_greater_than',
        '12': 'repeat_until_power_less_than',
        '13': 'repeat_until_power_greater_than',
        '14': 'power_less_than',
        '15': 'power_greater_than',
        '16': 'training_peaks_tss',
        '17': 'repeat_until_power_last_lap_less_than',
        '18': 'repeat_until_max_power_last_lap_less_than',
        '19': 'power_3s_less_than',
        '20': 'power_10s_less_than',
        '21': 'power_30s_less_than',
        '22': 'power_3s_greater_than',
        '23': 'power_10s_greater_than',
        '24': 'power_30s_greater_than',
        '25': 'power_lap_less_than',
        '26': 'power_lap_greater_than',
        '27': 'repeat_until_training_peaks_tss',
        '28': 'repetition_time',
        '29': 'reps',
        '31': 'time_only',
        },
    'wkt_step_target': {
        '0': 'speed',
        '1': 'heart_rate',
        '2': 'open',
        '3': 'cadence',
        '4': 'power',
        '5': 'grade',
        '6': 'resistance',
        '7': 'power_3s',
        '8': 'power_10s',
        '9': 'power_30s',
        '10': 'power_lap',
        '11': 'swim_stroke',
        '12': 'speed_lap',
        '13': 'heart_rate_lap',
        },
    'goal': {
        '0': 'time',
        '1': 'distance',
        '2': 'calories',
        '3': 'frequency',
        '4': 'steps',
        '5': 'ascent',
        '6': 'active_minutes',
        },
    'goal_recurrence': {
        '0': 'off',
        '1': 'daily',
        '2': 'weekly',
        '3': 'monthly',
        '4': 'yearly',
        '5': 'custom',
        },
    'goal_source': {
        '0': 'auto', # Device generated
        '1': 'community', # Social network sourced goal
        '2': 'user', # Manually generated
        },
    'schedule': {
        '0': 'workout',
        '1': 'course',
        },
    'course_point': {
        '0': 'generic',
        '1': 'summit',
        '2': 'valley',
        '3': 'water',
        '4': 'food',
        '5': 'danger',
        '6': 'left',
        '7': 'right',
        '8': 'straight',
        '9': 'first_aid',
        '10': 'fourth_category',
        '11': 'third_category',
        '12': 'second_category',
        '13': 'first_category',
        '14': 'hors_category',
        '15': 'sprint',
        '16': 'left_fork',
        '17': 'right_fork',
        '18': 'middle_fork',
        '19': 'slight_left',
        '20': 'sharp_left',
        '21': 'slight_right',
        '22': 'sharp_right',
        '23': 'u_turn',
        '24': 'segment_start',
        '25': 'segment_end',
        '27': 'campsite',
        '28': 'aid_station',
        '29': 'rest_area',
        '30': 'general_distance', # Used with UpAhead
        '31': 'service',
        '32': 'energy_gel',
        '33': 'sports_drink',
        '34': 'mile_marker',
        '35': 'checkpoint',
        '36': 'shelter',
        '37': 'meeting_spot',
        '38': 'overlook',
        '39': 'toilet',
        '40': 'shower',
        '41': 'gear',
        '42': 'sharp_curve',
        '43': 'steep_incline',
        '44': 'tunnel',
        '45': 'bridge',
        '46': 'obstacle',
        '47': 'crossing',
        '48': 'store',
        '49': 'transition',
        '50': 'navaid',
        '51': 'transport',
        '52': 'alert',
        '53': 'info',
        },
    'manufacturer': {
        '1': 'garmin',
        '2': 'garmin_fr405_antfs', # Do not use. Used by FR405 for ANTFS man id.
        '3': 'zephyr',
        '4': 'dayton',
        '5': 'idt',
        '6': 'srm',
        '7': 'quarq',
        '8': 'ibike',
        '9': 'saris',
        '10': 'spark_hk',
        '11': 'tanita',
        '12': 'echowell',
        '13': 'dynastream_oem',
        '14': 'nautilus',
        '15': 'dynastream',
        '16': 'timex',
        '17': 'metrigear',
        '18': 'xelic',
        '19': 'beurer',
        '20': 'cardiosport',
        '21': 'a_and_d',
        '22': 'hmm',
        '23': 'suunto',
        '24': 'thita_elektronik',
        '25': 'gpulse',
        '26': 'clean_mobile',
        '27': 'pedal_brain',
        '28': 'peaksware',
        '29': 'saxonar',
        '30': 'lemond_fitness',
        '31': 'dexcom',
        '32': 'wahoo_fitness',
        '33': 'octane_fitness',
        '34': 'archinoetics',
        '35': 'the_hurt_box',
        '36': 'citizen_systems',
        '37': 'magellan',
        '38': 'osynce',
        '39': 'holux',
        '40': 'concept2',
        '41': 'shimano',
        '42': 'one_giant_leap',
        '43': 'ace_sensor',
        '44': 'brim_brothers',
        '45': 'xplova',
        '46': 'perception_digital',
        '47': 'bf1systems',
        '48': 'pioneer',
        '49': 'spantec',
        '50': 'metalogics',
        '51': '4iiiis',
        '52': 'seiko_epson',
        '53': 'seiko_epson_oem',
        '54': 'ifor_powell',
        '55': 'maxwell_guider',
        '56': 'star_trac',
        '57': 'breakaway',
        '58': 'alatech_technology_ltd',
        '59': 'mio_technology_europe',
        '60': 'rotor',
        '61': 'geonaute',
        '62': 'id_bike',
        '63': 'specialized',
        '64': 'wtek',
        '65': 'physical_enterprises',
        '66': 'north_pole_engineering',
        '67': 'bkool',
        '68': 'cateye',
        '69': 'stages_cycling',
        '70': 'sigmasport',
        '71': 'tomtom',
        '72': 'peripedal',
        '73': 'wattbike',
        '76': 'moxy',
        '77': 'ciclosport',
        '78': 'powerbahn',
        '79': 'acorn_projects_aps',
        '80': 'lifebeam',
        '81': 'bontrager',
        '82': 'wellgo',
        '83': 'scosche',
        '84': 'magura',
        '85': 'woodway',
        '86': 'elite',
        '87': 'nielsen_kellerman',
        '88': 'dk_city',
        '89': 'tacx',
        '90': 'direction_technology',
        '91': 'magtonic',
        '92': '1partcarbon',
        '93': 'inside_ride_technologies',
        '94': 'sound_of_motion',
        '95': 'stryd',
        '96': 'icg', # Indoorcycling Group
        '97': 'MiPulse',
        '98': 'bsx_athletics',
        '99': 'look',
        '100': 'campagnolo_srl',
        '101': 'body_bike_smart',
        '102': 'praxisworks',
        '103': 'limits_technology', # Limits Technology Ltd.
        '104': 'topaction_technology', # TopAction Technology Inc.
        '105': 'cosinuss',
        '106': 'fitcare',
        '107': 'magene',
        '108': 'giant_manufacturing_co',
        '109': 'tigrasport', # Tigrasport
        '110': 'salutron',
        '111': 'technogym',
        '112': 'bryton_sensors',
        '113': 'latitude_limited',
        '114': 'soaring_technology',
        '115': 'igpsport',
        '116': 'thinkrider',
        '117': 'gopher_sport',
        '118': 'waterrower',
        '119': 'orangetheory',
        '120': 'inpeak',
        '121': 'kinetic',
        '122': 'johnson_health_tech',
        '123': 'polar_electro',
        '124': 'seesense',
        '125': 'nci_technology',
        '126': 'iqsquare',
        '127': 'leomo',
        '128': 'ifit_com',
        '129': 'coros_byte',
        '130': 'versa_design',
        '131': 'chileaf',
        '132': 'cycplus',
        '133': 'gravaa_byte',
        '134': 'sigeyi',
        '135': 'coospo',
        '136': 'geoid',
        '137': 'bosch',
        '138': 'kyto',
        '139': 'kinetic_sports',
        '140': 'decathlon_byte',
        '141': 'tq_systems',
        '142': 'tag_heuer',
        '143': 'keiser_fitness',
        '144': 'zwift_byte',
        '145': 'porsche_ep',
        '146': 'blackbird',
        '147': 'meilan_byte',
        '148': 'ezon',
        '149': 'laisi',
        '150': 'myzone',
        '151': 'abawo',
        '152': 'bafang',
        '255': 'development',
        '257': 'healthandlife',
        '258': 'lezyne',
        '259': 'scribe_labs',
        '260': 'zwift',
        '261': 'watteam',
        '262': 'recon',
        '263': 'favero_electronics',
        '264': 'dynovelo',
        '265': 'strava',
        '266': 'precor', # Amer Sports
        '267': 'bryton',
        '268': 'sram',
        '269': 'navman', # MiTAC Global Corporation (Mio Technology)
        '270': 'cobi', # COBI GmbH
        '271': 'spivi',
        '272': 'mio_magellan',
        '273': 'evesports',
        '274': 'sensitivus_gauge',
        '275': 'podoon',
        '276': 'life_time_fitness',
        '277': 'falco_e_motors', # Falco eMotors Inc.
        '278': 'minoura',
        '279': 'cycliq',
        '280': 'luxottica',
        '281': 'trainer_road',
        '282': 'the_sufferfest',
        '283': 'fullspeedahead',
        '284': 'virtualtraining',
        '285': 'feedbacksports',
        '286': 'omata',
        '287': 'vdo',
        '288': 'magneticdays',
        '289': 'hammerhead',
        '290': 'kinetic_by_kurt',
        '291': 'shapelog',
        '292': 'dabuziduo',
        '293': 'jetblack',
        '294': 'coros',
        '295': 'virtugo',
        '296': 'velosense',
        '297': 'cycligentinc',
        '298': 'trailforks',
        '299': 'mahle_ebikemotion',
        '300': 'nurvv',
        '301': 'microprogram',
        '302': 'zone5cloud',
        '303': 'greenteg',
        '304': 'yamaha_motors',
        '305': 'whoop',
        '306': 'gravaa',
        '307': 'onelap',
        '308': 'monark_exercise',
        '309': 'form',
        '310': 'decathlon',
        '311': 'syncros',
        '312': 'heatup',
        '313': 'cannondale',
        '314': 'true_fitness',
        '315': 'RGT_cycling',
        '316': 'vasa',
        '317': 'race_republic',
        '318': 'fazua',
        '319': 'oreka_training',
        '320': 'lsec', # Lishun Electric & Communication
        '321': 'lululemon_studio',
        '322': 'shanyue',
        '323': 'spinning_mda',
        '324': 'hilldating',
        '325': 'aero_sensor',
        '326': 'nike',
        '327': 'magicshine',
        '328': 'ictrainer',
        '329': 'absolute_cycling',
        '330': 'eo_swimbetter',
        '331': 'mywhoosh',
        '332': 'ravemen',
        '5759': 'actigraphcorp',
        },
    'garmin_product': {
        '1': 'hrm1',
        '2': 'axh01', # AXH01 HRM chipset
        '3': 'axb01',
        '4': 'axb02',
        '5': 'hrm2ss',
        '6': 'dsi_alf02',
        '7': 'hrm3ss',
        '8': 'hrm_run_single_byte_product_id', # hrm_run model for HRM ANT+ messaging
        '9': 'bsm', # BSM model for ANT+ messaging
        '10': 'bcm', # BCM model for ANT+ messaging
        '11': 'axs01', # AXS01 HRM Bike Chipset model for ANT+ messaging
        '12': 'hrm_tri_single_byte_product_id', # hrm_tri model for HRM ANT+ messaging
        '13': 'hrm4_run_single_byte_product_id', # hrm4 run model for HRM ANT+ messaging
        '14': 'fr225_single_byte_product_id', # fr225 model for HRM ANT+ messaging
        '15': 'gen3_bsm_single_byte_product_id', # gen3_bsm model for Bike Speed ANT+ messaging
        '16': 'gen3_bcm_single_byte_product_id', # gen3_bcm model for Bike Cadence ANT+ messaging
        '22': 'hrm_fit_single_byte_product_id',
        '255': 'OHR', # Garmin Wearable Optical Heart Rate Sensor for ANT+ HR Profile Broadcasting
        '473': 'fr301_china',
        '474': 'fr301_japan',
        '475': 'fr301_korea',
        '494': 'fr301_taiwan',
        '717': 'fr405', # Forerunner 405
        '782': 'fr50', # Forerunner 50
        '987': 'fr405_japan',
        '988': 'fr60', # Forerunner 60
        '1011': 'dsi_alf01',
        '1018': 'fr310xt', # Forerunner 310
        '1036': 'edge500',
        '1124': 'fr110', # Forerunner 110
        '1169': 'edge800',
        '1199': 'edge500_taiwan',
        '1213': 'edge500_japan',
        '1253': 'chirp',
        '1274': 'fr110_japan',
        '1325': 'edge200',
        '1328': 'fr910xt',
        '1333': 'edge800_taiwan',
        '1334': 'edge800_japan',
        '1341': 'alf04',
        '1345': 'fr610',
        '1360': 'fr210_japan',
        '1380': 'vector_ss',
        '1381': 'vector_cp',
        '1386': 'edge800_china',
        '1387': 'edge500_china',
        '1405': 'approach_g10',
        '1410': 'fr610_japan',
        '1422': 'edge500_korea',
        '1436': 'fr70',
        '1446': 'fr310xt_4t',
        '1461': 'amx',
        '1482': 'fr10',
        '1497': 'edge800_korea',
        '1499': 'swim',
        '1537': 'fr910xt_china',
        '1551': 'fenix',
        '1555': 'edge200_taiwan',
        '1561': 'edge510',
        '1567': 'edge810',
        '1570': 'tempe',
        '1600': 'fr910xt_japan',
        '1623': 'fr620',
        '1632': 'fr220',
        '1664': 'fr910xt_korea',
        '1688': 'fr10_japan',
        '1721': 'edge810_japan',
        '1735': 'virb_elite',
        '1736': 'edge_touring', # Also Edge Touring Plus
        '1742': 'edge510_japan',
        '1743': 'hrm_tri', # Also HRM-Swim
        '1752': 'hrm_run',
        '1765': 'fr920xt',
        '1821': 'edge510_asia',
        '1822': 'edge810_china',
        '1823': 'edge810_taiwan',
        '1836': 'edge1000',
        '1837': 'vivo_fit',
        '1853': 'virb_remote',
        '1885': 'vivo_ki',
        '1903': 'fr15',
        '1907': 'vivo_active',
        '1918': 'edge510_korea',
        '1928': 'fr620_japan',
        '1929': 'fr620_china',
        '1930': 'fr220_japan',
        '1931': 'fr220_china',
        '1936': 'approach_s6',
        '1956': 'vivo_smart',
        '1967': 'fenix2',
        '1988': 'epix',
        '2050': 'fenix3',
        '2052': 'edge1000_taiwan',
        '2053': 'edge1000_japan',
        '2061': 'fr15_japan',
        '2067': 'edge520',
        '2070': 'edge1000_china',
        '2072': 'fr620_russia',
        '2073': 'fr220_russia',
        '2079': 'vector_s',
        '2100': 'edge1000_korea',
        '2130': 'fr920xt_taiwan',
        '2131': 'fr920xt_china',
        '2132': 'fr920xt_japan',
        '2134': 'virbx',
        '2135': 'vivo_smart_apac',
        '2140': 'etrex_touch',
        '2147': 'edge25',
        '2148': 'fr25',
        '2150': 'vivo_fit2',
        '2153': 'fr225',
        '2156': 'fr630',
        '2157': 'fr230',
        '2158': 'fr735xt',
        '2160': 'vivo_active_apac',
        '2161': 'vector_2',
        '2162': 'vector_2s',
        '2172': 'virbxe',
        '2173': 'fr620_taiwan',
        '2174': 'fr220_taiwan',
        '2175': 'truswing',
        '2187': 'd2airvenu',
        '2188': 'fenix3_china',
        '2189': 'fenix3_twn',
        '2192': 'varia_headlight',
        '2193': 'varia_taillight_old',
        '2204': 'edge_explore_1000',
        '2219': 'fr225_asia',
        '2225': 'varia_radar_taillight',
        '2226': 'varia_radar_display',
        '2238': 'edge20',
        '2260': 'edge520_asia',
        '2261': 'edge520_japan',
        '2262': 'd2_bravo',
        '2266': 'approach_s20',
        '2271': 'vivo_smart2',
        '2274': 'edge1000_thai',
        '2276': 'varia_remote',
        '2288': 'edge25_asia',
        '2289': 'edge25_jpn',
        '2290': 'edge20_asia',
        '2292': 'approach_x40',
        '2293': 'fenix3_japan',
        '2294': 'vivo_smart_emea',
        '2310': 'fr630_asia',
        '2311': 'fr630_jpn',
        '2313': 'fr230_jpn',
        '2327': 'hrm4_run',
        '2332': 'epix_japan',
        '2337': 'vivo_active_hr',
        '2347': 'vivo_smart_gps_hr',
        '2348': 'vivo_smart_hr',
        '2361': 'vivo_smart_hr_asia',
        '2362': 'vivo_smart_gps_hr_asia',
        '2368': 'vivo_move',
        '2379': 'varia_taillight',
        '2396': 'fr235_asia',
        '2397': 'fr235_japan',
        '2398': 'varia_vision',
        '2406': 'vivo_fit3',
        '2407': 'fenix3_korea',
        '2408': 'fenix3_sea',
        '2413': 'fenix3_hr',
        '2417': 'virb_ultra_30',
        '2429': 'index_smart_scale',
        '2431': 'fr235',
        '2432': 'fenix3_chronos',
        '2441': 'oregon7xx',
        '2444': 'rino7xx',
        '2457': 'epix_korea',
        '2473': 'fenix3_hr_chn',
        '2474': 'fenix3_hr_twn',
        '2475': 'fenix3_hr_jpn',
        '2476': 'fenix3_hr_sea',
        '2477': 'fenix3_hr_kor',
        '2496': 'nautix',
        '2497': 'vivo_active_hr_apac',
        '2503': 'fr35',
        '2512': 'oregon7xx_ww',
        '2530': 'edge_820',
        '2531': 'edge_explore_820',
        '2533': 'fr735xt_apac',
        '2534': 'fr735xt_japan',
        '2544': 'fenix5s',
        '2547': 'd2_bravo_titanium',
        '2567': 'varia_ut800', # Varia UT 800 SW
        '2593': 'running_dynamics_pod',
        '2599': 'edge_820_china',
        '2600': 'edge_820_japan',
        '2604': 'fenix5x',
        '2606': 'vivo_fit_jr',
        '2622': 'vivo_smart3',
        '2623': 'vivo_sport',
        '2628': 'edge_820_taiwan',
        '2629': 'edge_820_korea',
        '2630': 'edge_820_sea',
        '2650': 'fr35_hebrew',
        '2656': 'approach_s60',
        '2667': 'fr35_apac',
        '2668': 'fr35_japan',
        '2675': 'fenix3_chronos_asia',
        '2687': 'virb_360',
        '2691': 'fr935',
        '2697': 'fenix5',
        '2700': 'vivoactive3',
        '2733': 'fr235_china_nfc',
        '2769': 'foretrex_601_701',
        '2772': 'vivo_move_hr',
        '2713': 'edge_1030',
        '2727': 'fr35_sea',
        '2787': 'vector_3',
        '2796': 'fenix5_asia',
        '2797': 'fenix5s_asia',
        '2798': 'fenix5x_asia',
        '2806': 'approach_z80',
        '2814': 'fr35_korea',
        '2819': 'd2charlie',
        '2831': 'vivo_smart3_apac',
        '2832': 'vivo_sport_apac',
        '2833': 'fr935_asia',
        '2859': 'descent',
        '2878': 'vivo_fit4',
        '2886': 'fr645',
        '2888': 'fr645m',
        '2891': 'fr30',
        '2900': 'fenix5s_plus',
        '2909': 'Edge_130',
        '2924': 'edge_1030_asia',
        '2927': 'vivosmart_4',
        '2945': 'vivo_move_hr_asia',
        '2962': 'approach_x10',
        '2977': 'fr30_asia',
        '2988': 'vivoactive3m_w',
        '3003': 'fr645_asia',
        '3004': 'fr645m_asia',
        '3011': 'edge_explore',
        '3028': 'gpsmap66',
        '3049': 'approach_s10',
        '3066': 'vivoactive3m_l',
        '3085': 'approach_g80',
        '3092': 'edge_130_asia',
        '3095': 'edge_1030_bontrager',
        '3110': 'fenix5_plus',
        '3111': 'fenix5x_plus',
        '3112': 'edge_520_plus',
        '3113': 'fr945',
        '3121': 'edge_530',
        '3122': 'edge_830',
        '3126': 'instinct_esports',
        '3134': 'fenix5s_plus_apac',
        '3135': 'fenix5x_plus_apac',
        '3142': 'edge_520_plus_apac',
        '3143': 'descent_t1',
        '3144': 'fr235l_asia',
        '3145': 'fr245_asia',
        '3163': 'vivo_active3m_apac',
        '3192': 'gen3_bsm', # gen3 bike speed sensor
        '3193': 'gen3_bcm', # gen3 bike cadence sensor
        '3218': 'vivo_smart4_asia',
        '3224': 'vivoactive4_small',
        '3225': 'vivoactive4_large',
        '3226': 'venu',
        '3246': 'marq_driver',
        '3247': 'marq_aviator',
        '3248': 'marq_captain',
        '3249': 'marq_commander',
        '3250': 'marq_expedition',
        '3251': 'marq_athlete',
        '3258': 'descent_mk2',
        '3284': 'gpsmap66i',
        '3287': 'fenix6S_sport',
        '3288': 'fenix6S',
        '3289': 'fenix6_sport',
        '3290': 'fenix6',
        '3291': 'fenix6x',
        '3299': 'hrm_dual', # HRM-Dual
        '3300': 'hrm_pro', # HRM-Pro
        '3308': 'vivo_move3_premium',
        '3314': 'approach_s40',
        '3321': 'fr245m_asia',
        '3349': 'edge_530_apac',
        '3350': 'edge_830_apac',
        '3378': 'vivo_move3',
        '3387': 'vivo_active4_small_asia',
        '3388': 'vivo_active4_large_asia',
        '3389': 'vivo_active4_oled_asia',
        '3405': 'swim2',
        '3420': 'marq_driver_asia',
        '3421': 'marq_aviator_asia',
        '3422': 'vivo_move3_asia',
        '3441': 'fr945_asia',
        '3446': 'vivo_active3t_chn',
        '3448': 'marq_captain_asia',
        '3449': 'marq_commander_asia',
        '3450': 'marq_expedition_asia',
        '3451': 'marq_athlete_asia',
        '3461': 'index_smart_scale_2',
        '3466': 'instinct_solar',
        '3469': 'fr45_asia',
        '3473': 'vivoactive3_daimler',
        '3498': 'legacy_rey',
        '3499': 'legacy_darth_vader',
        '3500': 'legacy_captain_marvel',
        '3501': 'legacy_first_avenger',
        '3512': 'fenix6s_sport_asia',
        '3513': 'fenix6s_asia',
        '3514': 'fenix6_sport_asia',
        '3515': 'fenix6_asia',
        '3516': 'fenix6x_asia',
        '3535': 'legacy_captain_marvel_asia',
        '3536': 'legacy_first_avenger_asia',
        '3537': 'legacy_rey_asia',
        '3538': 'legacy_darth_vader_asia',
        '3542': 'descent_mk2s',
        '3558': 'edge_130_plus',
        '3570': 'edge_1030_plus',
        '3578': 'rally_200', # Rally 100/200 Power Meter Series
        '3589': 'fr745',
        '3600': 'venusq',
        '3615': 'lily',
        '3624': 'marq_adventurer',
        '3638': 'enduro',
        '3639': 'swim2_apac',
        '3648': 'marq_adventurer_asia',
        '3652': 'fr945_lte',
        '3702': 'descent_mk2_asia', # Mk2 and Mk2i
        '3703': 'venu2',
        '3704': 'venu2s',
        '3737': 'venu_daimler_asia',
        '3739': 'marq_golfer',
        '3740': 'venu_daimler',
        '3794': 'fr745_asia',
        '3808': 'varia_rct715',
        '3809': 'lily_asia',
        '3812': 'edge_1030_plus_asia',
        '3813': 'edge_130_plus_asia',
        '3823': 'approach_s12',
        '3872': 'enduro_asia',
        '3837': 'venusq_asia',
        '3843': 'edge_1040',
        '3850': 'marq_golfer_asia',
        '3851': 'venu2_plus',
        '3865': 'gnss',
        '3869': 'fr55',
        '3888': 'instinct_2',
        '3905': 'fenix7s',
        '3906': 'fenix7',
        '3907': 'fenix7x',
        '3908': 'fenix7s_apac',
        '3909': 'fenix7_apac',
        '3910': 'fenix7x_apac',
        ' 3927': 'approach_g12',
        '3930': 'descent_mk2s_asia',
        '3934': 'approach_s42',
        '3943': 'epix_gen2',
        '3944': 'epix_gen2_apac',
        '3949': 'venu2s_asia',
        '3950': 'venu2_asia',
        '3978': 'fr945_lte_asia',
        '3982': 'vivo_move_sport',
        '3983': 'vivomove_trend',
        '3986': 'approach_S12_asia',
        '3990': 'fr255_music',
        '3991': 'fr255_small_music',
        '3992': 'fr255',
        '3993': 'fr255_small',
        ' 4001': 'approach_g12_asia',
        '4002': 'approach_s42_asia',
        '4005': 'descent_g1',
        '4017': 'venu2_plus_asia',
        '4024': 'fr955',
        '4033': 'fr55_asia',
        '4061': 'edge_540',
        '4062': 'edge_840',
        '4063': 'vivosmart_5',
        '4071': 'instinct_2_asia',
        '4105': 'marq_gen2', # Adventurer, Athlete, Captain, Golfer
        '4115': 'venusq2',
        '4116': 'venusq2music',
        '4124': 'marq_gen2_aviator',
        '4125': 'd2_air_x10',
        '4130': 'hrm_pro_plus',
        '4132': 'descent_g1_asia',
        '4135': 'tactix7',
        '4155': 'instinct_crossover',
        '4169': 'edge_explore2',
        '4222': 'descent_mk3',
        '4223': 'descent_mk3i',
        '4233': 'approach_s70',
        '4257': 'fr265_large',
        '4258': 'fr265_small',
        '4260': 'venu3',
        '4261': 'venu3s',
        '4265': 'tacx_neo_smart', # Neo Smart, Tacx
        '4266': 'tacx_neo2_smart', # Neo 2 Smart, Tacx
        '4267': 'tacx_neo2_t_smart', # Neo 2T Smart, Tacx
        '4268': 'tacx_neo_smart_bike', # Neo Smart Bike, Tacx
        '4269': 'tacx_satori_smart', # Satori Smart, Tacx
        '4270': 'tacx_flow_smart', # Flow Smart, Tacx
        '4271': 'tacx_vortex_smart', # Vortex Smart, Tacx
        '4272': 'tacx_bushido_smart', # Bushido Smart, Tacx
        '4273': 'tacx_genius_smart', # Genius Smart, Tacx
        '4274': 'tacx_flux_flux_s_smart', # Flux/Flux S Smart, Tacx
        '4275': 'tacx_flux2_smart', # Flux 2 Smart, Tacx
        '4276': 'tacx_magnum', # Magnum, Tacx
        '4305': 'edge_1040_asia',
        '4312': 'epix_gen2_pro_42',
        '4313': 'epix_gen2_pro_47',
        '4314': 'epix_gen2_pro_51',
        '4315': 'fr965',
        '4341': 'enduro2',
        '4374': 'fenix7s_pro_solar',
        '4375': 'fenix7_pro_solar',
        '4376': 'fenix7x_pro_solar',
        '4380': 'lily2',
        '4394': 'instinct_2x',
        '4426': 'vivoactive5',
        '4432': 'fr165',
        '4433': 'fr165_music',
        '4440': 'edge_1050',
        '4442': 'descent_t2',
        '4446': 'hrm_fit',
        '4472': 'marq_gen2_commander',
        '4477': 'lily_athlete', # aka the Lily 2 Active
        '4532': 'fenix8_solar',
        '4533': 'fenix8_solar_large',
        '4534': 'fenix8_small',
        '4536': 'fenix8',
        '4556': 'd2_mach1_pro',
        '4575': 'enduro3',
        '4666': 'fenix_e',
        '10007': 'sdm4', # SDM4 footpod
        '10014': 'edge_remote',
        '20533': 'tacx_training_app_win',
        '20534': 'tacx_training_app_mac',
        '20565': 'tacx_training_app_mac_catalyst',
        '20119': 'training_center',
        '30045': 'tacx_training_app_android',
        '30046': 'tacx_training_app_ios',
        '30047': 'tacx_training_app_legacy',
        '65531': 'connectiq_simulator',
        '65532': 'android_antplus_plugin',
        '65534': 'connect', # Garmin Connect website
        },
    'antplus_device_type': {
        '1': 'antfs',
        '11': 'bike_power',
        '12': 'environment_sensor_legacy',
        '15': 'multi_sport_speed_distance',
        '16': 'control',
        '17': 'fitness_equipment',
        '18': 'blood_pressure',
        '19': 'geocache_node',
        '20': 'light_electric_vehicle',
        '25': 'env_sensor',
        '26': 'racquet',
        '27': 'control_hub',
        '31': 'muscle_oxygen',
        '34': 'shifting',
        '35': 'bike_light_main',
        '36': 'bike_light_shared',
        '38': 'exd',
        '40': 'bike_radar',
        '46': 'bike_aero',
        '119': 'weight_scale',
        '120': 'heart_rate',
        '121': 'bike_speed_cadence',
        '122': 'bike_cadence',
        '123': 'bike_speed',
        '124': 'stride_speed_distance',
        },
    'ant_network': {
        '0': 'public',
        '1': 'antplus',
        '2': 'antfs',
        '3': 'private',
        },
    'workout_capabilities': {
        '0x00000001': 'interval',
        '0x00000002': 'custom',
        '0x00000004': 'fitness_equipment',
        '0x00000008': 'firstbeat',
        '0x00000010': 'new_leaf',
        '0x00000020': 'tcx', # For backwards compatibility. Watch should add missing id fields then clear flag.
        '0x00000080': 'speed', # Speed source required for workout step.
        '0x00000100': 'heart_rate', # Heart rate source required for workout step.
        '0x00000200': 'distance', # Distance source required for workout step.
        '0x00000400': 'cadence', # Cadence source required for workout step.
        '0x00000800': 'power', # Power source required for workout step.
        '0x00001000': 'grade', # Grade source required for workout step.
        '0x00002000': 'resistance', # Resistance source required for workout step.
        '0x00004000': 'protected',
        },
    'battery_status': {
        '1': 'new',
        '2': 'good',
        '3': 'ok',
        '4': 'low',
        '5': 'critical',
        '6': 'charging',
        '7': 'unknown',
        },
    'hr_type': {
        '0': 'normal',
        '1': 'irregular',
        },
    'course_capabilities': {
        '0x00000001': 'processed',
        '0x00000002': 'valid',
        '0x00000004': 'time',
        '0x00000008': 'distance',
        '0x00000010': 'position',
        '0x00000020': 'heart_rate',
        '0x00000040': 'power',
        '0x00000080': 'cadence',
        '0x00000100': 'training',
        '0x00000200': 'navigation',
        '0x00000400': 'bikeway',
        '0x00001000': 'aviation', # Denote course files to be used as flight plans
        },
    'weight': {
        '0xFFFE': 'calculating',
        },
    'workout_hr': {
        '100': 'bpm_offset',
        },
    'workout_power': {
        '1000': 'watts_offset',
        },
    'bp_status': {
        '0': 'no_error',
        '1': 'error_incomplete_data',
        '2': 'error_no_measurement',
        '3': 'error_data_out_of_range',
        '4': 'error_irregular_heart_rate',
        },
    'user_local_id': {
        '0x0000': 'local_min',
        '0x000F': 'local_max',
        '0x0010': 'stationary_min',
        '0x00FF': 'stationary_max',
        '0x0100': 'portable_min',
        '0xFFFE': 'portable_max',
        },
    'swim_stroke': {
        '0': 'freestyle',
        '1': 'backstroke',
        '2': 'breaststroke',
        '3': 'butterfly',
        '4': 'drill',
        '5': 'mixed',
        '6': 'im', # IM is a mixed interval containing the same number of lengths for each of: Butterfly, Backstroke, Breaststroke, Freestyle, swam in that order.
        },
    'activity_type': {
        '0': 'generic',
        '1': 'running',
        '2': 'cycling',
        '3': 'transition', # Mulitsport transition
        '4': 'fitness_equipment',
        '5': 'swimming',
        '6': 'walking',
        '8': 'sedentary',
        '254': 'all', # All is for goals only to include all sports.
        },
    'activity_subtype': {
        '0': 'generic',
        '1': 'treadmill', # Run
        '2': 'street', # Run
        '3': 'trail', # Run
        '4': 'track', # Run
        '5': 'spin', # Cycling
        '6': 'indoor_cycling', # Cycling
        '7': 'road', # Cycling
        '8': 'mountain', # Cycling
        '9': 'downhill', # Cycling
        '10': 'recumbent', # Cycling
        '11': 'cyclocross', # Cycling
        '12': 'hand_cycling', # Cycling
        '13': 'track_cycling', # Cycling
        '14': 'indoor_rowing', # Fitness Equipment
        '15': 'elliptical', # Fitness Equipment
        '16': 'stair_climbing', # Fitness Equipment
        '17': 'lap_swimming', # Swimming
        '18': 'open_water', # Swimming
        '254': 'all',
        },
    'activity_level': {
        '0': 'low',
        '1': 'medium',
        '2': 'high',
        },
    'side': {
        '0': 'right',
        '1': 'left',
        },
    'left_right_balance': {
        '0x7F': 'mask', # % contribution
        '0x80': 'right', # data corresponds to right if set, otherwise unknown
        },
    'left_right_balance_100': {
        '0x3FFF': 'mask', # % contribution scaled by 100
        '0x8000': 'right', # data corresponds to right if set, otherwise unknown
        },
    'length_type': {
        '0': 'idle', # Rest period. Length with no strokes
        '1': 'active', # Length with strokes.
        },
    'day_of_week': {
        '0': 'sunday',
        '1': 'monday',
        '2': 'tuesday',
        '3': 'wednesday',
        '4': 'thursday',
        '5': 'friday',
        '6': 'saturday',
        },
    'connectivity_capabilities': {
        '0x00000001': 'bluetooth',
        '0x00000002': 'bluetooth_le',
        '0x00000004': 'ant',
        '0x00000008': 'activity_upload',
        '0x00000010': 'course_download',
        '0x00000020': 'workout_download',
        '0x00000040': 'live_track',
        '0x00000080': 'weather_conditions',
        '0x00000100': 'weather_alerts',
        '0x00000200': 'gps_ephemeris_download',
        '0x00000400': 'explicit_archive',
        '0x00000800': 'setup_incomplete',
        '0x00001000': 'continue_sync_after_software_update',
        '0x00002000': 'connect_iq_app_download',
        '0x00004000': 'golf_course_download',
        '0x00008000': 'device_initiates_sync', # Indicates device is in control of initiating all syncs
        '0x00010000': 'connect_iq_watch_app_download',
        '0x00020000': 'connect_iq_widget_download',
        '0x00040000': 'connect_iq_watch_face_download',
        '0x00080000': 'connect_iq_data_field_download',
        '0x00100000': 'connect_iq_app_managment', # Device supports delete and reorder of apps via GCM
        '0x00200000': 'swing_sensor',
        '0x00400000': 'swing_sensor_remote',
        '0x00800000': 'incident_detection', # Device supports incident detection
        '0x01000000': 'audio_prompts',
        '0x02000000': 'wifi_verification', # Device supports reporting wifi verification via GCM
        '0x04000000': 'true_up', # Device supports True Up
        '0x08000000': 'find_my_watch', # Device supports Find My Watch
        '0x10000000': 'remote_manual_sync',
        '0x20000000': 'live_track_auto_start', # Device supports LiveTrack auto start
        '0x40000000': 'live_track_messaging', # Device supports LiveTrack Messaging
        '0x80000000': 'instant_input', # Device supports instant input feature
        },
    'weather_report': {
        '0': 'current',
        '1': 'forecast', # Deprecated use hourly_forecast instead
        '1': 'hourly_forecast',
        '2': 'daily_forecast',
        },
    'weather_status': {
        '0': 'clear',
        '1': 'partly_cloudy',
        '2': 'mostly_cloudy',
        '3': 'rain',
        '4': 'snow',
        '5': 'windy',
        '6': 'thunderstorms',
        '7': 'wintry_mix',
        '8': 'fog',
        '11': 'hazy',
        '12': 'hail',
        '13': 'scattered_showers',
        '14': 'scattered_thunderstorms',
        '15': 'unknown_precipitation',
        '16': 'light_rain',
        '17': 'heavy_rain',
        '18': 'light_snow',
        '19': 'heavy_snow',
        '20': 'light_rain_snow',
        '21': 'heavy_rain_snow',
        '22': 'cloudy',
        },
    'weather_severity': {
        '0': 'unknown',
        '1': 'warning',
        '2': 'watch',
        '3': 'advisory',
        '4': 'statement',
        },
    'weather_severe_type': {
        '0': 'unspecified',
        '1': 'tornado',
        '2': 'tsunami',
        '3': 'hurricane',
        '4': 'extreme_wind',
        '5': 'typhoon',
        '6': 'inland_hurricane',
        '7': 'hurricane_force_wind',
        '8': 'waterspout',
        '9': 'severe_thunderstorm',
        '10': 'wreckhouse_winds',
        '11': 'les_suetes_wind',
        '12': 'avalanche',
        '13': 'flash_flood',
        '14': 'tropical_storm',
        '15': 'inland_tropical_storm',
        '16': 'blizzard',
        '17': 'ice_storm',
        '18': 'freezing_rain',
        '19': 'debris_flow',
        '20': 'flash_freeze',
        '21': 'dust_storm',
        '22': 'high_wind',
        '23': 'winter_storm',
        '24': 'heavy_freezing_spray',
        '25': 'extreme_cold',
        '26': 'wind_chill',
        '27': 'cold_wave',
        '28': 'heavy_snow_alert',
        '29': 'lake_effect_blowing_snow',
        '30': 'snow_squall',
        '31': 'lake_effect_snow',
        '32': 'winter_weather',
        '33': 'sleet',
        '34': 'snowfall',
        '35': 'snow_and_blowing_snow',
        '36': 'blowing_snow',
        '37': 'snow_alert',
        '38': 'arctic_outflow',
        '39': 'freezing_drizzle',
        '40': 'storm',
        '41': 'storm_surge',
        '42': 'rainfall',
        '43': 'areal_flood',
        '44': 'coastal_flood',
        '45': 'lakeshore_flood',
        '46': 'excessive_heat',
        '47': 'heat',
        '48': 'weather',
        '49': 'high_heat_and_humidity',
        '50': 'humidex_and_health',
        '51': 'humidex',
        '52': 'gale',
        '53': 'freezing_spray',
        '54': 'special_marine',
        '55': 'squall',
        '56': 'strong_wind',
        '57': 'lake_wind',
        '58': 'marine_weather',
        '59': 'wind',
        '60': 'small_craft_hazardous_seas',
        '61': 'hazardous_seas',
        '62': 'small_craft',
        '63': 'small_craft_winds',
        '64': 'small_craft_rough_bar',
        '65': 'high_water_level',
        '66': 'ashfall',
        '67': 'freezing_fog',
        '68': 'dense_fog',
        '69': 'dense_smoke',
        '70': 'blowing_dust',
        '71': 'hard_freeze',
        '72': 'freeze',
        '73': 'frost',
        '74': 'fire_weather',
        '75': 'flood',
        '76': 'rip_tide',
        '77': 'high_surf',
        '78': 'smog',
        '79': 'air_quality',
        '80': 'brisk_wind',
        '81': 'air_stagnation',
        '82': 'low_water',
        '83': 'hydrological',
        '84': 'special_weather',
        },
    'time_into_day': {
        },
    'localtime_into_day': {
        },
    'stroke_type': {
        '0': 'no_event',
        '1': 'other', # stroke was detected but cannot be identified
        '2': 'serve',
        '3': 'forehand',
        '4': 'backhand',
        '5': 'smash',
        },
    'body_location': {
        '0': 'left_leg',
        '1': 'left_calf',
        '2': 'left_shin',
        '3': 'left_hamstring',
        '4': 'left_quad',
        '5': 'left_glute',
        '6': 'right_leg',
        '7': 'right_calf',
        '8': 'right_shin',
        '9': 'right_hamstring',
        '10': 'right_quad',
        '11': 'right_glute',
        '12': 'torso_back',
        '13': 'left_lower_back',
        '14': 'left_upper_back',
        '15': 'right_lower_back',
        '16': 'right_upper_back',
        '17': 'torso_front',
        '18': 'left_abdomen',
        '19': 'left_chest',
        '20': 'right_abdomen',
        '21': 'right_chest',
        '22': 'left_arm',
        '23': 'left_shoulder',
        '24': 'left_bicep',
        '25': 'left_tricep',
        '26': 'left_brachioradialis', # Left anterior forearm
        '27': 'left_forearm_extensors', # Left posterior forearm
        '28': 'right_arm',
        '29': 'right_shoulder',
        '30': 'right_bicep',
        '31': 'right_tricep',
        '32': 'right_brachioradialis', # Right anterior forearm
        '33': 'right_forearm_extensors', # Right posterior forearm
        '34': 'neck',
        '35': 'throat',
        '36': 'waist_mid_back',
        '37': 'waist_front',
        '38': 'waist_left',
        '39': 'waist_right',
        },
    'segment_lap_status': {
        '0': 'end',
        '1': 'fail',
        },
    'segment_leaderboard_type': {
        '0': 'overall',
        '1': 'personal_best',
        '2': 'connections',
        '3': 'group',
        '4': 'challenger',
        '5': 'kom',
        '6': 'qom',
        '7': 'pr',
        '8': 'goal',
        '9': 'carrot',
        '10': 'club_leader',
        '11': 'rival',
        '12': 'last',
        '13': 'recent_best',
        '14': 'course_record',
        },
    'segment_delete_status': {
        '0': 'do_not_delete',
        '1': 'delete_one',
        '2': 'delete_all',
        },
    'segment_selection_type': {
        '0': 'starred',
        '1': 'suggested',
        },
    'source_type': {
        '0': 'ant', # External device connected with ANT
        '1': 'antplus', # External device connected with ANT+
        '2': 'bluetooth', # External device connected with BT
        '3': 'bluetooth_low_energy', # External device connected with BLE
        '4': 'wifi', # External device connected with Wifi
        '5': 'local', # Onboard device
        },
    'local_device_type': {
        '0': 'gps', # Onboard gps receiver
        '1': 'glonass', # Onboard glonass receiver
        '2': 'gps_glonass', # Onboard gps glonass receiver
        '3': 'accelerometer', # Onboard sensor
        '4': 'barometer', # Onboard sensor
        '5': 'temperature', # Onboard sensor
        '10': 'whr', # Onboard wrist HR sensor
        '12': 'sensor_hub', # Onboard software package
        },
    'ble_device_type': {
        '0': 'connected_gps', # GPS that is provided over a proprietary bluetooth service
        '1': 'heart_rate',
        '2': 'bike_power',
        '3': 'bike_speed_cadence',
        '4': 'bike_speed',
        '5': 'bike_cadence',
        '6': 'footpod',
        '7': 'bike_trainer', # Indoor-Bike FTMS protocol
        },
    'ant_channel_id': {
        '0xF0000000': 'ant_extended_device_number_upper_nibble',
        '0x0F000000': 'ant_transmission_type_lower_nibble',
        '0x00FF0000': 'ant_device_type',
        '0x0000FFFF': 'ant_device_number',
        },
    'display_orientation': {
        '0': 'auto', # automatic if the device supports it
        '1': 'portrait',
        '2': 'landscape',
        '3': 'portrait_flipped', # portrait mode but rotated 180 degrees
        '4': 'landscape_flipped', # landscape mode but rotated 180 degrees
        },
    'workout_equipment': {
        '0': 'none',
        '1': 'swim_fins',
        '2': 'swim_kickboard',
        '3': 'swim_paddles',
        '4': 'swim_pull_buoy',
        '5': 'swim_snorkel',
        },
    'watchface_mode': {
        '0': 'digital',
        '1': 'analog',
        '2': 'connect_iq',
        '3': 'disabled',
        },
    'digital_watchface_layout': {
        '0': 'traditional',
        '1': 'modern',
        '2': 'bold',
        },
    'analog_watchface_layout': {
        '0': 'minimal',
        '1': 'traditional',
        '2': 'modern',
        },
    'rider_position_type': {
        '0': 'seated',
        '1': 'standing',
        '2': 'transition_to_seated',
        '3': 'transition_to_standing',
        },
    'power_phase_type': {
        '0': 'power_phase_start_angle',
        '1': 'power_phase_end_angle',
        '2': 'power_phase_arc_length',
        '3': 'power_phase_center',
        },
    'camera_event_type': {
        '0': 'video_start', # Start of video recording
        '1': 'video_split', # Mark of video file split (end of one file, beginning of the other)
        '2': 'video_end', # End of video recording
        '3': 'photo_taken', # Still photo taken
        '4': 'video_second_stream_start',
        '5': 'video_second_stream_split',
        '6': 'video_second_stream_end',
        '7': 'video_split_start', # Mark of video file split start
        '8': 'video_second_stream_split_start',
        '11': 'video_pause', # Mark when a video recording has been paused
        '12': 'video_second_stream_pause',
        '13': 'video_resume', # Mark when a video recording has been resumed
        '14': 'video_second_stream_resume',
        },
    'sensor_type': {
        '0': 'accelerometer',
        '1': 'gyroscope',
        '2': 'compass', # Magnetometer
        '3': 'barometer',
        },
    'bike_light_network_config_type': {
        '0': 'auto',
        '4': 'individual',
        '5': 'high_visibility',
        '6': 'trail',
        },
    'comm_timeout_type': {
        '0': 'wildcard_pairing_timeout', # Timeout pairing to any device
        '1': 'pairing_timeout', # Timeout pairing to previously paired device
        '2': 'connection_lost', # Temporary loss of communications
        '3': 'connection_timeout', # Connection closed due to extended bad communications
        },
    'camera_orientation_type': {
        '0': 'camera_orientation_0',
        '1': 'camera_orientation_90',
        '2': 'camera_orientation_180',
        '3': 'camera_orientation_270',
        },
    'attitude_stage': {
        '0': 'failed',
        '1': 'aligning',
        '2': 'degraded',
        '3': 'valid',
        },
    'attitude_validity': {
        '0x0001': 'track_angle_heading_valid',
        '0x0002': 'pitch_valid',
        '0x0004': 'roll_valid',
        '0x0008': 'lateral_body_accel_valid',
        '0x0010': 'normal_body_accel_valid',
        '0x0020': 'turn_rate_valid',
        '0x0040': 'hw_fail',
        '0x0080': 'mag_invalid',
        '0x0100': 'no_gps',
        '0x0200': 'gps_invalid',
        '0x0400': 'solution_coasting',
        '0x0800': 'true_track_angle',
        '0x1000': 'magnetic_heading',
        },
    'auto_sync_frequency': {
        '0': 'never',
        '1': 'occasionally',
        '2': 'frequent',
        '3': 'once_a_day',
        '4': 'remote',
        },
    'exd_layout': {
        '0': 'full_screen',
        '1': 'half_vertical',
        '2': 'half_horizontal',
        '3': 'half_vertical_right_split',
        '4': 'half_horizontal_bottom_split',
        '5': 'full_quarter_split',
        '6': 'half_vertical_left_split',
        '7': 'half_horizontal_top_split',
        '8': 'dynamic', # The EXD may display the configured concepts in any layout it sees fit.
        },
    'exd_display_type': {
        '0': 'numerical',
        '1': 'simple',
        '2': 'graph',
        '3': 'bar',
        '4': 'circle_graph',
        '5': 'virtual_partner',
        '6': 'balance',
        '7': 'string_list',
        '8': 'string',
        '9': 'simple_dynamic_icon',
        '10': 'gauge',
        },
    'exd_data_units': {
        '0': 'no_units',
        '1': 'laps',
        '2': 'miles_per_hour',
        '3': 'kilometers_per_hour',
        '4': 'feet_per_hour',
        '5': 'meters_per_hour',
        '6': 'degrees_celsius',
        '7': 'degrees_farenheit',
        '8': 'zone',
        '9': 'gear',
        '10': 'rpm',
        '11': 'bpm',
        '12': 'degrees',
        '13': 'millimeters',
        '14': 'meters',
        '15': 'kilometers',
        '16': 'feet',
        '17': 'yards',
        '18': 'kilofeet',
        '19': 'miles',
        '20': 'time',
        '21': 'enum_turn_type',
        '22': 'percent',
        '23': 'watts',
        '24': 'watts_per_kilogram',
        '25': 'enum_battery_status',
        '26': 'enum_bike_light_beam_angle_mode',
        '27': 'enum_bike_light_battery_status',
        '28': 'enum_bike_light_network_config_type',
        '29': 'lights',
        '30': 'seconds',
        '31': 'minutes',
        '32': 'hours',
        '33': 'calories',
        '34': 'kilojoules',
        '35': 'milliseconds',
        '36': 'second_per_mile',
        '37': 'second_per_kilometer',
        '38': 'centimeter',
        '39': 'enum_course_point',
        '40': 'bradians',
        '41': 'enum_sport',
        '42': 'inches_hg',
        '43': 'mm_hg',
        '44': 'mbars',
        '45': 'hecto_pascals',
        '46': 'feet_per_min',
        '47': 'meters_per_min',
        '48': 'meters_per_sec',
        '49': 'eight_cardinal',
        },
    'exd_qualifiers': {
        '0': 'no_qualifier',
        '1': 'instantaneous',
        '2': 'average',
        '3': 'lap',
        '4': 'maximum',
        '5': 'maximum_average',
        '6': 'maximum_lap',
        '7': 'last_lap',
        '8': 'average_lap',
        '9': 'to_destination',
        '10': 'to_go',
        '11': 'to_next',
        '12': 'next_course_point',
        '13': 'total',
        '14': 'three_second_average',
        '15': 'ten_second_average',
        '16': 'thirty_second_average',
        '17': 'percent_maximum',
        '18': 'percent_maximum_average',
        '19': 'lap_percent_maximum',
        '20': 'elapsed',
        '21': 'sunrise',
        '22': 'sunset',
        '23': 'compared_to_virtual_partner',
        '24': 'maximum_24h',
        '25': 'minimum_24h',
        '26': 'minimum',
        '27': 'first',
        '28': 'second',
        '29': 'third',
        '30': 'shifter',
        '31': 'last_sport',
        '32': 'moving',
        '33': 'stopped',
        '34': 'estimated_total',
        '242': 'zone_9',
        '243': 'zone_8',
        '244': 'zone_7',
        '245': 'zone_6',
        '246': 'zone_5',
        '247': 'zone_4',
        '248': 'zone_3',
        '249': 'zone_2',
        '250': 'zone_1',
        },
    'exd_descriptors': {
        '0': 'bike_light_battery_status',
        '1': 'beam_angle_status',
        '2': 'batery_level',
        '3': 'light_network_mode',
        '4': 'number_lights_connected',
        '5': 'cadence',
        '6': 'distance',
        '7': 'estimated_time_of_arrival',
        '8': 'heading',
        '9': 'time',
        '10': 'battery_level',
        '11': 'trainer_resistance',
        '12': 'trainer_target_power',
        '13': 'time_seated',
        '14': 'time_standing',
        '15': 'elevation',
        '16': 'grade',
        '17': 'ascent',
        '18': 'descent',
        '19': 'vertical_speed',
        '20': 'di2_battery_level',
        '21': 'front_gear',
        '22': 'rear_gear',
        '23': 'gear_ratio',
        '24': 'heart_rate',
        '25': 'heart_rate_zone',
        '26': 'time_in_heart_rate_zone',
        '27': 'heart_rate_reserve',
        '28': 'calories',
        '29': 'gps_accuracy',
        '30': 'gps_signal_strength',
        '31': 'temperature',
        '32': 'time_of_day',
        '33': 'balance',
        '34': 'pedal_smoothness',
        '35': 'power',
        '36': 'functional_threshold_power',
        '37': 'intensity_factor',
        '38': 'work',
        '39': 'power_ratio',
        '40': 'normalized_power',
        '41': 'training_stress_Score',
        '42': 'time_on_zone',
        '43': 'speed',
        '44': 'laps',
        '45': 'reps',
        '46': 'workout_step',
        '47': 'course_distance',
        '48': 'navigation_distance',
        '49': 'course_estimated_time_of_arrival',
        '50': 'navigation_estimated_time_of_arrival',
        '51': 'course_time',
        '52': 'navigation_time',
        '53': 'course_heading',
        '54': 'navigation_heading',
        '55': 'power_zone',
        '56': 'torque_effectiveness',
        '57': 'timer_time',
        '58': 'power_weight_ratio',
        '59': 'left_platform_center_offset',
        '60': 'right_platform_center_offset',
        '61': 'left_power_phase_start_angle',
        '62': 'right_power_phase_start_angle',
        '63': 'left_power_phase_finish_angle',
        '64': 'right_power_phase_finish_angle',
        '65': 'gears', # Combined gear information
        '66': 'pace',
        '67': 'training_effect',
        '68': 'vertical_oscillation',
        '69': 'vertical_ratio',
        '70': 'ground_contact_time',
        '71': 'left_ground_contact_time_balance',
        '72': 'right_ground_contact_time_balance',
        '73': 'stride_length',
        '74': 'running_cadence',
        '75': 'performance_condition',
        '76': 'course_type',
        '77': 'time_in_power_zone',
        '78': 'navigation_turn',
        '79': 'course_location',
        '80': 'navigation_location',
        '81': 'compass',
        '82': 'gear_combo',
        '83': 'muscle_oxygen',
        '84': 'icon',
        '85': 'compass_heading',
        '86': 'gps_heading',
        '87': 'gps_elevation',
        '88': 'anaerobic_training_effect',
        '89': 'course',
        '90': 'off_course',
        '91': 'glide_ratio',
        '92': 'vertical_distance',
        '93': 'vmg',
        '94': 'ambient_pressure',
        '95': 'pressure',
        '96': 'vam',
        },
    'auto_activity_detect': {
        '0x00000000': 'none',
        '0x00000001': 'running',
        '0x00000002': 'cycling',
        '0x00000004': 'swimming',
        '0x00000008': 'walking',
        '0x00000020': 'elliptical',
        '0x00000400': 'sedentary',
        },
    'supported_exd_screen_layouts': {
        '0x00000001': 'full_screen',
        '0x00000002': 'half_vertical',
        '0x00000004': 'half_horizontal',
        '0x00000008': 'half_vertical_right_split',
        '0x00000010': 'half_horizontal_bottom_split',
        '0x00000020': 'full_quarter_split',
        '0x00000040': 'half_vertical_left_split',
        '0x00000080': 'half_horizontal_top_split',
        },
    'fit_base_type': {
        '0': 'enum',
        '1': 'sint8',
        '2': 'uint8',
        '131': 'sint16',
        '132': 'uint16',
        '133': 'sint32',
        '134': 'uint32',
        '7': 'string',
        '136': 'float32',
        '137': 'float64',
        '10': 'uint8z',
        '139': 'uint16z',
        '140': 'uint32z',
        '13': 'byte',
        '142': 'sint64',
        '143': 'uint64',
        '144': 'uint64z',
        },
    'turn_type': {
        '0': 'arriving_idx',
        '1': 'arriving_left_idx',
        '2': 'arriving_right_idx',
        '3': 'arriving_via_idx',
        '4': 'arriving_via_left_idx',
        '5': 'arriving_via_right_idx',
        '6': 'bear_keep_left_idx',
        '7': 'bear_keep_right_idx',
        '8': 'continue_idx',
        '9': 'exit_left_idx',
        '10': 'exit_right_idx',
        '11': 'ferry_idx',
        '12': 'roundabout_45_idx',
        '13': 'roundabout_90_idx',
        '14': 'roundabout_135_idx',
        '15': 'roundabout_180_idx',
        '16': 'roundabout_225_idx',
        '17': 'roundabout_270_idx',
        '18': 'roundabout_315_idx',
        '19': 'roundabout_360_idx',
        '20': 'roundabout_neg_45_idx',
        '21': 'roundabout_neg_90_idx',
        '22': 'roundabout_neg_135_idx',
        '23': 'roundabout_neg_180_idx',
        '24': 'roundabout_neg_225_idx',
        '25': 'roundabout_neg_270_idx',
        '26': 'roundabout_neg_315_idx',
        '27': 'roundabout_neg_360_idx',
        '28': 'roundabout_generic_idx',
        '29': 'roundabout_neg_generic_idx',
        '30': 'sharp_turn_left_idx',
        '31': 'sharp_turn_right_idx',
        '32': 'turn_left_idx',
        '33': 'turn_right_idx',
        '34': 'uturn_left_idx',
        '35': 'uturn_right_idx',
        '36': 'icon_inv_idx',
        '37': 'icon_idx_cnt',
        },
    'bike_light_beam_angle_mode': {
        '0': 'manual',
        '1': 'auto',
        },
    'fit_base_unit': {
        '0': 'other',
        '1': 'kilogram',
        '2': 'pound',
        },
    'set_type': {
        '0': 'rest',
        '1': 'active',
        },
    'max_met_category': {
        '0': 'generic',
        '1': 'cycling',
        },
    'exercise_category': {
        '0': 'bench_press',
        '1': 'calf_raise',
        '2': 'cardio',
        '3': 'carry',
        '4': 'chop',
        '5': 'core',
        '6': 'crunch',
        '7': 'curl',
        '8': 'deadlift',
        '9': 'flye',
        '10': 'hip_raise',
        '11': 'hip_stability',
        '12': 'hip_swing',
        '13': 'hyperextension',
        '14': 'lateral_raise',
        '15': 'leg_curl',
        '16': 'leg_raise',
        '17': 'lunge',
        '18': 'olympic_lift',
        '19': 'plank',
        '20': 'plyo',
        '21': 'pull_up',
        '22': 'push_up',
        '23': 'row',
        '24': 'shoulder_press',
        '25': 'shoulder_stability',
        '26': 'shrug',
        '27': 'sit_up',
        '28': 'squat',
        '29': 'total_body',
        '30': 'triceps_extension',
        '31': 'warm_up',
        '32': 'run',
        '65534': 'unknown',
        },
    'bench_press_exercise_name': {
        '0': 'alternating_dumbbell_chest_press_on_swiss_ball',
        '1': 'barbell_bench_press',
        '2': 'barbell_board_bench_press',
        '3': 'barbell_floor_press',
        '4': 'close_grip_barbell_bench_press',
        '5': 'decline_dumbbell_bench_press',
        '6': 'dumbbell_bench_press',
        '7': 'dumbbell_floor_press',
        '8': 'incline_barbell_bench_press',
        '9': 'incline_dumbbell_bench_press',
        '10': 'incline_smith_machine_bench_press',
        '11': 'isometric_barbell_bench_press',
        '12': 'kettlebell_chest_press',
        '13': 'neutral_grip_dumbbell_bench_press',
        '14': 'neutral_grip_dumbbell_incline_bench_press',
        '15': 'one_arm_floor_press',
        '16': 'weighted_one_arm_floor_press',
        '17': 'partial_lockout',
        '18': 'reverse_grip_barbell_bench_press',
        '19': 'reverse_grip_incline_bench_press',
        '20': 'single_arm_cable_chest_press',
        '21': 'single_arm_dumbbell_bench_press',
        '22': 'smith_machine_bench_press',
        '23': 'swiss_ball_dumbbell_chest_press',
        '24': 'triple_stop_barbell_bench_press',
        '25': 'wide_grip_barbell_bench_press',
        '26': 'alternating_dumbbell_chest_press',
        },
    'calf_raise_exercise_name': {
        '0': '3_way_calf_raise',
        '1': '3_way_weighted_calf_raise',
        '2': '3_way_single_leg_calf_raise',
        '3': '3_way_weighted_single_leg_calf_raise',
        '4': 'donkey_calf_raise',
        '5': 'weighted_donkey_calf_raise',
        '6': 'seated_calf_raise',
        '7': 'weighted_seated_calf_raise',
        '8': 'seated_dumbbell_toe_raise',
        '9': 'single_leg_bent_knee_calf_raise',
        '10': 'weighted_single_leg_bent_knee_calf_raise',
        '11': 'single_leg_decline_push_up',
        '12': 'single_leg_donkey_calf_raise',
        '13': 'weighted_single_leg_donkey_calf_raise',
        '14': 'single_leg_hip_raise_with_knee_hold',
        '15': 'single_leg_standing_calf_raise',
        '16': 'single_leg_standing_dumbbell_calf_raise',
        '17': 'standing_barbell_calf_raise',
        '18': 'standing_calf_raise',
        '19': 'weighted_standing_calf_raise',
        '20': 'standing_dumbbell_calf_raise',
        },
    'cardio_exercise_name': {
        '0': 'bob_and_weave_circle',
        '1': 'weighted_bob_and_weave_circle',
        '2': 'cardio_core_crawl',
        '3': 'weighted_cardio_core_crawl',
        '4': 'double_under',
        '5': 'weighted_double_under',
        '6': 'jump_rope',
        '7': 'weighted_jump_rope',
        '8': 'jump_rope_crossover',
        '9': 'weighted_jump_rope_crossover',
        '10': 'jump_rope_jog',
        '11': 'weighted_jump_rope_jog',
        '12': 'jumping_jacks',
        '13': 'weighted_jumping_jacks',
        '14': 'ski_moguls',
        '15': 'weighted_ski_moguls',
        '16': 'split_jacks',
        '17': 'weighted_split_jacks',
        '18': 'squat_jacks',
        '19': 'weighted_squat_jacks',
        '20': 'triple_under',
        '21': 'weighted_triple_under',
        },
    'carry_exercise_name': {
        '0': 'bar_holds',
        '1': 'farmers_walk',
        '2': 'farmers_walk_on_toes',
        '3': 'hex_dumbbell_hold',
        '4': 'overhead_carry',
        },
    'chop_exercise_name': {
        '0': 'cable_pull_through',
        '1': 'cable_rotational_lift',
        '2': 'cable_woodchop',
        '3': 'cross_chop_to_knee',
        '4': 'weighted_cross_chop_to_knee',
        '5': 'dumbbell_chop',
        '6': 'half_kneeling_rotation',
        '7': 'weighted_half_kneeling_rotation',
        '8': 'half_kneeling_rotational_chop',
        '9': 'half_kneeling_rotational_reverse_chop',
        '10': 'half_kneeling_stability_chop',
        '11': 'half_kneeling_stability_reverse_chop',
        '12': 'kneeling_rotational_chop',
        '13': 'kneeling_rotational_reverse_chop',
        '14': 'kneeling_stability_chop',
        '15': 'kneeling_woodchopper',
        '16': 'medicine_ball_wood_chops',
        '17': 'power_squat_chops',
        '18': 'weighted_power_squat_chops',
        '19': 'standing_rotational_chop',
        '20': 'standing_split_rotational_chop',
        '21': 'standing_split_rotational_reverse_chop',
        '22': 'standing_stability_reverse_chop',
        },
    'core_exercise_name': {
        '0': 'abs_jabs',
        '1': 'weighted_abs_jabs',
        '2': 'alternating_plate_reach',
        '3': 'barbell_rollout',
        '4': 'weighted_barbell_rollout',
        '5': 'body_bar_oblique_twist',
        '6': 'cable_core_press',
        '7': 'cable_side_bend',
        '8': 'side_bend',
        '9': 'weighted_side_bend',
        '10': 'crescent_circle',
        '11': 'weighted_crescent_circle',
        '12': 'cycling_russian_twist',
        '13': 'weighted_cycling_russian_twist',
        '14': 'elevated_feet_russian_twist',
        '15': 'weighted_elevated_feet_russian_twist',
        '16': 'half_turkish_get_up',
        '17': 'kettlebell_windmill',
        '18': 'kneeling_ab_wheel',
        '19': 'weighted_kneeling_ab_wheel',
        '20': 'modified_front_lever',
        '21': 'open_knee_tucks',
        '22': 'weighted_open_knee_tucks',
        '23': 'side_abs_leg_lift',
        '24': 'weighted_side_abs_leg_lift',
        '25': 'swiss_ball_jackknife',
        '26': 'weighted_swiss_ball_jackknife',
        '27': 'swiss_ball_pike',
        '28': 'weighted_swiss_ball_pike',
        '29': 'swiss_ball_rollout',
        '30': 'weighted_swiss_ball_rollout',
        '31': 'triangle_hip_press',
        '32': 'weighted_triangle_hip_press',
        '33': 'trx_suspended_jackknife',
        '34': 'weighted_trx_suspended_jackknife',
        '35': 'u_boat',
        '36': 'weighted_u_boat',
        '37': 'windmill_switches',
        '38': 'weighted_windmill_switches',
        '39': 'alternating_slide_out',
        '40': 'weighted_alternating_slide_out',
        '41': 'ghd_back_extensions',
        '42': 'weighted_ghd_back_extensions',
        '43': 'overhead_walk',
        '44': 'inchworm',
        '45': 'weighted_modified_front_lever',
        '46': 'russian_twist',
        '47': 'abdominal_leg_rotations', # Deprecated do not use
        '48': 'arm_and_leg_extension_on_knees',
        '49': 'bicycle',
        '50': 'bicep_curl_with_leg_extension',
        '51': 'cat_cow',
        '52': 'corkscrew',
        '53': 'criss_cross',
        '54': 'criss_cross_with_ball', # Deprecated do not use
        '55': 'double_leg_stretch',
        '56': 'knee_folds',
        '57': 'lower_lift',
        '58': 'neck_pull',
        '59': 'pelvic_clocks',
        '60': 'roll_over',
        '61': 'roll_up',
        '62': 'rolling',
        '63': 'rowing_1',
        '64': 'rowing_2',
        '65': 'scissors',
        '66': 'single_leg_circles',
        '67': 'single_leg_stretch',
        '68': 'snake_twist_1_and_2', # Deprecated do not use
        '69': 'swan',
        '70': 'swimming',
        '71': 'teaser',
        '72': 'the_hundred',
        },
    'crunch_exercise_name': {
        '0': 'bicycle_crunch',
        '1': 'cable_crunch',
        '2': 'circular_arm_crunch',
        '3': 'crossed_arms_crunch',
        '4': 'weighted_crossed_arms_crunch',
        '5': 'cross_leg_reverse_crunch',
        '6': 'weighted_cross_leg_reverse_crunch',
        '7': 'crunch_chop',
        '8': 'weighted_crunch_chop',
        '9': 'double_crunch',
        '10': 'weighted_double_crunch',
        '11': 'elbow_to_knee_crunch',
        '12': 'weighted_elbow_to_knee_crunch',
        '13': 'flutter_kicks',
        '14': 'weighted_flutter_kicks',
        '15': 'foam_roller_reverse_crunch_on_bench',
        '16': 'weighted_foam_roller_reverse_crunch_on_bench',
        '17': 'foam_roller_reverse_crunch_with_dumbbell',
        '18': 'foam_roller_reverse_crunch_with_medicine_ball',
        '19': 'frog_press',
        '20': 'hanging_knee_raise_oblique_crunch',
        '21': 'weighted_hanging_knee_raise_oblique_crunch',
        '22': 'hip_crossover',
        '23': 'weighted_hip_crossover',
        '24': 'hollow_rock',
        '25': 'weighted_hollow_rock',
        '26': 'incline_reverse_crunch',
        '27': 'weighted_incline_reverse_crunch',
        '28': 'kneeling_cable_crunch',
        '29': 'kneeling_cross_crunch',
        '30': 'weighted_kneeling_cross_crunch',
        '31': 'kneeling_oblique_cable_crunch',
        '32': 'knees_to_elbow',
        '33': 'leg_extensions',
        '34': 'weighted_leg_extensions',
        '35': 'leg_levers',
        '36': 'mcgill_curl_up',
        '37': 'weighted_mcgill_curl_up',
        '38': 'modified_pilates_roll_up_with_ball',
        '39': 'weighted_modified_pilates_roll_up_with_ball',
        '40': 'pilates_crunch',
        '41': 'weighted_pilates_crunch',
        '42': 'pilates_roll_up_with_ball',
        '43': 'weighted_pilates_roll_up_with_ball',
        '44': 'raised_legs_crunch',
        '45': 'weighted_raised_legs_crunch',
        '46': 'reverse_crunch',
        '47': 'weighted_reverse_crunch',
        '48': 'reverse_crunch_on_a_bench',
        '49': 'weighted_reverse_crunch_on_a_bench',
        '50': 'reverse_curl_and_lift',
        '51': 'weighted_reverse_curl_and_lift',
        '52': 'rotational_lift',
        '53': 'weighted_rotational_lift',
        '54': 'seated_alternating_reverse_crunch',
        '55': 'weighted_seated_alternating_reverse_crunch',
        '56': 'seated_leg_u',
        '57': 'weighted_seated_leg_u',
        '58': 'side_to_side_crunch_and_weave',
        '59': 'weighted_side_to_side_crunch_and_weave',
        '60': 'single_leg_reverse_crunch',
        '61': 'weighted_single_leg_reverse_crunch',
        '62': 'skater_crunch_cross',
        '63': 'weighted_skater_crunch_cross',
        '64': 'standing_cable_crunch',
        '65': 'standing_side_crunch',
        '66': 'step_climb',
        '67': 'weighted_step_climb',
        '68': 'swiss_ball_crunch',
        '69': 'swiss_ball_reverse_crunch',
        '70': 'weighted_swiss_ball_reverse_crunch',
        '71': 'swiss_ball_russian_twist',
        '72': 'weighted_swiss_ball_russian_twist',
        '73': 'swiss_ball_side_crunch',
        '74': 'weighted_swiss_ball_side_crunch',
        '75': 'thoracic_crunches_on_foam_roller',
        '76': 'weighted_thoracic_crunches_on_foam_roller',
        '77': 'triceps_crunch',
        '78': 'weighted_bicycle_crunch',
        '79': 'weighted_crunch',
        '80': 'weighted_swiss_ball_crunch',
        '81': 'toes_to_bar',
        '82': 'weighted_toes_to_bar',
        '83': 'crunch',
        '84': 'straight_leg_crunch_with_ball',
        },
    'curl_exercise_name': {
        '0': 'alternating_dumbbell_biceps_curl',
        '1': 'alternating_dumbbell_biceps_curl_on_swiss_ball',
        '2': 'alternating_incline_dumbbell_biceps_curl',
        '3': 'barbell_biceps_curl',
        '4': 'barbell_reverse_wrist_curl',
        '5': 'barbell_wrist_curl',
        '6': 'behind_the_back_barbell_reverse_wrist_curl',
        '7': 'behind_the_back_one_arm_cable_curl',
        '8': 'cable_biceps_curl',
        '9': 'cable_hammer_curl',
        '10': 'cheating_barbell_biceps_curl',
        '11': 'close_grip_ez_bar_biceps_curl',
        '12': 'cross_body_dumbbell_hammer_curl',
        '13': 'dead_hang_biceps_curl',
        '14': 'decline_hammer_curl',
        '15': 'dumbbell_biceps_curl_with_static_hold',
        '16': 'dumbbell_hammer_curl',
        '17': 'dumbbell_reverse_wrist_curl',
        '18': 'dumbbell_wrist_curl',
        '19': 'ez_bar_preacher_curl',
        '20': 'forward_bend_biceps_curl',
        '21': 'hammer_curl_to_press',
        '22': 'incline_dumbbell_biceps_curl',
        '23': 'incline_offset_thumb_dumbbell_curl',
        '24': 'kettlebell_biceps_curl',
        '25': 'lying_concentration_cable_curl',
        '26': 'one_arm_preacher_curl',
        '27': 'plate_pinch_curl',
        '28': 'preacher_curl_with_cable',
        '29': 'reverse_ez_bar_curl',
        '30': 'reverse_grip_wrist_curl',
        '31': 'reverse_grip_barbell_biceps_curl',
        '32': 'seated_alternating_dumbbell_biceps_curl',
        '33': 'seated_dumbbell_biceps_curl',
        '34': 'seated_reverse_dumbbell_curl',
        '35': 'split_stance_offset_pinky_dumbbell_curl',
        '36': 'standing_alternating_dumbbell_curls',
        '37': 'standing_dumbbell_biceps_curl',
        '38': 'standing_ez_bar_biceps_curl',
        '39': 'static_curl',
        '40': 'swiss_ball_dumbbell_overhead_triceps_extension',
        '41': 'swiss_ball_ez_bar_preacher_curl',
        '42': 'twisting_standing_dumbbell_biceps_curl',
        '43': 'wide_grip_ez_bar_biceps_curl',
        },
    'deadlift_exercise_name': {
        '0': 'barbell_deadlift',
        '1': 'barbell_straight_leg_deadlift',
        '2': 'dumbbell_deadlift',
        '3': 'dumbbell_single_leg_deadlift_to_row',
        '4': 'dumbbell_straight_leg_deadlift',
        '5': 'kettlebell_floor_to_shelf',
        '6': 'one_arm_one_leg_deadlift',
        '7': 'rack_pull',
        '8': 'rotational_dumbbell_straight_leg_deadlift',
        '9': 'single_arm_deadlift',
        '10': 'single_leg_barbell_deadlift',
        '11': 'single_leg_barbell_straight_leg_deadlift',
        '12': 'single_leg_deadlift_with_barbell',
        '13': 'single_leg_rdl_circuit',
        '14': 'single_leg_romanian_deadlift_with_dumbbell',
        '15': 'sumo_deadlift',
        '16': 'sumo_deadlift_high_pull',
        '17': 'trap_bar_deadlift',
        '18': 'wide_grip_barbell_deadlift',
        },
    'flye_exercise_name': {
        '0': 'cable_crossover',
        '1': 'decline_dumbbell_flye',
        '2': 'dumbbell_flye',
        '3': 'incline_dumbbell_flye',
        '4': 'kettlebell_flye',
        '5': 'kneeling_rear_flye',
        '6': 'single_arm_standing_cable_reverse_flye',
        '7': 'swiss_ball_dumbbell_flye',
        '8': 'arm_rotations',
        '9': 'hug_a_tree',
        },
    'hip_raise_exercise_name': {
        '0': 'barbell_hip_thrust_on_floor',
        '1': 'barbell_hip_thrust_with_bench',
        '2': 'bent_knee_swiss_ball_reverse_hip_raise',
        '3': 'weighted_bent_knee_swiss_ball_reverse_hip_raise',
        '4': 'bridge_with_leg_extension',
        '5': 'weighted_bridge_with_leg_extension',
        '6': 'clam_bridge',
        '7': 'front_kick_tabletop',
        '8': 'weighted_front_kick_tabletop',
        '9': 'hip_extension_and_cross',
        '10': 'weighted_hip_extension_and_cross',
        '11': 'hip_raise',
        '12': 'weighted_hip_raise',
        '13': 'hip_raise_with_feet_on_swiss_ball',
        '14': 'weighted_hip_raise_with_feet_on_swiss_ball',
        '15': 'hip_raise_with_head_on_bosu_ball',
        '16': 'weighted_hip_raise_with_head_on_bosu_ball',
        '17': 'hip_raise_with_head_on_swiss_ball',
        '18': 'weighted_hip_raise_with_head_on_swiss_ball',
        '19': 'hip_raise_with_knee_squeeze',
        '20': 'weighted_hip_raise_with_knee_squeeze',
        '21': 'incline_rear_leg_extension',
        '22': 'weighted_incline_rear_leg_extension',
        '23': 'kettlebell_swing',
        '24': 'marching_hip_raise',
        '25': 'weighted_marching_hip_raise',
        '26': 'marching_hip_raise_with_feet_on_a_swiss_ball',
        '27': 'weighted_marching_hip_raise_with_feet_on_a_swiss_ball',
        '28': 'reverse_hip_raise',
        '29': 'weighted_reverse_hip_raise',
        '30': 'single_leg_hip_raise',
        '31': 'weighted_single_leg_hip_raise',
        '32': 'single_leg_hip_raise_with_foot_on_bench',
        '33': 'weighted_single_leg_hip_raise_with_foot_on_bench',
        '34': 'single_leg_hip_raise_with_foot_on_bosu_ball',
        '35': 'weighted_single_leg_hip_raise_with_foot_on_bosu_ball',
        '36': 'single_leg_hip_raise_with_foot_on_foam_roller',
        '37': 'weighted_single_leg_hip_raise_with_foot_on_foam_roller',
        '38': 'single_leg_hip_raise_with_foot_on_medicine_ball',
        '39': 'weighted_single_leg_hip_raise_with_foot_on_medicine_ball',
        '40': 'single_leg_hip_raise_with_head_on_bosu_ball',
        '41': 'weighted_single_leg_hip_raise_with_head_on_bosu_ball',
        '42': 'weighted_clam_bridge',
        '43': 'single_leg_swiss_ball_hip_raise_and_leg_curl',
        '44': 'clams',
        '45': 'inner_thigh_circles', # Deprecated do not use
        '46': 'inner_thigh_side_lift', # Deprecated do not use
        '47': 'leg_circles',
        '48': 'leg_lift',
        '49': 'leg_lift_in_external_rotation',
        },
    'hip_stability_exercise_name': {
        '0': 'band_side_lying_leg_raise',
        '1': 'dead_bug',
        '2': 'weighted_dead_bug',
        '3': 'external_hip_raise',
        '4': 'weighted_external_hip_raise',
        '5': 'fire_hydrant_kicks',
        '6': 'weighted_fire_hydrant_kicks',
        '7': 'hip_circles',
        '8': 'weighted_hip_circles',
        '9': 'inner_thigh_lift',
        '10': 'weighted_inner_thigh_lift',
        '11': 'lateral_walks_with_band_at_ankles',
        '12': 'pretzel_side_kick',
        '13': 'weighted_pretzel_side_kick',
        '14': 'prone_hip_internal_rotation',
        '15': 'weighted_prone_hip_internal_rotation',
        '16': 'quadruped',
        '17': 'quadruped_hip_extension',
        '18': 'weighted_quadruped_hip_extension',
        '19': 'quadruped_with_leg_lift',
        '20': 'weighted_quadruped_with_leg_lift',
        '21': 'side_lying_leg_raise',
        '22': 'weighted_side_lying_leg_raise',
        '23': 'sliding_hip_adduction',
        '24': 'weighted_sliding_hip_adduction',
        '25': 'standing_adduction',
        '26': 'weighted_standing_adduction',
        '27': 'standing_cable_hip_abduction',
        '28': 'standing_hip_abduction',
        '29': 'weighted_standing_hip_abduction',
        '30': 'standing_rear_leg_raise',
        '31': 'weighted_standing_rear_leg_raise',
        '32': 'supine_hip_internal_rotation',
        '33': 'weighted_supine_hip_internal_rotation',
        },
    'hip_swing_exercise_name': {
        '0': 'single_arm_kettlebell_swing',
        '1': 'single_arm_dumbbell_swing',
        '2': 'step_out_swing',
        },
    'hyperextension_exercise_name': {
        '0': 'back_extension_with_opposite_arm_and_leg_reach',
        '1': 'weighted_back_extension_with_opposite_arm_and_leg_reach',
        '2': 'base_rotations',
        '3': 'weighted_base_rotations',
        '4': 'bent_knee_reverse_hyperextension',
        '5': 'weighted_bent_knee_reverse_hyperextension',
        '6': 'hollow_hold_and_roll',
        '7': 'weighted_hollow_hold_and_roll',
        '8': 'kicks',
        '9': 'weighted_kicks',
        '10': 'knee_raises',
        '11': 'weighted_knee_raises',
        '12': 'kneeling_superman',
        '13': 'weighted_kneeling_superman',
        '14': 'lat_pull_down_with_row',
        '15': 'medicine_ball_deadlift_to_reach',
        '16': 'one_arm_one_leg_row',
        '17': 'one_arm_row_with_band',
        '18': 'overhead_lunge_with_medicine_ball',
        '19': 'plank_knee_tucks',
        '20': 'weighted_plank_knee_tucks',
        '21': 'side_step',
        '22': 'weighted_side_step',
        '23': 'single_leg_back_extension',
        '24': 'weighted_single_leg_back_extension',
        '25': 'spine_extension',
        '26': 'weighted_spine_extension',
        '27': 'static_back_extension',
        '28': 'weighted_static_back_extension',
        '29': 'superman_from_floor',
        '30': 'weighted_superman_from_floor',
        '31': 'swiss_ball_back_extension',
        '32': 'weighted_swiss_ball_back_extension',
        '33': 'swiss_ball_hyperextension',
        '34': 'weighted_swiss_ball_hyperextension',
        '35': 'swiss_ball_opposite_arm_and_leg_lift',
        '36': 'weighted_swiss_ball_opposite_arm_and_leg_lift',
        '37': 'superman_on_swiss_ball',
        '38': 'cobra',
        '39': 'supine_floor_barre', # Deprecated do not use
        },
    'lateral_raise_exercise_name': {
        '0': '45_degree_cable_external_rotation',
        '1': 'alternating_lateral_raise_with_static_hold',
        '2': 'bar_muscle_up',
        '3': 'bent_over_lateral_raise',
        '4': 'cable_diagonal_raise',
        '5': 'cable_front_raise',
        '6': 'calorie_row',
        '7': 'combo_shoulder_raise',
        '8': 'dumbbell_diagonal_raise',
        '9': 'dumbbell_v_raise',
        '10': 'front_raise',
        '11': 'leaning_dumbbell_lateral_raise',
        '12': 'lying_dumbbell_raise',
        '13': 'muscle_up',
        '14': 'one_arm_cable_lateral_raise',
        '15': 'overhand_grip_rear_lateral_raise',
        '16': 'plate_raises',
        '17': 'ring_dip',
        '18': 'weighted_ring_dip',
        '19': 'ring_muscle_up',
        '20': 'weighted_ring_muscle_up',
        '21': 'rope_climb',
        '22': 'weighted_rope_climb',
        '23': 'scaption',
        '24': 'seated_lateral_raise',
        '25': 'seated_rear_lateral_raise',
        '26': 'side_lying_lateral_raise',
        '27': 'standing_lift',
        '28': 'suspended_row',
        '29': 'underhand_grip_rear_lateral_raise',
        '30': 'wall_slide',
        '31': 'weighted_wall_slide',
        '32': 'arm_circles',
        '33': 'shaving_the_head',
        },
    'leg_curl_exercise_name': {
        '0': 'leg_curl',
        '1': 'weighted_leg_curl',
        '2': 'good_morning',
        '3': 'seated_barbell_good_morning',
        '4': 'single_leg_barbell_good_morning',
        '5': 'single_leg_sliding_leg_curl',
        '6': 'sliding_leg_curl',
        '7': 'split_barbell_good_morning',
        '8': 'split_stance_extension',
        '9': 'staggered_stance_good_morning',
        '10': 'swiss_ball_hip_raise_and_leg_curl',
        '11': 'zercher_good_morning',
        },
    'leg_raise_exercise_name': {
        '0': 'hanging_knee_raise',
        '1': 'hanging_leg_raise',
        '2': 'weighted_hanging_leg_raise',
        '3': 'hanging_single_leg_raise',
        '4': 'weighted_hanging_single_leg_raise',
        '5': 'kettlebell_leg_raises',
        '6': 'leg_lowering_drill',
        '7': 'weighted_leg_lowering_drill',
        '8': 'lying_straight_leg_raise',
        '9': 'weighted_lying_straight_leg_raise',
        '10': 'medicine_ball_leg_drops',
        '11': 'quadruped_leg_raise',
        '12': 'weighted_quadruped_leg_raise',
        '13': 'reverse_leg_raise',
        '14': 'weighted_reverse_leg_raise',
        '15': 'reverse_leg_raise_on_swiss_ball',
        '16': 'weighted_reverse_leg_raise_on_swiss_ball',
        '17': 'single_leg_lowering_drill',
        '18': 'weighted_single_leg_lowering_drill',
        '19': 'weighted_hanging_knee_raise',
        '20': 'lateral_stepover',
        '21': 'weighted_lateral_stepover',
        },
    'lunge_exercise_name': {
        '0': 'overhead_lunge',
        '1': 'lunge_matrix',
        '2': 'weighted_lunge_matrix',
        '3': 'alternating_barbell_forward_lunge',
        '4': 'alternating_dumbbell_lunge_with_reach',
        '5': 'back_foot_elevated_dumbbell_split_squat',
        '6': 'barbell_box_lunge',
        '7': 'barbell_bulgarian_split_squat',
        '8': 'barbell_crossover_lunge',
        '9': 'barbell_front_split_squat',
        '10': 'barbell_lunge',
        '11': 'barbell_reverse_lunge',
        '12': 'barbell_side_lunge',
        '13': 'barbell_split_squat',
        '14': 'core_control_rear_lunge',
        '15': 'diagonal_lunge',
        '16': 'drop_lunge',
        '17': 'dumbbell_box_lunge',
        '18': 'dumbbell_bulgarian_split_squat',
        '19': 'dumbbell_crossover_lunge',
        '20': 'dumbbell_diagonal_lunge',
        '21': 'dumbbell_lunge',
        '22': 'dumbbell_lunge_and_rotation',
        '23': 'dumbbell_overhead_bulgarian_split_squat',
        '24': 'dumbbell_reverse_lunge_to_high_knee_and_press',
        '25': 'dumbbell_side_lunge',
        '26': 'elevated_front_foot_barbell_split_squat',
        '27': 'front_foot_elevated_dumbbell_split_squat',
        '28': 'gunslinger_lunge',
        '29': 'lawnmower_lunge',
        '30': 'low_lunge_with_isometric_adduction',
        '31': 'low_side_to_side_lunge',
        '32': 'lunge',
        '33': 'weighted_lunge',
        '34': 'lunge_with_arm_reach',
        '35': 'lunge_with_diagonal_reach',
        '36': 'lunge_with_side_bend',
        '37': 'offset_dumbbell_lunge',
        '38': 'offset_dumbbell_reverse_lunge',
        '39': 'overhead_bulgarian_split_squat',
        '40': 'overhead_dumbbell_reverse_lunge',
        '41': 'overhead_dumbbell_split_squat',
        '42': 'overhead_lunge_with_rotation',
        '43': 'reverse_barbell_box_lunge',
        '44': 'reverse_box_lunge',
        '45': 'reverse_dumbbell_box_lunge',
        '46': 'reverse_dumbbell_crossover_lunge',
        '47': 'reverse_dumbbell_diagonal_lunge',
        '48': 'reverse_lunge_with_reach_back',
        '49': 'weighted_reverse_lunge_with_reach_back',
        '50': 'reverse_lunge_with_twist_and_overhead_reach',
        '51': 'weighted_reverse_lunge_with_twist_and_overhead_reach',
        '52': 'reverse_sliding_box_lunge',
        '53': 'weighted_reverse_sliding_box_lunge',
        '54': 'reverse_sliding_lunge',
        '55': 'weighted_reverse_sliding_lunge',
        '56': 'runners_lunge_to_balance',
        '57': 'weighted_runners_lunge_to_balance',
        '58': 'shifting_side_lunge',
        '59': 'side_and_crossover_lunge',
        '60': 'weighted_side_and_crossover_lunge',
        '61': 'side_lunge',
        '62': 'weighted_side_lunge',
        '63': 'side_lunge_and_press',
        '64': 'side_lunge_jump_off',
        '65': 'side_lunge_sweep',
        '66': 'weighted_side_lunge_sweep',
        '67': 'side_lunge_to_crossover_tap',
        '68': 'weighted_side_lunge_to_crossover_tap',
        '69': 'side_to_side_lunge_chops',
        '70': 'weighted_side_to_side_lunge_chops',
        '71': 'siff_jump_lunge',
        '72': 'weighted_siff_jump_lunge',
        '73': 'single_arm_reverse_lunge_and_press',
        '74': 'sliding_lateral_lunge',
        '75': 'weighted_sliding_lateral_lunge',
        '76': 'walking_barbell_lunge',
        '77': 'walking_dumbbell_lunge',
        '78': 'walking_lunge',
        '79': 'weighted_walking_lunge',
        '80': 'wide_grip_overhead_barbell_split_squat',
        },
    'olympic_lift_exercise_name': {
        '0': 'barbell_hang_power_clean',
        '1': 'barbell_hang_squat_clean',
        '2': 'barbell_power_clean',
        '3': 'barbell_power_snatch',
        '4': 'barbell_squat_clean',
        '5': 'clean_and_jerk',
        '6': 'barbell_hang_power_snatch',
        '7': 'barbell_hang_pull',
        '8': 'barbell_high_pull',
        '9': 'barbell_snatch',
        '10': 'barbell_split_jerk',
        '11': 'clean',
        '12': 'dumbbell_clean',
        '13': 'dumbbell_hang_pull',
        '14': 'one_hand_dumbbell_split_snatch',
        '15': 'push_jerk',
        '16': 'single_arm_dumbbell_snatch',
        '17': 'single_arm_hang_snatch',
        '18': 'single_arm_kettlebell_snatch',
        '19': 'split_jerk',
        '20': 'squat_clean_and_jerk',
        },
    'plank_exercise_name': {
        '0': '45_degree_plank',
        '1': 'weighted_45_degree_plank',
        '2': '90_degree_static_hold',
        '3': 'weighted_90_degree_static_hold',
        '4': 'bear_crawl',
        '5': 'weighted_bear_crawl',
        '6': 'cross_body_mountain_climber',
        '7': 'weighted_cross_body_mountain_climber',
        '8': 'elbow_plank_pike_jacks',
        '9': 'weighted_elbow_plank_pike_jacks',
        '10': 'elevated_feet_plank',
        '11': 'weighted_elevated_feet_plank',
        '12': 'elevator_abs',
        '13': 'weighted_elevator_abs',
        '14': 'extended_plank',
        '15': 'weighted_extended_plank',
        '16': 'full_plank_passe_twist',
        '17': 'weighted_full_plank_passe_twist',
        '18': 'inching_elbow_plank',
        '19': 'weighted_inching_elbow_plank',
        '20': 'inchworm_to_side_plank',
        '21': 'weighted_inchworm_to_side_plank',
        '22': 'kneeling_plank',
        '23': 'weighted_kneeling_plank',
        '24': 'kneeling_side_plank_with_leg_lift',
        '25': 'weighted_kneeling_side_plank_with_leg_lift',
        '26': 'lateral_roll',
        '27': 'weighted_lateral_roll',
        '28': 'lying_reverse_plank',
        '29': 'weighted_lying_reverse_plank',
        '30': 'medicine_ball_mountain_climber',
        '31': 'weighted_medicine_ball_mountain_climber',
        '32': 'modified_mountain_climber_and_extension',
        '33': 'weighted_modified_mountain_climber_and_extension',
        '34': 'mountain_climber',
        '35': 'weighted_mountain_climber',
        '36': 'mountain_climber_on_sliding_discs',
        '37': 'weighted_mountain_climber_on_sliding_discs',
        '38': 'mountain_climber_with_feet_on_bosu_ball',
        '39': 'weighted_mountain_climber_with_feet_on_bosu_ball',
        '40': 'mountain_climber_with_hands_on_bench',
        '41': 'mountain_climber_with_hands_on_swiss_ball',
        '42': 'weighted_mountain_climber_with_hands_on_swiss_ball',
        '43': 'plank',
        '44': 'plank_jacks_with_feet_on_sliding_discs',
        '45': 'weighted_plank_jacks_with_feet_on_sliding_discs',
        '46': 'plank_knee_twist',
        '47': 'weighted_plank_knee_twist',
        '48': 'plank_pike_jumps',
        '49': 'weighted_plank_pike_jumps',
        '50': 'plank_pikes',
        '51': 'weighted_plank_pikes',
        '52': 'plank_to_stand_up',
        '53': 'weighted_plank_to_stand_up',
        '54': 'plank_with_arm_raise',
        '55': 'weighted_plank_with_arm_raise',
        '56': 'plank_with_knee_to_elbow',
        '57': 'weighted_plank_with_knee_to_elbow',
        '58': 'plank_with_oblique_crunch',
        '59': 'weighted_plank_with_oblique_crunch',
        '60': 'plyometric_side_plank',
        '61': 'weighted_plyometric_side_plank',
        '62': 'rolling_side_plank',
        '63': 'weighted_rolling_side_plank',
        '64': 'side_kick_plank',
        '65': 'weighted_side_kick_plank',
        '66': 'side_plank',
        '67': 'weighted_side_plank',
        '68': 'side_plank_and_row',
        '69': 'weighted_side_plank_and_row',
        '70': 'side_plank_lift',
        '71': 'weighted_side_plank_lift',
        '72': 'side_plank_with_elbow_on_bosu_ball',
        '73': 'weighted_side_plank_with_elbow_on_bosu_ball',
        '74': 'side_plank_with_feet_on_bench',
        '75': 'weighted_side_plank_with_feet_on_bench',
        '76': 'side_plank_with_knee_circle',
        '77': 'weighted_side_plank_with_knee_circle',
        '78': 'side_plank_with_knee_tuck',
        '79': 'weighted_side_plank_with_knee_tuck',
        '80': 'side_plank_with_leg_lift',
        '81': 'weighted_side_plank_with_leg_lift',
        '82': 'side_plank_with_reach_under',
        '83': 'weighted_side_plank_with_reach_under',
        '84': 'single_leg_elevated_feet_plank',
        '85': 'weighted_single_leg_elevated_feet_plank',
        '86': 'single_leg_flex_and_extend',
        '87': 'weighted_single_leg_flex_and_extend',
        '88': 'single_leg_side_plank',
        '89': 'weighted_single_leg_side_plank',
        '90': 'spiderman_plank',
        '91': 'weighted_spiderman_plank',
        '92': 'straight_arm_plank',
        '93': 'weighted_straight_arm_plank',
        '94': 'straight_arm_plank_with_shoulder_touch',
        '95': 'weighted_straight_arm_plank_with_shoulder_touch',
        '96': 'swiss_ball_plank',
        '97': 'weighted_swiss_ball_plank',
        '98': 'swiss_ball_plank_leg_lift',
        '99': 'weighted_swiss_ball_plank_leg_lift',
        '100': 'swiss_ball_plank_leg_lift_and_hold',
        '101': 'swiss_ball_plank_with_feet_on_bench',
        '102': 'weighted_swiss_ball_plank_with_feet_on_bench',
        '103': 'swiss_ball_prone_jackknife',
        '104': 'weighted_swiss_ball_prone_jackknife',
        '105': 'swiss_ball_side_plank',
        '106': 'weighted_swiss_ball_side_plank',
        '107': 'three_way_plank',
        '108': 'weighted_three_way_plank',
        '109': 'towel_plank_and_knee_in',
        '110': 'weighted_towel_plank_and_knee_in',
        '111': 't_stabilization',
        '112': 'weighted_t_stabilization',
        '113': 'turkish_get_up_to_side_plank',
        '114': 'weighted_turkish_get_up_to_side_plank',
        '115': 'two_point_plank',
        '116': 'weighted_two_point_plank',
        '117': 'weighted_plank',
        '118': 'wide_stance_plank_with_diagonal_arm_lift',
        '119': 'weighted_wide_stance_plank_with_diagonal_arm_lift',
        '120': 'wide_stance_plank_with_diagonal_leg_lift',
        '121': 'weighted_wide_stance_plank_with_diagonal_leg_lift',
        '122': 'wide_stance_plank_with_leg_lift',
        '123': 'weighted_wide_stance_plank_with_leg_lift',
        '124': 'wide_stance_plank_with_opposite_arm_and_leg_lift',
        '125': 'weighted_mountain_climber_with_hands_on_bench',
        '126': 'weighted_swiss_ball_plank_leg_lift_and_hold',
        '127': 'weighted_wide_stance_plank_with_opposite_arm_and_leg_lift',
        '128': 'plank_with_feet_on_swiss_ball',
        '129': 'side_plank_to_plank_with_reach_under',
        '130': 'bridge_with_glute_lower_lift',
        '131': 'bridge_one_leg_bridge',
        '132': 'plank_with_arm_variations',
        '133': 'plank_with_leg_lift',
        '134': 'reverse_plank_with_leg_pull',
        },
    'plyo_exercise_name': {
        '0': 'alternating_jump_lunge',
        '1': 'weighted_alternating_jump_lunge',
        '2': 'barbell_jump_squat',
        '3': 'body_weight_jump_squat',
        '4': 'weighted_jump_squat',
        '5': 'cross_knee_strike',
        '6': 'weighted_cross_knee_strike',
        '7': 'depth_jump',
        '8': 'weighted_depth_jump',
        '9': 'dumbbell_jump_squat',
        '10': 'dumbbell_split_jump',
        '11': 'front_knee_strike',
        '12': 'weighted_front_knee_strike',
        '13': 'high_box_jump',
        '14': 'weighted_high_box_jump',
        '15': 'isometric_explosive_body_weight_jump_squat',
        '16': 'weighted_isometric_explosive_jump_squat',
        '17': 'lateral_leap_and_hop',
        '18': 'weighted_lateral_leap_and_hop',
        '19': 'lateral_plyo_squats',
        '20': 'weighted_lateral_plyo_squats',
        '21': 'lateral_slide',
        '22': 'weighted_lateral_slide',
        '23': 'medicine_ball_overhead_throws',
        '24': 'medicine_ball_side_throw',
        '25': 'medicine_ball_slam',
        '26': 'side_to_side_medicine_ball_throws',
        '27': 'side_to_side_shuffle_jump',
        '28': 'weighted_side_to_side_shuffle_jump',
        '29': 'squat_jump_onto_box',
        '30': 'weighted_squat_jump_onto_box',
        '31': 'squat_jumps_in_and_out',
        '32': 'weighted_squat_jumps_in_and_out',
        },
    'pull_up_exercise_name': {
        '0': 'banded_pull_ups',
        '1': '30_degree_lat_pulldown',
        '2': 'band_assisted_chin_up',
        '3': 'close_grip_chin_up',
        '4': 'weighted_close_grip_chin_up',
        '5': 'close_grip_lat_pulldown',
        '6': 'crossover_chin_up',
        '7': 'weighted_crossover_chin_up',
        '8': 'ez_bar_pullover',
        '9': 'hanging_hurdle',
        '10': 'weighted_hanging_hurdle',
        '11': 'kneeling_lat_pulldown',
        '12': 'kneeling_underhand_grip_lat_pulldown',
        '13': 'lat_pulldown',
        '14': 'mixed_grip_chin_up',
        '15': 'weighted_mixed_grip_chin_up',
        '16': 'mixed_grip_pull_up',
        '17': 'weighted_mixed_grip_pull_up',
        '18': 'reverse_grip_pulldown',
        '19': 'standing_cable_pullover',
        '20': 'straight_arm_pulldown',
        '21': 'swiss_ball_ez_bar_pullover',
        '22': 'towel_pull_up',
        '23': 'weighted_towel_pull_up',
        '24': 'weighted_pull_up',
        '25': 'wide_grip_lat_pulldown',
        '26': 'wide_grip_pull_up',
        '27': 'weighted_wide_grip_pull_up',
        '28': 'burpee_pull_up',
        '29': 'weighted_burpee_pull_up',
        '30': 'jumping_pull_ups',
        '31': 'weighted_jumping_pull_ups',
        '32': 'kipping_pull_up',
        '33': 'weighted_kipping_pull_up',
        '34': 'l_pull_up',
        '35': 'weighted_l_pull_up',
        '36': 'suspended_chin_up',
        '37': 'weighted_suspended_chin_up',
        '38': 'pull_up',
        },
    'push_up_exercise_name': {
        '0': 'chest_press_with_band',
        '1': 'alternating_staggered_push_up',
        '2': 'weighted_alternating_staggered_push_up',
        '3': 'alternating_hands_medicine_ball_push_up',
        '4': 'weighted_alternating_hands_medicine_ball_push_up',
        '5': 'bosu_ball_push_up',
        '6': 'weighted_bosu_ball_push_up',
        '7': 'clapping_push_up',
        '8': 'weighted_clapping_push_up',
        '9': 'close_grip_medicine_ball_push_up',
        '10': 'weighted_close_grip_medicine_ball_push_up',
        '11': 'close_hands_push_up',
        '12': 'weighted_close_hands_push_up',
        '13': 'decline_push_up',
        '14': 'weighted_decline_push_up',
        '15': 'diamond_push_up',
        '16': 'weighted_diamond_push_up',
        '17': 'explosive_crossover_push_up',
        '18': 'weighted_explosive_crossover_push_up',
        '19': 'explosive_push_up',
        '20': 'weighted_explosive_push_up',
        '21': 'feet_elevated_side_to_side_push_up',
        '22': 'weighted_feet_elevated_side_to_side_push_up',
        '23': 'hand_release_push_up',
        '24': 'weighted_hand_release_push_up',
        '25': 'handstand_push_up',
        '26': 'weighted_handstand_push_up',
        '27': 'incline_push_up',
        '28': 'weighted_incline_push_up',
        '29': 'isometric_explosive_push_up',
        '30': 'weighted_isometric_explosive_push_up',
        '31': 'judo_push_up',
        '32': 'weighted_judo_push_up',
        '33': 'kneeling_push_up',
        '34': 'weighted_kneeling_push_up',
        '35': 'medicine_ball_chest_pass',
        '36': 'medicine_ball_push_up',
        '37': 'weighted_medicine_ball_push_up',
        '38': 'one_arm_push_up',
        '39': 'weighted_one_arm_push_up',
        '40': 'weighted_push_up',
        '41': 'push_up_and_row',
        '42': 'weighted_push_up_and_row',
        '43': 'push_up_plus',
        '44': 'weighted_push_up_plus',
        '45': 'push_up_with_feet_on_swiss_ball',
        '46': 'weighted_push_up_with_feet_on_swiss_ball',
        '47': 'push_up_with_one_hand_on_medicine_ball',
        '48': 'weighted_push_up_with_one_hand_on_medicine_ball',
        '49': 'shoulder_push_up',
        '50': 'weighted_shoulder_push_up',
        '51': 'single_arm_medicine_ball_push_up',
        '52': 'weighted_single_arm_medicine_ball_push_up',
        '53': 'spiderman_push_up',
        '54': 'weighted_spiderman_push_up',
        '55': 'stacked_feet_push_up',
        '56': 'weighted_stacked_feet_push_up',
        '57': 'staggered_hands_push_up',
        '58': 'weighted_staggered_hands_push_up',
        '59': 'suspended_push_up',
        '60': 'weighted_suspended_push_up',
        '61': 'swiss_ball_push_up',
        '62': 'weighted_swiss_ball_push_up',
        '63': 'swiss_ball_push_up_plus',
        '64': 'weighted_swiss_ball_push_up_plus',
        '65': 't_push_up',
        '66': 'weighted_t_push_up',
        '67': 'triple_stop_push_up',
        '68': 'weighted_triple_stop_push_up',
        '69': 'wide_hands_push_up',
        '70': 'weighted_wide_hands_push_up',
        '71': 'parallette_handstand_push_up',
        '72': 'weighted_parallette_handstand_push_up',
        '73': 'ring_handstand_push_up',
        '74': 'weighted_ring_handstand_push_up',
        '75': 'ring_push_up',
        '76': 'weighted_ring_push_up',
        '77': 'push_up',
        '78': 'pilates_pushup',
        },
    'row_exercise_name': {
        '0': 'barbell_straight_leg_deadlift_to_row',
        '1': 'cable_row_standing',
        '2': 'dumbbell_row',
        '3': 'elevated_feet_inverted_row',
        '4': 'weighted_elevated_feet_inverted_row',
        '5': 'face_pull',
        '6': 'face_pull_with_external_rotation',
        '7': 'inverted_row_with_feet_on_swiss_ball',
        '8': 'weighted_inverted_row_with_feet_on_swiss_ball',
        '9': 'kettlebell_row',
        '10': 'modified_inverted_row',
        '11': 'weighted_modified_inverted_row',
        '12': 'neutral_grip_alternating_dumbbell_row',
        '13': 'one_arm_bent_over_row',
        '14': 'one_legged_dumbbell_row',
        '15': 'renegade_row',
        '16': 'reverse_grip_barbell_row',
        '17': 'rope_handle_cable_row',
        '18': 'seated_cable_row',
        '19': 'seated_dumbbell_row',
        '20': 'single_arm_cable_row',
        '21': 'single_arm_cable_row_and_rotation',
        '22': 'single_arm_inverted_row',
        '23': 'weighted_single_arm_inverted_row',
        '24': 'single_arm_neutral_grip_dumbbell_row',
        '25': 'single_arm_neutral_grip_dumbbell_row_and_rotation',
        '26': 'suspended_inverted_row',
        '27': 'weighted_suspended_inverted_row',
        '28': 't_bar_row',
        '29': 'towel_grip_inverted_row',
        '30': 'weighted_towel_grip_inverted_row',
        '31': 'underhand_grip_cable_row',
        '32': 'v_grip_cable_row',
        '33': 'wide_grip_seated_cable_row',
        },
    'shoulder_press_exercise_name': {
        '0': 'alternating_dumbbell_shoulder_press',
        '1': 'arnold_press',
        '2': 'barbell_front_squat_to_push_press',
        '3': 'barbell_push_press',
        '4': 'barbell_shoulder_press',
        '5': 'dead_curl_press',
        '6': 'dumbbell_alternating_shoulder_press_and_twist',
        '7': 'dumbbell_hammer_curl_to_lunge_to_press',
        '8': 'dumbbell_push_press',
        '9': 'floor_inverted_shoulder_press',
        '10': 'weighted_floor_inverted_shoulder_press',
        '11': 'inverted_shoulder_press',
        '12': 'weighted_inverted_shoulder_press',
        '13': 'one_arm_push_press',
        '14': 'overhead_barbell_press',
        '15': 'overhead_dumbbell_press',
        '16': 'seated_barbell_shoulder_press',
        '17': 'seated_dumbbell_shoulder_press',
        '18': 'single_arm_dumbbell_shoulder_press',
        '19': 'single_arm_step_up_and_press',
        '20': 'smith_machine_overhead_press',
        '21': 'split_stance_hammer_curl_to_press',
        '22': 'swiss_ball_dumbbell_shoulder_press',
        '23': 'weight_plate_front_raise',
        },
    'shoulder_stability_exercise_name': {
        '0': '90_degree_cable_external_rotation',
        '1': 'band_external_rotation',
        '2': 'band_internal_rotation',
        '3': 'bent_arm_lateral_raise_and_external_rotation',
        '4': 'cable_external_rotation',
        '5': 'dumbbell_face_pull_with_external_rotation',
        '6': 'floor_i_raise',
        '7': 'weighted_floor_i_raise',
        '8': 'floor_t_raise',
        '9': 'weighted_floor_t_raise',
        '10': 'floor_y_raise',
        '11': 'weighted_floor_y_raise',
        '12': 'incline_i_raise',
        '13': 'weighted_incline_i_raise',
        '14': 'incline_l_raise',
        '15': 'weighted_incline_l_raise',
        '16': 'incline_t_raise',
        '17': 'weighted_incline_t_raise',
        '18': 'incline_w_raise',
        '19': 'weighted_incline_w_raise',
        '20': 'incline_y_raise',
        '21': 'weighted_incline_y_raise',
        '22': 'lying_external_rotation',
        '23': 'seated_dumbbell_external_rotation',
        '24': 'standing_l_raise',
        '25': 'swiss_ball_i_raise',
        '26': 'weighted_swiss_ball_i_raise',
        '27': 'swiss_ball_t_raise',
        '28': 'weighted_swiss_ball_t_raise',
        '29': 'swiss_ball_w_raise',
        '30': 'weighted_swiss_ball_w_raise',
        '31': 'swiss_ball_y_raise',
        '32': 'weighted_swiss_ball_y_raise',
        },
    'shrug_exercise_name': {
        '0': 'barbell_jump_shrug',
        '1': 'barbell_shrug',
        '2': 'barbell_upright_row',
        '3': 'behind_the_back_smith_machine_shrug',
        '4': 'dumbbell_jump_shrug',
        '5': 'dumbbell_shrug',
        '6': 'dumbbell_upright_row',
        '7': 'incline_dumbbell_shrug',
        '8': 'overhead_barbell_shrug',
        '9': 'overhead_dumbbell_shrug',
        '10': 'scaption_and_shrug',
        '11': 'scapular_retraction',
        '12': 'serratus_chair_shrug',
        '13': 'weighted_serratus_chair_shrug',
        '14': 'serratus_shrug',
        '15': 'weighted_serratus_shrug',
        '16': 'wide_grip_jump_shrug',
        },
    'sit_up_exercise_name': {
        '0': 'alternating_sit_up',
        '1': 'weighted_alternating_sit_up',
        '2': 'bent_knee_v_up',
        '3': 'weighted_bent_knee_v_up',
        '4': 'butterfly_sit_up',
        '5': 'weighted_butterfly_situp',
        '6': 'cross_punch_roll_up',
        '7': 'weighted_cross_punch_roll_up',
        '8': 'crossed_arms_sit_up',
        '9': 'weighted_crossed_arms_sit_up',
        '10': 'get_up_sit_up',
        '11': 'weighted_get_up_sit_up',
        '12': 'hovering_sit_up',
        '13': 'weighted_hovering_sit_up',
        '14': 'kettlebell_sit_up',
        '15': 'medicine_ball_alternating_v_up',
        '16': 'medicine_ball_sit_up',
        '17': 'medicine_ball_v_up',
        '18': 'modified_sit_up',
        '19': 'negative_sit_up',
        '20': 'one_arm_full_sit_up',
        '21': 'reclining_circle',
        '22': 'weighted_reclining_circle',
        '23': 'reverse_curl_up',
        '24': 'weighted_reverse_curl_up',
        '25': 'single_leg_swiss_ball_jackknife',
        '26': 'weighted_single_leg_swiss_ball_jackknife',
        '27': 'the_teaser',
        '28': 'the_teaser_weighted',
        '29': 'three_part_roll_down',
        '30': 'weighted_three_part_roll_down',
        '31': 'v_up',
        '32': 'weighted_v_up',
        '33': 'weighted_russian_twist_on_swiss_ball',
        '34': 'weighted_sit_up',
        '35': 'x_abs',
        '36': 'weighted_x_abs',
        '37': 'sit_up',
        },
    'squat_exercise_name': {
        '0': 'leg_press',
        '1': 'back_squat_with_body_bar',
        '2': 'back_squats',
        '3': 'weighted_back_squats',
        '4': 'balancing_squat',
        '5': 'weighted_balancing_squat',
        '6': 'barbell_back_squat',
        '7': 'barbell_box_squat',
        '8': 'barbell_front_squat',
        '9': 'barbell_hack_squat',
        '10': 'barbell_hang_squat_snatch',
        '11': 'barbell_lateral_step_up',
        '12': 'barbell_quarter_squat',
        '13': 'barbell_siff_squat',
        '14': 'barbell_squat_snatch',
        '15': 'barbell_squat_with_heels_raised',
        '16': 'barbell_stepover',
        '17': 'barbell_step_up',
        '18': 'bench_squat_with_rotational_chop',
        '19': 'weighted_bench_squat_with_rotational_chop',
        '20': 'body_weight_wall_squat',
        '21': 'weighted_wall_squat',
        '22': 'box_step_squat',
        '23': 'weighted_box_step_squat',
        '24': 'braced_squat',
        '25': 'crossed_arm_barbell_front_squat',
        '26': 'crossover_dumbbell_step_up',
        '27': 'dumbbell_front_squat',
        '28': 'dumbbell_split_squat',
        '29': 'dumbbell_squat',
        '30': 'dumbbell_squat_clean',
        '31': 'dumbbell_stepover',
        '32': 'dumbbell_step_up',
        '33': 'elevated_single_leg_squat',
        '34': 'weighted_elevated_single_leg_squat',
        '35': 'figure_four_squats',
        '36': 'weighted_figure_four_squats',
        '37': 'goblet_squat',
        '38': 'kettlebell_squat',
        '39': 'kettlebell_swing_overhead',
        '40': 'kettlebell_swing_with_flip_to_squat',
        '41': 'lateral_dumbbell_step_up',
        '42': 'one_legged_squat',
        '43': 'overhead_dumbbell_squat',
        '44': 'overhead_squat',
        '45': 'partial_single_leg_squat',
        '46': 'weighted_partial_single_leg_squat',
        '47': 'pistol_squat',
        '48': 'weighted_pistol_squat',
        '49': 'plie_slides',
        '50': 'weighted_plie_slides',
        '51': 'plie_squat',
        '52': 'weighted_plie_squat',
        '53': 'prisoner_squat',
        '54': 'weighted_prisoner_squat',
        '55': 'single_leg_bench_get_up',
        '56': 'weighted_single_leg_bench_get_up',
        '57': 'single_leg_bench_squat',
        '58': 'weighted_single_leg_bench_squat',
        '59': 'single_leg_squat_on_swiss_ball',
        '60': 'weighted_single_leg_squat_on_swiss_ball',
        '61': 'squat',
        '62': 'weighted_squat',
        '63': 'squats_with_band',
        '64': 'staggered_squat',
        '65': 'weighted_staggered_squat',
        '66': 'step_up',
        '67': 'weighted_step_up',
        '68': 'suitcase_squats',
        '69': 'sumo_squat',
        '70': 'sumo_squat_slide_in',
        '71': 'weighted_sumo_squat_slide_in',
        '72': 'sumo_squat_to_high_pull',
        '73': 'sumo_squat_to_stand',
        '74': 'weighted_sumo_squat_to_stand',
        '75': 'sumo_squat_with_rotation',
        '76': 'weighted_sumo_squat_with_rotation',
        '77': 'swiss_ball_body_weight_wall_squat',
        '78': 'weighted_swiss_ball_wall_squat',
        '79': 'thrusters',
        '80': 'uneven_squat',
        '81': 'weighted_uneven_squat',
        '82': 'waist_slimming_squat',
        '83': 'wall_ball',
        '84': 'wide_stance_barbell_squat',
        '85': 'wide_stance_goblet_squat',
        '86': 'zercher_squat',
        '87': 'kbs_overhead', # Deprecated do not use
        '88': 'squat_and_side_kick',
        '89': 'squat_jumps_in_n_out',
        '90': 'pilates_plie_squats_parallel_turned_out_flat_and_heels',
        '91': 'releve_straight_leg_and_knee_bent_with_one_leg_variation',
        },
    'total_body_exercise_name': {
        '0': 'burpee',
        '1': 'weighted_burpee',
        '2': 'burpee_box_jump',
        '3': 'weighted_burpee_box_jump',
        '4': 'high_pull_burpee',
        '5': 'man_makers',
        '6': 'one_arm_burpee',
        '7': 'squat_thrusts',
        '8': 'weighted_squat_thrusts',
        '9': 'squat_plank_push_up',
        '10': 'weighted_squat_plank_push_up',
        '11': 'standing_t_rotation_balance',
        '12': 'weighted_standing_t_rotation_balance',
        },
    'triceps_extension_exercise_name': {
        '0': 'bench_dip',
        '1': 'weighted_bench_dip',
        '2': 'body_weight_dip',
        '3': 'cable_kickback',
        '4': 'cable_lying_triceps_extension',
        '5': 'cable_overhead_triceps_extension',
        '6': 'dumbbell_kickback',
        '7': 'dumbbell_lying_triceps_extension',
        '8': 'ez_bar_overhead_triceps_extension',
        '9': 'incline_dip',
        '10': 'weighted_incline_dip',
        '11': 'incline_ez_bar_lying_triceps_extension',
        '12': 'lying_dumbbell_pullover_to_extension',
        '13': 'lying_ez_bar_triceps_extension',
        '14': 'lying_triceps_extension_to_close_grip_bench_press',
        '15': 'overhead_dumbbell_triceps_extension',
        '16': 'reclining_triceps_press',
        '17': 'reverse_grip_pressdown',
        '18': 'reverse_grip_triceps_pressdown',
        '19': 'rope_pressdown',
        '20': 'seated_barbell_overhead_triceps_extension',
        '21': 'seated_dumbbell_overhead_triceps_extension',
        '22': 'seated_ez_bar_overhead_triceps_extension',
        '23': 'seated_single_arm_overhead_dumbbell_extension',
        '24': 'single_arm_dumbbell_overhead_triceps_extension',
        '25': 'single_dumbbell_seated_overhead_triceps_extension',
        '26': 'single_leg_bench_dip_and_kick',
        '27': 'weighted_single_leg_bench_dip_and_kick',
        '28': 'single_leg_dip',
        '29': 'weighted_single_leg_dip',
        '30': 'static_lying_triceps_extension',
        '31': 'suspended_dip',
        '32': 'weighted_suspended_dip',
        '33': 'swiss_ball_dumbbell_lying_triceps_extension',
        '34': 'swiss_ball_ez_bar_lying_triceps_extension',
        '35': 'swiss_ball_ez_bar_overhead_triceps_extension',
        '36': 'tabletop_dip',
        '37': 'weighted_tabletop_dip',
        '38': 'triceps_extension_on_floor',
        '39': 'triceps_pressdown',
        '40': 'weighted_dip',
        },
    'warm_up_exercise_name': {
        '0': 'quadruped_rocking',
        '1': 'neck_tilts',
        '2': 'ankle_circles',
        '3': 'ankle_dorsiflexion_with_band',
        '4': 'ankle_internal_rotation',
        '5': 'arm_circles',
        '6': 'bent_over_reach_to_sky',
        '7': 'cat_camel',
        '8': 'elbow_to_foot_lunge',
        '9': 'forward_and_backward_leg_swings',
        '10': 'groiners',
        '11': 'inverted_hamstring_stretch',
        '12': 'lateral_duck_under',
        '13': 'neck_rotations',
        '14': 'opposite_arm_and_leg_balance',
        '15': 'reach_roll_and_lift',
        '16': 'scorpion', # Deprecated do not use
        '17': 'shoulder_circles',
        '18': 'side_to_side_leg_swings',
        '19': 'sleeper_stretch',
        '20': 'slide_out',
        '21': 'swiss_ball_hip_crossover',
        '22': 'swiss_ball_reach_roll_and_lift',
        '23': 'swiss_ball_windshield_wipers',
        '24': 'thoracic_rotation',
        '25': 'walking_high_kicks',
        '26': 'walking_high_knees',
        '27': 'walking_knee_hugs',
        '28': 'walking_leg_cradles',
        '29': 'walkout',
        '30': 'walkout_from_push_up_position',
        },
    'run_exercise_name': {
        '0': 'run',
        '1': 'walk',
        '2': 'jog',
        '3': 'sprint',
        },
    'water_type': {
        '0': 'fresh',
        '1': 'salt',
        '2': 'en13319',
        '3': 'custom',
        },
    'tissue_model_type': {
        '0': 'zhl_16c', # Buhlmann's decompression algorithm, version C
        },
    'dive_gas_status': {
        '0': 'disabled',
        '1': 'enabled',
        '2': 'backup_only',
        },
    'dive_alert': {
        '0': 'ndl_reached',
        '1': 'gas_switch_prompted',
        '2': 'near_surface',
        '3': 'approaching_ndl',
        '4': 'po2_warn',
        '5': 'po2_crit_high',
        '6': 'po2_crit_low',
        '7': 'time_alert',
        '8': 'depth_alert',
        '9': 'deco_ceiling_broken',
        '10': 'deco_complete',
        '11': 'safety_stop_broken',
        '12': 'safety_stop_complete',
        '13': 'cns_warning',
        '14': 'cns_critical',
        '15': 'otu_warning',
        '16': 'otu_critical',
        '17': 'ascent_critical',
        '18': 'alert_dismissed_by_key',
        '19': 'alert_dismissed_by_timeout',
        '20': 'battery_low',
        '21': 'battery_critical',
        '22': 'safety_stop_started',
        '23': 'approaching_first_deco_stop',
        '24': 'setpoint_switch_auto_low',
        '25': 'setpoint_switch_auto_high',
        '26': 'setpoint_switch_manual_low',
        '27': 'setpoint_switch_manual_high',
        '28': 'auto_setpoint_switch_ignored',
        '29': 'switched_to_open_circuit',
        '30': 'switched_to_closed_circuit',
        '32': 'tank_battery_low',
        '33': 'po2_ccr_dil_low', # ccr diluent has low po2
        '34': 'deco_stop_cleared', # a deco stop has been cleared
        '35': 'apnea_neutral_buoyancy', # Target Depth Apnea Alarm triggered
        '36': 'apnea_target_depth', # Neutral Buoyance Apnea Alarm triggered
        '37': 'apnea_surface', # Surface Apnea Alarm triggered
        '38': 'apnea_high_speed', # High Speed Apnea Alarm triggered
        '39': 'apnea_low_speed', # Low Speed Apnea Alarm triggered
        },
    'dive_alarm_type': {
        '0': 'depth', # Alarm when a certain depth is crossed
        '1': 'time', # Alarm when a certain time has transpired
        '2': 'speed', # Alarm when a certain ascent or descent rate is exceeded
        },
    'dive_backlight_mode': {
        '0': 'at_depth',
        '1': 'always_on',
        },
    'sleep_level': {
        '0': 'unmeasurable',
        '1': 'awake',
        '2': 'light',
        '3': 'deep',
        '4': 'rem',
        },
    'spo2_measurement_type': {
        '0': 'off_wrist',
        '1': 'spot_check',
        '2': 'continuous_check',
        '3': 'periodic',
        },
    'ccr_setpoint_switch_mode': {
        '0': 'manual', # User switches setpoints manually
        '1': 'automatic', # Switch automatically based on depth
        },
    'dive_gas_mode': {
        '0': 'open_circuit',
        '1': 'closed_circuit_diluent',
        },
    'projectile_type': {
        '0': 'arrow', # Arrow projectile type
        '1': 'rifle_cartridge', # Rifle cartridge projectile type
        '2': 'pistol_cartridge', # Pistol cartridge projectile type
        '3': 'shotshell', # Shotshell projectile type
        '4': 'air_rifle_pellet', # Air rifle pellet projectile type
        '5': 'other', # Other projectile type
        },
    'favero_product': {
        '10': 'assioma_uno',
        '12': 'assioma_duo',
        },
    'split_type': {
        '1': 'ascent_split',
        '2': 'descent_split',
        '3': 'interval_active',
        '4': 'interval_rest',
        '5': 'interval_warmup',
        '6': 'interval_cooldown',
        '7': 'interval_recovery',
        '8': 'interval_other',
        '9': 'climb_active',
        '10': 'climb_rest',
        '11': 'surf_active',
        '12': 'run_active',
        '13': 'run_rest',
        '14': 'workout_round',
        '17': 'rwd_run', # run/walk detection running
        '18': 'rwd_walk', # run/walk detection walking
        '21': 'windsurf_active',
        '22': 'rwd_stand', # run/walk detection standing
        '23': 'transition', # Marks the time going from ascent_split to descent_split/used in backcountry ski
        '28': 'ski_lift_split',
        '29': 'ski_run_split',
        },
    'climb_pro_event': {
        '0': 'approach',
        '1': 'start',
        '2': 'complete',
        },
    'gas_consumption_rate_type': {
        '0': 'pressure_sac', # Pressure-based Surface Air Consumption
        '1': 'volume_sac', # Volumetric Surface Air Consumption
        '2': 'rmv', # Respiratory Minute Volume
        },
    'tap_sensitivity': {
        '0': 'high',
        '1': 'medium',
        '2': 'low',
        },
    'radar_threat_level_type': {
        '0': 'threat_unknown',
        '1': 'threat_none',
        '2': 'threat_approaching',
        '3': 'threat_approaching_fast',
        },
    'max_met_speed_source': {
        '0': 'onboard_gps',
        '1': 'connected_gps',
        '2': 'cadence',
        },
    'max_met_heart_rate_source': {
        '0': 'whr', # Wrist Heart Rate Monitor
        '1': 'hrm', # Chest Strap Heart Rate Monitor
        },
    'hrv_status': {
        '0': 'none',
        '1': 'poor',
        '2': 'low',
        '3': 'unbalanced',
        '4': 'balanced',
        },
    'no_fly_time_mode': {
        '0': 'standard', # Standard Diver Alert Network no-fly guidance
        '1': 'flat_24_hours', # Flat 24 hour no-fly guidance
        },
        },
    'mesg_num' : {
        'FILE_ID': 0,
        'FILE_CREATOR': 49,
        'TIMESTAMP_CORRELATION': 162,
        'SOFTWARE': 35,
        'SLAVE_DEVICE': 106,
        'CAPABILITIES': 1,
        'FILE_CAPABILITIES': 37,
        'MESG_CAPABILITIES': 38,
        'FIELD_CAPABILITIES': 39,
        'DEVICE_SETTINGS': 2,
        'USER_PROFILE': 3,
        'HRM_PROFILE': 4,
        'SDM_PROFILE': 5,
        'BIKE_PROFILE': 6,
        'CONNECTIVITY': 127,
        'WATCHFACE_SETTINGS': 159,
        'OHR_SETTINGS': 188,
        'TIME_IN_ZONE': 216,
        'ZONES_TARGET': 7,
        'SPORT': 12,
        'HR_ZONE': 8,
        'SPEED_ZONE': 53,
        'CADENCE_ZONE': 131,
        'POWER_ZONE': 9,
        'MET_ZONE': 10,
        'DIVE_SETTINGS': 258,
        'DIVE_ALARM': 262,
        'DIVE_APNEA_ALARM': 393,
        'DIVE_GAS': 259,
        'GOAL': 15,
        'ACTIVITY': 34,
        'SESSION': 18,
        'LAP': 19,
        'LENGTH': 101,
        'RECORD': 20,
        'EVENT': 21,
        'DEVICE_INFO': 23,
        'DEVICE_AUX_BATTERY_INFO': 375,
        'TRAINING_FILE': 72,
        'WEATHER_CONDITIONS': 128,
        'WEATHER_ALERT': 129,
        'GPS_METADATA': 160,
        'CAMERA_EVENT': 161,
        'GYROSCOPE_DATA': 164,
        'ACCELEROMETER_DATA': 165,
        'MAGNETOMETER_DATA': 208,
        'BAROMETER_DATA': 209,
        'THREE_D_SENSOR_CALIBRATION': 167,
        'ONE_D_SENSOR_CALIBRATION': 210,
        'VIDEO_FRAME': 169,
        'OBDII_DATA': 174,
        'NMEA_SENTENCE': 177,
        'AVIATION_ATTITUDE': 178,
        'VIDEO': 184,
        'VIDEO_TITLE': 185,
        'VIDEO_DESCRIPTION': 186,
        'VIDEO_CLIP': 187,
        'SET': 225,
        'JUMP': 285,
        'SPLIT': 312,
        'SPLIT_SUMMARY': 313,
        'CLIMB_PRO': 317,
        'FIELD_DESCRIPTION': 206,
        'DEVELOPER_DATA_ID': 207,
        'COURSE': 31,
        'COURSE_POINT': 32,
        'SEGMENT_ID': 148,
        'SEGMENT_LEADERBOARD_ENTRY': 149,
        'SEGMENT_POINT': 150,
        'SEGMENT_LAP': 142,
        'SEGMENT_FILE': 151,
        'WORKOUT': 26,
        'WORKOUT_SESSION': 158,
        'WORKOUT_STEP': 27,
        'EXERCISE_TITLE': 264,
        'SCHEDULE': 28,
        'TOTALS': 33,
        'WEIGHT_SCALE': 30,
        'BLOOD_PRESSURE': 51,
        'MONITORING_INFO': 103,
        'MONITORING': 55,
        'MONITORING_HR_DATA': 211,
        'SPO2_DATA': 269,
        'HR': 132,
        'STRESS_LEVEL': 227,
        'MAX_MET_DATA': 229,
        'HSA_BODY_BATTERY_DATA': 314,
        'HSA_EVENT': 315,
        'HSA_ACCELEROMETER_DATA': 302,
        'HSA_GYROSCOPE_DATA': 376,
        'HSA_STEP_DATA': 304,
        'HSA_SPO2_DATA': 305,
        'HSA_STRESS_DATA': 306,
        'HSA_RESPIRATION_DATA': 307,
        'HSA_HEART_RATE_DATA': 308,
        'HSA_CONFIGURATION_DATA': 389,
        'HSA_WRIST_TEMPERATURE_DATA': 409,
        'MEMO_GLOB': 145,
        'SLEEP_LEVEL': 275,
        'ANT_CHANNEL_ID': 82,
        'ANT_RX': 80,
        'ANT_TX': 81,
        'EXD_SCREEN_CONFIGURATION': 200,
        'EXD_DATA_FIELD_CONFIGURATION': 201,
        'EXD_DATA_CONCEPT_CONFIGURATION': 202,
        'DIVE_SUMMARY': 268,
        'AAD_ACCEL_FEATURES': 289,
        'HRV': 78,
        'BEAT_INTERVALS': 290,
        'HRV_STATUS_SUMMARY': 370,
        'HRV_VALUE': 371,
        'RAW_BBI': 372,
        'RESPIRATION_RATE': 297,
        'CHRONO_SHOT_SESSION': 387,
        'CHRONO_SHOT_DATA': 388,
        'TANK_UPDATE': 319,
        'TANK_SUMMARY': 323,
        'SLEEP_ASSESSMENT': 346,
        'SKIN_TEMP_OVERNIGHT': 398,
        'PAD': 105,
    }
}
