'''accumulator.py: Contains the Accumulator class and sub-component class AccumulatedField'''

###########################################################################################
# Copyright 2024 Garmin International, Inc.
# Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
# may not use this file except in compliance with the Flexible and Interoperable Data
# Transfer (FIT) Protocol License.
###########################################################################################
# ****WARNING****  This file is auto-generated!  Do NOT edit this file.
# Profile Version = 21.158.0Release
# Tag = production/release/21.158.0-0-gc9428aa
############################################################################################


class AccumulatedField:
    '''A class that accumulates a value for a particular field.
        Attributes:
            _accumulated_value: Resulting accumulated value
            _last_value: The previous accumulated value thus far.
    '''
    def __init__(self, value = 0):
        self._accumulated_value = value
        self._last_value = value

    def accumulate(self, value, bits):
        ''''Accumulates to the previous value and gives the updated accumulated value.'''
        mask = (1 << bits) - 1

        self._accumulated_value += (value - self._last_value) & mask
        self._last_value = value

        return self._accumulated_value

class Accumulator:
    '''A class that represents the accumulated values for particular fields.
        Attributes:
            _messages: A list of messages with a field or fields to accumulate.
    '''
    def __init__(self):
        self._messages = {}

    def createAccumulatedField(self, mesg_num, field_num, value):
        '''Creates an accumulated field and stores its initial value in the accumulator'''
        accumulatedField = AccumulatedField(value)

        if mesg_num not in self._messages:
            self._messages[mesg_num] = {}

        self._messages[mesg_num][field_num] = accumulatedField
        
        return accumulatedField

    def accumulate(self, mesg_num, field_num, value, bits):
        '''Accumulates the given field value if present in the accumulator. If it is not, the accumulated field is added to the Accumulator.'''
        accumulatedField = None 

        if mesg_num in self._messages and field_num in self._messages[mesg_num]:
            accumulatedField = self._messages[mesg_num][field_num]
        else:
            accumulatedField = self.createAccumulatedField(mesg_num, field_num, value)

        return accumulatedField.accumulate(value, bits)

