# Generated by Django 1.11.1 on 2017-06-18 12:17

import django.db.models.deletion
import imagefield.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="File",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "image_file",
                    imagefield.fields.ImageField(
                        blank=True,
                        height_field="image_height",
                        upload_to="cabinet/%Y/%m",
                        verbose_name="image",
                        width_field="image_width",
                    ),
                ),
                (
                    "image_width",
                    models.PositiveIntegerField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="image width",
                    ),
                ),
                (
                    "image_height",
                    models.PositiveIntegerField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="image height",
                    ),
                ),
                (
                    "image_ppoi",
                    imagefield.fields.PPOIField(
                        default="0.5x0.5",
                        max_length=20,
                        verbose_name="primary point of interest",
                    ),
                ),
                (
                    "download_file",
                    models.FileField(
                        blank=True, upload_to="cabinet/%Y/%m", verbose_name="download"
                    ),
                ),
                (
                    "download_type",
                    models.CharField(
                        editable=False, max_length=20, verbose_name="download type"
                    ),
                ),
                (
                    "file_name",
                    models.CharField(max_length=1000, verbose_name="file name"),
                ),
                ("file_size", models.PositiveIntegerField(verbose_name="file size")),
            ],
            options={
                "abstract": False,
                "verbose_name": "file",
                "verbose_name_plural": "files",
                "ordering": ["file_name"],
                "swappable": "CABINET_FILE_MODEL",
            },
        ),
        migrations.CreateModel(
            name="Folder",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, verbose_name="name")),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="cabinet.Folder",
                        verbose_name="parent",
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
                "verbose_name": "folder",
                "verbose_name_plural": "folders",
            },
        ),
        migrations.AddField(
            model_name="file",
            name="folder",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="files",
                to="cabinet.Folder",
                verbose_name="folder",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="folder", unique_together={("parent", "name")}
        ),
    ]
