"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Laravel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const efs = require("@aws-cdk/aws-efs");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
/**
 * Represents the Laravel service.
 *
 * @stability stable
 */
class Laravel extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this.vpc = (_b = props.vpc) !== null && _b !== void 0 ? _b : getOrCreateVpc(this);
        this.db = this.addDatabase({
            vpc: this.vpc,
            databaseSubnets: props.databaseSubnets,
            instanceType: props.databaseInstanceType,
            instanceEngine: props.instanceEngine,
            clusterEngine: props.clusterEngine,
            auroraServerless: props.auroraServerless,
            singleDbInstance: props.singleDbInstance,
            backupRetention: props.backupRetention,
            defaultDatabaseName: props.defaultDatabaseName,
        });
        const logGroup = new logs.LogGroup(this, 'LogGroup', {
            retention: logs.RetentionDays.ONE_MONTH,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
        const task = new ecs.FargateTaskDefinition(this, 'Task', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        task.addContainer('Laravel', {
            image: ecs.ContainerImage.fromAsset(props.code),
            portMappings: [{ containerPort: (_c = props.containerPort) !== null && _c !== void 0 ? _c : 80 }],
            environment: {
                Laravel_DB_NAME: 'Laravel',
            },
            logging: new ecs.AwsLogDriver({
                streamPrefix: 'Laravel-fargate',
                logGroup,
            }),
            secrets: {
                LARAVEL_DB_HOST: ecs.Secret.fromSecretsManager(this.db.secret, 'host'),
                LARAVEL_DB_USER: ecs.Secret.fromSecretsManager(this.db.secret, 'username'),
                LARAVEL_DB_PASSWORD: ecs.Secret.fromSecretsManager(this.db.secret, 'password'),
            },
        });
        const healthCheck = {
            path: '/',
            interval: cdk.Duration.minutes(1),
        };
        this.svc = new _1.DualAlbFargateService(this, 'ALBFargateService', {
            vpc: this.vpc,
            spot: props.spot,
            enableExecuteCommand: props.enableExecuteCommand,
            tasks: props.serviceProps ? [props.serviceProps] : [
                {
                    external: props.loadbalancer,
                    task,
                    healthCheck,
                },
            ],
            route53Ops: { enableLoadBalancerAlias: false },
        });
        if (props.efsFileSystem) {
            // EFS volume
            const filesystem = new efs.FileSystem(this, 'FileSystem', props.efsFileSystem);
            const volumeName = 'efs';
            this.svc.service[0].taskDefinition.addVolume({
                name: volumeName,
                efsVolumeConfiguration: {
                    fileSystemId: filesystem.fileSystemId,
                },
            });
            // fix me - tentatively mount to /efsmount
            (_d = this.svc.service[0].taskDefinition.defaultContainer) === null || _d === void 0 ? void 0 : _d.addMountPoints({
                containerPath: '/efsmount',
                readOnly: false,
                sourceVolume: volumeName,
            });
            filesystem.connections.allowFrom(new ec2.Connections({ securityGroups: this.svc.service[0].connections.securityGroups }), ec2.Port.tcp(2049), 'allow Laravel to connect to efs filesystem');
        }
        this.db.connections.allowFrom(this.svc.service[0], this.db.connections.defaultPort, `allow ${this.svc.service[0].serviceName} to connect to database`);
    }
    addDatabase(props) {
        return new _1.Database(this, 'Database', {
            ...props,
        });
    }
}
exports.Laravel = Laravel;
_a = JSII_RTTI_SYMBOL_1;
Laravel[_a] = { fqn: "cdk-fargate-patterns.Laravel", version: "0.2.10" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1'
        || process.env.CDK_USE_DEFAULT_VPC === '1' ? ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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