# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeyPairResult',
    'AwaitableGetKeyPairResult',
    'get_key_pair',
    'get_key_pair_output',
]

@pulumi.output_type
class GetKeyPairResult:
    def __init__(__self__, key_fingerprint=None, key_pair_id=None, public_key_material=None, tags=None):
        if key_fingerprint and not isinstance(key_fingerprint, str):
            raise TypeError("Expected argument 'key_fingerprint' to be a str")
        pulumi.set(__self__, "key_fingerprint", key_fingerprint)
        if key_pair_id and not isinstance(key_pair_id, str):
            raise TypeError("Expected argument 'key_pair_id' to be a str")
        pulumi.set(__self__, "key_pair_id", key_pair_id)
        if public_key_material and not isinstance(public_key_material, str):
            raise TypeError("Expected argument 'public_key_material' to be a str")
        pulumi.set(__self__, "public_key_material", public_key_material)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> Optional[str]:
        """
        A short sequence of bytes used for public key verification
        """
        return pulumi.get(self, "key_fingerprint")

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> Optional[str]:
        """
        An AWS generated ID for the key pair
        """
        return pulumi.get(self, "key_pair_id")

    @property
    @pulumi.getter(name="publicKeyMaterial")
    def public_key_material(self) -> Optional[str]:
        """
        Plain text public key to import
        """
        return pulumi.get(self, "public_key_material")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.KeyPairTag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetKeyPairResult(GetKeyPairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyPairResult(
            key_fingerprint=self.key_fingerprint,
            key_pair_id=self.key_pair_id,
            public_key_material=self.public_key_material,
            tags=self.tags)


def get_key_pair(key_name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyPairResult:
    """
    The AWS::EC2::KeyPair creates an SSH key pair


    :param str key_name: The name of the SSH key pair
    """
    __args__ = dict()
    __args__['keyName'] = key_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult).value

    return AwaitableGetKeyPairResult(
        key_fingerprint=__ret__.key_fingerprint,
        key_pair_id=__ret__.key_pair_id,
        public_key_material=__ret__.public_key_material,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_key_pair)
def get_key_pair_output(key_name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeyPairResult]:
    """
    The AWS::EC2::KeyPair creates an SSH key pair


    :param str key_name: The name of the SSH key pair
    """
    ...
