# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    def __init__(__self__, connection_arn=None, connection_status=None, owner_account_id=None, tags=None):
        if connection_arn and not isinstance(connection_arn, str):
            raise TypeError("Expected argument 'connection_arn' to be a str")
        pulumi.set(__self__, "connection_arn", connection_arn)
        if connection_status and not isinstance(connection_status, str):
            raise TypeError("Expected argument 'connection_status' to be a str")
        pulumi.set(__self__, "connection_status", connection_status)
        if owner_account_id and not isinstance(owner_account_id, str):
            raise TypeError("Expected argument 'owner_account_id' to be a str")
        pulumi.set(__self__, "owner_account_id", owner_account_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectionArn")
    def connection_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the  connection. The ARN is used as the connection reference when the connection is shared between AWS services.
        """
        return pulumi.get(self, "connection_arn")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[str]:
        """
        The current status of the connection.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[str]:
        """
        The name of the external provider where your third-party code repository is configured. For Bitbucket, this is the account ID of the owner of the Bitbucket repository.
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ConnectionTag']]:
        """
        Specifies the tags applied to a connection.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            connection_arn=self.connection_arn,
            connection_status=self.connection_status,
            owner_account_id=self.owner_account_id,
            tags=self.tags)


def get_connection(connection_arn: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    Schema for AWS::CodeStarConnections::Connection resource which can be used to connect external source providers with AWS CodePipeline


    :param str connection_arn: The Amazon Resource Name (ARN) of the  connection. The ARN is used as the connection reference when the connection is shared between AWS services.
    """
    __args__ = dict()
    __args__['connectionArn'] = connection_arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:codestarconnections:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        connection_arn=__ret__.connection_arn,
        connection_status=__ret__.connection_status,
        owner_account_id=__ret__.owner_account_id,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_connection)
def get_connection_output(connection_arn: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionResult]:
    """
    Schema for AWS::CodeStarConnections::Connection resource which can be used to connect external source providers with AWS CodePipeline


    :param str connection_arn: The Amazon Resource Name (ARN) of the  connection. The ARN is used as the connection reference when the connection is shared between AWS services.
    """
    ...
